/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing.file_chooser;

import com.qarks.util.ui.swing.ISortableObject;
import java.io.File;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;

public class FileInfos
implements ISortableObject {
    private String mName = "";
    private Long mFileSize = new Long(0L);
    private Icon mIcon = null;
    private File mFile = null;
    private FileSystemView mFileSystemView = FileSystemView.getFileSystemView();
    private FileView mFileView = null;

    public FileInfos(FileView fileView, File file) {
        this.mFileView = fileView;
        this.mIcon = fileView.getIcon(file);
        this.mName = file.isDirectory() || this.mFileSystemView.isComputerNode(file) ? this.mFileSystemView.getSystemDisplayName(file) : fileView.getName(file);
        this.mFile = file;
        this.mFileSize = !this.mFileSystemView.isDrive(file) && file.isFile() ? new Long(file.length()) : new Long(0L);
    }

    public Long getLength() {
        return this.mFileSize;
    }

    public Icon getIcon() {
        return this.mIcon;
    }

    public String getName() {
        return this.mName;
    }

    @Override
    public int comparesTo(Object object) {
        int n = 0;
        if (object instanceof FileInfos) {
            FileInfos fileInfos = (FileInfos)object;
            if (this.mFile.isDirectory()) {
                n = !fileInfos.getFile().isDirectory() ? -1 : this.compareName(fileInfos.getFile());
            } else if (fileInfos.getFile().isDirectory()) {
                if (!this.mFile.isDirectory()) {
                    return 1;
                }
                n = this.compareName(fileInfos.getFile());
            } else {
                n = this.compareName(fileInfos.getFile());
            }
        }
        return n;
    }

    private int compareName(File file) {
        String string;
        int n = 0;
        String string2 = this.mFile.getName().toLowerCase();
        int n2 = string2.compareTo(string = file.getName().toLowerCase());
        n = n2 < 0 ? -1 : (n2 > 0 ? 1 : 0);
        return n;
    }

    public File getFile() {
        return this.mFile;
    }
}

