/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify;

import cc.mallet.classify.Classification;
import cc.mallet.classify.Classifier;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.LabelVector;

public class Winnow
extends Classifier {
    double[][] weights;
    double theta;

    public Winnow(Pipe dataPipe, double[][] newWeights, double theta, int idim, int jdim) {
        super(dataPipe);
        this.theta = theta;
        this.weights = new double[idim][jdim];
        for (int i = 0; i < idim; ++i) {
            for (int j = 0; j < jdim; ++j) {
                this.weights[i][j] = newWeights[i][j];
            }
        }
    }

    @Override
    public Classification classify(Instance instance) {
        int numClasses = this.getLabelAlphabet().size();
        double[] scores = new double[numClasses];
        FeatureVector fv = (FeatureVector)instance.getData();
        assert (this.instancePipe == null || fv.getAlphabet() == this.instancePipe.getDataAlphabet());
        int fvisize = fv.numLocations();
        for (int fvi = 0; fvi < fvisize; ++fvi) {
            int fi = fv.indexAtLocation(fvi);
            for (int ci = 0; ci < numClasses; ++ci) {
                int n = ci;
                scores[n] = scores[n] + this.weights[ci][fi];
            }
        }
        return new Classification(instance, this, new LabelVector(this.getLabelAlphabet(), scores));
    }
}

