# Overview
Welcome to the IDC *NRBA App*, an interactive application that you can use to analyze survey data response rates, representativeness, and nonresponse bias. Use the IDC *NRBA App* to answer questions such as

- What are our response rates, and do they differ across subgroups?
- Are some subgroups in the population overrepresented or underrepresented in our respondent data?
- How do survey outcomes differ across subgroups?
- Can statistical adjustments reduce nonresponse bias in our data?

You can access the point-and-click interface of this tool through your web browser and run it using the open-source data analysis program, *RStudio*. The tool consists of three modules---Setup, Analysis, and Report. The sections below provide a broad overview of the functionality of each module.

### Setup: Load a Prepared Dataset into the Application

First, select and import a dataset to use for analysis (Step 1: Import). Once selected, the application will provide a summary of the rows and columns in the dataset, with a preview of the first few rows and columns of the dataset.

Note: IDC recommends using a dataset that includes one row for every person invited to submit a survey, regardless of whether that person ultimately responded. This is necessary for the calculation of key analyses.

Next, to properly analyze the data, indicate how you collected the data (Step 2: Identify the Data Collection Method). This includes identifying whether the data come from an attempted census or represent a survey sample, which variable indicates response/eligibility status for the survey, and other variables in the data related to the method of data collection. Once you have loaded and described the data in the Setup module, you can move to the Analysis module.


### Analysis: Select and Configure Specific Analyses to Run, and View the Results

This module allows you to select from a variety of analysis types to answer questions about response rate, representativeness, and nonresponse bias in your survey data. When you select an analysis type from the menu, a new Specify Analysis tab will appear with options for conducting the specific analysis. The application will recommend some of these selections as defaults. When you submit your options, a pop-up window will appear, showing a table with the resulting statistics for the analysis.

Once complete, you can add the analysis output to the Report module. You can then repeat the same analysis with a variety of options (e.g., calculating response rates separately by race, disability category, and grade) or select a different analysis type to run and then add to the report module.

Once you have finished adding your analyses, you can move to the Report module.


### Report: Export Output Tables Summarizing the Analyses to an Excel File

When you open the Report module, a list of the analyses you've added to the report will appear in the Items in Report display at the top. From this display, you can remove any items you decide no longer belong in the report and save the report by clicking Save to Excel.

### Additional Help Within the App

As you use the IDC *NRBA App*, be aware of additional instructions and help available within it. For example, each module of the IDC *NRBA App* includes written instructions that cover the steps outlined above. In addition, built-in screen tips provide more information and definitions of key terms. You can access these tips by hovering over the text within the app. If you are ready to begin using this tool, move to the Setup tab.

# For More Information

If you would like more detailed information on using the IDC *NRBA App*, including preparing and importing your dataset, understanding the statistical processes behind each analysis option, and interpreting the results of analyses, see the IDC *NRBA App* Reference Guide.
For a demonstration of the IDC *NRBA App* using a sample dataset, see [this short video.](https://www.youtube.com/watch?v=0em2O0-QGP8)

For technical assistance using this tool, please contact your IDC State Liaison or email IDEAdata@westat.com.
Please note that this tool is not 508 accessible. 
