/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.dialogs;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.datatable.DataTableModel;
import org.af.gMCP.gui.datatable.RDataFrameRef;
import org.af.gMCP.gui.datatable.SingleDataFramePanel;
import org.af.gMCP.gui.dialogs.GroupDialog;
import org.af.gMCP.gui.graph.EdgeWeight;
import org.af.gMCP.gui.graph.Node;
import org.af.jhlir.call.RChar;
import org.af.jhlir.call.RErrorException;
import org.af.jhlir.call.RInteger;
import org.af.jhlir.call.RList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixCreationDialog
extends JDialog
implements ActionListener,
ChangeListener {
    JButton ok = new JButton("Save matrix to R");
    JFrame parent;
    List<String> names;
    JTextArea jta = new JTextArea();
    public SingleDataFramePanel dfp;
    SingleDataFramePanel dfpDiag;
    SingleDataFramePanel dfpInterCor;
    SingleDataFramePanel dfpIntraCor;
    JTextField tfname = new JTextField();
    JList hypotheses;
    JLabel warning = new JLabel();
    protected static Log logger = LogFactory.getLog(MatrixCreationDialog.class);
    public boolean created = false;
    JTabbedPane tabbedPane = new JTabbedPane();
    JButton reorder = new JButton("Apply reordering");
    JButton toggleNA = new JButton("Change 0 in matrix to NA");
    JButton resetDiag = new JButton("Reset to identity matrix");
    JSpinner spinnerN;
    JSpinner spinnerN2;
    JButton jbAdd;
    JLabel jlBlock = new JLabel();
    JButton applyTE = new JButton("Calculate overall correlation");
    JSpinner spinnerNT;
    JSpinner spinnerNE;
    protected JComboBox jcbCorString = new JComboBox<String>(new String[]{"User defined design (edit the matrix)"});
    protected JComboBox jcbCorString2 = new JComboBox<String>(new String[]{"User defined design (edit the matrix)"});
    static final String NO_SD = "User defined design (edit the matrix)";

    public static Vector<String> getNames(Vector<Node> nodes) {
        Vector<String> v = new Vector<String>();
        for (Node n : nodes) {
            v.add(n.getName());
        }
        return v;
    }

    public MatrixCreationDialog(String[] matrix, String mname, String[] names) {
        this(null, Arrays.asList(matrix), mname, Arrays.asList(names));
    }

    public MatrixCreationDialog(JFrame parent, List<String> matrix, String mname, List<String> names) {
        super(parent, "Specify correlation matrix", true);
        DataTableModel m;
        this.setLocationRelativeTo(parent);
        this.names = new Vector<String>();
        for (String name : names) {
            this.names.add(name);
        }
        this.parent = parent;
        RDataFrameRef df = new RDataFrameRef();
        for (String n : names) {
            df.addRowCol(n);
            df.setValue(df.getColumnCount() - 1, df.getColumnCount() - 1, new EdgeWeight(1.0));
        }
        this.dfp = new SingleDataFramePanel(df);
        this.dfp.getTable().getModel().diagEditable = false;
        this.dfp.getTable().getModel().setCheckRowSum(false);
        this.dfp.getTable().getModel().checkCorMat();
        this.setUpTabbedPane();
        this.getPossibleCorrelations();
        this.jta.setText("");
        this.warning.setForeground(Color.RED);
        this.ok.addActionListener(this);
        String cols = "5dlu, fill:min:grow, 5dlu, fill:min:grow, 5dlu";
        String rows = "5dlu, fill:min:grow, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        layout.setColumnGroups((int[][])new int[][]{{2, 4}});
        this.getContentPane().setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.getContentPane().add((Component)this.tabbedPane, cc.xy(2, row));
        this.getContentPane().add((Component)new JScrollPane(this.dfp), cc.xy(4, row));
        this.getContentPane().add((Component)this.warning, cc.xy(2, row += 2));
        this.getContentPane().add((Component)this.ok, cc.xy(4, row));
        if (matrix == null) {
            if (mname != null) {
                m = this.dfp.getTable().getModel();
                int n = m.getColumnCount();
                String[] result = RControl.getR().eval("(function(x){ x[is.na(x)] <- \"NA\"; return(x)})(" + mname + ")").asRChar().getData();
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n; ++j) {
                        m.setValueAt(new EdgeWeight(result[i * n + j]), i, j);
                    }
                }
            }
        } else {
            m = this.dfp.getTable().getModel();
            int n = m.getColumnCount();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    m.setValueAt(new EdgeWeight(matrix.get(i * n + j)), i, j);
                }
            }
        }
        this.tfname.setText(mname);
        this.pack();
        Dimension d = this.getSize();
        this.setSize((int)d.getWidth(), Math.min((int)(d.getHeight() * 1.7), (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() - 80.0)));
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void setUpTabbedPane() {
        this.tabbedPane.add("General", this.getSortPane());
        this.tabbedPane.add("Block Diagonal", this.getBlockPane());
        this.tabbedPane.add("Treatments and Endpoints", this.getTEPane());
    }

    private JPanel getSortPane() {
        JPanel panel = new JPanel();
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, fill:min:grow, 5dlu, pref, 5dlu, pref, 5dlu";
        panel.setLayout((LayoutManager)new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.tfname.setText("corMat");
        panel.add((Component)new JLabel("Save matrix as:"), cc.xy(2, row));
        panel.add((Component)this.tfname, cc.xy(4, row));
        this.resetDiag.addActionListener(this);
        panel.add((Component)this.resetDiag, cc.xy(4, row += 2));
        this.toggleNA.addActionListener(this);
        panel.add((Component)this.toggleNA, cc.xy(4, row += 2));
        panel.add((Component)new JLabel("You can reorder the hypotheses by drag'n'drop:"), cc.xyw(2, row += 2, 3));
        row += 2;
        DefaultListModel<String> lm = new DefaultListModel<String>();
        for (String n : this.names) {
            lm.addElement(n);
        }
        try {
            Class<?> cls = Class.forName("org.af.commons.widgets.JListDnD");
            Constructor<?> ct = cls.getConstructor(ListModel.class);
            this.hypotheses = (JList)ct.newInstance(lm);
            panel.add((Component)new JScrollPane(this.hypotheses), cc.xyw(2, row, 3));
        }
        catch (Exception e) {
            logger.warn((Object)e);
            this.hypotheses = new JList(lm);
            panel.add((Component)new JScrollPane(this.hypotheses), cc.xyw(2, row, 3));
            panel.add((Component)new JLabel("Reordering does currently not work for you due to Java 5"), cc.xyw(2, row += 2, 3));
        }
        this.reorder.addActionListener(this);
        panel.add((Component)this.reorder, cc.xy(4, row += 2));
        row += 2;
        return panel;
    }

    private JPanel getBlockPane() {
        JPanel panel = new JPanel();
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, fill:min:grow, 5dlu, pref, 5dlu";
        panel.setLayout((LayoutManager)new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.spinnerN = new JSpinner(new SpinnerNumberModel(2, 1, this.names.size(), 1));
        this.spinnerN.addChangeListener(this);
        panel.add((Component)new JLabel("Insert matrix of size:"), cc.xy(2, row));
        panel.add((Component)this.spinnerN, cc.xy(4, row));
        this.spinnerN2 = new JSpinner(new SpinnerNumberModel(1, 1, this.names.size() - 1, 1));
        this.spinnerN2.addChangeListener(this);
        panel.add((Component)new JLabel("Insert matrix at position:"), cc.xy(2, row += 2));
        panel.add((Component)this.spinnerN2, cc.xy(4, row));
        panel.add((Component)new JLabel("Use standard design:"), cc.xy(2, row += 2));
        panel.add((Component)this.jcbCorString2, cc.xy(4, row));
        this.jcbCorString2.addActionListener(this);
        panel.add((Component)this.jlBlock, cc.xyw(2, row += 2, 3));
        row += 2;
        RDataFrameRef df = new RDataFrameRef();
        for (int i = 0; i < 2; ++i) {
            df.addRowCol(this.names.get(i));
            df.setValue(df.getColumnCount() - 1, df.getColumnCount() - 1, new EdgeWeight(1.0));
        }
        this.dfpDiag = new SingleDataFramePanel(df);
        this.dfpDiag.getTable().getModel().setCheckRowSum(false);
        panel.add((Component)new JScrollPane(this.dfpDiag), cc.xyw(2, row, 3));
        this.jbAdd = new JButton("Add matrix on diagonal");
        this.jbAdd.addActionListener(this);
        panel.add((Component)this.jbAdd, cc.xyw(2, row += 2, 3));
        return panel;
    }

    private JPanel getTEPane() {
        JPanel panel = new JPanel();
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, fill:min:grow, 5dlu, fill:min:grow, 5dlu, pref, 5dlu";
        panel.setLayout((LayoutManager)new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 2;
        panel.add((Component)this.getTEPane1(), cc.xyw(2, row, 3));
        panel.add((Component)this.getTEPane2(), cc.xyw(2, row += 2, 3));
        this.applyTE.addActionListener(this);
        panel.add((Component)this.applyTE, cc.xyw(2, row += 2, 3));
        return panel;
    }

    private JPanel getTEPane1() {
        JPanel panel = new JPanel();
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, fill:min:grow, 5dlu";
        panel.setLayout((LayoutManager)new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.spinnerNT = new JSpinner(new SpinnerNumberModel(Math.max(2, this.names.size() / 2), 1, this.names.size(), 1));
        this.spinnerNT.addChangeListener(this);
        panel.add((Component)new JLabel("Number of Treatment Comparisons:"), cc.xy(2, row));
        panel.add((Component)this.spinnerNT, cc.xy(4, row));
        panel.add((Component)new JLabel("Use standard design:"), cc.xy(2, row += 2));
        panel.add((Component)this.jcbCorString, cc.xy(4, row));
        this.jcbCorString.addActionListener(this);
        row += 2;
        RDataFrameRef df = new RDataFrameRef();
        for (int i = 0; i < Math.max(2, this.names.size() / 2); ++i) {
            df.addRowCol("T" + (i + 1));
            df.setValue(df.getColumnCount() - 1, df.getColumnCount() - 1, new EdgeWeight(1.0));
        }
        this.dfpIntraCor = new SingleDataFramePanel(df);
        this.dfpIntraCor.getTable().getModel().setCheckRowSum(false);
        panel.add((Component)new JScrollPane(this.dfpIntraCor), cc.xyw(2, row, 3));
        TitledBorder title = BorderFactory.createTitledBorder("Treatment correlation.");
        panel.setBorder(title);
        return panel;
    }

    private JPanel getTEPane2() {
        JPanel panel = new JPanel();
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, fill:min:grow, 5dlu";
        panel.setLayout((LayoutManager)new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.spinnerNE = new JSpinner(new SpinnerNumberModel(Math.max(2, this.names.size() / 2), 1, this.names.size(), 1));
        this.spinnerNE.addChangeListener(this);
        panel.add((Component)new JLabel("Number of Endpoints:"), cc.xy(2, row));
        panel.add((Component)this.spinnerNE, cc.xy(4, row));
        row += 2;
        RDataFrameRef df = new RDataFrameRef();
        for (int i = 0; i < Math.max(2, this.names.size() / 2); ++i) {
            df.addRowCol("E" + (i + 1));
            df.setValue(df.getColumnCount() - 1, df.getColumnCount() - 1, new EdgeWeight(1.0));
        }
        this.dfpInterCor = new SingleDataFramePanel(df);
        this.dfpInterCor.getTable().getModel().setCheckRowSum(false);
        panel.add((Component)new JScrollPane(this.dfpInterCor), cc.xyw(2, row, 3));
        TitledBorder title = BorderFactory.createTitledBorder("Correlation between endpoints");
        panel.setBorder(title);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            String name = RControl.getR().eval("make.names(\"" + this.tfname.getText() + "\")").asRChar().getData()[0];
            RControl.getR().evalInGlobalEnv(name + " <- " + this.dfp.getTable().getModel().getDataFrame().getRMatrix());
            this.created = true;
            this.dispose();
        } else if (e.getSource() == this.jbAdd) {
            int k = Integer.parseInt(this.spinnerN2.getModel().getValue().toString());
            int n = Integer.parseInt(this.spinnerN.getModel().getValue().toString());
            DataTableModel m = this.dfpDiag.getTable().getModel();
            DataTableModel m2 = this.dfp.getTable().getModel();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    m2.setValueAt(m.getValueAt(i, j), i + k - 1, j + k - 1);
                }
            }
        } else if (e.getSource() == this.toggleNA) {
            DataTableModel m2 = this.dfp.getTable().getModel();
            int n = m2.getColumnCount();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    if (m2.getValueAt(i, j).getWeight(null) != 0.0) continue;
                    m2.setValueAt(new EdgeWeight("NA"), i, j);
                }
            }
        } else if (e.getSource() == this.reorder) {
            this.names.clear();
            for (int i = 0; i < this.hypotheses.getModel().getSize(); ++i) {
                this.names.add((String)this.hypotheses.getModel().getElementAt(i));
            }
            this.createMDiag();
            Vector<String> names2 = new Vector<String>();
            for (String n : this.names) {
                names2.add(n);
            }
            this.dfp.getTable().getModel().getDataFrame().setNames(names2);
            this.dfp.getTable().update();
        } else if (e.getSource() == this.resetDiag) {
            DataTableModel m2 = this.dfp.getTable().getModel();
            int n = m2.getColumnCount();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    if (i == j) {
                        m2.setValueAt(new EdgeWeight(1.0), i, j);
                        continue;
                    }
                    m2.setValueAt(new EdgeWeight(0.0), i, j);
                }
            }
        } else if (e.getSource() == this.applyTE) {
            int b;
            DataTableModel m2 = this.dfp.getTable().getModel();
            int n = m2.getColumnCount();
            int a = this.dfpIntraCor.getTable().getRowCount();
            if (a * (b = this.dfpInterCor.getTable().getRowCount()) != n) {
                JOptionPane.showMessageDialog(this, "Wrong dimensions: " + a + "+" + b + "!=" + n, "Wrong dimension", 0);
                return;
            }
            double[] result = RControl.getR().eval("as.numeric(kronecker(" + this.dfpInterCor.getTable().getRMatrix() + "," + this.dfpIntraCor.getTable().getRMatrix() + "))").asRNumeric().getData();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    m2.setValueAt(new EdgeWeight(result[i * n + j]), i, j);
                }
            }
        } else if (e.getSource() == this.jcbCorString2) {
            if (this.jcbCorString2.getSelectedItem() == null || this.jcbCorString2.getSelectedItem().toString().equals(NO_SD)) {
                return;
            }
            DataTableModel m = this.dfpDiag.getTable().getModel();
            int n = Integer.parseInt(this.spinnerN.getModel().getValue().toString());
            String s = this.jcbCorString2.getSelectedItem().toString();
            this.setMatrix(m, s, n);
        } else if (e.getSource() == this.jcbCorString) {
            if (this.jcbCorString.getSelectedItem() == null || this.jcbCorString.getSelectedItem().toString().equals(NO_SD)) {
                return;
            }
            DataTableModel m = this.dfpIntraCor.getTable().getModel();
            int n = Integer.parseInt(this.spinnerNT.getModel().getValue().toString());
            String s = this.jcbCorString.getSelectedItem().toString();
            this.setMatrix(m, s, n);
        }
        try {
            this.warning.setText(RControl.getR().eval("gMCP:::checkPSD(" + this.dfp.getTable().getRMatrix() + ")").asRChar().getData()[0]);
        }
        catch (RErrorException error) {
            this.warning.setText("Matrix could not be evaluated! Are all entries numeric?");
        }
    }

    private void setMatrix(DataTableModel m, String s, int n) {
        String design = s.substring(0, s.indexOf(" "));
        String groups = s.substring(s.indexOf("(") + 1, s.indexOf("groups") - 1);
        GroupDialog gd = new GroupDialog(this.parent, Integer.parseInt(groups));
        String command = "gMCP:::getCorrMat(n=" + gd.getGroups() + ", type =\"" + design + "\")";
        double[] m2 = RControl.getR().eval(command).asRNumeric().getData();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                m.setValueAt(new EdgeWeight(m2[i * n + j]), i, j);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.spinnerN || e.getSource() == this.spinnerN2) {
            this.createMDiag();
            this.getPossibleCorrelations();
        } else if (e.getSource() == this.spinnerNT) {
            this.createMT();
            this.getPossibleCorrelations();
        } else if (e.getSource() == this.spinnerNE) {
            this.createME();
            this.getPossibleCorrelations();
        }
    }

    private void createMT() {
        int n = Integer.parseInt(this.spinnerNT.getModel().getValue().toString());
        DataTableModel m = this.dfpIntraCor.getTable().getModel();
        m.removeAll();
        for (int i = 0; i < n; ++i) {
            m.addRowCol("T" + (i + 1));
            m.setValueAt(new EdgeWeight(1.0), m.getColumnCount() - 1, m.getColumnCount() - 1);
        }
    }

    private void createME() {
        int n = Integer.parseInt(this.spinnerNE.getModel().getValue().toString());
        DataTableModel m = this.dfpInterCor.getTable().getModel();
        m.removeAll();
        for (int i = 0; i < n; ++i) {
            m.addRowCol("E" + (i + 1));
            m.setValueAt(new EdgeWeight(1.0), m.getColumnCount() - 1, m.getColumnCount() - 1);
        }
    }

    private void createMDiag() {
        int n = Integer.parseInt(this.spinnerN.getModel().getValue().toString());
        int j = Integer.parseInt(this.spinnerN2.getModel().getValue().toString());
        DataTableModel m = this.dfpDiag.getTable().getModel();
        m.removeAll();
        if (n + j - 1 > this.names.size()) {
            JOptionPane.showMessageDialog(this.parent, "The selected values " + n + "+" + j + " exceed the number of nodes+1.", "Impossible parameter combination", 0);
            return;
        }
        for (int i = j - 1; i < j - 1 + n; ++i) {
            m.addRowCol(this.names.get(i));
            m.setValueAt(new EdgeWeight(1.0), m.getColumnCount() - 1, m.getColumnCount() - 1);
        }
    }

    private void getPossibleCorrelations() {
        int i;
        RInteger groups;
        RChar designs;
        RList list;
        this.jcbCorString.removeAllItems();
        this.jcbCorString2.removeAllItems();
        int n = Integer.parseInt(this.spinnerNT.getModel().getValue().toString());
        int n2 = Integer.parseInt(this.spinnerN.getModel().getValue().toString());
        if (n != 0) {
            list = RControl.getR().eval("gMCP:::getAvailableStandardDesigns(" + n + ")").asRList();
            designs = list.get(0).asRChar();
            groups = list.get(1).asRInteger();
            this.jcbCorString.addItem(NO_SD);
            for (i = 0; i < designs.getLength(); ++i) {
                this.jcbCorString.addItem(designs.getData()[i] + " (" + groups.getData()[i] + " groups)");
            }
        }
        if (n2 != 0) {
            list = RControl.getR().eval("gMCP:::getAvailableStandardDesigns(" + n2 + ")").asRList();
            designs = list.get(0).asRChar();
            groups = list.get(1).asRInteger();
            this.jcbCorString2.addItem(NO_SD);
            for (i = 0; i < designs.getLength(); ++i) {
                this.jcbCorString2.addItem(designs.getData()[i] + " (" + groups.getData()[i] + " groups)");
            }
        }
    }
}

