/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.dialogs;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.af.commons.errorhandling.HTTPPoster;
import org.af.commons.tools.StringTools;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.CreateGraphGUI;
import org.af.gMCP.gui.ErrorDialogGMCP;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.dialogs.ImagePanel;
import org.af.gMCP.gui.graph.GraphView;

public class GraphSendToArchiveDialog
extends JDialog
implements ActionListener {
    JButton ok = new JButton("Submit");
    JButton cancel = new JButton("Cancel");
    CreateGraphGUI parent;
    GraphView control;
    JTextArea jtDescr = new JTextArea(6, 40);
    JTextArea jtLiterature = new JTextArea(6, 40);
    JTextField jtTitle = new JTextField();
    JTextField jtName = new JTextField();
    JTextField jtEmail = new JTextField();
    Hashtable<String, String> table = new Hashtable();
    Hashtable<String, File> files = new Hashtable();
    String urlString = "http://algorithm-forge.com/gMCP/submitGraph.php";
    JPanel canvas;
    static final int MAXWIDTH = 500;
    static final int MAXHEIGHT = 300;

    public GraphSendToArchiveDialog(CreateGraphGUI parent, GraphView control) {
        super(parent, "Submit your graph", true);
        this.parent = parent;
        this.control = control;
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 10;
        c.ipady = 10;
        c.weightx = 1.0;
        c.weighty = 0.0;
        BufferedImage img = control.nl.getImage(1.0, false);
        this.canvas = 500 / img.getWidth() < 1 || 300 / img.getHeight() < 1 ? (500 / img.getWidth() > 300 / img.getHeight() ? new ImagePanel(img.getScaledInstance(-1, 300, 4)) : new ImagePanel(img.getScaledInstance(500, -1, 4))) : new ImagePanel(img);
        this.getContentPane().add((Component)this.canvas, c);
        ++c.gridy;
        c.weighty = 1.0;
        this.getContentPane().add((Component)this.getInfoPanel(), c);
        ++c.gridy;
        c.weighty = 0.0;
        this.getContentPane().add((Component)this.ok, c);
        this.ok.addActionListener(this);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public JPanel getInfoPanel() {
        JPanel panel = new JPanel();
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref,5dlu, pref, 5dlu, fill:pref:grow,5dlu, pref, 5dlu, pref,5dlu, pref, 5dlu, pref";
        FormLayout layout = new FormLayout(cols, rows);
        panel.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        panel.add((Component)new JLabel("Title"), cc.xy(2, row));
        panel.add((Component)new JTextField(), cc.xy(2, row += 2));
        panel.add((Component)new JLabel("Description and References"), cc.xy(2, row += 2));
        panel.add((Component)new JScrollPane(this.jtDescr), cc.xy(2, row += 2));
        panel.add((Component)new JLabel("Your name"), cc.xy(2, row += 2));
        panel.add((Component)this.jtName, cc.xy(2, row += 2));
        panel.add((Component)new JLabel("Optional email (will not be published - just for feedback from us)"), cc.xy(2, row += 2));
        panel.add((Component)this.jtEmail, cc.xy(2, row += 2));
        return panel;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            this.table.put("Description", this.jtDescr.getText());
            this.table.put("Title", this.jtTitle.getText());
            this.table.put("Name", this.jtName.getText());
            this.table.put("Email", this.jtEmail.getText());
            this.table.put("Subject", "New graph from " + this.jtName.getText());
            File file = new File(Configuration.getInstance().getGeneralConfig().getTempDir(), "Graph" + new Random().nextInt() + ".jpg");
            this.control.saveGraphImage(file, true, true, true);
            this.files.put("Image", file);
            this.files.put("Graph", ErrorDialogGMCP.makeLogFile("graph.txt", StringTools.collapseStringArray((String[])RControl.getR().eval("gMCP:::getDebugInfo()").asRChar().getData())));
            new HTTPPoster().post(this.urlString, this.table, this.files);
        }
        catch (IOException e1) {
            new ErrorDialogGMCP("An error occured submitting the graph.", e1, false).showDialog();
        }
        this.dispose();
    }
}

