/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.util.dataset;

import net.sourceforge.jclec.util.dataset.AbstractAttribute;
import net.sourceforge.jclec.util.dataset.AttributeType;
import net.sourceforge.jclec.util.intset.Closure;
import net.sourceforge.jclec.util.intset.Interval;

public class IntegerAttribute
extends AbstractAttribute {
    private static final long serialVersionUID = -6328412187422731602L;
    Interval interval = null;

    public void addInterval(Interval interval) {
        this.interval = interval;
    }

    @Override
    public AttributeType getType() {
        return AttributeType.IntegerNumerical;
    }

    @Override
    public boolean isValid(double internalValue) {
        return this.interval.contains(Double.valueOf(internalValue).intValue());
    }

    @Override
    public boolean isValid(Object externalValue) {
        return this.interval.contains(((Double)externalValue).intValue());
    }

    @Override
    public double parse(String externalValue) {
        return Double.parseDouble(externalValue);
    }

    @Override
    public String show(double internalValue) {
        return new Integer(Double.valueOf(internalValue).intValue()).toString();
    }

    public Interval intervalValues() {
        if (this.interval == null) {
            this.interval = new Interval(0, Integer.MAX_VALUE, Closure.ClosedClosed);
        }
        return this.interval;
    }
}

