/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Lazy_Learning.Deeps;

class Itemset {
    private int[] items = new int[maxItems];
    private int size;
    private static int maxItems = 1;

    public static void setMaxItems(int value) {
        maxItems = value;
    }

    public Itemset() {
        this.size = 0;
    }

    public Itemset(int[] inItems) {
        for (int i = 0; i < inItems.length; ++i) {
            if (inItems[i] != 1) continue;
            this.add(i);
        }
    }

    public int contains(int value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.items[i] != value) continue;
            return i;
        }
        return -1;
    }

    public void add(int value) {
        if (this.contains(value) == -1) {
            this.items[this.size] = value;
            ++this.size;
        }
    }

    public void drop(int value) {
        int position = this.contains(value);
        if (position > -1) {
            for (int i = position; i < this.size; ++i) {
                this.items[i] = this.items[i + 1];
            }
            --this.size;
        }
    }

    public int get(int position) {
        return this.items[position];
    }

    public int getSize() {
        return this.size;
    }

    public boolean isSubset(Itemset great) {
        for (int i = 0; i < this.size; ++i) {
            if (great.contains(this.items[i]) != -1) continue;
            return false;
        }
        return true;
    }

    public boolean isSuperset(Itemset little) {
        for (int i = 0; i < little.getSize(); ++i) {
            if (this.contains(little.get(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public Itemset diference(Itemset other) {
        Itemset result = new Itemset();
        for (int i = 0; i < this.size; ++i) {
            if (other.contains(this.items[i]) != -1) continue;
            result.add(this.items[i]);
        }
        return result;
    }

    public Itemset merge(Itemset other) {
        int i;
        Itemset result = new Itemset();
        for (i = 0; i < this.size; ++i) {
            result.add(this.items[i]);
        }
        for (i = 0; i < other.getSize(); ++i) {
            result.add(other.get(i));
        }
        return result;
    }

    public boolean isSubSetBinary(int[] array) {
        for (int i = 0; i < this.size; ++i) {
            if (array[this.items[i]] != 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String chain = "";
        chain = chain + " <";
        for (int i = 0; i < this.size; ++i) {
            chain = chain + this.items[i] + " ";
        }
        chain = chain + ">";
        return chain;
    }
}

