/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.SFLSDE;

import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;
import keel.Algorithms.Instance_Generation.utilities.RandomGenerator;

public class SFLSDEGenerator
extends PrototypeGenerator {
    private int k;
    private int PopulationSize;
    private int ParticleSize;
    private int MaxIter;
    private int Strategy;
    protected int numberOfClass;
    protected int numberOfPrototypes;
    private String[] paramsOfInitialReducction = null;
    private double[] tau = new double[4];
    private double Fl;
    private double Fu;
    private int iterSFGSS;
    private int iterSFHC;

    public SFLSDEGenerator(PrototypeSet _trainingDataSet, int neigbors, int poblacion, int perc, int iteraciones, double F, double CR, int strg) {
        super(_trainingDataSet);
        this.algorithmName = "SFLSDE";
        this.k = neigbors;
        this.PopulationSize = poblacion;
        this.ParticleSize = perc;
        this.MaxIter = iteraciones;
        this.numberOfPrototypes = this.getSetSizeFromPercentage(perc);
    }

    public SFLSDEGenerator(PrototypeSet t, Parameters parameters) {
        super(t, parameters);
        this.algorithmName = "SFLSDE";
        this.k = parameters.getNextAsInt();
        this.PopulationSize = parameters.getNextAsInt();
        this.ParticleSize = parameters.getNextAsInt();
        this.MaxIter = parameters.getNextAsInt();
        this.iterSFGSS = parameters.getNextAsInt();
        this.iterSFHC = parameters.getNextAsInt();
        this.Fl = parameters.getNextAsDouble();
        this.Fu = parameters.getNextAsDouble();
        this.tau[0] = parameters.getNextAsDouble();
        this.tau[1] = parameters.getNextAsDouble();
        this.tau[2] = parameters.getNextAsDouble();
        this.tau[3] = parameters.getNextAsDouble();
        this.Strategy = parameters.getNextAsInt();
        this.numberOfPrototypes = this.getSetSizeFromPercentage(this.ParticleSize);
        this.numberOfClass = this.trainingDataSet.getPosibleValuesOfOutput().size();
        System.out.print("\nIsaac dice:  " + this.k + " Swar= " + this.PopulationSize + " Particle=  " + this.ParticleSize + " Maxiter= " + this.MaxIter + " tau4=  " + this.tau[3] + " CrossverType = " + "\n");
    }

    public PrototypeSet mutant(PrototypeSet[] population, int actual, int mejor, double SFi) {
        PrototypeSet mutant = new PrototypeSet(population.length);
        int[] lista = new int[population.length];
        this.inic_vector_sin(lista, actual);
        this.desordenar_vector_sin(lista);
        PrototypeSet r1 = population[lista[0]];
        PrototypeSet r2 = population[lista[1]];
        PrototypeSet r3 = population[lista[2]];
        PrototypeSet r4 = population[lista[3]];
        PrototypeSet r5 = population[lista[4]];
        switch (this.Strategy) {
            case 1: {
                PrototypeSet resta = r2.restar(r3);
                PrototypeSet producto = resta.mulEscalar(SFi);
                mutant = producto.sumar(r1);
                break;
            }
            case 2: {
                PrototypeSet resta = r2.restar(r3);
                PrototypeSet producto = resta.mulEscalar(SFi);
                mutant = population[mejor].sumar(producto);
                break;
            }
            case 3: {
                PrototypeSet resta = r1.restar(r2);
                PrototypeSet resta2 = population[mejor].restar(population[actual]);
                PrototypeSet producto = resta.mulEscalar(SFi);
                PrototypeSet producto2 = resta2.mulEscalar(SFi);
                PrototypeSet result = population[actual].sumar(producto);
                mutant = result.sumar(producto2);
                break;
            }
            case 4: {
                PrototypeSet resta = r1.restar(r2);
                PrototypeSet resta2 = r3.restar(r4);
                PrototypeSet producto = resta.mulEscalar(SFi);
                PrototypeSet producto2 = resta2.mulEscalar(SFi);
                PrototypeSet result = population[mejor].sumar(producto);
                mutant = result.sumar(producto2);
                break;
            }
            case 5: {
                PrototypeSet resta = r2.restar(r3);
                PrototypeSet resta2 = r4.restar(r5);
                PrototypeSet producto = resta.mulEscalar(SFi);
                PrototypeSet producto2 = resta2.mulEscalar(SFi);
                PrototypeSet result = r1.sumar(producto);
                mutant = result.sumar(producto2);
                break;
            }
            case 6: {
                PrototypeSet resta = r1.restar(r2);
                PrototypeSet resta2 = r3.restar(r4);
                PrototypeSet resta3 = population[mejor].restar(population[actual]);
                PrototypeSet producto = resta.mulEscalar(SFi);
                PrototypeSet producto2 = resta2.mulEscalar(SFi);
                PrototypeSet producto3 = resta3.mulEscalar(SFi);
                PrototypeSet result = population[actual].sumar(producto);
                result = result.sumar(producto2);
                mutant = result.sumar(producto3);
            }
        }
        mutant.applyThresholds();
        return mutant;
    }

    public double lsff(double Fi, double CRi, PrototypeSet[] population, int actual, int mejor) {
        double FitnessFi = 0.0;
        PrototypeSet mutant = new PrototypeSet(population[actual].size());
        mutant = this.mutant(population, actual, mejor, Fi);
        PrototypeSet crossover = new PrototypeSet(population[actual]);
        for (int j = 0; j < population[actual].size(); ++j) {
            double randNumber = RandomGenerator.Randdouble(0.0, 1.0);
            if (!(randNumber < CRi)) continue;
            crossover.set(j, mutant.get(j));
        }
        PrototypeSet nominalPopulation = new PrototypeSet();
        nominalPopulation.formatear(crossover);
        FitnessFi = SFLSDEGenerator.accuracy(nominalPopulation, this.trainingDataSet);
        return FitnessFi;
    }

    public PrototypeSet SFGSS(PrototypeSet[] population, int actual, int mejor, double CRi) {
        double a = 0.1;
        double b = 1.0;
        double fi1 = 0.0;
        double fi2 = 0.0;
        double fitnessFi1 = 0.0;
        double fitnessFi2 = 0.0;
        double phi = (1.0 + Math.sqrt(5.0)) / 5.0;
        for (int i = 0; i < this.iterSFGSS; ++i) {
            fi1 = b - (b - a) / phi;
            fi2 = a + (b - a) / phi;
            fitnessFi1 = this.lsff(fi1, CRi, population, actual, mejor);
            if (fitnessFi1 > (fitnessFi2 = this.lsff(fi2, CRi, population, actual, mejor))) {
                b = fi2;
                continue;
            }
            a = fi1;
        }
        double scaling = fitnessFi1 > fitnessFi2 ? fi1 : fi2;
        PrototypeSet mutant = new PrototypeSet(population[actual].size());
        mutant = this.mutant(population, actual, mejor, scaling);
        PrototypeSet crossover = new PrototypeSet(population[actual]);
        for (int j = 0; j < population[actual].size(); ++j) {
            double randNumber = RandomGenerator.Randdouble(0.0, 1.0);
            if (!(randNumber < CRi)) continue;
            crossover.set(j, mutant.get(j));
        }
        return crossover;
    }

    public PrototypeSet SFHC(PrototypeSet[] population, int actual, int mejor, double SFi, double CRi) {
        double h = 0.5;
        for (int i = 0; i < this.iterSFHC; ++i) {
            double bestFi;
            double fitnessFi1 = this.lsff(SFi - h, CRi, population, actual, mejor);
            double fitnessFi2 = this.lsff(SFi, CRi, population, actual, mejor);
            double fitnessFi3 = this.lsff(SFi + h, CRi, population, actual, mejor);
            if (fitnessFi1 >= fitnessFi2 && fitnessFi1 >= fitnessFi3) {
                bestFi = SFi - h;
            } else if (fitnessFi2 >= fitnessFi1 && fitnessFi2 >= fitnessFi3) {
                bestFi = SFi;
                h /= 2.0;
            } else {
                bestFi = SFi;
            }
            SFi = bestFi;
        }
        PrototypeSet mutant = new PrototypeSet(population[actual].size());
        mutant = this.mutant(population, actual, mejor, SFi);
        PrototypeSet crossover = new PrototypeSet(population[actual]);
        for (int j = 0; j < population[actual].size(); ++j) {
            double randNumber = RandomGenerator.Randdouble(0.0, 1.0);
            if (!(randNumber < CRi)) continue;
            crossover.set(j, mutant.get(j));
        }
        return crossover;
    }

    @Override
    public PrototypeSet reduceSet() {
        PrototypeSet nominalPopulation;
        int i;
        int j;
        int i2;
        System.out.print("\nThe algorithm  SFLSDE is starting...\n Computing...\n");
        System.out.println("Reduction %, result set = " + (this.trainingDataSet.size() - this.numberOfPrototypes) * 100 / this.trainingDataSet.size() + "\n");
        if (this.numberOfPrototypes < this.trainingDataSet.getPosibleValuesOfOutput().size()) {
            System.out.println("Number of prototypes less than the number of clases");
            this.numberOfPrototypes = this.trainingDataSet.getPosibleValuesOfOutput().size();
        }
        PrototypeSet[] population = new PrototypeSet[this.PopulationSize];
        PrototypeSet[] mutation = new PrototypeSet[this.PopulationSize];
        PrototypeSet[] crossover = new PrototypeSet[this.PopulationSize];
        double[] ScalingFactor = new double[this.PopulationSize];
        double[] CrossOverRate = new double[this.PopulationSize];
        double[] fitness = new double[this.PopulationSize];
        population[0] = this.selecRandomSet(this.numberOfPrototypes, true).clone();
        PrototypeSet[] clases = new PrototypeSet[this.numberOfClass];
        for (i2 = 0; i2 < this.numberOfClass; ++i2) {
            clases[i2] = new PrototypeSet(this.trainingDataSet.getFromClass(i2));
            System.out.println("Clase " + i2 + ", size= " + clases[i2].size());
        }
        for (i2 = 0; i2 < population[0].size(); ++i2) {
            for (j = 0; j < this.numberOfClass; ++j) {
                if (population[0].getFromClass(j).size() != 0 || clases[j].size() == 0) continue;
                population[0].add(clases[j].getRandom());
            }
        }
        fitness[0] = SFLSDEGenerator.accuracy(population[0], this.trainingDataSet);
        for (i2 = 1; i2 < this.PopulationSize; ++i2) {
            population[i2] = new PrototypeSet();
            for (j = 0; j < population[0].size(); ++j) {
                population[i2].add(this.trainingDataSet.getFromClass(((Prototype)population[0].get(j)).getOutput(0)).getRandom());
            }
            fitness[i2] = SFLSDEGenerator.accuracy(population[i2], this.trainingDataSet);
        }
        double bestFitness = fitness[0];
        int bestFitnessIndex = 0;
        for (int i3 = 1; i3 < this.PopulationSize; ++i3) {
            if (!(fitness[i3] > bestFitness)) continue;
            bestFitness = fitness[i3];
            bestFitnessIndex = i3;
        }
        for (int j2 = 0; j2 < this.PopulationSize; ++j2) {
            for (i = 0; i < population[j2].size(); ++i) {
                ((Prototype)population[j2].get(i)).setIndex(i);
            }
        }
        boolean[] cruceExp = new boolean[this.PopulationSize];
        for (i = 0; i < this.PopulationSize; ++i) {
            ScalingFactor[i] = RandomGenerator.Randdouble(0.0, 1.0);
            CrossOverRate[i] = RandomGenerator.Randdouble(0.0, 1.0);
        }
        double[] randj = new double[5];
        for (int iter = 0; iter < this.MaxIter; ++iter) {
            for (int i4 = 0; i4 < this.PopulationSize; ++i4) {
                int j3;
                for (j3 = 0; j3 < 5; ++j3) {
                    randj[j3] = RandomGenerator.Randdouble(0.0, 1.0);
                }
                if (i4 == bestFitnessIndex && randj[4] < this.tau[2]) {
                    crossover[i4] = this.SFGSS(population, i4, bestFitnessIndex, CrossOverRate[i4]);
                } else if (i4 == bestFitnessIndex && this.tau[2] <= randj[4] && randj[4] < this.tau[3]) {
                    crossover[i4] = this.SFHC(population, i4, bestFitnessIndex, ScalingFactor[i4], CrossOverRate[i4]);
                } else {
                    if (randj[1] < this.tau[0]) {
                        ScalingFactor[i4] = this.Fl + this.Fu * randj[0];
                    }
                    if (randj[3] < this.tau[1]) {
                        CrossOverRate[i4] = randj[2];
                    }
                    mutation[i4] = new PrototypeSet(population[i4].size());
                    mutation[i4] = this.mutant(population, i4, bestFitnessIndex, ScalingFactor[i4]);
                    crossover[i4] = new PrototypeSet(population[i4]);
                    for (j3 = 0; j3 < population[i4].size(); ++j3) {
                        double randNumber = RandomGenerator.Randdouble(0.0, 1.0);
                        if (!(randNumber < CrossOverRate[i4])) continue;
                        crossover[i4].set(j3, mutation[i4].get(j3));
                    }
                }
                nominalPopulation = new PrototypeSet();
                nominalPopulation.formatear(population[i4]);
                fitness[i4] = SFLSDEGenerator.accuracy(nominalPopulation, this.trainingDataSet);
                nominalPopulation = new PrototypeSet();
                nominalPopulation.formatear(crossover[i4]);
                double trialVector = SFLSDEGenerator.accuracy(nominalPopulation, this.trainingDataSet);
                if (trialVector > fitness[i4]) {
                    population[i4] = new PrototypeSet(crossover[i4]);
                    fitness[i4] = trialVector;
                }
                if (!(fitness[i4] > bestFitness)) continue;
                bestFitness = fitness[i4];
                bestFitnessIndex = i4;
                System.out.println("Iter=" + iter + " Acc= " + bestFitness);
            }
        }
        nominalPopulation = new PrototypeSet();
        nominalPopulation.formatear(population[bestFitnessIndex]);
        System.err.println("\n% de acierto en training Nominal " + (double)KNN.classficationAccuracy(nominalPopulation, this.trainingDataSet, 1) * 100.0 / (double)this.trainingDataSet.size());
        return nominalPopulation;
    }

    public static void main(String[] args) {
        Parameters.setUse("SFLSDE", "<seed> <Number of neighbors>\n<Swarm size>\n<Particle Size>\n<MaxIter>\n<DistanceFunction>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        SFLSDEGenerator.setSeed(seed);
        int k = Parameters.assertExtendedArgAsInt(args, 3, "number of neighbors", 1.0, 2.147483647E9);
        int swarm = Parameters.assertExtendedArgAsInt(args, 4, "swarm size", 1.0, 2.147483647E9);
        int particle = Parameters.assertExtendedArgAsInt(args, 5, "particle size", 1.0, 2.147483647E9);
        int iter = Parameters.assertExtendedArgAsInt(args, 6, "max iter", 1.0, 2.147483647E9);
        double c1 = Parameters.assertExtendedArgAsInt(args, 7, "c1", 1.0, Double.MAX_VALUE);
        double c2 = Parameters.assertExtendedArgAsInt(args, 8, "c2", 1.0, Double.MAX_VALUE);
        double vmax = Parameters.assertExtendedArgAsInt(args, 9, "vmax", 1.0, Double.MAX_VALUE);
        double wstart = Parameters.assertExtendedArgAsInt(args, 10, "wstart", 1.0, Double.MAX_VALUE);
        double wend = Parameters.assertExtendedArgAsInt(args, 11, "wend", 1.0, Double.MAX_VALUE);
        SFLSDEGenerator generator = new SFLSDEGenerator(training, k, swarm, particle, iter, 0.5, 0.5, 1);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

