/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.Basic;

import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.Debug;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.KeelFile;
import keel.Algorithms.Instance_Generation.utilities.Parameters;

public class AccuracyMeter {
    protected static final String[] yes = new String[]{"yes", "Yes", "YES", "Y", "yeah", "oh yeah"};

    protected static boolean isIn(String s, String[] posibilities) {
        boolean value = false;
        for (int i = 0; !value && i < posibilities.length; ++i) {
            value = value || s.equals(posibilities[i]);
        }
        return value;
    }

    protected static boolean isYes(String s) {
        return AccuracyMeter.isIn(s, yes);
    }

    public static void main(String[] args) {
        Parameters.assertBasicArgs(args);
        Debug.endsIf(args.length < 4, "Use: <training data set> <reduced set file> <test set file> <algorithmName used in reduction> <output file> [append]");
        String algoName = args[3];
        String outputFile = args[4];
        boolean append = false;
        if (args.length == 6) {
            append = AccuracyMeter.isYes(args[5]);
        }
        PrototypeSet trainingSet = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet reducedSet = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[2]);
        PrototypeGenerator gen = new PrototypeGenerator(reducedSet);
        gen.execute();
        int accuracy1NN = KNN.classficationAccuracy1NN(reducedSet, test);
        String data = gen.getResults(Parameters.getFileName(), algoName, accuracy1NN, trainingSet.size(), test);
        if (append) {
            KeelFile.append(outputFile, data);
        } else {
            KeelFile.write(outputFile, data);
        }
        System.out.flush();
    }
}

