/*
 * Decompiled with CFR 0.152.
 */
package keel.Dataset;

import java.util.Vector;

public class Attribute {
    public static final int NOMINAL = 0;
    public static final int INTEGER = 1;
    public static final int REAL = 2;
    public static final int INPUT = 1;
    public static final int OUTPUT = 2;
    public static final int DIR_NOT_DEF = -1;
    private int dirAttribute = -1;
    private int type = -1;
    private String name;
    private Vector nominalValues;
    private double min;
    private double max;
    private boolean firstTime;
    private boolean fixedBounds;
    private int countValues = 0;
    private boolean newValuesInTest;
    private Vector newValuesList;
    private int[][] classFrequencies;
    private String[] mostUsedValue;
    private double[] meanValue;
    private int[] numStatUpdates;
    private boolean makeStatistics = false;

    public void setType(int _type) {
        if (this.type != -1) {
            System.err.println("Type already fixed !!");
            System.exit(1);
        }
        this.type = _type;
        this.firstTime = true;
        if (this.type == 0) {
            this.nominalValues = new Vector();
            this.newValuesList = new Vector();
        }
        this.fixedBounds = false;
    }

    public int getType() {
        return this.type;
    }

    public void setName(String _name) {
        this.name = _name;
    }

    public String getName() {
        return this.name;
    }

    public void setBounds(double _min, double _max) {
        if (this.type != 2 && this.type != 1) {
            return;
        }
        this.fixedBounds = true;
        this.min = _min;
        this.max = _max;
    }

    public boolean getFixedBounds() {
        return this.fixedBounds;
    }

    public void setFixedBounds(boolean fBounds) {
        this.fixedBounds = fBounds;
    }

    public void enlargeBounds(double value) {
        if (this.type != 2 && this.type != 1) {
            return;
        }
        if (this.firstTime) {
            if (!this.fixedBounds) {
                this.min = value;
                this.max = value;
            }
            this.firstTime = false;
        }
        ++this.countValues;
        if (this.fixedBounds) {
            return;
        }
        if (value < this.min) {
            this.min = value;
        }
        if (value > this.max) {
            this.max = value;
        }
    }

    public double rectifyValueInBounds(double value) {
        if (value < this.min) {
            return this.min;
        }
        if (value > this.max) {
            return this.max;
        }
        return value;
    }

    public boolean isInBounds(double val) {
        return val >= this.min && val <= this.max;
    }

    public boolean isNominalValue(String val) {
        return this.nominalValues.contains(val);
    }

    public double getMinAttribute() {
        return this.min;
    }

    public double getMaxAttribute() {
        return this.max;
    }

    public void addNominalValue(String value) {
        if (this.type != 0) {
            return;
        }
        if (!this.nominalValues.contains(value)) {
            this.nominalValues.addElement(new String(value));
        }
    }

    public String getMostFrequentValue(int whichClass) {
        if (!this.makeStatistics || this.type != 0 || this.mostUsedValue == null) {
            return null;
        }
        if (whichClass < 0 || whichClass >= this.mostUsedValue.length) {
            return null;
        }
        return this.mostUsedValue[whichClass];
    }

    public double getMeanValue(int whichClass) {
        if (!this.makeStatistics || this.type != 2 && this.type != 1 || this.meanValue == null) {
            return 0.0;
        }
        if (whichClass < 0 || whichClass >= this.meanValue.length) {
            return 0.0;
        }
        return this.meanValue[whichClass];
    }

    void initStatistics(int classNumber) {
        this.makeStatistics = true;
        if (this.type == 0) {
            this.classFrequencies = new int[classNumber][];
            this.numStatUpdates = new int[classNumber];
            for (int i = 0; i < classNumber; ++i) {
                this.numStatUpdates[i] = 0;
                this.classFrequencies[i] = new int[this.nominalValues.size()];
                for (int j = 0; j < this.nominalValues.size(); ++j) {
                    this.classFrequencies[i][j] = 0;
                }
            }
        } else {
            this.meanValue = new double[classNumber];
            this.numStatUpdates = new int[classNumber];
            for (int i = 0; i < classNumber; ++i) {
                this.meanValue[i] = 0.0;
                this.numStatUpdates[i] = 0;
            }
        }
    }

    void finishStatistics() {
        if (!this.makeStatistics) {
            return;
        }
        if (this.type == 0) {
            this.mostUsedValue = new String[this.classFrequencies.length];
            for (int i = 0; i < this.mostUsedValue.length; ++i) {
                int max = this.classFrequencies[i][0];
                int pos = 0;
                for (int j = 1; j < this.classFrequencies[i].length; ++j) {
                    if (this.classFrequencies[i][j] <= max) continue;
                    max = this.classFrequencies[i][j];
                    pos = j;
                }
                this.mostUsedValue[i] = (String)this.nominalValues.elementAt(pos);
            }
        } else {
            for (int i = 0; i < this.meanValue.length; ++i) {
                int n = i;
                this.meanValue[n] = this.meanValue[n] / (double)this.numStatUpdates[i];
            }
        }
    }

    void increaseClassFrequency(int whichClass, String value) {
        if (this.makeStatistics && this.classFrequencies != null && this.classFrequencies[whichClass] != null && this.classFrequencies[whichClass] != null) {
            int[] nArray = this.classFrequencies[whichClass];
            int n = this.convertNominalValue(value);
            nArray[n] = nArray[n] + 1;
            int n2 = whichClass;
            this.numStatUpdates[n2] = this.numStatUpdates[n2] + 1;
        }
    }

    public void addInMeanValue(int whichClass, double value) {
        if (this.makeStatistics) {
            int n = whichClass;
            this.numStatUpdates[n] = this.numStatUpdates[n] + 1;
            int n2 = whichClass;
            this.meanValue[n2] = this.meanValue[n2] + value;
        }
    }

    public boolean addTestNominalValue(String value) {
        if (this.type != 0) {
            return false;
        }
        if (!this.nominalValues.contains(value)) {
            this.nominalValues.addElement(new String(value));
            this.newValuesList.addElement(new String(value));
            this.newValuesInTest = true;
            return true;
        }
        return false;
    }

    public Vector getNewValuesInTest() {
        return this.newValuesList;
    }

    public boolean areNewNominalValuesInTest() {
        return this.newValuesInTest;
    }

    public int getNumNominalValues() {
        if (this.type != 0) {
            return -1;
        }
        return this.nominalValues.size();
    }

    public Vector getNominalValuesList() {
        return this.nominalValues;
    }

    public String getNominalValue(int pos) {
        if (this.type != 0) {
            return null;
        }
        return (String)this.nominalValues.elementAt(pos);
    }

    public int convertNominalValue(String value) {
        return this.nominalValues.indexOf(value);
    }

    public boolean equals(Attribute attr) {
        if (!this.name.equals(attr.name)) {
            return false;
        }
        if (attr.type != this.type) {
            return false;
        }
        return this.type != 0 || this.nominalValues.equals(attr.nominalValues);
    }

    public void setDirectionAttribute(int _dirAtt) {
        this.dirAttribute = _dirAtt;
    }

    public int getDirectionAttribute() {
        return this.dirAttribute;
    }

    public double normalizeValue(double val) {
        if (this.type == 0) {
            return val;
        }
        if (this.type == 1) {
            return val - this.min;
        }
        if (this.type == 2) {
            return (val - this.min) / (this.max - this.min);
        }
        return val;
    }

    public String toString() {
        String[] typeNames = new String[]{"", "integer", "real"};
        String aux = "@attribute " + this.name;
        switch (this.type) {
            case 0: {
                aux = aux + "{";
                String ending = ",";
                for (int i = 0; i < this.nominalValues.size(); ++i) {
                    if (i == this.nominalValues.size() - 1) {
                        ending = "";
                    }
                    aux = aux + (String)this.nominalValues.elementAt(i) + ending;
                }
                aux = aux + '}';
                break;
            }
            case 1: {
                aux = aux + " integer[" + new Integer((int)this.min).toString();
                aux = aux + "," + new Integer((int)this.max).toString() + "]";
                break;
            }
            case 2: {
                aux = aux + " real[" + new Double(this.min).toString();
                aux = aux + "," + new Double(this.max).toString() + "]";
            }
        }
        return aux;
    }

    public void print() {
        int i;
        String[] typesConv = new String[]{"Nominal", "Integer", "Real"};
        System.out.println("    > Name: " + this.name + ".");
        System.out.println("    > Type: " + this.type);
        System.out.println("    > Type: " + typesConv[this.type] + ".");
        System.out.print("    > Input/Output: ");
        switch (this.dirAttribute) {
            case 1: {
                System.out.println("INPUT");
                break;
            }
            case 2: {
                System.out.println("OUTPUT");
                break;
            }
            default: {
                System.out.println("NOT DEFINED");
            }
        }
        System.out.print("    > Range: ");
        switch (this.type) {
            case 0: {
                System.out.print("{");
                for (i = 0; i < this.nominalValues.size(); ++i) {
                    System.out.print((String)this.nominalValues.elementAt(i) + "  ");
                }
                System.out.print("}");
                break;
            }
            case 1: {
                System.out.print("[" + (int)this.min + "," + (int)this.max + "]");
                break;
            }
            default: {
                System.out.print("[" + this.min + "," + this.max + "]");
            }
        }
        if (this.type == 0) {
            if (this.mostUsedValue != null) {
                System.out.println("\n    > Most used value: ");
                for (i = 0; i < this.mostUsedValue.length; ++i) {
                    System.out.print("       > class " + i + ":" + this.mostUsedValue[i]);
                    System.out.println("  (" + this.classFrequencies[i][this.convertNominalValue(this.mostUsedValue[i])] + ").");
                }
            }
        } else if (this.meanValue != null) {
            System.out.println("\n    > Mean used value: ");
            for (i = 0; i < this.meanValue.length; ++i) {
                System.out.println("       > class " + i + ": " + this.meanValue[i]);
            }
        }
        System.out.println();
    }
}

