/*
 * Decompiled with CFR 0.152.
 */
package javolution.realtime;

import javolution.realtime.Context;
import javolution.util.StandardLog;

public abstract class LogContext
extends Context {
    public static final StandardLog STANDARD = new StandardLog();
    public static final LogContext NULL = new NullLog();
    public static final LogContext SYSTEM = new SystemLog();
    public static final LogContext SYSTEM_ERR = new SystemErrLog();
    private static volatile LogContext Default = STANDARD;

    public static LogContext current() {
        for (Context context = Context.current(); context != null; context = context.getOuter()) {
            if (!(context instanceof LogContext)) continue;
            return (LogContext)context;
        }
        return Default;
    }

    public static LogContext getDefault() {
        return Default;
    }

    public static void setDefault(LogContext logContext) {
        Default = logContext;
    }

    public static void info(CharSequence charSequence) {
        LogContext logContext = LogContext.current();
        logContext.logInfo(charSequence);
    }

    public static void warning(CharSequence charSequence) {
        LogContext logContext = LogContext.current();
        logContext.logWarning(charSequence);
    }

    public static void error(Throwable throwable) {
        LogContext logContext = LogContext.current();
        logContext.logError(throwable, null);
    }

    public static void error(Throwable throwable, CharSequence charSequence) {
        LogContext logContext = LogContext.current();
        logContext.logError(throwable, charSequence);
    }

    public abstract boolean isInfoLogged();

    public abstract void logInfo(CharSequence var1);

    public abstract boolean isWarningLogged();

    public abstract void logWarning(CharSequence var1);

    public abstract boolean isErrorLogged();

    public abstract void logError(Throwable var1, CharSequence var2);

    protected void enterAction() {
    }

    protected void exitAction() {
    }

    private static class SystemErrLog
    extends LogContext {
        private SystemErrLog() {
        }

        public boolean isInfoLogged() {
            return false;
        }

        public boolean isWarningLogged() {
            return true;
        }

        public boolean isErrorLogged() {
            return true;
        }

        public void logInfo(CharSequence charSequence) {
        }

        public void logWarning(CharSequence charSequence) {
            System.err.print("[warning] ");
            System.err.println(charSequence);
        }

        public void logError(Throwable throwable, CharSequence charSequence) {
            System.err.print("[error] ");
            System.err.print(throwable.getClass().getName());
            if (charSequence != null) {
                System.err.print(" - ");
                System.err.println(charSequence);
            } else {
                String string = throwable.getMessage();
                if (string != null) {
                    System.err.print(" - ");
                    System.err.println(string);
                } else {
                    System.err.println();
                }
            }
            throwable.printStackTrace();
        }
    }

    private static class SystemLog
    extends LogContext {
        private SystemLog() {
        }

        public boolean isInfoLogged() {
            return true;
        }

        public boolean isWarningLogged() {
            return true;
        }

        public boolean isErrorLogged() {
            return true;
        }

        public void logInfo(CharSequence charSequence) {
            System.out.print("[info] ");
            System.out.println(charSequence);
        }

        public void logWarning(CharSequence charSequence) {
            System.err.print("[warning] ");
            System.err.println(charSequence);
        }

        public void logError(Throwable throwable, CharSequence charSequence) {
            System.err.print("[error] ");
            System.err.print(throwable.getClass().getName());
            if (charSequence != null) {
                System.err.print(" - ");
                System.err.println(charSequence);
            } else {
                String string = throwable.getMessage();
                if (string != null) {
                    System.err.print(" - ");
                    System.err.println(string);
                } else {
                    System.err.println();
                }
            }
            throwable.printStackTrace();
        }
    }

    private static class NullLog
    extends LogContext {
        private NullLog() {
        }

        public boolean isInfoLogged() {
            return false;
        }

        public boolean isWarningLogged() {
            return false;
        }

        public boolean isErrorLogged() {
            return false;
        }

        public void logInfo(CharSequence charSequence) {
        }

        public void logWarning(CharSequence charSequence) {
        }

        public void logError(Throwable throwable, CharSequence charSequence) {
        }
    }
}

