/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import uk.ac.rhul.cs.utils.Multimap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultimapBase<K, V>
implements Multimap<K, V> {
    protected Map<K, Collection<V>> data;

    public MultimapBase() {
        this.initializeStorage();
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        Collection<V> values = this.data.get(key);
        return values != null && values.size() > 0;
    }

    @Override
    public Collection<V> get(K key) {
        Collection<V> values = this.data.get(key);
        if (values == null) {
            return Collections.emptyList();
        }
        return values;
    }

    @Override
    public Set<K> keySet() {
        return this.data.keySet();
    }

    protected abstract void initializeStorage();

    @Override
    public boolean isEmpty() {
        for (Map.Entry<K, Collection<V>> pair : this.data.entrySet()) {
            if (pair.getValue().isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean put(K key, V value) {
        Collection<V> values = this.data.get(key);
        if (values == null) {
            values = new TreeSet<V>();
            this.data.put(key, values);
        }
        values.add(value);
        return true;
    }

    @Override
    public boolean remove(Object key, Object value) {
        Collection<V> values = this.data.get(key);
        if (values == null) {
            return false;
        }
        boolean result = values.remove(value);
        if (result && values.isEmpty()) {
            this.data.remove(key);
        }
        return result;
    }

    @Override
    public Collection<V> removeAll(Object key) {
        Collection<V> values = this.data.remove(key);
        if (values == null) {
            return Collections.emptyList();
        }
        return values;
    }
}

