/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.graph;

import com.sosnoski.util.array.DoubleArray;
import com.sosnoski.util.array.IntArray;
import com.sosnoski.util.array.StringArray;
import com.sosnoski.util.hashmap.ObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import uk.ac.rhul.cs.graph.Directedness;
import uk.ac.rhul.cs.graph.Edge;
import uk.ac.rhul.cs.graph.EdgeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph
implements Iterable<Edge> {
    protected boolean directed = false;
    protected int numberOfNodes = 0;
    protected StringArray nodeNames = new StringArray();
    protected IntArray edgesOut = new IntArray();
    protected IntArray edgesIn = new IntArray();
    protected DoubleArray weights = new DoubleArray();
    protected ArrayList<IntArray> outEdgeAdjacencyLists = new ArrayList();
    protected ArrayList<IntArray> inEdgeAdjacencyLists = new ArrayList();

    public Graph() {
        this(false);
    }

    public Graph(boolean directed) {
        this.directed = directed;
    }

    public boolean isDirected() {
        return this.directed;
    }

    public boolean isWeighted() {
        if (this.weights.size() == 0) {
            return false;
        }
        double firstWeight = this.weights.get(0);
        for (int i = 1; i < this.weights.size(); ++i) {
            if (this.weights.get(i) == firstWeight) continue;
            return true;
        }
        return false;
    }

    public boolean areConnected(int source, int target) {
        IntArray edges = this.outEdgeAdjacencyLists.get(source);
        int n = edges.size();
        for (int i = 0; i < n; ++i) {
            int edge = edges.get(i);
            if (this.edgesIn.get(edge) != target) continue;
            return true;
        }
        return false;
    }

    public int createNode() {
        return this.createNode(null);
    }

    public int createNode(String name) {
        ++this.numberOfNodes;
        this.outEdgeAdjacencyLists.add(new IntArray());
        this.inEdgeAdjacencyLists.add(new IntArray());
        this.nodeNames.add(name);
        return this.numberOfNodes - 1;
    }

    public int[] createNodes(int new_node_count) {
        int[] result = new int[new_node_count];
        int n = this.numberOfNodes;
        for (int i = 0; i < new_node_count; ++i) {
            this.outEdgeAdjacencyLists.add(new IntArray());
            this.inEdgeAdjacencyLists.add(new IntArray());
            this.nodeNames.add(null);
            result[i] = n + i;
        }
        this.numberOfNodes += new_node_count;
        return result;
    }

    public int createEdge(int src, int dest) {
        return this.createEdge(src, dest, 1.0);
    }

    public int createEdge(int src, int dest, double weight) {
        if (src >= this.numberOfNodes) {
            this.createNodes(src - this.numberOfNodes + 1);
        }
        if (dest >= this.numberOfNodes) {
            this.createNodes(dest - this.numberOfNodes + 1);
        }
        int edgeID = this.edgesOut.size();
        this.edgesOut.add(src);
        this.edgesIn.add(dest);
        this.weights.add(weight);
        this.outEdgeAdjacencyLists.get(src).add(edgeID);
        this.inEdgeAdjacencyLists.get(dest).add(edgeID);
        if (!this.directed) {
            this.outEdgeAdjacencyLists.get(dest).add(edgeID);
            this.inEdgeAdjacencyLists.get(src).add(edgeID);
        }
        return edgeID;
    }

    public int getNodeCount() {
        return this.numberOfNodes;
    }

    public int getEdgeCount() {
        return this.edgesOut.size();
    }

    public int[] getAdjacentNodeIndicesArray(int nodeIndex, Directedness mode) {
        int[] edges = this.getAdjacentEdgeIndicesArray(nodeIndex, mode);
        int i = 0;
        int n = edges.length;
        for (i = 0; i < n; ++i) {
            int edge = edges[i];
            edges[i] = this.edgesIn.get(edge) == nodeIndex ? this.edgesOut.get(edge) : this.edgesIn.get(edge);
        }
        return edges;
    }

    public int[] getAdjacentEdgeIndicesArray(int nodeIndex, Directedness mode) {
        if (!this.directed || mode == Directedness.OUT) {
            return this.outEdgeAdjacencyLists.get(nodeIndex).toArray();
        }
        if (mode == Directedness.IN) {
            return this.inEdgeAdjacencyLists.get(nodeIndex).toArray();
        }
        int[] outEdgesArray = this.outEdgeAdjacencyLists.get(nodeIndex).toArray();
        int[] inEdgesArray = this.inEdgeAdjacencyLists.get(nodeIndex).toArray();
        int i = outEdgesArray.length;
        int n = i + inEdgesArray.length;
        int j = 0;
        int[] result = new int[n];
        result = Arrays.copyOf(outEdgesArray, n);
        while (i < n) {
            result[i] = inEdgesArray[j];
            ++i;
            ++j;
        }
        return result;
    }

    public String getNodeName(int nodeIndex) {
        return this.nodeNames.get(nodeIndex);
    }

    public String[] getNodeNames() {
        return this.nodeNames.toArray();
    }

    public ObjectIntHashMap getNodeNameHashMap() {
        ObjectIntHashMap map = new ObjectIntHashMap();
        String[] nodeNames = this.getNodeNames();
        for (int i = 0; i < this.numberOfNodes; ++i) {
            map.add(nodeNames[i], i);
        }
        return map;
    }

    public double getEdgeWeight(int edgeIndex) {
        return this.weights.get(edgeIndex);
    }

    public double[] getEdgeWeights() {
        return this.weights.toArray();
    }

    public int getEdgeEndpoint(int edgeIndex, int knownVertex) {
        int idx = this.edgesOut.get(edgeIndex);
        if (idx == knownVertex) {
            return this.edgesIn.get(edgeIndex);
        }
        return idx;
    }

    @Override
    public Iterator<Edge> iterator() {
        return new EdgeIterator(this);
    }

    public List<Edge> getEdgeList() {
        ArrayList<Edge> result = new ArrayList<Edge>(this.getEdgeCount());
        for (Edge edge : this) {
            result.add(edge);
        }
        return result;
    }

    public int getDegree(int nodeIndex) {
        return this.getDegree(nodeIndex, Directedness.ALL);
    }

    public int getDegree(int nodeIndex, Directedness mode) {
        if (!this.directed || mode == Directedness.OUT) {
            return this.outEdgeAdjacencyLists.get(nodeIndex).size();
        }
        if (mode == Directedness.IN) {
            return this.inEdgeAdjacencyLists.get(nodeIndex).size();
        }
        return this.outEdgeAdjacencyLists.get(nodeIndex).size() + this.inEdgeAdjacencyLists.get(nodeIndex).size();
    }

    public double getStrength(int nodeIndex) {
        return this.getStrength(nodeIndex, Directedness.ALL);
    }

    public double getStrength(int nodeIndex, Directedness mode) {
        IntArray neis = null;
        double result = 0.0;
        if (!this.directed || mode != Directedness.IN) {
            neis = this.outEdgeAdjacencyLists.get(nodeIndex);
            for (int eidx : neis.toArray()) {
                result += this.weights.get(eidx);
            }
        }
        if (this.directed && mode == Directedness.IN) {
            neis = this.inEdgeAdjacencyLists.get(nodeIndex);
            for (int eidx : neis.toArray()) {
                result += this.weights.get(eidx);
            }
        }
        return result;
    }
}

