/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class CollapsiblePanel
extends JPanel {
    protected JLabel headerLabel = null;
    protected JComponent component = null;
    private Icon collapsedIcon = this.loadIcon("plus.gif");
    private Icon expandedIcon = this.loadIcon("minus.gif");

    public CollapsiblePanel() {
        this("");
    }

    public CollapsiblePanel(String title) {
        this(title, true);
    }

    public CollapsiblePanel(String title, boolean expanded) {
        this(new JPanel(), title, expanded);
    }

    public CollapsiblePanel(JComponent component, String title) {
        this(component, title, true);
    }

    public CollapsiblePanel(JComponent component, String title, boolean expanded) {
        super.setLayout(new BorderLayout());
        this.headerLabel = new JLabel(title);
        this.headerLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.headerLabel.setFont(this.headerLabel.getFont().deriveFont(1));
        super.add((Component)this.headerLabel, "North");
        this.setWrappedComponent(component);
        this.setExpanded(expanded);
        this.headerLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                CollapsiblePanel.this.setExpanded(!CollapsiblePanel.this.isExpanded());
            }
        });
    }

    public Component add(Component comp) {
        return this.component.add(comp);
    }

    public Component add(Component comp, int index) {
        return this.component.add(comp, index);
    }

    public void add(Component comp, Object constraints) {
        this.component.add(comp, constraints);
    }

    public void add(Component comp, Object constraints, int index) {
        this.component.add(comp, constraints, index);
    }

    public Icon getCollapsedIcon() {
        return this.collapsedIcon;
    }

    public Icon getExpandedIcon() {
        return this.expandedIcon;
    }

    public JComponent getWrappedComponent() {
        return this.component;
    }

    protected ImageIcon loadIcon(String name) {
        URL url = CollapsiblePanel.class.getResource("resources/" + name);
        if (url == null) {
            url = CollapsiblePanel.class.getResource("../resources/" + name);
        }
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }

    public boolean isExpanded() {
        if (this.component == null) {
            return false;
        }
        return this.component.isVisible();
    }

    public void setBorder(Border border) {
        if (this.component != null) {
            this.component.setBorder(border);
        }
    }

    public void setCollapsedIcon(Icon icon) {
        this.collapsedIcon = icon;
        this.refreshIcon();
    }

    public void setExpandedIcon(Icon icon) {
        this.expandedIcon = icon;
        this.refreshIcon();
    }

    public void setLayout(LayoutManager mgr) {
        if (this.component != null) {
            this.component.setLayout(mgr);
        }
    }

    public void setWrappedComponent(JComponent component) {
        this.component = component;
        super.add((Component)component, "Center");
    }

    public void setExpanded(boolean expanded) {
        if (this.component != null) {
            this.component.setVisible(expanded);
        }
        this.refreshIcon();
    }

    private void refreshIcon() {
        this.headerLabel.setIcon(this.isExpanded() ? this.expandedIcon : this.collapsedIcon);
    }
}

