/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIdcb;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CResultSetAccessor
extends ResultSetAccessor {
    T4CMAREngine mare;
    OracleStatement[] newstmt = null;
    byte[] empty = new byte[]{0};
    boolean underlyingLongRaw = false;

    T4CResultSetAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, s2, n3, bl);
        this.mare = t4CMAREngine;
    }

    T4CResultSetAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2, int n8, int n9, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2 == -1 ? n9 : n2, bl, n3, n4, n5, n6, n7, s2);
        this.mare = t4CMAREngine;
        if (oracleStatement != null && oracleStatement.implicitDefineForLobPrefetchDone) {
            this.definedColumnType = 0;
            this.definedColumnSize = 0;
        } else {
            this.definedColumnType = n8;
            this.definedColumnSize = n9;
        }
        if (n2 == -1) {
            this.underlyingLongRaw = true;
        }
    }

    public T4CMAREngine getMAREngine() {
        return this.mare;
    }

    public void unmarshalColumnMetadata() throws SQLException, IOException {
        if (this.statement.statementType != 2 && !this.statement.sqlKind.isPlsqlOrCall() && this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
            this.setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
        }
    }

    public void processIndicator(int n2) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalSB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(n2 <= 0, n2);
        }
    }

    @Override
    int getPreviousRowProcessed() {
        if (this.previousRowProcessed == -1) {
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        }
        return this.previousRowProcessed;
    }

    @Override
    void reinitForResultSetCache(ByteArray byteArray, OracleStatement oracleStatement) throws SQLException {
        this.rowData = byteArray;
        this.mare = ((T4CConnection)oracleStatement.connection).mare;
        this.rowNull = null;
        this.setCapacity(oracleStatement.getFetchSize());
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        boolean bl = false;
        if (!this.isUseless()) {
            if (this.isUnexpected()) {
                long l2 = this.rowData.getPosition();
                this.unmarshalColumnMetadata();
                this.unmarshalBytes();
                this.rowData.setPosition(l2);
                this.setNull(this.lastRowProcessed, true);
            } else if (this.isNullByDescribe()) {
                this.setNull(this.lastRowProcessed, true);
                this.unmarshalColumnMetadata();
                if (this.statement.connection.versionNumber < 9200) {
                    this.processIndicator(0);
                }
            } else {
                this.unmarshalColumnMetadata();
                bl = this.unmarshalBytes();
            }
        }
        this.previousRowProcessed = this.lastRowProcessed++;
        return bl;
    }

    @Override
    void copyRow() throws SQLException, IOException {
        if (this.isNullByDescribe || this.previousRowProcessed == -1) {
            this.setNull(this.lastRowProcessed, true);
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        } else if (this.lastRowProcessed == 0) {
            if (this.previousRowProcessed == -1) {
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            }
            long l2 = this.getOffset(this.previousRowProcessed);
            this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
            if (!this.isNull(this.previousRowProcessed)) {
                this.setOffset(this.lastRowProcessed);
                ((DynamicByteArray)this.rowData).copyLeft(l2, this.getLength(this.previousRowProcessed));
                this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
            }
        } else if (this.lastCopyRow == this.previousRowProcessed) {
            this.setNull(this.lastRowProcessed, this.lastCopyRowIsNull);
            this.rowMetadata[this.lastRowProcessed] = this.lastCopyRowMetaData;
            this.setOffset(this.lastRowProcessed, this.lastCopyRowOffset);
            this.setLength(this.lastRowProcessed, this.lastCopyRowLength);
        } else {
            this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
            this.setOffset(this.lastRowProcessed, this.getOffset(this.previousRowProcessed));
            this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
        }
        this.previousRowProcessed = this.lastRowProcessed++;
    }

    @Override
    void setCapacity(int n2) {
        super.setCapacity(n2);
        if (this.newstmt == null || this.newstmt.length < n2) {
            OracleStatement[] oracleStatementArray = new OracleStatement[n2];
            if (this.newstmt != null) {
                System.arraycopy(this.newstmt, 0, oracleStatementArray, 0, this.newstmt.length);
            }
            this.newstmt = oracleStatementArray;
        }
    }

    @Override
    void insertNull(int n2) throws SQLException {
        System.arraycopy(this.newstmt, n2, this.newstmt, n2 + 1, this.newstmt.length - n2 - 1);
        super.insertNull(n2);
    }

    @Override
    Accessor copyForDefine(OracleStatement oracleStatement) {
        T4CResultSetAccessor t4CResultSetAccessor = (T4CResultSetAccessor)super.copyForDefine(oracleStatement);
        t4CResultSetAccessor.newstmt = null;
        return t4CResultSetAccessor;
    }

    @Override
    protected void copyFromInternal(Accessor accessor, int n2, int n3) throws SQLException {
        super.copyFromInternal(accessor, n2, n3);
        this.newstmt[n3] = ((T4CResultSetAccessor)accessor).newstmt[n2];
    }

    @Override
    void deleteRow(int n2) throws SQLException {
        super.deleteRow(n2);
        if (this.newstmt[n2] != null) {
            this.newstmt[n2].close();
        }
        this.delete(this.newstmt, n2);
    }

    boolean unmarshalBytes() throws SQLException, IOException {
        this.newstmt[this.lastRowProcessed] = this.statement.connection.RefCursorBytesToStatement(this.empty, this.statement);
        this.newstmt[this.lastRowProcessed].needToSendOalToFetch = true;
        T4CTTIdcb t4CTTIdcb = new T4CTTIdcb((T4CConnection)this.statement.connection);
        t4CTTIdcb.init(this.newstmt[this.lastRowProcessed], 0);
        this.newstmt[this.lastRowProcessed].accessors = t4CTTIdcb.receiveFromRefCursor(this.newstmt[this.lastRowProcessed].accessors);
        this.newstmt[this.lastRowProcessed].numberOfDefinePositions = this.newstmt[this.lastRowProcessed].accessors.length;
        this.newstmt[this.lastRowProcessed].describedWithNames = true;
        this.newstmt[this.lastRowProcessed].described = true;
        int n2 = (int)this.mare.unmarshalUB4();
        this.newstmt[this.lastRowProcessed].setCursorId(n2);
        if (n2 > 0) {
            this.rowData.putShort((short)n2);
            this.setLength(this.lastRowProcessed, 2);
            this.processIndicator(2);
        } else {
            this.newstmt[this.lastRowProcessed].close();
            this.newstmt[this.lastRowProcessed] = null;
            this.setNull(this.lastRowProcessed, true);
            this.processIndicator(0);
        }
        return false;
    }

    @Override
    ResultSet getCursor(int n2) throws SQLException {
        OracleResultSet oracleResultSet = null;
        if (this.newstmt[n2] != null) {
            OracleResultSet oracleResultSet2;
            for (int i2 = 0; i2 < this.newstmt[n2].numberOfDefinePositions; ++i2) {
                this.newstmt[n2].accessors[i2].initMetadata();
            }
            this.newstmt[n2].prepareAccessors();
            this.newstmt[n2].setPrefetchInternal(this.statement.getFetchSize(), false, false);
            this.newstmt[n2].closeOnCompletion();
            this.newstmt[n2].currentResultSet = oracleResultSet2 = this.newstmt[n2].createResultSet();
            oracleResultSet = oracleResultSet2;
        }
        return oracleResultSet;
    }
}

