/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.BLASkernel;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Interface;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.UnitLowerTriangDenseMatrix;
import no.uib.cipr.matrix.UpperTriangDenseMatrix;

public class DenseLU {
    private DenseMatrix LU;
    private int[] piv;
    private boolean singular;

    public DenseLU(int m, int n) {
        this.LU = new DenseMatrix(m, n);
        this.piv = new int[Math.min(m, n)];
    }

    public static DenseLU factorize(Matrix A) {
        return new DenseLU(A.numRows(), A.numColumns()).factor(new DenseMatrix(A));
    }

    public DenseLU factor(DenseMatrix A) {
        this.singular = false;
        int info = Interface.lapack().getrf(A.numRows(), A.numColumns(), A.getData(), this.piv);
        if (info > 0) {
            this.singular = true;
        } else if (info < 0) {
            throw new IllegalArgumentException();
        }
        this.LU.set(A);
        return this;
    }

    public UnitLowerTriangDenseMatrix getL() {
        return new UnitLowerTriangDenseMatrix((Matrix)this.LU, false);
    }

    public UpperTriangDenseMatrix getU() {
        return new UpperTriangDenseMatrix((Matrix)this.LU, false);
    }

    public DenseMatrix getLU() {
        return this.LU;
    }

    public double rcond(Matrix A, Matrix.Norm norm) {
        if (norm != Matrix.Norm.One && norm != Matrix.Norm.Infinity) {
            throw new IllegalArgumentException("Only the 1 or the Infinity norms are supported");
        }
        double anorm = A.norm(norm);
        int n = A.numRows();
        double[] rcond = new double[1];
        int info = Interface.lapack().gecon(norm, n, this.LU.getData(), anorm, rcond, new double[4 * n], new int[n]);
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        return rcond[0];
    }

    public int[] getPivots() {
        return this.piv;
    }

    public boolean isSingular() {
        return this.singular;
    }

    public DenseMatrix solve(DenseMatrix B) throws MatrixSingularException {
        return this.solve(B, BLASkernel.Transpose.NoTranspose);
    }

    public DenseMatrix transSolve(DenseMatrix B) throws MatrixSingularException {
        return this.solve(B, BLASkernel.Transpose.Transpose);
    }

    private DenseMatrix solve(DenseMatrix B, BLASkernel.Transpose trans) throws MatrixSingularException {
        if (this.singular) {
            throw new MatrixSingularException();
        }
        if (B.numRows() != this.LU.numRows()) {
            throw new IllegalArgumentException("B.numRows() != LU.numRows()");
        }
        int info = Interface.lapack().getrs(trans, this.LU.numRows(), B.numColumns(), this.LU.getData(), this.piv, B.getData());
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        return B;
    }
}

