/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.matrixAlgebra.Vector;

public class ComplexArray {
    public final double[] real;
    public final double[] complex;
    public final int length;

    public ComplexArray(double[] dArray) {
        this(dArray, new double[dArray.length]);
    }

    public ComplexArray(double[] dArray, double[] dArray2) {
        this.real = dArray;
        this.complex = dArray2;
        this.length = dArray.length;
    }

    public void conjugate() {
        for (int i = 0; i < this.length; ++i) {
            this.complex[i] = -this.complex[i];
        }
    }

    public ComplexArray product(ComplexArray complexArray) {
        double[] dArray = new double[this.length];
        double[] dArray2 = new double[this.length];
        for (int i = 0; i < this.length; ++i) {
            double d = this.real[i];
            double d2 = this.complex[i];
            double d3 = complexArray.real[i];
            double d4 = complexArray.complex[i];
            dArray[i] = d * d3 - d2 * d4;
            dArray2[i] = d * d4 + d2 * d3;
        }
        return new ComplexArray(dArray, dArray2);
    }

    public String toString() {
        return "\nReal   : " + new Vector(this.real).toString() + "\nComplex: " + new Vector(this.complex).toString();
    }

    public static double[] interleave(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double[] dArray3 = new double[n * 2];
        for (int i = 0; i < n; ++i) {
            dArray3[2 * i] = dArray[i];
            dArray3[2 * i + 1] = dArray2[i];
        }
        return dArray3;
    }
}

