/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.multidimensionalscaling;

import dr.inference.multidimensionalscaling.MultiDimensionalScalingCore;
import dr.inference.multidimensionalscaling.NativeMDSSingleton;

public class MassivelyParallelMDSImpl
implements MultiDimensionalScalingCore {
    private NativeMDSSingleton singleton = NativeMDSSingleton.loadLibrary();
    private int instance = -1;
    private final MultiDimensionalScalingCore.CoreInformation information = new MultiDimensionalScalingCore.CoreInformation();
    private int observationCount;
    private double precision;
    private double storedPrecision;
    private static final boolean CHECK_GRADIENT = false;
    private static final boolean CHECK_GRADIENT_KILL = true;

    MassivelyParallelMDSImpl() {
        String string;
        String string2 = System.getProperty("mds.resource");
        if (string2 != null) {
            try {
                int n = Integer.parseInt(string2);
                if (n > 0) {
                    this.information.deviceNumber = n - 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Unable to parse 'mds.resource' environmental property");
            }
        }
        if ((string = System.getProperty("mds.threads")) != null) {
            try {
                this.information.numThreads = Integer.parseInt(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Unable to parse 'mds.threads' environmental property");
            }
        }
    }

    @Override
    public void initialize(int n, int n2, long l) {
        this.information.flags = l;
        this.instance = this.singleton.initialize(n, n2, this.information);
        this.observationCount = n2 * (n2 - 1) / 2;
    }

    @Override
    public void setPairwiseData(double[] dArray) {
        this.singleton.setPairwiseData(this.instance, dArray);
    }

    @Override
    public void setParameters(double[] dArray) {
        this.precision = dArray[0];
        this.singleton.setParameters(this.instance, dArray);
    }

    @Override
    public double[] getPairwiseData() {
        return this.singleton.getPairwiseData(this.instance);
    }

    @Override
    public void updateLocation(int n, double[] dArray) {
        this.singleton.updateLocations(this.instance, n, dArray);
    }

    @Override
    public double calculateLogLikelihood() {
        double d = this.singleton.getSumOfIncrements(this.instance);
        return 0.5 * (Math.log(this.precision) - Math.log(Math.PI * 2)) * (double)this.observationCount - d;
    }

    @Override
    public void storeState() {
        this.singleton.storeState(this.instance);
        this.storedPrecision = this.precision;
    }

    @Override
    public void restoreState() {
        this.singleton.restoreState(this.instance);
        this.precision = this.storedPrecision;
    }

    @Override
    public void acceptState() {
        this.singleton.acceptState(this.instance);
    }

    @Override
    public void getGradient(double[] dArray) {
        this.singleton.getLocationGradient(this.instance, dArray);
    }

    @Override
    public void makeDirty() {
        this.singleton.makeDirty(this.instance);
    }

    @Override
    public int getInternalDimension() {
        return this.singleton.getInternalDimension(this.instance);
    }
}

