/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.discrete;

import dr.evolution.tree.Tree;
import dr.evomodel.siteratemodel.SiteRateModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.evomodel.treedatalikelihood.BeagleDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.preorder.AbstractDiscreteTraitDelegate;

public class DiscreteTraitBranchRateDelegate
extends AbstractDiscreteTraitDelegate {
    public static String GRADIENT_TRAIT_NAME = "BranchRateGradient";
    public static String HESSIAN_TRAIT_NAME = "BranchRateHessian";

    public DiscreteTraitBranchRateDelegate(String string, Tree tree, BeagleDataLikelihoodDelegate beagleDataLikelihoodDelegate) {
        super(string, tree, beagleDataLikelihoodDelegate);
    }

    @Override
    protected void cacheDifferentialMassMatrix(Tree tree, boolean bl) {
        for (int i = 0; i < this.evolutionaryProcessDelegate.getSubstitutionModelCount(); ++i) {
            double[] dArray = new double[this.stateCount * this.stateCount];
            SubstitutionModel substitutionModel = this.evolutionaryProcessDelegate.getSubstitutionModel(i);
            substitutionModel.getInfinitesimalMatrix(dArray);
            double[] dArray2 = DiscreteTraitBranchRateDelegate.scaleInfinitesimalMatrixByRates(dArray, DifferentialChoice.GRADIENT, this.siteRateModel);
            this.evolutionaryProcessDelegate.cacheInfinitesimalMatrix(this.beagle, i, dArray2);
            if (!bl) continue;
            double[] dArray3 = new double[this.stateCount * this.stateCount];
            for (int j = 0; j < this.stateCount; ++j) {
                for (int k = 0; k < this.stateCount; ++k) {
                    double d = 0.0;
                    for (int i2 = 0; i2 < this.stateCount; ++i2) {
                        d += dArray[j * this.stateCount + i2] * dArray[i2 * this.stateCount + k];
                    }
                    dArray3[j * this.stateCount + k] = d;
                }
            }
            double[] dArray4 = DiscreteTraitBranchRateDelegate.scaleInfinitesimalMatrixByRates(dArray3, DifferentialChoice.HESSIAN, this.siteRateModel);
            this.evolutionaryProcessDelegate.cacheInfinitesimalSquaredMatrix(this.beagle, i, dArray4);
        }
    }

    public static double[] scaleInfinitesimalMatrixByRates(double[] dArray, DifferentialChoice differentialChoice, SiteRateModel siteRateModel) {
        int n = dArray.length;
        if (dArray.length != n) {
            throw new RuntimeException("Dimension mismatch when preparing scaled differential matrix for branchRateGradient calculations.");
        }
        double[] dArray2 = new double[n * siteRateModel.getCategoryCount()];
        for (int i = 0; i < siteRateModel.getCategoryCount(); ++i) {
            double d = siteRateModel.getRateForCategory(i);
            for (int j = 0; j < n; ++j) {
                dArray2[n * i + j] = dArray[j] * differentialChoice.getRateScale(d);
            }
        }
        return dArray2;
    }

    public static String getName(String string) {
        return GRADIENT_TRAIT_NAME;
    }

    @Override
    protected String getGradientTraitName() {
        return GRADIENT_TRAIT_NAME;
    }

    @Override
    protected String getHessianTraitName() {
        return HESSIAN_TRAIT_NAME;
    }

    static enum DifferentialChoice {
        GRADIENT{

            @Override
            double getRateScale(double d) {
                return d;
            }
        }
        ,
        HESSIAN{

            @Override
            double getRateScale(double d) {
                return d * d;
            }
        };


        abstract double getRateScale(double var1);
    }
}

