/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evolution.datatype.DataType;
import dr.evomodel.substmodel.ComplexSubstitutionModel;
import dr.evomodel.substmodel.FrequencyModel;
import dr.inference.glm.GeneralizedLinearModel;
import dr.inference.loggers.LogColumn;
import dr.inference.model.BayesianStochasticSearchVariableSelection;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.util.Citation;
import dr.util.CommonCitations;
import java.util.Collections;
import java.util.List;

public class GLMSubstitutionModel
extends ComplexSubstitutionModel {
    private GeneralizedLinearModel glm;
    private double[] testProbabilities;

    public GLMSubstitutionModel(String string, DataType dataType, FrequencyModel frequencyModel, GeneralizedLinearModel generalizedLinearModel) {
        super(string, dataType, frequencyModel, (Parameter)null);
        this.glm = generalizedLinearModel;
        this.addModel(generalizedLinearModel);
        this.testProbabilities = new double[this.stateCount * this.stateCount];
    }

    public double[] getRates() {
        return this.glm.getXBeta();
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.glm) {
            this.updateMatrix = true;
            this.fireModelChanged();
        } else {
            super.handleModelChangedEvent(model, object, n);
        }
    }

    @Override
    public LogColumn[] getColumns() {
        LogColumn[] logColumnArray = new LogColumn[this.glm.getColumns().length + 2];
        int n = 0;
        LogColumn[] logColumnArray2 = this.glm.getColumns();
        int n2 = logColumnArray2.length;
        for (int i = 0; i < n2; ++i) {
            LogColumn logColumn;
            logColumnArray[n] = logColumn = logColumnArray2[i];
            ++n;
        }
        logColumnArray[n++] = new ComplexSubstitutionModel.LikelihoodColumn(this.getId() + ".L");
        logColumnArray[n++] = new ComplexSubstitutionModel.NormalizationColumn(this.getId() + ".Norm");
        return logColumnArray;
    }

    @Override
    public double getLogLikelihood() {
        double d = super.getLogLikelihood();
        if (d == 0.0 && BayesianStochasticSearchVariableSelection.Utils.connectedAndWellConditioned(this.testProbabilities, this)) {
            return 0.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public String getDescription() {
        return "Generalized linear (model, GLM) substitution model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CommonCitations.LEMEY_2014_UNIFYING);
    }
}

