/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.crypt.agile;

import java.io.IOException;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.poifs.crypt.ChainingMode;
import org.apache.poi.poifs.crypt.CipherAlgorithm;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionInfoBuilder;
import org.apache.poi.poifs.crypt.HashAlgorithm;
import org.apache.poi.poifs.crypt.agile.AgileDecryptor;
import org.apache.poi.poifs.crypt.agile.AgileEncryptionHeader;
import org.apache.poi.poifs.crypt.agile.AgileEncryptionVerifier;
import org.apache.poi.poifs.crypt.agile.AgileEncryptor;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

public class AgileEncryptionInfoBuilder
implements EncryptionInfoBuilder {
    EncryptionInfo info;
    AgileEncryptionHeader header;
    AgileEncryptionVerifier verifier;
    AgileDecryptor decryptor;
    AgileEncryptor encryptor;

    public void initialize(EncryptionInfo info, DocumentInputStream dis) throws IOException {
        this.info = info;
        StringBuilder builder = new StringBuilder();
        byte[] xmlDescriptor = new byte[dis.available()];
        dis.read(xmlDescriptor);
        for (byte b : xmlDescriptor) {
            builder.append((char)b);
        }
        String descriptor = builder.toString();
        this.header = new AgileEncryptionHeader(descriptor);
        this.verifier = new AgileEncryptionVerifier(descriptor);
        if (info.getVersionMajor() == 4 && info.getVersionMinor() == 4) {
            this.decryptor = new AgileDecryptor(this);
        }
    }

    public void initialize(EncryptionInfo info, CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int keyBits, int blockSize, ChainingMode chainingMode) {
        this.info = info;
        if (cipherAlgorithm == null) {
            cipherAlgorithm = CipherAlgorithm.aes128;
        }
        if (cipherAlgorithm == CipherAlgorithm.rc4) {
            throw new EncryptedDocumentException("RC4 must not be used with agile encryption.");
        }
        if (hashAlgorithm == null) {
            hashAlgorithm = HashAlgorithm.sha1;
        }
        if (chainingMode == null) {
            chainingMode = ChainingMode.cbc;
        }
        if (chainingMode != ChainingMode.cbc && chainingMode != ChainingMode.cfb) {
            throw new EncryptedDocumentException("Agile encryption only supports CBC/CFB chaining.");
        }
        if (keyBits == -1) {
            keyBits = cipherAlgorithm.defaultKeySize;
        }
        if (blockSize == -1) {
            blockSize = cipherAlgorithm.blockSize;
        }
        boolean found = false;
        for (int ks : cipherAlgorithm.allowedKeySize) {
            found |= ks == keyBits;
        }
        if (!found) {
            throw new EncryptedDocumentException("KeySize " + keyBits + " not allowed for Cipher " + cipherAlgorithm.toString());
        }
        this.header = new AgileEncryptionHeader(cipherAlgorithm, hashAlgorithm, keyBits, blockSize, chainingMode);
        this.verifier = new AgileEncryptionVerifier(cipherAlgorithm, hashAlgorithm, keyBits, blockSize, chainingMode);
        this.decryptor = new AgileDecryptor(this);
        this.encryptor = new AgileEncryptor(this);
    }

    public AgileEncryptionHeader getHeader() {
        return this.header;
    }

    public AgileEncryptionVerifier getVerifier() {
        return this.verifier;
    }

    public AgileDecryptor getDecryptor() {
        return this.decryptor;
    }

    public AgileEncryptor getEncryptor() {
        return this.encryptor;
    }

    protected EncryptionInfo getInfo() {
        return this.info;
    }
}

