## =======================================================================
## Example for using tramME for inidvidual participant data meta-analysis
## =======================================================================

## The dataset is a !!!_random subset_!!! of the 3CIA database
## of COPD patients
##
## Variable definitions
##  follow_up_months: length of follow-up in months
##  alive1_death2: indicator of the status at the end of follow-up
##                 (1: alive, 2: death)
##  age: age in years
##  fev1pp: FEV1 measurement
##  mmrc0_4: dyspnea score (mMRC)
##  ages, fev1pps, mmrcs: rescaled versions of the three covariates
##                        (using their ranges)
##  cohort: study indicator
##  su: Surv object treating survival times as right-censored
##  sui: Surv object taking interval censoring into account

## Reference for the data:
## J. B. Soriano, B. Lamprecht, A. S. Ramirez, P. Martinez-Camblor, B. Kaiser,
## I. Alfageme, P. Almagro, C. Casanova, C. Esteban, J. J. Soler-Cataluna,
## J. P. de Torres, M. Miravitlles, B. R. Celli, J. M. Marin, M. A. Puhan,
## P. Sobradillo, P. Lange, A. L. Sternberg, J. Garcia-Aymerich,
## A. M. Turner, M. K. Han, A. Langhammer, L. Leivseth, P. Bakke,
## A. Johannessen, N. Roche, and D. D. Sin. -- Mortality prediction in chronic
## obstructive pulmonary disease comparing the GOLD 2007 and 2011 staging
## systems: A pooled analysis of individual patient data.
## The Lancet Respiratory Medicine, 3(6):443--450, 2015.
## <doi:10.1016/S2213-2600(15)00157-5>

data3CIA <-
structure(list(follow_up_months = c(36, 36, 36, 36, 34, 36, 36,
36, 36, 36, 36, 36, 22, 4, 36, 36, 36, 5, 36, 36, 36, 26, 36,
36, 36, 36, 18, 36, 33, 36, 36, 36, 36, 36, 36, 36, 36, 26, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 14, 36,
36, 36, 36, 36, 28, 36, 36, 32, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 2, 36, 36, 36, 36, 36, 35, 36, 36, 20,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 29, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 17,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 34, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 22, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 19, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 23, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 32, 36, 36, 36, 36, 36, 22, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 33,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 27, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 9, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
30, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 33,
36, 29, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 32, 36, 36, 36, 36, 36, 36, 36, 28, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 28, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 31, 36, 36,
36, 36, 36, 36, 36, 1, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 13, 36,
36, 36, 36, 36, 36, 36, 15, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 26, 36, 36, 36, 36, 36, 36, 36, 36, 4, 36, 36, 36, 36, 36,
27, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 19, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
7, 36, 36, 36, 36, 36, 36, 36, 36, 36, 8, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 32, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 34, 36, 36, 36, 36, 36, 36,
36, 11, 36, 36, 36, 36, 36, 30, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
30, 36, 36, 36, 36, 36, 36, 9, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 18, 36, 36, 36, 2, 36, 36, 36, 5, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 23, 36, 36, 36, 36, 36, 36, 36, 36, 32,
36, 36, 36, 35, 36, 36, 13, 30, 36, 36, 36, 36, 36, 9, 36, 21,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 29, 36, 15, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 29, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 32, 36, 36, 36, 36, 36, 36, 36,
15, 4, 36, 36, 36, 36, 23, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 9, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 6, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 28, 36, 36, 36, 36, 36,
36, 36, 36, 13, 36, 28, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 6, 36, 15, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 11, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 5,
36, 36, 36, 36, 36, 36, 36, 36, 25, 9, 36, 36, 36, 36, 36, 36,
34, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 34, 36,
36, 36, 36, 18, 36, 36, 36, 36, 36, 10, 36, 21, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 2, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 16, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 18,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 13,
36, 36, 36, 36, 4, 36, 20, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 33, 36, 36, 36, 18, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 6, 36, 36, 36, 15, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 34, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 35, 36, 36, 36, 27, 29, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 35, 36, 36, 36, 58.200000000000003, 31, 81.099999999999994,
63.600000000000001, 78.099999999999994, 59.700000000000003, 75.599999999999994,
65.200000000000003, 73, 68.900000000000006, 71.200000000000003,
70, 69.400000000000006, 64.700000000000003, 68.400000000000006,
67.299999999999997, 15.699999999999999, 64, 12.1, 65.200000000000003,
14.4, 26, 55.100000000000001, 56.5, 56, 81.5, 80.400000000000006,
78.5, 76.900000000000006, 76.700000000000003, 74, 75.299999999999997,
54.600000000000001, 63.299999999999997, 71.299999999999997, 46.5,
56.200000000000003, 69.700000000000003, 63.100000000000001, 54.5,
68, 64.200000000000003, 63.299999999999997, 63.5, 63.100000000000001,
63.799999999999997, 61.299999999999997, 77.099999999999994, 73.900000000000006,
73.400000000000006, 75.299999999999997, 75.900000000000006, 74.400000000000006,
72.5, 74.299999999999997, 74.299999999999997, 63.399999999999999,
62.899999999999999, 12.6, 69.200000000000003, 69.799999999999997,
68.700000000000003, 64.900000000000006, 47.600000000000001, 56.700000000000003,
53, 56.200000000000003, 56, 55.5, 57.399999999999999, 53, 36.100000000000001,
80.400000000000006, 9, 39.200000000000003, 36.700000000000003,
72.900000000000006, 72.5, 71.900000000000006, 71.700000000000003,
70.900000000000006, 69.5, 70, 69.299999999999997, 68.900000000000006,
68.700000000000003, 66.200000000000003, 64, 63.100000000000001,
24.399999999999999, 57.299999999999997, 55, 80.5, 79.900000000000006,
26.199999999999999, 79.900000000000006, 79.200000000000003, 48.700000000000003,
70.400000000000006, 66.700000000000003, 55.899999999999999, 68.099999999999994,
60.100000000000001, 6.2000000000000002, 65, 66.299999999999997,
61, 60.600000000000001, 52.899999999999999, 22.5, 59.399999999999999,
58.799999999999997, 56, 53.200000000000003, 55.700000000000003,
54.399999999999999, 55.5, 55.5, 52.5, 53.899999999999999, 81.799999999999997,
81.5, 80.400000000000006, 79, 79.400000000000006, 71.900000000000006,
58.100000000000001, 62.799999999999997, 57.299999999999997, 66.799999999999997,
71.400000000000006, 50.799999999999997, 69.599999999999994, 70,
68.900000000000006, 40, 30.199999999999999, 64.799999999999997,
10, 59.399999999999999, 80.299999999999997, 78, 51.100000000000001,
72.200000000000003, 35.399999999999999, 69.299999999999997, 70.700000000000003,
50.5, 68.099999999999994, 68.099999999999994, 65, 80.099999999999994,
69.299999999999997, 68.200000000000003, 81, 80.099999999999994,
80.299999999999997, 75, 74.099999999999994, 77.599999999999994,
73.200000000000003, 66.799999999999997, 69.700000000000003, 55.299999999999997,
68.599999999999994, 15.9, 62.200000000000003, 27.600000000000001,
58.5, 58.700000000000003, 56.700000000000003, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 15, 36, 36, 26, 23, 36, 36, 36, 12, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 1, 36, 0, 13, 5, 8, 29, 15, 12, 30, 36, 36, 36, 35, 36,
36, 36, 36, 21, 36, 36, 36, 36, 36, 36, 36, 36, 18, 36, 8, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 14, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
35, 36, 36, 36, 36, 36, 36, 35, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 4, 36, 29, 36, 36, 26, 36, 36, 36, 36, 36, 36, 36, 32,
21, 36, 23, 36, 36, 36, 33, 36, 36, 36, 36, 9, 36, 7, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 49, 22, 17, 26, 48, 31,
34, 47, 3, 47, 47, 21, 45, 39, 12, 17, 43, 43, 42, 29, 42, 42,
41, 17, 3, 40, 12, 10, 41, 17, 40, 39, 15, 39, 38, 38, 38, 37,
37, 32, 37, 15, 24, 37, 37, 36, 36, 36, 36, 36, 36, 33, 35, 35,
35, 31, 17, 34, 33, 33, 33, 33, 33, 33, 33, 32, 4, 31, 31, 30,
31, 4, 30, 18, 27, 30, 3, 14, 30, 19, 8, 46, 13, 45, 16, 5, 44,
31, 34, 7, 17, 8, 40, 16, 4, 16, 16, 39, 35, 37, 36, 36, 16,
36, 17, 35, 35, 11, 35, 34, 33, 33, 31, 24, 30, 30, 60, 21, 60,
60, 54, 60, 5, 60, 6, 60, 45, 60, 36, 22, 60, 56, 60, 62, 32,
60, 60, 60, 60, 60, 60, 60, 56, 32, 10, 60, 28, 60, 60, 28, 56,
19, 60, 60, 60, 60, 62, 60, 60, 28, 60, 60, 60, 60, 27, 60, 43,
60, 60, 60, 60, 55, 21, 57, 50, 29, 60, 56, 60, 21, 68, 60, 60,
24, 49, 60, 60, 43, 60, 29, 60, 60, 60, 60, 60, 60, 11, 60, 57,
60, 48, 60, 34, 60, 32, 60, 54, 18, 60, 60, 60, 12, 60, 60, 60,
60, 60, 31, 31, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 25, 60,
60, 3, 60, 23, 60, 33, 14, 60, 60, 39, 60, 60, 60, 60, 60, 60,
60, 60, 60, 45, 60, 60, 24, 60, 60, 60, 60, 7, 60, 60, 51, 39,
60, 60, 41, 60, 62, 2, 11, 60, 60, 60, 60, 60, 34, 26, 60, 60,
60, 60, 45, 60, 60, 60, 60, 1, 57, 60, 60, 19, 60, 60, 60, 60,
3, 60, 60, 60, 37, 60, 60, 10, 60, 60, 60, 60, 14, 60, 60, 60,
60, 56, 60, 60, 20, 60, 60, 60, 60, 60, 42, 11, 45, 37, 33, 60,
60, 13, 60, 57, 55, 60, 60, 5, 60, 43, 60, 60, 60, 60, 60, 60,
60, 60, 60, 60, 60, 60, 60, 60, 60, 52, 60, 60, 60, 60, 60, 56,
39, 18, 17, 60, 54, 11, 60, 44, 60, 60, 60, 60, 21, 60, 60, 60,
44, 60, 60, 60, 60, 60, 60, 60, 60, 60, 29, 34, 60, 96, 115,
42, 62, 36, 96, 62, 17, 128, 71, 162, 72, 140, 46, 26, 20, 136,
66, 38, 77, 84, 12, 170, 63, 10, 168, 120, 80, 136, 72, 96, 156,
84, 76, 76, 76, 108, 136, 68, 36, 46, 136, 60, 76, 67, 96, 130,
130, 12, 84, 136, 120, 53, 108, 108, 96, 60, 156, 118, 60, 72,
84, 120, 12, 108, 156, 108, 156, 84, 43, 148, 108, 84, 104, 28,
21, 84, 84, 96, 61, 108, 120, 61, 60, 120, 136, 53, 36, 60, 48,
31, 48, 51, 84, 13, 16, 40, 15, 60, 14, 108, 12, 24, 96, 24,
96, 96, 60, 89, 76, 20, 3, 41, 45, 91, 44, 11, 39, 39, 66, 50,
36, 2, 20, 67, 67, 63, 60, 67, 23, 14, 18, 80, 62, 28, 14, 30,
10, 67, 61, 35, 67, 24, 65, 17, 6, 19, 27, 68, 11, 22, 20, 11,
90, 13, 60, 64, 90, 9, 15, 90, 11, 91, 23, 65, 17, 38, 36, 65,
12, 13, 14, 13, 65, 36, 10, 58, 18, 19, 35, 13, 13, 64, 14, 85,
14, 19, 25, 19, 21, 12, 10, 25, 15, 18, 23, 21, 23, 23, 12, 40.700000000000003,
4.7000000000000002, 173, 195.5, 45.5, 64.200000000000003, 70,
3.2000000000000002, 72.799999999999997, 102.09999999999999, 17,
4.2999999999999998, 200.5, 221.90000000000001, 134.69999999999999,
23.399999999999999, 49.200000000000003, 157.09999999999999, 19.899999999999999,
21.899999999999999, 60, 154.80000000000001, 1.1000000000000001,
98.299999999999997, 95.5, 220.69999999999999, 49.200000000000003,
54.600000000000001, 144.80000000000001, 120.5, 43.799999999999997,
36.899999999999999, 219.80000000000001, 49.399999999999999, 47.899999999999999,
36, 171.09999999999999, 89.599999999999994, 3.7999999999999998,
223, 56.600000000000001, 188.40000000000001, 73.400000000000006,
117, 87.200000000000003, 61.200000000000003, 9.1999999999999993,
149.80000000000001, 51.600000000000001, 89, 86.400000000000006,
89.900000000000006, 28.5, 146, 218.69999999999999, 88.299999999999997,
168.59999999999999, 1.6000000000000001, 141.5, 69.400000000000006,
38.799999999999997, 38.299999999999997, 78.799999999999997, 23.600000000000001,
109.59999999999999, 3.8999999999999999, 0.5, 194.90000000000001,
202.09999999999999, 79.400000000000006, 23.600000000000001, 55.200000000000003,
149.30000000000001, 58.700000000000003, 11.800000000000001, 110.59999999999999,
58.5, 26.300000000000001, 28.899999999999999, 155.90000000000001,
5.9000000000000004, 176.69999999999999, 74.5, 37.899999999999999,
217.40000000000001, 169.69999999999999, 92.5, 21.300000000000001,
146.59999999999999, 141.59999999999999, 18.699999999999999, 88.799999999999997,
134.30000000000001, 216.09999999999999, 75.099999999999994, 70.299999999999997,
58.899999999999999, 8.5999999999999996, 157.30000000000001, 28.199999999999999,
158.40000000000001, 87.900000000000006, 48.799999999999997, 215.5,
36.100000000000001, 17.800000000000001, 91.400000000000006, 63.100000000000001,
143.19999999999999, 212.80000000000001, 43.700000000000003, 8.6999999999999993,
212.59999999999999, 10.6, 135.5, 212.09999999999999, 187, 74.099999999999994,
132.30000000000001, 134, 53.200000000000003, 75.900000000000006,
6.9000000000000004, 32.399999999999999, 110.90000000000001, 8.0999999999999996,
75.099999999999994, 211.40000000000001, 211.40000000000001, 136.09999999999999,
136.69999999999999, 129.59999999999999, 75.799999999999997, 22.399999999999999,
134.19999999999999, 36.700000000000003, 207.09999999999999, 14.4,
96.799999999999997, 27.899999999999999, 41.5, 32.700000000000003,
0.69999999999999996, 1.6000000000000001, 116.90000000000001,
210.69999999999999, 11, 53.399999999999999, 35.799999999999997,
26.199999999999999, 16.899999999999999, 80, 173.80000000000001,
2.7999999999999998, 29.600000000000001, 60.700000000000003, 209.69999999999999,
54, 73, 210.19999999999999, 128.19999999999999, 210.19999999999999,
12.4, 141.80000000000001, 29.699999999999999, 12.800000000000001,
10.300000000000001, 84.599999999999994, 69.299999999999997, 67.200000000000003,
39.899999999999999, 209.30000000000001, 58.5, 164.59999999999999,
95.599999999999994, 209.30000000000001, 9.3000000000000007, 209.19999999999999,
6.7000000000000002, 68.400000000000006, 209.09999999999999, 122,
74.700000000000003, 209, 138.40000000000001, 46.5, 129.80000000000001,
29.100000000000001, 18, 60.399999999999999, 81, 47.799999999999997,
134.59999999999999, 73.700000000000003, 208.5, 46.399999999999999,
208.30000000000001, 208.40000000000001, 109.2, 26.300000000000001,
105.8, 128.30000000000001, 13.6, 208, 205, 37.299999999999997,
208, 191.5, 58, 107.8, 207.90000000000001, 88.599999999999994,
207.80000000000001, 34.899999999999999, 178.09999999999999, 37.299999999999997,
111.90000000000001, 17.699999999999999, 105.59999999999999, 205.40000000000001,
2.5, 168.90000000000001, 39.5, 52.5, 94.700000000000003, 184.40000000000001,
125.40000000000001, 206.30000000000001, 206.09999999999999, 91.099999999999994,
164.69999999999999, 52.399999999999999, 65.200000000000003, 37.899999999999999,
192.09999999999999, 138.30000000000001, 191.5, 85.599999999999994,
104.2, 206, 206, 75.200000000000003, 33.100000000000001, 81.299999999999997,
129.40000000000001, 204.90000000000001, 15.9, 205.59999999999999,
205.5, 205.5, 47.700000000000003, 141.30000000000001, 158.30000000000001,
41.899999999999999, 205.09999999999999, 7.5999999999999996, 204.80000000000001,
84, 204.69999999999999, 204.59999999999999, 57.100000000000001,
85.400000000000006, 29.300000000000001, 204.59999999999999, 61,
75.099999999999994, 69.099999999999994, 0.90000000000000002,
45.5, 18.199999999999999, 131.80000000000001, 126, 35.100000000000001,
91.799999999999997, 146.80000000000001, 38.700000000000003, 92.200000000000003,
107.40000000000001, 79.799999999999997, 100.09999999999999, 189.30000000000001,
204.59999999999999, 53.200000000000003, 150.40000000000001, 85.200000000000003,
191.09999999999999, 204.19999999999999, 47.100000000000001, 12.4,
29.600000000000001, 115.5, 12.300000000000001, 2.6000000000000001,
121.5, 29.300000000000001, 20.100000000000001, 9, 99.799999999999997,
96, 76.200000000000003, 258.39999999999998, 1.2, 83.099999999999994,
45.799999999999997, 121.09999999999999, 96.299999999999997, 74.700000000000003,
93.799999999999997, 13.5, 146.80000000000001, 25.399999999999999,
87.700000000000003, 14.800000000000001, 29.199999999999999, 77.299999999999997,
252.90000000000001, 62.100000000000001, 219.40000000000001, 112.3,
61.299999999999997, 60.799999999999997, 128.30000000000001, 77.799999999999997,
17.399999999999999, 3.5, 3, 12.9, 66.700000000000003, 188.69999999999999,
77.900000000000006, 109.09999999999999, 150.69999999999999, 129.80000000000001,
37.5, 26.699999999999999, 0.69999999999999996, 90.400000000000006,
258.10000000000002, 19.699999999999999, 24.100000000000001, 142.40000000000001,
13.1, 15.6, 17.5, 233.80000000000001, 4.7000000000000002, 31.5,
2.2999999999999998, 199.80000000000001, 26.699999999999999, 12.6,
20.300000000000001, 40.700000000000003, 113.2, 42.5, 115.5, 27.5,
27.5, 4.5999999999999996, 17.100000000000001, 4.4000000000000004,
25.300000000000001, 175.90000000000001, 31.800000000000001, 3.2000000000000002,
17, 104.5, 76.5, 118.59999999999999, 8.9000000000000004, 17.199999999999999,
48.600000000000001, 72.400000000000006, 25.399999999999999, 165.19999999999999,
142.80000000000001, 58.600000000000001, 3.7999999999999998, 184.5,
64.299999999999997, 4, 78.099999999999994, 15.4, 100.09999999999999,
7.4000000000000004, 5.7000000000000002, 28.399999999999999, 15.4,
154.90000000000001, 76.700000000000003, 228.40000000000001, 50.799999999999997,
39.399999999999999, 60.899999999999999, 10.1, 78.099999999999994,
46.5, 10.699999999999999, 110.8, 20.800000000000001, 15, 139.40000000000001,
44.200000000000003, 167.40000000000001, 28.699999999999999, 38.299999999999997,
160.40000000000001, 88.400000000000006, 87.900000000000006, 121,
5.4000000000000004, 42.100000000000001, 134.80000000000001, 38.399999999999999,
1.6000000000000001, 77.099999999999994, 41.799999999999997, 4,
102.5, 105, 38.799999999999997, 159.80000000000001, 30.800000000000001,
23.399999999999999, 155, 45.5, 155.80000000000001, 164.90000000000001,
43.899999999999999, 67.400000000000006, 39.200000000000003, 82.200000000000003,
170, 85.299999999999997, 12, 79.700000000000003, 54.700000000000003,
137.09999999999999, 65.799999999999997, 1.3999999999999999, 86.700000000000003,
28.699999999999999, 71.099999999999994, 11.699999999999999, 55.5,
31.600000000000001, 138.59999999999999, 81.900000000000006, 99.200000000000003,
78.599999999999994, 171, 10.199999999999999, 46.100000000000001,
127.09999999999999, 91.299999999999997, 72.400000000000006, 55.299999999999997,
38, 24.699999999999999, 80.400000000000006, 60.5, 163.59999999999999,
172.59999999999999, 30.399999999999999, 40.299999999999997, 70.099999999999994,
97.599999999999994, 98.799999999999997, 25.399999999999999, 31.5,
7.2000000000000002, 161.90000000000001, 18.100000000000001, 38.5,
21.100000000000001, 95.599999999999994, 40.799999999999997, 43,
58, 20, 76, 85, 66, 75, 57, 66, 84, 23, 90, 84, 85, 92, 85, 48,
48, 90, 83, 71, 76, 46, 81, 84, 70, 41, 91, 56, 90, 85, 10, 85,
78, 34, 87, 74, 29, 73, 81, 46, 14, 85, 84, 74, 25, 42, 43, 85,
42, 38, 78, 26, 89, 44, 92, 42, 85, 92, 88, 85, 7, 91, 22, 81,
68, 92, 92, 198.96000000000001, 181.19999999999999, 208.44, 98.640000000000001,
36.960000000000001, 147.84, 211.68000000000001, 71.519999999999996,
56.159999999999997, 58.560000000000002, 118.08, 198.12, 16.440000000000001,
59.280000000000001, 122.76000000000001, 245.40000000000001, 77.760000000000005,
178.80000000000001, 228.84, 8.4000000000000004, 171.59999999999999,
13.199999999999999, 10.800000000000001, 41.039999999999999, 142.44,
163.44, 102.59999999999999, 172.80000000000001, 123.72, 126.59999999999999,
36.479999999999997, 50.520000000000003, 88.920000000000002, 38.039999999999999,
98.879999999999995, 36.479999999999997, 149.75999999999999, 32.039999999999999,
151.08000000000001, 62.520000000000003, 236.75999999999999, 30.719999999999999,
131.75999999999999, 14.16, 107.76000000000001, 126.72, 184.91999999999999,
65.640000000000001, 44.399999999999999, 207.72, 91.680000000000007,
10.44, 213.59999999999999, 126.95999999999999, 220.08000000000001,
5.2800000000000002, 15.24, 126.72, 212.52000000000001, 14.640000000000001,
182.03999999999999, 78, 72.840000000000003, 123.84, 238.56, 158.63999999999999,
95.280000000000001, 22.32, 226.44, 168.84, 217.56, 102.72, 26.640000000000001,
202.80000000000001, 226.19999999999999, 111.72, 248.03999999999999,
238.56, 236.63999999999999, 40.079999999999998, 237, 116.88,
155.28, 203.40000000000001, 27.960000000000001, 224.40000000000001,
148.80000000000001, 16.32, 59.880000000000003, 121.2, 93.719999999999999,
67.439999999999998, 94.200000000000003, 72.959999999999994, 189.96000000000001,
109.92, 166.80000000000001, 109.8, 121.44, 18.359999999999999,
6.2400000000000002, 232.44, 94.439999999999998, 124.08, 27.239999999999998,
121.2, 136.08000000000001, 150.36000000000001, 176.75999999999999,
89.879999999999995, 130.31999999999999, 9.7200000000000006, 120.48,
146.88, 112.8, 195.24000000000001, 20.16, 233.88, 122.04000000000001,
24.48, 193.44, 15.6, 162.12, 29.399999999999999, 124.08, 178.08000000000001,
211.19999999999999, 38.640000000000001, 17.760000000000002, 151.80000000000001,
115.8, 6.96, 181.44, 33.359999999999999, 77.280000000000001,
78.599999999999994, 102.23999999999999, 120.84, 171.84, 161.63999999999999,
8.6400000000000006, 193.56, 132.47999999999999, 112.2, 91.680000000000007,
225.24000000000001, 89.040000000000006, 193.80000000000001, 178.80000000000001,
91.560000000000002, 199.19999999999999, 39.719999999999999, 119.40000000000001,
214.19999999999999, 157.80000000000001, 155.28, 54.960000000000001,
74.159999999999997, 91.319999999999993, 102.59999999999999, 18.120000000000001,
142.80000000000001, 208.91999999999999, 123.36, 28.800000000000001,
47.640000000000001, 145.08000000000001, 89.400000000000006, 172.31999999999999,
180.84, 222, 65.280000000000001, 17.280000000000001, 139.08000000000001,
60, 61.68, 93.719999999999999, 217.19999999999999, 155.03999999999999,
206.40000000000001, 66.599999999999994, 29.52, 122.64, 101.04000000000001,
13.08, 145.44, 110.76000000000001, 160.91999999999999, 148.31999999999999,
238.31999999999999, 40.920000000000002, 36.719999999999999, 150.59999999999999,
252.59999999999999, 101.64, 125.52, 33.719999999999999, 241.44,
183.59999999999999, 217.08000000000001, 14.4, 66.480000000000004,
182.16, 160.91999999999999, 140.88, 95.640000000000001, 215.40000000000001,
115.08, 223.19999999999999, 199.19999999999999, 179.03999999999999,
137.03999999999999, 207.24000000000001, 89.879999999999995, 114.84,
236.16, 109.56, 11.16, 90.959999999999994, 122.52, 156.59999999999999,
194.16, 144.47999999999999, 137.75999999999999, 71.159999999999997,
90.719999999999999, 188.28, 44.759999999999998, 200.40000000000001,
128.75999999999999, 177.12, 114.12, 182.40000000000001, 142.19999999999999,
26.039999999999999, 44.280000000000001, 64.200000000000003, 243.84,
146.75999999999999, 29.16, 15.48, 130.68000000000001, 149.75999999999999,
112.31999999999999, 22.68, 56.759999999999998, 25.920000000000002,
4.2000000000000002, 173.28, 232.68000000000001, 129.84, 208.08000000000001,
154.31999999999999, 191.28, 189.36000000000001, 104.64, 167.03999999999999,
68.040000000000006, 84, 48, 131.52000000000001, 119.16, 125.04000000000001,
84.719999999999999, 64.319999999999993, 59.039999999999999, 146.88,
241.80000000000001, 175.31999999999999, 152.52000000000001, 15.6,
145.56, 137.75999999999999, 146.88, 27.84, 111.23999999999999,
100.31999999999999, 204.59999999999999, 109.8, 216.84, 50.880000000000003,
64.799999999999997, 47.280000000000001, 64.200000000000003, 54.840000000000003,
161.40000000000001, 120.59999999999999, 170.63999999999999, 56.520000000000003,
117.95999999999999, 80.760000000000005, 66, 87.120000000000005,
36.840000000000003, 218.03999999999999, 9.3599999999999994, 169.80000000000001,
142.19999999999999, 157.80000000000001, 81.120000000000005, 130.80000000000001,
210.36000000000001, 169.31999999999999, 150.47999999999999, 236.03999999999999,
136.91999999999999, 186.36000000000001, 117.72, 149.75999999999999,
122.40000000000001, 134.63999999999999, 129, 197.52000000000001,
213.59999999999999, 104.76000000000001, 141, 167.75999999999999,
119.64, 23.399999999999999, 133.44, 198.36000000000001, 127.68000000000001,
225.84, 26.879999999999999, 248.75999999999999, 126.23999999999999,
149.63999999999999, 5.7599999999999998, 201.36000000000001, 131.16,
149.52000000000001, 153.47999999999999, 226.56, 81, 18.600000000000001,
68.040000000000006, 7.4400000000000004, 146.16, 187.80000000000001,
155.16, 201.24000000000001, 29.640000000000001, 114.48, 141.24000000000001,
244.56, 115.08, 168.84, 41.280000000000001, 63, 90.719999999999999,
83.159999999999997, 150.47999999999999, 41.759999999999998, 171.59999999999999,
48.960000000000001, 207.96000000000001, 148.31999999999999, 122.40000000000001,
114.23999999999999, 94.200000000000003, 155.88, 22.68, 63.240000000000002,
178.44, 172.08000000000001, 41.399999999999999, 99.239999999999995,
158.63999999999999, 120.48, 120.48, 233.03999999999999, 129.47999999999999,
27.719999999999999, 65.400000000000006, 161.88, 217.31999999999999,
199.68000000000001, 32.759999999999998, 132.12, 155.52000000000001,
152.40000000000001, 63, 119.28, 146.03999999999999, 46.439999999999998,
210.96000000000001, 59.159999999999997, 134.03999999999999, 111.36,
99.480000000000004, 11.4, 71.760000000000005, 137.75999999999999,
205.91999999999999, 89.640000000000001, 93.719999999999999, 172.68000000000001,
146.52000000000001, 196.19999999999999, 226.44, 12.720000000000001,
25.440000000000001, 160.56, 44.759999999999998, 135.72, 225.72,
171.72, 150.12, 24.48, 22.079999999999998, 207.84, 210.72, 126.12,
106.44, 146.16, 179.40000000000001, 39.719999999999999, 112.8,
74.159999999999997, 142.31999999999999, 46.68, 59.039999999999999,
64.079999999999998, 127.2, 57.719999999999999, 26.879999999999999,
132.59999999999999, 162.36000000000001, 175.44, 164.03999999999999,
45.479999999999997, 42, 168.59999999999999, 240.96000000000001,
178.80000000000001, 88.799999999999997, 19.079999999999998, 46.560000000000002,
24.600000000000001, 168.84, 181.56, 167.40000000000001, 158.40000000000001,
51.119999999999997, 237.72, 36, 196.80000000000001, 195, 143.52000000000001,
117.72, 168.24000000000001, 132.72, 137.88, 165.96000000000001,
23.52, 100.44, 116.76000000000001, 154.56, 181.44, 131.75999999999999,
128.03999999999999, 222.47999999999999, 36.119999999999997, 55.799999999999997,
128.88, 66.239999999999995, 57.600000000000001, 204.24000000000001,
81.480000000000004, 67.439999999999998, 91.319999999999993, 172.91999999999999,
10.56, 43.32, 129.72, 112.2, 112.68000000000001, 120, 82.920000000000002,
237, 131.75999999999999, 120.59999999999999, 170.63999999999999,
51.240000000000002, 133.68000000000001, 189.84, 58.079999999999998,
82.680000000000007, 247.31999999999999, 59.640000000000001, 184.80000000000001,
81.719999999999999, 21.719999999999999, 135.59999999999999, 17.640000000000001,
194.88, 50.159999999999997, 83.879999999999995, 111, 87.959999999999994,
131.63999999999999, 99.239999999999995, 162.72, 195.59999999999999,
115.31999999999999, 118.2, 36, 97.079999999999998, 66.599999999999994,
7.0800000000000001, 137.52000000000001, 70.560000000000002, 15.359999999999999,
94.439999999999998, 210.36000000000001, 79.439999999999998, 46.32,
129.72, 36.240000000000002, 79.680000000000007, 122.16, 106.2,
155.75999999999999, 68.280000000000001, 114.36, 33, 86.519999999999996,
130.68000000000001, 11.16, 103.68000000000001, 214.44, 156.84,
243.47999999999999, 203.16, 239.03999999999999, 260.88, 138.72,
166.31999999999999, 260.75999999999999, 120, 198.24000000000001,
207.36000000000001, 90.719999999999999, 79.560000000000002, 75.239999999999995,
65.879999999999995, 16.68, 115.44, 232.56, 132.47999999999999,
52.200000000000003, 11.880000000000001, 15.6, 94.319999999999993,
23.16, 215.63999999999999, 91.319999999999993, 71.400000000000006,
70.680000000000007, 118.2, 29.039999999999999, 157.19999999999999,
74.040000000000006, 102.36, 127.56, 53.159999999999997, 107.28,
115.44, 142.44, 221.88, 213.72, 73.079999999999998, 113.88, 134.28,
72.400000000000006, 68.599999999999994, 79.900000000000006, 69.5,
25.600000000000001, 83.799999999999997, 67.799999999999997, 33.100000000000001,
52.700000000000003, 28.899999999999999, 80.099999999999994, 88,
77.400000000000006, 66.900000000000006, 78.200000000000003, 78.799999999999997,
78.5, 78.5, 79.5, 66.200000000000003, 64.700000000000003, 75.200000000000003,
87.599999999999994, 87.700000000000003, 48.399999999999999, 86.700000000000003,
72.5, 80.099999999999994, 54.200000000000003, 78.5, 77.5, 76.200000000000003,
75.5, 75.599999999999994, 52.399999999999999, 87.599999999999994,
75.5, 50.899999999999999, 71.299999999999997, 63.700000000000003,
86, 71.5, 57.299999999999997, 44.899999999999999, 78.700000000000003,
52.600000000000001, 44.700000000000003, 52.700000000000003, 67,
37, 78.5, 77.900000000000006, 63.799999999999997, 77.400000000000006,
31.600000000000001, 56.799999999999997, 84.599999999999994, 50.5,
70.400000000000006, 81.400000000000006, 67.599999999999994, 69.799999999999997,
68.799999999999997, 6.2000000000000002, 68, 47.799999999999997,
52.399999999999999, 58, 2.1000000000000001, 83.900000000000006,
51.200000000000003, 84.200000000000003, 77, 54.700000000000003,
66.799999999999997, 76.900000000000006, 67.200000000000003, 81.5,
61.799999999999997, 57.5, 78.099999999999994, 68.5, 70.799999999999997,
57.100000000000001, 81.400000000000006, 77.900000000000006, 64.599999999999994,
32.399999999999999, 80, 52.200000000000003, 29.100000000000001,
86.700000000000003, 62, 74.900000000000006, 71.400000000000006,
58.299999999999997, 70.200000000000003, 70.5, 79.700000000000003,
48.5, 67.400000000000006, 55.600000000000001, 63.799999999999997,
55.399999999999999, 84.200000000000003, 71.299999999999997, 50.799999999999997,
63.399999999999999, 51.700000000000003, 57.100000000000001, 70.099999999999994,
75.200000000000003, 78.099999999999994, 65.599999999999994, 76,
75.900000000000006, 82.299999999999997, 54.700000000000003, 74.700000000000003,
54, 66.099999999999994, 79.5, 71.5, 84.099999999999994, 70.099999999999994,
70.799999999999997, 68.200000000000003, 52.799999999999997, 55.899999999999999,
83.900000000000006, 75.900000000000006, 61.600000000000001, 76.200000000000003,
60.299999999999997, 70.299999999999997, 83.700000000000003, 68.700000000000003,
56.799999999999997, 81.799999999999997, 69.900000000000006, 80,
77.299999999999997, 76.200000000000003, 78, 67.400000000000006,
39.799999999999997, 79.5, 87.799999999999997, 87.799999999999997,
86.400000000000006, 72.400000000000006, 86.5, 46.100000000000001,
84.700000000000003, 84.099999999999994, 61.899999999999999, 84.099999999999994,
81, 83.200000000000003, 78.099999999999994, 81.299999999999997,
78.799999999999997, 68.900000000000006, 68.900000000000006, 80.200000000000003,
79.5, 55.899999999999999, 81.599999999999994, 54.299999999999997,
79.299999999999997, 66.400000000000006, 77.099999999999994, 78.099999999999994,
77.799999999999997, 66, 59.799999999999997, 77.599999999999994,
77.400000000000006, 77.099999999999994, 76.5, 63.799999999999997,
87.599999999999994, 74.200000000000003, 68, 84.200000000000003,
70.599999999999994, 71.799999999999997, 71.099999999999994, 70.5,
82.700000000000003, 82.299999999999997, 69.700000000000003, 81.299999999999997,
68.700000000000003, 25.399999999999999, 54, 76.599999999999994,
76.400000000000006, 62.899999999999999, 62.899999999999999, 55.899999999999999,
62.600000000000001, 61.899999999999999, 71.599999999999994, 57.799999999999997,
72.700000000000003, 34.399999999999999, 68.5, 56.100000000000001,
68.200000000000003, 67.900000000000006, 55.399999999999999, 54.799999999999997,
54.899999999999999, 66.599999999999994, 64.299999999999997, 63.5,
50.299999999999997, 62.299999999999997, 62.200000000000003, 49.600000000000001,
48.700000000000003, 60.299999999999997, 58.200000000000003, 45.600000000000001,
45.399999999999999, 45.5, 56.399999999999999, 54.100000000000001,
43.799999999999997, 54, 37, 51, 51.200000000000003, 50.5, 37.899999999999999,
49.799999999999997, 37.299999999999997, 36.100000000000001, 35.700000000000003,
35, 47, 33.100000000000001, 44.700000000000003, 31.600000000000001,
43.700000000000003, 43.700000000000003, 44, 31.399999999999999,
30.899999999999999, 42.399999999999999, 41.399999999999999, 40.200000000000003,
40.100000000000001, 38.200000000000003, 37.700000000000003, 37.100000000000001,
29.5, 72, 71, 57, 70, 68, 61, 8, 49, 67, 67, 71, 65, 14, 23,
70, 70, 66, 70, 68, 66, 65, 67, 65, 63, 70, 32, 68, 70, 65, 37,
41, 67, 65, 68, 68, 62, 65, 66, 21, 69, 69, 68, 68, 62, 51, 66,
24, 60, 51, 68, 68, 69, 66, 9, 67, 32, 41, 64, 67, 64, 51, 66,
69, 64, 50, 67, 52, 69, 64, 67, 68, 65, 59, 63, 57, 62, 13, 65,
63, 62, 14, 67, 56, 64, 65, 68, 37, 65, 58, 43, 19, 30, 50, 65,
56, 67, 54, 64, 16, 31, 64, 65, 36, 64, 61, 68, 59, 56, 64, 27,
35, 1, 68, 63, 22, 64, 64, 65, 65, 51, 58, 65, 64, 67, 67, 59,
64, 64, 60, 66, 67, 67, 67, 64, 66, 65, 36, 65, 53, 61, 66, 66,
66, 66, 47, 66, 66, 36, 59, 12, 65, 63, 61, 50, 49, 62, 54, 67,
20, 68, 7, 63, 66, 56, 39, 46, 65, 60, 66, 7, 52, 59, 4, 63,
58, 17, 64, 45, 64, 14, 44, 22, 67, 62, 62, 64, 67, 65, 65, 67,
61, 30, 64, 60, 67, 63, 64, 42, 63, 64, 54, 53, 27, 63, 63, 67,
33, 66, 65, 64, 53, 63, 27, 43, 21, 63, 62, 61, 64, 54, 62, 62,
64, 58, 19, 64, 59, 22, 66, 23, 63, 51, 66, 60, 64, 54, 26, 67,
43, 64, 65, 51, 32, 54, 64, 24, 65, 65, 49, 62, 62, 57, 49, 40,
60, 65, 60, 51, 32, 60, 62, 60, 60, 25, 65, 59, 34, 12, 60, 57,
43, 63, 61, 46, 63, 62, 64, 62, 61, 59, 62, 23, 22, 57, 65, 66,
59, 63, 3, 65, 36, 60, 62, 23, 62, 57, 59, 56, 22, 64, 65, 57,
59, 64, 62, 64, 46, 30, 57, 60, 31, 16, 31, 64, 64, 41, 62, 64,
62, 62, 63, 58, 41, 59, 64, 60, 35, 63, 60, 64, 64, 65, 21, 63,
43, 62, 65, 40, 20, 38, 53, 60, 60, 42, 23, 63, 2, 61, 59, 22,
55, 51, 49, 63, 28, 41, 38, 48, 64, 31, 63, 56, 64, 62, 62, 59,
45, 58, 63, 15, 22, 60, 60, 63, 62, 27, 61, 62, 57, 61, 64, 46,
64, 59, 58, 11, 37, 60, 64, 59, 18, 63, 58, 64, 62, 60, 37, 62,
60, 62, 53, 62, 50, 60, 40, 30, 35, 63, 61, 62, 60, 62, 62, 62,
62, 61, 33, 62, 60, 61, 61, 64, 58, 56, 60, 57, 59, 61, 60, 4,
57, 60, 57, 43, 63, 61, 14, 60, 25, 62, 39, 28, 60, 45, 33, 59,
61, 38, 60, 61, 33, 20, 61, 58, 59, 61, 62, 55, 62, 62, 51, 60,
7, 53, 19, 56, 31, 58, 60, 54, 58, 56, 60, 49, 11, 57, 39, 58,
60, 62, 59, 62, 52, 56, 59, 59, 46, 61, 45, 56, 59, 21, 58, 59,
62, 19, 57, 59, 61, 60, 46, 58, 56, 13, 57, 14, 57, 32, 22, 61,
60, 45, 53, 56, 62, 59, 60, 62, 36, 51, 57, 32, 24, 58, 56, 59,
29, 32, 56, 60, 57, 58, 58, 33, 17, 62, 59, 31, 48, 59, 58, 58,
59, 26, 57, 32, 60, 53, 59, 62, 43, 59, 56, 56, 57, 62, 57, 56,
57, 54, 49, 44, 56, 60, 61, 61, 35, 55, 61, 57, 34, 58, 45, 56,
56, 55, 57, 58, 25, 37, 56, 59, 55, 54, 23, 61, 59, 60, 28, 59,
61, 60, 60, 60, 58, 55, 57, 46, 57, 15, 56, 56, 57, 49, 56, 60,
41, 24, 22, 55, 57, 34, 54, 53, 24, 57, 57, 56, 55, 58, 56, 57,
29, 55, 33, 58, 52, 60, 48, 60, 60, 54, 15, 56, 60, 38, 54, 55,
35, 50, 56, 57, 24, 57, 54, 59, 59, 58, 57, 59, 56, 53, 57, 56,
53, 40, 20, 60, 53, 38, 52, 58, 57, 27, 59, 60, 54, 54, 60, 57,
40, 10, 36, 19, 58, 58, 58, 56, 16, 53, 54, 55, 56, 53, 56, 59,
9, 25, 43, 55, 56, 56, 53, 47, 51, 57, 56, 60, 42, 32, 57, 28,
57, 56, 58, 25, 55, 54, 20, 56, 56, 38, 35, 57, 46, 58, 56, 14,
55, 55, 56, 41, 53, 30, 35, 18, 24, 56, 58, 57, 3, 29, 59, 56,
58, 13, 57, 56, 51, 56, 39, 55, 56, 43, 56, 42, 53, 52, 54, 56,
55, 57, 55, 50, 41, 56, 10, 27, 54, 55, 45, 55, 53, 55, 38, 55,
12, 56, 49, 55, 54, 34, 52, 43, 51, 26, 55, 34, 20, 55, 55, 28,
54, 51, 47, 19, 34, 58, 51, 56, 25, 53, 50, 55, 57, 52, 56, 52,
53, 54, 55, 54, 56, 55, 47, 48, 58, 48, 45, 51, 58, 47, 55, 22,
55, 34, 56, 47, 26, 55, 49, 54, 54, 54, 49, 53, 24, 7, 55, 55,
56, 55, 47, 57, 52, 52, 46, 32, 8, 57, 54, 58, 57, 47, 51, 53,
53, 46, 46, 54, 49, 38, 52, 54, 54, 6, 45, 57, 56, 53, 54, 49,
56, 29, 56, 46, 52, 51, 53, 49, 31, 53, 19, 55, 56, 55, 16, 51,
31, 42, 54, 56, 12, 38, 45, 19, 54, 48, 52, 54, 6, 51, 50, 55,
35, 21, 49, 51, 49, 13, 48, 5, 57, 7, 30, 40, 47, 54, 57, 50,
53, 53, 54, 48, 45, 49, 54, 53, 52, 23, 47, 51, 50, 50, 5, 30,
54, 47, 47, 53, 50, 54, 52, 13, 37, 28, 46, 46, 54, 55, 54, 51,
53, 53, 52, 51, 56, 45, 52, 45, 22, 46, 50, 47, 53, 55, 50, 55,
40, 54, 44, 39, 53, 54, 53, 53, 10, 8, 14, 53, 53, 55, 46, 43,
40, 38, 8, 14, 53, 50, 52, 55, 51, 28, 41, 21, 53, 54, 51, 53,
46, 49, 52, 54, 55, 53, 8, 51, 47, 43, 50, 43, 49, 53, 28, 54,
49, 42, 46, 52, 5, 55, 52, 50, 50, 52, 48, 51, 18, 53, 20, 49,
32, 50, 51, 7, 52, 50, 50, 53, 49, 50, 25, 49, 18, 53, 9, 54,
54, 49, 13, 41, 54, 9, 32, 28, 43, 54, 51, 40, 55, 44, 52, 25,
28, 50, 51, 53, 54, 22, 52, 52, 11, 11, 55, 52, 54, 50, 48, 18,
6, 51, 52, 15, 53, 42, 52, 20, 52, 53, 35, 44, 43, 51, 14, 31,
38, 35, 19, 54, 34, 49, 49, 54, 44, 24, 55, 32, 38, 15, 40, 50,
18, 24, 46, 7, 48, 6, 42, 18, 52, 40, 49, 52, 7, 36, 48, 32,
51, 6, 37, 45, 53, 52, 45, 50, 47, 49, 52, 53, 40, 29, 51, 28,
54, 53, 42, 34, 50, 24, 47, 54, 54, 7, 43, 48, 38, 42, 19, 37,
46, 47, 47, 47, 47, 42, 50, 51, 46, 17, 49, 7, 10, 10, 52, 53,
11, 49, 39, 46, 52, 43, 53, 50, 48, 50, 44, 39, 32, 11, 43, 49,
47, 10, 47, 48, 37, 44, 53, 53, 51, 45, 48, 51, 49, 45, 45, 49,
26, 50, 50, 50, 47, 50, 52, 51, 47, 22, 49, 24, 49, 50, 20, 51,
47, 52, 17, 21, 51, 48, 21, 48, 8, 46, 48, 47, 47, 48, 48, 50,
53, 45, 11, 48, 48, 48, 52, 49, 52, 37, 47, 42, 37, 50, 12, 52,
28, 44, 48, 13, 50, 50, 44, 48, 31, 52, 50, 51, 49, 49, 37, 49,
48, 4, 46, 13, 14, 48, 16, 49, 48, 43, 47, 17, 48, 46, 47, 38,
45, 48, 51, 52, 50, 48, 48, 16, 34, 23, 40, 24, 39, 16, 48, 49,
17, 47, 50, 49, 43, 50, 15, 46, 45, 46, 47, 47, 34, 44, 47, 46,
23, 49, 52, 46, 47, 48, 31, 7, 18, 46, 48, 50, 6, 48, 48, 49,
21, 46, 51, 39, 2, 47, 47, 46, 50, 51, 42, 39, 25, 36, 19, 18,
50, 47, 39, 47, 47, 15, 21, 44, 47, 49, 51, 47, 48, 47, 34, 20,
47, 47, 45, 49, 50, 28, 44, 41, 46, 48, 8, 21, 47, 41, 29, 45,
49, 44, 47, 50, 47, 37, 7, 7, 21, 48, 49, 44, 15, 48, 43, 47,
44, 42, 50, 47, 47, 5, 7, 27, 30, 37, 49, 47, 12, 45, 32, 26,
12, 25, 45, 43, 48, 50, 18, 13, 31, 23, 50, 46, 23, 8, 35, 47,
45, 14, 47, 15, 42, 11, 39, 45, 49, 11, 35, 43, 29, 42, 25, 40,
14, 8, 47, 10, 47, 34, 29, 33, 9, 43, 38, 44, 38, 4, 46, 38,
46, 27, 45, 36, 15, 45, 38, 47, 44, 48, 45, 41, 27, 5, 41, 15,
44, 42, 31, 40, 41, 13, 10, 47, 10, 46, 47, 48, 45, 28, 30, 39,
48, 31, 44, 44, 18, 44, 44, 46, 34, 32, 35, 43, 42, 42, 45, 25,
39, 45, 42, 36, 44, 5, 43, 15, 46, 42, 44, 41, 44, 47, 18, 32,
25, 42, 39, 12, 6, 40, 20, 41, 17, 46, 40, 35, 43, 43, 4, 27,
44, 40, 42, 14, 43, 44, 44, 43, 43, 38, 35, 47, 45, 44, 3, 7,
44, 46, 42, 44, 9, 29, 47, 31, 41, 41, 46, 27, 11, 44, 45, 44,
45, 36, 32, 42, 42, 42, 43, 12, 14, 4, 43, 43, 42, 43, 5, 40,
42, 45, 46, 43, 40, 38, 43, 34, 38, 25, 45, 44, 14, 42, 41, 44,
10, 41, 37, 42, 30, 43, 43, 29, 41, 6, 29, 26, 40, 43, 42, 16,
43, 46, 43, 40, 28, 40, 26, 43, 42, 30, 42, 42, 42, 43, 15, 45,
41, 3, 41, 42, 42, 38, 10, 18, 40, 9, 44, 40, 45, 42, 6, 42,
40, 42, 41, 6, 23, 41, 45, 43, 40, 43, 42, 41, 29, 40, 42, 18,
11, 36, 15, 42, 24, 38, 40, 43, 33, 10, 32, 40, 42, 36, 41, 40,
41, 6, 3, 42, 30, 16, 44, 40, 45, 20, 12, 21, 42, 42, 39, 13,
33, 20, 27, 3, 41, 36, 32, 36, 7, 27, 40, 31, 45, 42, 45, 45,
39, 44, 39, 43, 42, 43, 15, 35, 39, 19, 28, 41, 38, 40, 39, 31,
37, 41, 40, 44, 41, 38, 41, 38, 6, 40, 42, 19, 9, 41, 41, 43,
36, 16, 42, 41, 40, 10, 29, 42, 39, 32, 43, 36, 43, 41, 40, 41,
44, 38, 39, 20, 39, 43, 39, 41, 43, 1, 42, 40, 32, 38, 40, 38,
38, 38, 29, 3, 39, 40, 39, 18, 43, 44, 40, 43, 39, 42, 40, 28,
35, 41, 42, 39, 42, 36, 41, 40, 35, 40, 40, 40, 37, 39, 39, 39,
41, 40, 32, 37, 40, 15, 26, 33, 37, 31, 40, 40, 30, 36, 39, 36,
19, 5, 39, 41, 40, 4, 37, 41, 41, 42, 21, 17, 42, 35, 4, 3, 42,
35, 12, 36, 42, 40, 40, 17, 38, 39, 37, 41, 39, 39, 40, 39, 37,
37, 42, 40, 41, 42, 35, 39, 39, 30, 39, 38, 37, 15, 28, 24, 38,
37, 31, 1, 12, 14, 29, 38, 28, 37, 36, 35, 38, 10, 5, 10, 36,
42, 42, 25, 42, 38, 6, 39, 40, 41, 41, 36, 42, 41, 38, 38, 40,
21, 41, 37, 7, 36, 17, 36, 38, 21, 37, 3, 7, 41, 38, 37, 35,
37, 6, 27, 41, 37, 40, 38, 38, 12, 36, 34, 41, 18, 34, 35, 38,
40, 37, 37, 5, 36, 38, 37, 39, 38, 42, 38, 31, 37, 32, 38, 40,
35, 40, 36, 38, 34, 39, 39, 37, 38, 34, 41, 36, 39, 38, 30, 37,
36, 38, 34, 33, 36, 40, 26, 8, 6, 37, 36, 36, 23, 25, 34, 39,
34, 30, 21, 35, 36, 39, 37, 37, 36, 36, 25, 37, 34, 38, 35, 35,
36, 3, 34, 36, 35, 37, 40, 36, 37, 39, 36, 36, 37, 36, 23, 17,
37, 35, 17, 37, 6, 36, 36, 38, 37, 7, 4, 34, 37, 36, 36, 34,
36, 35, 34, 36, 35, 39, 28, 37, 37, 36, 38, 35, 36, 35, 16, 37,
34, 36, 37, 36, 35, 30, 39, 36, 36, 26, 32, 36, 36, 35, 29, 35,
23, 39, 35, 36, 35, 13, 35, 35, 39, 33, 36, 35, 27, 36, 30, 36,
39, 37, 35, 30, 4, 32, 3, 34, 24, 36, 36, 36, 33, 36, 32, 35,
37, 33, 5, 33, 33, 24, 35, 36, 35, 33, 26, 36, 35, 36, 33, 26,
33, 31, 32, 32, 25, 22, 38, 6, 31, 34, 3, 35, 35, 32, 35, 35,
31, 32, 9, 34, 3, 35, 34, 33, 9, 18, 33, 32, 35, 35, 34, 27,
35, 31, 34, 31, 17, 38, 36, 34, 34, 34, 11, 29, 35, 32, 34, 32,
35, 12, 30, 37, 33, 21, 34, 27, 31, 35, 22, 34, 36, 33, 35, 35,
37, 36, 35, 33, 5, 4, 34, 31, 14, 26, 9, 23, 31, 28, 36, 34,
14, 12, 30, 37, 6, 31, 28, 33, 32, 34, 33, 31, 27, 35, 6, 27,
30, 31, 30, 29, 16, 31, 34, 35, 32, 26, 25, 28, 31, 23, 21, 30,
27, 32, 33, 16, 30, 31, 31, 32, 34, 20, 29, 28, 16, 6, 26, 30,
29, 20, 28, 50, 133, 133, 1, 133, 40, 14, 133, 133, 39, 133,
133, 132, 132, 132, 132, 132, 132, 132, 132, 132, 114, 132, 89,
132, 67, 132, 33, 76, 60, 47, 132, 132, 132, 131, 24, 131, 131,
131, 131, 131, 131, 131, 112, 83, 111, 131, 131, 131, 116, 50,
116, 131, 131, 63, 131, 131, 131, 131, 110, 131, 98, 131, 131,
88, 23, 131, 21, 131, 51, 130, 130, 130, 130, 130, 130, 35, 130,
130, 129, 126, 129, 129, 123, 129, 129, 129, 129, 129, 129, 129,
129, 129, 129, 129, 129, 110, 39, 129, 129, 15, 129, 129, 100,
118, 53, 128, 128, 128, 29, 128, 47, 128, 13, 111, 128, 50, 128,
118, 67, 128, 128, 128, 128, 25, 127, 127, 127, 126, 50, 67,
126, 126, 53, 28, 25, 126, 126, 43, 24, 126, 36, 126, 126, 126,
33, 9, 125, 95, 125, 125, 125, 113, 125, 125, 125, 91, 74, 5,
121, 125, 125, 125, 70, 124, 55, 119, 119, 36, 34, 106, 124,
124, 64, 79, 124, 124, 99, 124, 124, 110, 124, 124, 124, 123,
105, 123, 11, 75, 123, 102, 110, 123, 123, 71, 60, 36, 123, 123,
27, 123, 93, 39, 123, 123, 123, 123, 123, 41, 123, 48, 122, 43,
122, 82, 122, 122, 82, 83, 98, 60, 86, 122, 100, 59, 122, 122,
108, 31, 122, 122, 122, 3, 45, 16, 36, 97, 89, 39, 121, 55, 100,
121, 37, 121, 17, 22, 120, 33, 60, 42, 120, 86, 120, 120, 120,
111, 89, 120, 98, 120, 120, 120, 60, 120, 18, 13, 120, 109, 120,
120, 119, 119, 24, 119, 27, 104, 119, 6, 18, 49, 119, 23, 119,
119, 3, 119, 97, 119, 119, 73, 9, 119, 99, 119, 12, 118, 118,
118, 118, 102, 118, 118, 119, 58, 118, 34, 86, 118, 47, 118,
118, 26, 117, 117, 117, 117, 117, 117, 28, 117, 45, 9, 117, 117,
117, 26, 117, 8, 117, 35, 117, 116, 82, 116, 116, 116, 69, 46,
116, 116, 32, 116, 116, 116, 116, 116, 97, 70, 116, 69, 37, 116,
116, 116, 116, 116, 31, 99, 16, 73, 56, 47, 116, 29, 115, 35,
103, 80, 22, 114, 114, 68, 37, 52, 67, 114, 49, 114, 114, 114,
113, 22, 113, 113, 113, 113, 113, 105, 113, 113, 113, 6, 91,
113, 113, 113, 103, 91, 113, 113, 85, 91, 113, 100, 113, 113,
113, 39, 72, 85, 112, 112, 106, 112, 112, 112, 10, 72, 35, 112,
55, 112, 46, 112, 112, 112, 112, 112, 32, 112, 73, 80, 99, 112,
17, 111, 14, 111, 111, 111, 111, 111, 57, 111, 75, 111, 111,
15, 111, 80, 111, 62, 8, 42, 56, 111, 111, 22, 78, 103, 57, 110,
110, 110, 9, 25, 64, 96, 59, 14, 61, 52, 110, 110, 109, 118,
144, 210, 150, 200, 204, 150, 203, 167, 196, 198, 204, 203, 209,
147, 197, 195, 207, 201, 170, 182, 182, 210, 196, 207, 217, 201,
204, 196, 210, 203, 160, 197, 182, 208, 205, 211, 141, 205, 179,
136, 196, 201, 211, 159, 132, 200, 205, 160, 146, 172, 209, 211,
212, 202, 206, 204, 204, 214, 163, 188, 208, 123, 199, 158, 176,
207, 135, 201, 173, 174, 212, 146, 177, 208, 171, 200, 174, 135,
129, 199, 200, 203, 216, 195, 215, 160, 180, 202, 198, 205, 203,
205, 210, 209, 201, 134, 208, 125, 203, 116, 199, 129, 212, 208,
205, 214, 199, 208, 210, 211, 199, 205, 211, 210, 152, 128, 210,
198, 198, 200, 211, 213, 203, 215, 199, 181, 189, 204, 211, 136,
140, 203, 149, 208, 198, 126, 171, 216, 212, 148, 142, 199, 209,
139, 211, 195, 198, 154, 137, 201, 211, 127, 205, 198, 211, 197,
158, 126, 212, 205, 200, 207, 203, 210, 212, 203, 181, 211, 216,
201, 208, 167, 151, 200, 144, 207, 183, 141, 212, 195, 203, 158,
202, 209, 204, 185, 127, 215, 210, 177, 211, 195, 145, 198, 173,
211, 202, 186, 207, 205, 208, 209, 174, 209, 207, 130, 212, 215,
213, 211, 212, 214, 203, 203, 214, 134, 214, 199, 187, 133, 203,
138, 214, 131, 115, 215, 130, 202, 209, 211, 200, 174, 212, 203,
201, 191, 214, 137, 203, 204, 204, 170, 204, 203, 140, 152, 151,
203, 128, 128, 210, 195, 202, 179, 211, 209, 208, 162, 119, 147,
202, 211, 215, 200, 204, 205, 132, 208, 208, 210, 212, 205, 211,
211, 202, 199, 134, 188, 133, 170, 181, 170, 147, 199, 205, 210,
216, 203, 163, 217, 155, 203, 155, 216, 209, 210, 145, 198, 212,
211, 215, 192, 170, 216, 216, 214, 212, 210, 211, 205, 199, 173,
209, 203, 202, 215, 197, 199, 198, 214, 203, 201, 171, 205, 148,
214, 203, 194, 208, 209, 141, 203, 209, 198, 136, 210, 196, 197,
149, 202, 136, 176, 146, 157, 205, 121, 197, 203, 128, 199, 200,
214, 125, 120, 204, 216, 159, 200, 139, 210, 217, 192, 182, 203,
146, 202, 210, 214, 200, 199, 202, 200, 211, 188, 201, 200, 160,
217, 167, 209, 143, 142, 142, 200, 204, 196, 202, 216, 200, 203,
196, 137, 195, 212, 215, 157, 212, 211, 207, 193, 136, 210, 194,
137, 211, 204, 204, 214, 200, 118, 202, 209, 215, 201, 203, 203,
136, 204, 211, 121, 213, 214, 210, 166, 126, 129, 196, 203, 214,
214, 145, 208, 136, 211, 202, 213, 211, 201, 210, 196, 208, 211,
208, 198, 216, 211, 214, 140, 193, 177, 191, 205, 201, 169, 208,
198, 214, 143, 198, 199, 181, 201, 176, 172, 212, 136, 178, 184,
214, 205, 217, 204, 203, 210, 144, 198, 201, 213, 207, 208, 183,
202, 182, 203, 212, 216, 217, 202, 199, 168, 194, 190, 185, 202,
186, 202, 134, 199, 192, 203, 213, 195, 149, 188, 205, 198, 182,
158, 153, 156, 212, 19, 84, 106, 82, 119, 100, 22, 42, 102, 128,
64, 16, 59, 55, 64, 75, 48, 35, 87, 54, 32, 111, 87, 41, 97,
102, 36, 69, 60, 30, 105, 17, 15, 52, 123, 63, 73, 11, 101, 22,
67, 112, 110, 34, 29, 90, 122, 81, 36, 24, 22, 69, 24, 56, 45,
46, 68, 102, 33, 46, 7, 103, 45, 109, 15, 149, 72, 92, 56, 118,
40, 113, 10, 13, 51, 107, 72, 88, 18, 108, 33, 72, 12, 60, 22,
31, 104, 19, 13, 90, 40, 86, 37, 36, 40, 4, 50, 36, 63, 70, 33,
70, 87, 6, 122, 4, 214, 99, 121, 39, 37, 122, 93, 67, 89, 106,
53, 86, 63, 70, 122, 85, 103, 44, 83, 77, 50, 39, 86, 74, 91,
84, 46, 71, 129, 16, 96, 100, 119, 77, 48, 214, 60, 82, 92, 118,
65, 83, 73, 96, 108, 205, 32, 109, 209, 61, 19, 120, 87, 100,
84, 74, 119, 10, 103, 112, 45, 112, 126, 36, 49, 119, 68, 52,
61, 16, 14, 91, 124, 31, 74, 121, 92, 107, 105, 47, 63, 110,
208, 58, 32, 94, 27, 87, 118, 74, 38, 91, 111, 63, 47, 28, 67,
62, 47, 68, 58, 62, 21, 84, 207, 40, 21, 108, 80, 55, 60, 93,
83, 67, 96, 100, 28, 97, 40, 22, 80, 90, 97, 36, 110, 35, 95,
94, 66, 116, 101, 88, 39, 60, 68, 109, 71, 70, 27, 103, 64, 23,
92, 45, 78, 14, 87, 109, 101, 98, 84, 111, 57, 109, 110, 24,
52, 80, 114, 96, 96, 36, 108, 48, 59, 196, 43, 113, 190, 32,
34, 36, 72, 47, 95, 8, 92, 128, 100, 94, 117, 117, 109, 49, 78,
59, 22, 112, 27, 32, 125, 49, 16, 71, 122, 148, 92, 83, 57, 166,
21, 40, 107, 55, 24, 109, 112, 51, 44, 111, 114, 55, 105, 97,
33, 52, 24, 66, 98, 2, 23, 104, 4, 107, 51, 76, 112, 97, 32,
5, 101, 15, 42, 69, 64, 90, 117, 107, 120, 99, 102, 73, 81, 82,
81, 83, 95, 77, 101, 87, 132, 33, 30, 93, 126, 121, 21, 30, 27,
112, 108, 8, 103, 80, 123, 53, 24, 33, 81, 61, 38, 125, 95, 40,
71, 57, 125, 145, 55, 1, 96, 113, 80, 3, 23, 38, 158, 108, 104,
11, 6, 79, 134, 74, 40, 111, 110, 96, 126, 33, 105, 22, 23, 70,
44, 10, 55, 81, 86, 122, 107, 18, 104, 112, 23, 109, 115, 102,
110, 103, 112, 50, 78, 105, 73, 89, 96, 95, 69, 60, 71, 28, 62,
15, 91, 28, 66, 28, 121, 71, 6, 135, 18, 15, 118, 80, 135, 61,
107, 49, 104, 103, 55, 103, 12, 102, 100, 67, 34, 168, 159, 114,
13, 36, 128, 28, 43, 57, 106, 97, 15, 99, 4, 84, 90, 123, 90,
16, 52, 75, 76, 70, 76, 95, 105, 104, 70, 76, 65, 10, 62, 64,
27, 37, 88, 44, 95, 56, 47, 122, 80, 88, 11, 64, 63, 94, 38,
90, 61, 62, 64, 91, 56, 66, 79, 86, 89, 41, 26, 86, 52, 16, 2,
124, 108, 62, 3, 73, 33, 59, 29, 29, 78, 78, 69, 82, 32, 78,
120, 6, 133, 123, 61, 101, 44, 8, 29, 87, 5, 80, 3, 30, 79, 83,
58, 69, 54, 30, 11, 117, 117, 87, 43, 81, 57, 47, 60, 16, 109,
76, 65, 81, 2, 89, 79, 55, 114, 29, 6, 110, 110, 90, 92, 21,
104, 65, 103, 79, 33, 44, 8, 45, 118, 51, 77, 65, 77, 48, 38,
90, 29, 50, 112, 102, 36, 20, 50, 31, 1, 7, 63, 95, 69, 42, 11,
3, 1, 39, 95, 23, 73, 26, 72, 43, 30, 18, 33, 45, 60, 36, 55,
51, 91, 8, 47, 57, 61, 72, 48, 44, 53, 25, 35, 72, 68, 20, 59,
7, 59, 12, 83, 53, 31, 60, 15, 84, 32, 29, 47, 73, 54, 50, 25,
46, 63, 52, 52, 45, 18, 31, 34, 45, 31, 21, 8, 29, 24, 77, 13,
79, 42, 40, 10, 29, 34, 32, 31, 28, 28, 34, 27, 30, 32, 23, 55,
43, 28, 6, 9, 69, 48, 48, 37, 49, 54, 40, 36, 25, 19, 26, 15,
30, 27, 31, 1, 18, 6, 26, 22, 9, 24, 19, 28, 20, 24, 25, 31,
61, 10, 50, 43, 42, 42, 41, 41, 40, 25, 24, 81, 1, 25, 14, 1,
14, 23, 28, 1, 8, 12, 27, 22, 17, 16, 20, 1, 26, 10, 17, 20,
25, 23, 3, 25, 45, 32, 20, 31, 31, 40, 47, 1, 28, 31, 30, 30,
30, 31, 2, 16, 23, 28, 1, 14, 22, 24, 7, 23, 1, 24, 27, 23, 12,
22, 1, 18, 14, 19, 22, 1, 3, 1, 22, 21, 12, 18, 8, 17, 6, 9,
3, 2, 2, 19, 2, 17, 28, 18, 1, 14, 14, 2, 16, 18, 18, 37, 14,
16, 18, 4, 15, 2, 32, 32, 48, 13, 7, 9, 6, 4, 4, 3, 26, 4, 10,
9, 8, 2, 8, 4, 10, 4, 40, 4, 25, 13, 40, 18, 24, 24, 2, 2, 30,
30, 10, 22, 15, 11, 10, 24, 13, 18, 22, 21, 16, 16, 17, 18, 4,
19, 19, 20, 16, 12, 19, 18, 20, 16, 21, 22, 5, 34, 8, 12, 17,
20, 16, 11, 6, 12, 9, 19, 55, 8, 13, 22, 16, 6, 20, 15, 20, 15,
12, 12, 20, 7, 16, 3, 7, 11, 12, 14, 12, 16, 12, 12, 11, 14,
12, 12, 20, 11, 12, 13, 10, 14, 12, 11, 8, 12, 13, 16, 16, 11,
15, 2, 11, 12, 10, 11, 10, 12, 13, 12, 5, 6, 19, 11, 9, 13, 6,
12, 10, 4, 10, 12, 2, 3, 6, 18, 7, 15, 17, 12, 3, 17, 10, 15,
60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 9.5999999999999996, 19.199999999999999,
60, 60, 60, 1.2, 60, 55.200000000000003, 2.3999999999999999,
60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 62.399999999999999,
60, 60, 60, 32.399999999999999, 60, 60, 20.399999999999999, 60,
60, 60, 60, 60, 60, 60, 60, 60, 60, 22.800000000000001, 60, 60,
60, 60, 60, 60, 60, 60, 60, 56.399999999999999, 60, 60, 60, 60,
60, 60, 60, 60, 44.399999999999999, 60, 60, 60, 24, 60, 60, 60,
10.800000000000001, 60, 18, 60, 60, 16.800000000000001, 60, 60,
60, 26.399999999999999, 22.800000000000001, 60, 1.2, 60, 60,
12, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 8.4000000000000004,
12, 60, 60, 39.600000000000001, 60, 60, 60, 60, 60, 60, 60, 60,
60, 7.2000000000000002, 37.200000000000003, 60, 60, 60, 60, 9.5999999999999996,
60, 20.399999999999999, 6, 60, 60, 7.2000000000000002, 60, 60,
60, 50.399999999999999, 60, 26.399999999999999, 60, 60, 60, 60,
60, 60, 60, 60, 60, 60, 60, 60, 60, 12, 60, 60, 60, 60, 60, 60,
60, 60, 60, 60, 58.799999999999997, 58.799999999999997, 60, 60,
60, 60, 60, 61.200000000000003, 60, 39.600000000000001, 19.199999999999999,
15.6, 60, 60, 60, 60, 60, 60, 60, 60, 22.800000000000001, 60,
60, 60, 89, 46, 85, 85, 43, 58, 74, 70, 52, 41, 51, 62, 58, 62,
63, 75, 65, 45, 51, 34, 58, 67, 49, 94, 44, 37, 47, 74, 77, 85,
44, 26, 37, 73, 32, 39, 51, 79, 71, 43, 45, 15, 64, 74, 64, 69,
48, 47, 71, 84, 70, 34, 34, 58, 104, 51, 41, 62, 61, 36, 67,
61, 49, 5, 45, 104, 36, 53, 39, 30, 70, 52, 30, 64, 9, 60, 32,
65, 55, 30, 78, 61, 61, 45, 28, 61, 45, 59, 76, 59, 41, 23, 65,
83, 24, 68, 47, 19, 47, 58, 13, 60, 93, 35, 50, 51, 44, 64, 59,
61, 62, 37, 48, 65, 67, 63, 56, 37, 37, 56, 69, 51, 69, 58, 59,
87, 11, 63, 59, 64, 53, 64, 43, 88, 60, 64, 47, 64, 69, 90, 48,
59, 43, 39, 17, 48, 65, 96, 30, 41, 52, 95, 63, 69, 23, 67, 99,
53, 63, 63, 45, 35, 71, 14, 49, 59, 76, 59, 102, 66, 88, 49,
24, 104, 75, 42, 52, 48, 49, 39, 104, 65, 64, 53, 82, 60, 60,
98, 93, 41, 57, 77, 85, 73, 68, 62, 57, 35, 104, 69, 19, 20,
37, 38, 104, 28, 68, 1, 34, 46, 24, 63, 22, 91, 84, 50, 3, 21,
36, 70, 23, 25, 4, 13, 73, 12, 47, 73, 12, 47, 21, 11, 101, 9,
51, 34, 36, 23, 48, 35, 65, 25, 70, 21, 56, 21, 98, 18, 35, 66,
19, 39, 16, 60, 48, 40, 60, 60, 60, 11, 60, 29, 18, 60, 60, 60,
14, 4, 60, 4, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 40,
60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 47, 48, 60, 60, 60, 25,
60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 2, 60, 60, 55, 60, 60,
60, 51, 60, 60, 53, 26, 60, 39, 60, 60, 60, 60, 44, 60, 51.399999999999999,
66.099999999999994, 47.200000000000003, 42.200000000000003, 26.600000000000001,
51.399999999999999, 53.299999999999997, 42.399999999999999, 53,
52.5, 72.299999999999997, 45.399999999999999, 53, 41.899999999999999,
47.200000000000003, 45.200000000000003, 36.5, 52.899999999999999,
33.299999999999997, 35.5, 61.200000000000003, 45.200000000000003,
53.299999999999997, 33.799999999999997, 53.200000000000003, 52.399999999999999,
55.299999999999997, 53, 37.100000000000001, 68.299999999999997,
34.299999999999997, 53.799999999999997, 53.5, 42.299999999999997,
55.600000000000001, 51.600000000000001, 41.299999999999997, 52.899999999999999,
35.899999999999999, 45.200000000000003, 49.200000000000003, 53.299999999999997,
35, 45.200000000000003, 54.399999999999999, 35.200000000000003,
72.900000000000006, 61.600000000000001, 60.100000000000001, 52.899999999999999,
12, 84, 84, 84, 84, 84, 82.799999999999997, 82.799999999999997,
82.799999999999997, 80.400000000000006, 79.200000000000003, 79.200000000000003,
79.200000000000003, 75.599999999999994, 75.599999999999994, 74.400000000000006,
81.599999999999994, 38.399999999999999, 80.400000000000006, 14.4,
76.799999999999997, 78, 26.399999999999999, 54, 52.799999999999997,
84, 79.200000000000003, 79.200000000000003, 79.200000000000003,
76.799999999999997, 6, 70.799999999999997, 7.2000000000000002,
63.600000000000001, 61.200000000000003, 14.4, 56.399999999999999,
37.200000000000003, 61.200000000000003, 60, 61.200000000000003,
60, 56.399999999999999, 56.399999999999999, 61.200000000000003,
44.399999999999999, 61.200000000000003, 55.200000000000003, 60,
22.800000000000001, 36, 1.2, 16.800000000000001, 37.200000000000003,
68.400000000000006, 50.399999999999999, 57.600000000000001, 38.399999999999999,
33, 14, 55, 22, 40, 10, 23, 37, 12, 45, 37, 28, 13, 15, 18, 12,
44, 4, 22, 46, 41, 49, 6, 35, 45, 15, 43, 52, 51, 52, 20, 45,
51, 42, 50, 9, 14, 47, 53, 0, 52, 33, 19, 45, 32, 18, 33, 50,
36, 52, 46, 27, 50, 53, 47, 26, 25, 28, 14, 35, 29, 3, 45, 41,
12, 46, 47, 17, 2, 1, 51, 19, 0, 53, 17, 18, 8, 35, 30, 8, 10,
15, 47, 29, 38, 54, 43, 12, 44, 47, 20, 13, 32, 43, 51, 29, 33,
55, 30, 47, 40, 9, 49, 52, 56, 29, 3, 6, 54, 29, 47, 46, 52,
51, 38, 34, 47, 19, 48, 31, 47, 24, 40, 46, 24, 55, 14, 53, 23,
48, 38, 12, 50, 46, 0, 28, 53, 44, 53, 44, 52, 43, 37, 38, 43,
21, 48, 19, 24, 30, 35, 19, 33, 49, 50, 38, 22, 22, 31, 23, 38,
26, 52, 37, 15, 44, 27, 44, 52, 27, 8, 52, 41, 55, 28, 3, 9,
45, 11, 42, 43, 37, 45, 18, 6, 56, 52, 46, 43, 15, 43, 42, 16,
25, 48, 38, 48, 31, 49, 32, 12, 11, 46, 24, 13, 4, 56, 5, 13,
50, 30, 48, 41, 54, 37, 46, 25, 16, 7, 46, 42, 47, 4, 2, 39,
43, 34, 49, 52, 24, 16, 48, 46, 25, 44, 10, 53, 12, 37, 17, 44,
41, 22, 35, 51, 51, 54, 39, 47, 46, 47, 51, 49, 41, 1, 45, 19,
28, 39, 44, 39, 21, 26, 48, 48, 50, 25, 48, 39, 7, 30, 49, 59,
40, 34, 51, 51, 3, 56, 28, 17, 3, 40, 44, 45, 50, 46, 47, 40,
28, 40, 14, 42, 39, 48, 23, 31, 11, 8, 29, 35, 54, 12, 47, 48,
24, 26, 41, 38, 18, 43, 26, 40, 23, 47, 51, 8, 41, 28, 0, 16,
9, 12, 22, 49, 18, 11, 26, 26, 18, 15, 38, 36, 34, 26, 12, 34,
20, 48, 47, 50, 6, 13, 14, 37, 34, 42, 6, 50, 11, 52, 43), alive1_death2 = c(1L,
1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 1L,
2L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L,
1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L,
2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
2L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 2L, 1L, 1L,
1L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L,
1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L,
1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L,
1L, 1L, 1L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 2L, 1L, 2L,
1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 1L,
2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 2L, 1L, 2L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L,
1L, 1L, 2L, 2L, 2L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 2L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 2L,
1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 2L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L,
1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L,
2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 2L, 1L,
1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 1L, 2L, 2L, 1L, 2L, 1L,
2L, 2L, 1L, 2L, 2L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 2L, 1L,
2L, 2L, 2L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 2L,
2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 2L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 2L, 1L, 2L,
2L, 1L, 2L, 2L, 1L, 2L, 2L, 1L, 2L, 1L, 2L, 2L, 1L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 1L,
1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L,
2L, 1L, 2L, 1L, 2L, 1L, 2L, 2L, 1L, 2L, 1L, 2L, 2L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 2L, 2L, 2L, 1L, 2L, 1L, 1L, 2L, 2L, 2L, 1L, 1L,
1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 1L,
1L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 1L, 2L, 2L, 1L, 1L, 2L, 2L, 1L,
1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 1L, 2L, 1L,
2L, 1L, 2L, 1L, 2L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L,
2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L,
2L, 1L, 2L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 2L, 1L, 1L, 2L,
1L, 2L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 1L, 1L, 2L,
1L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L,
1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L,
1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 1L, 1L, 2L, 1L,
2L, 2L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L,
1L, 2L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 2L,
2L, 1L, 1L, 2L, 2L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 2L,
1L, 2L, 2L, 2L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 2L, 2L,
2L, 2L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L,
2L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 2L, 1L, 1L, 2L, 2L, 2L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 2L,
2L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 1L,
2L, 2L, 1L, 2L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L,
2L, 1L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L,
2L, 1L, 2L, 1L, 2L, 2L, 1L, 2L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 1L, 2L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L,
1L, 2L, 2L, 2L, 1L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 1L, 1L, 2L, 2L, 2L, 2L,
1L, 2L, 1L, 2L, 1L, 1L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 2L,
1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 1L, 2L, 2L, 1L, 2L, 2L,
2L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L,
1L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 1L, 2L, 2L, 2L, 1L,
2L, 2L, 2L, 2L, 1L, 1L, 2L, 2L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 2L,
2L, 1L, 1L, 2L, 1L, 1L, 2L, 2L, 2L, 2L, 1L, 2L, 1L, 2L, 2L, 1L,
2L, 2L, 2L, 2L, 2L, 1L, 1L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 1L, 2L,
2L, 2L, 2L, 2L, 1L, 2L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 1L, 2L,
2L, 2L, 1L, 2L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 1L, 2L, 1L, 2L, 2L,
2L, 1L, 2L, 2L, 1L, 2L, 2L, 1L, 2L, 1L, 2L, 2L, 1L, 1L, 2L, 1L,
2L, 2L, 1L, 1L, 2L, 2L, 2L, 2L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 1L,
1L, 2L, 2L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 1L, 2L, 1L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 1L, 1L, 2L,
2L, 1L, 2L, 2L, 2L, 2L, 1L, 2L, 1L, 2L, 2L, 1L, 2L, 1L, 2L, 1L,
2L, 1L, 2L, 2L, 1L, 2L, 2L, 1L, 2L, 2L, 2L, 2L, 1L, 2L, 1L, 2L,
1L, 1L, 2L, 2L, 1L, 2L, 1L, 2L, 2L, 1L, 2L, 2L, 1L, 1L, 1L, 2L,
2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 1L, 2L, 2L,
2L, 2L, 2L, 2L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 1L, 1L,
2L, 2L, 2L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 2L, 2L, 1L, 2L,
2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 2L, 2L, 2L, 1L, 1L,
2L, 2L, 2L, 2L, 2L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 2L, 2L, 2L, 2L,
1L, 1L, 2L, 2L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 1L, 1L, 2L, 1L, 2L,
2L, 1L, 2L, 1L, 2L, 2L, 2L, 1L, 2L, 1L, 2L, 2L, 2L, 1L, 1L, 1L,
1L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 1L, 2L, 2L, 2L, 2L, 2L,
1L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 1L, 1L, 1L, 2L, 1L,
1L, 2L, 2L, 1L, 1L, 2L, 1L, 1L, 2L, 2L, 2L, 1L, 1L, 2L, 2L, 1L,
1L, 2L, 2L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 2L, 1L, 2L, 1L, 1L,
2L, 2L, 2L, 2L, 1L, 1L, 1L, 2L, 2L, 2L, 1L, 1L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 2L, 2L, 2L,
2L, 2L, 1L, 1L, 2L, 1L, 2L, 2L, 2L, 1L, 2L, 1L, 2L, 2L, 2L, 1L,
2L, 2L, 1L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 1L,
1L, 1L, 1L, 2L, 2L, 1L, 2L, 2L, 1L, 2L, 1L, 2L, 2L, 1L, 1L, 1L,
2L, 1L, 1L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 1L, 2L,
1L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 2L, 1L,
2L, 2L, 1L, 1L, 1L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 1L, 1L, 2L, 1L,
1L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 1L, 1L,
2L, 2L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 2L, 2L, 1L, 2L, 2L, 2L, 2L,
1L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 1L, 1L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 2L, 1L, 2L, 2L,
2L, 2L, 1L, 2L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 1L,
2L, 2L, 2L, 2L, 2L, 2L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 1L, 2L,
2L, 2L, 1L, 2L, 1L, 2L, 2L, 1L, 2L, 2L, 1L, 1L, 2L, 2L, 2L, 2L,
1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L,
1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
2L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L,
2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 1L, 1L, 2L,
2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L,
1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 2L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L,
1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 1L, 2L,
1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L,
2L, 2L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 2L, 1L, 2L, 1L, 1L,
1L, 1L, 1L, 2L, 1L, 1L, 2L, 2L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 2L,
1L, 1L, 2L, 1L, 1L, 1L, 2L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 1L, 2L, 1L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L,
1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L,
2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L,
1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L,
1L, 1L, 2L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L,
1L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 2L, 1L, 1L,
2L, 1L, 2L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
2L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L,
1L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 2L, 2L,
1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L,
2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 1L,
1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 2L,
1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L,
2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L,
2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 2L, 2L, 1L, 1L,
1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 2L, 2L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 1L, 2L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L,
2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L,
1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L,
2L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L,
1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L,
2L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 2L, 2L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L,
2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 2L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L,
1L, 1L, 1L, 2L, 1L, 1L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L,
1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 2L,
1L, 2L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 2L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 2L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 1L,
1L, 1L, 2L, 1L, 2L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L,
1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 1L, 2L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L,
2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 2L, 2L, 1L, 1L, 2L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 1L, 2L, 1L,
2L, 2L, 2L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
2L, 2L, 2L, 1L, 1L, 1L, 2L, 2L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L,
2L, 1L, 2L, 1L, 1L, 2L, 2L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 2L, 1L, 1L, 2L, 2L, 2L, 1L,
1L, 1L, 2L, 1L, 2L, 1L, 2L, 2L, 1L, 2L, 1L, 2L, 2L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 2L, 2L, 2L, 1L, 1L, 2L,
2L, 1L, 2L, 1L, 1L, 1L, 2L, 2L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 1L,
1L, 2L, 2L, 2L, 2L, 1L, 1L, 1L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L,
1L, 1L, 2L, 2L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L,
2L, 2L, 1L, 2L, 2L, 1L, 1L, 2L, 2L, 2L, 1L, 1L, 2L, 1L, 2L, 2L,
1L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 1L, 2L, 2L,
2L, 2L, 2L, 1L, 2L, 2L, 1L, 1L, 2L, 2L, 1L, 1L, 1L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 1L, 2L, 2L, 1L, 2L, 1L, 2L, 2L, 1L, 2L, 2L, 2L,
1L, 2L, 1L, 1L, 1L, 2L, 2L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 2L, 2L,
1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 2L, 1L, 2L, 2L, 2L, 1L, 2L,
1L, 1L, 2L, 1L, 2L, 1L, 1L, 2L, 2L, 1L, 2L, 1L, 2L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 1L, 2L, 1L, 2L, 2L, 1L, 2L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 1L, 1L, 2L, 1L, 2L, 2L, 1L, 1L, 1L, 2L, 1L, 2L, 1L, 2L,
1L, 1L, 2L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L,
2L, 2L, 1L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L,
1L, 2L, 1L, 2L, 2L, 2L, 2L, 1L, 1L, 2L, 2L, 2L, 2L, 1L, 2L, 1L,
1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 2L, 1L,
1L, 1L, 2L, 2L, 1L, 1L, 2L, 2L, 1L, 2L, 1L, 1L, 1L, 2L, 2L, 2L,
1L, 1L, 2L, 1L, 1L, 1L, 2L, 2L, 2L, 1L, 2L, 1L, 2L, 1L, 1L, 1L,
1L, 1L, 2L, 1L, 2L, 2L, 2L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L,
2L, 1L, 2L, 1L, 1L, 2L, 1L, 2L, 1L, 2L, 2L, 2L, 2L, 1L, 1L, 2L,
2L, 2L, 2L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 1L,
1L, 1L, 2L, 1L, 2L, 2L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 2L,
1L, 1L, 1L, 1L, 2L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L,
2L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 2L, 2L, 1L, 1L, 1L, 2L, 2L, 1L,
1L, 2L, 2L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 2L, 1L, 2L,
1L, 2L, 2L, 1L, 2L, 1L, 2L, 2L, 1L, 2L, 2L, 1L, 2L, 2L, 2L, 2L,
2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
2L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 2L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L,
2L, 1L, 1L, 2L, 2L, 1L, 2L, 1L, 1L, 2L, 2L, 1L, 1L, 2L, 2L, 1L,
1L, 2L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 2L, 2L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 2L, 1L,
2L, 2L, 2L, 2L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 2L,
1L, 2L, 2L, 1L, 2L, 1L, 1L, 2L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 2L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 2L, 2L, 2L,
1L, 2L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 2L, 1L, 2L,
1L, 1L, 1L, 2L, 1L, 1L, 2L, 2L, 2L, 1L, 2L, 2L, 1L, 1L, 1L, 2L,
1L, 1L, 1L, 2L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 1L, 1L,
1L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L,
2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 2L, 2L, 1L, 2L, 1L, 1L, 1L,
2L, 1L, 1L, 1L, 2L, 1L, 2L, 2L, 2L, 2L, 1L, 2L, 1L, 1L, 2L, 1L,
2L, 1L, 2L, 2L, 2L, 1L, 2L, 1L, 2L, 1L, 1L, 2L, 2L, 1L, 2L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 2L, 1L, 2L, 2L,
2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 1L,
1L, 2L, 2L, 1L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L,
1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 2L, 2L, 1L, 1L, 1L, 1L,
2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 2L, 2L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L,
2L, 2L, 1L, 2L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 1L,
1L, 1L, 2L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 1L,
2L, 1L, 2L, 2L, 2L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 2L, 2L, 2L, 2L,
1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 1L, 2L, 2L, 2L, 1L, 1L, 1L,
2L, 2L, 1L, 2L, 2L, 1L, 2L, 2L, 1L, 1L, 2L, 2L, 1L, 1L, 2L, 1L,
1L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 2L,
1L, 1L, 2L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 2L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 1L, 2L,
2L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L,
1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 1L,
1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 1L, 2L, 1L, 1L, 2L,
1L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L,
1L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L,
2L, 1L, 2L, 2L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
2L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L,
1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 2L, 1L, 2L, 2L, 1L,
1L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L,
1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
2L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 1L,
2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L,
1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
2L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 1L, 1L, 2L, 1L, 2L, 2L, 1L, 1L,
1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 2L, 1L, 1L, 2L, 2L, 2L, 2L,
2L, 1L, 1L, 2L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L,
1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 2L, 2L, 1L, 2L, 2L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
2L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L,
1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L,
1L, 1L, 2L, 2L, 1L, 1L, 1L, 2L, 1L, 2L, 2L, 1L, 1L, 1L, 2L, 2L,
1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 2L,
1L, 1L, 2L, 2L, 2L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L,
1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L,
1L, 2L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 2L, 1L,
1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L,
2L, 2L, 2L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L,
1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 1L,
2L, 1L, 2L, 1L, 2L, 1L, 1L, 2L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 2L, 1L, 1L, 2L, 1L, 2L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L,
1L, 1L, 2L, 2L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L,
2L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L), age = c(82, 67, 47, 58, 71,
81, 76, 70, 73, 64, 78, 67, 68, 78, 75, 81, 69, 71, 61, 81, 62,
67, 74, 77, 69, 77, 75, 76, 67, 76, 68, 79, 57, 57, 83, 72, 75,
71, 80, 79, 76, 78, 80, 57, 55, 45, 56, 73, 77, 56, 73, 70, 69,
73, 64, 61, 56, 56, 66, 62, 58, 53, 65, 56, 45, 62, 55, 42, 54,
53, 42, 66, 65, 62, 62, 70, 53, 51, 40, 74, 68, 53, 49, 46, 53,
40, 61, 59, 43, 63, 44, 40, 43, 85, 61, 60, 58, 44, 73, 66, 63,
50, 60, 78, 73, 53, 47, 40, 77, 68, 58, 61, 50, 49, 77, 76, 71,
62, 72, 65, 74, 53, 48, 70, 61, 60, 56, 51, 69, 55, 46, 67, 63,
62, 56, 48, 45, 61, 60, 54, 53, 50, 40, 51, 44, 42, 72, 71, 71,
62, 59, 53, 63, 55, 45, 68, 63, 60, 54, 63, 46, 44, 68, 58, 72,
53, 49, 58, 72, 59, 52, 65, 48, 74, 58, 72, 71, 69, 68, 51, 42,
41, 63, 57, 56, 70, 56, 69, 62, 58, 54, 66, 65, 52, 48, 66, 66,
65, 55, 52, 43, 53, 75, 65, 49, 46, 79, 66, 59, 56, 55, 68, 54,
70, 69, 66, 63, 73, 71, 51, 74, 67, 61, 53, 79, 70, 58, 49, 59,
52, 52, 61, 60, 59, 56, 56, 55, 57, 49, 47, 67, 64, 60, 61, 57,
52, 71, 70, 68, 65, 65, 50, 64, 56, 72, 69, 53, 65, 74, 61, 57,
56, 49, 81, 65, 56, 53, 75, 71, 65, 59, 56, 51, 46, 69, 61, 61,
59, 52, 74, 62, 63, 62, 61, 47, 75, 67, 56, 42, 42, 71, 61, 58,
55, 70, 66, 45, 58, 61, 57, 50, 49, 53, 61, 63, 44, 53, 60, 53,
62, 52, 52, 46, 77, 74, 71, 65, 63, 58, 75, 73, 73, 58, 69, 60,
42, 65, 61, 56, 55, 53, 52, 71, 63, 59, 51, 50, 67, 62, 61, 55,
54, 60, 59, 48, 78, 54, 63, 57, 54, 52, 44, 52, 64, 56, 53, 53,
51, 71, 68, 75, 75, 69, 59, 63, 58, 73, 56, 45, 81, 74, 65, 59,
58, 54, 74, 58, 62, 56, 45, 42, 70, 66, 57, 48, 65, 60, 58, 53,
53, 73, 68, 64, 44, 42, 63, 59, 49, 74, 57, 71, 62, 56, 72, 60,
57, 48, 74, 68, 65, 50, 79, 74, 67, 75, 62, 47, 46, 44, 74, 64,
59, 53, 58, 68, 53, 53, 53, 71, 53, 53, 65, 60, 52, 43, 42, 77,
66, 64, 63, 59, 66, 44, 51, 64, 62, 47, 47, 55, 73, 61, 55, 58,
65, 57, 50, 48, 69, 69, 63, 42, 72, 67, 66, 60, 55, 56, 54, 52,
47, 47, 77, 58, 43, 75, 65, 58, 57, 41, 65, 59, 74, 67, 72, 67,
66, 64, 63, 61, 61, 49, 42, 69, 73, 66, 64, 62, 57, 72, 68, 55,
63, 63, 70, 63, 62, 61, 60, 52, 51, 68, 41, 73, 60, 76, 74, 67,
66, 65, 62, 61, 44, 72, 67, 58, 57, 70, 63, 60, 61, 50, 48, 48,
63, 59, 56, 53, 64, 49, 63, 61, 62, 59, 74, 67, 64, 63, 46, 47,
69, 68, 67, 57, 61, 41, 63, 62, 56, 54, 66, 60, 53, 48, 53, 51,
70, 69, 59, 57, 56, 49, 70, 62, 59, 52, 68, 59, 48, 53, 70, 58,
75, 72, 60, 69, 65, 70, 72, 56, 75, 67, 69, 54, 47, 73, 63, 62,
58, 56, 58, 45, 73, 70, 53, 75, 74, 73, 57, 55, 52, 60, 60, 57,
66, 54, 64, 52, 45, 64, 58, 54, 50, 75, 66, 61, 50, 51, 65, 57,
53, 52, 73, 75, 75, 74, 65, 54, 71, 62, 61, 80, 58, 58, 52, 57,
48, 59, 51, 64, 69, 44, 71, 69, 63, 59, 69, 71, 62, 51, 58, 68,
72, 67, 66, 54, 42, 75, 82, 60, 71, 54, 50, 50, 66, 65, 62, 58,
64, 85, 62, 56, 48, 73, 65, 51, 77, 71, 61, 61, 49, 45, 67, 65,
49, 65, 63, 75, 68, 56, 44, 41, 86, 60, 59, 65, 57, 71, 70, 50,
48, 45, 66, 65, 57, 53, 44, 71, 66, 61, 60, 57, 57, 66, 63, 61,
54, 68, 49, 71, 49, 75, 74, 65, 60, 74, 46, 53, 71, 69, 65, 58,
56, 54, 75, 73, 71, 70, 67, 62, 62, 56, 54, 54, 50, 78, 75, 65,
63, 57, 66, 63, 52, 73, 68, 73, 71, 69, 68, 55, 44, 55, 45, 42,
69, 67, 56, 66, 66, 44, 80, 62, 51, 58, 65, 67, 48, 75, 55, 52,
58, 74, 40, 56, 55, 55, 53, 71, 67, 64, 62, 58, 62, 61, 48, 47,
54, 71, 63, 67, 67, 62, 66, 42, 70, 56, 68, 55, 48, 63, 60, 48,
66, 64, 54, 49, 92, 68, 63, 59, 49, 76, 72, 67, 62, 46, 44, 71,
69, 64, 64, 53, 55, 72, 70, 69, 60, 47, 44, 74, 57, 45, 73, 60,
65, 45, 72, 68, 58, 57, 51, 56, 71, 58, 73, 54, 45, 68, 65, 60,
41, 43, 67, 62, 51, 60, 72, 68, 53, 72, 62, 59, 53, 53, 52, 49,
65, 67, 59, 59, 52, 74, 73, 62, 52, 82, 61, 59, 50, 51, 79, 77,
65, 55, 72, 50, 72, 65, 56, 76, 66, 62, 61, 58, 54, 74, 69, 61,
54, 63, 62, 76, 73, 54, 47, 54, 68, 57, 62, 52, 56, 52, 56, 51,
66, 75, 75, 71, 63, 61, 71, 57, 56, 50, 72, 70, 66, 60, 72, 68,
64, 54, 76, 54, 48, 74, 69, 73, 56, 86, 69, 61, 59, 58, 56, 49,
42, 65, 71, 51, 76, 57, 74, 58, 56, 65, 64, 61, 74, 49, 57, 79,
74, 57, 56, 56, 46, 73, 65, 57, 56, 50, 44, 64, 68, 65, 61, 50,
51, 74, 71, 54, 41, 64, 49, 47, 68, 66, 65, 63, 49, 67, 65, 61,
67, 66, 42, 78, 76, 75, 72, 72, 45, 50, 88, 68, 59, 57, 46, 65,
60, 58, 68, 60, 51, 64, 58, 43, 62, 46, 61, 58, 55, 52, 51, 70,
62, 58, 44, 75, 71, 70, 63, 65, 43, 76, 66, 64, 78, 73, 82, 53,
51, 49, 55, 63, 58, 55, 55, 53, 74, 73, 72, 71, 56, 61, 59, 59,
59, 59, 49, 41, 58, 58, 54, 54, 76, 69, 65, 54, 52, 51, 61, 60,
59, 59, 57, 52, 68, 65, 56, 45, 64, 54, 53, 50, 58, 55, 55, 50,
76, 63, 60, 50, 46, 40, 58, 57, 56, 77, 66, 60, 56, 56, 54, 41,
63, 62, 61, 59, 71, 65, 61, 51, 42, 52, 56, 53, 46, 42, 61, 47,
43, 68, 63, 70, 53, 60, 60, 45, 72, 75, 62, 78, 74, 66, 60, 56,
72, 71, 69, 66, 65, 63, 52, 59, 60, 45, 76, 72, 67, 63, 55, 68,
61, 54, 60, 60, 52, 51, 63, 58, 64, 60, 60, 42, 75, 67, 46, 62,
66, 48, 58, 60, 72, 64, 60, 47, 77, 78, 72, 80, 75, 77, 74, 75,
72, 58, 68, 70, 53, 60, 71, 67, 82, 72, 75, 74, 77, 60, 68, 63,
74, 70, 66, 66, 62, 59, 55, 64, 49, 72, 61, 71, 70, 65, 73, 69,
68, 58, 52, 51, 72, 75, 52, 69, 81, 69, 73, 74, 66, 59, 75, 69,
74, 78, 85, 78, 64, 65, 59, 67, 61, 68, 78, 71, 76, 71, 75, 74,
74, 66, 44, 71, 68, 73, 73, 67, 59, 59, 72, 66, 72, 47, 65, 68,
53, 76, 49, 77, 61, 64, 56, 59, 77, 68, 78, 62, 65, 65, 72, 74,
61, 79, 82, 77, 76, 68, 77, 59, 71, 74, 81, 53, 81, 67, 78, 68,
65, 70, 53, 78, 71, 54, 71, 67, 56, 62, 52, 66, 68, 74, 70, 58,
69, 68, 76, 66, 67, 53, 63, 54, 82, 84, 76, 75, 82, 55, 85, 53,
70, 66, 58, 75, 63, 68, 60, 68, 59, 69, 68, 76, 66, 76, 72, 66,
77, 66, 75, 62, 63, 71, 73, 53, 62, 61, 44, 58, 55, 66, 66, 64,
76, 81, 75, 58, 55, 62, 67, 68, 61, 65, 63, 53, 53, 60, 55, 68,
43, 74, 60, 65, 67, 77, 67, 71, 62, 69, 74, 78, 65, 64, 66, 60,
79, 67, 70, 66, 80, 53, 67, 58, 68, 73, 72, 58, 66, 61, 68, 74,
77, 75, 69, 67, 51, 64, 73, 61, 63, 71, 70, 66, 72, 65, 45, 65,
68, 57, 75, 50, 60, 74, 46, 73, 64, 77, 51, 47, 62, 52, 57, 66,
61, 55, 67, 76, 69, 54, 80, 77, 78, 66, 56, 68, 62, 69, 65, 71,
62, 82, 56, 63, 57, 67, 63, 63, 64, 82, 54, 61, 65, 65, 67, 81,
63, 66, 53, 69, 72, 69, 72, 84, 81, 69, 83, 59, 87, 68, 57, 57,
54, 74, 45, 68, 75, 71, 59, 79, 49, 74, 65, 73, 68, 49, 65, 54,
71, 48, 70, 86, 81, 52, 75, 69, 89, 74, 77, 61, 68, 64, 47, 85,
79, 82, 61, 79, 62, 76, 65, 80, 56, 78, 68, 67, 65, 81, 68, 76,
78, 86, 68, 62, 75, 68, 68, 81, 87, 75, 76, 70, 67, 62, 82, 77,
76, 56, 58, 77, 62, 69, 65, 80, 67, 79, 72, 77, 65, 71, 65, 59,
67, 60, 63, 62, 89, 71, 64, 75, 74, 79, 71, 76, 78, 62, 74, 76,
70, 80, 79, 64, 67, 71, 61, 84, 69, 82, 66, 76, 64, 57, 73, 87,
63, 71, 76, 88, 52, 59, 61, 71, 80, 83, 81, 74, 72, 76, 61, 75,
70, 78, 72, 79, 71, 73, 74, 75, 71, 51, 73, 67, 78, 75, 79, 62,
71, 75, 69, 65, 60, 77, 77, 78, 73, 68, 52, 54, 69, 70, 60, 62,
75, 72, 70, 77, 61, 40, 84, 51, 76, 80, 53, 61, 62, 59, 83, 72,
71, 76, 70, 71, 73, 70, 68, 61, 77, 67, 67, 73, 78, 60, 71, 68,
79, 74, 66, 72, 49, 76, 76, 68, 70, 78, 76, 68, 70, 69, 68, 78,
73, 53, 77, 73, 64, 70, 74, 69, 70, 65, 63, 75, 74, 77, 81, 68,
79, 65, 70, 76, 77, 76, 67, 76, 70, 63, 68, 76, 76, 68, 65, 71,
74, 67, 58, 63, 69, 57, 77, 78, 57, 74, 71, 67, 75, 72, 69, 66,
66, 77, 68, 56, 67, 61, 71, 66, 76, 60, 70, 70, 73, 74, 77, 78,
56, 75, 70, 61, 74, 68, 33, 66, 75, 53, 58, 65, 74, 57, 77, 76,
76, 63, 70, 70, 50, 73, 68, 77, 69, 54, 74, 70, 51, 67, 81, 70,
71, 66, 65, 74, 75, 60, 76, 70, 65, 67, 58, 71, 65, 60, 72, 67,
78, 71, 70, 66, 62, 72, 55, 65, 68, 70, 73, 61, 71, 81, 71, 50,
73, 51, 60, 80, 79, 73, 76, 73, 62, 69, 80, 73, 70, 73, 49, 68,
77, 64, 71, 78, 64, 47, 61, 72, 77, 75, 67, 63, 68, 52, 57, 67,
66, 73, 79, 72, 56, 74, 71, 60, 77, 74, 77, 68, 56, 72, 74, 76,
79, 60, 60, 68, 59, 60, 69, 77, 52, 55, 58, 41, 60, 67, 71, 72,
59, 70, 78, 77, 69, 60, 78, 80, 78, 61, 80, 76, 73, 73, 69, 75,
72, 75, 69, 71, 73, 70, 75, 72, 52, 71, 78, 64, 69, 61, 61, 57,
56, 55, 64, 63, 54, 50, 51, 84, 75, 64, 50, 54, 57, 65, 63, 80,
59, 63, 65, 57, 60, 66, 56, 53, 62, 69, 77, 58, 76, 61, 57, 60,
77, 62, 73, 64, 59, 69, 70, 39, 69, 55, 60, 57, 74, 57, 55, 74,
51, 62, 68, 55, 56, 60, 58, 62, 73, 65, 55, 60, 68, 69, 60, 62,
76, 63, 55, 57, 56, 73, 73, 66, 62, 50, 59, 64, 57, 62, 63, 52,
78, 76, 79, 83, 80, 78, 66, 82, 61, 64, 78, 61, 77, 74, 62, 76,
70, 76, 69, 76, 77, 80, 72, 58, 66, 83, 73, 77, 79, 88, 55, 77,
67, 67, 65, 45, 83, 71, 78, 80, 48, 80, 76, 50, 67, 84, 68, 67,
67, 67, 74, 73, 76, 77, 74, 75, 68, 78, 72, 82, 68, 88, 63, 74,
80, 75, 78, 57, 70, 87, 67, 77, 59, 78, 70, 79, 65, 75, 69, 59,
64, 59, 77, 70, 76, 71, 77, 52, 74, 78, 58, 68, 52, 79, 63, 69,
72, 66, 76, 67, 69, 64, 73, 64, 54, 68, 62, 56, 71, 72, 59, 78,
72, 71, 73, 63, 78, 69, 68, 51, 51, 70, 71, 68, 78, 65, 65, 68,
76, 75, 82, 78, 63, 75, 71, 69, 80, 74, 74, 71, 71, 70, 67, 85,
72, 61, 64, 56, 59, 71, 62, 79, 56, 65, 63, 67, 69, 63, 78, 70,
59, 50, 70, 65, 61, 66, 79, 71, 65, 65, 68, 78, 66, 65, 70, 63,
77, 70, 44, 68, 56, 63, 55, 55, 75, 69, 74, 65, 57, 77, 69, 52,
73, 71, 39, 69, 67, 45, 75, 62, 78, 68, 66, 38, 78, 68, 79, 65,
53, 63, 68, 66, 74, 68, 62, 68, 68, 55, 62, 67, 64, 48, 40, 72,
57, 83, 73, 57, 70, 69, 34, 67, 63, 73, 50, 80, 74, 71, 62, 69,
65, 67, 54, 71, 83, 62, 74, 77, 75, 70, 58, 79, 75, 52, 64, 65,
83, 68, 62, 75, 63, 68, 68, 63, 74, 60, 75, 56, 59, 65, 81, 54,
65, 54, 69, 75, 77, 55, 77, 68, 71, 66, 76, 72, 76, 68, 63, 69,
54, 63, 63, 43, 73, 60, 76, 53, 68, 61, 62, 76, 54, 55, 62, 74,
35, 63, 57, 60, 73, 53, 86, 73, 59, 63, 69, 77, 70, 70, 63, 50,
65, 58, 67, 78, 67, 69, 76, 74, 65, 70, 59, 72, 49, 46, 58, 61,
66, 75, 71, 67, 55, 65, 46, 46, 79, 65, 65, 70, 66, 51, 55, 69,
44, 47, 77, 75, 64, 51, 79, 78, 60, 81, 75, 76, 66, 64, 82, 68,
65, 88, 76, 64, 64, 78, 76, 56, 73, 59, 70, 77, 58, 81, 53, 71,
64, 80, 78, 75, 67, 81, 77, 68, 78, 76, 71, 85, 59, 79, 71, 84,
75, 77, 63, 67, 81, 85, 67, 76, 74, 57, 75, 48, 76, 56, 63, 68,
85, 75, 75, 64, 82, 67, 44, 61, 68, 65, 75, 75, 78, 82, 73, 48,
83, 55, 73, 87, 74, 65, 71, 77, 70, 85, 77, 64, 68, 83, 71, 76,
80, 60, 75, 74, 61, 75, 74, 66, 82, 72, 89, 78, 76, 88, 64, 80,
74, 68, 61, 70, 60, 53, 63, 76, 66, 76, 79, 82, 82, 73, 73, 78,
69, 81, 63, 49, 65, 78, 82, 79, 77, 71, 72, 73, 67, 79, 64, 74,
69, 74, 69, 67, 68, 80, 87, 74, 91, 84, 68, 71, 73, 83, 67, 63,
53, 61, 83, 63, 59, 79, 68, 74, 65, 66, 77, 72, 83, 70, 60, 75,
68, 80, 58, 70, 63, 70, 88, 61, 83, 86, 78, 80, 69, 77, 66, 74,
77, 80, 89, 66, 62, 61, 77, 73, 79, 66, 56, 75, 62, 73, 78, 75,
72, 52, 83, 66, 56, 61, 88, 63, 89, 69, 71, 68, 51, 62, 73, 69,
73, 64, 53, 65, 68, 72, 54, 74, 68, 63, 64, 72, 58, 56, 72, 63,
67, 66, 58, 60, 73, 75, 65, 46, 68, 62, 65, 64, 75, 62, 73, 69,
62, 72, 68, 64, 75, 75, 60, 70, 68, 76, 71, 58, 79, 71, 56, 57,
57, 75, 67, 69, 44, 66, 75, 72, 60, 68, 80, 58, 47, 65, 60, 51,
81, 49, 63, 61, 61, 54, 75, 54, 82, 76, 44, 66, 50, 81, 62, 53,
51, 50, 70, 69, 64, 64, 88, 67, 66, 69, 64, 65, 68, 72, 80, 58,
59, 43, 78, 68, 64, 77, 69, 56, 53, 60, 73, 64, 61, 62, 71, 79,
47, 48, 75, 44, 57, 67, 68, 72, 46, 67, 60, 51, 53, 80, 62, 70,
59, 70, 67, 69, 50, 55, 81, 73, 67, 66, 62, 56, 66, 59, 61, 64,
61, 55, 54, 70, 55, 58, 61, 53, 69, 57, 76, 59, 73, 50, 78, 71,
57, 59, 74, 68, 72, 63, 77, 73, 49, 45, 72, 57, 54, 63, 66, 46,
57, 63, 52, 73, 64, 69, 72, 56, 54, 58, 71, 68, 56, 63, 80, 73,
64, 73, 63, 57, 71, 70, 63, 66, 58, 62, 72, 67, 65, 42, 58, 74,
64, 67, 75, 68, 77, 51, 72, 73, 56, 78, 54, 72, 52, 72, 63, 63,
68, 46, 69, 76, 66, 72, 65, 51, 46, 45, 55, 61, 77, 74, 78, 72,
50, 70, 49, 65, 74, 73, 66, 57, 55, 76, 64, 57, 70, 71, 78, 70,
47, 70, 58, 59, 53, 74, 56, 77, 61, 67, 52, 70, 59, 58, 67, 48,
47, 65, 55, 68, 64, 68, 65, 75, 79, 73, 68, 64, 67, 70, 61, 68,
58, 66, 66, 59, 50, 53, 59, 69, 55, 52, 56, 73, 52, 53, 52, 55,
74, 79, 62, 64, 72, 73, 79, 60, 46, 74, 45, 70, 67, 58, 75, 50,
59, 61, 75, 58, 50, 63, 79, 56, 58, 55, 58, 67, 69, 81, 80, 55,
69, 58, 62, 63, 52, 55, 58, 72, 63, 73, 74, 70, 51, 61, 65, 68,
67, 62, 77, 49, 61, 51, 73, 66, 63, 51, 71, 57, 56, 40, 65, 67,
66, 77, 67, 74, 79, 67, 70, 57, 55, 58, 77, 57, 62, 74, 65, 56,
51, 49, 72, 49, 42, 59, 57, 44, 61, 59, 46, 67, 52, 64, 80, 71,
76, 65, 70, 66, 61, 67, 53, 65, 70, 73, 77, 71, 60, 74, 63, 45,
50, 68, 72, 62, 63, 88, 73, 53, 74, 64, 53, 58, 64, 63, 44, 68,
62, 66, 49, 51, 69, 61, 61, 71, 74, 71, 77, 58, 34, 76, 72, 75,
64, 80, 73, 68, 56, 80, 78, 67, 65, 55, 71, 56, 59, 62, 71, 63,
70, 60, 52, 77, 54, 56, 68, 74, 77, 56, 64, 59, 67, 78, 65, 63,
75, 67, 69, 72, 76, 73, 51, 81, 66, 64, 60, 58, 50, 57, 63, 52,
42, 55, 65, 75, 67, 75, 56, 65, 71, 67, 49, 66, 56, 79, 50, 70,
53, 64, 58, 59, 67, 79, 63, 77, 75, 48, 74, 62, 72, 63, 71, 68,
82, 74, 52, 70, 56, 82, 60, 54, 73, 51, 58, 65, 79, 70, 56, 75,
52, 59, 63, 62, 45, 51, 67, 53, 56, 57, 72, 58, 71, 73, 67, 76,
54, 64, 71, 60, 73, 55, 43, 71, 59, 63, 74, 60, 66, 64, 60, 56,
46, 54, 77, 67, 62, 79, 70, 68, 75, 58, 72, 63, 52, 58, 54, 64,
54, 42, 58, 42, 59, 43, 52, 69, 65, 54, 58, 57, 58, 64, 65, 79,
69, 65, 69, 69, 54, 65, 81, 60, 68, 76, 69, 71, 84, 66, 54, 54,
51, 54, 47, 54, 65, 68, 61, 67, 74, 55, 59, 67, 58, 65.900000000000006,
48.5, 60.100000000000001, 65.200000000000003, 47.700000000000003,
66.700000000000003, 76.599999999999994, 83.200000000000003, 60.100000000000001,
59.100000000000001, 70.5, 82.599999999999994, 50.600000000000001,
61.600000000000001, 70.299999999999997, 38.200000000000003, 47.600000000000001,
74.400000000000006, 40.399999999999999, 51, 52.899999999999999,
45.799999999999997, 57.100000000000001, 58.200000000000003, 73.299999999999997,
53.899999999999999, 56.700000000000003, 67.900000000000006, 63.299999999999997,
41.600000000000001, 64.400000000000006, 72.299999999999997, 57.799999999999997,
58.600000000000001, 62.899999999999999, 57.5, 67.400000000000006,
63.899999999999999, 66.700000000000003, 58.299999999999997, 45.299999999999997,
61.100000000000001, 27.399999999999999, 50.100000000000001, 60.799999999999997,
59.899999999999999, 76.299999999999997, 62.200000000000003, 47.200000000000003,
63.899999999999999, 53.600000000000001, 41.299999999999997, 63.399999999999999,
44.700000000000003, 70.299999999999997, 62, 50.600000000000001,
66.900000000000006, 66.799999999999997, 65.299999999999997, 72.700000000000003,
32.399999999999999, 62.100000000000001, 57, 55, 73.5, 55.399999999999999,
53.299999999999997, 77.5, 58.600000000000001, 63.799999999999997,
55.299999999999997, 58.5, 47.100000000000001, 54.299999999999997,
62.799999999999997, 66.700000000000003, 53.200000000000003, 75.799999999999997,
58, 61.200000000000003, 64.299999999999997, 70.5, 74.799999999999997,
45.600000000000001, 49.899999999999999, 36.600000000000001, 57.200000000000003,
64.200000000000003, 64, 52, 58.200000000000003, 47.899999999999999,
48.200000000000003, 50.299999999999997, 47, 55.299999999999997,
46.700000000000003, 39.799999999999997, 67.200000000000003, 74.099999999999994,
61.399999999999999, 50.299999999999997, 67.299999999999997, 58.700000000000003,
60.600000000000001, 46.600000000000001, 50, 52.399999999999999,
68.799999999999997, 45.600000000000001, 67.299999999999997, 76.599999999999994,
51.399999999999999, 50.200000000000003, 63.799999999999997, 63,
60.100000000000001, 48.5, 50.399999999999999, 68.099999999999994,
46, 54.100000000000001, 65.799999999999997, 69.599999999999994,
65.900000000000006, 59.899999999999999, 45.600000000000001, 54.399999999999999,
52.799999999999997, 63, 59.100000000000001, 52.5, 45.399999999999999,
49.799999999999997, 63.600000000000001, 57.799999999999997, 48.899999999999999,
66.200000000000003, 39.700000000000003, 47.100000000000001, 60.299999999999997,
60.399999999999999, 73.400000000000006, 60.799999999999997, 43.299999999999997,
49.100000000000001, 46.200000000000003, 58.399999999999999, 65.900000000000006,
57.799999999999997, 54.799999999999997, 57.799999999999997, 40.799999999999997,
44.799999999999997, 50.5, 27, 64.099999999999994, 62.5, 48.799999999999997,
58, 57.100000000000001, 41.5, 38, 38.399999999999999, 62, 64.099999999999994,
51, 60, 56.600000000000001, 57.799999999999997, 60.200000000000003,
48.799999999999997, 31.699999999999999, 51.100000000000001, 35.899999999999999,
66.099999999999994, 71.799999999999997, 66.700000000000003, 48.399999999999999,
55.600000000000001, 67.599999999999994, 45.899999999999999, 49.200000000000003,
54, 66.700000000000003, 55.200000000000003, 48.200000000000003,
61.899999999999999, 64.599999999999994, 58.200000000000003, 68.200000000000003,
54.100000000000001, 35.5, 46.299999999999997, 53.600000000000001,
38.5, 46.700000000000003, 43.700000000000003, 46.799999999999997,
45, 61.600000000000001, 54.299999999999997, 57.700000000000003,
50.700000000000003, 50, 68.200000000000003, 63.399999999999999,
38.200000000000003, 61.299999999999997, 50.200000000000003, 36.100000000000001,
45, 61, 34.200000000000003, 45.200000000000003, 49.299999999999997,
46.100000000000001, 54.299999999999997, 51.899999999999999, 37.899999999999999,
64.900000000000006, 70.099999999999994, 71.400000000000006, 43.299999999999997,
62.899999999999999, 61.200000000000003, 26.300000000000001, 66.299999999999997,
56.600000000000001, 24.300000000000001, 36.700000000000003, 50.899999999999999,
64.900000000000006, 56.200000000000003, 30.399999999999999, 53.399999999999999,
73.900000000000006, 55.799999999999997, 37.799999999999997, 47.700000000000003,
36.100000000000001, 56.5, 43.700000000000003, 56.799999999999997,
61.299999999999997, 59.200000000000003, 45.700000000000003, 62.200000000000003,
78.799999999999997, 63.100000000000001, 70.799999999999997, 56.899999999999999,
59.5, 41.200000000000003, 38.899999999999999, 43.5, 64.299999999999997,
63, 62, 69, 66, 69, 73, 61, 63, 81, 47, 48, 56, 65, 72, 60, 76,
66, 70, 62, 47, 75, 72, 58, 68, 63, 65, 58, 60, 70, 55, 63, 65,
75, 68, 65, 50, 68, 71, 59, 62, 70, 80, 78, 69, 59, 75, 45, 59,
61, 72, 70, 59, 59, 52, 68, 70, 59, 48, 59, 50, 76, 70, 64, 58,
63, 47, 58, 64, 50, 78, 63, 51, 64, 76, 73, 74, 56, 66, 73, 68,
75, 68, 58, 66, 69, 63, 69, 64, 74, 72, 76, 66, 60, 64, 53, 49,
51, 75, 65, 46, 58, 53, 73, 59, 69, 62, 62, 56, 58, 64, 61, 70,
63, 67, 58, 61, 74, 61, 62, 60, 69, 66, 70, 58, 54, 59, 52, 67,
69, 61, 69, 70, 69, 65, 53, 67, 65, 69, 66, 66, 64, 78, 72, 79,
65, 76, 73, 67, 72, 59, 51, 60, 79, 65, 66, 69, 68, 55, 65, 69,
70, 69, 70, 73, 64, 59, 66, 65, 61, 72, 51, 70, 64, 55, 59, 67,
55, 60, 54, 63, 67, 66, 67, 54, 56, 77, 60, 55, 55, 61, 64, 68,
72, 56, 67, 71, 80, 48, 70, 68, 68, 63, 48, 65, 53, 64, 75, 65,
54, 65, 78, 74, 62, 72, 44, 67, 68, 65, 58, 55, 58, 68, 58, 56,
67, 73, 70, 64, 61, 53, 73, 57, 66, 60, 45, 62, 68, 72, 57, 70,
72, 69, 55, 62, 68, 74, 77, 71, 66, 46, 70, 66, 74, 71, 56, 65,
54, 60, 66, 62, 61, 72, 65, 55, 67, 60, 78, 59, 70, 71, 65, 69,
53, 64, 54, 48, 70, 72, 79, 72, 55, 61, 48, 61, 69, 55, 69, 64,
74, 58, 57, 65, 60, 46, 65, 63, 66, 49, 63, 64, 62, 70, 77, 63,
72, 73, 60, 74, 49, 65, 65, 56, 52, 62, 68, 67, 72, 70, 59, 71,
69, 71, 51, 52, 72, 64, 67, 56, 57, 46, 69, 52, 70, 50, 66, 62,
55, 65, 66, 65, 59, 53, 52, 75, 66, 72, 61, 67, 67, 77, 61, 69,
70, 75, 63, 74, 52, 73, 70, 79, 67, 73, 76, 62, 57, 64, 65, 71,
55, 71, 71, 55, 66, 77, 69, 50, 52, 68, 62, 62, 71, 74, 58, 65,
60, 73, 76, 73, 46, 75, 56, 70, 78, 56, 59, 47, 71, 68, 64, 68,
61, 66, 61, 71, 50, 65, 46, 72, 71, 67, 76, 73, 69, 51, 67, 62,
71, 75, 70, 56, 72, 58, 67, 73, 62, 55, 56, 71, 76, 46, 69, 76,
75, 65, 50, 80, 66, 51, 54, 63, 67, 51, 64, 66, 45, 62, 69, 64,
63, 52, 54, 70, 60, 59, 70, 60, 69, 78, 52, 51, 56, 65, 69, 73,
52, 60, 63, 51, 67, 71, 71, 46, 68, 68, 67, 68, 63, 71, 60, 53,
57, 64, 66, 46, 71, 60, 80, 75, 66, 73, 73, 53, 79, 66, 68, 58,
46, 66, 58, 53, 58, 71, 53, 54, 66, 76, 66, 67, 51, 77, 67, 66,
61, 64, 76, 55, 65, 68, 69, 45, 74, 64, 48, 60, 64, 54, 52, 68,
47, 76, 76, 68, 66, 63, 45, 71, 61, 71, 73, 68, 62, 58, 59, 60,
70, 60, 70, 73, 75, 61, 59, 73, 74, 74, 62, 65, 60, 70, 66, 56,
58, 64, 66, 68, 71, 60, 70, 73, 59, 68, 71, 60, 59, 55, 66, 78,
64, 47, 46, 62, 53, 65, 61, 60, 70, 65, 69, 68, 73, 71, 55, 72,
73, 79, 60, 66, 51, 79, 78, 53, 58, 58, 66, 69, 60, 63, 58, 48,
56, 49, 56, 54, 66, 61, 71, 57, 73, 80, 51, 62, 51, 77, 49, 71,
58, 58, 57, 55, 61, 52, 65, 69, 68, 61, 49, 69, 48, 60, 46, 73,
55, 55, 48, 50, 62, 66, 63, 75, 65, 64, 54, 65, 62, 63, 79, 64,
72, 81, 70, 48, 72, 67, 69, 51, 59, 58, 62, 66, 54, 71, 63, 72,
47, 45, 60, 58, 52, 52, 68, 49, 74, 57, 62, 58, 56, 59, 68, 57,
68, 70, 63, 70, 69, 55, 47, 52, 66, 69, 46, 59, 66, 71, 75, 60,
64, 64, 56, 54, 72, 60, 71, 78, 51, 62, 76, 70, 50, 46, 62, 77,
61, 56, 66, 52, 46, 67, 68, 65, 71, 70, 67, 64, 58, 63, 56, 58,
53, 61, 72, 54, 60, 52, 69, 48, 65, 71, 70, 70, 58, 50, 69, 62,
50, 73, 62, 76, 66, 61, 69, 59, 69, 65, 70, 62, 59, 54, 49, 54,
70, 59, 76, 78, 64, 62, 78, 79, 64, 74, 70, 75, 62, 61, 52, 61,
59, 51, 67, 65, 73, 62, 47, 53, 72, 72, 72, 69, 67, 49, 55, 60,
50, 65, 59, 63, 75, 46, 71, 73, 55, 48, 62, 75, 71, 55, 59, 57,
71, 72, 50, 65, 54, 67, 70, 62, 62, 62, 66, 50, 56, 59, 72, 55,
65, 62, 65, 66, 73, 70, 73, 80, 75, 64, 64, 74, 64, 62, 77, 66,
68, 63, 60, 45, 48, 62, 66, 60, 77, 62, 56, 66, 66, 73, 57, 51,
79, 71, 63, 66, 70, 54, 72, 62, 60, 70, 75, 77, 61, 70, 47, 59,
67, 69, 76, 54, 74, 48, 71, 62, 58, 62, 52, 47, 58, 56, 58, 54,
60, 63, 49, 62, 51, 66, 68, 68, 66, 68, 58, 56, 60, 75, 62, 64,
59, 62, 71, 60, 61, 72, 52, 69, 58, 74, 72, 74, 78, 49, 63, 52,
61, 58, 68, 60, 55, 45, 59, 64, 62, 50, 75, 64, 59, 70, 60, 61,
56, 56, 61, 52, 49, 73, 48, 56, 54, 52, 71, 75, 65, 53, 65, 65,
68, 78, 56, 51, 62, 57, 50, 51, 54, 69, 62, 67, 72, 65, 71, 52,
53, 47, 73, 57, 77, 64, 75, 72, 72, 59, 65, 61, 57, 67, 56, 68,
53, 60, 71, 60, 52, 61, 60, 51, 66, 70, 72, 62, 67, 70, 71, 67,
50, 63, 66, 71, 52, 77, 57, 62, 65, 57, 66, 67, 46, 48, 64, 63,
70, 64, 60, 72, 46, 61, 65, 53, 78, 63, 55, 75, 52, 76, 64, 62,
53, 56, 67, 64, 50, 46, 54, 58, 62, 56, 80, 51, 65, 80, 51, 66,
63, 65, 76, 50, 52, 62, 75, 48, 57, 63, 46, 71, 64, 70, 60, 74,
64, 55, 57, 66, 59, 67, 55, 51, 56, 51, 50, 65, 51, 51, 74, 56,
53, 60, 60, 61, 71, 57, 46, 54, 62, 51, 52, 72, 49, 57, 61, 79,
76, 69, 62, 64, 57, 73, 67, 62, 75, 68, 54, 59, 65, 70, 59, 57,
51, 74, 68, 67, 76, 56, 56, 69, 56, 55, 48, 67, 67, 48, 67, 73,
56, 67, 66, 58, 56, 60, 76, 55, 77, 66, 65, 66, 73, 70, 68, 67,
72, 63, 76, 62, 78, 55, 75, 49, 75, 53, 53, 57, 66, 56, 58, 72,
76, 47, 69, 67, 68, 74, 76, 63, 61, 70, 52, 47, 62, 51, 60, 77,
60, 60, 53, 49, 68, 62, 46, 53, 68, 72, 69, 60, 63, 68, 58, 71,
77, 65, 69, 79, 73, 66, 61, 71, 68, 64, 68, 49, 51, 80, 64, 79,
51, 63, 65, 66, 59, 74, 50, 68, 54, 64, 61, 61, 58, 70, 72, 65,
54, 66, 79, 67, 61, 73, 63, 75, 72, 49, 57, 62, 63, 62, 46, 54,
61, 62, 77, 73, 54, 58, 64, 72, 75, 65, 53, 64, 47, 77, 51, 46,
57, 59, 64, 63, 76, 66, 63, 70, 59, 63, 79, 66, 59, 47, 54, 74,
69, 58, 68, 70, 68, 51, 50, 48, 73, 70, 68, 54, 60, 77, 68, 70,
58, 76, 60, 60, 52, 64, 64, 57, 62, 63, 67, 72, 69, 75, 62, 66,
47, 60, 66, 76, 76, 48, 74, 67, 51, 46, 49, 59, 62, 63, 80, 80,
67, 66, 69, 59, 73, 63, 72, 77, 56, 66, 46, 52, 67, 54, 64, 66,
58, 72, 46, 55, 71, 71, 64, 47, 63, 62, 67, 71, 57, 57, 76, 71,
74, 52, 73, 53, 60, 59, 64, 62, 56, 58, 58, 46, 53, 61, 70, 58,
64, 51, 78, 57, 52, 58, 50, 56, 64, 62, 59, 58, 67, 57, 47, 54,
72, 62, 79, 47, 50, 79, 53, 60, 63, 77, 46, 52, 68, 49, 57, 49,
79, 55, 64, 50, 71, 47, 70, 56, 72, 67, 60, 47, 63, 58, 67, 54,
60, 54, 61, 74, 79, 53, 59, 77, 49, 53, 70, 52, 78, 54, 57, 46,
65, 76, 56, 71, 71, 65, 60, 74, 67, 63, 51, 52, 66, 53, 75, 70,
54, 60, 53, 62, 49, 56, 75, 66, 55, 47, 67, 58, 76, 50, 69, 59,
52, 49, 55, 52, 69, 68, 55, 61, 56, 54, 77, 53, 66, 55, 75, 46,
78, 65, 60, 57, 71, 69, 65, 71, 63, 56, 66, 66, 58, 66, 50, 66,
63, 46, 74, 60, 57, 52, 77, 58, 68, 58, 62, 65, 77, 64, 65, 51,
65, 60, 49, 79, 67, 66, 49, 79, 54, 51, 62, 50, 53, 70, 62, 61,
69, 57, 66, 62, 58, 79, 63, 51, 49, 68, 72, 76, 70, 47, 64, 65,
59, 65, 76, 71, 62, 49, 67, 77, 60, 67, 45, 69, 69, 46, 73, 65,
65, 65, 72, 61, 49, 66, 67, 63, 46, 71, 59, 73, 68, 67, 79, 71,
53, 66, 60, 56, 69, 56, 73, 59, 64, 58, 52, 72, 68, 59, 52, 58,
60, 59, 74, 69, 65, 48, 61, 55, 47, 68, 56, 62, 53, 64, 66, 57,
66, 52, 67, 62, 68, 69, 54, 68, 65, 56, 63, 73, 74, 62, 73, 78,
75, 63, 63, 54, 69, 62, 57, 50, 48, 76, 67, 79, 56, 65, 72, 71,
60, 59, 57, 54, 62, 57, 66, 70, 72, 68, 52, 73, 70, 79, 64, 61,
65, 52, 68, 66, 68, 77, 50, 63, 61, 59, 69, 59, 63, 61, 75, 71,
46, 78, 69, 62, 68, 58, 69, 68, 70, 73, 49, 66, 68, 49, 68, 49,
63, 56, 51, 56, 59, 72, 75, 58, 50, 60, 66, 57, 71, 49, 76, 75,
75, 73, 56, 68, 74, 63, 63, 58, 48, 63, 76, 72, 76, 71, 70, 63,
59, 60, 71, 53, 68, 67, 74, 67, 56, 70, 63, 79, 76, 79, 63, 62,
58, 73, 50, 58, 50, 72, 57, 49, 60, 70, 67, 58, 62, 73, 73, 64,
62, 66, 68, 61, 56, 48, 69, 76, 66, 61, 55, 72, 74, 60, 75, 60,
71, 63, 73, 80, 61, 62, 71, 57, 59, 50, 70, 62, 52, 60, 68, 56,
48, 74, 76, 57, 57, 49, 56, 69, 49, 65, 60, 59, 58, 55, 65, 62,
56, 65, 62, 45, 76, 67, 71, 48, 67, 60, 76, 61, 68, 62, 66, 67,
71, 68, 71, 60, 45, 65, 79, 60, 59, 48, 47, 61, 46, 62, 52, 62,
58, 57, 62, 53, 68, 50, 73, 58, 50, 57, 63, 63, 66, 70, 62, 67,
67, 58, 56, 73, 53, 52, 71, 63, 55, 56, 59, 72, 71, 67, 53, 69,
62, 51, 74, 64, 58, 62, 47, 78, 75, 65, 67, 66, 61, 52, 66, 67,
75, 60, 71, 51, 45, 69, 57, 62, 62, 60, 62, 61, 70, 58, 65, 69,
53, 58, 55, 47, 64, 59, 69, 59, 64, 55, 51, 65, 57, 53, 67, 70,
63, 54, 51, 67, 65, 57, 53, 54, 80, 76, 58, 54, 61, 56, 59, 58,
57, 69, 73, 71, 75, 74, 62, 72, 78, 70, 63, 60, 71, 63, 69, 51,
60, 68, 78, 64, 58, 58, 69, 58, 60, 65, 68, 63, 74, 62, 63, 50,
64, 76, 64, 74, 57, 74, 66, 71, 69, 58, 68, 77, 67, 73, 68, 72,
67, 62, 55, 63, 57, 67, 67, 59, 69, 59, 57, 56, 71, 52, 73, 71,
56, 56, 70, 56, 48, 60, 62, 61, 54, 76, 63, 71, 68, 68, 58, 54,
58, 75, 63, 54, 66, 67, 70, 60, 70, 48, 62, 65, 75, 62, 67, 60,
62, 58, 77, 55, 74, 68, 62, 69, 61, 68, 73, 62, 56, 55, 73, 75,
73, 64, 67, 48, 62, 68, 69, 67, 63, 57, 49, 67, 80, 68, 67, 64,
65, 64, 65, 66, 54, 52, 74, 67, 78, 72, 72, 63, 76, 74, 55, 68,
74, 52, 59, 55, 74, 60, 76, 67, 61, 56, 61, 52, 67, 53, 52, 69,
63, 69, 59, 73, 72, 66, 75, 81, 50, 72, 67, 55, 63, 51, 64, 68,
67, 71, 65, 67, 73, 71, 53, 70, 66, 54, 52, 59, 62, 65, 79, 60,
54, 53, 53, 64, 71, 68, 66, 51, 66, 61, 78, 73, 65, 56, 70, 67,
70, 57, 74, 77, 69, 59, 64, 66, 66, 50, 67, 67, 57, 74, 67, 69,
69, 78, 60, 66, 67, 64, 69, 78, 67, 67, 62, 68, 63, 63, 63, 69,
57, 77, 68, 59, 64, 65, 62, 63, 74, 48, 63, 45, 56, 66, 64, 63,
45, 61, 51, 55, 70, 59, 62, 54, 53, 68, 72, 69, 66, 63, 67, 50,
60, 53, 56, 58, 55, 58, 63, 55, 52, 56, 54, 65, 61, 74, 65, 69,
57, 65, 72, 54, 64, 58, 60, 59, 52, 69, 57, 49, 59, 64, 57, 67,
57, 64, 70, 44, 70, 84, 46, 47, 72, 62, 48, 49, 61, 47, 44, 54,
49, 54, 57, 48, 57, 42, 55, 77, 42, 57, 54, 58, 46, 83, 72, 51,
54, 58, 51, 54, 57, 57, 58, 60, 53, 65, 52, 59, 55, 62, 47, 74,
54, 57, 51, 51, 59, 82, 57, 58, 77, 58, 57, 65, 52, 52, 58, 57,
70, 67, 57, 59, 59, 52, 73, 57, 57, 58, 64, 58, 59, 58, 51, 53,
46, 62, 67, 69, 53, 55, 53, 70, 57, 60, 53, 60, 58, 67, 66, 68,
53, 65, 65, 69, 51, 56, 70, 62, 69, 78, 56, 66, 55, 60, 60, 67,
54, 69, 67, 70, 69, 67, 68, 59, 61, 65, 54, 64, 69, 56, 64, 61,
51, 69, 54, 68, 70, 55, 47, 65, 69, 62, 65, 62, 68, 66, 61, 62,
62, 68, 68, 62, 64, 50, 61, 67, 69, 62, 70, 61, 46, 64, 66, 68,
66, 56, 69, 62, 66, 64, 63, 70, 65, 57, 70, 68, 64, 62, 59, 61,
69, 66, 72, 65, 62, 61, 64, 64, 62, 52, 68, 62, 62, 63, 68, 64,
63, 68, 68, 69, 61, 70, 68, 70, 72, 67, 65, 72, 75, 72, 72, 61,
51, 53, 63, 71, 76, 42, 79, 73, 77, 73, 53, 75, 71, 73, 72, 72,
52, 66, 80, 71, 69, 73, 79, 72, 72, 62, 73, 80, 80, 71, 77, 80,
75, 80, 75, 56, 73, 78, 73, 71, 74, 55, 72, 77, 80, 52, 72, 65,
71, 74, 69, 78, 79, 87, 76, 61, 74, 76, 53, 79, 75, 49, 72, 71,
74, 76, 55, 71, 70, 73, 79, 74, 79, 73, 78, 78, 73, 47, 82, 78,
72, 72, 45, 52, 77, 76, 53, 71, 79, 80, 65, 73, 76, 53, 57, 65,
76, 70, 77, 77, 72, 78, 64, 76, 45, 60, 77, 48, 59, 47, 55, 57,
63, 85, 68, 83, 75, 72, 75, 54, 84, 63, 77, 59, 82, 72, 55, 83,
74, 55, 60, 74, 83, 66, 80, 82, 64, 57, 54, 48, 71, 59, 89, 71,
82, 58, 52, 79, 52, 48, 55, 90, 75, 74, 86, 72, 77, 64, 59, 49,
70, 77, 54, 84, 56, 58, 77, 67, 81, 78, 56, 70, 63, 52, 52, 54,
84, 59, 75, 51, 66, 74, 77, 69, 51, 76, 84, 77, 55, 55, 59, 70,
67, 60, 51, 64, 64, 60, 76, 51, 65, 55, 76, 76, 76, 56, 68, 82,
82, 55, 54, 77, 66, 74, 58, 83, 57, 73, 75, 55, 62, 76, 67, 67,
59, 70, 64, 65, 76, 58, 84, 78, 73, 59, 50, 46, 49, 83, 72, 58,
59, 76, 85, 66, 75, 43, 65, 84, 84, 72, 68, 71, 77, 40, 64, 83,
79, 66, 64, 80, 76, 73, 64, 79, 81, 87, 68, 63, 49, 62, 58, 69,
68, 80, 69, 37, 68, 57, 67, 65, 64, 60, 40, 66, 57, 40, 68, 42,
41, 68, 69, 73, 45, 64, 43, 58, 28, 46, 66, 65, 64, 67, 31, 75,
58, 68, 53, 67, 75, 63, 71, 61, 57, 67, 68, 66, 64, 38, 75, 72,
65, 51, 42, 41, 32, 57, 56, 36, 47, 66, 74, 47, 72, 72, 83, 56,
54, 71, 55, 65, 63, 42, 76, 70, 64, 64, 73, 66, 65, 84, 71, 51,
65, 52, 34, 60, 76, 57, 54, 67, 63, 72, 74, 58, 74, 70, 63, 48,
77, 70, 63, 51, 73, 34, 57, 36, 64, 54, 55, 76, 45, 67, 52, 39,
67, 69, 72, 69, 64, 59, 45, 38, 52, 54, 45, 54, 62, 71, 57, 68,
75, 73, 72, 70, 61, 53, 69, 72, 62, 53, 69, 63, 34, 21, 73, 68,
40, 26, 60, 63, 51, 61, 72, 68, 65, 66, 72, 60, 76, 57, 50, 47,
63, 54, 84, 73, 59, 74, 63, 57, 79, 63, 55, 75, 71, 68, 57, 68,
60, 46, 71, 57, 60, 35, 62, 61, 56, 68, 57, 70, 64, 56, 60, 53,
68, 63, 57, 51, 71, 65, 45, 68, 58, 68, 42, 60, 63, 49, 46, 62,
66, 59, 61, 54, 20, 53, 74, 23, 38, 70, 70, 59, 72, 68, 73, 70,
64, 63, 58, 48, 38, 62, 68, 56, 53, 72, 68, 63, 69, 69, 55, 48,
72, 59, 48, 74, 59, 69, 62, 53, 74, 27, 66, 65, 79, 61, 55, 60,
52, 43, 61, 60, 33, 55, 64, 61, 64, 73, 72, 56, 71, 50, 46, 48,
70, 53, 78, 54, 70, 75, 62, 58, 65, 61, 53, 66, 61, 57, 75, 65,
38, 68, 35, 65, 42, 69, 49, 63, 48, 43, 40, 51, 52, 49, 28, 72,
46, 71, 51, 61, 53, 42, 64, 53, 66, 52, 19, 54, 47, 39, 24, 60,
59, 66, 75, 71, 32, 61, 72, 71, 65, 59, 66, 53, 46, 75, 71, 68,
67, 53, 41, 58, 48, 55, 48, 55, 72, 64, 28, 68, 53, 63, 51, 65,
78, 65, 36, 66, 35, 73, 72, 68, 71, 65, 66, 70, 55, 54, 55, 58,
43, 74, 61, 45, 75, 48, 71, 66, 56, 65, 52, 65, 69, 72, 49, 64,
64, 61, 40, 39, 36, 47, 87, 50, 65, 57, 63, 48, 74, 69, 78, 70,
55, 71, 54, 48, 38, 29, 53, 39, 77, 38, 74, 41, 73, 66, 48, 74,
71, 58, 75, 55, 48, 64, 63, 72, 70, 66, 62, 62, 59, 73, 40, 78,
63, 62, 66, 56, 63, 66, 75, 57, 75, 65, 66, 64, 36, 43, 70, 72,
66, 61, 52, 31, 65, 64, 59, 57, 72, 63, 49, 70, 67, 50, 60, 27,
71, 82, 69, 65, 59, 58, 58, 55, 67, 65, 62, 40, 25, 51, 44, 74,
74, 65, 59, 56, 54, 54, 49, 38, 68, 52, 82, 69, 64, 63, 50, 59,
67, 63, 62, 71, 42, 76, 55, 45, 44, 66, 60, 56, 70, 63, 67, 77,
54, 69, 65, 71, 73, 83, 76, 70, 77, 65, 63, 64, 83, 77, 65, 65,
72, 71, 70, 71, 67, 80, 60, 74, 84, 62, 75, 78, 64, 56, 73, 64,
71, 74, 72, 83, 71, 85, 83, 73, 85, 68, 68, 81, 85, 75, 81, 70,
78, 88, 76, 84, 78, 96, 72, 68, 71, 70, 74, 68, 71, 73, 68, 45,
76, 67, 74, 73, 78, 77, 71, 86, 81, 81, 80, 72, 79, 68, 79, 80,
68, 74, 86, 76, 82, 50, 71, 74, 70, 65, 79, 67, 67, 75, 70, 59,
55, 67, 74, 82, 65, 73, 73, 77, 57, 71, 71, 75, 72, 77, 83, 66,
70, 61, 73, 75, 73, 86, 81, 69, 69, 65, 81, 76, 77, 63, 67, 78,
83, 85, 73, 56, 60, 64, 71, 88, 74, 76, 82, 68, 74, 77, 59, 74,
64, 65, 74, 65, 79, 61, 74, 84, 35, 65, 74, 69, 81, 69, 74, 49,
70, 73, 61, 75, 65, 52, 76, 76, 71, 70, 67, 76, 72, 76, 62, 54,
72, 76, 84, 74, 72, 77, 75, 71, 69, 62, 58, 65, 63, 68, 57, 81,
77, 73, 76, 72, 74, 63, 48, 74, 78, 76, 77, 49, 82, 72, 57, 78,
43, 69, 65, 68, 71, 71, 82, 76, 76, 53, 79, 55, 74, 69, 52, 76,
80, 67, 75, 68, 80, 62, 71, 81, 76, 74, 61, 72, 79, 52, 77, 73,
77, 78, 82, 69, 72, 67, 71, 63, 73, 83, 78, 41, 68, 75, 68, 67,
68, 60, 75, 61, 78, 72, 74, 66, 62, 72, 82, 76, 73, 56, 65, 77,
65, 77, 73, 73, 72, 65, 73, 59, 55, 48, 73, 55, 58, 62, 47, 64,
57, 61, 62, 71, 84, 77, 60, 58, 77, 82, 52, 53, 49, 60, 71, 58,
72, 63, 62, 87, 77, 61, 64, 75, 78, 55, 59, 50, 59, 76, 65, 75,
69, 75, 83, 70, 85, 74, 64, 82, 73, 56, 44, 79, 75, 57, 66, 68,
77, 63, 82, 80, 64, 53, 68, 83, 56, 62, 64, 76, 61, 70, 83, 74,
52, 55, 61, 44, 87, 68, 57, 44, 67, 86, 70, 72, 72, 42, 47, 51,
65, 64, 57, 69, 70, 74, 60, 43, 56, 56, 74, 67, 58, 60, 64, 77,
57, 52, 65, 65, 50, 73, 58, 65, 83, 64, 72, 70, 65, 44, 76, 65,
49, 53, 69, 81, 62, 64, 72, 68, 76, 82, 71, 68, 50, 71, 73, 78,
60, 71, 63, 79, 61, 64, 60, 65, 64, 47, 74, 78, 57, 79, 63, 67,
63, 46, 74, 74, 48, 66, 59, 72, 48, 76, 76, 73, 67, 59, 68, 56,
61, 56, 60, 82, 65, 74, 63, 58, 71, 66, 70, 65, 71, 61, 82, 54,
56, 58, 62, 65, 66, 48, 50, 48, 79, 44, 61, 52, 63, 60, 56, 63,
64, 82, 46, 53, 38, 79, 38, 78, 69, 56, 82, 69, 58, 72, 45, 50,
56, 72, 69, 74, 68, 75, 81, 58, 82, 74, 70, 73, 52, 60, 66, 76,
72, 72, 64, 67, 42, 84, 74, 70, 59, 52, 52, 59, 72, 65, 55, 66,
56, 75, 58, 72, 33, 78, 79, 77, 76, 64, 79, 80, 74, 68, 58, 74,
72, 55, 77, 63, 73, 80, 57, 41, 80, 63, 73, 63, 66, 81, 48, 64,
63, 64, 66, 56, 51, 66, 70, 58, 54, 74, 50, 74, 62, 59, 57, 74,
71, 75, 53, 60, 58, 67, 50, 78, 69, 63, 69, 57, 60, 60, 61, 65,
58, 51, 56, 70, 72, 57, 56, 72, 54, 67, 62, 51, 57, 73, 58, 73,
70, 55, 66, 75, 63, 65, 68, 67, 74, 67, 53, 60, 68, 79, 76, 59,
79, 55, 57, 83, 52, 78, 66, 62, 81, 65, 62, 52, 56, 53, 62, 69,
76, 55, 77, 62, 50, 79, 76, 44, 67, 75, 60, 72, 54, 63, 56, 69,
78, 65, 74, 52, 61, 68, 78, 57, 60, 73, 57, 61, 59, 81, 81, 67,
65, 52, 73, 59, 79, 65, 63, 67, 40, 70, 54, 69, 62, 51, 59, 67,
70, 63, 64, 64, 75, 73, 67, 70, 52, 64, 62, 51, 65, 57, 79, 59,
64, 70, 46, 65, 71, 74, 52, 54, 56, 67, 74, 81, 70, 38, 60, 61,
65, 62, 68, 63, 56, 58, 52, 64, 74, 59, 50, 67, 61, 57, 62, 48,
59, 61, 72, 62, 60, 64, 56, 78, 65, 66, 59, 51, 46, 51, 40, 78,
66, 55, 54, 65, 74, 55, 39, 76, 46, 64, 61, 50, 67, 78, 51, 65,
70, 53, 37, 63, 86, 57, 58, 60, 73, 69, 47, 52, 55, 49, 76, 68,
60, 81, 65, 68, 59, 56, 67, 69, 69, 70, 52, 66, 62, 62, 79, 76,
64, 70, 63, 58, 53, 70, 60, 56, 50, 60, 81, 65, 77, 50, 69, 60,
74, 41, 62, 45, 46, 58, 73, 79, 71, 54, 63, 74, 59, 48, 60, 52,
60, 80, 55, 55, 69, 78, 54, 58, 50, 61, 74, 84, 51, 66, 65, 63,
52, 48, 58, 60, 54, 60, 74, 69, 82, 76, 70, 65, 62, 65, 77, 68,
75, 63, 72, 63, 54, 64, 73, 51, 76, 56, 61, 61, 49, 58, 68, 78,
65, 48, 61, 76, 46, 66, 63, 55, 67, 54, 52, 68, 74, 56, 69, 76,
60, 49, 46, 57, 65, 68, 51, 79, 60, 66, 59, 69, 67, 78, 51, 55,
84, 60, 73, 80, 80, 68, 85, 58, 69, 69, 70, 61, 51, 64, 87, 66,
83, 83, 56, 64, 86, 67, 47, 64, 69, 75, 62, 67, 65, 59, 77, 57,
74, 67, 32, 63, 53, 56, 70, 69, 61, 66, 58, 59, 57, 65, 65, 79,
81, 72, 75, 83, 73, 61, 61, 58, 82, 59, 79, 78, 68, 64, 49, 56,
79, 66, 59, 56, 66, 65, 62, 54, 82, 62, 73, 57, 63, 51, 82, 76,
70, 78, 63, 82, 70, 66, 63, 82, 60, 52, 66, 59, 60, 77, 55, 79,
53, 75, 56, 69, 59, 57, 64, 56, 56, 71, 52, 63, 66, 60, 67, 78,
64, 80, 62, 66, 80, 54, 75, 74, 53, 86, 80, 71, 62, 53, 58, 52,
66, 74, 62, 82, 55, 90, 71, 52, 65, 70, 49, 83, 84, 82, 78, 68,
80, 57, 81, 55, 88, 61, 86, 51, 70, 52, 71, 55, 60, 75, 68, 60,
81, 78, 69, 82, 72, 55, 59, 68, 68, 56, 63, 73, 60, 78, 72, 72,
54, 53, 60, 55, 74, 55, 59, 58, 85, 42, 77, 78, 41, 69, 76, 65,
72, 64, 67, 79, 58, 78, 64, 60, 66, 65, 41, 70, 59, 59, 62, 78,
55, 73, 72, 58, 77, 59, 83, 75, 73, 64, 75, 54, 69, 76, 69, 73,
79, 46, 65, 60, 56, 70, 73, 63, 51, 66, 59, 66, 70, 74, 61, 57,
60, 78, 46, 52, 74, 73, 52, 71, 73, 66, 69, 66, 62, 73, 71, 63,
65, 67, 84, 78, 74, 68, 57, 69, 74, 48, 61, 61, 66, 75, 86, 65,
65, 79, 91, 75, 71, 82, 78, 67, 71, 61, 54, 62, 80, 88, 80, 83,
53, 66, 91, 84, 71, 73, 60, 75, 84, 79, 85, 81, 70, 76, 70, 61,
83, 52, 65, 59, 50, 67, 84, 63, 64, 77, 63, 64, 68, 72, 78, 75,
85, 63, 73, 68, 73, 62, 61, 76, 84, 72, 85, 60, 61, 73, 61, 46,
81, 70, 86, 84, 66, 69, 79, 77, 60, 90, 61, 83, 55, 51, 69, 65,
79, 85, 81, 73, 67, 70, 60, 74, 79, 69, 84, 76, 85, 83, 87, 82,
83, 82, 70, 65, 75, 70, 84, 70, 69, 87, 62, 58, 83, 70, 73, 82,
61, 74, 84, 83, 57, 59, 68, 67, 50, 82, 78, 76, 66, 83, 85, 74,
70, 71, 65, 63, 66, 68, 85, 89, 74, 71, 78, 65, 68, 63, 55, 68,
80, 80, 82, 83, 61, 74, 50, 59, 65, 93, 73, 86, 88, 69, 87, 82,
88, 66, 71, 83, 77, 84, 83, 82, 62, 59, 70, 87, 68, 86, 85, 82,
65, 87, 72, 84, 75, 80, 61, 86, 58, 86, 92, 86, 70, 80, 76, 81,
84, 73, 58, 70, 69, 73, 72, 71, 77, 75, 71, 59, 64, 58, 82, 55,
65, 56, 34, 61, 72, 76, 70, 72, 66, 68, 70, 71, 75, 81, 59, 77,
65, 85, 65, 70, 82, 81, 57, 76, 63, 72, 69, 63, 56, 70, 75, 69,
79, 74, 87, 72, 68, 52, 65, 70, 61, 69, 69, 76, 69, 67, 62, 89,
76, 64, 68, 68, 75, 69, 79, 71, 70, 74, 70, 79, 69, 69, 71, 77,
65, 74, 66, 66, 64, 76, 66, 66, 68, 70, 73, 65, 73, 65, 76, 72,
67, 70, 61, 61, 75, 78, 67, 67, 78, 54, 75, 68, 60, 60, 73, 65,
69, 74, 69, 64, 79, 78, 79, 63, 77, 61, 71, 60, 80, 77, 76, 64,
56, 69, 65, 66, 63, 56, 76, 74, 72, 63, 77, 57, 59, 71, 64, 66,
56, 69, 69, 73, 59, 69, 55, 80, 58, 66, 74, 60, 56, 80, 61, 55,
59, 52, 60, 69, 65, 70, 64, 55, 52, 81, 71, 70, 66, 62, 75, 69,
68, 80, 78, 72, 64, 63, 68, 67, 85, 64, 66, 80, 73, 69, 75, 71,
68, 66, 70, 75, 73, 82, 75, 81, 69, 56, 63, 83, 55, 63, 63, 72,
74, 70, 66, 62, 72, 73, 63, 72, 57, 84, 63, 82, 73, 67, 74, 50,
63, 78, 75, 65, 60, 67, 70, 59, 79, 71, 80, 67, 76, 66, 72, 62,
58, 65, 76, 62, 68, 61, 76, 49, 50, 67, 77, 51, 77, 72, 64, 81,
56, 77, 70, 64, 76, 76, 81, 70, 60, 59, 60, 58, 65, 62, 84, 60,
46, 78, 73, 69, 66, 70, 84, 75, 61, 79, 64, 52, 83, 48, 71, 70,
69, 75, 57, 56, 84, 77, 77, 79, 83, 69, 64, 80, 62, 72, 50, 81,
65, 64, 83, 62, 60, 77, 75, 72, 52, 69, 75, 77, 42, 63, 78, 73,
80, 84, 77, 71, 66, 67, 61, 70, 86, 62, 60, 66, 74, 81, 80, 80,
71, 79, 51, 71, 78, 65, 75, 75, 61, 61, 70, 73, 72, 69, 71, 84,
54, 83, 70, 58, 78, 70, 77, 52, 76, 69, 83, 68, 72, 76, 72, 42,
66, 61, 48, 84, 74, 58, 84, 56, 52, 73, 76, 74, 61, 76, 67, 53,
60, 59, 75, 77, 75, 85, 60, 62, 82, 63, 62, 78, 55, 74, 58, 61,
63, 79, 73, 81, 65, 75, 74, 65, 74, 66, 74, 57, 63, 60, 80, 42,
60, 45, 72, 74, 71, 50, 74, 77, 65, 64, 49, 59, 63, 51, 58, 73,
68, 56, 85, 70, 67, 75, 73, 70, 78, 90, 75, 61, 62, 78, 81, 54,
62, 68, 82, 75, 65, 62, 65, 77, 80, 61, 81, 62, 79, 74, 77, 60,
65, 78, 65, 66, 62, 57, 72, 73, 82, 78, 78, 60, 59, 81, 61, 76,
81, 74, 70, 72, 69, 71, 71, 80, 65, 74, 70, 82, 67, 80, 61, 63,
64, 64, 66, 71, 66, 69, 70, 50, 77, 55, 60, 73, 80, 75, 73, 67,
60, 75, 67, 77, 72, 66, 81, 69, 78, 68, 78, 76, 54, 63, 51, 80,
70, 64, 77, 61, 66, 83, 56, 55, 43, 76, 48, 67, 82, 73, 74, 70,
51, 82, 76, 48, 60, 75, 80, 63, 60, 60, 67, 69, 58, 69, 69, 55,
54, 65, 84, 69, 83, 66, 79, 63, 83, 66, 64, 63, 67, 58, 76, 90,
69, 65, 66, 70, 72, 54, 50, 70, 55, 60, 61, 72, 86, 64, 78, 71,
80, 59, 68, 76, 68), fev1pp = c(45, 37, 64, 46.799999237060497,
49.5, 48.099998474121101, 27.799999237060501, 43.400001525878899,
35.299999237060497, 32.900001525878899, 59, 60.700000762939503,
55.200000762939503, 35.5, 62, 53, 41, 56.200000762939503, 45,
50.200000762939503, 54, 37.700000762939503, 57.400001525878899,
40.700000762939503, 53.400001525878899, 52.099998474121101, 57,
58.400001525878899, 60, 43, 40.400001525878899, 50, 67.800003051757798,
66.199996948242202, 36, 44, 34, 42, 46, 48, 34, 39, 41, 27, 57,
54, 43, 41, 45, 32, 43, 33, 34, 92.850502014160199, 45.153518676757798,
87.13720703125, 64.069709777832003, 76.883651733398395, 139.28546142578099,
130.84614562988301, 108.056999206543, 133.353103637695, 81.660438537597699,
91.048492431640597, 115.59063720703099, 112.859329223633, 54.197868347167997,
71.182167053222699, 39.294445037841797, 80.398780822753906, 111.27394866943401,
105.44480133056599, 93.179267883300795, 108.67278289794901, 108.67278289794901,
90.566810607910199, 98.967033386230497, 74.374969482421903, 76.042869567871094,
80.297515869140597, 83.917564392089901, 62.100780487060497, 105.830284118652,
36.144577026367202, 101.918098449707, 110.53492736816401, 111.284225463867,
105.32364654541, 106.73191070556599, 105.28532409668, 112.072967529297,
116.73444366455099, 83.305084228515597, 114.37094879150401, 135.53935241699199,
106.119552612305, 120.096084594727, 79.799354553222699, 132.53013610839801,
116.286575317383, 121.261100769043, 90.045845031738295, 98.039207458496094,
124.470993041992, 107.318069458008, 80.410705566406193, 127.16408538818401,
67.963439941406307, 162.866455078125, 84.979812622070298, 80.921867370605497,
105.301383972168, 106.004066467285, 79.151496887207003, 76.281074523925795,
100.509246826172, 115.039962768555, 77.075538635253906, 47.988483428955099,
94.637229919433594, 45.164039611816399, 51.768768310546903, 44.988304138183601,
93.2918701171875, 62.945869445800803, 88.078018188476605, 65.636383056640597,
93.572006225585895, 68.686279296875, 90.766830444335895, 85.061561584472699,
90.636550903320298, 98.837677001953097, 111.13257598877, 92.487625122070298,
127.192253112793, 66.350357055664105, 80.836082458496094, 104.88364410400401,
60.795547485351598, 35.790977478027301, 114.819343566895, 91.491920471191406,
112.939659118652, 79.641319274902301, 75.991966247558594, 54.263038635253899,
124.837158203125, 116.792121887207, 62.177154541015597, 123.44460296630901,
106.330764770508, 105.545951843262, 63.323196411132798, 96.065177917480497,
92.407768249511705, 75.261535644531307, 104.861770629883, 66.802894592285199,
89.427276611328097, 63.1811714172363, 77.466865539550795, 124.156120300293,
75.396560668945298, 75.171012878417997, 70.750793457031307, 104.705947875977,
41.76318359375, 80.080924987792997, 34.930141448974602, 78.176437377929702,
59.453033447265597, 54.338741302490199, 57.742282867431598, 120.254257202148,
85.448181152343693, 127.334465026855, 67.781295776367202, 62.656642913818402,
88.785041809082003, 86.723434448242202, 81.219055175781193, 93.109870910644503,
56.405559539794901, 83.338890075683594, 99.35205078125, 76.883651733398395,
41.012420654296903, 81.884109497070298, 70.912399291992202, 79.923271179199205,
92.886459350585895, 37.721611022949197, 63.100326538085902, 130.54019165039099,
77.524383544921903, 47.254920959472699, 51.517421722412102, 15.807776451110801,
61.184535980224602, 54.8675346374512, 76.080902099609403, 72.399200439453097,
56.572715759277301, 58.324150085449197, 68.685096740722699, 108.00107574462901,
48.749912261962898, 72.712463378906307, 67.571723937988295, 92.469543457031307,
36.359855651855497, 90.780715942382798, 110.36245727539099, 34.533031463622997,
32.423084259033203, 45.653762817382798, 83.930168151855497, 85.676452636718693,
90.914993286132798, 82.529762268066406, 42.304172515869098, 83.785781860351605,
109.75226593017599, 117.205810546875, 50.563980102539098, 49.7265014648437,
104.65177154541, 114.700523376465, 57.035499572753899, 94.744468688964801,
18.998405456543001, 92.506927490234403, 66.662429809570298, 70.336982727050795,
88.034370422363295, 29.817686080932599, 81.967216491699205, 121.30177307128901,
93.358161926269503, 39.256736755371101, 62.543979644775398, 76.936996459960895,
77.866462707519503, 66.771171569824205, 68.651313781738295, 36.410709381103501,
60.822898864746101, 84.577117919921903, 90.787452697753906, 69.369308471679702,
80.971649169921903, 80.085418701171903, 91.777961730957003, 69.286338806152301,
66.039932250976605, 60.559696197509801, 71.674308776855497, 90.5660400390625,
74.780334472656307, 89.1392822265625, 109.449111938477, 47.364799499511697,
107.014320373535, 45.620433807373097, 109.06650543212901, 76.949378967285199,
131.18867492675801, 83.063385009765597, 88.523551940917997, 76.917930603027301,
73.338226318359403, 81.903274536132798, 91.081443786621094, 78.701019287109403,
49.173881530761697, 54.351768493652301, 69.128974914550795, 111.876586914063,
85.997970581054702, 107.702606201172, 61.983478546142599, 119.57145690918,
115.697891235352, 103.416580200195, 105.86679840087901, 85.251495361328097,
55.1002197265625, 64.575149536132798, 90.049415588378906, 121.117752075195,
71.326683044433594, 67.823234558105497, 91.098388671875, 63.894054412841797,
69.247024536132798, 86.132644653320298, 41.062938690185597, 96.959625244140597,
98.509506225585895, 63.032089233398402, 45.314479827880902, 74.576690673828097,
90.488639831542997, 83.508628845214901, 76.754379272460895, 67.785118103027301,
99.044914245605497, 80.601829528808594, 63.119930267333999, 55.9382934570313,
96.238883972167997, 90.822929382324205, 77.432678222656307, 26.429389953613299,
58.361629486083999, 65.274154663085895, 82.787689208984403, 37.425148010253899,
79.853981018066406, 66.142433166503906, 71.748115539550795, 98.241004943847699,
76.746726989746094, 49.8602104187012, 70.758232116699205, 80.662513732910199,
122.25685882568401, 74.294197082519503, 72.239418029785199, 83.298629760742202,
80.115982055664105, 81.782066345214801, 84.338104248046903, 97.826835632324205,
96.057456970214901, 58.496639251708999, 105.86491394043, 51.994358062744098,
92.466415405273395, 106.06329345703099, 35.396144866943402, 61.527332305908203,
69.924629211425795, 107.321014404297, 101.785888671875, 78.588890075683594,
83.5330810546875, 58.811996459960902, 79.700813293457003, 92.785240173339801,
22.691745758056602, 63.0769233703613, 76.219512939453097, 88.193580627441406,
92.283340454101605, 63.548545837402301, 68.645957946777401, 71.143028259277301,
64.616180419921903, 18.157058715820298, 82.928993225097699, 58.622898101806598,
104.721435546875, 56.789943695068402, 76.023002624511705, 79.070129394531307,
58.750568389892599, 86.913337707519503, 91.863502502441406, 101.312660217285,
45.819023132324197, 61.610504150390597, 63.601669311523402, 108.11759185791,
25.357110977172798, 66.813652038574205, 67.666046142578097, 79.008659362792997,
94.998603820800795, 105.50058746337901, 70.011665344238295, 100.232124328613,
20.48508644104, 50.229171752929702, 117.863723754883, 57.1973266601563,
83.757949829101605, 106.08828735351599, 101.85373687744099, 59.481327056884801,
44.308784484863303, 69.487869262695298, 92.4365234375, 69.049331665039105,
79.901214599609403, 28.995111465454102, 42.7063598632813, 63.457530975341797,
78.508338928222699, 77.714012145996094, 108.90151214599599, 82.888198852539105,
83.979835510253906, 87.879905700683594, 60.191349029541001, 40.405296325683601,
91.217102050781307, 92.810737609863295, 47.588630676269503, 77.164901733398395,
38.989391326904297, 66.073471069335895, 34.8756103515625, 83.672134399414105,
75.919975280761705, 63.245891571044901, 70.926177978515597, 51.076530456542997,
63.276576995849602, 89.605735778808594, 64.409271240234403, 66.680709838867202,
90.642326354980497, 138.80950927734401, 81.967208862304702, 102.766792297363,
56.089206695556598, 118.862190246582, 85.895118713378906, 76.258255004882798,
129.54299926757801, 88.949699401855497, 83.752090454101605, 89.248527526855497,
82.133270263671903, 26.917901992797901, 91.114509582519503, 49.352928161621101,
59.382423400878899, 99.717468261718807, 78.257911682128906, 80.858177185058594,
50.195461273193402, 54.6068305969238, 61.561187744140597, 66.979240417480497,
69.393722534179702, 98.667984008789105, 61.695072174072301, 57.219154357910199,
80.814605712890597, 94.227691650390597, 50.964687347412102, 67.904022216796903,
102.848091125488, 112.618644714355, 60.753345489502003, 74.610954284667997,
82.396278381347699, 58.528018951416001, 43.103446960449197, 61.159591674804702,
32.010246276855497, 48.165988922119098, 64.279151916503906, 75.145599365234403,
80.071174621582003, 56.134723663330099, 86.771537780761705, 91.625137329101605,
49.889137268066399, 59.783580780029297, 76.575263977050795, 58.165554046630902,
54.208553314208999, 28.578428268432599, 67.397293090820298, 82.425262451171903,
75.685905456542997, 61.414283752441399, 70.478370666503906, 63.405189514160199,
62.826210021972699, 65.069282531738295, 66.906120300292997, 77.256996154785199,
31.334867477416999, 64.161323547363295, 87.719291687011705, 82.203041076660199,
88.818954467773395, 78.142448425292997, 75.845458984375, 44.779460906982401,
68.775779724121094, 56.378261566162102, 106.22573852539099, 73.346862792968807,
59.769622802734403, 65.210304260253906, 65.759193420410199, 74.536796569824205,
48.250904083252003, 21.296230316162099, 96.899223327636705, 123.296112060547,
80.256820678710895, 74.496055603027301, 88.214538574218807, 97.717597961425795,
48.8095893859863, 52.054134368896499, 84.213752746582003, 43.277553558349602,
67.385444641113295, 96.270423889160199, 80.660476684570298, 56.572715759277301,
58.724220275878899, 68.186248779296903, 40.518638610839801, 49.006507873535199,
53.985080718994098, 64.220176696777301, 90.924118041992202, 96.256683349609403,
77.166152954101605, 100.435218811035, 58.655330657958999, 84.085952758789105,
75.728889465332003, 72.662681579589901, 70.013999938964801, 82.390838623046903,
30.656040191650401, 76.619316101074205, 81.900077819824205, 60.5152397155762,
32.879596710205099, 50.146854400634801, 118.30940246582, 82.534439086914105,
88.693862915039105, 64.281929016113295, 36.591049194335902, 67.8922119140625,
101.653945922852, 32.955886840820298, 49.705905914306598, 30.494003295898398,
16.524829864501999, 66.037109375, 47.6574516296387, 85.055931091308594,
70.764259338378906, 47.368419647216797, 53.422607421875, 84.685028076171903,
63.437572479247997, 38.417209625244098, 16.647245407104499, 90.134895324707003,
98.324211120605497, 98.183410644531307, 77.790740966796903, 38.370037078857401,
103.47023010253901, 36.320411682128899, 76.458442687988295, 40.343494415283203,
47.641735076904297, 38.262866973877003, 52.407234191894503, 67.024131774902301,
81.652648925781307, 62.888679504394503, 65.761940002441406, 64.124488830566406,
59.832462310791001, 71.558319091796903, 43.050430297851598, 62.8140678405762,
63.552589416503899, 37.4503784179687, 87.787742614746094, 58.780029296875,
17.820549011230501, 86.562232971191406, 98.400993347167997, 89.434768676757798,
39.799861907958999, 52.882072448730497, 104.53176116943401, 96.099945068359403,
40.436717987060597, 64.437355041503906, 63.379001617431598, 48.4527397155762,
84.676658630371094, 63.262874603271499, 72.289169311523395, 46.100654602050803,
104.125625610352, 79.950798034667997, 69.498748779296903, 66.929428100585895,
87.751701354980497, 90.351722717285199, 60.3304252624512, 114.394653320313,
102.13143157959, 89.589675903320298, 37.459709167480497, 31.138790130615199,
52.118228912353501, 46.918987274169901, 83.822296142578097, 106.780563354492,
23.137434005737301, 72.841590881347699, 84.479377746582003, 93.933464050292997,
54.863239288330099, 71.523941040039105, 69.224113464355497, 97.923561096191406,
16.7037868499756, 66.981597900390597, 95.785438537597699, 89.600196838378906,
102.61443328857401, 40.853378295898402, 74.775672912597699, 80.685203552246094,
107.492889404297, 90.999343872070298, 118.071083068848, 66.988212585449205,
94.464393615722699, 73.434127807617202, 56.190914154052699, 66.889633178710895,
67.001678466796903, 27.178836822509801, 79.418167114257798, 44.897697448730497,
66.822586059570298, 39.9970893859863, 76.582321166992202, 87.549247741699205,
70.560134887695298, 58.049537658691399, 61.032524108886697, 103.599113464355,
75.885330200195298, 40.804214477539098, 26.9164524078369, 91.181831359863295,
91.688949584960895, 53.652179718017599, 54.964717864990199, 75.741172790527301,
29.233018875122099, 49.873054504394503, 57.3230171203613, 74.706504821777301,
86.885421752929702, 49.942375183105497, 71.180709838867202, 73.964500427246094,
40.011428833007798, 84.961776733398395, 80.180770874023395, 71.343635559082003,
41.3679008483887, 95.402503967285199, 43.802444458007798, 59.120761871337898,
81.133361816406193, 69.265777587890597, 71.318534851074205, 60.7269897460938,
74.436416625976605, 86.142318725585895, 87.776039123535199, 48.547618865966797,
82.279563903808594, 50.907073974609403, 96.202819824218807, 89.410453796386705,
51.149154663085902, 57.982227325439503, 79.311813354492202, 37.098869323730497,
76.867431640625, 68.526672363281307, 57.588371276855497, 45.741855621337898,
108.00978088378901, 65.006500244140597, 96.188850402832003, 57.045066833496101,
78.186088562011705, 38.617488861083999, 74.259719848632798, 53.802009582519503,
78.740150451660199, 44.497180938720703, 78.444557189941406, 63.195911407470703,
58.782039642333999, 77.220069885253906, 134.41719055175801, 116.02309417724599,
52.387367248535199, 32.365077972412102, 44.0313110351562, 58.868343353271499,
76.060089111328097, 89.943458557128906, 45.2794799804687, 57.343826293945298,
50.262077331542997, 73.436843872070298, 71.375160217285199, 69.8323974609375,
72.231132507324205, 92.484413146972699, 79.267219543457003, 60.909576416015597,
106.918243408203, 96.662590026855497, 31.083478927612301, 36.755699157714801,
69.609603881835895, 90.500373840332003, 75.629501342773395, 93.991752624511705,
47.851978302002003, 73.394493103027401, 56.925998687744098, 48.8567504882812,
69.981582641601605, 68.001983642578097, 85.622299194335895, 42.219539642333999,
57.414070129394503, 60.136814117431598, 60.341629028320298, 57.548435211181598,
45.129257202148402, 21.050859451293899, 68.982315063476605, 76.973831176757798,
39.449954986572301, 91.452690124511705, 24.026910781860401, 88.658523559570298,
46.926326751708999, 47.769523620605497, 51.5375366210938, 92.916488647460895,
55.701442718505902, 57.532665252685597, 45.048427581787102, 92.088096618652401,
40.225261688232401, 73.642219543457003, 58.024898529052699, 54.880104064941399,
61.9866752624512, 63.366004943847699, 29.605506896972699, 85.204498291015597,
54.200546264648402, 102.023788452148, 53.422607421875, 85.266906738281193,
41.696453094482401, 90.171325683593807, 88.967956542968807, 95.752944946289105,
55.962554931640597, 88.672142028808594, 60.949592590332003, 35.794189453125,
37.325809478759801, 59.209957122802699, 76.715133666992202, 58.635059356689503,
101.221633911133, 44.759895324707003, 76.65283203125, 57.954212188720703,
61.690315246582003, 58.415763854980497, 63.456253051757798, 42.444820404052699,
52.611438751220703, 88.577697753906307, 70.783935546875, 69.633262634277301,
70.843826293945298, 102.26442718505901, 66.747047424316406, 59.039615631103501,
72.702598571777301, 67.301712036132798, 49.298858642578097, 28.1267604827881,
62.843379974365199, 53.683723449707003, 79.314720153808594, 58.696929931640597,
31.0390300750732, 81.660438537597699, 44.396522521972699, 60.559696197509801,
46.372970581054702, 80.1763916015625, 84.405998229980497, 53.390281677246101,
62.533500671386697, 84.877883911132798, 97.763664245605497, 31.0091247558594,
51.444103240966797, 33.855682373046903, 82.644630432128906, 76.084205627441406,
56.9043998718262, 33.227497100830099, 21.0526313781738, 68.341026306152301,
51.941829681396499, 83.872505187988295, 79.599723815917997, 65.142341613769503,
59.377719879150398, 60.817386627197301, 71.273628234863295, 67.983680725097699,
97.936347961425795, 74.558853149414105, 59.622390747070298, 80.5384521484375,
70.686744689941406, 63.392776489257798, 64.245330810546903, 77.009239196777301,
44.237998962402401, 41.508129119872997, 45.2173881530762, 69.735008239746094,
74.531517028808594, 80.575843811035199, 34.899143218994098, 40.768253326416001,
88.169044494628906, 60.650978088378899, 76.973464965820298, 43.837223052978501,
52.866542816162102, 74.444648742675795, 54.238338470458999, 30.168947219848601,
50.709934234619098, 73.176025390625, 84.060958862304702, 77.4329833984375,
36.488357543945298, 69.343757629394503, 75.464271545410199, 64.297798156738295,
50.444828033447301, 79.668571472167997, 44.986095428466797, 90.815757751464901,
68.925483703613295, 34.5518608093262, 73.672424316406193, 68.338966369628906,
28.631965637206999, 108.397163391113, 59.436519622802699, 40.773059844970703,
64.409271240234403, 50.382312774658203, 39.386775970458999, 73.000892639160199,
48.192775726318402, 9.7637176513671893, 88.727386474609403, 63.168628692627003,
63.786354064941399, 37.904632568359403, 77.164901733398395, 76.907508850097699,
49.333988189697301, 18.474533081054702, 23.561090469360298, 85.193389892578097,
39.532638549804702, 58.313896179199197, 24.624475479126001, 64.231231689453097,
42.256500244140597, 82.515060424804702, 38.343563079833999, 37.502346038818402,
67.020217895507798, 30.621171951293899, 54.248035430908203, 53.758186340332003,
83.390190124511705, 60.794895172119098, 41.234283447265597, 23.746198654174801,
73.026626586914105, 93.655830383300795, 71.886749267578097, 51.513706207275398,
42.211902618408203, 72.542625427246094, 76.9569091796875, 64.032196044921903,
31.864530563354499, 54.926479339599602, 72.924125671386705, 39.7378120422363,
60.3448295593262, 86.831764221191406, 69.247024536132798, 34.320030212402301,
53.943889617919901, 78.704734802246094, 43.715847015380902, 66.798141479492202,
34.093410491943402, 82.123100280761705, 31.3302822113037, 110.66096496582,
82.918731689453097, 71.462608337402301, 57.641040802002003, 70.084098815917997,
64.6134033203125, 103.885307312012, 79.032371520996094, 66.784049987792997,
38.0264282226562, 59.512912750244098, 29.520919799804702, 28.415548324585,
66.8712158203125, 45.8505249023438, 27.901788711547901, 56.625144958496101,
46.995876312255902, 32.993621826171903, 59.808605194091797, 91.863510131835895,
54.539356231689503, 62.817661285400398, 85.7901611328125, 59.6987495422363,
59.767093658447301, 54.482711791992202, 99.611511230468807, 50.033359527587898,
105.438400268555, 67.823234558105497, 75.954177856445298, 83.772872924804702,
29.1715278625488, 51.373382568359403, 48.736904144287102, 78.529464721679702,
79.722930908203097, 50.0450439453125, 42.841228485107401, 68.605918884277301,
87.001914978027301, 97.358627319335895, 91.380455017089801, 72.739471435546903,
39.840641021728501, 66.981597900390597, 89.898651123046903, 93.329010009765597,
76.052055358886705, 92.6776123046875, 77.065353393554702, 69.119522094726605,
54.989372253417997, 55.504161834716797, 73.700325012207003, 55.419204711914098,
40.3132934570313, 62.537025451660199, 108.983390808105, 33.430107116699197,
88.1494140625, 76.604873657226605, 102.28684997558599, 92.599182128906307,
59.834644317627003, 81.986412048339901, 89.208885192871094, 22.168035507202099,
61.715694427490199, 83.592979431152301, 10.5864915847778, 76.419212341308594,
80.139007568359403, 83.603828430175795, 39.756153106689403, 45.630844116210902,
102.786651611328, 73.873420715332003, 52.154819488525398, 71.901695251464801,
94.613349914550795, 80.478263854980497, 34.770515441894503, 51.083702087402401,
56.980056762695298, 60.216781616210902, 87.327774047851605, 65.087570190429702,
78.532165527343807, 67.230117797851605, 32.824554443359403, 81.398330688476605,
50.552467346191399, 79.018653869628906, 59.594757080078097, 93.546417236328097,
53.119907379150398, 42.3519477844238, 64.536949157714801, 53.078559875488303,
63.205799102783203, 62.232593536377003, 67.554527282714801, 80.0147705078125,
64.121910095214801, 73.444145202636705, 97.095237731933594, 60.324825286865199,
75.724113464355497, 78.655982971191406, 81.623123168945298, 29.3358364105225,
104.92600250244099, 91.434066772460895, 104.926544189453, 72.716697692871094,
66.957336425781193, 49.504951477050803, 104.94475555419901, 68.218299865722699,
118.706504821777, 94.358039855957003, 85.895896911621094, 49.423389434814503,
65.713188171386705, 81.095695495605497, 39.781768798828097, 39.038780212402301,
51.268905639648402, 76.867057800292997, 111.24772644043, 83.108253479003906,
55.2079467773438, 96.411796569824205, 71.808982849121094, 72.321983337402301,
87.108009338378906, 95.561859130859403, 43.3944091796875, 57.114303588867202,
71.1077880859375, 64.470367431640597, 53.768264770507798, 84.510841369628906,
68.279357910156193, 47.375404357910199, 57.692310333252003, 80.739463806152401,
84.895652770996094, 73.685928344726605, 85.006477355957003, 55.751712799072301,
90.636550903320298, 72.791976928710895, 42.155284881591797, 59.634731292724602,
56.965629577636697, 50.78125, 31.4399528503418, 71.656562805175795,
95.874305725097699, 94.962844848632798, 34.099765777587898, 79.547462463378906,
81.847946166992202, 58.841987609863303, 80.652389526367202, 49.180324554443402,
87.327774047851605, 60.225189208984403, 66.572685241699205, 84.981979370117202,
90.925079345703097, 74.208999633789105, 84.204925537109403, 64.677078247070298,
80.180770874023395, 49.019607543945298, 34.062267303466797, 98.736175537109403,
49.532535552978501, 116.14241027832, 85.184921264648395, 27.5786018371582,
81.306320190429702, 58.664257049560597, 60.399734497070298, 39.635353088378899,
59.152931213378899, 53.447353363037102, 29.559564590454102, 57.012542724609403,
74.128974914550795, 50.838840484619098, 103.626945495605, 78.819152832031307,
97.186225891113295, 75.575218200683594, 101.21168518066401, 78.7933349609375,
67.180229187011705, 23.631351470947301, 67.740478515625, 64.297798156738295,
53.565452575683601, 55.820182800292997, 96.780769348144503, 62.630481719970703,
49.6348266601563, 72.235908508300795, 80.561088562011705, 80.281349182128906,
64.394683837890597, 54.747856140136697, 69.074394226074205, 80.537849426269503,
70.883308410644503, 73.751747131347699, 43.004581451416001, 39.491634368896499,
84.018486022949205, 58.327125549316399, 78.451881408691406, 63.694263458252003,
82.140335083007798, 47.913116455078097, 71.691925048828097, 71.132553100585895,
30.089410781860298, 53.074222564697301, 32.080661773681598, 50.662509918212898,
59.404132843017599, 67.921600341796903, 73.026626586914105, 92.499603271484403,
42.317092895507798, 79.528434753417997, 61.1027221679688, 31.8358669281006,
50.265041351318402, 70.563972473144503, 30.877815246581999, 65.876152038574205,
67.115951538085895, 73.684211730957003, 53.195114135742202, 71.693664550781193,
85.939041137695298, 52.396389007568402, 53.330169677734403, 88.718719482421903,
67.978538513183594, 67.356262207031307, 34.855598450000002, 56.749900820000001,
32.773166660000001, 35.745841980000002, 69.226104739999997, 40.798435210000001,
86.227455140000004, 23.647295, 52.507572170000003, 67.685844419999995,
30.857704160000001, 67.293312069999999, 47.356636049999999, 69.894302370000005,
52.890933990000001, 77.63502502, 39.224914550000001, 41.736789700000003,
31.351894380000001, 48.971893309999999, 33.27331161, 47.950260159999999,
52.268684389999997, 57.59659576, 58.859977720000003, 58.063674929999998,
45.797584530000002, 34.111690520000003, 64.083000179999999, 47.145252229999997,
61.609992980000001, 55.906379700000002, 58.457862849999998, 50.9344368,
77.607360839999998, 52.434215549999998, 59.9005394, 63.112014770000002,
56.680427549999997, 50.293380740000003, 42.71149063, 84.175079350000004,
28.046306609999998, 33.053077700000003, 43.66657257, 50.508720400000001,
58.139533999999998, 37.528480530000003, 53.1817894, 38.569000240000001,
38.656356809999998, 55.573585510000001, 89.040725710000004, 78.078071589999993,
52.509140010000003, 52.540664669999998, 46.913898469999999, 64.147628780000005,
47.782314300000003, 43.583538060000002, 51.732353209999999, 30.469631199999998,
48.269290920000003, 35.971225740000001, 60.645069120000002, 44.035541530000003,
87.651458739999995, 48.621372219999998, 69.073089600000003, 53.175323489999997,
62.745399480000003, 27.040668490000002, 54.21088409, 82.812927250000001,
43.626598360000003, 19.053876880000001, 58.527446750000003, 71.207633970000003,
32.626899719999997, 21.435531619999999, 51.663692470000001, 71.343338009999997,
54.964923859999999, 39.2747612, 60.878776549999998, 73.177268979999994,
53.21459961, 43.674610139999999, 69.039848329999998, 43.870750430000001,
84.6059494, 52.792804719999999, 39.522319789999997, 43.359607699999998,
74.130714420000004, 47.173133849999999, 41.442825319999997, 71.190956119999996,
61.584102629999997, 27.29384422, 42.971328739999997, 48.981307979999997,
53.426677699999999, 46.992481230000003, 59.474250789999999, 36.72251129,
36.20659637, 58.72483063, 63.864856719999999, 60.878242489999998,
66.025642399999995, 52.090286249999998, 107.7791367, 66.38156128,
67.151039119999993, 35.453685759999999, 60.742069239999999, 44.351860049999999,
46.665153500000002, 64.869308469999993, 48.840431209999998, 25.760801319999999,
26.726726530000001, 41.4822998, 35.808147429999998, 64.791915889999999,
49.715465549999998, 41.02845001, 34.63744354, 38.630424499999997,
36.236492159999997, 17.79359436, 47.237548830000001, 40.303298949999999,
18.376346590000001, 56.54475403, 31.86133766, 54.294498439999998,
48.521076200000003, 40.529487609999997, 84.05232239, 55.898326869999998,
39.173564910000003, 56.832469940000003, 54.091785430000002, 63.571949009999997,
52.281368260000001, 31.416902539999999, 52.977710719999997, 64.405967709999999,
45.480155940000003, 20.11001396, 46.338153839999997, 46.24163437,
39.797637940000001, 40.080162049999998, 59.876789090000003, 26.73796844,
75.418678279999995, 62.208915709999999, 52.62138367, 29.603494640000001,
34.28081512, 38.810901639999997, 62.544673920000001, 58.194549559999999,
41.400203699999999, 43.442844389999998, 39.524173740000002, 68.049896239999995,
50.145347600000001, 43.347640991210902, 54.797981262207003, 70.748298645019503,
48.2758598327637, 77.483444213867202, 37.151702880859403, 68.529411315917997,
50.997150421142599, 54.700855255127003, 57.100589752197301, 13.75,
51.724136352539098, 62.345676422119098, 29.496402740478501, 44.074073791503899,
33.7313423156738, 51.482479095458999, 79.945053100585895, 42.105262756347699,
54.128440856933601, 61.4718627929688, 30.6451625823975, 33.5877876281738,
46.994533538818402, 73.803527832031307, 75.074188232421903, 69.452453613281193,
40.9669189453125, 27.376426696777301, 49.008499145507798, 23.6363620758057,
74.679489135742202, 54.518070220947301, 34.055728912353501, 39.365077972412102,
50, 29.5774631500244, 27.952754974365199, 14.8044691085815, 40.234375,
20, 115.51155090332, 52.758617401123097, 12.881355285644499,
15.286623001098601, 22.614841461181602, 35.365852355957003, 20.512821197509801,
45.079360961914098, 59.7345161437988, 28.6118984222412, 76.276275634765597,
44.072948455810497, 59.516616821289098, 42.1875, 20.863309860229499,
36.101081848144503, 52.615386962890597, 30.529594421386701, 45.569622039794901,
49.450550079345703, 63.358779907226598, 49.815498352050803, 37.931034088134801,
23.9616603851318, 25.762710571289102, 45.993034362792997, 24.584718704223601,
61.662818908691399, 42.622951507568402, 42.063491821289098, 43.042072296142599,
67.549667358398395, 56.521736145019503, 45.244956970214801, 79.948577880859403,
30.5785121917725, 40.714286804199197, 71.473350524902301, 57.345977783203097,
25, 77.500007629394503, 59.166664123535199, 73.775215148925795,
20.833332061767599, 41.44384765625, 70.114944458007798, 71.717170715332003,
63.896106719970703, 34.983497619628899, 61.994606018066399, 24,
49.860725402832003, 32.424243927002003, 55.922863006591797, 55.395683288574197,
28.8702907562256, 58.064517974853501, 61.714286804199197, 46.0465087890625,
26.013511657714801, 25.752508163452099, 42.121212005615199, 26.9230766296387,
54.857143402099602, 31.269350051879901, 58.608058929443402, 33.189655303955099,
51.515148162841797, 75.767913818359403, 76.691726684570298, 75.595237731933594,
79.402000427246094, 65.045593261718807, 67.647056579589801, 68.4049072265625,
18.5567016601562, 31.034482955932599, 35.869564056396499, 47.500003814697301,
40.869564056396499, 40.883979797363303, 57.876712799072301, 20.9125461578369,
49.382717132568402, 51.125404357910199, 69.777778625488295, 26.490066528320298,
39.033454895019503, 14.9837141036987, 62.453529357910199, 42.965778350830099,
29.741380691528299, 21.933084487915, 34.876541137695298, 30.841121673583999,
52.903228759765597, 38.671875, 46.518985748291001, 35.909091949462898,
65.460525512695298, 30.9248561859131, 53.556480407714801, 72.705879211425795,
28.321680068969702, 31.249998092651399, 46.153850555419901, 38.2352905273437,
64.285713195800795, 42.857143402099602, 59.859157562255902, 42.813453674316399,
29.972751617431602, 45.454544067382798, 77.058815002441406, 76.369865417480497,
46.3768119812012, 64.102569580078097, 41.1949653625488, 32, 46,
56, 73, 74, 80, 54, 48, 26, 74, 48, 34, 35, 56, 21, 62, 47, 33,
58, 36, 58, 36, 47, 53, 35, 40, 54, 23, 27, 38, 70, 71, 20, 69,
58, 51, 40, 35, 48, 45, 31, 57, 28, 27, 25, 65, 61, 56, 60, 74,
50, 64, 87, 54, 43, 51, 31, 57, 51, 26, 44, 32, 65, 38, 43, 42,
50, 55, 53, 25, 65, 30, 25, 62, 83, 42, 78, 53, 34, 42, 26, 27,
35, 31, 21, 27, 28, 38, 52, 34, 32, 30, 24, 40, 20, 38, 32, 50,
43, 32, 43, 31, 25, 31, 32, 36, 26, 46, 25, 36, 39, 25, 38, 40,
36, 39, 52, 50, 42, 74, 59, 69, 53, 63, 42, 63, 35, 60, 40, 55,
44, 41, 52, 44, 53, 44, 41, 58, 38, 76, 61, 79, 78, 63, 33, 44,
32, 37, 69, 21, 40, 47, 39, 67, 62, 56, 48, 42, 56, 49, 41, 59,
66, 66, 26, 66, 37, 37, 63, 49, 61, 29, 35, 36, 33, 42, 62, 68,
71, 64, 37, 58, 62, 32, 62, 58, 42, 36, 27, 54, 38, 71, 51, 33,
60, 53, 40, 69, 37, 50, 47, 55, 48, 59, 69, 53, 45, 59, 54, 46,
54, 72, 71, 51, 54, 74, 58, 42, 74, 47, 70, 33, 58, 71, 54, 38,
62, 54, 62, 43, 55, 37, 55, 46, 50, 57, 61, 29, 54, 78, 29, 61,
64, 43, 55, 26, 60, 46, 45, 54, 62, 58, 77, 43, 72, 55, 68, 75,
28, 44, 59, 50, 45, 70, 69, 54, 62, 64, 50, 67, 43, 68, 73, 52,
30, 73, 48, 67, 67, 28, 55, 35, 53, 44, 48, 41, 42, 41, 62, 50,
59, 61, 60, 69, 53, 57, 51, 45, 78, 67, 64, 71, 79, 46, 56, 53,
65, 27, 48, 68, 41, 39, 46, 63, 66, 34, 70, 64, 62, 56, 54, 63,
59, 61, 46, 54, 55, 41, 60, 53, 58, 49, 74, 64, 69, 55, 38, 46,
72, 41, 69, 75, 71, 75, 54, 55, 34, 65, 53, 53, 49, 61, 52, 58,
45, 78, 66, 43, 56, 65, 75, 42, 34, 41, 35, 70, 65, 40, 56, 61,
58, 22, 65, 61, 66, 76, 58, 54, 62, 53, 74, 49, 65, 65, 75, 43,
29, 63, 63, 82, 62, 52, 66, 72, 69, 62, 78, 72, 39, 62, 43, 74,
50, 58, 68, 80, 99, 98, 51, 61, 85, 20, 74, 80, 36, 75, 98, 30,
89, 73, 95, 64, 74, 98, 90, 84, 68, 55, 102, 87, 85, 76, 70,
41, 77, 60, 94, 111, 77, 73, 80, 101, 69, 88, 72, 48, 62, 98,
81, 91, 57, 92, 95, 71, 92, 82, 96, 72, 49, 75, 78, 23, 98, 62,
86, 101, 112, 70, 87, 66, 50, 101, 65, 92, 48, 47, 84, 60, 41,
68, 57, 65, 63, 91, 80, 34, 39, 87, 86, 79, 28, 91, 53, 40, 65,
77, 24, 53, 47, 40, 27, 35, 19, 31, 39, 35, 37, 48.100000000000001,
32, 40, 20, 25, 55.399999999999999, 49, 58, 38, 33, 29, 34, 47,
27, 31, 64, 34, 31, 44, 92, 56, 40, 94, 33, 67, 49, 33, 38, 27,
51, 31, 44, 29, 50, 35, 47, 81, 33, 52, 75, 34, 40, 26, 33, 42,
39, 39, 55, 53, 42, 38, 54, 58, 37, 24, 16, 72, 82, 33, 11, 28,
70, 51, 81, 37, 43, 41, 34, 44, 40, 36, 32, 33, 28, 53, 47, 32,
52, 57, 49, 49, 26, 26, 68, 63, 49, 43, 59, 42, 36, 20, 53, 39,
34, 34, 42, 57, 31, 22, 31, 46, 43, 34, 39, 39, 43, 55, 12, 32,
58, 62, 63, 26, 42, 43, 32, 38, 42, 61, 25, 60, 25, 36, 30, 63,
42, 33, 36, 41, 36, 30, 46, 31, 36, 22, 64, 44, 63, 34, 32, 44,
49, 24, 54, 26, 28, 41, 15, 46, 63, 41, 23, 56, 42, 34, 43, 33,
37, 60, 51, 51, 55, 23, 60, 29, 57, 53, 19, 23, 45, 33, 31, 39,
39, 33, 32, 22, 42, 27, 35, 51, 33, 27, 54, 39, 27, 39, 42, 24,
47, 53, 65, 61, 50, 45, 24, 57, 59, 35, 53, 63, 37, 47, 29, 64,
26, 23, 47, 33, 45, 33, 36, 50, 41, 18, 26, 28, 53, 46, 42, 30,
28, 51, 25, 27, 42, 49, 29, 33, 41, 32, 31, 26, 91, 45, 27, 36,
50, 59, 45, 61, 32, 64, 60, 37, 59, 64, 23, 39, 52, 58, 74, 61,
24, 45, 33, 42, 45, 43, 43, 17, 41, 27, 57, 36, 50, 30, 50, 35,
60, 28, 48, 61, 31, 32, 26, 64, 38, 31, 53, 59, 40, 45, 47, 61,
48, 39, 61, 55, 53, 61, 27, 22, 49, 54, 56, 43, 64, 38, 58, 48,
22, 55, 30, 34, 37, 32, 61, 26, 61, 37, 35, 29, 61, 37, 31, 45,
41, 29, 54, 63, 61, 35, 30, 45, 44, 61, 56, 42, 41, 63, 46, 35,
58, 65, 55, 15, 61, 31, 43, 42, 22, 32, 28, 62, 42, 45, 64, 61,
54, 31, 41, 63, 38, 34, 30, 50, 65, 48, 60, 40, 58, 32, 54, 62,
28, 55, 56, 55, 56, 28, 48, 35, 40, 29, 34, 49, 29, 29, 35, 35,
51, 36, 30, 43, 54, 73, 40, 52, 25, 25, 22, 70, 39, 62, 39, 63,
40, 33, 39, 16, 26, 57, 48, 36, 31, 25, 37, 26, 76, 61, 28, 57,
17, 26, 33, 35, 68, 25, 47, 30, 55, 38, 44, 30, 41, 33, 64, 38,
47, 61, 32, 62, 52, 43, 49, 33, 33, 18, 37, 34, 31, 40, 35, 66,
52, 41, 27, 20, 46, 35, 31, 28, 23, 32, 23, 31, 47, 21, 40, 24,
26, 57, 31, 20, 25, 28, 23, 21, 12, 12, 49, 25, 45, 76, 61, 40,
62, 53, 77, 30, 22, 45, 56, 76, 51, 32, 23, 53, 58, 44, 62, 32,
43, 50, 23, 69, 28, 37, 42, 29, 42, 60, 50, 65, 63.5, 39, 49,
48, 43, 32, 43, 29, 65, 62, 34, 57, 24, 62, 33, 25, 54.5, 42,
63, 33, 41, 57, 40, 71, 42, 40, 68, 47, 41, 36, 44, 32, 62, 33,
44, 27, 42, 57, 59, 22, 31, 50, 65, 35, 52, 38, 42, 66, 47, 28,
55, 37, 30, 58, 25, 24, 39, 22, 56, 82, 23, 55, 69, 59, 68, 71,
65, 79, 75, 67, 59, 32, 75, 36, 46, 57, 60, 55, 71, 47, 77, 19,
57, 30, 18, 26, 46, 42, 28, 49, 36, 53, 47, 23, 32, 65, 43, 33,
61, 66, 37, 33, 33, 33, 27, 79, 69, 29, 44, 72, 74, 76, 29, 42,
49, 24, 52, 50, 55, 45, 24, 42, 80, 55, 72, 25, 68, 52, 50, 67,
48, 52, 129, 27, 97, 94, 70, 32, 75, 89, 47, 55, 76, 22, 72,
77, 41, 74, 43, 85, 85, 53, 71, 41, 43, 41, 41, 27, 53, 34, 47,
60, 24, 78, 32, 65, 60, 71, 54, 42, 55, 82, 51, 95, 59, 72, 67,
33, 37, 102, 75, 63, 27, 71, 59, 83, 69, 71, 80, 50, 58, 45,
61, 75, 57, 51, 34, 63, 50, 97, 68, 40, 81, 61, 52, 78, 64, 73,
84, 66, 95, 45, 41, 55, 41, 110, 79, 69, 25, 106, 79, 30, 66,
71, 84, 22, 86, 53, 97, 96, 31, 31, 75, 43, 83, 58, 56, 81, 75,
62, 77, 75, 86, 84, 68, 51, 88, 76, 46, 57, 96, 67, 75, 71, 51,
45, 90, 57, 86, 43, 59, 80, 71, 75, 47, 58, 51, 47, 59, 54, 59,
93, 92, 76, 60, 66, 40, 48, 63, 38, 41, 77, 72, 102, 43, 37,
62, 37, 56, 38, 103, 95, 32, 36, 73, 38, 50, 40, 82, 59, 29,
54, 53, 57, 77, 41, 46, 57, 64, 95, 67, 67, 41, 47, 65, 111,
58, 49, 54, 80, 109, 33, 40, 57, 39, 75, 62, 108, 61, 63, 68,
69, 45, 55, 49, 103, 58, 77, 69, 57, 65, 74, 53, 76, 33, 57,
63, 82, 28, 81, 53, 67, 89, 63, 24, 94, 77, 67, 73, 79, 56, 16,
96, 66, 45, 35, 62, 31, 42, 51, 57, 59, 64, 58, 71, 75, 106,
90, 40, 29, 62, 83, 51, 88, 38, 60, 81, 88, 50, 73, 50, 39, 66,
71, 56, 50, 36, 62, 85, 41, 34, 47, 31, 82, 51, 30, 82, 68, 65,
29, 62, 90, 107, 79, 34, 97, 82, 90, 37, 84, 80, 34, 96, 61,
51, 92, 56, 68, 90, 65, 65, 93, 87, 85, 79, 84, 76, 64, 74, 68,
52, 66, 87, 78, 24, 51, 48, 59, 16, 82, 62, 34, 67, 66, 29, 28,
67, 75, 54, 69, 91, 93, 89, 70, 66, 38, 50, 55, 35, 44, 38, 60,
40, 107, 63, 60, 64, 100, 73, 60, 69, 85, 49, 9, 55, 56, 41,
57, 84, 67, 32, 69, 88, 85, 60, 83, 37, 92, 66, 50, 65, 78, 67,
67, 88, 34, 63, 68, 51, 66, 77, 76, 73, 57, 78, 27, 37, 30, 64,
80, 84, 52, 33, 93, 38, 42, 68, 62, 60, 43, 68, 74, 85, 56, 66,
43, 58, 66, 77, 66, 76, 74, 65, 62, 69, 93, 48, 63, 48, 75, 69,
36, 44, 69, 49, 71, 29, 50, 25, 87, 48, 82, 64, 80, 104, 56,
72, 71, 72, 58, 87, 99, 90, 38, 74, 62, 63, 70, 81, 78, 50, 72,
81, 25, 63, 56, 28, 53, 96, 67, 74, 78, 66, 24, 59, 59, 27, 30,
28, 38, 42, 74, 26, 58, 101, 94, 83, 39, 47, 103, 19, 45, 37,
48, 104, 20, 60, 38, 41, 40, 76, 71, 59, 86, 38, 83, 32, 71,
72, 64, 28, 68, 67, 21, 79, 45, 73, 47, 42, 44, 42, 48, 46, 92,
59, 55, 25, 96, 62, 43, 17, 82, 75, 37, 36, 74, 62, 37, 78, 49,
75, 112, 82, 31, 65, 40, 39, 64, 46, 75, 81, 51, 57, 28, 87,
100, 69, 36, 94, 46, 75, 53, 67, 41, 55, 76, 54, 41, 47, 95,
104, 44, 95, 36, 41, 29, 120, 106, 104, 22, 95, 42, 113, 26,
27, 101, 81, 92, 127, 37, 101, 136, 126, 29, 117, 114, 124, 37,
69, 97, 113, 44, 50, 29, 107, 26, 40, 50, 57, 42, 39, 32, 96,
29, 22, 27, 93, 117, 108, 39, 38, 49, 32, 32, 98, 75, 26, 24,
47, 27, 62, 37, 101, 74, 63, 84, 110, 38, 31, 27, 67, 34, 35,
31, 55, 133, 42, 43, 120, 39, 73, 59, 27, 51, 35, 60, 37, 83,
115, 49, 37, 107, 39, 48, 66, 52, 50, 21, 132, 25, 59, 53, 51,
71, 63, 65, 39, 84, 104, 30, 54, 19, 47, 88, 54, 54, 34, 49,
52, 25, 34, 81, 68, 43, 32, 133, 100, 47, 57, 37, 79, 37, 21,
86, 38, 25, 52, 34, 37, 57, 22, 72, 25, 113, 58, 38, 79, 104,
85, 73, 98, 38, 48, 39, 61, 49, 32, 111, 36, 44, 41, 115, 118,
49, 138, 48, 83, 62, 110, 43, 60, 34, 43, 38, 49, 50, 65, 45,
108, 22, 36, 49, 63, 93, 79, 104, 74, 105, 26, 96, 122, 53, 40,
115, 78, 52, 79, 113, 114, 23, 118, 144, 59, 57, 66, 53, 36,
62, 34, 50, 53, 81, 26, 29, 50, 101, 111, 119, 58, 44, 30, 82,
79, 53, 42, 49, 99, 64, 67, 70, 82, 90, 115, 46, 111, 89, 86,
116, 47, 43, 109, 83, 93, 96, 101, 82, 91, 62, 56, 68, 43, 71,
92, 121, 88, 46, 60, 75, 99, 25, 59, 68, 64, 28.600000000000001,
51.700000000000003, 59.299999999999997, 42.5, 72.200000000000003,
61.399999999999999, 82.799999999999997, 35.200000000000003, 70.599999999999994,
42.799999999999997, 14.9, 68, 16.699999999999999, 49.899999999999999,
85.599999999999994, 45, 54, 66.700000000000003, 46.100000000000001,
42.100000000000001, 31.899999999999999, 23.300000000000001, 24.600000000000001,
91.599999999999994, 73.900000000000006, 50.200000000000003, 50.100000000000001,
47.399999999999999, 21.399999999999999, 59.700000000000003, 31.800000000000001,
57.200000000000003, 89.900000000000006, 55.399999999999999, 63,
43.799999999999997, 23.699999999999999, 45, 11.800000000000001,
74.400000000000006, 43.899999999999999, 96, 86, 21.5, 54, 37.799999999999997,
26.699999999999999, 30.899999999999999, 13, 19.100000000000001,
66.900000000000006, 62.899999999999999, 78.200000000000003, 26,
27.5, 21.399999999999999, 24.600000000000001, 23.100000000000001,
46.5, 63, 83.299999999999997, 94.200000000000003, 69.299999999999997,
63.100000000000001, 82, 67, 70.299999999999997, 57.399999999999999,
15.9, 32.600000000000001, 38.399999999999999, 40, 119.2, 67,
29.300000000000001, 76.5, 59.100000000000001, 67.599999999999994,
21.5, 38.200000000000003, 69.900000000000006, 74.400000000000006,
53.100000000000001, 51.299999999999997, 69.599999999999994, 51.899999999999999,
60, 51.299999999999997, 36.399999999999999, 36.600000000000001,
24.300000000000001, 59.899999999999999, 18.199999999999999, 23.300000000000001,
67.700000000000003, 55.5, 64.799999999999997, 81.700000000000003,
16.600000000000001, 69.700000000000003, 57.700000000000003, 53.700000000000003,
61.600000000000001, 112.90000000000001, 112.3, 40.899999999999999,
74.200000000000003, 32.200000000000003, 37.899999999999999, 83.099999999999994,
30.899999999999999, 33.5, 51.5, 65.700000000000003, 73, 81.599999999999994,
86.299999999999997, 79.900000000000006, 24.800000000000001, 47.100000000000001,
93.700000000000003, 39.5, 37.399999999999999, 101.90000000000001,
42.799999999999997, 12.9, 56.399999999999999, 85.5, 78.900000000000006,
64.599999999999994, 62.600000000000001, 45, 71.400000000000006,
50.5, 64.900000000000006, 65.5, 18.199999999999999, 57.5, 28,
68.299999999999997, 23.199999999999999, 81.5, 46.899999999999999,
70.099999999999994, 35.399999999999999, 80.5, 42.5, 52.600000000000001,
35.700000000000003, 53.399999999999999, 19.800000000000001, 46,
41.799999999999997, 21.800000000000001, 71.400000000000006, 62.299999999999997,
53.100000000000001, 56.899999999999999, 17.300000000000001, 32.100000000000001,
10.4, 39.200000000000003, 74.5, 34.200000000000003, 67.700000000000003,
19.399999999999999, 53.600000000000001, 25, 68.200000000000003,
40, 54.600000000000001, 68.700000000000003, 81.5, 23, 45.299999999999997,
20.300000000000001, 37.600000000000001, 56, 67.599999999999994,
33.399999999999999, 50, 56.600000000000001, 54, 67, 48.899999999999999,
87.099999999999994, 31.600000000000001, 92.5, 84.599999999999994,
69.900000000000006, 84, 30.199999999999999, 17.399999999999999,
58.200000000000003, 65.900000000000006, 23.899999999999999, 35.799999999999997,
62.200000000000003, 75.700000000000003, 77, 40.299999999999997,
80, 31.399999999999999, 54.799999999999997, 45.100000000000001,
66.700000000000003, 18.199999999999999, 89.299999999999997, 80.5,
37.799999999999997, 36.100000000000001, 40.899999999999999, 25.600000000000001,
33.899999999999999, 17.300000000000001, 79.200000000000003, 91.299999999999997,
32.100000000000001, 48.299999999999997, 46.600000000000001, 52.5,
72.099999999999994, 62.299999999999997, 51.399999999999999, 19.800000000000001,
40.299999999999997, 107.3, 19.5, 31.399999999999999, 60.899999999999999,
27.899999999999999, 19.600000000000001, 103.59999999999999, 29.699999999999999,
74.299999999999997, 89.900000000000006, 17.300000000000001, 39.200000000000003,
76.5, 89.700000000000003, 25.100000000000001, 36.200000000000003,
15.4, 43.600000000000001, 70.200000000000003, 30, 60.700000000000003,
81.200000000000003, 94.599999999999994, 29.300000000000001, 65.900000000000006,
76.900000000000006, 85.700000000000003, 51.299999999999997, 73.799999999999997,
67.200000000000003, 81.200000000000003, 73.299999999999997, 26.199999999999999,
66.400000000000006, 15.5, 31, 72.200000000000003, 40, 60.600000000000001,
47.5, 75.200000000000003, 33.799999999999997, 82.099999999999994,
86.5, 19, 68.599999999999994, 85, 63.200000000000003, 61.100000000000001,
39, 100.8, 58.799999999999997, 48.799999999999997, 75.200000000000003,
78, 25.699999999999999, 76.200000000000003, 65.700000000000003,
91.700000000000003, 40.899999999999999, 92.099999999999994, 58.100000000000001,
50.5, 51.600000000000001, 30.800000000000001, 26.699999999999999,
95.400000000000006, 46.100000000000001, 89.799999999999997, 15.4,
51.899999999999999, 40.700000000000003, 23.5, 43.200000000000003,
67.599999999999994, 43.299999999999997, 66.599999999999994, 78.799999999999997,
59.399999999999999, 40.899999999999999, 72.200000000000003, 33.299999999999997,
25.800000000000001, 27.699999999999999, 15.199999999999999, 101.2,
34.600000000000001, 41.700000000000003, 59.5, 66.400000000000006,
44.399999999999999, 57.399999999999999, 20.699999999999999, 55.799999999999997,
101.40000000000001, 74.700000000000003, 108.09999999999999, 63.399999999999999,
57.600000000000001, 34, 46.899999999999999, 93.5, 31.100000000000001,
43.799999999999997, 82.400000000000006, 81.400000000000006, 47.799999999999997,
67.099999999999994, 43.399999999999999, 67.5, 65.200000000000003,
17, 67.599999999999994, 48.399999999999999, 68.400000000000006,
48.399999999999999, 36.799999999999997, 50, 14.5, 43.5, 29.199999999999999,
93.200000000000003, 18.600000000000001, 17.899999999999999, 33.399999999999999,
37, 61.200000000000003, 38.100000000000001, 61.899999999999999,
41.399999999999999, 45.299999999999997, 34.799999999999997, 59.200000000000003,
52.799999999999997, 63.600000000000001, 26.600000000000001, 101.2,
75, 13.699999999999999, 86.5, 24.100000000000001, 92.5, 72.099999999999994,
20.300000000000001, 46.299999999999997, 89.400000000000006, 38.600000000000001,
39.600000000000001, 60.100000000000001, 101.90000000000001, 34.5,
72.400000000000006, 29.399999999999999, 85.700000000000003, 98.5,
24.800000000000001, 38, 88.299999999999997, 44.799999999999997,
32.200000000000003, 56.600000000000001, 29.100000000000001, 31.5,
38.299999999999997, 64.900000000000006, 43.799999999999997, 90.700000000000003,
75.599999999999994, 66.5, 35.5, 58.600000000000001, 81.900000000000006,
51.5, 53.899999999999999, 52.700000000000003, 75.799999999999997,
42.200000000000003, 79.900000000000006, 53.100000000000001, 78.5,
51.799999999999997, 71.400000000000006, 28.399999999999999, 40.200000000000003,
47.600000000000001, 33.799999999999997, 32, 58.700000000000003,
73.299999999999997, 55.200000000000003, 43.299999999999997, 66.099999999999994,
48.600000000000001, 43.799999999999997, 28.399999999999999, 47.200000000000003,
67.299999999999997, 84.5, 59.200000000000003, 80, 29.600000000000001,
50.299999999999997, 41, 64.599999999999994, 51.299999999999997,
27.899999999999999, 89, 28, 68.799999999999997, 63.899999999999999,
25.800000000000001, 65, 87.799999999999997, 54.799999999999997,
53, 61.600000000000001, 64, 40.399999999999999, 52.200000000000003,
97.099999999999994, 33.299999999999997, 29.5, 77.400000000000006,
26.5, 70.5, 97, 89.799999999999997, 21, 82.099999999999994, 36.600000000000001,
63.100000000000001, 52.799999999999997, 74.599999999999994, 18.800000000000001,
36.5, 36.399999999999999, 17.600000000000001, 36.100000000000001,
18.600000000000001, 29.899999999999999, 40.799999999999997, 16.199999999999999,
31.199999999999999, 45.200000000000003, 42.299999999999997, 35.700000000000003,
64.099999999999994, 52.200000000000003, 49.5, 26.100000000000001,
67.799999999999997, 71.099999999999994, 75, 26.300000000000001,
58.200000000000003, 29.300000000000001, 24.899999999999999, 90.200000000000003,
56.5, 18.800000000000001, 89.400000000000006, 43.899999999999999,
60.899999999999999, 47.899999999999999, 71.299999999999997, 88,
45.100000000000001, 29.899999999999999, 99.400000000000006, 66.799999999999997,
79.299999999999997, 83.900000000000006, 100.09999999999999, 29.899999999999999,
85.400000000000006, 60.899999999999999, 104.2, 82.799999999999997,
56.299999999999997, 41.399999999999999, 71.299999999999997, 20.300000000000001,
60.899999999999999, 77.099999999999994, 78.400000000000006, 37.799999999999997,
63.200000000000003, 57.799999999999997, 44.799999999999997, 40.799999999999997,
82.5, 79.700000000000003, 31.600000000000001, 58.799999999999997,
77.200000000000003, 73.900000000000006, 71.099999999999994, 53.700000000000003,
69.900000000000006, 23.899999999999999, 58.899999999999999, 47.600000000000001,
88.5, 43.299999999999997, 46.5, 50.799999999999997, 27.600000000000001,
59.5, 45.600000000000001, 92.5, 38.899999999999999, 34.399999999999999,
42.200000000000003, 87.200000000000003, 61.200000000000003, 99.299999999999997,
38.100000000000001, 46.399999999999999, 75.299999999999997, 107.90000000000001,
46.600000000000001, 49.799999999999997, 56.399999999999999, 82.099999999999994,
72, 23.600000000000001, 51.5, 56.799999999999997, 78.200000000000003,
78.099999999999994, 61.600000000000001, 66.799999999999997, 32.5,
89.299999999999997, 68.200000000000003, 72.200000000000003, 31.600000000000001,
69.900000000000006, 75.400000000000006, 75.900000000000006, 55.899999999999999,
47.700000000000003, 72.299999999999997, 71.799999999999997, 61.600000000000001,
20.699999999999999, 12.5, 74.700000000000003, 59.5, 70.200000000000003,
22.899999999999999, 76.599999999999994, 69.599999999999994, 24.600000000000001,
85.799999999999997, 87.200000000000003, 32.100000000000001, 70.5,
40, 78.200000000000003, 38.399999999999999, 62.5, 61.899999999999999,
44.5, 50.100000000000001, 77.599999999999994, 29, 71.299999999999997,
96.599999999999994, 21.699999999999999, 88.700000000000003, 20.699999999999999,
59.799999999999997, 100.2, 58.700000000000003, 32.700000000000003,
36.600000000000001, 33.700000000000003, 38.899999999999999, 31.199999999999999,
53.899999999999999, 88.299999999999997, 30.699999999999999, 58.899999999999999,
30.199999999999999, 75.099999999999994, 39.200000000000003, 35,
53.299999999999997, 77.099999999999994, 83.200000000000003, 22.600000000000001,
61.799999999999997, 52.5, 71.5, 45.799999999999997, 32.200000000000003,
79.700000000000003, 79.5, 43.100000000000001, 42.5, 61.200000000000003,
61.700000000000003, 34.5, 21.300000000000001, 93.5, 47.399999999999999,
40.399999999999999, 19.600000000000001, 15.800000000000001, 60.799999999999997,
29.199999999999999, 73.400000000000006, 28.5, 77.900000000000006,
82.599999999999994, 36.5, 78.5, 20.5, 28.5, 68.700000000000003,
41.200000000000003, 66.900000000000006, 76.900000000000006, 15.800000000000001,
17.699999999999999, 22.100000000000001, 94.400000000000006, 18.699999999999999,
81.400000000000006, 46.100000000000001, 71.200000000000003, 105.8,
89, 58.600000000000001, 63.399999999999999, 48.600000000000001,
50.600000000000001, 54.600000000000001, 21.800000000000001, 77.799999999999997,
95.900000000000006, 82.200000000000003, 90.700000000000003, 81.099999999999994,
53.600000000000001, 66.200000000000003, 75.5, 76.700000000000003,
56, 75.299999999999997, 38.100000000000001, 47.100000000000001,
116.09999999999999, 70.400000000000006, 40, 12, 86.299999999999997,
49.299999999999997, 94.099999999999994, 50, 71.799999999999997,
84.799999999999997, 83.299999999999997, 36.299999999999997, 29,
84.900000000000006, 82.200000000000003, 48.899999999999999, 73.799999999999997,
37.200000000000003, 85, 82.400000000000006, 13.699999999999999,
65.200000000000003, 50, 100.3, 64.799999999999997, 52, 12.199999999999999,
55.200000000000003, 50.700000000000003, 26.600000000000001, 19.699999999999999,
49, 81.400000000000006, 52.100000000000001, 113, 48.399999999999999,
25.100000000000001, 77.200000000000003, 74.299999999999997, 40.5,
72.700000000000003, 59.5, 17.800000000000001, 95.099999999999994,
17.699999999999999, 75.799999999999997, 24.5, 125.8, 75.599999999999994,
47.299999999999997, 42, 93.200000000000003, 57.200000000000003,
82.900000000000006, 51.399999999999999, 70.400000000000006, 59.399999999999999,
81, 84.299999999999997, 35.899999999999999, 58.200000000000003,
42.799999999999997, 80.900000000000006, 69.700000000000003, 22.699999999999999,
45.799999999999997, 23.5, 31.199999999999999, 77.5, 56, 78.400000000000006,
51.799999999999997, 105, 79.400000000000006, 84, 52.100000000000001,
47.100000000000001, 44.5, 51, 30.699999999999999, 73.900000000000006,
77.299999999999997, 72.700000000000003, 94.599999999999994, 90,
89.200000000000003, 91.799999999999997, 79.200000000000003, 68.400000000000006,
23.600000000000001, 91.299999999999997, 50.899999999999999, 53.200000000000003,
50.399999999999999, 65.5, 67.799999999999997, 41.200000000000003,
71.599999999999994, 65.5, 13.4, 44.600000000000001, 87.099999999999994,
35.899999999999999, 57.399999999999999, 38.5, 81.5, 18, 60.799999999999997,
47.299999999999997, 77.700000000000003, 98.299999999999997, 70.400000000000006,
44.399999999999999, 44.299999999999997, 50.600000000000001, 53.899999999999999,
74.599999999999994, 77.799999999999997, 57, 40.899999999999999,
79.299999999999997, 44.899999999999999, 27.5, 41.600000000000001,
53.399999999999999, 60.399999999999999, 23.5, 27.600000000000001,
39.299999999999997, 69.599999999999994, 78.299999999999997, 66,
68.400000000000006, 50, 56.200000000000003, 70.900000000000006,
66.900000000000006, 59.200000000000003, 24.100000000000001, 62.299999999999997,
26.5, 81.700000000000003, 77.5, 68.799999999999997, 45, 33.600000000000001,
85, 65.700000000000003, 36.100000000000001, 32.100000000000001,
20, 52.899999999999999, 73.299999999999997, 50, 38.399999999999999,
68.299999999999997, 89.099999999999994, 71.900000000000006, 56.600000000000001,
15.9, 49.200000000000003, 44.299999999999997, 37.700000000000003,
103.09999999999999, 41.100000000000001, 63, 51.899999999999999,
88.900000000000006, 64.700000000000003, 67.5, 53.700000000000003,
66.299999999999997, 22.100000000000001, 85.200000000000003, 85.799999999999997,
52.700000000000003, 28.699999999999999, 53, 66, 27.5, 73.799999999999997,
79.5, 55.700000000000003, 35.200000000000003, 32.799999999999997,
76.700000000000003, 75.599999999999994, 98.799999999999997, 53.899999999999999,
44, 69.799999999999997, 60.100000000000001, 43.200000000000003,
28.399999999999999, 56, 64.599999999999994, 19.199999999999999,
99.400000000000006, 84, 62.200000000000003, 80.099999999999994,
78, 60.899999999999999, 38.5, 77.799999999999997, 53, 37.100000000000001,
76, 66.799999999999997, 30.100000000000001, 41.399999999999999,
60.600000000000001, 43.399999999999999, 63.200000000000003, 22.5,
56.700000000000003, 42.299999999999997, 79.5, 72.200000000000003,
70.799999999999997, 44.200000000000003, 58.5, 16.699999999999999,
22.600000000000001, 22.800000000000001, 42.299999999999997, 57,
82.5, 92.599999999999994, 26.5, 76.400000000000006, 80.400000000000006,
28.600000000000001, 39.200000000000003, 61.799999999999997, 75.599999999999994,
30.600000000000001, 73.599999999999994, 79.700000000000003, 44.200000000000003,
50.600000000000001, 76.700000000000003, 54.600000000000001, 49.299999999999997,
83.900000000000006, 24.899999999999999, 34.700000000000003, 72.099999999999994,
40, 77.700000000000003, 81.299999999999997, 34, 83.799999999999997,
26.600000000000001, 69.599999999999994, 23.600000000000001, 39,
34.100000000000001, 49.100000000000001, 23.800000000000001, 52.600000000000001,
103, 37.799999999999997, 83.299999999999997, 55.799999999999997,
29.300000000000001, 78.200000000000003, 36.899999999999999, 72.5,
76.099999999999994, 36, 76.299999999999997, 89.799999999999997,
83.299999999999997, 46.5, 54.100000000000001, 28.100000000000001,
42.799999999999997, 41.100000000000001, 19.100000000000001, 58.799999999999997,
71.700000000000003, 49.600000000000001, 75.599999999999994, 55.200000000000003,
33.600000000000001, 63.5, 60.600000000000001, 98.099999999999994,
85.799999999999997, 93.599999999999994, 89.900000000000006, 43,
36.799999999999997, 25.300000000000001, 85.299999999999997, 30.399999999999999,
93.5, 96.200000000000003, 55.299999999999997, 47.700000000000003,
49.5, 95.200000000000003, 67.5, 79, 35.899999999999999, 31.899999999999999,
60.799999999999997, 54.799999999999997, 39.600000000000001, 73.900000000000006,
41.5, 24.800000000000001, 49.200000000000003, 38, 79.400000000000006,
72.400000000000006, 81.299999999999997, 33.100000000000001, 85.5,
33.399999999999999, 95.700000000000003, 85.099999999999994, 30,
20.800000000000001, 58.200000000000003, 70, 33.799999999999997,
35.100000000000001, 63.200000000000003, 48.200000000000003, 16.5,
68.700000000000003, 72.799999999999997, 61.700000000000003, 65.599999999999994,
63.899999999999999, 51.899999999999999, 74, 42.399999999999999,
25.699999999999999, 88.299999999999997, 64.5, 58.5, 49.299999999999997,
58.600000000000001, 23.199999999999999, 90.700000000000003, 62.600000000000001,
49.200000000000003, 73.200000000000003, 92, 45, 104.59999999999999,
65.900000000000006, 65.799999999999997, 50.299999999999997, 54.299999999999997,
50.399999999999999, 19.899999999999999, 25.699999999999999, 108.8,
11.199999999999999, 59.600000000000001, 23, 85.900000000000006,
88.900000000000006, 51.600000000000001, 34.600000000000001, 28.300000000000001,
45.5, 67.5, 40.5, 58.200000000000003, 47, 98.900000000000006,
36.200000000000003, 82.200000000000003, 93.900000000000006, 29.699999999999999,
33.200000000000003, 62.799999999999997, 72.599999999999994, 40.600000000000001,
85, 101.3, 15.6, 50.100000000000001, 62.600000000000001, 35.700000000000003,
38.899999999999999, 41, 24.800000000000001, 15.9, 78.599999999999994,
46.5, 69.700000000000003, 70.900000000000006, 29, 81, 46.299999999999997,
94.700000000000003, 70.400000000000006, 92.599999999999994, 59.299999999999997,
98.599999999999994, 28.100000000000001, 29.600000000000001, 74.900000000000006,
108.09999999999999, 41.399999999999999, 45.600000000000001, 24.800000000000001,
44.399999999999999, 49.5, 82.599999999999994, 58.200000000000003,
90.299999999999997, 28.100000000000001, 56.700000000000003, 45.100000000000001,
71.599999999999994, 67.400000000000006, 82.5, 43, 40.200000000000003,
66.799999999999997, 61.100000000000001, 53.600000000000001, 94.900000000000006,
69.700000000000003, 70.799999999999997, 46.100000000000001, 46.700000000000003,
53.5, 93.099999999999994, 19.600000000000001, 105.7, 57.700000000000003,
99.099999999999994, 78.900000000000006, 56, 43, 60.399999999999999,
60.600000000000001, 49.899999999999999, 100.7, 62.200000000000003,
52.200000000000003, 94.400000000000006, 62.200000000000003, 74.299999999999997,
38.899999999999999, 59.899999999999999, 82.400000000000006, 23,
88.5, 48.100000000000001, 50.5, 42.700000000000003, 87, 34.5,
98.900000000000006, 58.299999999999997, 87.599999999999994, 80.099999999999994,
24, 21, 37.399999999999999, 58.700000000000003, 36.799999999999997,
27, 85.299999999999997, 37.100000000000001, 63.799999999999997,
34.600000000000001, 54.600000000000001, 67.5, 27, 78.799999999999997,
78.200000000000003, 81.5, 74.799999999999997, 85, 36.700000000000003,
69.599999999999994, 63.100000000000001, 71.5, 34.700000000000003,
30.800000000000001, 72.400000000000006, 104.59999999999999, 62.700000000000003,
48.299999999999997, 51.100000000000001, 68, 64, 64.099999999999994,
37.700000000000003, 26.800000000000001, 73.900000000000006, 59.700000000000003,
74.599999999999994, 60.299999999999997, 19.300000000000001, 41.5,
70.799999999999997, 15.300000000000001, 59.799999999999997, 79.099999999999994,
70.099999999999994, 62.299999999999997, 45, 20.199999999999999,
75.5, 25.600000000000001, 14.300000000000001, 42.200000000000003,
43.899999999999999, 83.5, 81.400000000000006, 34.700000000000003,
28.899999999999999, 73.5, 87.599999999999994, 53.700000000000003,
23.899999999999999, 75, 55.600000000000001, 97.5, 32, 85.900000000000006,
32.5, 41.700000000000003, 70.900000000000006, 60, 31.600000000000001,
91.900000000000006, 59.600000000000001, 80.299999999999997, 44,
42.799999999999997, 75, 115.3, 28.800000000000001, 75.799999999999997,
63.600000000000001, 73.700000000000003, 43.700000000000003, 72.099999999999994,
66.200000000000003, 66.200000000000003, 35.5, 23.5, 47.600000000000001,
92.5, 51.799999999999997, 45, 32.299999999999997, 30.5, 31.699999999999999,
101.2, 35.700000000000003, 36.799999999999997, 53.299999999999997,
20.5, 24.899999999999999, 99.799999999999997, 62.899999999999999,
66.599999999999994, 75.400000000000006, 77.900000000000006, 71.5,
55.600000000000001, 72.400000000000006, 28.399999999999999, 79.5,
58.799999999999997, 41.5, 32.200000000000003, 38.100000000000001,
55.899999999999999, 34.200000000000003, 67.200000000000003, 55.5,
89, 9.5, 82.900000000000006, 63.799999999999997, 53.100000000000001,
68.5, 62.100000000000001, 82.200000000000003, 31.699999999999999,
26.300000000000001, 101.3, 53.100000000000001, 37.100000000000001,
65.799999999999997, 69, 86.5, 71.400000000000006, 84.900000000000006,
81.700000000000003, 94.099999999999994, 17.5, 58.899999999999999,
47.600000000000001, 75.200000000000003, 59, 16.600000000000001,
57, 43, 59.5, 78.200000000000003, 31.699999999999999, 43.600000000000001,
39, 45.399999999999999, 33.700000000000003, 73.400000000000006,
68.700000000000003, 52.100000000000001, 59.700000000000003, 41.799999999999997,
107.90000000000001, 79.900000000000006, 37.799999999999997, 64.900000000000006,
65.200000000000003, 57.299999999999997, 31.899999999999999, 96,
81.5, 71.700000000000003, 70.200000000000003, 41.399999999999999,
51.899999999999999, 74.799999999999997, 42, 32.899999999999999,
56.899999999999999, 50.600000000000001, 103.5, 76.900000000000006,
50.700000000000003, 43.399999999999999, 64.799999999999997, 28.100000000000001,
41.200000000000003, 17, 31.699999999999999, 27.199999999999999,
27.399999999999999, 44.200000000000003, 38.299999999999997, 61.399999999999999,
91.400000000000006, 30.300000000000001, 74.400000000000006, 26.899999999999999,
16.699999999999999, 75.400000000000006, 93.299999999999997, 75.700000000000003,
46.399999999999999, 58.299999999999997, 49.799999999999997, 24,
64.200000000000003, 63.299999999999997, 50, 85, 82.099999999999994,
74.400000000000006, 19.600000000000001, 51.299999999999997, 72.700000000000003,
21.399999999999999, 34.100000000000001, 62.899999999999999, 45.600000000000001,
83.299999999999997, 51.899999999999999, 76.900000000000006, 65.099999999999994,
88.900000000000006, 46.5, 73.5, 24.100000000000001, 69.299999999999997,
67, 67.299999999999997, 40.700000000000003, 24.5, 105.7, 80.700000000000003,
95, 59.899999999999999, 113.8, 83.799999999999997, 47.100000000000001,
67.599999999999994, 73.599999999999994, 76.900000000000006, 29.399999999999999,
86.200000000000003, 72.900000000000006, 61.600000000000001, 67.700000000000003,
55.700000000000003, 55.5, 63.299999999999997, 46.899999999999999,
85.900000000000006, 59, 71.599999999999994, 42.899999999999999,
89.700000000000003, 98.200000000000003, 53.399999999999999, 36.700000000000003,
42.700000000000003, 71.799999999999997, 15.800000000000001, 53.200000000000003,
63.700000000000003, 61.100000000000001, 57.600000000000001, 35.799999999999997,
76.200000000000003, 57.100000000000001, 76.200000000000003, 84.799999999999997,
72.799999999999997, 40.700000000000003, 54.399999999999999, 47.200000000000003,
66.200000000000003, 86, 89.700000000000003, 51.899999999999999,
54.899999999999999, 87, 68.599999999999994, 80.5, 66.599999999999994,
27.199999999999999, 63.600000000000001, 60.899999999999999, 68.099999999999994,
76.099999999999994, 25.5, 71.099999999999994, 52.5, 65.599999999999994,
71.400000000000006, 38.600000000000001, 34.600000000000001, 86,
60.299999999999997, 95.700000000000003, 55.700000000000003, 83.299999999999997,
83.900000000000006, 48.700000000000003, 61.799999999999997, 36,
63.5, 55.399999999999999, 70.700000000000003, 75, 64.400000000000006,
68.400000000000006, 82.799999999999997, 71.099999999999994, 65.200000000000003,
19.899999999999999, 29.399999999999999, 29.399999999999999, 64.700000000000003,
30.399999999999999, 117.90000000000001, 52, 75.5, 49, 18.100000000000001,
71.200000000000003, 37.100000000000001, 54.299999999999997, 49.600000000000001,
71.200000000000003, 78.599999999999994, 96.799999999999997, 41.299999999999997,
31.800000000000001, 49, 66.900000000000006, 27.199999999999999,
49.600000000000001, 34.600000000000001, 58.299999999999997, 75.900000000000006,
37.200000000000003, 48.799999999999997, 69.900000000000006, 67.099999999999994,
46, 94.400000000000006, 55.700000000000003, 73.900000000000006,
38.700000000000003, 37.200000000000003, 74.200000000000003, 27.800000000000001,
52.600000000000001, 57.799999999999997, 21.5, 66.5, 45.799999999999997,
77.5, 60.299999999999997, 52.799999999999997, 34.399999999999999,
21.100000000000001, 80.299999999999997, 65.200000000000003, 72,
102, 46.899999999999999, 79.599999999999994, 74.599999999999994,
45.100000000000001, 42.700000000000003, 98.400000000000006, 112,
43.200000000000003, 50.5, 46.899999999999999, 29.5, 44.5, 73.900000000000006,
51.600000000000001, 27.699999999999999, 62.200000000000003, 72.900000000000006,
94, 69.700000000000003, 50.799999999999997, 84.099999999999994,
9.8000000000000007, 74.700000000000003, 23.600000000000001, 36.399999999999999,
88.700000000000003, 47.899999999999999, 19.800000000000001, 50.799999999999997,
48.700000000000003, 73.700000000000003, 58.799999999999997, 94.900000000000006,
70.200000000000003, 91.799999999999997, 57.5, 46.700000000000003,
54.200000000000003, 62.700000000000003, 47.399999999999999, 82.799999999999997,
82.799999999999997, 39.200000000000003, 66.099999999999994, 41,
39.899999999999999, 44.700000000000003, 44.600000000000001, 77.799999999999997,
40.200000000000003, 71.5, 26.300000000000001, 70, 32.200000000000003,
52.5, 65.599999999999994, 70.799999999999997, 46.100000000000001,
42.399999999999999, 22.699999999999999, 41, 34.600000000000001,
51.299999999999997, 34.5, 54.399999999999999, 28.800000000000001,
72.700000000000003, 16.199999999999999, 41.200000000000003, 86.299999999999997,
44.5, 85.900000000000006, 21.899999999999999, 50.299999999999997,
48, 54.100000000000001, 59.5, 72.200000000000003, 38.899999999999999,
70.400000000000006, 41.600000000000001, 33, 51.5, 74.400000000000006,
27.899999999999999, 81.799999999999997, 60.399999999999999, 83.200000000000003,
45.799999999999997, 61, 94.700000000000003, 62, 23, 48.100000000000001,
45.700000000000003, 61.299999999999997, 56.299999999999997, 19,
33.700000000000003, 78, 26.100000000000001, 21.800000000000001,
94.799999999999997, 24.199999999999999, 86.700000000000003, 94.599999999999994,
44.700000000000003, 69.299999999999997, 23.800000000000001, 61.299999999999997,
71.299999999999997, 68.099999999999994, 71.200000000000003, 97.200000000000003,
45.100000000000001, 73.400000000000006, 26.5, 62.700000000000003,
32.5, 55.5, 51.700000000000003, 34.299999999999997, 63.100000000000001,
36.299999999999997, 94.900000000000006, 83.400000000000006, 56.899999999999999,
48.600000000000001, 83.900000000000006, 15.4, 71.700000000000003,
54.100000000000001, 75, 53.100000000000001, 56.200000000000003,
81.900000000000006, 83.5, 72.700000000000003, 35.600000000000001,
71.799999999999997, 65.099999999999994, 38, 16.699999999999999,
102.59999999999999, 67.299999999999997, 76, 60.100000000000001,
67.099999999999994, 56.799999999999997, 92.5, 46.200000000000003,
45.5, 38.5, 50.799999999999997, 60.100000000000001, 20, 52.600000000000001,
46.299999999999997, 17.800000000000001, 14, 88, 49.899999999999999,
36.899999999999999, 92.599999999999994, 40.600000000000001, 70.799999999999997,
80, 10.300000000000001, 38.299999999999997, 42.5, 34.200000000000003,
25.899999999999999, 104.3, 58.899999999999999, 38.899999999999999,
44.200000000000003, 56.299999999999997, 79.200000000000003, 69.700000000000003,
39.700000000000003, 61.5, 59.200000000000003, 65.099999999999994,
38.100000000000001, 81.299999999999997, 56.600000000000001, 22.699999999999999,
20.600000000000001, 30.5, 79.099999999999994, 44.600000000000001,
70.799999999999997, 23.899999999999999, 74.599999999999994, 68.900000000000006,
22.5, 73.599999999999994, 72, 72.200000000000003, 46.600000000000001,
66.700000000000003, 95.400000000000006, 26.300000000000001, 74.099999999999994,
86.299999999999997, 48.100000000000001, 60.100000000000001, 39.399999999999999,
35.700000000000003, 62.200000000000003, 35.299999999999997, 43.799999999999997,
48.100000000000001, 36.100000000000001, 22, 31.800000000000001,
62.299999999999997, 67.200000000000003, 46.399999999999999, 38.600000000000001,
52.799999999999997, 88.799999999999997, 83.700000000000003, 35.200000000000003,
55.600000000000001, 25.699999999999999, 58.700000000000003, 54.899999999999999,
95.299999999999997, 28.199999999999999, 76.599999999999994, 134.90000000000001,
44.399999999999999, 40.600000000000001, 27.399999999999999, 48.200000000000003,
24.300000000000001, 34.100000000000001, 75.799999999999997, 41.799999999999997,
76.200000000000003, 55.200000000000003, 61.799999999999997, 78.400000000000006,
55, 16.800000000000001, 61.299999999999997, 75.400000000000006,
67.700000000000003, 62.299999999999997, 88.200000000000003, 18.300000000000001,
64.200000000000003, 71.799999999999997, 18.100000000000001, 67.900000000000006,
63.5, 86, 79.400000000000006, 18, 40.899999999999999, 72, 88.200000000000003,
65.599999999999994, 51.700000000000003, 73.900000000000006, 69,
84.5, 70, 63.799999999999997, 88, 33.399999999999999, 91.599999999999994,
68.599999999999994, 47.600000000000001, 87.700000000000003, 79.799999999999997,
62.5, 47.700000000000003, 42.899999999999999, 72.200000000000003,
13.4, 63.700000000000003, 64.299999999999997, 41.299999999999997,
28.300000000000001, 54.700000000000003, 48.600000000000001, 31.5,
80.200000000000003, 34.100000000000001, 87.299999999999997, 69.400000000000006,
70.799999999999997, 33, 88.299999999999997, 75.5, 60.700000000000003,
57.200000000000003, 71.799999999999997, 67.400000000000006, 65.299999999999997,
84.299999999999997, 71.200000000000003, 43.399999999999999, 60.399999999999999,
55.399999999999999, 71.700000000000003, 82.900000000000006, 72.400000000000006,
21.899999999999999, 48.899999999999999, 85.400000000000006, 59.899999999999999,
30.600000000000001, 38.799999999999997, 50, 63.799999999999997,
23.800000000000001, 59.600000000000001, 48.100000000000001, 64,
40.5, 76.400000000000006, 45.600000000000001, 92.599999999999994,
57.200000000000003, 34, 102.7, 33, 57.799999999999997, 43.899999999999999,
55.399999999999999, 40.600000000000001, 56.799999999999997, 80.5,
48.700000000000003, 53, 36.899999999999999, 30.5, 77.200000000000003,
89.400000000000006, 24.699999999999999, 58.600000000000001, 25.600000000000001,
89.299999999999997, 52.100000000000001, 53.299999999999997, 68.400000000000006,
91, 64.700000000000003, 40.200000000000003, 53.200000000000003,
77.5, 47.899999999999999, 27.600000000000001, 21.899999999999999,
65.299999999999997, 83.5, 54.899999999999999, 25.699999999999999,
27.300000000000001, 60.700000000000003, 12.4, 81.099999999999994,
25.699999999999999, 35, 25.800000000000001, 23.399999999999999,
26.899999999999999, 27.399999999999999, 77.200000000000003, 39.5,
68.5, 35.100000000000001, 45.299999999999997, 71.299999999999997,
66.299999999999997, 42.700000000000003, 55.899999999999999, 52.600000000000001,
95.900000000000006, 45.799999999999997, 67.200000000000003, 66.599999999999994,
74.299999999999997, 68.700000000000003, 75.200000000000003, 63.5,
91.5, 71.200000000000003, 30.5, 70.5, 56, 32.200000000000003,
63.5, 70.599999999999994, 73.799999999999997, 91.599999999999994,
56, 67.299999999999997, 76.700000000000003, 37.899999999999999,
25.399999999999999, 67, 90.099999999999994, 87.099999999999994,
119.59999999999999, 68.5, 58, 38.399999999999999, 36.299999999999997,
20.699999999999999, 37.100000000000001, 33.899999999999999, 71.700000000000003,
39.600000000000001, 27.800000000000001, 57.299999999999997, 78.099999999999994,
66.099999999999994, 29.300000000000001, 36.600000000000001, 21.800000000000001,
52.399999999999999, 64.799999999999997, 84.700000000000003, 83.400000000000006,
20.199999999999999, 58.100000000000001, 48.299999999999997, 43.600000000000001,
54.700000000000003, 52.700000000000003, 79.900000000000006, 71.299999999999997,
67.700000000000003, 77.299999999999997, 61, 34, 47, 71.700000000000003,
55.399999999999999, 72.900000000000006, 94.299999999999997, 43,
68.200000000000003, 42.5, 101.3, 55.399999999999999, 22.699999999999999,
95.799999999999997, 74, 93.099999999999994, 53.5, 61.799999999999997,
75, 28.800000000000001, 88.200000000000003, 78.099999999999994,
65.599999999999994, 36.600000000000001, 43.200000000000003, 35.399999999999999,
49.100000000000001, 33.399999999999999, 11.699999999999999, 52.899999999999999,
66.299999999999997, 21.300000000000001, 25.5, 21.100000000000001,
50.399999999999999, 43, 39.399999999999999, 72.200000000000003,
72.400000000000006, 78.900000000000006, 92.900000000000006, 85.900000000000006,
100.40000000000001, 57.399999999999999, 72.900000000000006, 67,
35.200000000000003, 73.599999999999994, 96.700000000000003, 47.899999999999999,
57.399999999999999, 61.700000000000003, 55.700000000000003, 42.799999999999997,
59.700000000000003, 43.299999999999997, 36.200000000000003, 41.700000000000003,
39.100000000000001, 45.700000000000003, 46.600000000000001, 96.700000000000003,
26.199999999999999, 73.5, 57.399999999999999, 81.5, 38.5, 52.700000000000003,
49.5, 38.700000000000003, 92.900000000000006, 43.100000000000001,
31.600000000000001, 58.600000000000001, 75.200000000000003, 37.700000000000003,
31.300000000000001, 64.200000000000003, 28.5, 28.199999999999999,
47.600000000000001, 50.5, 75.599999999999994, 95.599999999999994,
52.299999999999997, 58.600000000000001, 48.600000000000001, 52.200000000000003,
40.600000000000001, 70.900000000000006, 115.2, 34.299999999999997,
80.099999999999994, 48.600000000000001, 17.5, 81.900000000000006,
63.5, 65.099999999999994, 23, 71.599999999999994, 98.700000000000003,
74.400000000000006, 70.5, 64.299999999999997, 36.600000000000001,
62.399999999999999, 72.5, 41.799999999999997, 62.799999999999997,
92.299999999999997, 33.5, 16.399999999999999, 36.399999999999999,
32.100000000000001, 50.600000000000001, 51.200000000000003, 47.5,
16.800000000000001, 76.099999999999994, 73.200000000000003, 78.400000000000006,
82.299999999999997, 52.799999999999997, 48.899999999999999, 62.600000000000001,
14.300000000000001, 41.899999999999999, 46.700000000000003, 52.100000000000001,
27.800000000000001, 60.899999999999999, 38.600000000000001, 27.399999999999999,
51.5, 60.299999999999997, 72.599999999999994, 38.100000000000001,
54.5, 26.600000000000001, 30.300000000000001, 52.100000000000001,
40.600000000000001, 30.399999999999999, 91.799999999999997, 70.200000000000003,
92.400000000000006, 49.700000000000003, 73.700000000000003, 16.300000000000001,
37, 48.600000000000001, 11.9, 71.299999999999997, 31.399999999999999,
91.599999999999994, 32.299999999999997, 56.700000000000003, 37,
92.400000000000006, 29.199999999999999, 52, 41.200000000000003,
79.5, 34, 19.100000000000001, 83.700000000000003, 69.700000000000003,
80.900000000000006, 57.299999999999997, 64, 41.5, 20.300000000000001,
32.200000000000003, 33.299999999999997, 76, 54, 61.100000000000001,
30.300000000000001, 44.600000000000001, 85.099999999999994, 84,
24.699999999999999, 47.799999999999997, 65.799999999999997, 40.200000000000003,
44, 69.799999999999997, 75.599999999999994, 119.90000000000001,
67.200000000000003, 53.399999999999999, 15.5, 59.200000000000003,
62.100000000000001, 69.200000000000003, 31.699999999999999, 78.599999999999994,
65.099999999999994, 33.600000000000001, 46.700000000000003, 101.8,
80.299999999999997, 98.299999999999997, 48, 65.900000000000006,
23.399999999999999, 68.099999999999994, 75.200000000000003, 83,
51.299999999999997, 58.5, 70.700000000000003, 54.600000000000001,
71.099999999999994, 66.799999999999997, 72.599999999999994, 73.799999999999997,
20.399999999999999, 15.699999999999999, 65.799999999999997, 39.600000000000001,
32.700000000000003, 61.200000000000003, 68.900000000000006, 71.200000000000003,
51, 40.600000000000001, 89.599999999999994, 52, 50.299999999999997,
70.900000000000006, 42.600000000000001, 78, 35.600000000000001,
24.600000000000001, 43.100000000000001, 72.099999999999994, 37.200000000000003,
41.700000000000003, 33, 82, 81.400000000000006, 73.5, 49.100000000000001,
58.899999999999999, 39.899999999999999, 73.099999999999994, 44.299999999999997,
67.900000000000006, 34.5, 30.800000000000001, 54.100000000000001,
81.599999999999994, 61.899999999999999, 70.799999999999997, 21.600000000000001,
46.799999999999997, 26.300000000000001, 78.599999999999994, 35,
23.300000000000001, 80, 29.5, 74.099999999999994, 24, 76.200000000000003,
19.5, 66.900000000000006, 48.700000000000003, 56.700000000000003,
30.100000000000001, 81.799999999999997, 38.100000000000001, 20.199999999999999,
60.700000000000003, 26.699999999999999, 73.599999999999994, 84.599999999999994,
78.299999999999997, 53.200000000000003, 51, 79.599999999999994,
63.700000000000003, 30.100000000000001, 40.899999999999999, 74.799999999999997,
39.299999999999997, 65.900000000000006, 67.700000000000003, 69.700000000000003,
63.299999999999997, 40.799999999999997, 97, 46.299999999999997,
67.799999999999997, 58.399999999999999, 16, 55, 71, 22, 54, 9,
64, 66, 32, 51, 68, 67, 61, 13, 58, 50, 56, 49, 55, 66, 52, 47,
76, 60, 66, 27, 52, 63, 37, 18, 14, 43, 18, 71, 57, 11, 53, 57,
57, 52, 73, 62, 52, 30, 63, 14, 75, 69, 28, 66, 28, 42, 54, 75,
57, 50, 63, 62, 39, 30, 74, 27, 81, 44, 56, 36, 25, 15, 79, 19,
52, 53, 65, 57, 30, 41, 17, 56, 37, 58, 25, 43, 23, 35, 61, 49,
78, 41, 56, 28, 51, 68, 44, 52, 41, 35, 25, 12, 69, 29, 47, 18,
62, 49, 26, 71, 66, 21, 51, 33, 51, 38, 43, 27, 50, 72, 58, 57,
12, 43, 55, 61, 34, 24, 23, 24, 52, 68, 43, 48, 16, 56, 76, 32,
33, 38, 69, 24, 18, 28, 71, 23, 49, 62, 47, 14, 48, 36, 34, 50,
47, 40, 44, 61, 45, 31, 22, 69, 31, 66, 50, 37, 21, 42, 45, 44,
57, 63, 19, 34, 28, 42, 63, 28, 24, 51, 67, 34, 57, 29, 26, 22,
52, 54, 37, 29, 66, 55, 42, 18, 52, 39, 40, 71, 15, 15, 37, 42,
69, 36, 44, 49, 18, 31, 21, 70, 58, 50, 12, 34, 32, 71, 39, 37,
38, 38, 60, 67, 26, 33, 54, 34, 63, 26, 40, 48, 21, 59, 26, 52,
19, 51, 33, 44, 26, 21, 31, 53, 12, 58, 17, 57, 71, 17, 62, 51,
15, 62, 55, 65, 59, 80, 41, 69, 48, 61, 69, 43, 25, 59, 53, 70,
38, 33, 58, 13, 17, 73, 56, 51, 43, 55, 78, 16, 72, 50, 58, 47,
26, 29, 73, 39, 22, 63, 52, 11, 41, 55, 69, 74, 53, 46, 72, 38,
59, 57, 59, 72, 64, 50, 49, 44, 63, 77, 15, 73, 30, 47, 53, 57,
67, 35, 19, 71, 39, 72, 78, 34, 68, 39, 66, 21, 28, 69, 47, 73,
21, 51, 35, 61, 67, 68, 55, 54, 77, 35, 74, 58, 63, 78, 71, 45,
65, 61, 29, 45, 24, 58, 45, 55, 64, 61, 51, 69, 68, 52, 74, 45,
50, 37, 45, 32, 45, 51, 37, 60, 28, 42, 28, 62, 67, 34, 45, 19,
41, 35, 65, 28, 74, 61, 44, 29, 65, 34, 64, 60, 52, 22, 69, 42,
72, 76, 28, 39, 56, 44, 26, 46, 22, 68, 45, 29, 34, 35, 51, 43,
44, 51, 47, 41, 37, 55, 57, 43, 55, 60, 39, 36, 67, 56, 38, 38,
48, 26, 44, 60, 47, 51, 30, 15, 21, 50, 19, 40, 54, 69, 46, 51,
31, 72, 52, 56, 62, 30, 77, 62, 69, 34, 39, 48, 43, 64, 59, 20,
62, 30, 76, 50, 70, 27, 51, 63, 75, 70, 37, 48, 39, 29, 17, 48,
53, 36, 42, 30, 45, 49, 45, 64.099999999999994, 68.200000000000003,
69.700000000000003, 63, 96.400000000000006, 72.5, 72.799999999999997,
58.799999999999997, 81.200000000000003, 70, 77.200000000000003,
97, 68.5, 65.5, 79.5, 87.900000000000006, 81.599999999999994,
85.5, 55.200000000000003, 81.400000000000006, 51.899999999999999,
77.299999999999997, 79, 67.5, 94.299999999999997, 74.5, 95.200000000000003,
100.40000000000001, 89.5, 81.799999999999997, 82, 83.5, 82.700000000000003,
68.799999999999997, 82.5, 84, 64.900000000000006, 85.299999999999997,
63, 48.799999999999997, 56.200000000000003, 68.5, 73.900000000000006,
70.299999999999997, 63.5, 65.599999999999994, 86, 63.200000000000003,
51.899999999999999, 72.5, 74.700000000000003, 63.100000000000001,
51.299999999999997, 61.700000000000003, 74, 70.700000000000003,
100.40000000000001, 99.299999999999997, 41, 108, 44.700000000000003,
64.299999999999997, 99.400000000000006, 90.099999999999994, 91.400000000000006,
57.200000000000003, 55.200000000000003, 66.700000000000003, 56.100000000000001,
99.700000000000003, 80.400000000000006, 47.600000000000001, 84.900000000000006,
80, 101.90000000000001, 36.899999999999999, 52.899999999999999,
58.399999999999999, 63.200000000000003, 102.2, 61.700000000000003,
97.599999999999994, 103.5, 91.700000000000003, 77.099999999999994,
55.899999999999999, 77, 69.700000000000003, 84, 63.600000000000001,
92.299999999999997, 80.799999999999997, 54.100000000000001, 88.599999999999994,
71.200000000000003, 55, 27.699999999999999, 80.700000000000003,
74.099999999999994, 61, 81.299999999999997, 72.099999999999994,
73.700000000000003, 74, 90.099999999999994, 72.200000000000003,
94, 60.600000000000001, 94.5, 70.200000000000003, 71.5, 82.200000000000003,
79.299999999999997, 53.799999999999997, 62.399999999999999, 102.09999999999999,
38.100000000000001, 58.200000000000003, 68.5, 75.200000000000003,
90.099999999999994, 77, 76.799999999999997, 86.599999999999994,
79.299999999999997, 67.599999999999994, 62.100000000000001, 69,
57, 80.799999999999997, 75.400000000000006, 102.59999999999999,
73.5, 82.700000000000003, 78.900000000000006, 60.899999999999999,
59.899999999999999, 85.200000000000003, 80.700000000000003, 44.100000000000001,
90.900000000000006, 86.799999999999997, 77.700000000000003, 89.299999999999997,
110.5, 90.400000000000006, 84.400000000000006, 83.099999999999994,
61.700000000000003, 67.5, 83.5, 53.899999999999999, 69.099999999999994,
50.799999999999997, 52, 79.099999999999994, 61.200000000000003,
79.700000000000003, 75.599999999999994, 71, 87, 64.299999999999997,
62, 83, 91.900000000000006, 66.700000000000003, 63.600000000000001,
63.100000000000001, 95.5, 100.5, 80.299999999999997, 58.799999999999997,
63.5, 84.5, 84, 64.200000000000003, 52.5, 74.400000000000006,
78.599999999999994, 50.200000000000003, 79.700000000000003, 69.299999999999997,
79.400000000000006, 68.200000000000003, 57.899999999999999, 68.599999999999994,
61.600000000000001, 67.400000000000006, 70.799999999999997, 69.799999999999997,
74.900000000000006, 91.700000000000003, 74.099999999999994, 71.700000000000003,
76, 61.200000000000003, 68.299999999999997, 67.099999999999994,
75, 70.799999999999997, 76.299999999999997, 66.299999999999997,
62.700000000000003, 68.099999999999994, 92.700000000000003, 59.299999999999997,
66.700000000000003, 90.400000000000006, 66.799999999999997, 54.600000000000001,
50.100000000000001, 92, 70, 80.900000000000006, 54.100000000000001,
98.5, 78.5, 72.599999999999994, 75.200000000000003, 65.299999999999997,
64.900000000000006, 60.299999999999997, 100.3, 72.299999999999997,
36.899999999999999, 68.400000000000006, 33.100000000000001, 79.099999999999994,
84, 63.700000000000003, 99, 76.599999999999994, 89.799999999999997,
65.900000000000006, 57.399999999999999, 75.799999999999997, 76.900000000000006,
71.200000000000003, 65.400000000000006, 45.399999999999999, 97.5,
73.599999999999994, 62.600000000000001, 79.299999999999997, 81.599999999999994,
74.299999999999997, 75.099999999999994, 95.400000000000006, 35.5,
70.599999999999994, 74.400000000000006, 93.299999999999997, 94.099999999999994,
117.59999999999999, 83.900000000000006, 76.700000000000003, 83,
57.299999999999997, 84.200000000000003, 70, 91.900000000000006,
90.099999999999994, 57.5, 85.099999999999994, 91.900000000000006,
81.700000000000003, 86.900000000000006, 79.299999999999997, 84.200000000000003,
71.299999999999997, 108.90000000000001, 81, 56.299999999999997,
74.900000000000006, 73, 57.5, 68, 65.200000000000003, 106.2,
55.100000000000001, 96.099999999999994, 68.299999999999997, 58,
77.5, 109.5, 74.400000000000006, 70.400000000000006, 120.2, 81.400000000000006,
65.5, 53.799999999999997, 52.299999999999997, 41, 77.900000000000006,
63.799999999999997, 62.200000000000003, 91, 82.5, 86.299999999999997,
63.899999999999999, 44.600000000000001, 75.099999999999994, 69,
74.299999999999997, 77.099999999999994, 57.899999999999999, 96.299999999999997,
80.200000000000003, 74.099999999999994, 44.200000000000003, 78.5,
82, 63.100000000000001, 98.099999999999994, 80.299999999999997,
83.700000000000003, 69.799999999999997, 72, 53.5, 80, 77.299999999999997,
48.700000000000003, 64.200000000000003, 92.099999999999994, 78.099999999999994,
84.700000000000003, 81.799999999999997, 83.400000000000006, 92.900000000000006,
40.899999999999999, 37.600000000000001, 77.700000000000003, 33.399999999999999,
65.900000000000006, 62.5, 75.099999999999994, 63.100000000000001,
46.600000000000001, 61.600000000000001, 83.700000000000003, 50.399999999999999,
80.299999999999997, 54.399999999999999, 68.799999999999997, 73.099999999999994,
75.299999999999997, 90, 78.400000000000006, 58, 64.299999999999997,
66.200000000000003, 79.299999999999997, 71.200000000000003, 96.700000000000003,
88.5, 97.5, 83, 105.59999999999999, 54.299999999999997, 99.700000000000003,
71.299999999999997, 78.5, 75.299999999999997, 106.3, 25.899999999999999,
97.799999999999997, 77.700000000000003, 78.099999999999994, 69.200000000000003,
64.599999999999994, 89.299999999999997, 84.400000000000006, 104.59999999999999,
67.099999999999994, 57.600000000000001, 133.30000000000001, 58.700000000000003,
65.900000000000006, 59.100000000000001, 38.600000000000001, 93,
38, 63.700000000000003, 71.299999999999997, 61.5, 78.299999999999997,
88.5, 73.200000000000003, 64, 77.700000000000003, 65.799999999999997,
104, 65.900000000000006, 48.399999999999999, 64.599999999999994,
60.299999999999997, 83.799999999999997, 89.5, 90.900000000000006,
44.399999999999999, 60.5, 110.09999999999999, 56.600000000000001,
49, 62.899999999999999, 51.100000000000001, 70, 73.700000000000003,
87.099999999999994, 97.099999999999994, 91.599999999999994, 68.599999999999994,
77.400000000000006, 83.299999999999997, 106, 80, 77.299999999999997,
78, 77.900000000000006, 64.400000000000006, 95.299999999999997,
70.200000000000003, 103, 77, 56.200000000000003, 54.399999999999999,
60.5, 47, 78.799999999999997, 75, 82.599999999999994, 97.900000000000006,
84.400000000000006, 65.299999999999997, 70.299999999999997, 76.799999999999997,
66, 83, 73.400000000000006, 73.299999999999997, 55.700000000000003,
95.400000000000006, 79.799999999999997, 80.400000000000006, 60.799999999999997,
66.799999999999997, 76.599999999999994, 74, 77.400000000000006,
94.400000000000006, 44.200000000000003, 64.299999999999997, 92.400000000000006,
29.600000000000001, 102.40000000000001, 82, 55.200000000000003,
47.100000000000001, 89.400000000000006, 68.299999999999997, 38,
78.799999999999997, 55.100000000000001, 72.099999999999994, 75.900000000000006,
96.900000000000006, 86.099999999999994, 73.5, 80, 82.400000000000006,
75.299999999999997, 86.299999999999997, 88.200000000000003, 106.90000000000001,
69.5, 48.100000000000001, 69.5, 95.299999999999997, 91.400000000000006,
84.5, 73.200000000000003, 51, 87.700000000000003, 77.200000000000003,
66.900000000000006, 85.400000000000006, 86.599999999999994, 75.799999999999997,
70.599999999999994, 78, 59.200000000000003, 73.900000000000006,
74.700000000000003, 106, 86.799999999999997, 67.599999999999994,
82.099999999999994, 47.100000000000001, 79.900000000000006, 88.799999999999997,
70.700000000000003, 49.200000000000003, 52.299999999999997, 50.200000000000003,
80, 77.299999999999997, 57.100000000000001, 61.799999999999997,
61.200000000000003, 49.399999999999999, 74, 62.200000000000003,
49.5, 42.200000000000003, 53.399999999999999, 44.700000000000003,
55.200000000000003, 37.5, 34.299999999999997, 44, 53.399999999999999,
84.5, 60.399999999999999, 73, 69.799999999999997, 39, 57.700000000000003,
47.700000000000003, 85.200000000000003, 80.599999999999994, 42.399999999999999,
74.200000000000003, 89.200000000000003, 54.5, 51.100000000000001,
73, 47.899999999999999, 58.100000000000001, 39, 63.899999999999999,
49.100000000000001, 38.5, 83.900000000000006, 74.599999999999994,
45.600000000000001, 63.899999999999999, 78, 87.799999999999997,
78.5, 63.5, 66, 80.799999999999997, 93.299999999999997, 75.900000000000006,
40.299999999999997, 66.200000000000003, 51.100000000000001, 57.5,
55.299999999999997, 66, 81.299999999999997, 52.299999999999997,
99.299999999999997, 55.100000000000001, 51.200000000000003, 62.5,
98.200000000000003, 59.100000000000001, 29, 82.400000000000006,
107.2, 49.799999999999997, 51.799999999999997, 50.899999999999999,
58, 70.900000000000006, 77.200000000000003, 87.5, 64.400000000000006,
73.299999999999997, 64.799999999999997, 90.099999999999994, 74.700000000000003,
67.799999999999997, 33.799999999999997, 93.599999999999994, 39.200000000000003,
69.099999999999994, 73.299999999999997, 68.700000000000003, 76.200000000000003,
55, 50.200000000000003, 75.700000000000003, 44.899999999999999,
121.8, 67.900000000000006, 96.299999999999997, 57.799999999999997,
52.700000000000003, 42.200000000000003, 63.899999999999999, 81.400000000000006,
81.5, 77.099999999999994, 63.399999999999999, 51.399999999999999,
29.899999999999999, 59.5, 48.700000000000003, 74.299999999999997,
60.399999999999999, 68.200000000000003, 75.799999999999997, 72.299999999999997,
53.100000000000001, 18.699999999999999, 57.5, 54.600000000000001,
32.700000000000003, 48.200000000000003, 45.100000000000001, 73.099999999999994,
49.799999999999997, 41.200000000000003, 20.899999999999999, 65.599999999999994,
33.799999999999997, 33.899999999999999, 58, 68.5, 46.5, 42.399999999999999,
47.5, 51, 61.299999999999997, 66.799999999999997, 60.5, 78.5,
61.5, 36.700000000000003, 131.19999999999999, 74.799999999999997,
53.200000000000003, 79.099999999999994, 64.200000000000003, 55.399999999999999,
19.600000000000001, 81.900000000000006, 67.400000000000006, 32.799999999999997,
76.200000000000003, 80.799999999999997, 63, 59.600000000000001,
69.200000000000003, 45.899999999999999, 70.900000000000006, 56,
45.299999999999997, 67.099999999999994, 61, 52.600000000000001,
48.799999999999997, 88.599999999999994, 71.799999999999997, 41,
77.400000000000006, 48.799999999999997, 51.200000000000003, 56.5,
83.599999999999994, 90.700000000000003, 80.799999999999997, 37,
40.399999999999999, 102.59999999999999, 60.299999999999997, 62,
64.700000000000003, 36.600000000000001, 49.5, 39.899999999999999,
84, 75.200000000000003, 74.099999999999994, 47.799999999999997,
68.599999999999994, 24.699999999999999, 80.799999999999997, 57.5,
52.799999999999997, 59.100000000000001, 56.100000000000001, 85.200000000000003,
36.899999999999999, 63.399999999999999, 73.700000000000003, 69.900000000000006,
54.600000000000001, 74.400000000000006, 63.100000000000001, 103.2,
45.100000000000001, 90.400000000000006, 63.5, 65.900000000000006,
63.5, 64.5, 68.099999999999994, 45.5, 42.799999999999997, 73.700000000000003,
76.099999999999994, 76.200000000000003, 75.900000000000006, 39.600000000000001,
87.299999999999997, 71, 86.5, 48.700000000000003, 117.09999999999999,
45.600000000000001, 64.700000000000003, 70, 71.200000000000003,
42.899999999999999, 71.200000000000003, 62.100000000000001, 48.899999999999999,
35.200000000000003, 76.700000000000003, 95.900000000000006, 104.40000000000001,
33, 32.700000000000003, 87.700000000000003, 68.900000000000006,
60.200000000000003, 48.799999999999997, 79, 73.700000000000003,
87.400000000000006, 79.900000000000006, 90.599999999999994, 68,
55.100000000000001, 92.299999999999997, 92.799999999999997, 71.5,
51.200000000000003, 38.899999999999999, 80.599999999999994, 76,
80.900000000000006, 63.799999999999997, 79, 67.900000000000006,
28.300000000000001, 65.099999999999994, 103.5, 81.299999999999997,
27.5, 83.099999999999994, 48.299999999999997, 63.399999999999999,
69.599999999999994, 62.100000000000001, 62.5, 44.799999999999997,
78.599999999999994, 40, 71.799999999999997, 63.600000000000001,
22.800000000000001, 78.5, 59.5, 52.299999999999997, 52.799999999999997,
59.100000000000001, 61.299999999999997, 67.799999999999997, 76.200000000000003,
55.799999999999997, 42.700000000000003, 65.5, 26.73, 32.149999999999999,
36.520000000000003, 46.490000000000002, 63.240000000000002, 55.689999999999998,
45.75, 35.340000000000003, 53.380000000000003, 70.290000000000006,
30.050000000000001, 38.109999999999999, 16.210000000000001, 48.259999999999998,
27.100000000000001, 18.559999999999999, 68.280000000000001, 74.579999999999998,
59.159999999999997, 34.090000000000003, 37.829999999999998, 78.469999999999999,
29.859999999999999, 31.199999999999999, 38.439999999999998, 75.200000000000003,
71.810000000000002, 37.369999999999997, 27.210000000000001, 24.870000000000001,
28.120000000000001, 56.369999999999997, 22.73, 62.770000000000003,
45.359999999999999, 42.600000000000001, 74.819999999999993, 48.850000000000001,
25.140000000000001, 39.490000000000002, 46.75, 44.939999999999998,
32.200000000000003, 31.780000000000001, 64.430000000000007, 52.560000000000002,
47.520000000000003, 33.409999999999997, 61.710000000000001, 79.450000000000003,
27.789999999999999, 90.200000000000003, 87.140000000000001, 28.789999999999999,
78.129999999999995, 49.579999999999998, 43.140000000000001, 77.829999999999998,
57.909999999999997, 36.289999999999999, 54.689999999999998, 61.289999999999999,
37.450000000000003, 14.960000000000001, 44, 43.229999999999997,
52.810000000000002, 32.770000000000003, 64.189999999999998, 23.890000000000001,
68.469999999999999, 46.920000000000002, 52.289999999999999, 48.229999999999997,
66.280000000000001, 74.819999999999993, 59.5, 56.450000000000003,
41.479999999999997, 44.710000000000001, 67.219999999999999, 67.579999999999998,
62.140000000000001, 74.989999999999995, 20.850000000000001, 43.259999999999998,
73.819999999999993, 28.010000000000002, 71.569999999999993, 28.829999999999998,
50.539999999999999, 69.159999999999997, 38.189999999999998, 81.019999999999996,
76.799999999999997, 76.269999999999996, 38.200000000000003, 86.700000000000003,
35, 35.479999999999997, 40.560000000000002, 31.940000000000001,
45.380000000000003, 21.629999999999999, 69.709999999999994, 46.899999999999999,
49.229999999999997, 31.219999999999999, 28.43, 50.130000000000003,
34.990000000000002, 42.810000000000002, 21.91, 55.880000000000003,
57.090000000000003, 75.329999999999998, 19.609999999999999, 52.079999999999998,
75.900000000000006, 36.700000000000003, 44.530000000000001, 41.240000000000002,
42.990000000000002, 85.519999999999996, 27.199999999999999, 51.189999999999998,
93.530000000000001, 31.09, 74.959999999999994, 58.530000000000001,
32.759999999999998, 25.07, 20.329999999999998, 28.579999999999998,
15.34, 30.949999999999999, 31.460000000000001, 46.350000000000001,
77.280000000000001, 44.539999999999999, 60.479999999999997, 62.189999999999998,
55.409999999999997, 29.329999999999998, 58.780000000000001, 44.439999999999998,
58.340000000000003, 35.740000000000002, 70.189999999999998, 69.480000000000004,
71.689999999999998, 32.049999999999997, 17.109999999999999, 29.920000000000002,
48.079999999999998, 51.880000000000003, 71.670000000000002, 47.170000000000002,
58.210000000000001, 22.68, 31.079999999999998, 78.260000000000005,
20.190000000000001, 46.960000000000001, 43.700000000000003, 51.990000000000002,
25.82, 29.920000000000002, 25, 78.900000000000006, 50.560000000000002,
32.450000000000003, 59.130000000000003, 33.130000000000003, 23.469999999999999,
40.25, 54.039999999999999, 75.120000000000005, 57.359999999999999,
78.680000000000007, 58.710000000000001, 40.759999999999998, 63.229999999999997,
61.700000000000003, 24.09, 67.5, 65.430000000000007, 79.629999999999995,
41.890000000000001, 54.810000000000002, 80.319999999999993, 73.230000000000004,
56.93, 70.180000000000007, 47.390000000000001, 73.019999999999996,
107.47, 57.380000000000003, 69.069999999999993, 51.890000000000001,
71.459999999999994, 21.609999999999999, 75.040000000000006, 23.82,
67.799999999999997, 80.200000000000003, 32.200000000000003, 28.52,
60.700000000000003, 69.650000000000006, 44.869999999999997, 81.810000000000002,
44.270000000000003, 60.990000000000002, 61.68, 93.730000000000004,
31.960000000000001, 57.229999999999997, 29.41, 86.439999999999998,
36.979999999999997, 90.439999999999998, 61.82, 37.640000000000001,
33.710000000000001, 76.799999999999997, 86.780000000000001, 65.390000000000001,
33.600000000000001, 30.68, 67.459999999999994, 54.909999999999997,
47.170000000000002, 37.789999999999999, 72.530000000000001, 32.609999999999999,
42.520000000000003, 42.75, 68.840000000000003, 48.93, 60.609999999999999,
23.890000000000001, 81.340000000000003, 12.109999999999999, 58.82,
71.430000000000007, 50.670000000000002, 62.57, 59.799999999999997,
69.469999999999999, 48.829999999999998, 63.520000000000003, 14.99,
34.409999999999997, 45.140000000000001, 23.440000000000001, 38.270000000000003,
53.369999999999997, 36.979999999999997, 65.799999999999997, 39.93,
79.739999999999995, 85.170000000000002, 62.509999999999998, 61.020000000000003,
48.469999999999999, 48.469999999999999, 34.969999999999999, 61.780000000000001,
71.579999999999998, 36.009999999999998, 51.719999999999999, 66.930000000000007,
77.189999999999998, 40.82, 69.040000000000006, 64.859999999999999,
26.77, 71.950000000000003, 62, 84.719999999999999, 46.960000000000001,
64.219999999999999, 84.120000000000005, 85.109999999999999, 67.489999999999995,
68.810000000000002, 80.519999999999996, 31.140000000000001, 64.269999999999996,
24.719999999999999, 62.259999999999998, 61.079999999999998, 47.240000000000002,
42.270000000000003, 19.739999999999998, 71.010000000000005, 36.310000000000002,
77.650000000000006, 63.82, 31.309999999999999, 44.920000000000002,
69.560000000000002, 56.409999999999997, 85.260000000000005, 74.799999999999997,
95.819999999999993, 36.090000000000003, 77.609999999999999, 29.260000000000002,
53.170000000000002, 53.960000000000001, 26.379999999999999, 63.43,
42.409999999999997, 53.719999999999999, 78.25, 27.739999999999998,
81.950000000000003, 59.450000000000003, 73.579999999999998, 40.409999999999997,
45.170000000000002, 91.040000000000006, 57.740000000000002, 57.640000000000001,
91.079999999999998, 41.159999999999997, 36.590000000000003, 68.069999999999993,
44.850000000000001, 72.620000000000005, 54.600000000000001, 62.380000000000003,
38.039999999999999, 21.609999999999999, 38.189999999999998, 75.859999999999999,
44.079999999999998, 49.189999999999998, 32.859999999999999, 97.230000000000004,
44.979999999999997, 13.43, 46.229999999999997, 30.370000000000001,
29.100000000000001, 41.729999999999997, 26.68, 49.270000000000003,
45.990000000000002, 52.079999999999998, 35.57, 42.259999999999998,
73.560000000000002, 33.5, 55.960000000000001, 31.420000000000002,
26.190000000000001, 81.810000000000002, 44.549999999999997, 93.870000000000005,
19.370000000000001, 68.549999999999997, 45.450000000000003, 68.879999999999995,
32.969999999999999, 42.869999999999997, 78.349999999999994, 75.349999999999994,
51.710000000000001, 38.219999999999999, 69.180000000000007, 46.659999999999997,
73, 65.109999999999999, 57.439999999999998, 32.340000000000003,
73.799999999999997, 68.170000000000002, 72.560000000000002, 71.430000000000007,
53, 66.900000000000006, 45.689999999999998, 62.560000000000002,
64.879999999999995, 46.189999999999998, 74.739999999999995, 114.56999999999999,
76.730000000000004, 46.75, 69.120000000000005, 68.230000000000004,
80.689999999999998, 68.459999999999994, 109.54000000000001, 58.630000000000003,
60.240000000000002, 78.709999999999994, 72.430000000000007, 92.849999999999994,
65.879999999999995, 41.479999999999997, 22.379999999999999, 51.259999999999998,
87.900000000000006, 72, 44.289999999999999, 79.109999999999999,
65.319999999999993, 76.939999999999998, 57.939999999999998, 74.209999999999994,
51.090000000000003, 42.969999999999999, 57.799999999999997, 72.819999999999993,
38.490000000000002, 63.899999999999999, 54.380000000000003, 81.819999999999993,
44.520000000000003, 58.689999999999998, 61.450000000000003, 80.120000000000005,
65.230000000000004, 57.039999999999999, 70.349999999999994, 114.13,
54.020000000000003, 56.530000000000001, 57.880000000000003, 89.290000000000006,
43.479999999999997, 41.740000000000002, 32.020000000000003, 33.990000000000002,
73.780000000000001, 70.469999999999999, 45.770000000000003, 28.949999999999999,
47.289999999999999, 34.950000000000003, 35.549999999999997, 30.199999999999999,
28.34, 69.170000000000002, 49.640000000000001, 32.649999999999999,
69.5, 81.060000000000002, 28.059999999999999, 49.990000000000002,
30.780000000000001, 19.440000000000001, 48.740000000000002, 66.129999999999995,
35.759999999999998, 70.799999999999997, 58.840000000000003, 78.379999999999995,
56.149999999999999, 76.709999999999994, 42.719999999999999, 44.280000000000001,
74.780000000000001, 46.119999999999997, 25.600000000000001, 33.670000000000002,
75.840000000000003, 62.829999999999998, 61.560000000000002, 90.140000000000001,
55.420000000000002, 33.979999999999997, 67.079999999999998, 85.879999999999995,
59.979999999999997, 68.549999999999997, 35.619999999999997, 47.590000000000003,
36.310000000000002, 88.730000000000004, 48.5, 92.329999999999998,
51.090000000000003, 42.460000000000001, 27.100000000000001, 30.91,
28.289999999999999, 33, 51.869999999999997, 19.68, 95.519999999999996,
65.329999999999998, 94.579999999999998, 79, 25.620000000000001,
70.079999999999998, 67.540000000000006, 76.480000000000004, 23.949999999999999,
73.140000000000001, 100.88, 77.790000000000006, 86.969999999999999,
74.75, 77.379999999999995, 63.310000000000002, 82.299999999999997,
82.549999999999997, 104.84999999999999, 93.790000000000006, 68.849999999999994,
45.090000000000003, 89.200000000000003, 52.109999999999999, 59.240000000000002,
65.689999999999998, 46.240000000000002, 22.370000000000001, 51.859999999999999,
36.840000000000003, 54.039999999999999, 59.200000000000003, 49.57,
54.420000000000002, 74.150000000000006, 37.719999999999999, 77.120000000000005,
23.579999999999998, 66.670000000000002, 87.709999999999994, 31.84,
54.140000000000001, 44.539999999999999, 65.150000000000006, 79.900000000000006,
34.399999999999999, 51.219999999999999, 86.459999999999994, 60.520000000000003,
56.840000000000003, 79.980000000000004, 46.68, 100.59, 61.579999999999998,
70.310000000000002, 35.990000000000002, 65.780000000000001, 71.400000000000006,
71.200000000000003, 33.630000000000003, 73.819999999999993, 76.609999999999999,
34.149999999999999, 17.780000000000001, 31.789999999999999, 59.009999999999998,
82.5, 38.359999999999999, 55.68, 68.849999999999994, 56.649999999999999,
36.159999999999997, 45.460000000000001, 59.899999999999999, 19.949999999999999,
46.020000000000003, 52.450000000000003, 60.280000000000001, 43.789999999999999,
45.770000000000003, 62.359999999999999, 26.809999999999999, 48.359999999999999,
97.879999999999995, 67.709999999999994, 75.790000000000006, 17.170000000000002,
62.780000000000001, 56.609999999999999, 37.409999999999997, 56.869999999999997,
73.959999999999994, 56.619999999999997, 33.530000000000001, 70.75,
47.200000000000003, 41.789999999999999, 60.969999999999999, 48.270000000000003,
22.690000000000001, 53.789999999999999, 17.920000000000002, 13.550000000000001,
68.849999999999994, 22.489999999999998, 25.539999999999999, 16.489999999999998,
79.299999999999997, 69.939999999999998, 62.399999999999999, 11.199999999999999,
18.170000000000002, 48.609999999999999, 90.829999999999998, 53.920000000000002,
28.420000000000002, 84.950000000000003, 21.07, 21.039999999999999,
75.200000000000003, 36.990000000000002, 23.949999999999999, 70.319999999999993,
21.219999999999999, 29.550000000000001, 74.549999999999997, 30.079999999999998,
50.630000000000003, 72.790000000000006, 35.229999999999997, 18.190000000000001,
23.93, 22.579999999999998, 37.780000000000001, 59.340000000000003,
21.140000000000001, 32.369999999999997, 34.899999999999999, 68.810000000000002,
89.359999999999999, 79.340000000000003, 54.850000000000001, 30.129999999999999,
16.91, 28.420000000000002, 47.289999999999999, 55.240000000000002,
60.82, 29.710000000000001, 81.870000000000005, 34.600000000000001,
47.350000000000001, 19.140000000000001, 51.539999999999999, 53.399999999999999,
39.5, 73.799999999999997, 25.809999999999999, 75.939999999999998,
49.409999999999997, 46.450000000000003, 57.079999999999998, 40.159999999999997,
52.009999999999998, 52.149999999999999, 68.150000000000006, 54.640000000000001,
33.020000000000003, 28.09, 133.84, 53.689999999999998, 61.880000000000003,
88.060000000000002, 73.379999999999995, 60.149999999999999, 56.939999999999998,
14.27, 70.810000000000002, 34.460000000000001, 48.590000000000003,
40.159999999999997, 43.630000000000003, 66.159999999999997, 53.299999999999997,
30.559999999999999, 19.899999999999999, 36.759999999999998, 53.25,
34.020000000000003, 62.479999999999997, 73.239999999999995, 58.229999999999997,
29.52, 78.260000000000005, 84.379999999999995, 81.280000000000001,
50.649999999999999, 72.599999999999994, 48.57, 88.090000000000003,
40.939999999999998, 40.130000000000003, 18.25, 68.099999999999994,
71.079999999999998, 27.75, 21.539999999999999, 48.530000000000001,
73.489999999999995, 67.989999999999995, 23.530000000000001, 67.790000000000006,
55.759999999999998, 51.729999999999997, 46, 47, 71, 74, 52, 53,
58, 53, 44, 59, 54, 51, 75, 24, 41, 34, 62, 50, 58, 61, 39, 56,
68, 68, 52, 74, 56, 29, 76, 80, 65, 47, 40, 38, 30, 49, 49, 78,
50, 30, 78, 51, 74, 70, 75, 62, 61, 62, 65, 49, 36, 69, 58, 62,
66, 47, 63, 55, 57, 72, 74, 76, 49, 45, 69, 76, 36, 69, 40, 32,
57, 63, 74, 36, 68, 63, 66, 39, 57, 64, 75, 63, 61, 69, 40, 63,
64, 29, 29, 64, 59, 50, 47, 52, 26, 39, 77, 53, 49, 49, 70, 44,
72, 34, 43, 41, 34, 73, 42, 68, 15, 59, 64, 45, 39, 59, 71, 78,
53, 65, 71, 57, 77, 20, 27, 71, 39, 25, 64, 56, 67, 57, 71, 68,
18, 76, 77, 21, 41, 66, 29, 59, 75, 24, 79, 51, 76, 58, 55, 69,
99, 63, 70, 66, 73, 65, 55, 28, 57, 61, 35, 43, 35, 71, 49, 12,
38, 66, 65, 46, 45, 23, 33, 64, 34, 75, 33, 74, 39, 33, 77, 73,
58, 63, 68, 66, 73, 15, 44, 78, 53, 38, 51, 49, 70, 66, 71, 78,
77, 55, 22, 61, 41, 24, 27, 47, 74, 28, 62, 45, 29, 48, 58, 81,
63, 53, 35, 29, 93, 55, 35, 36, 63, 42, 58, 30, 35, 45, 40, 45,
21, 63, 40, 60, 64, 21, 45, 46, 12, 44, 30, 104, 64, 26, 34,
18, 48, 49, 74, 43, 112, 41, 30, 15, 36, 26, 30, 26, 34, 70,
33, 30, 22, 24, 51, 71, 54, 32, 28, 58, 49, 72, 30, 21, 27, 67,
54, 64, 31, 69, 30, 29, 33, 28, 77, 27, 36, 42, 21, 49, 64, 86,
75, 56, 45, 38, 83, 60, 36, 70, 65, 79, 47, 35, 62, 21, 34, 29,
65, 51, 51, 58, 22, 75, 53, 38, 38, 44, 33, 27, 49, 45, 30, 69,
52, 16, 41, 68, 33, 46, 39, 28, 65, 41, 38, 71, 66, 48, 23, 60,
64, 22, 36, 36, 28, 96, 49, 73, 57, 51, 48, 51, 40, 43, 49, 61,
49, 54, 95, 66, 85, 32, 43, 60, 57, 36, 41, 38, 59, 83, 33, 92,
68, 63, 39, 64, 19, 47, 41, 77, 61, 31, 57, 36, 48, 35, 68, 18,
54, 77, 65, 50, 55, 60, 45, 78, 32, 65, 30, 60, 32, 37, 38, 36,
38, 66, 61, 63, 44, 59, 58, 36, 59, 81, 78, 75, 69, 75, 76, 51,
44, 25, 33, 79, 50, 66, 31, 56, 54, 63, 45, 68, 49, 20, 74, 44,
48, 38, 41, 59, 40, 58, 68, 40, 58, 34, 87, 53, 50, 65, 28, 42,
56, 64, 70, 42, 52, 60.899999999999999, 66.200000000000003, 36.5,
21.399999999999999, 55.799999999999997, 42.700000000000003, 57.399999999999999,
65, 28.199999999999999, 22, 45, 45.5, 43.799999999999997, 19.699999999999999,
28, 50.100000000000001, 30.600000000000001, 53.700000000000003,
30.399999999999999, 43.100000000000001, 49.100000000000001, 43,
37.700000000000003, 27.600000000000001, 56.5, 68.099999999999994,
44.5, 20.199999999999999, 26.600000000000001, 48.299999999999997,
33.700000000000003, 63.799999999999997, 28.600000000000001, 54.700000000000003,
44.399999999999999, 42.799999999999997, 48.700000000000003, 40.399999999999999,
65.799999999999997, 40.799999999999997, 46.399999999999999, 45.399999999999999,
80.700000000000003, 54.200000000000003, 42.899999999999999, 38.5,
40, 34.399999999999999, 74.400000000000006, 36.299999999999997,
25.899999999999999, 49.200000000000003, 26.800000000000001, 40.799999999999997,
33.799999999999997, 17.199999999999999, 57.799999999999997, 22.300000000000001,
37, 32.799999999999997, 60.100000000000001, 50, 36.899999999999999,
65.599999999999994, 67.799999999999997, 25.899999999999999, 32.600000000000001,
21.100000000000001, 28.899999999999999, 43.5, 64.599999999999994,
74.099999999999994, 64, 21.300000000000001, 55.299999999999997,
19, 34, 97, 26, 51, 37, 51, 44, 20, 63, 69, 22, 61, 35, 47, 36,
78, 55, 24, 48, 61, 28, 31, 67, 42, 18, 79, 37, 32, 31, 22, 18,
38, 37, 35, 72, 32, 56, 59, 38, 31, 71, 58, 39, 23, 54, 24, 29,
80, 76, 49, 58, 61, 54, 35, 34, 37, 34, 24, 53, 52, 39, 53, 62,
36, 50, 63, 32, 22, 46, 50, 67, 35, 43, 34, 31, 48, 37, 41, 51,
50, 52, 30, 62, 45, 40, 28, 27, 46, 38, 30, 45, 27, 43, 18, 53,
54, 50, 29, 30, 32, 33, 14, 28, 18, 37, 39, 39, 75.299999999999997,
47.310000000000002, 61.200000000000003, 48.899999999999999, 68.400000000000006,
46, 96.099999999999994, 68.200000000000003, 60.700000000000003,
63.600000000000001, 31.899999999999999, 44.600000000000001, 70.599999999999994,
47.200000000000003, 78, 24.800000000000001, 50.100000000000001,
73.200000000000003, 63.100000000000001, 44, 63.200000000000003,
60.07, 30, 73.969999999999999, 18, 16.949999999999999, 66.099999999999994,
31, 69.299999999999997, 47.670000000000002, 79.099999999999994,
77, 56.909999999999997, 83, 67.400000000000006, 31.289999999999999,
33.799999999999997, 63.049999999999997, 56.799999999999997, 40,
30.399999999999999, 62.640000000000001, 57.5, 69, 57.600000000000001,
47.200000000000003, 64.700000000000003, 49.899999999999999, 62.399999999999999,
35.899999999999999, 40.600000000000001, 56.5, 24.100000000000001,
41.5, 42.399999999999999, 58.159999999999997, 47.409999999999997,
34.899999999999999, 55.700000000000003, 24.010000000000002, 41.799999999999997,
52.100000000000001, 45.850000000000001, 63.200000000000003, 73.400000000000006,
62.200000000000003, 84.700000000000003, 65.900000000000006, 64.299999999999997,
58.299999999999997, 44, 59.299999999999997, 79.400000000000006,
52.200000000000003, 69, 39.799999999999997, 73, 54.100000000000001,
67.200000000000003, 46.799999999999997, 60.799999999999997, 54.5,
50.700000000000003, 40.600000000000001, 71.409999999999997, 44.200000000000003,
60.200000000000003, 36.520000000000003, 59.5, 53.700000000000003,
64.400000000000006, 61.530000000000001, 34.590000000000003, 45.030000000000001,
54.5, 68.790000000000006, 81.799999999999997, 60.979999999999997,
73.280000000000001, 36, 37.299999999999997, 45.399999999999999,
54.700000000000003, 74.099999999999994, 64.700000000000003, 76.799999999999997,
68.299999999999997, 29.399999999999999, 45.799999999999997, 41.399999999999999,
69, 71, 44.899999999999999, 22.73, 74.900000000000006, 29.899999999999999,
88.5, 57, 58, 27.699999999999999, 61.350000000000001, 56, 75.900000000000006,
48.799999999999997, 61.5, 63.82, 43.600000000000001, 32, 72.299999999999997,
59.799999999999997, 45, 90.799999999999997, 43.960000000000001,
63.299999999999997, 65.400000000000006, 79.379999999999995, 39.100000000000001,
22.5, 51.200000000000003, 55.210000000000001, 16.5, 49.899999999999999,
46.700000000000003, 62.560000000000002, 41.259999999999998, 80.709999999999994,
54.469999999999999, 29.600000000000001, 55.799999999999997, 47.32,
65.299999999999997, 78.25, 32.100000000000001, 68.599999999999994,
55.299999999999997, 42.100000000000001, 45.700000000000003, 30,
40.740000000000002, 82.299999999999997, 54, 74, 62, 50, 77.5,
55, 69.400000000000006, 54.890000000000001, 65.099999999999994,
34.100000000000001, 38, 46.200000000000003, 77.560000000000002,
61.899999999999999, 66.099999999999994, 59, 51.299999999999997,
39.5, 66.700000000000003, 76.590000000000003, 75, 28.960000000000001,
48.100000000000001, 29.699999999999999, 72, 60.5, 61.100000000000001,
33.539999999999999, 53.399999999999999, 43, 80.799999999999997,
50.689999999999998, 56.700000000000003, 79, 54.600000000000001,
71.599999999999994, 51.899999999999999, 75.400000000000006, 59.060000000000002,
94.299999999999997, 35.799999999999997, 49.899999999999999, 58.060000000000002,
69.5, 100, 31.399999999999999, 58.43, 57, 31.800000000000001,
71.799999999999997, 72.280000000000001, 72.200000000000003, 53,
72.5, 84.5, 35, 76.299999999999997, 94.379999999999995, 61.600000000000001,
84.620000000000005, 46, 69.700000000000003, 69, 73, 63.200000000000003,
43.689999999999998, 43.899999999999999, 86.400000000000006, 37,
85.609999999999999, 73, 32, 57.100000000000001, 28.800000000000001,
50, 44, 25.920000000000002, 58.799999999999997, 65, 66.5, 69.920000000000002,
58, 72.200000000000003, 82.799999999999997, 36.799999999999997,
58.700000000000003, 52.899999999999999, 44.100000000000001, 39.5,
54, 56.890000000000001, 75.700000000000003, 31.629999999999999,
92.879999999999995, 42.399999999999999, 48.899999999999999, 60,
31.210000000000001, 55.600000000000001, 66.299999999999997, 55.299999999999997,
50.090000000000003, 55.93, 37.100000000000001, 39, 38.600000000000001,
75.299999999999997, 23.100000000000001, 62, 30.100000000000001,
50.899999999999999, 55, 28.800000000000001, 74.700000000000003,
35.399999999999999, 35.100000000000001, 78.299999999999997, 64,
67.900000000000006, 46.399999999999999, 62, 100.81, 40.5, 51.700000000000003,
64.599999999999994, 44.829999999999998, 65, 69.299999999999997,
54.600000000000001, 76.5, 40.799999999999997, 66.5, 71.700000000000003,
84.700000000000003, 67, 86.299999999999997, 40.700000000000003,
54.899999999999999, 20.120000000000001, 69.599999999999994, 30,
52.899999999999999, 53.890000000000001, 73.189999999999998, 68.099999999999994,
34.920000000000002, 53.590000000000003, 28.899999999999999, 46.100000000000001,
53, 43.899999999999999, 92.760000000000005, 28.5, 28.84, 55.899999999999999,
57, 56, 65.299999999999997, 66.180000000000007, 70.5, 51.969999999999999,
24.899999999999999, 57.189999999999998, 43.200000000000003, 99,
48.799999999999997, 90.469999999999999, 68.290000000000006, 93,
83.900000000000006, 72.5, 61.149999999999999, 45.299999999999997,
47, 71.5, 35.909999999999997, 34, 25.5, 82.239999999999995, 19.98,
36.380000000000003, 74.659999999999997, 50.100000000000001, 33.5,
67, 50.5, 77.200000000000003, 76.299999999999997, 73, 53, 54.299999999999997,
32), mmrc0_4 = c(1L, 3L, 1L, 2L, 2L, 2L, 3L, 2L, 2L, 2L, 3L,
2L, 3L, 3L, 2L, 2L, 2L, 2L, 3L, 2L, 2L, 3L, 3L, 2L, 1L, 2L, 2L,
2L, 2L, 2L, 2L, 3L, 3L, 3L, 2L, 1L, 2L, 3L, 2L, 1L, 2L, 1L, 1L,
2L, 1L, 2L, 1L, 1L, 2L, 2L, 2L, 3L, 2L, 2L, 4L, 1L, 0L, 0L, 0L,
1L, 0L, 1L, 4L, 1L, 0L, 0L, 2L, 1L, 4L, 0L, 0L, 1L, 1L, 0L, 0L,
0L, 1L, 1L, 0L, 2L, 4L, 1L, 1L, 1L, 4L, 0L, 1L, 1L, 4L, 0L, 4L,
0L, 0L, 1L, 0L, 2L, 0L, 0L, 1L, 0L, 0L, 1L, 2L, 1L, 2L, 0L, 0L,
1L, 0L, 0L, 1L, 1L, 1L, 1L, 0L, 1L, 2L, 4L, 2L, 0L, 2L, 1L, 4L,
0L, 1L, 0L, 1L, 1L, 1L, 0L, 1L, 1L, 1L, 1L, 0L, 0L, 1L, 0L, 0L,
0L, 4L, 1L, 1L, 0L, 0L, 0L, 4L, 1L, 0L, 1L, 0L, 4L, 0L, 1L, 0L,
0L, 0L, 0L, 1L, 1L, 1L, 0L, 1L, 0L, 0L, 1L, 0L, 4L, 1L, 1L, 1L,
4L, 4L, 4L, 0L, 0L, 1L, 1L, 4L, 0L, 0L, 1L, 0L, 0L, 1L, 0L, 0L,
2L, 1L, 1L, 2L, 1L, 4L, 0L, 0L, 4L, 2L, 0L, 4L, 1L, 0L, 1L, 4L,
1L, 1L, 0L, 0L, 4L, 1L, 1L, 1L, 4L, 0L, 0L, 2L, 1L, 0L, 0L, 0L,
1L, 1L, 4L, 1L, 2L, 1L, 1L, 4L, 0L, 0L, 2L, 1L, 4L, 1L, 1L, 2L,
1L, 4L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 0L, 0L, 2L, 1L, 1L, 0L, 1L,
1L, 0L, 0L, 0L, 2L, 2L, 4L, 0L, 2L, 0L, 0L, 2L, 0L, 2L, 0L, 0L,
0L, 1L, 0L, 0L, 0L, 1L, 0L, 0L, 1L, 1L, 4L, 0L, 0L, 0L, 2L, 0L,
0L, 1L, 1L, 0L, 1L, 0L, 0L, 0L, 0L, 1L, 1L, 0L, 0L, 1L, 0L, 1L,
0L, 1L, 1L, 4L, 2L, 0L, 1L, 0L, 0L, 0L, 1L, 1L, 1L, 0L, 1L, 4L,
2L, 2L, 1L, 2L, 1L, 1L, 2L, 0L, 0L, 2L, 0L, 0L, 1L, 0L, 0L, 0L,
1L, 4L, 1L, 0L, 1L, 1L, 0L, 0L, 0L, 1L, 1L, 1L, 4L, 0L, 1L, 0L,
2L, 2L, 1L, 0L, 4L, 1L, 2L, 1L, 0L, 1L, 1L, 0L, 1L, 4L, 1L, 4L,
0L, 1L, 1L, 1L, 4L, 1L, 2L, 1L, 0L, 0L, 1L, 1L, 1L, 0L, 2L, 0L,
0L, 0L, 1L, 1L, 4L, 1L, 0L, 1L, 0L, 0L, 1L, 4L, 0L, 1L, 1L, 1L,
1L, 4L, 4L, 1L, 0L, 0L, 0L, 0L, 0L, 2L, 1L, 0L, 1L, 0L, 1L, 0L,
2L, 1L, 4L, 0L, 0L, 0L, 1L, 2L, 0L, 1L, 0L, 4L, 1L, 1L, 0L, 0L,
1L, 1L, 0L, 4L, 0L, 0L, 1L, 0L, 0L, 4L, 1L, 1L, 2L, 0L, 1L, 0L,
1L, 4L, 1L, 1L, 4L, 1L, 0L, 0L, 0L, 0L, 4L, 1L, 1L, 0L, 4L, 0L,
0L, 1L, 1L, 2L, 0L, 1L, 0L, 0L, 1L, 0L, 4L, 0L, 0L, 0L, 0L, 1L,
1L, 2L, 4L, 0L, 0L, 1L, 0L, 2L, 1L, 1L, 0L, 0L, 4L, 4L, 0L, 1L,
0L, 1L, 1L, 1L, 1L, 1L, 1L, 0L, 0L, 0L, 1L, 1L, 1L, 2L, 1L, 0L,
1L, 0L, 0L, 0L, 1L, 1L, 1L, 4L, 1L, 0L, 0L, 2L, 0L, 0L, 1L, 4L,
4L, 2L, 0L, 0L, 1L, 0L, 1L, 1L, 1L, 2L, 1L, 0L, 2L, 4L, 0L, 0L,
1L, 4L, 2L, 0L, 0L, 0L, 1L, 0L, 1L, 4L, 0L, 2L, 1L, 1L, 1L, 0L,
0L, 1L, 1L, 1L, 0L, 1L, 2L, 0L, 0L, 1L, 0L, 4L, 1L, 4L, 0L, 1L,
1L, 4L, 0L, 4L, 0L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 2L, 0L, 4L,
4L, 0L, 1L, 2L, 2L, 1L, 0L, 1L, 1L, 4L, 1L, 4L, 0L, 0L, 0L, 2L,
0L, 2L, 0L, 2L, 1L, 1L, 1L, 0L, 0L, 1L, 4L, 1L, 1L, 4L, 1L, 0L,
4L, 0L, 0L, 2L, 2L, 0L, 0L, 1L, 4L, 1L, 0L, 0L, 0L, 1L, 0L, 0L,
0L, 0L, 4L, 1L, 0L, 2L, 0L, 4L, 1L, 4L, 0L, 2L, 0L, 4L, 0L, 0L,
0L, 1L, 1L, 0L, 0L, 2L, 4L, 0L, 0L, 4L, 1L, 1L, 4L, 0L, 0L, 1L,
2L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 2L, 0L, 0L, 1L, 2L, 0L, 1L, 0L,
0L, 0L, 2L, 2L, 0L, 1L, 0L, 0L, 1L, 0L, 0L, 4L, 0L, 2L, 2L, 1L,
0L, 0L, 0L, 1L, 1L, 4L, 0L, 2L, 0L, 1L, 1L, 1L, 0L, 0L, 0L, 0L,
1L, 4L, 0L, 1L, 0L, 1L, 1L, 1L, 4L, 0L, 1L, 4L, 0L, 1L, 0L, 0L,
0L, 0L, 4L, 1L, 0L, 0L, 0L, 0L, 0L, 4L, 1L, 0L, 0L, 0L, 0L, 1L,
0L, 0L, 1L, 1L, 1L, 4L, 0L, 0L, 0L, 0L, 4L, 1L, 0L, 4L, 4L, 1L,
1L, 1L, 0L, 0L, 1L, 1L, 0L, 1L, 0L, 0L, 4L, 0L, 1L, 1L, 0L, 0L,
2L, 0L, 1L, 0L, 0L, 0L, 1L, 2L, 1L, 1L, 4L, 1L, 0L, 4L, 4L, 1L,
1L, 0L, 1L, 2L, 1L, 0L, 1L, 4L, 2L, 0L, 1L, 4L, 1L, 1L, 0L, 2L,
0L, 0L, 0L, 2L, 1L, 0L, 2L, 1L, 0L, 0L, 1L, 0L, 1L, 1L, 1L, 1L,
0L, 4L, 0L, 0L, 4L, 4L, 4L, 2L, 1L, 1L, 4L, 0L, 1L, 0L, 2L, 0L,
0L, 0L, 0L, 1L, 0L, 0L, 4L, 1L, 1L, 2L, 0L, 1L, 1L, 0L, 2L, 1L,
4L, 0L, 0L, 4L, 2L, 0L, 4L, 4L, 4L, 4L, 0L, 0L, 4L, 0L, 1L, 1L,
0L, 1L, 1L, 1L, 0L, 2L, 1L, 0L, 4L, 0L, 0L, 4L, 1L, 0L, 2L, 2L,
0L, 1L, 1L, 0L, 1L, 2L, 0L, 0L, 0L, 4L, 4L, 1L, 2L, 1L, 2L, 1L,
2L, 1L, 1L, 2L, 0L, 1L, 1L, 1L, 0L, 0L, 1L, 2L, 1L, 0L, 1L, 4L,
0L, 0L, 1L, 4L, 1L, 0L, 4L, 1L, 1L, 1L, 1L, 4L, 1L, 2L, 2L, 1L,
4L, 1L, 1L, 0L, 0L, 2L, 0L, 0L, 4L, 1L, 0L, 1L, 4L, 0L, 1L, 1L,
0L, 4L, 2L, 2L, 0L, 1L, 0L, 0L, 4L, 1L, 1L, 0L, 1L, 1L, 1L, 2L,
2L, 4L, 0L, 1L, 0L, 4L, 1L, 0L, 0L, 0L, 2L, 1L, 0L, 1L, 0L, 2L,
4L, 0L, 1L, 0L, 1L, 1L, 0L, 0L, 1L, 0L, 0L, 1L, 2L, 0L, 0L, 2L,
0L, 2L, 1L, 0L, 0L, 0L, 0L, 4L, 1L, 0L, 4L, 4L, 1L, 0L, 2L, 2L,
0L, 0L, 1L, 0L, 1L, 0L, 2L, 1L, 0L, 4L, 4L, 4L, 2L, 4L, 4L, 0L,
4L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 1L, 1L, 1L, 0L, 1L, 1L, 0L, 1L,
0L, 1L, 0L, 4L, 0L, 1L, 0L, 0L, 0L, 1L, 0L, 1L, 0L, 0L, 0L, 1L,
0L, 0L, 2L, 2L, 2L, 2L, 0L, 0L, 1L, 0L, 0L, 1L, 1L, 0L, 0L, 1L,
0L, 1L, 1L, 1L, 0L, 4L, 0L, 0L, 1L, 0L, 0L, 0L, 1L, 1L, 1L, 1L,
0L, 1L, 4L, 0L, 1L, 0L, 4L, 0L, 0L, 0L, 0L, 1L, 2L, 0L, 0L, 1L,
1L, 0L, 0L, 1L, 0L, 4L, 4L, 0L, 1L, 1L, 0L, 4L, 0L, 2L, 1L, 4L,
0L, 4L, 1L, 2L, 4L, 4L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 4L, 2L, 0L,
4L, 1L, 0L, 2L, 4L, 0L, 1L, 1L, 1L, 0L, 4L, 2L, 2L, 0L, 4L, 1L,
0L, 1L, 1L, 0L, 0L, 4L, 0L, 1L, 2L, 2L, 2L, 1L, 1L, 0L, 0L, 1L,
1L, 1L, 0L, 1L, 0L, 1L, 1L, 2L, 0L, 0L, 4L, 1L, 0L, 1L, 0L, 0L,
0L, 1L, 1L, 2L, 1L, 2L, 2L, 1L, 1L, 3L, 3L, 1L, 4L, 2L, 4L, 1L,
1L, 1L, 2L, 4L, 2L, 2L, 2L, 0L, 4L, 0L, 1L, 2L, 1L, 2L, 1L, 1L,
1L, 1L, 0L, 0L, 0L, 1L, 0L, 1L, 1L, 0L, 2L, 0L, 2L, 1L, 1L, 3L,
2L, 1L, 1L, 1L, 2L, 3L, 1L, 1L, 1L, 1L, 2L, 2L, 4L, 2L, 4L, 4L,
1L, 1L, 2L, 1L, 2L, 0L, 1L, 1L, 1L, 3L, 1L, 0L, 4L, 4L, 2L, 2L,
1L, 4L, 1L, 0L, 2L, 2L, 1L, 1L, 3L, 2L, 2L, 2L, 1L, 1L, 1L, 2L,
1L, 2L, 2L, 1L, 1L, 4L, 1L, 2L, 4L, 1L, 1L, 2L, 0L, 1L, 4L, 4L,
1L, 2L, 1L, 1L, 3L, 4L, 3L, 1L, 4L, 0L, 2L, 2L, 2L, 4L, 4L, 1L,
1L, 4L, 1L, 2L, 1L, 4L, 2L, 4L, 4L, 4L, 1L, 1L, 2L, 2L, 1L, 1L,
2L, 1L, 0L, 1L, 2L, 1L, 1L, 2L, 3L, 1L, 2L, 2L, 1L, 1L, 1L, 4L,
1L, 2L, 1L, 2L, 4L, 2L, 1L, 1L, 1L, 4L, 4L, 1L, 1L, 4L, 2L, 0L,
1L, 0L, 1L, 1L, 2L, 1L, 1L, 4L, 1L, 2L, 4L, 2L, 2L, 2L, 0L, 1L,
4L, 4L, 2L, 2L, 0L, 0L, 4L, 1L, 4L, 1L, 1L, 1L, 1L, 4L, 1L, 1L,
1L, 4L, 4L, 4L, 2L, 4L, 4L, 2L, 4L, 4L, 4L, 2L, 4L, 2L, 2L, 2L,
1L, 0L, 1L, 2L, 2L, 1L, 1L, 4L, 4L, 1L, 0L, 1L, 1L, 2L, 4L, 1L,
4L, 1L, 1L, 2L, 1L, 1L, 0L, 0L, 1L, 1L, 0L, 2L, 1L, 2L, 4L, 1L,
4L, 4L, 1L, 3L, 2L, 1L, 4L, 1L, 4L, 0L, 4L, 2L, 4L, 2L, 4L, 4L,
1L, 1L, 4L, 1L, 1L, 4L, 4L, 1L, 4L, 0L, 1L, 4L, 4L, 1L, 1L, 1L,
4L, 4L, 1L, 1L, 3L, 4L, 3L, 1L, 4L, 4L, 2L, 2L, 4L, 2L, 4L, 0L,
1L, 4L, 4L, 1L, 4L, 4L, 1L, 2L, 3L, 1L, 2L, 3L, 0L, 4L, 4L, 1L,
1L, 1L, 0L, 1L, 4L, 1L, 1L, 1L, 1L, 1L, 0L, 1L, 1L, 0L, 3L, 2L,
1L, 1L, 0L, 2L, 1L, 2L, 2L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 0L, 4L,
1L, 1L, 0L, 1L, 0L, 2L, 1L, 2L, 0L, 0L, 0L, 0L, 2L, 0L, 2L, 1L,
2L, 4L, 3L, 2L, 1L, 1L, 3L, 1L, 1L, 0L, 2L, 0L, 0L, 0L, 1L, 1L,
1L, 2L, 0L, 1L, 3L, 0L, 1L, 2L, 1L, 4L, 1L, 2L, 1L, 1L, 1L, 2L,
0L, 2L, 0L, 2L, 1L, 2L, 2L, 1L, 1L, 3L, 3L, 1L, 3L, 4L, 1L, 2L,
2L, 1L, 4L, 3L, 3L, 1L, 1L, 0L, 3L, 3L, 2L, 1L, 2L, 2L, 2L, 2L,
3L, 0L, 2L, 1L, 2L, 2L, 1L, 1L, 0L, 2L, 2L, 2L, 4L, 2L, 2L, 0L,
2L, 0L, 1L, 2L, 2L, 0L, 2L, 4L, 0L, 2L, 1L, 2L, 1L, 2L, 1L, 2L,
0L, 2L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 2L, 1L, 0L, 1L, 2L, 2L, 1L,
1L, 1L, 3L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 0L, 2L, 1L, 2L, 1L,
4L, 1L, 3L, 2L, 1L, 2L, 2L, 2L, 2L, 1L, 3L, 2L, 1L, 2L, 0L, 1L,
3L, 1L, 2L, 2L, 2L, 1L, 1L, 4L, 2L, 3L, 1L, 2L, 1L, 4L, 1L, 1L,
3L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 2L, 2L, 1L, 1L, 2L,
1L, 1L, 1L, 0L, 1L, 2L, 1L, 2L, 2L, 2L, 2L, 0L, 2L, 1L, 2L, 0L,
1L, 4L, 2L, 3L, 2L, 1L, 1L, 1L, 1L, 3L, 1L, 1L, 3L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 4L, 1L, 0L, 0L, 1L, 1L, 1L, 1L, 0L, 2L, 1L, 1L,
1L, 2L, 2L, 2L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 2L, 1L,
0L, 1L, 1L, 2L, 0L, 3L, 2L, 2L, 2L, 1L, 1L, 4L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 4L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L,
2L, 1L, 1L, 2L, 2L, 3L, 0L, 1L, 2L, 2L, 1L, 1L, 2L, 1L, 2L, 1L,
2L, 1L, 1L, 2L, 2L, 1L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 2L, 1L, 2L,
0L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 0L, 2L, 2L, 1L, 1L, 1L, 1L,
0L, 1L, 1L, 1L, 1L, 2L, 2L, 3L, 4L, 1L, 1L, 1L, 2L, 2L, 1L, 2L,
2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 2L, 2L, 4L, 1L,
1L, 0L, 2L, 0L, 0L, 1L, 2L, 3L, 2L, 1L, 3L, 1L, 1L, 3L, 3L, 1L,
1L, 0L, 0L, 0L, 3L, 2L, 1L, 1L, 1L, 0L, 2L, 1L, 2L, 3L, 0L, 0L,
1L, 2L, 4L, 1L, 1L, 1L, 1L, 1L, 1L, 0L, 1L, 1L, 1L, 4L, 1L, 1L,
1L, 1L, 1L, 1L, 2L, 0L, 2L, 0L, 0L, 1L, 1L, 0L, 1L, 0L, 1L, 1L,
0L, 0L, 1L, 0L, 0L, 0L, 1L, 0L, 0L, 4L, 1L, 0L, 0L, 1L, 0L, 1L,
0L, 1L, 1L, 0L, 0L, 1L, 1L, 1L, 0L, 1L, 2L, 1L, 2L, 3L, 1L, 0L,
0L, 1L, 1L, 1L, 0L, 0L, 3L, 0L, 2L, 4L, 1L, 1L, 3L, 3L, 1L, 3L,
3L, 2L, 2L, 3L, 3L, 3L, 3L, 3L, 4L, 3L, 3L, 2L, 2L, 2L, 2L, 3L,
2L, 1L, 2L, 2L, 2L, 3L, 2L, 4L, 3L, 1L, 3L, 2L, 2L, 2L, 3L, 0L,
1L, 4L, 2L, 4L, 1L, 3L, 4L, 3L, 3L, 2L, 3L, 1L, 4L, 3L, 1L, 3L,
2L, 1L, 2L, 1L, 3L, 2L, 2L, 1L, 2L, 0L, 0L, 1L, 3L, 3L, 4L, 2L,
1L, 1L, 3L, 2L, 3L, 1L, 3L, 1L, 2L, 1L, 1L, 1L, 3L, 3L, 3L, 2L,
1L, 0L, 2L, 3L, 0L, 1L, 0L, 1L, 3L, 4L, 2L, 1L, 3L, 2L, 1L, 1L,
2L, 3L, 3L, 1L, 2L, 1L, 2L, 1L, 1L, 4L, 3L, 1L, 2L, 2L, 2L, 2L,
3L, 2L, 4L, 3L, 3L, 1L, 1L, 3L, 3L, 3L, 4L, 3L, 3L, 2L, 2L, 2L,
3L, 2L, 4L, 1L, 2L, 4L, 2L, 1L, 2L, 4L, 3L, 4L, 1L, 4L, 1L, 2L,
1L, 2L, 4L, 2L, 2L, 4L, 1L, 3L, 4L, 2L, 3L, 2L, 3L, 4L, 3L, 1L,
1L, 4L, 1L, 3L, 2L, 1L, 2L, 1L, 2L, 4L, 1L, 4L, 4L, 2L, 4L, 4L,
3L, 4L, 1L, 2L, 2L, 3L, 4L, 4L, 2L, 4L, 3L, 2L, 4L, 3L, 1L, 2L,
2L, 2L, 2L, 4L, 2L, 2L, 1L, 1L, 4L, 2L, 4L, 2L, 3L, 2L, 1L, 4L,
3L, 3L, 4L, 1L, 3L, 4L, 3L, 2L, 3L, 2L, 2L, 2L, 4L, 4L, 2L, 3L,
3L, 2L, 4L, 2L, 2L, 3L, 4L, 3L, 2L, 4L, 3L, 4L, 2L, 3L, 2L, 4L,
1L, 4L, 3L, 4L, 1L, 2L, 2L, 3L, 4L, 1L, 1L, 1L, 4L, 3L, 4L, 3L,
3L, 3L, 4L, 2L, 4L, 2L, 3L, 1L, 2L, 4L, 4L, 4L, 2L, 4L, 2L, 2L,
3L, 3L, 1L, 2L, 2L, 3L, 3L, 2L, 4L, 2L, 3L, 3L, 2L, 4L, 3L, 4L,
3L, 1L, 3L, 2L, 2L, 2L, 1L, 4L, 2L, 2L, 2L, 3L, 3L, 1L, 1L, 3L,
3L, 3L, 2L, 1L, 4L, 1L, 3L, 3L, 4L, 2L, 2L, 3L, 2L, 3L, 3L, 3L,
1L, 2L, 3L, 1L, 2L, 3L, 2L, 4L, 2L, 2L, 4L, 3L, 2L, 2L, 3L, 1L,
1L, 1L, 2L, 2L, 1L, 2L, 3L, 4L, 1L, 3L, 4L, 1L, 4L, 4L, 4L, 2L,
1L, 2L, 1L, 1L, 2L, 2L, 2L, 1L, 3L, 3L, 1L, 1L, 1L, 2L, 2L, 3L,
1L, 3L, 2L, 1L, 4L, 2L, 3L, 2L, 3L, 3L, 2L, 3L, 1L, 2L, 3L, 3L,
3L, 4L, 3L, 1L, 0L, 3L, 3L, 1L, 1L, 2L, 4L, 2L, 4L, 3L, 4L, 1L,
4L, 4L, 2L, 1L, 3L, 2L, 1L, 4L, 4L, 1L, 1L, 2L, 4L, 4L, 4L, 1L,
1L, 1L, 1L, 0L, 4L, 1L, 4L, 4L, 2L, 2L, 4L, 1L, 4L, 2L, 2L, 2L,
1L, 4L, 1L, 4L, 1L, 1L, 2L, 0L, 1L, 3L, 1L, 2L, 4L, 3L, 1L, 3L,
2L, 2L, 3L, 0L, 2L, 1L, 2L, 4L, 1L, 2L, 2L, 2L, 2L, 4L, 2L, 1L,
1L, 2L, 0L, 1L, 2L, 1L, 3L, 3L, 2L, 4L, 3L, 2L, 2L, 2L, 0L, 1L,
3L, 3L, 3L, 4L, 4L, 2L, 4L, 4L, 4L, 1L, 4L, 2L, 3L, 2L, 4L, 1L,
4L, 2L, 1L, 3L, 2L, 3L, 4L, 3L, 4L, 2L, 2L, 4L, 3L, 0L, 2L, 4L,
1L, 3L, 4L, 2L, 4L, 4L, 2L, 4L, 3L, 3L, 4L, 4L, 2L, 2L, 4L, 4L,
3L, 4L, 3L, 4L, 2L, 3L, 1L, 2L, 2L, 4L, 0L, 2L, 3L, 1L, 3L, 1L,
0L, 2L, 4L, 4L, 2L, 1L, 2L, 3L, 4L, 1L, 1L, 4L, 2L, 3L, 3L, 4L,
2L, 3L, 1L, 3L, 3L, 1L, 3L, 3L, 1L, 1L, 2L, 0L, 3L, 2L, 0L, 1L,
2L, 1L, 1L, 1L, 0L, 1L, 1L, 2L, 1L, 3L, 1L, 1L, 1L, 2L, 0L, 4L,
1L, 3L, 1L, 2L, 4L, 2L, 2L, 3L, 3L, 3L, 4L, 1L, 1L, 4L, 4L, 2L,
3L, 1L, 1L, 2L, 1L, 1L, 4L, 2L, 1L, 2L, 2L, 1L, 2L, 2L, 1L, 1L,
0L, 2L, 2L, 1L, 2L, 1L, 1L, 4L, 1L, 3L, 2L, 1L, 2L, 3L, 2L, 1L,
2L, 1L, 1L, 3L, 0L, 2L, 0L, 2L, 0L, 4L, 1L, 2L, 4L, 0L, 2L, 2L,
3L, 1L, 2L, 0L, 1L, 4L, 2L, 1L, 1L, 2L, 2L, 3L, 3L, 3L, 3L, 4L,
1L, 1L, 3L, 1L, 3L, 2L, 2L, 1L, 1L, 3L, 2L, 0L, 3L, 0L, 1L, 0L,
2L, 3L, 2L, 0L, 2L, 2L, 3L, 3L, 1L, 0L, 1L, 0L, 0L, 1L, 1L, 0L,
2L, 1L, 1L, 2L, 1L, 2L, 2L, 0L, 1L, 4L, 0L, 1L, 2L, 2L, 2L, 2L,
0L, 2L, 2L, 1L, 2L, 4L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 3L,
3L, 3L, 1L, 1L, 2L, 3L, 3L, 2L, 2L, 3L, 3L, 1L, 2L, 3L, 1L, 2L,
1L, 1L, 0L, 1L, 1L, 2L, 1L, 0L, 2L, 2L, 0L, 2L, 2L, 2L, 3L, 0L,
0L, 2L, 1L, 2L, 1L, 0L, 2L, 2L, 2L, 2L, 2L, 3L, 1L, 2L, 0L, 2L,
3L, 2L, 1L, 2L, 2L, 1L, 1L, 2L, 4L, 0L, 1L, 1L, 2L, 3L, 2L, 1L,
3L, 2L, 1L, 1L, 2L, 3L, 1L, 2L, 4L, 4L, 1L, 2L, 3L, 2L, 3L, 1L,
0L, 1L, 2L, 1L, 1L, 1L, 2L, 2L, 3L, 3L, 1L, 2L, 0L, 4L, 1L, 1L,
0L, 4L, 1L, 2L, 1L, 2L, 2L, 0L, 3L, 1L, 1L, 1L, 1L, 2L, 2L, 1L,
2L, 3L, 3L, 2L, 2L, 0L, 3L, 3L, 4L, 2L, 2L, 0L, 3L, 1L, 2L, 1L,
0L, 1L, 3L, 0L, 2L, 2L, 1L, 1L, 1L, 3L, 1L, 2L, 2L, 2L, 2L, 4L,
4L, 2L, 2L, 1L, 2L, 1L, 1L, 2L, 0L, 0L, 2L, 2L, 1L, 0L, 2L, 0L,
1L, 3L, 1L, 2L, 3L, 1L, 2L, 4L, 1L, 1L, 2L, 4L, 2L, 1L, 2L, 4L,
4L, 1L, 4L, 2L, 3L, 3L, 2L, 2L, 0L, 2L, 3L, 2L, 1L, 0L, 2L, 0L,
2L, 1L, 0L, 1L, 2L, 3L, 0L, 0L, 0L, 3L, 1L, 0L, 1L, 2L, 4L, 0L,
0L, 2L, 1L, 1L, 0L, 3L, 0L, 3L, 1L, 1L, 2L, 0L, 3L, 2L, 2L, 2L,
4L, 2L, 3L, 1L, 0L, 1L, 2L, 2L, 1L, 1L, 2L, 2L, 1L, 2L, 1L, 2L,
0L, 1L, 2L, 2L, 1L, 1L, 4L, 2L, 2L, 2L, 0L, 2L, 2L, 2L, 1L, 1L,
2L, 2L, 3L, 1L, 3L, 3L, 3L, 2L, 1L, 1L, 1L, 2L, 1L, 0L, 2L, 2L,
2L, 1L, 1L, 3L, 2L, 1L, 1L, 2L, 1L, 2L, 1L, 3L, 3L, 2L, 0L, 3L,
3L, 1L, 0L, 4L, 3L, 3L, 2L, 0L, 2L, 1L, 3L, 0L, 2L, 2L, 3L, 4L,
1L, 3L, 3L, 2L, 0L, 1L, 1L, 0L, 1L, 2L, 1L, 3L, 1L, 1L, 1L, 0L,
0L, 0L, 2L, 0L, 1L, 0L, 2L, 2L, 2L, 0L, 2L, 1L, 3L, 4L, 4L, 0L,
2L, 1L, 2L, 3L, 0L, 1L, 1L, 1L, 0L, 1L, 0L, 0L, 1L, 2L, 0L, 3L,
2L, 2L, 1L, 2L, 2L, 3L, 0L, 2L, 1L, 2L, 4L, 1L, 1L, 1L, 0L, 3L,
3L, 2L, 3L, 2L, 3L, 2L, 2L, 4L, 1L, 0L, 3L, 2L, 1L, 2L, 1L, 2L,
2L, 1L, 3L, 2L, 3L, 2L, 1L, 4L, 2L, 3L, 2L, 2L, 2L, 3L, 1L, 0L,
2L, 0L, 1L, 0L, 2L, 1L, 3L, 2L, 1L, 4L, 0L, 2L, 1L, 3L, 3L, 2L,
0L, 1L, 1L, 0L, 2L, 3L, 0L, 0L, 1L, 3L, 4L, 2L, 0L, 2L, 2L, 2L,
1L, 1L, 0L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 2L, 2L, 0L, 1L, 1L, 3L,
2L, 2L, 0L, 0L, 2L, 4L, 1L, 1L, 0L, 0L, 1L, 4L, 1L, 2L, 2L, 0L,
1L, 1L, 1L, 2L, 2L, 4L, 0L, 4L, 0L, 1L, 0L, 4L, 0L, 3L, 0L, 3L,
3L, 1L, 3L, 0L, 0L, 3L, 0L, 0L, 0L, 2L, 0L, 1L, 0L, 1L, 2L, 2L,
0L, 2L, 0L, 3L, 0L, 3L, 4L, 1L, 4L, 1L, 3L, 2L, 2L, 3L, 4L, 3L,
2L, 0L, 0L, 3L, 4L, 2L, 3L, 3L, 0L, 4L, 3L, 4L, 3L, 3L, 2L, 3L,
2L, 2L, 2L, 2L, 0L, 3L, 3L, 0L, 0L, 3L, 1L, 4L, 1L, 0L, 4L, 3L,
1L, 3L, 3L, 1L, 4L, 2L, 2L, 3L, 0L, 1L, 2L, 3L, 3L, 0L, 4L, 3L,
1L, 3L, 0L, 3L, 0L, 3L, 1L, 2L, 1L, 1L, 1L, 2L, 3L, 0L, 3L, 3L,
0L, 3L, 3L, 0L, 1L, 1L, 0L, 0L, 1L, 2L, 2L, 0L, 3L, 1L, 2L, 1L,
0L, 0L, 1L, 3L, 2L, 2L, 4L, 0L, 3L, 0L, 2L, 3L, 2L, 2L, 0L, 0L,
3L, 1L, 0L, 3L, 3L, 2L, 0L, 0L, 3L, 2L, 1L, 3L, 0L, 2L, 4L, 1L,
3L, 4L, 0L, 0L, 1L, 2L, 0L, 2L, 1L, 1L, 0L, 3L, 0L, 3L, 3L, 4L,
0L, 2L, 2L, 2L, 0L, 4L, 3L, 2L, 3L, 1L, 1L, 3L, 1L, 0L, 3L, 2L,
1L, 2L, 3L, 1L, 1L, 2L, 1L, 1L, 0L, 3L, 0L, 0L, 0L, 1L, 1L, 0L,
1L, 2L, 3L, 1L, 3L, 2L, 4L, 3L, 2L, 0L, 0L, 0L, 4L, 1L, 3L, 3L,
3L, 1L, 1L, 2L, 1L, 2L, 2L, 2L, 1L, 0L, 0L, 2L, 1L, 0L, 1L, 0L,
2L, 2L, 0L, 1L, 2L, 1L, 1L, 1L, 0L, 1L, 2L, 1L, 3L, 3L, 2L, 0L,
2L, 1L, 1L, 3L, 1L, 4L, 0L, 2L, 2L, 1L, 2L, 3L, 0L, 3L, 3L, 3L,
3L, 3L, 0L, 3L, 0L, 3L, 3L, 0L, 3L, 0L, 3L, 2L, 4L, 4L, 1L, 3L,
0L, 0L, 3L, 4L, 2L, 1L, 3L, 0L, 2L, 2L, 0L, 2L, 4L, 2L, 4L, 4L,
3L, 3L, 0L, 3L, 2L, 4L, 3L, 4L, 4L, 3L, 4L, 2L, 0L, 3L, 3L, 3L,
3L, 3L, 2L, 4L, 0L, 1L, 1L, 1L, 3L, 0L, 3L, 1L, 3L, 3L, 2L, 2L,
2L, 0L, 0L, 3L, 0L, 2L, 0L, 3L, 2L, 2L, 0L, 3L, 3L, 0L, 3L, 1L,
3L, 4L, 3L, 4L, 3L, 4L, 4L, 4L, 4L, 0L, 0L, 3L, 0L, 2L, 3L, 3L,
0L, 0L, 2L, 0L, 4L, 3L, 3L, 3L, 0L, 0L, 0L, 1L, 0L, 0L, 1L, 3L,
3L, 0L, 2L, 3L, 2L, 4L, 4L, 0L, 0L, 2L, 0L, 0L, 0L, 1L, 3L, 3L,
0L, 4L, 0L, 4L, 1L, 3L, 1L, 2L, 1L, 4L, 2L, 3L, 3L, 4L, 4L, 4L,
0L, 3L, 4L, 4L, 2L, 3L, 2L, 4L, 3L, 4L, 4L, 0L, 0L, 1L, 4L, 0L,
4L, 1L, 3L, 3L, 3L, 3L, 3L, 4L, 3L, 3L, 3L, 4L, 4L, 3L, 3L, 0L,
2L, 3L, 1L, 2L, 0L, 0L, 3L, 0L, 4L, 4L, 3L, 1L, 4L, 1L, 4L, 0L,
0L, 3L, 0L, 3L, 2L, 3L, 2L, 3L, 0L, 3L, 4L, 1L, 2L, 1L, 3L, 3L,
2L, 0L, 1L, 3L, 0L, 2L, 2L, 0L, 1L, 0L, 0L, 0L, 3L, 3L, 0L, 3L,
3L, 0L, 4L, 2L, 0L, 2L, 0L, 4L, 0L, 4L, 0L, 4L, 2L, 2L, 4L, 0L,
0L, 1L, 4L, 0L, 1L, 1L, 2L, 2L, 3L, 0L, 3L, 1L, 0L, 3L, 3L, 0L,
3L, 4L, 2L, 1L, 2L, 1L, 0L, 4L, 0L, 2L, 0L, 0L, 3L, 0L, 3L, 3L,
2L, 2L, 4L, 0L, 0L, 1L, 2L, 0L, 2L, 3L, 3L, 0L, 4L, 0L, 0L, 0L,
4L, 3L, 4L, 4L, 4L, 4L, 2L, 1L, 0L, 3L, 2L, 3L, 4L, 4L, 4L, 4L,
0L, 4L, 3L, 0L, 0L, 2L, 2L, 3L, 2L, 0L, 3L, 3L, 3L, 4L, 3L, 0L,
0L, 3L, 3L, 1L, 0L, 4L, 0L, 0L, 3L, 1L, 2L, 4L, 0L, 4L, 3L, 1L,
2L, 3L, 1L, 3L, 0L, 2L, 4L, 4L, 3L, 1L, 3L, 0L, 3L, 4L, 2L, 0L,
0L, 1L, 4L, 1L, 0L, 4L, 0L, 4L, 3L, 0L, 3L, 1L, 1L, 4L, 0L, 4L,
1L, 4L, 0L, 4L, 0L, 1L, 3L, 2L, 0L, 3L, 3L, 1L, 3L, 3L, 4L, 0L,
1L, 0L, 3L, 1L, 3L, 2L, 0L, 1L, 2L, 0L, 3L, 4L, 0L, 2L, 1L, 2L,
0L, 4L, 3L, 4L, 3L, 3L, 1L, 3L, 3L, 3L, 3L, 2L, 3L, 2L, 2L, 0L,
0L, 2L, 0L, 3L, 3L, 2L, 3L, 1L, 2L, 1L, 1L, 2L, 3L, 4L, 3L, 0L,
1L, 4L, 3L, 2L, 4L, 0L, 0L, 3L, 4L, 0L, 2L, 2L, 3L, 4L, 3L, 0L,
3L, 0L, 3L, 0L, 4L, 4L, 1L, 4L, 1L, 3L, 4L, 2L, 3L, 3L, 3L, 0L,
2L, 2L, 3L, 1L, 4L, 2L, 0L, 0L, 4L, 3L, 3L, 3L, 3L, 4L, 2L, 0L,
2L, 1L, 0L, 3L, 4L, 3L, 3L, 0L, 3L, 3L, 0L, 0L, 2L, 0L, 2L, 0L,
1L, 4L, 3L, 0L, 4L, 3L, 0L, 1L, 3L, 1L, 2L, 3L, 4L, 1L, 0L, 4L,
4L, 1L, 4L, 0L, 3L, 4L, 4L, 3L, 3L, 2L, 3L, 2L, 1L, 3L, 0L, 1L,
1L, 3L, 3L, 1L, 0L, 3L, 1L, 1L, 3L, 1L, 1L, 2L, 3L, 2L, 0L, 2L,
3L, 0L, 1L, 0L, 0L, 1L, 2L, 2L, 0L, 4L, 0L, 3L, 3L, 0L, 2L, 4L,
3L, 0L, 0L, 3L, 3L, 4L, 0L, 1L, 0L, 3L, 0L, 0L, 3L, 0L, 1L, 3L,
3L, 3L, 1L, 4L, 1L, 2L, 0L, 3L, 1L, 3L, 1L, 0L, 2L, 0L, 4L, 1L,
0L, 4L, 4L, 3L, 3L, 4L, 2L, 2L, 0L, 4L, 1L, 2L, 4L, 0L, 4L, 4L,
0L, 0L, 3L, 4L, 3L, 3L, 2L, 3L, 0L, 2L, 4L, 3L, 4L, 3L, 3L, 3L,
4L, 0L, 2L, 3L, 4L, 4L, 2L, 0L, 4L, 0L, 2L, 4L, 0L, 1L, 3L, 1L,
1L, 1L, 0L, 4L, 4L, 3L, 0L, 3L, 1L, 1L, 2L, 0L, 0L, 4L, 0L, 3L,
3L, 0L, 2L, 0L, 1L, 0L, 3L, 3L, 4L, 0L, 0L, 0L, 4L, 0L, 3L, 1L,
0L, 0L, 3L, 4L, 0L, 3L, 1L, 3L, 2L, 2L, 0L, 2L, 3L, 0L, 2L, 4L,
1L, 3L, 0L, 0L, 3L, 1L, 3L, 3L, 3L, 4L, 3L, 2L, 2L, 3L, 4L, 3L,
1L, 3L, 0L, 4L, 3L, 0L, 0L, 3L, 4L, 0L, 4L, 0L, 4L, 1L, 3L, 1L,
0L, 4L, 3L, 1L, 0L, 1L, 0L, 3L, 3L, 0L, 0L, 3L, 1L, 2L, 3L, 3L,
4L, 0L, 3L, 1L, 1L, 4L, 0L, 2L, 0L, 0L, 3L, 3L, 1L, 0L, 3L, 3L,
0L, 0L, 1L, 0L, 2L, 0L, 2L, 0L, 1L, 2L, 0L, 2L, 4L, 1L, 0L, 1L,
1L, 0L, 1L, 3L, 4L, 0L, 1L, 3L, 4L, 0L, 3L, 1L, 2L, 2L, 0L, 4L,
3L, 2L, 3L, 1L, 0L, 0L, 2L, 4L, 0L, 2L, 2L, 4L, 1L, 1L, 3L, 4L,
1L, 1L, 0L, 2L, 1L, 0L, 3L, 0L, 0L, 1L, 2L, 4L, 3L, 3L, 0L, 0L,
2L, 4L, 0L, 3L, 3L, 3L, 3L, 4L, 2L, 2L, 1L, 3L, 0L, 3L, 4L, 4L,
3L, 3L, 3L, 1L, 2L, 2L, 0L, 0L, 1L, 2L, 2L, 3L, 4L, 0L, 1L, 1L,
4L, 2L, 1L, 2L, 1L, 1L, 1L, 3L, 4L, 1L, 0L, 0L, 0L, 3L, 4L, 0L,
1L, 3L, 3L, 0L, 3L, 0L, 0L, 2L, 0L, 0L, 3L, 4L, 0L, 2L, 1L, 0L,
1L, 2L, 2L, 4L, 1L, 2L, 4L, 0L, 0L, 4L, 4L, 2L, 4L, 4L, 4L, 3L,
4L, 3L, 2L, 0L, 2L, 3L, 2L, 0L, 3L, 4L, 1L, 1L, 3L, 0L, 3L, 4L,
4L, 4L, 2L, 0L, 1L, 4L, 4L, 1L, 4L, 0L, 0L, 4L, 0L, 3L, 1L, 2L,
3L, 4L, 4L, 3L, 3L, 0L, 2L, 0L, 2L, 2L, 1L, 3L, 2L, 0L, 3L, 0L,
0L, 3L, 3L, 3L, 3L, 4L, 0L, 3L, 0L, 0L, 2L, 3L, 3L, 2L, 3L, 2L,
0L, 0L, 0L, 0L, 2L, 3L, 2L, 2L, 3L, 0L, 0L, 0L, 3L, 1L, 0L, 1L,
2L, 3L, 2L, 1L, 4L, 3L, 1L, 0L, 4L, 4L, 3L, 1L, 0L, 3L, 3L, 0L,
2L, 3L, 1L, 4L, 2L, 3L, 2L, 4L, 2L, 0L, 0L, 3L, 3L, 2L, 3L, 0L,
0L, 1L, 1L, 4L, 3L, 3L, 0L, 3L, 2L, 1L, 3L, 0L, 2L, 1L, 1L, 0L,
2L, 0L, 2L, 0L, 0L, 1L, 2L, 3L, 4L, 0L, 4L, 3L, 2L, 0L, 0L, 3L,
1L, 4L, 3L, 0L, 0L, 0L, 3L, 0L, 3L, 0L, 0L, 3L, 2L, 1L, 0L, 3L,
0L, 0L, 2L, 0L, 1L, 3L, 2L, 3L, 0L, 2L, 0L, 0L, 1L, 2L, 4L, 0L,
2L, 0L, 0L, 0L, 3L, 0L, 4L, 3L, 1L, 0L, 3L, 0L, 4L, 2L, 3L, 1L,
2L, 0L, 4L, 1L, 3L, 4L, 0L, 1L, 3L, 3L, 1L, 3L, 1L, 1L, 0L, 3L,
0L, 1L, 3L, 0L, 4L, 0L, 0L, 2L, 1L, 3L, 3L, 2L, 0L, 3L, 0L, 2L,
2L, 0L, 2L, 2L, 3L, 4L, 1L, 3L, 0L, 3L, 2L, 3L, 0L, 4L, 3L, 0L,
1L, 1L, 3L, 3L, 4L, 0L, 2L, 0L, 0L, 0L, 1L, 1L, 1L, 2L, 3L, 0L,
0L, 1L, 1L, 0L, 2L, 2L, 2L, 3L, 2L, 4L, 1L, 1L, 2L, 1L, 3L, 0L,
0L, 4L, 4L, 4L, 4L, 1L, 0L, 0L, 4L, 0L, 2L, 4L, 1L, 0L, 3L, 4L,
2L, 3L, 2L, 3L, 4L, 1L, 2L, 3L, 1L, 3L, 3L, 0L, 0L, 2L, 3L, 0L,
3L, 0L, 3L, 1L, 3L, 4L, 0L, 1L, 3L, 0L, 1L, 0L, 0L, 2L, 2L, 4L,
3L, 1L, 1L, 0L, 4L, 0L, 0L, 4L, 4L, 4L, 2L, 0L, 1L, 3L, 4L, 3L,
4L, 1L, 4L, 0L, 3L, 4L, 2L, 2L, 3L, 0L, 0L, 0L, 2L, 3L, 2L, 4L,
0L, 0L, 1L, 3L, 4L, 0L, 2L, 0L, 2L, 0L, 4L, 1L, 3L, 3L, 0L, 3L,
0L, 3L, 4L, 0L, 1L, 4L, 0L, 0L, 0L, 0L, 0L, 0L, 4L, 3L, 2L, 2L,
0L, 3L, 4L, 2L, 3L, 1L, 1L, 1L, 3L, 0L, 3L, 2L, 3L, 1L, 1L, 1L,
3L, 0L, 0L, 3L, 0L, 0L, 3L, 3L, 1L, 4L, 1L, 1L, 1L, 1L, 0L, 4L,
4L, 4L, 0L, 0L, 0L, 0L, 1L, 1L, 3L, 3L, 4L, 4L, 1L, 4L, 3L, 3L,
0L, 0L, 3L, 2L, 3L, 4L, 4L, 3L, 0L, 3L, 1L, 2L, 4L, 0L, 0L, 4L,
0L, 0L, 4L, 3L, 0L, 0L, 4L, 2L, 1L, 3L, 3L, 1L, 0L, 0L, 0L, 3L,
1L, 4L, 0L, 0L, 2L, 2L, 3L, 0L, 0L, 1L, 0L, 2L, 0L, 0L, 0L, 4L,
0L, 0L, 0L, 0L, 4L, 1L, 2L, 3L, 3L, 1L, 1L, 2L, 4L, 3L, 1L, 1L,
2L, 2L, 3L, 3L, 4L, 3L, 3L, 0L, 1L, 3L, 0L, 0L, 4L, 0L, 4L, 3L,
4L, 1L, 0L, 0L, 1L, 2L, 2L, 3L, 3L, 2L, 3L, 0L, 4L, 0L, 1L, 2L,
3L, 1L, 0L, 0L, 2L, 4L, 4L, 2L, 0L, 0L, 0L, 1L, 2L, 2L, 0L, 4L,
3L, 2L, 0L, 0L, 0L, 0L, 1L, 2L, 3L, 3L, 1L, 4L, 0L, 2L, 0L, 0L,
1L, 3L, 4L, 0L, 2L, 1L, 4L, 1L, 1L, 4L, 3L, 4L, 3L, 3L, 3L, 1L,
3L, 3L, 0L, 1L, 3L, 0L, 3L, 2L, 4L, 4L, 0L, 4L, 2L, 3L, 3L, 4L,
1L, 3L, 2L, 4L, 0L, 0L, 0L, 3L, 3L, 2L, 1L, 1L, 0L, 0L, 1L, 3L,
1L, 1L, 1L, 0L, 2L, 2L, 3L, 3L, 1L, 0L, 2L, 2L, 1L, 3L, 1L, 1L,
0L, 4L, 3L, 0L, 4L, 3L, 1L, 0L, 4L, 0L, 2L, 0L, 0L, 0L, 2L, 1L,
0L, 4L, 0L, 3L, 2L, 1L, 0L, 4L, 3L, 0L, 3L, 2L, 4L, 3L, 3L, 2L,
3L, 1L, 4L, 2L, 0L, 2L, 3L, 0L, 4L, 2L, 3L, 3L, 2L, 0L, 4L, 2L,
4L, 3L, 1L, 3L, 1L, 2L, 1L, 3L, 3L, 3L, 0L, 3L, 0L, 1L, 4L, 4L,
2L, 2L, 1L, 3L, 1L, 4L, 3L, 0L, 2L, 3L, 0L, 3L, 1L, 0L, 3L, 3L,
0L, 0L, 3L, 1L, 4L, 0L, 1L, 0L, 0L, 1L, 1L, 2L, 0L, 0L, 0L, 3L,
4L, 4L, 2L, 4L, 1L, 4L, 2L, 3L, 3L, 0L, 1L, 3L, 4L, 0L, 3L, 3L,
1L, 0L, 1L, 1L, 3L, 1L, 0L, 3L, 1L, 0L, 3L, 4L, 0L, 0L, 0L, 2L,
2L, 0L, 0L, 2L, 0L, 2L, 4L, 1L, 1L, 0L, 2L, 3L, 3L, 0L, 3L, 0L,
0L, 4L, 0L, 0L, 4L, 1L, 2L, 2L, 2L, 0L, 4L, 3L, 0L, 3L, 0L, 0L,
0L, 4L, 0L, 2L, 3L, 1L, 2L, 3L, 4L, 3L, 2L, 3L, 3L, 2L, 2L, 1L,
3L, 1L, 0L, 0L, 2L, 3L, 1L, 3L, 2L, 3L, 0L, 3L, 3L, 1L, 2L, 3L,
0L, 3L, 3L, 4L, 0L, 0L, 3L, 1L, 4L, 3L, 0L, 1L, 3L, 2L, 3L, 3L,
0L, 1L, 4L, 3L, 1L, 1L, 1L, 3L, 4L, 2L, 3L, 4L, 2L, 3L, 3L, 1L,
0L, 0L, 3L, 2L, 4L, 0L, 0L, 0L, 3L, 3L, 4L, 4L, 3L, 2L, 1L, 0L,
3L, 1L, 0L, 4L, 3L, 1L, 0L, 2L, 0L, 2L, 0L, 0L, 4L, 0L, 0L, 2L,
0L, 0L, 0L, 0L, 3L, 0L, 4L, 3L, 3L, 4L, 3L, 3L, 2L, 1L, 0L, 3L,
4L, 3L, 0L, 3L, 1L, 0L, 1L, 0L, 0L, 3L, 0L, 0L, 2L, 3L, 1L, 1L,
2L, 1L, 0L, 2L, 4L, 1L, 4L, 1L, 4L, 2L, 0L, 3L, 1L, 4L, 3L, 3L,
2L, 2L, 0L, 4L, 2L, 4L, 4L, 2L, 1L, 3L, 4L, 0L, 0L, 2L, 2L, 2L,
3L, 0L, 0L, 2L, 3L, 4L, 0L, 0L, 1L, 0L, 0L, 0L, 3L, 3L, 0L, 1L,
3L, 3L, 1L, 0L, 1L, 3L, 2L, 4L, 3L, 0L, 4L, 4L, 4L, 4L, 3L, 3L,
0L, 0L, 0L, 3L, 0L, 2L, 1L, 3L, 2L, 2L, 1L, 3L, 1L, 2L, 1L, 1L,
0L, 0L, 0L, 3L, 4L, 2L, 2L, 3L, 2L, 2L, 0L, 2L, 1L, 3L, 0L, 2L,
3L, 0L, 0L, 3L, 1L, 3L, 3L, 3L, 0L, 3L, 3L, 3L, 0L, 0L, 4L, 3L,
0L, 2L, 3L, 3L, 4L, 2L, 4L, 0L, 2L, 3L, 0L, 2L, 3L, 0L, 3L, 0L,
0L, 3L, 0L, 1L, 3L, 2L, 2L, 2L, 2L, 0L, 0L, 1L, 1L, 0L, 2L, 2L,
0L, 3L, 0L, 2L, 0L, 1L, 4L, 0L, 4L, 2L, 4L, 4L, 1L, 3L, 3L, 4L,
4L, 0L, 3L, 3L, 3L, 3L, 0L, 3L, 3L, 3L, 0L, 2L, 1L, 0L, 1L, 0L,
1L, 4L, 3L, 2L, 2L, 0L, 0L, 2L, 1L, 0L, 1L, 3L, 4L, 4L, 3L, 3L,
0L, 3L, 2L, 1L, 1L, 1L, 0L, 4L, 2L, 0L, 4L, 4L, 4L, 1L, 3L, 4L,
3L, 2L, 4L, 2L, 2L, 0L, 2L, 1L, 3L, 1L, 0L, 2L, 3L, 2L, 2L, 3L,
1L, 3L, 0L, 0L, 0L, 4L, 2L, 0L, 0L, 0L, 2L, 3L, 4L, 4L, 3L, 0L,
0L, 2L, 4L, 3L, 3L, 2L, 3L, 2L, 4L, 0L, 0L, 3L, 0L, 3L, 3L, 2L,
3L, 2L, 2L, 2L, 2L, 0L, 2L, 3L, 3L, 1L, 0L, 3L, 0L, 2L, 3L, 1L,
4L, 2L, 0L, 4L, 3L, 3L, 4L, 4L, 4L, 4L, 3L, 0L, 3L, 0L, 0L, 1L,
2L, 0L, 4L, 1L, 3L, 3L, 2L, 4L, 0L, 0L, 1L, 1L, 0L, 3L, 4L, 4L,
3L, 0L, 4L, 2L, 3L, 1L, 1L, 2L, 3L, 0L, 2L, 2L, 3L, 0L, 3L, 0L,
4L, 2L, 3L, 1L, 3L, 3L, 4L, 3L, 0L, 2L, 1L, 0L, 1L, 0L, 3L, 1L,
2L, 3L, 1L, 1L, 3L, 1L, 3L, 0L, 0L, 2L, 1L, 0L, 3L, 4L, 4L, 1L,
1L, 2L, 0L, 3L, 3L, 3L, 2L, 1L, 0L, 0L, 0L, 0L, 3L, 3L, 2L, 0L,
3L, 3L, 2L, 1L, 1L, 1L, 3L, 2L, 3L, 0L, 3L, 0L, 3L, 4L, 2L, 1L,
4L, 0L, 4L, 2L, 3L, 0L, 3L, 4L, 2L, 3L, 4L, 4L, 2L, 4L, 3L, 4L,
2L, 4L, 2L, 3L, 4L, 1L, 1L, 4L, 0L, 0L, 4L, 2L, 0L, 3L, 3L, 3L,
2L, 4L, 4L, 0L, 3L, 0L, 3L, 2L, 4L, 1L, 2L, 3L, 1L, 0L, 4L, 0L,
4L, 0L, 0L, 3L, 1L, 1L, 2L, 0L, 3L, 2L, 0L, 0L, 1L, 0L, 0L, 3L,
1L, 1L, 2L, 0L, 2L, 0L, 3L, 3L, 1L, 2L, 1L, 1L, 1L, 2L, 4L, 0L,
1L, 0L, 1L, 0L, 0L, 2L, 2L, 0L, 2L, 0L, 1L, 1L, 0L, 4L, 0L, 0L,
0L, 0L, 0L, 1L, 1L, 0L, 3L, 1L, 1L, 2L, 0L, 0L, 2L, 0L, 2L, 0L,
2L, 1L, 1L, 2L, 0L, 2L, 2L, 4L, 0L, 0L, 1L, 3L, 1L, 3L, 2L, 2L,
1L, 1L, 4L, 1L, 1L, 1L, 0L, 1L, 2L, 4L, 3L, 2L, 3L, 0L, 2L, 1L,
1L, 1L, 0L, 4L, 1L, 1L, 2L, 1L, 2L, 1L, 4L, 2L, 3L, 1L, 0L, 1L,
0L, 3L, 2L, 0L, 1L, 2L, 4L, 4L, 3L, 0L, 2L, 1L, 0L, 2L, 1L, 0L,
2L, 2L, 1L, 0L, 2L, 2L, 2L, 0L, 1L, 2L, 1L, 1L, 4L, 2L, 1L, 1L,
1L, 1L, 1L, 3L, 0L, 1L, 1L, 2L, 0L, 0L, 0L, 1L, 1L, 2L, 0L, 0L,
3L, 1L, 1L, 3L, 2L, 4L, 3L, 0L, 4L, 3L, 1L, 0L, 0L, 2L, 1L, 0L,
0L, 2L, 0L, 2L, 4L, 0L, 2L, 3L, 4L, 2L, 3L, 1L, 0L, 4L, 4L, 0L,
0L, 2L, 2L, 0L, 3L, 4L, 2L, 4L, 0L, 1L, 1L, 3L, 1L, 2L, 0L, 3L,
1L, 2L, 1L, 0L, 3L, 2L, 4L, 2L, 4L, 1L, 2L, 3L, 1L, 4L, 1L, 2L,
1L, 1L, 0L, 2L, 2L, 3L, 0L, 4L, 1L, 3L, 1L, 2L, 0L, 0L, 4L, 1L,
2L, 4L, 1L, 0L, 1L, 2L, 0L, 1L, 0L, 1L, 1L, 1L, 2L, 1L, 4L, 0L,
1L, 2L, 3L, 1L, 4L, 1L, 1L, 0L, 0L, 1L, 2L, 0L, 4L, 0L, 2L, 2L,
0L, 4L, 1L, 1L, 1L, 4L, 0L, 3L, 3L, 1L, 1L, 1L, 0L, 4L, 3L, 0L,
3L, 0L, 3L, 0L, 2L, 1L, 0L, 2L, 2L, 1L, 0L, 3L, 0L, 4L, 2L, 2L,
2L, 1L, 2L, 2L, 0L, 2L, 0L, 0L, 2L, 0L, 2L, 0L, 3L, 3L, 0L, 0L,
1L, 4L, 0L, 3L, 0L, 3L, 0L, 0L, 2L, 0L, 1L, 0L, 2L, 1L, 0L, 3L,
1L, 0L, 0L, 1L, 0L, 2L, 0L, 4L, 1L, 2L, 0L, 1L, 3L, 0L, 0L, 1L,
2L, 3L, 4L, 0L, 0L, 1L, 3L, 2L, 1L, 4L, 3L, 1L, 2L, 3L, 2L, 4L,
2L, 2L, 4L, 0L, 2L, 1L, 0L, 3L, 0L, 2L, 2L, 1L, 1L, 0L, 3L, 4L,
2L, 0L, 1L, 3L, 4L, 0L, 2L, 2L, 1L, 1L, 0L, 0L, 4L, 1L, 0L, 0L,
1L, 2L, 1L, 1L, 4L, 3L, 0L, 1L, 1L, 1L, 0L, 2L, 2L, 0L, 2L, 1L,
4L, 1L, 3L, 1L, 1L, 0L, 1L, 1L, 4L, 0L, 4L, 1L, 0L, 0L, 1L, 2L,
2L, 2L, 2L, 1L, 1L, 0L, 2L, 2L, 0L, 0L, 4L, 4L, 1L, 0L, 0L, 1L,
4L, 1L, 3L, 0L, 4L, 0L, 2L, 1L, 1L, 2L, 1L, 1L, 2L, 2L, 4L, 1L,
4L, 2L, 1L, 1L, 4L, 1L, 1L, 4L, 2L, 0L, 3L, 0L, 1L, 0L, 0L, 1L,
3L, 2L, 0L, 0L, 3L, 3L, 0L, 1L, 1L, 4L, 3L, 4L, 2L, 0L, 0L, 2L,
2L, 1L, 1L, 4L, 0L, 2L, 2L, 1L, 2L, 3L, 0L, 0L, 4L, 2L, 2L, 3L,
3L, 1L, 2L, 3L, 3L, 1L, 0L, 1L, 1L, 2L, 3L, 0L, 4L, 0L, 1L, 1L,
0L, 1L, 1L, 2L, 3L, 2L, 1L, 1L, 0L, 2L, 1L, 2L, 2L, 0L, 0L, 2L,
2L, 0L, 2L, 3L, 1L, 1L, 0L, 1L, 0L, 0L, 0L, 0L, 3L, 0L, 4L, 0L,
0L, 1L, 0L, 0L, 1L, 3L, 0L, 2L, 3L, 3L, 0L, 1L, 0L, 0L, 0L, 3L,
0L, 1L, 0L, 2L, 0L, 0L, 3L, 1L, 0L, 2L, 2L, 2L, 3L, 1L, 3L, 4L,
4L, 0L, 3L, 0L, 1L, 2L, 2L, 0L, 3L, 3L, 2L, 2L, 0L, 4L, 0L, 2L,
0L, 2L, 1L, 3L, 0L, 0L, 0L, 0L, 2L, 0L, 2L, 2L, 3L, 3L, 1L, 1L,
1L, 2L, 3L, 3L, 1L, 0L, 3L, 2L, 4L, 3L, 0L, 2L, 3L, 3L, 2L, 1L,
0L, 0L, 0L, 2L, 1L, 3L, 2L, 0L, 2L, 1L, 0L, 1L, 2L, 3L, 0L, 2L,
2L, 0L, 3L, 2L, 3L, 2L, 4L, 2L, 0L, 2L, 0L, 0L, 1L, 2L, 1L, 4L,
1L, 0L, 2L, 0L, 2L, 0L, 2L, 0L, 3L, 1L, 2L, 4L, 4L, 0L, 4L, 2L,
0L, 3L, 0L, 0L, 0L, 2L, 0L, 4L, 3L, 3L, 0L, 2L, 2L, 2L, 0L, 1L,
2L, 1L, 2L, 0L, 0L, 1L, 3L, 3L, 1L, 1L, 0L, 0L, 4L, 0L, 3L, 0L,
1L, 2L, 0L, 0L, 2L, 2L, 2L, 2L, 2L, 3L, 2L, 1L, 1L, 0L, 0L, 2L,
0L, 1L, 1L, 1L, 0L, 1L, 0L, 1L, 2L, 0L, 1L, 2L, 0L, 2L, 0L, 1L,
2L, 2L, 2L, 0L, 3L, 2L, 3L, 0L, 0L, 1L, 2L, 1L, 3L, 4L, 4L, 0L,
0L, 4L, 0L, 1L, 1L, 1L, 2L, 1L, 3L, 4L, 2L, 0L, 3L, 1L, 1L, 1L,
0L, 2L, 2L, 0L, 4L, 0L, 3L, 0L, 0L, 3L, 4L, 2L, 0L, 2L, 1L, 2L,
0L, 3L, 2L, 2L, 2L, 0L, 3L, 0L, 2L, 2L, 0L, 1L, 1L, 0L, 2L, 1L,
2L, 0L, 2L, 0L, 1L, 2L, 1L, 1L, 0L, 2L, 2L, 2L, 0L, 0L, 2L, 2L,
2L, 0L, 4L, 1L, 3L, 1L, 1L, 4L, 2L, 3L, 3L, 1L, 1L, 1L, 2L, 0L,
3L, 2L, 3L, 3L, 0L, 2L, 1L, 2L, 1L, 0L, 0L, 3L, 2L, 3L, 2L, 3L,
2L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 2L, 2L, 3L, 0L, 0L, 2L, 2L, 0L,
1L, 0L, 2L, 1L, 4L, 1L, 0L, 0L, 2L, 0L, 3L, 2L, 2L, 0L, 2L, 2L,
3L, 3L, 3L, 4L, 0L, 1L, 1L, 3L, 4L, 2L, 4L, 2L, 2L, 1L, 3L, 2L,
1L, 2L, 2L, 1L, 3L, 1L, 1L, 3L, 2L, 2L, 1L, 2L, 1L, 2L, 0L, 1L,
2L, 1L, 2L, 1L, 2L, 1L, 2L, 4L, 1L, 0L, 0L, 2L, 2L, 0L, 2L, 3L,
1L, 0L, 3L, 2L, 1L, 2L, 2L, 0L, 2L, 2L, 0L, 0L, 1L, 0L, 4L, 0L,
3L, 4L, 1L, 3L, 0L, 1L, 2L, 1L, 0L, 1L, 0L, 0L, 0L, 1L, 3L, 0L,
0L, 1L, 2L, 3L, 3L, 1L, 3L, 3L, 2L, 3L, 0L, 4L, 2L, 3L, 4L, 3L,
2L, 1L, 3L, 2L, 0L, 2L, 3L, 2L, 0L, 3L, 4L, 3L, 1L, 2L, 3L, 2L,
3L, 2L, 3L, 2L, 3L, 1L, 0L, 2L, 2L, 3L, 4L, 0L, 2L, 0L, 0L, 0L,
0L, 2L, 3L, 0L, 0L, 1L, 3L, 2L, 2L, 0L, 0L, 1L, 3L, 3L, 0L, 0L,
4L, 0L, 0L, 3L, 3L, 2L, 1L, 2L, 4L, 0L, 3L, 1L, 2L, 2L, 0L, 0L,
3L, 1L, 3L, 1L, 0L, 3L, 4L, 3L, 3L, 3L, 4L, 0L, 1L, 2L, 2L, 1L,
2L, 0L, 1L, 3L, 4L, 4L, 0L, 0L, 0L, 3L, 1L, 0L, 2L, 1L, 2L, 3L,
3L, 2L, 2L, 2L, 0L, 2L, 2L, 3L, 3L, 2L, 1L, 2L, 2L, 1L, 2L, 2L,
3L, 3L, 2L, 3L, 1L, 2L, 4L, 3L, 2L, 0L, 2L, 1L, 0L, 2L, 3L, 4L,
2L, 0L, 4L, 2L, 1L, 1L, 0L, 3L, 2L, 0L, 2L, 1L, 3L, 1L, 2L, 2L,
0L, 4L, 3L, 1L, 4L, 0L, 3L, 1L, 0L, 1L, 3L, 1L, 1L, 2L, 1L, 0L,
2L, 1L, 3L, 1L, 2L, 1L, 2L, 4L, 4L, 0L, 3L, 3L, 1L, 0L, 0L, 1L,
1L, 0L, 4L, 1L, 2L, 1L, 4L, 1L, 4L, 4L, 0L, 3L, 3L, 2L, 2L, 1L,
3L, 4L, 0L, 0L, 2L, 3L, 2L, 2L, 2L, 0L, 2L, 2L, 1L, 2L, 2L, 0L,
2L, 3L, 0L, 1L, 0L, 0L, 0L, 3L, 2L, 0L, 3L, 2L, 0L, 0L, 1L, 3L,
4L, 3L, 0L, 0L, 3L, 2L, 3L, 3L, 0L, 0L, 0L, 2L, 2L, 0L, 4L, 2L,
2L, 2L, 3L, 2L, 2L, 4L, 1L, 1L, 1L, 3L, 2L, 3L, 1L, 2L, 3L, 2L,
2L, 4L, 1L, 3L, 3L, 0L, 1L, 1L, 2L, 3L, 3L, 2L, 4L, 1L, 1L, 2L,
4L, 0L, 2L, 1L, 1L, 2L, 4L, 0L, 1L, 3L, 1L, 0L, 2L, 2L, 0L, 0L,
2L, 3L, 1L, 1L, 1L, 2L, 3L, 3L, 1L, 4L, 0L, 1L, 0L, 2L, 0L, 1L,
3L, 3L, 4L, 0L, 4L, 4L, 1L, 1L, 1L, 2L, 1L, 3L, 4L, 3L, 0L, 3L,
1L, 2L, 1L, 1L, 0L, 2L, 1L, 1L, 1L, 3L, 0L, 3L, 3L, 1L, 1L, 2L,
1L, 2L, 2L, 1L, 0L, 1L, 2L, 1L, 4L, 1L, 0L, 1L, 4L, 2L, 1L, 4L,
1L, 4L, 4L, 1L, 3L, 0L, 2L, 0L, 3L, 1L, 4L, 1L, 3L, 4L, 3L, 2L,
2L, 3L, 1L, 1L, 2L, 4L, 1L, 0L, 2L, 2L, 3L, 0L, 1L, 1L, 4L, 1L,
2L, 3L, 4L, 1L, 1L, 1L, 4L, 0L, 0L, 0L, 0L, 0L, 3L, 2L, 4L, 2L,
2L, 3L, 2L, 3L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 0L, 0L, 1L,
2L, 2L, 1L, 3L, 1L, 1L, 1L, 2L, 0L, 2L, 2L, 1L, 3L, 3L, 3L, 2L,
3L, 1L, 3L, 1L, 1L, 0L, 3L, 2L, 3L, 0L, 2L, 0L, 0L, 1L, 1L, 3L,
2L, 2L, 3L, 1L, 1L, 1L, 2L, 2L, 0L, 1L, 2L, 2L, 2L, 1L, 1L, 1L,
1L, 2L, 0L, 2L, 0L, 3L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 4L, 3L, 2L,
1L, 1L, 2L, 2L, 2L, 0L, 4L, 1L, 1L, 3L, 3L, 2L, 1L, 1L, 2L, 4L,
1L, 1L, 2L, 4L, 0L, 1L, 1L, 1L, 0L, 1L, 2L, 3L, 3L, 2L, 1L, 2L,
2L, 0L, 1L, 1L, 2L, 1L, 4L, 4L, 1L, 3L, 3L, 1L, 1L, 1L, 2L, 2L,
3L, 2L, 1L, 2L, 2L, 2L, 2L, 0L, 1L, 1L, 2L, 0L, 2L, 0L, 1L, 2L,
0L, 3L, 2L, 3L, 2L, 2L, 2L, 0L, 3L, 2L, 2L, 2L, 2L, 1L, 1L, 1L,
1L, 4L, 1L, 1L, 3L, 2L, 4L, 1L, 1L, 1L, 1L, 1L, 0L, 1L, 0L, 0L,
2L, 1L, 2L, 1L, 1L, 0L, 0L, 2L, 2L, 1L, 1L, 0L, 2L, 0L, 0L, 1L,
1L, 1L, 0L, 0L, 2L, 2L, 4L, 2L, 3L, 4L, 4L, 0L, 2L, 2L, 4L, 0L,
3L, 2L, 1L, 2L, 1L, 3L, 3L, 1L, 1L, 1L, 2L, 1L, 1L, 3L, 3L, 2L,
3L, 3L, 0L, 1L, 3L, 0L, 2L, 1L, 2L, 1L, 1L, 1L, 3L, 2L, 2L, 3L,
3L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 3L, 0L, 1L, 1L, 0L, 1L,
1L, 1L, 1L, 2L, 2L, 0L, 1L, 1L, 1L, 2L, 3L, 1L, 1L, 3L, 2L, 1L,
1L, 1L, 3L, 1L, 1L, 0L, 1L, 1L, 2L, 3L, 1L, 2L, 2L, 1L, 1L, 0L,
1L, 2L, 0L, 1L, 0L, 1L, 0L, 0L, 4L, 0L, 1L, 0L, 0L, 1L, 2L, 4L,
2L, 1L, 1L, 2L, 3L, 2L, 1L, 2L, 3L, 0L, 2L, 1L, 1L, 2L, 1L, 1L,
2L, 3L, 2L, 0L, 1L, 1L, 3L, 1L, 3L, 3L, 2L, 3L, 2L, 1L, 3L, 2L,
2L, 2L, 2L, 1L, 2L, 3L, 1L, 1L, 1L, 2L, 2L, 2L, 1L, 1L, 2L, 1L,
2L, 2L, 3L, 3L, 3L, 1L, 1L, 4L, 1L, 1L, 2L, 0L, 3L, 1L, 2L, 2L,
2L, 4L, 2L, 0L, 0L, 2L, 1L, 2L, 4L, 2L, 1L, 0L, 1L, 2L, 0L, 2L,
2L, 1L, 1L, 2L, 3L, 3L, 0L, 3L, 0L, 2L, 1L, 1L, 1L, 1L, 3L, 1L,
1L, 3L, 3L, 1L, 0L, 2L, 1L, 3L, 0L, 2L, 2L, 1L, 1L, 0L, 4L, 2L,
1L, 0L, 0L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 1L, 2L, 2L, 1L, 2L, 1L,
1L, 2L, 2L, 4L, 4L, 2L, 2L, 3L, 3L, 3L, 0L, 1L, 1L, 2L, 2L, 4L,
1L, 3L, 1L, 3L, 2L, 2L, 1L, 3L, 2L, 2L, 1L, 3L, 1L, 4L, 3L, 1L,
3L, 4L, 3L, 2L, 2L, 1L, 4L, 3L, 3L, 1L, 3L, 3L, 2L, 4L, 4L, 0L,
3L, 3L, 1L, 2L, 4L, 0L, 4L, 1L, 1L, 3L, 3L, 2L, 4L, 3L, 1L, 3L,
3L, 2L, 0L, 0L, 2L, 4L, 4L, 4L, 3L, 2L, 2L, 3L, 4L, 3L, 3L, 2L,
4L, 2L, 4L, 1L, 0L, 4L, 1L, 2L, 2L, 3L, 4L, 3L, 2L, 2L, 2L, 4L,
2L, 0L, 3L, 3L, 0L, 1L, 0L, 2L, 2L, 3L, 2L, 0L, 1L, 2L, 3L, 3L,
4L, 4L, 3L, 1L, 3L, 2L, 3L, 4L, 4L, 2L, 1L, 1L, 1L, 2L, 1L, 0L,
4L, 4L, 4L, 2L, 1L, 4L, 4L, 2L, 3L, 3L, 4L, 1L, 2L, 3L, 1L, 1L,
4L, 3L, 1L, 0L, 4L, 1L, 4L, 1L, 4L, 4L, 4L, 4L, 1L, 1L, 1L, 0L,
3L, 1L, 4L, 1L, 3L, 1L, 4L, 2L, 1L, 1L, 1L, 1L, 1L, 4L, 4L, 3L,
4L, 1L, 4L, 1L, 2L, 1L, 0L, 4L, 3L, 0L, 1L, 4L, 3L, 0L, 4L, 1L,
4L, 1L, 0L, 4L, 1L, 1L, 1L, 1L, 1L, 1L, 3L, 0L, 2L, 1L, 1L, 1L,
0L, 2L, 1L, 4L, 4L, 3L, 1L, 3L, 1L, 4L, 1L, 4L, 4L, 4L, 0L, 3L,
0L, 4L, 4L, 0L, 3L, 2L, 4L, 4L, 1L, 4L, 4L, 1L, 3L, 2L, 0L, 1L,
1L, 0L, 1L, 4L, 1L, 4L, 4L, 4L, 1L, 4L, 1L, 4L, 4L, 1L, 1L, 2L,
4L, 3L, 4L, 4L, 2L, 0L, 1L, 3L, 4L, 4L, 1L, 3L, 2L, 3L, 0L, 1L,
1L, 0L, 0L, 1L, 2L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 0L, 3L, 1L, 2L,
1L, 1L, 2L, 3L, 0L, 1L, 1L, 0L, 1L, 1L, 1L, 1L, 1L, 0L, 1L, 3L,
1L, 2L, 1L, 3L, 2L, 0L, 1L, 1L, 2L, 1L, 1L, 1L, 3L, 1L, 1L, 0L,
3L, 1L, 1L, 0L, 1L, 1L, 1L, 0L, 1L, 3L, 1L, 1L, 3L, 1L, 1L, 3L,
1L, 1L, 0L, 1L, 0L, 1L, 1L, 1L, 1L, 3L, 2L, 2L, 0L, 3L, 3L, 1L,
3L, 3L, 2L, 2L, 1L, 2L, 4L, 2L, 0L, 1L, 2L, 3L, 3L, 1L, 1L, 4L,
3L, 2L, 3L, 3L, 3L, 1L, 1L, 1L, 1L, 4L, 1L, 1L, 4L, 1L, 1L, 1L,
2L, 2L, 2L, 3L, 2L, 2L, 1L, 3L, 0L, 3L, 2L, 3L, 3L, 3L, 1L, 4L,
3L, 3L, 3L, 2L, 3L, 2L, 2L, 1L, 1L, 3L, 2L, 2L, 1L, 1L, 3L, 3L,
3L, 1L, 2L, 0L, 4L, 1L, 3L, 3L, 0L, 3L, 2L, 3L, 3L, 1L, 3L, 2L,
2L, 2L, 3L, 1L, 0L, 3L, 1L, 3L, 0L, 1L, 2L, 3L, 2L, 2L, 2L, 3L,
2L, 3L, 4L, 2L, 1L, 1L, 3L, 1L, 0L, 1L, 3L, 1L, 3L, 2L, 2L, 4L,
2L, 3L, 1L, 2L, 0L, 2L, 2L, 3L, 1L, 2L, 2L, 2L, 2L, 1L, 2L, 3L,
4L, 1L, 3L, 2L, 2L, 3L, 2L, 2L, 2L, 0L, 3L, 2L, 2L, 0L, 3L, 2L,
1L, 1L, 3L, 0L, 3L, 2L, 0L, 3L, 2L, 1L, 1L, 1L, 3L, 0L, 1L, 2L,
3L, 0L, 3L, 2L, 1L, 0L, 3L, 1L, 2L, 0L, 2L, 3L, 1L, 2L, 2L, 2L,
3L, 2L, 2L, 1L, 1L, 1L, 3L, 0L, 4L, 3L, 4L, 2L, 2L, 1L, 3L, 2L,
3L, 3L, 1L, 2L, 1L, 0L, 2L, 1L, 3L, 2L, 1L, 2L, 1L, 1L, 1L, 1L,
1L, 1L, 2L, 1L, 2L, 2L, 2L, 1L, 2L, 1L, 3L, 2L, 2L, 2L, 2L, 3L,
0L, 2L, 3L, 2L, 3L, 1L, 2L, 2L, 2L, 1L, 1L, 2L, 4L, 1L, 2L, 3L,
3L, 3L, 2L, 2L, 3L, 0L, 0L, 0L, 1L, 1L, 1L, 0L, 0L, 0L, 0L, 2L,
2L, 2L, 0L, 2L, 1L, 1L, 2L, 1L, 2L, 2L, 1L, 0L, 0L, 1L, 1L, 0L,
0L, 2L, 2L, 1L, 0L, 1L, 0L, 0L, 1L, 1L, 1L, 1L, 1L, 0L, 2L, 1L,
3L, 1L, 1L, 1L, 1L, 1L, 0L, 0L, 2L, 1L, 1L, 2L, 1L, 2L, 3L, 1L,
2L, 2L, 0L, 0L, 1L, 2L, 0L, 2L, 1L, 1L, 2L, 2L, 3L, 3L, 0L, 0L,
2L, 0L, 4L, 3L, 0L, 3L, 1L, 3L, 3L, 2L, 3L, 3L, 2L, 4L, 3L, 3L,
2L, 1L, 2L, 3L, 3L, 2L, 2L, 1L, 4L, 3L, 2L, 4L, 3L, 2L, 4L, 3L,
3L, 2L, 4L, 3L, 4L, 2L, 3L, 3L, 2L, 2L, 3L, 2L, 3L, 2L, 3L, 3L,
3L, 3L, 1L, 0L, 3L, 2L, 1L, 1L, 3L, 3L, 1L, 2L, 2L, 0L, 1L, 2L,
3L, 1L, 0L, 2L, 1L, 4L, 3L, 2L, 4L, 2L, 3L, 2L, 4L, 3L, 4L, 3L,
3L, 3L, 3L, 4L, 4L, 3L, 4L, 3L, 2L, 3L, 2L, 3L, 3L, 1L, 3L, 1L,
4L, 3L, 2L, 4L, 3L, 4L, 3L, 4L, 3L, 3L, 3L, 4L, 2L, 4L, 2L, 2L,
0L, 2L, 1L, 1L, 2L, 1L, 0L, 4L, 3L, 1L, 1L, 3L, 1L, 2L, 1L, 1L,
1L, 1L, 1L, 2L, 3L, 2L, 1L, 4L, 1L, 3L, 2L, 0L, 1L, 2L, 0L, 2L,
0L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 0L, 1L, 4L, 1L, 1L,
3L, 1L, 2L, 0L, 0L, 1L, 1L, 1L, 1L, 1L, 0L, 2L, 1L, 0L, 1L, 1L,
3L, 0L, 3L, 4L, 2L, 3L, 0L, 1L, 1L, 2L, 2L, 1L, 0L, 4L, 1L, 1L,
2L, 2L, 0L, 1L, 1L, 1L, 1L, 2L, 2L, 3L, 2L, 3L, 1L, 0L, 0L, 1L,
1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 0L, 1L, 3L, 1L, 1L, 1L, 1L, 4L,
1L, 4L, 0L, 3L, 1L, 2L, 0L, 1L, 1L, 4L, 1L, 0L, 3L, 2L, 1L, 1L,
1L, 1L, 4L, 1L, 0L, 2L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
2L, 1L, 1L, 3L, 3L, 1L, 1L, 1L, 2L, 2L, 1L, 3L, 1L, 1L, 0L, 1L,
0L, 2L, 0L, 1L, 1L, 1L, 1L, 2L, 0L, 1L, 2L, 1L, 0L, 4L, 1L, 1L,
2L, 1L, 1L, 1L, 1L, 3L, 1L, 1L, 0L, 2L, 1L, 1L, 1L, 1L, 4L, 1L,
1L, 1L, 1L, 0L, 0L, 1L, 3L, 0L, 0L, 1L, 0L, 4L, 2L, 1L, 2L, 1L,
2L, 1L, 0L, 1L, 1L, 3L, 0L, 0L, 1L, 1L, 2L, 1L, 2L, 0L, 1L, 1L,
1L, 1L, 2L, 0L, 1L, 1L, 1L, 3L, 1L, 1L, 2L, 1L, 1L, 2L, 2L, 1L,
2L, 1L, 1L, 0L, 2L, 0L, 1L, 1L, 0L, 0L, 3L, 1L, 1L, 0L, 1L, 1L,
0L, 1L, 1L, 2L, 1L, 3L, 1L, 1L, 0L, 3L, 2L, 3L, 1L, 1L, 1L, 0L,
4L, 1L, 2L, 4L, 1L, 1L, 0L, 1L, 3L, 1L, 1L, 1L, 1L, 1L, 0L, 1L,
2L, 2L, 1L, 1L, 1L, 4L, 3L, 1L, 4L, 2L, 2L, 1L, 1L, 0L, 1L, 1L,
2L, 2L, 2L, 0L, 0L, 1L, 3L, 1L, 1L, 1L, 0L, 1L, 1L, 1L, 0L, 2L,
0L, 3L, 1L, 1L, 0L, 0L, 1L, 0L, 1L, 1L, 1L, 0L, 1L, 2L, 4L, 1L,
0L, 2L, 1L, 1L, 0L, 3L, 1L, 1L, 1L, 1L, 0L, 0L, 1L, 3L), mmrcs = c(0.25,
0.75, 0.25, 0.5, 0.5, 0.5, 0.75, 0.5, 0.5, 0.5, 0.75, 0.5, 0.75,
0.75, 0.5, 0.5, 0.5, 0.5, 0.75, 0.5, 0.5, 0.75, 0.75, 0.5, 0.25,
0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.75, 0.75, 0.75, 0.5, 0.25, 0.5,
0.75, 0.5, 0.25, 0.5, 0.25, 0.25, 0.5, 0.25, 0.5, 0.25, 0.25,
0.5, 0.5, 0.5, 0.75, 0.5, 0.5, 1, 0.25, 0, 0, 0, 0.25, 0, 0.25,
1, 0.25, 0, 0, 0.5, 0.25, 1, 0, 0, 0.25, 0.25, 0, 0, 0, 0.25,
0.25, 0, 0.5, 1, 0.25, 0.25, 0.25, 1, 0, 0.25, 0.25, 1, 0, 1,
0, 0, 0.25, 0, 0.5, 0, 0, 0.25, 0, 0, 0.25, 0.5, 0.25, 0.5, 0,
0, 0.25, 0, 0, 0.25, 0.25, 0.25, 0.25, 0, 0.25, 0.5, 1, 0.5,
0, 0.5, 0.25, 1, 0, 0.25, 0, 0.25, 0.25, 0.25, 0, 0.25, 0.25,
0.25, 0.25, 0, 0, 0.25, 0, 0, 0, 1, 0.25, 0.25, 0, 0, 0, 1, 0.25,
0, 0.25, 0, 1, 0, 0.25, 0, 0, 0, 0, 0.25, 0.25, 0.25, 0, 0.25,
0, 0, 0.25, 0, 1, 0.25, 0.25, 0.25, 1, 1, 1, 0, 0, 0.25, 0.25,
1, 0, 0, 0.25, 0, 0, 0.25, 0, 0, 0.5, 0.25, 0.25, 0.5, 0.25,
1, 0, 0, 1, 0.5, 0, 1, 0.25, 0, 0.25, 1, 0.25, 0.25, 0, 0, 1,
0.25, 0.25, 0.25, 1, 0, 0, 0.5, 0.25, 0, 0, 0, 0.25, 0.25, 1,
0.25, 0.5, 0.25, 0.25, 1, 0, 0, 0.5, 0.25, 1, 0.25, 0.25, 0.5,
0.25, 1, 0.25, 0.25, 0.25, 0.25, 0.5, 0.5, 0.25, 0, 0, 0.5, 0.25,
0.25, 0, 0.25, 0.25, 0, 0, 0, 0.5, 0.5, 1, 0, 0.5, 0, 0, 0.5,
0, 0.5, 0, 0, 0, 0.25, 0, 0, 0, 0.25, 0, 0, 0.25, 0.25, 1, 0,
0, 0, 0.5, 0, 0, 0.25, 0.25, 0, 0.25, 0, 0, 0, 0, 0.25, 0.25,
0, 0, 0.25, 0, 0.25, 0, 0.25, 0.25, 1, 0.5, 0, 0.25, 0, 0, 0,
0.25, 0.25, 0.25, 0, 0.25, 1, 0.5, 0.5, 0.25, 0.5, 0.25, 0.25,
0.5, 0, 0, 0.5, 0, 0, 0.25, 0, 0, 0, 0.25, 1, 0.25, 0, 0.25,
0.25, 0, 0, 0, 0.25, 0.25, 0.25, 1, 0, 0.25, 0, 0.5, 0.5, 0.25,
0, 1, 0.25, 0.5, 0.25, 0, 0.25, 0.25, 0, 0.25, 1, 0.25, 1, 0,
0.25, 0.25, 0.25, 1, 0.25, 0.5, 0.25, 0, 0, 0.25, 0.25, 0.25,
0, 0.5, 0, 0, 0, 0.25, 0.25, 1, 0.25, 0, 0.25, 0, 0, 0.25, 1,
0, 0.25, 0.25, 0.25, 0.25, 1, 1, 0.25, 0, 0, 0, 0, 0, 0.5, 0.25,
0, 0.25, 0, 0.25, 0, 0.5, 0.25, 1, 0, 0, 0, 0.25, 0.5, 0, 0.25,
0, 1, 0.25, 0.25, 0, 0, 0.25, 0.25, 0, 1, 0, 0, 0.25, 0, 0, 1,
0.25, 0.25, 0.5, 0, 0.25, 0, 0.25, 1, 0.25, 0.25, 1, 0.25, 0,
0, 0, 0, 1, 0.25, 0.25, 0, 1, 0, 0, 0.25, 0.25, 0.5, 0, 0.25,
0, 0, 0.25, 0, 1, 0, 0, 0, 0, 0.25, 0.25, 0.5, 1, 0, 0, 0.25,
0, 0.5, 0.25, 0.25, 0, 0, 1, 1, 0, 0.25, 0, 0.25, 0.25, 0.25,
0.25, 0.25, 0.25, 0, 0, 0, 0.25, 0.25, 0.25, 0.5, 0.25, 0, 0.25,
0, 0, 0, 0.25, 0.25, 0.25, 1, 0.25, 0, 0, 0.5, 0, 0, 0.25, 1,
1, 0.5, 0, 0, 0.25, 0, 0.25, 0.25, 0.25, 0.5, 0.25, 0, 0.5, 1,
0, 0, 0.25, 1, 0.5, 0, 0, 0, 0.25, 0, 0.25, 1, 0, 0.5, 0.25,
0.25, 0.25, 0, 0, 0.25, 0.25, 0.25, 0, 0.25, 0.5, 0, 0, 0.25,
0, 1, 0.25, 1, 0, 0.25, 0.25, 1, 0, 1, 0, 0.25, 0.25, 0.5, 0.25,
0.25, 0.25, 0.5, 0.25, 0.5, 0, 1, 1, 0, 0.25, 0.5, 0.5, 0.25,
0, 0.25, 0.25, 1, 0.25, 1, 0, 0, 0, 0.5, 0, 0.5, 0, 0.5, 0.25,
0.25, 0.25, 0, 0, 0.25, 1, 0.25, 0.25, 1, 0.25, 0, 1, 0, 0, 0.5,
0.5, 0, 0, 0.25, 1, 0.25, 0, 0, 0, 0.25, 0, 0, 0, 0, 1, 0.25,
0, 0.5, 0, 1, 0.25, 1, 0, 0.5, 0, 1, 0, 0, 0, 0.25, 0.25, 0,
0, 0.5, 1, 0, 0, 1, 0.25, 0.25, 1, 0, 0, 0.25, 0.5, 0, 0, 0.25,
0, 0, 0, 0, 0.5, 0, 0, 0.25, 0.5, 0, 0.25, 0, 0, 0, 0.5, 0.5,
0, 0.25, 0, 0, 0.25, 0, 0, 1, 0, 0.5, 0.5, 0.25, 0, 0, 0, 0.25,
0.25, 1, 0, 0.5, 0, 0.25, 0.25, 0.25, 0, 0, 0, 0, 0.25, 1, 0,
0.25, 0, 0.25, 0.25, 0.25, 1, 0, 0.25, 1, 0, 0.25, 0, 0, 0, 0,
1, 0.25, 0, 0, 0, 0, 0, 1, 0.25, 0, 0, 0, 0, 0.25, 0, 0, 0.25,
0.25, 0.25, 1, 0, 0, 0, 0, 1, 0.25, 0, 1, 1, 0.25, 0.25, 0.25,
0, 0, 0.25, 0.25, 0, 0.25, 0, 0, 1, 0, 0.25, 0.25, 0, 0, 0.5,
0, 0.25, 0, 0, 0, 0.25, 0.5, 0.25, 0.25, 1, 0.25, 0, 1, 1, 0.25,
0.25, 0, 0.25, 0.5, 0.25, 0, 0.25, 1, 0.5, 0, 0.25, 1, 0.25,
0.25, 0, 0.5, 0, 0, 0, 0.5, 0.25, 0, 0.5, 0.25, 0, 0, 0.25, 0,
0.25, 0.25, 0.25, 0.25, 0, 1, 0, 0, 1, 1, 1, 0.5, 0.25, 0.25,
1, 0, 0.25, 0, 0.5, 0, 0, 0, 0, 0.25, 0, 0, 1, 0.25, 0.25, 0.5,
0, 0.25, 0.25, 0, 0.5, 0.25, 1, 0, 0, 1, 0.5, 0, 1, 1, 1, 1,
0, 0, 1, 0, 0.25, 0.25, 0, 0.25, 0.25, 0.25, 0, 0.5, 0.25, 0,
1, 0, 0, 1, 0.25, 0, 0.5, 0.5, 0, 0.25, 0.25, 0, 0.25, 0.5, 0,
0, 0, 1, 1, 0.25, 0.5, 0.25, 0.5, 0.25, 0.5, 0.25, 0.25, 0.5,
0, 0.25, 0.25, 0.25, 0, 0, 0.25, 0.5, 0.25, 0, 0.25, 1, 0, 0,
0.25, 1, 0.25, 0, 1, 0.25, 0.25, 0.25, 0.25, 1, 0.25, 0.5, 0.5,
0.25, 1, 0.25, 0.25, 0, 0, 0.5, 0, 0, 1, 0.25, 0, 0.25, 1, 0,
0.25, 0.25, 0, 1, 0.5, 0.5, 0, 0.25, 0, 0, 1, 0.25, 0.25, 0,
0.25, 0.25, 0.25, 0.5, 0.5, 1, 0, 0.25, 0, 1, 0.25, 0, 0, 0,
0.5, 0.25, 0, 0.25, 0, 0.5, 1, 0, 0.25, 0, 0.25, 0.25, 0, 0,
0.25, 0, 0, 0.25, 0.5, 0, 0, 0.5, 0, 0.5, 0.25, 0, 0, 0, 0, 1,
0.25, 0, 1, 1, 0.25, 0, 0.5, 0.5, 0, 0, 0.25, 0, 0.25, 0, 0.5,
0.25, 0, 1, 1, 1, 0.5, 1, 1, 0, 1, 0, 0, 0.25, 0, 0.25, 0, 0.25,
0.25, 0.25, 0.25, 0, 0.25, 0.25, 0, 0.25, 0, 0.25, 0, 1, 0, 0.25,
0, 0, 0, 0.25, 0, 0.25, 0, 0, 0, 0.25, 0, 0, 0.5, 0.5, 0.5, 0.5,
0, 0, 0.25, 0, 0, 0.25, 0.25, 0, 0, 0.25, 0, 0.25, 0.25, 0.25,
0, 1, 0, 0, 0.25, 0, 0, 0, 0.25, 0.25, 0.25, 0.25, 0, 0.25, 1,
0, 0.25, 0, 1, 0, 0, 0, 0, 0.25, 0.5, 0, 0, 0.25, 0.25, 0, 0,
0.25, 0, 1, 1, 0, 0.25, 0.25, 0, 1, 0, 0.5, 0.25, 1, 0, 1, 0.25,
0.5, 1, 1, 0.5, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 1, 0.5, 0,
1, 0.25, 0, 0.5, 1, 0, 0.25, 0.25, 0.25, 0, 1, 0.5, 0.5, 0, 1,
0.25, 0, 0.25, 0.25, 0, 0, 1, 0, 0.25, 0.5, 0.5, 0.5, 0.25, 0.25,
0, 0, 0.25, 0.25, 0.25, 0, 0.25, 0, 0.25, 0.25, 0.5, 0, 0, 1,
0.25, 0, 0.25, 0, 0, 0, 0.25, 0.25, 0.5, 0.25, 0.5, 0.5, 0.25,
0.25, 0.75, 0.75, 0.25, 1, 0.5, 1, 0.25, 0.25, 0.25, 0.5, 1,
0.5, 0.5, 0.5, 0, 1, 0, 0.25, 0.5, 0.25, 0.5, 0.25, 0.25, 0.25,
0.25, 0, 0, 0, 0.25, 0, 0.25, 0.25, 0, 0.5, 0, 0.5, 0.25, 0.25,
0.75, 0.5, 0.25, 0.25, 0.25, 0.5, 0.75, 0.25, 0.25, 0.25, 0.25,
0.5, 0.5, 1, 0.5, 1, 1, 0.25, 0.25, 0.5, 0.25, 0.5, 0, 0.25,
0.25, 0.25, 0.75, 0.25, 0, 1, 1, 0.5, 0.5, 0.25, 1, 0.25, 0,
0.5, 0.5, 0.25, 0.25, 0.75, 0.5, 0.5, 0.5, 0.25, 0.25, 0.25,
0.5, 0.25, 0.5, 0.5, 0.25, 0.25, 1, 0.25, 0.5, 1, 0.25, 0.25,
0.5, 0, 0.25, 1, 1, 0.25, 0.5, 0.25, 0.25, 0.75, 1, 0.75, 0.25,
1, 0, 0.5, 0.5, 0.5, 1, 1, 0.25, 0.25, 1, 0.25, 0.5, 0.25, 1,
0.5, 1, 1, 1, 0.25, 0.25, 0.5, 0.5, 0.25, 0.25, 0.5, 0.25, 0,
0.25, 0.5, 0.25, 0.25, 0.5, 0.75, 0.25, 0.5, 0.5, 0.25, 0.25,
0.25, 1, 0.25, 0.5, 0.25, 0.5, 1, 0.5, 0.25, 0.25, 0.25, 1, 1,
0.25, 0.25, 1, 0.5, 0, 0.25, 0, 0.25, 0.25, 0.5, 0.25, 0.25,
1, 0.25, 0.5, 1, 0.5, 0.5, 0.5, 0, 0.25, 1, 1, 0.5, 0.5, 0, 0,
1, 0.25, 1, 0.25, 0.25, 0.25, 0.25, 1, 0.25, 0.25, 0.25, 1, 1,
1, 0.5, 1, 1, 0.5, 1, 1, 1, 0.5, 1, 0.5, 0.5, 0.5, 0.25, 0, 0.25,
0.5, 0.5, 0.25, 0.25, 1, 1, 0.25, 0, 0.25, 0.25, 0.5, 1, 0.25,
1, 0.25, 0.25, 0.5, 0.25, 0.25, 0, 0, 0.25, 0.25, 0, 0.5, 0.25,
0.5, 1, 0.25, 1, 1, 0.25, 0.75, 0.5, 0.25, 1, 0.25, 1, 0, 1,
0.5, 1, 0.5, 1, 1, 0.25, 0.25, 1, 0.25, 0.25, 1, 1, 0.25, 1,
0, 0.25, 1, 1, 0.25, 0.25, 0.25, 1, 1, 0.25, 0.25, 0.75, 1, 0.75,
0.25, 1, 1, 0.5, 0.5, 1, 0.5, 1, 0, 0.25, 1, 1, 0.25, 1, 1, 0.25,
0.5, 0.75, 0.25, 0.5, 0.75, 0, 1, 1, 0.25, 0.25, 0.25, 0, 0.25,
1, 0.25, 0.25, 0.25, 0.25, 0.25, 0, 0.25, 0.25, 0, 0.75, 0.5,
0.25, 0.25, 0, 0.5, 0.25, 0.5, 0.5, 0.5, 0.25, 0.25, 0.5, 0.25,
0.25, 0.25, 0, 1, 0.25, 0.25, 0, 0.25, 0, 0.5, 0.25, 0.5, 0,
0, 0, 0, 0.5, 0, 0.5, 0.25, 0.5, 1, 0.75, 0.5, 0.25, 0.25, 0.75,
0.25, 0.25, 0, 0.5, 0, 0, 0, 0.25, 0.25, 0.25, 0.5, 0, 0.25,
0.75, 0, 0.25, 0.5, 0.25, 1, 0.25, 0.5, 0.25, 0.25, 0.25, 0.5,
0, 0.5, 0, 0.5, 0.25, 0.5, 0.5, 0.25, 0.25, 0.75, 0.75, 0.25,
0.75, 1, 0.25, 0.5, 0.5, 0.25, 1, 0.75, 0.75, 0.25, 0.25, 0,
0.75, 0.75, 0.5, 0.25, 0.5, 0.5, 0.5, 0.5, 0.75, 0, 0.5, 0.25,
0.5, 0.5, 0.25, 0.25, 0, 0.5, 0.5, 0.5, 1, 0.5, 0.5, 0, 0.5,
0, 0.25, 0.5, 0.5, 0, 0.5, 1, 0, 0.5, 0.25, 0.5, 0.25, 0.5, 0.25,
0.5, 0, 0.5, 0.25, 0.25, 0.25, 0.25, 0.5, 0.5, 0.25, 0.5, 0.25,
0, 0.25, 0.5, 0.5, 0.25, 0.25, 0.25, 0.75, 0.5, 0.25, 0.25, 0.5,
0.25, 0.25, 0.25, 0.5, 0, 0.5, 0.25, 0.5, 0.25, 1, 0.25, 0.75,
0.5, 0.25, 0.5, 0.5, 0.5, 0.5, 0.25, 0.75, 0.5, 0.25, 0.5, 0,
0.25, 0.75, 0.25, 0.5, 0.5, 0.5, 0.25, 0.25, 1, 0.5, 0.75, 0.25,
0.5, 0.25, 1, 0.25, 0.25, 0.75, 0.25, 0.25, 0.25, 0.25, 0.25,
0.5, 0.25, 0.25, 0.25, 0.5, 0.5, 0.5, 0.25, 0.25, 0.5, 0.25,
0.25, 0.25, 0, 0.25, 0.5, 0.25, 0.5, 0.5, 0.5, 0.5, 0, 0.5, 0.25,
0.5, 0, 0.25, 1, 0.5, 0.75, 0.5, 0.25, 0.25, 0.25, 0.25, 0.75,
0.25, 0.25, 0.75, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 1,
0.25, 0, 0, 0.25, 0.25, 0.25, 0.25, 0, 0.5, 0.25, 0.25, 0.25,
0.5, 0.5, 0.5, 0.25, 0.25, 0.5, 0.25, 0.5, 0.25, 0.25, 0.25,
0.25, 0.5, 0.5, 0.25, 0, 0.25, 0.25, 0.5, 0, 0.75, 0.5, 0.5,
0.5, 0.25, 0.25, 1, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25,
0.25, 0.25, 0.25, 0.25, 1, 0.5, 0.25, 0.25, 0.25, 0.25, 0.25,
0.25, 0.5, 0.5, 0.25, 0.25, 0.5, 0.5, 0.75, 0, 0.25, 0.5, 0.5,
0.25, 0.25, 0.5, 0.25, 0.5, 0.25, 0.5, 0.25, 0.25, 0.5, 0.5,
0.25, 0.25, 0, 0, 0, 0, 0, 0, 0.5, 0.25, 0.5, 0, 0.25, 0.5, 0.25,
0.25, 0.25, 0.5, 0.25, 0.25, 0, 0.5, 0.5, 0.25, 0.25, 0.25, 0.25,
0, 0.25, 0.25, 0.25, 0.25, 0.5, 0.5, 0.75, 1, 0.25, 0.25, 0.25,
0.5, 0.5, 0.25, 0.5, 0.5, 0.25, 0.5, 0.25, 0.25, 0.25, 0.25,
0.25, 0.25, 0.5, 0.5, 0.25, 0.5, 0.5, 1, 0.25, 0.25, 0, 0.5,
0, 0, 0.25, 0.5, 0.75, 0.5, 0.25, 0.75, 0.25, 0.25, 0.75, 0.75,
0.25, 0.25, 0, 0, 0, 0.75, 0.5, 0.25, 0.25, 0.25, 0, 0.5, 0.25,
0.5, 0.75, 0, 0, 0.25, 0.5, 1, 0.25, 0.25, 0.25, 0.25, 0.25,
0.25, 0, 0.25, 0.25, 0.25, 1, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25,
0.5, 0, 0.5, 0, 0, 0.25, 0.25, 0, 0.25, 0, 0.25, 0.25, 0, 0,
0.25, 0, 0, 0, 0.25, 0, 0, 1, 0.25, 0, 0, 0.25, 0, 0.25, 0, 0.25,
0.25, 0, 0, 0.25, 0.25, 0.25, 0, 0.25, 0.5, 0.25, 0.5, 0.75,
0.25, 0, 0, 0.25, 0.25, 0.25, 0, 0, 0.75, 0, 0.5, 1, 0.25, 0.25,
0.75, 0.75, 0.25, 0.75, 0.75, 0.5, 0.5, 0.75, 0.75, 0.75, 0.75,
0.75, 1, 0.75, 0.75, 0.5, 0.5, 0.5, 0.5, 0.75, 0.5, 0.25, 0.5,
0.5, 0.5, 0.75, 0.5, 1, 0.75, 0.25, 0.75, 0.5, 0.5, 0.5, 0.75,
0, 0.25, 1, 0.5, 1, 0.25, 0.75, 1, 0.75, 0.75, 0.5, 0.75, 0.25,
1, 0.75, 0.25, 0.75, 0.5, 0.25, 0.5, 0.25, 0.75, 0.5, 0.5, 0.25,
0.5, 0, 0, 0.25, 0.75, 0.75, 1, 0.5, 0.25, 0.25, 0.75, 0.5, 0.75,
0.25, 0.75, 0.25, 0.5, 0.25, 0.25, 0.25, 0.75, 0.75, 0.75, 0.5,
0.25, 0, 0.5, 0.75, 0, 0.25, 0, 0.25, 0.75, 1, 0.5, 0.25, 0.75,
0.5, 0.25, 0.25, 0.5, 0.75, 0.75, 0.25, 0.5, 0.25, 0.5, 0.25,
0.25, 1, 0.75, 0.25, 0.5, 0.5, 0.5, 0.5, 0.75, 0.5, 1, 0.75,
0.75, 0.25, 0.25, 0.75, 0.75, 0.75, 1, 0.75, 0.75, 0.5, 0.5,
0.5, 0.75, 0.5, 1, 0.25, 0.5, 1, 0.5, 0.25, 0.5, 1, 0.75, 1,
0.25, 1, 0.25, 0.5, 0.25, 0.5, 1, 0.5, 0.5, 1, 0.25, 0.75, 1,
0.5, 0.75, 0.5, 0.75, 1, 0.75, 0.25, 0.25, 1, 0.25, 0.75, 0.5,
0.25, 0.5, 0.25, 0.5, 1, 0.25, 1, 1, 0.5, 1, 1, 0.75, 1, 0.25,
0.5, 0.5, 0.75, 1, 1, 0.5, 1, 0.75, 0.5, 1, 0.75, 0.25, 0.5,
0.5, 0.5, 0.5, 1, 0.5, 0.5, 0.25, 0.25, 1, 0.5, 1, 0.5, 0.75,
0.5, 0.25, 1, 0.75, 0.75, 1, 0.25, 0.75, 1, 0.75, 0.5, 0.75,
0.5, 0.5, 0.5, 1, 1, 0.5, 0.75, 0.75, 0.5, 1, 0.5, 0.5, 0.75,
1, 0.75, 0.5, 1, 0.75, 1, 0.5, 0.75, 0.5, 1, 0.25, 1, 0.75, 1,
0.25, 0.5, 0.5, 0.75, 1, 0.25, 0.25, 0.25, 1, 0.75, 1, 0.75,
0.75, 0.75, 1, 0.5, 1, 0.5, 0.75, 0.25, 0.5, 1, 1, 1, 0.5, 1,
0.5, 0.5, 0.75, 0.75, 0.25, 0.5, 0.5, 0.75, 0.75, 0.5, 1, 0.5,
0.75, 0.75, 0.5, 1, 0.75, 1, 0.75, 0.25, 0.75, 0.5, 0.5, 0.5,
0.25, 1, 0.5, 0.5, 0.5, 0.75, 0.75, 0.25, 0.25, 0.75, 0.75, 0.75,
0.5, 0.25, 1, 0.25, 0.75, 0.75, 1, 0.5, 0.5, 0.75, 0.5, 0.75,
0.75, 0.75, 0.25, 0.5, 0.75, 0.25, 0.5, 0.75, 0.5, 1, 0.5, 0.5,
1, 0.75, 0.5, 0.5, 0.75, 0.25, 0.25, 0.25, 0.5, 0.5, 0.25, 0.5,
0.75, 1, 0.25, 0.75, 1, 0.25, 1, 1, 1, 0.5, 0.25, 0.5, 0.25,
0.25, 0.5, 0.5, 0.5, 0.25, 0.75, 0.75, 0.25, 0.25, 0.25, 0.5,
0.5, 0.75, 0.25, 0.75, 0.5, 0.25, 1, 0.5, 0.75, 0.5, 0.75, 0.75,
0.5, 0.75, 0.25, 0.5, 0.75, 0.75, 0.75, 1, 0.75, 0.25, 0, 0.75,
0.75, 0.25, 0.25, 0.5, 1, 0.5, 1, 0.75, 1, 0.25, 1, 1, 0.5, 0.25,
0.75, 0.5, 0.25, 1, 1, 0.25, 0.25, 0.5, 1, 1, 1, 0.25, 0.25,
0.25, 0.25, 0, 1, 0.25, 1, 1, 0.5, 0.5, 1, 0.25, 1, 0.5, 0.5,
0.5, 0.25, 1, 0.25, 1, 0.25, 0.25, 0.5, 0, 0.25, 0.75, 0.25,
0.5, 1, 0.75, 0.25, 0.75, 0.5, 0.5, 0.75, 0, 0.5, 0.25, 0.5,
1, 0.25, 0.5, 0.5, 0.5, 0.5, 1, 0.5, 0.25, 0.25, 0.5, 0, 0.25,
0.5, 0.25, 0.75, 0.75, 0.5, 1, 0.75, 0.5, 0.5, 0.5, 0, 0.25,
0.75, 0.75, 0.75, 1, 1, 0.5, 1, 1, 1, 0.25, 1, 0.5, 0.75, 0.5,
1, 0.25, 1, 0.5, 0.25, 0.75, 0.5, 0.75, 1, 0.75, 1, 0.5, 0.5,
1, 0.75, 0, 0.5, 1, 0.25, 0.75, 1, 0.5, 1, 1, 0.5, 1, 0.75, 0.75,
1, 1, 0.5, 0.5, 1, 1, 0.75, 1, 0.75, 1, 0.5, 0.75, 0.25, 0.5,
0.5, 1, 0, 0.5, 0.75, 0.25, 0.75, 0.25, 0, 0.5, 1, 1, 0.5, 0.25,
0.5, 0.75, 1, 0.25, 0.25, 1, 0.5, 0.75, 0.75, 1, 0.5, 0.75, 0.25,
0.75, 0.75, 0.25, 0.75, 0.75, 0.25, 0.25, 0.5, 0, 0.75, 0.5,
0, 0.25, 0.5, 0.25, 0.25, 0.25, 0, 0.25, 0.25, 0.5, 0.25, 0.75,
0.25, 0.25, 0.25, 0.5, 0, 1, 0.25, 0.75, 0.25, 0.5, 1, 0.5, 0.5,
0.75, 0.75, 0.75, 1, 0.25, 0.25, 1, 1, 0.5, 0.75, 0.25, 0.25,
0.5, 0.25, 0.25, 1, 0.5, 0.25, 0.5, 0.5, 0.25, 0.5, 0.5, 0.25,
0.25, 0, 0.5, 0.5, 0.25, 0.5, 0.25, 0.25, 1, 0.25, 0.75, 0.5,
0.25, 0.5, 0.75, 0.5, 0.25, 0.5, 0.25, 0.25, 0.75, 0, 0.5, 0,
0.5, 0, 1, 0.25, 0.5, 1, 0, 0.5, 0.5, 0.75, 0.25, 0.5, 0, 0.25,
1, 0.5, 0.25, 0.25, 0.5, 0.5, 0.75, 0.75, 0.75, 0.75, 1, 0.25,
0.25, 0.75, 0.25, 0.75, 0.5, 0.5, 0.25, 0.25, 0.75, 0.5, 0, 0.75,
0, 0.25, 0, 0.5, 0.75, 0.5, 0, 0.5, 0.5, 0.75, 0.75, 0.25, 0,
0.25, 0, 0, 0.25, 0.25, 0, 0.5, 0.25, 0.25, 0.5, 0.25, 0.5, 0.5,
0, 0.25, 1, 0, 0.25, 0.5, 0.5, 0.5, 0.5, 0, 0.5, 0.5, 0.25, 0.5,
1, 0.25, 0.5, 0.25, 0.25, 0.25, 0.25, 0.25, 0.5, 0.5, 0.75, 0.75,
0.75, 0.25, 0.25, 0.5, 0.75, 0.75, 0.5, 0.5, 0.75, 0.75, 0.25,
0.5, 0.75, 0.25, 0.5, 0.25, 0.25, 0, 0.25, 0.25, 0.5, 0.25, 0,
0.5, 0.5, 0, 0.5, 0.5, 0.5, 0.75, 0, 0, 0.5, 0.25, 0.5, 0.25,
0, 0.5, 0.5, 0.5, 0.5, 0.5, 0.75, 0.25, 0.5, 0, 0.5, 0.75, 0.5,
0.25, 0.5, 0.5, 0.25, 0.25, 0.5, 1, 0, 0.25, 0.25, 0.5, 0.75,
0.5, 0.25, 0.75, 0.5, 0.25, 0.25, 0.5, 0.75, 0.25, 0.5, 1, 1,
0.25, 0.5, 0.75, 0.5, 0.75, 0.25, 0, 0.25, 0.5, 0.25, 0.25, 0.25,
0.5, 0.5, 0.75, 0.75, 0.25, 0.5, 0, 1, 0.25, 0.25, 0, 1, 0.25,
0.5, 0.25, 0.5, 0.5, 0, 0.75, 0.25, 0.25, 0.25, 0.25, 0.5, 0.5,
0.25, 0.5, 0.75, 0.75, 0.5, 0.5, 0, 0.75, 0.75, 1, 0.5, 0.5,
0, 0.75, 0.25, 0.5, 0.25, 0, 0.25, 0.75, 0, 0.5, 0.5, 0.25, 0.25,
0.25, 0.75, 0.25, 0.5, 0.5, 0.5, 0.5, 1, 1, 0.5, 0.5, 0.25, 0.5,
0.25, 0.25, 0.5, 0, 0, 0.5, 0.5, 0.25, 0, 0.5, 0, 0.25, 0.75,
0.25, 0.5, 0.75, 0.25, 0.5, 1, 0.25, 0.25, 0.5, 1, 0.5, 0.25,
0.5, 1, 1, 0.25, 1, 0.5, 0.75, 0.75, 0.5, 0.5, 0, 0.5, 0.75,
0.5, 0.25, 0, 0.5, 0, 0.5, 0.25, 0, 0.25, 0.5, 0.75, 0, 0, 0,
0.75, 0.25, 0, 0.25, 0.5, 1, 0, 0, 0.5, 0.25, 0.25, 0, 0.75,
0, 0.75, 0.25, 0.25, 0.5, 0, 0.75, 0.5, 0.5, 0.5, 1, 0.5, 0.75,
0.25, 0, 0.25, 0.5, 0.5, 0.25, 0.25, 0.5, 0.5, 0.25, 0.5, 0.25,
0.5, 0, 0.25, 0.5, 0.5, 0.25, 0.25, 1, 0.5, 0.5, 0.5, 0, 0.5,
0.5, 0.5, 0.25, 0.25, 0.5, 0.5, 0.75, 0.25, 0.75, 0.75, 0.75,
0.5, 0.25, 0.25, 0.25, 0.5, 0.25, 0, 0.5, 0.5, 0.5, 0.25, 0.25,
0.75, 0.5, 0.25, 0.25, 0.5, 0.25, 0.5, 0.25, 0.75, 0.75, 0.5,
0, 0.75, 0.75, 0.25, 0, 1, 0.75, 0.75, 0.5, 0, 0.5, 0.25, 0.75,
0, 0.5, 0.5, 0.75, 1, 0.25, 0.75, 0.75, 0.5, 0, 0.25, 0.25, 0,
0.25, 0.5, 0.25, 0.75, 0.25, 0.25, 0.25, 0, 0, 0, 0.5, 0, 0.25,
0, 0.5, 0.5, 0.5, 0, 0.5, 0.25, 0.75, 1, 1, 0, 0.5, 0.25, 0.5,
0.75, 0, 0.25, 0.25, 0.25, 0, 0.25, 0, 0, 0.25, 0.5, 0, 0.75,
0.5, 0.5, 0.25, 0.5, 0.5, 0.75, 0, 0.5, 0.25, 0.5, 1, 0.25, 0.25,
0.25, 0, 0.75, 0.75, 0.5, 0.75, 0.5, 0.75, 0.5, 0.5, 1, 0.25,
0, 0.75, 0.5, 0.25, 0.5, 0.25, 0.5, 0.5, 0.25, 0.75, 0.5, 0.75,
0.5, 0.25, 1, 0.5, 0.75, 0.5, 0.5, 0.5, 0.75, 0.25, 0, 0.5, 0,
0.25, 0, 0.5, 0.25, 0.75, 0.5, 0.25, 1, 0, 0.5, 0.25, 0.75, 0.75,
0.5, 0, 0.25, 0.25, 0, 0.5, 0.75, 0, 0, 0.25, 0.75, 1, 0.5, 0,
0.5, 0.5, 0.5, 0.25, 0.25, 0, 0.25, 0.25, 0.25, 0.5, 0.5, 0.25,
0.25, 0.5, 0.5, 0, 0.25, 0.25, 0.75, 0.5, 0.5, 0, 0, 0.5, 1,
0.25, 0.25, 0, 0, 0.25, 1, 0.25, 0.5, 0.5, 0, 0.25, 0.25, 0.25,
0.5, 0.5, 1, 0, 1, 0, 0.25, 0, 1, 0, 0.75, 0, 0.75, 0.75, 0.25,
0.75, 0, 0, 0.75, 0, 0, 0, 0.5, 0, 0.25, 0, 0.25, 0.5, 0.5, 0,
0.5, 0, 0.75, 0, 0.75, 1, 0.25, 1, 0.25, 0.75, 0.5, 0.5, 0.75,
1, 0.75, 0.5, 0, 0, 0.75, 1, 0.5, 0.75, 0.75, 0, 1, 0.75, 1,
0.75, 0.75, 0.5, 0.75, 0.5, 0.5, 0.5, 0.5, 0, 0.75, 0.75, 0,
0, 0.75, 0.25, 1, 0.25, 0, 1, 0.75, 0.25, 0.75, 0.75, 0.25, 1,
0.5, 0.5, 0.75, 0, 0.25, 0.5, 0.75, 0.75, 0, 1, 0.75, 0.25, 0.75,
0, 0.75, 0, 0.75, 0.25, 0.5, 0.25, 0.25, 0.25, 0.5, 0.75, 0,
0.75, 0.75, 0, 0.75, 0.75, 0, 0.25, 0.25, 0, 0, 0.25, 0.5, 0.5,
0, 0.75, 0.25, 0.5, 0.25, 0, 0, 0.25, 0.75, 0.5, 0.5, 1, 0, 0.75,
0, 0.5, 0.75, 0.5, 0.5, 0, 0, 0.75, 0.25, 0, 0.75, 0.75, 0.5,
0, 0, 0.75, 0.5, 0.25, 0.75, 0, 0.5, 1, 0.25, 0.75, 1, 0, 0,
0.25, 0.5, 0, 0.5, 0.25, 0.25, 0, 0.75, 0, 0.75, 0.75, 1, 0,
0.5, 0.5, 0.5, 0, 1, 0.75, 0.5, 0.75, 0.25, 0.25, 0.75, 0.25,
0, 0.75, 0.5, 0.25, 0.5, 0.75, 0.25, 0.25, 0.5, 0.25, 0.25, 0,
0.75, 0, 0, 0, 0.25, 0.25, 0, 0.25, 0.5, 0.75, 0.25, 0.75, 0.5,
1, 0.75, 0.5, 0, 0, 0, 1, 0.25, 0.75, 0.75, 0.75, 0.25, 0.25,
0.5, 0.25, 0.5, 0.5, 0.5, 0.25, 0, 0, 0.5, 0.25, 0, 0.25, 0,
0.5, 0.5, 0, 0.25, 0.5, 0.25, 0.25, 0.25, 0, 0.25, 0.5, 0.25,
0.75, 0.75, 0.5, 0, 0.5, 0.25, 0.25, 0.75, 0.25, 1, 0, 0.5, 0.5,
0.25, 0.5, 0.75, 0, 0.75, 0.75, 0.75, 0.75, 0.75, 0, 0.75, 0,
0.75, 0.75, 0, 0.75, 0, 0.75, 0.5, 1, 1, 0.25, 0.75, 0, 0, 0.75,
1, 0.5, 0.25, 0.75, 0, 0.5, 0.5, 0, 0.5, 1, 0.5, 1, 1, 0.75,
0.75, 0, 0.75, 0.5, 1, 0.75, 1, 1, 0.75, 1, 0.5, 0, 0.75, 0.75,
0.75, 0.75, 0.75, 0.5, 1, 0, 0.25, 0.25, 0.25, 0.75, 0, 0.75,
0.25, 0.75, 0.75, 0.5, 0.5, 0.5, 0, 0, 0.75, 0, 0.5, 0, 0.75,
0.5, 0.5, 0, 0.75, 0.75, 0, 0.75, 0.25, 0.75, 1, 0.75, 1, 0.75,
1, 1, 1, 1, 0, 0, 0.75, 0, 0.5, 0.75, 0.75, 0, 0, 0.5, 0, 1,
0.75, 0.75, 0.75, 0, 0, 0, 0.25, 0, 0, 0.25, 0.75, 0.75, 0, 0.5,
0.75, 0.5, 1, 1, 0, 0, 0.5, 0, 0, 0, 0.25, 0.75, 0.75, 0, 1,
0, 1, 0.25, 0.75, 0.25, 0.5, 0.25, 1, 0.5, 0.75, 0.75, 1, 1,
1, 0, 0.75, 1, 1, 0.5, 0.75, 0.5, 1, 0.75, 1, 1, 0, 0, 0.25,
1, 0, 1, 0.25, 0.75, 0.75, 0.75, 0.75, 0.75, 1, 0.75, 0.75, 0.75,
1, 1, 0.75, 0.75, 0, 0.5, 0.75, 0.25, 0.5, 0, 0, 0.75, 0, 1,
1, 0.75, 0.25, 1, 0.25, 1, 0, 0, 0.75, 0, 0.75, 0.5, 0.75, 0.5,
0.75, 0, 0.75, 1, 0.25, 0.5, 0.25, 0.75, 0.75, 0.5, 0, 0.25,
0.75, 0, 0.5, 0.5, 0, 0.25, 0, 0, 0, 0.75, 0.75, 0, 0.75, 0.75,
0, 1, 0.5, 0, 0.5, 0, 1, 0, 1, 0, 1, 0.5, 0.5, 1, 0, 0, 0.25,
1, 0, 0.25, 0.25, 0.5, 0.5, 0.75, 0, 0.75, 0.25, 0, 0.75, 0.75,
0, 0.75, 1, 0.5, 0.25, 0.5, 0.25, 0, 1, 0, 0.5, 0, 0, 0.75, 0,
0.75, 0.75, 0.5, 0.5, 1, 0, 0, 0.25, 0.5, 0, 0.5, 0.75, 0.75,
0, 1, 0, 0, 0, 1, 0.75, 1, 1, 1, 1, 0.5, 0.25, 0, 0.75, 0.5,
0.75, 1, 1, 1, 1, 0, 1, 0.75, 0, 0, 0.5, 0.5, 0.75, 0.5, 0, 0.75,
0.75, 0.75, 1, 0.75, 0, 0, 0.75, 0.75, 0.25, 0, 1, 0, 0, 0.75,
0.25, 0.5, 1, 0, 1, 0.75, 0.25, 0.5, 0.75, 0.25, 0.75, 0, 0.5,
1, 1, 0.75, 0.25, 0.75, 0, 0.75, 1, 0.5, 0, 0, 0.25, 1, 0.25,
0, 1, 0, 1, 0.75, 0, 0.75, 0.25, 0.25, 1, 0, 1, 0.25, 1, 0, 1,
0, 0.25, 0.75, 0.5, 0, 0.75, 0.75, 0.25, 0.75, 0.75, 1, 0, 0.25,
0, 0.75, 0.25, 0.75, 0.5, 0, 0.25, 0.5, 0, 0.75, 1, 0, 0.5, 0.25,
0.5, 0, 1, 0.75, 1, 0.75, 0.75, 0.25, 0.75, 0.75, 0.75, 0.75,
0.5, 0.75, 0.5, 0.5, 0, 0, 0.5, 0, 0.75, 0.75, 0.5, 0.75, 0.25,
0.5, 0.25, 0.25, 0.5, 0.75, 1, 0.75, 0, 0.25, 1, 0.75, 0.5, 1,
0, 0, 0.75, 1, 0, 0.5, 0.5, 0.75, 1, 0.75, 0, 0.75, 0, 0.75,
0, 1, 1, 0.25, 1, 0.25, 0.75, 1, 0.5, 0.75, 0.75, 0.75, 0, 0.5,
0.5, 0.75, 0.25, 1, 0.5, 0, 0, 1, 0.75, 0.75, 0.75, 0.75, 1,
0.5, 0, 0.5, 0.25, 0, 0.75, 1, 0.75, 0.75, 0, 0.75, 0.75, 0,
0, 0.5, 0, 0.5, 0, 0.25, 1, 0.75, 0, 1, 0.75, 0, 0.25, 0.75,
0.25, 0.5, 0.75, 1, 0.25, 0, 1, 1, 0.25, 1, 0, 0.75, 1, 1, 0.75,
0.75, 0.5, 0.75, 0.5, 0.25, 0.75, 0, 0.25, 0.25, 0.75, 0.75,
0.25, 0, 0.75, 0.25, 0.25, 0.75, 0.25, 0.25, 0.5, 0.75, 0.5,
0, 0.5, 0.75, 0, 0.25, 0, 0, 0.25, 0.5, 0.5, 0, 1, 0, 0.75, 0.75,
0, 0.5, 1, 0.75, 0, 0, 0.75, 0.75, 1, 0, 0.25, 0, 0.75, 0, 0,
0.75, 0, 0.25, 0.75, 0.75, 0.75, 0.25, 1, 0.25, 0.5, 0, 0.75,
0.25, 0.75, 0.25, 0, 0.5, 0, 1, 0.25, 0, 1, 1, 0.75, 0.75, 1,
0.5, 0.5, 0, 1, 0.25, 0.5, 1, 0, 1, 1, 0, 0, 0.75, 1, 0.75, 0.75,
0.5, 0.75, 0, 0.5, 1, 0.75, 1, 0.75, 0.75, 0.75, 1, 0, 0.5, 0.75,
1, 1, 0.5, 0, 1, 0, 0.5, 1, 0, 0.25, 0.75, 0.25, 0.25, 0.25,
0, 1, 1, 0.75, 0, 0.75, 0.25, 0.25, 0.5, 0, 0, 1, 0, 0.75, 0.75,
0, 0.5, 0, 0.25, 0, 0.75, 0.75, 1, 0, 0, 0, 1, 0, 0.75, 0.25,
0, 0, 0.75, 1, 0, 0.75, 0.25, 0.75, 0.5, 0.5, 0, 0.5, 0.75, 0,
0.5, 1, 0.25, 0.75, 0, 0, 0.75, 0.25, 0.75, 0.75, 0.75, 1, 0.75,
0.5, 0.5, 0.75, 1, 0.75, 0.25, 0.75, 0, 1, 0.75, 0, 0, 0.75,
1, 0, 1, 0, 1, 0.25, 0.75, 0.25, 0, 1, 0.75, 0.25, 0, 0.25, 0,
0.75, 0.75, 0, 0, 0.75, 0.25, 0.5, 0.75, 0.75, 1, 0, 0.75, 0.25,
0.25, 1, 0, 0.5, 0, 0, 0.75, 0.75, 0.25, 0, 0.75, 0.75, 0, 0,
0.25, 0, 0.5, 0, 0.5, 0, 0.25, 0.5, 0, 0.5, 1, 0.25, 0, 0.25,
0.25, 0, 0.25, 0.75, 1, 0, 0.25, 0.75, 1, 0, 0.75, 0.25, 0.5,
0.5, 0, 1, 0.75, 0.5, 0.75, 0.25, 0, 0, 0.5, 1, 0, 0.5, 0.5,
1, 0.25, 0.25, 0.75, 1, 0.25, 0.25, 0, 0.5, 0.25, 0, 0.75, 0,
0, 0.25, 0.5, 1, 0.75, 0.75, 0, 0, 0.5, 1, 0, 0.75, 0.75, 0.75,
0.75, 1, 0.5, 0.5, 0.25, 0.75, 0, 0.75, 1, 1, 0.75, 0.75, 0.75,
0.25, 0.5, 0.5, 0, 0, 0.25, 0.5, 0.5, 0.75, 1, 0, 0.25, 0.25,
1, 0.5, 0.25, 0.5, 0.25, 0.25, 0.25, 0.75, 1, 0.25, 0, 0, 0,
0.75, 1, 0, 0.25, 0.75, 0.75, 0, 0.75, 0, 0, 0.5, 0, 0, 0.75,
1, 0, 0.5, 0.25, 0, 0.25, 0.5, 0.5, 1, 0.25, 0.5, 1, 0, 0, 1,
1, 0.5, 1, 1, 1, 0.75, 1, 0.75, 0.5, 0, 0.5, 0.75, 0.5, 0, 0.75,
1, 0.25, 0.25, 0.75, 0, 0.75, 1, 1, 1, 0.5, 0, 0.25, 1, 1, 0.25,
1, 0, 0, 1, 0, 0.75, 0.25, 0.5, 0.75, 1, 1, 0.75, 0.75, 0, 0.5,
0, 0.5, 0.5, 0.25, 0.75, 0.5, 0, 0.75, 0, 0, 0.75, 0.75, 0.75,
0.75, 1, 0, 0.75, 0, 0, 0.5, 0.75, 0.75, 0.5, 0.75, 0.5, 0, 0,
0, 0, 0.5, 0.75, 0.5, 0.5, 0.75, 0, 0, 0, 0.75, 0.25, 0, 0.25,
0.5, 0.75, 0.5, 0.25, 1, 0.75, 0.25, 0, 1, 1, 0.75, 0.25, 0,
0.75, 0.75, 0, 0.5, 0.75, 0.25, 1, 0.5, 0.75, 0.5, 1, 0.5, 0,
0, 0.75, 0.75, 0.5, 0.75, 0, 0, 0.25, 0.25, 1, 0.75, 0.75, 0,
0.75, 0.5, 0.25, 0.75, 0, 0.5, 0.25, 0.25, 0, 0.5, 0, 0.5, 0,
0, 0.25, 0.5, 0.75, 1, 0, 1, 0.75, 0.5, 0, 0, 0.75, 0.25, 1,
0.75, 0, 0, 0, 0.75, 0, 0.75, 0, 0, 0.75, 0.5, 0.25, 0, 0.75,
0, 0, 0.5, 0, 0.25, 0.75, 0.5, 0.75, 0, 0.5, 0, 0, 0.25, 0.5,
1, 0, 0.5, 0, 0, 0, 0.75, 0, 1, 0.75, 0.25, 0, 0.75, 0, 1, 0.5,
0.75, 0.25, 0.5, 0, 1, 0.25, 0.75, 1, 0, 0.25, 0.75, 0.75, 0.25,
0.75, 0.25, 0.25, 0, 0.75, 0, 0.25, 0.75, 0, 1, 0, 0, 0.5, 0.25,
0.75, 0.75, 0.5, 0, 0.75, 0, 0.5, 0.5, 0, 0.5, 0.5, 0.75, 1,
0.25, 0.75, 0, 0.75, 0.5, 0.75, 0, 1, 0.75, 0, 0.25, 0.25, 0.75,
0.75, 1, 0, 0.5, 0, 0, 0, 0.25, 0.25, 0.25, 0.5, 0.75, 0, 0,
0.25, 0.25, 0, 0.5, 0.5, 0.5, 0.75, 0.5, 1, 0.25, 0.25, 0.5,
0.25, 0.75, 0, 0, 1, 1, 1, 1, 0.25, 0, 0, 1, 0, 0.5, 1, 0.25,
0, 0.75, 1, 0.5, 0.75, 0.5, 0.75, 1, 0.25, 0.5, 0.75, 0.25, 0.75,
0.75, 0, 0, 0.5, 0.75, 0, 0.75, 0, 0.75, 0.25, 0.75, 1, 0, 0.25,
0.75, 0, 0.25, 0, 0, 0.5, 0.5, 1, 0.75, 0.25, 0.25, 0, 1, 0,
0, 1, 1, 1, 0.5, 0, 0.25, 0.75, 1, 0.75, 1, 0.25, 1, 0, 0.75,
1, 0.5, 0.5, 0.75, 0, 0, 0, 0.5, 0.75, 0.5, 1, 0, 0, 0.25, 0.75,
1, 0, 0.5, 0, 0.5, 0, 1, 0.25, 0.75, 0.75, 0, 0.75, 0, 0.75,
1, 0, 0.25, 1, 0, 0, 0, 0, 0, 0, 1, 0.75, 0.5, 0.5, 0, 0.75,
1, 0.5, 0.75, 0.25, 0.25, 0.25, 0.75, 0, 0.75, 0.5, 0.75, 0.25,
0.25, 0.25, 0.75, 0, 0, 0.75, 0, 0, 0.75, 0.75, 0.25, 1, 0.25,
0.25, 0.25, 0.25, 0, 1, 1, 1, 0, 0, 0, 0, 0.25, 0.25, 0.75, 0.75,
1, 1, 0.25, 1, 0.75, 0.75, 0, 0, 0.75, 0.5, 0.75, 1, 1, 0.75,
0, 0.75, 0.25, 0.5, 1, 0, 0, 1, 0, 0, 1, 0.75, 0, 0, 1, 0.5,
0.25, 0.75, 0.75, 0.25, 0, 0, 0, 0.75, 0.25, 1, 0, 0, 0.5, 0.5,
0.75, 0, 0, 0.25, 0, 0.5, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0.25, 0.5,
0.75, 0.75, 0.25, 0.25, 0.5, 1, 0.75, 0.25, 0.25, 0.5, 0.5, 0.75,
0.75, 1, 0.75, 0.75, 0, 0.25, 0.75, 0, 0, 1, 0, 1, 0.75, 1, 0.25,
0, 0, 0.25, 0.5, 0.5, 0.75, 0.75, 0.5, 0.75, 0, 1, 0, 0.25, 0.5,
0.75, 0.25, 0, 0, 0.5, 1, 1, 0.5, 0, 0, 0, 0.25, 0.5, 0.5, 0,
1, 0.75, 0.5, 0, 0, 0, 0, 0.25, 0.5, 0.75, 0.75, 0.25, 1, 0,
0.5, 0, 0, 0.25, 0.75, 1, 0, 0.5, 0.25, 1, 0.25, 0.25, 1, 0.75,
1, 0.75, 0.75, 0.75, 0.25, 0.75, 0.75, 0, 0.25, 0.75, 0, 0.75,
0.5, 1, 1, 0, 1, 0.5, 0.75, 0.75, 1, 0.25, 0.75, 0.5, 1, 0, 0,
0, 0.75, 0.75, 0.5, 0.25, 0.25, 0, 0, 0.25, 0.75, 0.25, 0.25,
0.25, 0, 0.5, 0.5, 0.75, 0.75, 0.25, 0, 0.5, 0.5, 0.25, 0.75,
0.25, 0.25, 0, 1, 0.75, 0, 1, 0.75, 0.25, 0, 1, 0, 0.5, 0, 0,
0, 0.5, 0.25, 0, 1, 0, 0.75, 0.5, 0.25, 0, 1, 0.75, 0, 0.75,
0.5, 1, 0.75, 0.75, 0.5, 0.75, 0.25, 1, 0.5, 0, 0.5, 0.75, 0,
1, 0.5, 0.75, 0.75, 0.5, 0, 1, 0.5, 1, 0.75, 0.25, 0.75, 0.25,
0.5, 0.25, 0.75, 0.75, 0.75, 0, 0.75, 0, 0.25, 1, 1, 0.5, 0.5,
0.25, 0.75, 0.25, 1, 0.75, 0, 0.5, 0.75, 0, 0.75, 0.25, 0, 0.75,
0.75, 0, 0, 0.75, 0.25, 1, 0, 0.25, 0, 0, 0.25, 0.25, 0.5, 0,
0, 0, 0.75, 1, 1, 0.5, 1, 0.25, 1, 0.5, 0.75, 0.75, 0, 0.25,
0.75, 1, 0, 0.75, 0.75, 0.25, 0, 0.25, 0.25, 0.75, 0.25, 0, 0.75,
0.25, 0, 0.75, 1, 0, 0, 0, 0.5, 0.5, 0, 0, 0.5, 0, 0.5, 1, 0.25,
0.25, 0, 0.5, 0.75, 0.75, 0, 0.75, 0, 0, 1, 0, 0, 1, 0.25, 0.5,
0.5, 0.5, 0, 1, 0.75, 0, 0.75, 0, 0, 0, 1, 0, 0.5, 0.75, 0.25,
0.5, 0.75, 1, 0.75, 0.5, 0.75, 0.75, 0.5, 0.5, 0.25, 0.75, 0.25,
0, 0, 0.5, 0.75, 0.25, 0.75, 0.5, 0.75, 0, 0.75, 0.75, 0.25,
0.5, 0.75, 0, 0.75, 0.75, 1, 0, 0, 0.75, 0.25, 1, 0.75, 0, 0.25,
0.75, 0.5, 0.75, 0.75, 0, 0.25, 1, 0.75, 0.25, 0.25, 0.25, 0.75,
1, 0.5, 0.75, 1, 0.5, 0.75, 0.75, 0.25, 0, 0, 0.75, 0.5, 1, 0,
0, 0, 0.75, 0.75, 1, 1, 0.75, 0.5, 0.25, 0, 0.75, 0.25, 0, 1,
0.75, 0.25, 0, 0.5, 0, 0.5, 0, 0, 1, 0, 0, 0.5, 0, 0, 0, 0, 0.75,
0, 1, 0.75, 0.75, 1, 0.75, 0.75, 0.5, 0.25, 0, 0.75, 1, 0.75,
0, 0.75, 0.25, 0, 0.25, 0, 0, 0.75, 0, 0, 0.5, 0.75, 0.25, 0.25,
0.5, 0.25, 0, 0.5, 1, 0.25, 1, 0.25, 1, 0.5, 0, 0.75, 0.25, 1,
0.75, 0.75, 0.5, 0.5, 0, 1, 0.5, 1, 1, 0.5, 0.25, 0.75, 1, 0,
0, 0.5, 0.5, 0.5, 0.75, 0, 0, 0.5, 0.75, 1, 0, 0, 0.25, 0, 0,
0, 0.75, 0.75, 0, 0.25, 0.75, 0.75, 0.25, 0, 0.25, 0.75, 0.5,
1, 0.75, 0, 1, 1, 1, 1, 0.75, 0.75, 0, 0, 0, 0.75, 0, 0.5, 0.25,
0.75, 0.5, 0.5, 0.25, 0.75, 0.25, 0.5, 0.25, 0.25, 0, 0, 0, 0.75,
1, 0.5, 0.5, 0.75, 0.5, 0.5, 0, 0.5, 0.25, 0.75, 0, 0.5, 0.75,
0, 0, 0.75, 0.25, 0.75, 0.75, 0.75, 0, 0.75, 0.75, 0.75, 0, 0,
1, 0.75, 0, 0.5, 0.75, 0.75, 1, 0.5, 1, 0, 0.5, 0.75, 0, 0.5,
0.75, 0, 0.75, 0, 0, 0.75, 0, 0.25, 0.75, 0.5, 0.5, 0.5, 0.5,
0, 0, 0.25, 0.25, 0, 0.5, 0.5, 0, 0.75, 0, 0.5, 0, 0.25, 1, 0,
1, 0.5, 1, 1, 0.25, 0.75, 0.75, 1, 1, 0, 0.75, 0.75, 0.75, 0.75,
0, 0.75, 0.75, 0.75, 0, 0.5, 0.25, 0, 0.25, 0, 0.25, 1, 0.75,
0.5, 0.5, 0, 0, 0.5, 0.25, 0, 0.25, 0.75, 1, 1, 0.75, 0.75, 0,
0.75, 0.5, 0.25, 0.25, 0.25, 0, 1, 0.5, 0, 1, 1, 1, 0.25, 0.75,
1, 0.75, 0.5, 1, 0.5, 0.5, 0, 0.5, 0.25, 0.75, 0.25, 0, 0.5,
0.75, 0.5, 0.5, 0.75, 0.25, 0.75, 0, 0, 0, 1, 0.5, 0, 0, 0, 0.5,
0.75, 1, 1, 0.75, 0, 0, 0.5, 1, 0.75, 0.75, 0.5, 0.75, 0.5, 1,
0, 0, 0.75, 0, 0.75, 0.75, 0.5, 0.75, 0.5, 0.5, 0.5, 0.5, 0,
0.5, 0.75, 0.75, 0.25, 0, 0.75, 0, 0.5, 0.75, 0.25, 1, 0.5, 0,
1, 0.75, 0.75, 1, 1, 1, 1, 0.75, 0, 0.75, 0, 0, 0.25, 0.5, 0,
1, 0.25, 0.75, 0.75, 0.5, 1, 0, 0, 0.25, 0.25, 0, 0.75, 1, 1,
0.75, 0, 1, 0.5, 0.75, 0.25, 0.25, 0.5, 0.75, 0, 0.5, 0.5, 0.75,
0, 0.75, 0, 1, 0.5, 0.75, 0.25, 0.75, 0.75, 1, 0.75, 0, 0.5,
0.25, 0, 0.25, 0, 0.75, 0.25, 0.5, 0.75, 0.25, 0.25, 0.75, 0.25,
0.75, 0, 0, 0.5, 0.25, 0, 0.75, 1, 1, 0.25, 0.25, 0.5, 0, 0.75,
0.75, 0.75, 0.5, 0.25, 0, 0, 0, 0, 0.75, 0.75, 0.5, 0, 0.75,
0.75, 0.5, 0.25, 0.25, 0.25, 0.75, 0.5, 0.75, 0, 0.75, 0, 0.75,
1, 0.5, 0.25, 1, 0, 1, 0.5, 0.75, 0, 0.75, 1, 0.5, 0.75, 1, 1,
0.5, 1, 0.75, 1, 0.5, 1, 0.5, 0.75, 1, 0.25, 0.25, 1, 0, 0, 1,
0.5, 0, 0.75, 0.75, 0.75, 0.5, 1, 1, 0, 0.75, 0, 0.75, 0.5, 1,
0.25, 0.5, 0.75, 0.25, 0, 1, 0, 1, 0, 0, 0.75, 0.25, 0.25, 0.5,
0, 0.75, 0.5, 0, 0, 0.25, 0, 0, 0.75, 0.25, 0.25, 0.5, 0, 0.5,
0, 0.75, 0.75, 0.25, 0.5, 0.25, 0.25, 0.25, 0.5, 1, 0, 0.25,
0, 0.25, 0, 0, 0.5, 0.5, 0, 0.5, 0, 0.25, 0.25, 0, 1, 0, 0, 0,
0, 0, 0.25, 0.25, 0, 0.75, 0.25, 0.25, 0.5, 0, 0, 0.5, 0, 0.5,
0, 0.5, 0.25, 0.25, 0.5, 0, 0.5, 0.5, 1, 0, 0, 0.25, 0.75, 0.25,
0.75, 0.5, 0.5, 0.25, 0.25, 1, 0.25, 0.25, 0.25, 0, 0.25, 0.5,
1, 0.75, 0.5, 0.75, 0, 0.5, 0.25, 0.25, 0.25, 0, 1, 0.25, 0.25,
0.5, 0.25, 0.5, 0.25, 1, 0.5, 0.75, 0.25, 0, 0.25, 0, 0.75, 0.5,
0, 0.25, 0.5, 1, 1, 0.75, 0, 0.5, 0.25, 0, 0.5, 0.25, 0, 0.5,
0.5, 0.25, 0, 0.5, 0.5, 0.5, 0, 0.25, 0.5, 0.25, 0.25, 1, 0.5,
0.25, 0.25, 0.25, 0.25, 0.25, 0.75, 0, 0.25, 0.25, 0.5, 0, 0,
0, 0.25, 0.25, 0.5, 0, 0, 0.75, 0.25, 0.25, 0.75, 0.5, 1, 0.75,
0, 1, 0.75, 0.25, 0, 0, 0.5, 0.25, 0, 0, 0.5, 0, 0.5, 1, 0, 0.5,
0.75, 1, 0.5, 0.75, 0.25, 0, 1, 1, 0, 0, 0.5, 0.5, 0, 0.75, 1,
0.5, 1, 0, 0.25, 0.25, 0.75, 0.25, 0.5, 0, 0.75, 0.25, 0.5, 0.25,
0, 0.75, 0.5, 1, 0.5, 1, 0.25, 0.5, 0.75, 0.25, 1, 0.25, 0.5,
0.25, 0.25, 0, 0.5, 0.5, 0.75, 0, 1, 0.25, 0.75, 0.25, 0.5, 0,
0, 1, 0.25, 0.5, 1, 0.25, 0, 0.25, 0.5, 0, 0.25, 0, 0.25, 0.25,
0.25, 0.5, 0.25, 1, 0, 0.25, 0.5, 0.75, 0.25, 1, 0.25, 0.25,
0, 0, 0.25, 0.5, 0, 1, 0, 0.5, 0.5, 0, 1, 0.25, 0.25, 0.25, 1,
0, 0.75, 0.75, 0.25, 0.25, 0.25, 0, 1, 0.75, 0, 0.75, 0, 0.75,
0, 0.5, 0.25, 0, 0.5, 0.5, 0.25, 0, 0.75, 0, 1, 0.5, 0.5, 0.5,
0.25, 0.5, 0.5, 0, 0.5, 0, 0, 0.5, 0, 0.5, 0, 0.75, 0.75, 0,
0, 0.25, 1, 0, 0.75, 0, 0.75, 0, 0, 0.5, 0, 0.25, 0, 0.5, 0.25,
0, 0.75, 0.25, 0, 0, 0.25, 0, 0.5, 0, 1, 0.25, 0.5, 0, 0.25,
0.75, 0, 0, 0.25, 0.5, 0.75, 1, 0, 0, 0.25, 0.75, 0.5, 0.25,
1, 0.75, 0.25, 0.5, 0.75, 0.5, 1, 0.5, 0.5, 1, 0, 0.5, 0.25,
0, 0.75, 0, 0.5, 0.5, 0.25, 0.25, 0, 0.75, 1, 0.5, 0, 0.25, 0.75,
1, 0, 0.5, 0.5, 0.25, 0.25, 0, 0, 1, 0.25, 0, 0, 0.25, 0.5, 0.25,
0.25, 1, 0.75, 0, 0.25, 0.25, 0.25, 0, 0.5, 0.5, 0, 0.5, 0.25,
1, 0.25, 0.75, 0.25, 0.25, 0, 0.25, 0.25, 1, 0, 1, 0.25, 0, 0,
0.25, 0.5, 0.5, 0.5, 0.5, 0.25, 0.25, 0, 0.5, 0.5, 0, 0, 1, 1,
0.25, 0, 0, 0.25, 1, 0.25, 0.75, 0, 1, 0, 0.5, 0.25, 0.25, 0.5,
0.25, 0.25, 0.5, 0.5, 1, 0.25, 1, 0.5, 0.25, 0.25, 1, 0.25, 0.25,
1, 0.5, 0, 0.75, 0, 0.25, 0, 0, 0.25, 0.75, 0.5, 0, 0, 0.75,
0.75, 0, 0.25, 0.25, 1, 0.75, 1, 0.5, 0, 0, 0.5, 0.5, 0.25, 0.25,
1, 0, 0.5, 0.5, 0.25, 0.5, 0.75, 0, 0, 1, 0.5, 0.5, 0.75, 0.75,
0.25, 0.5, 0.75, 0.75, 0.25, 0, 0.25, 0.25, 0.5, 0.75, 0, 1,
0, 0.25, 0.25, 0, 0.25, 0.25, 0.5, 0.75, 0.5, 0.25, 0.25, 0,
0.5, 0.25, 0.5, 0.5, 0, 0, 0.5, 0.5, 0, 0.5, 0.75, 0.25, 0.25,
0, 0.25, 0, 0, 0, 0, 0.75, 0, 1, 0, 0, 0.25, 0, 0, 0.25, 0.75,
0, 0.5, 0.75, 0.75, 0, 0.25, 0, 0, 0, 0.75, 0, 0.25, 0, 0.5,
0, 0, 0.75, 0.25, 0, 0.5, 0.5, 0.5, 0.75, 0.25, 0.75, 1, 1, 0,
0.75, 0, 0.25, 0.5, 0.5, 0, 0.75, 0.75, 0.5, 0.5, 0, 1, 0, 0.5,
0, 0.5, 0.25, 0.75, 0, 0, 0, 0, 0.5, 0, 0.5, 0.5, 0.75, 0.75,
0.25, 0.25, 0.25, 0.5, 0.75, 0.75, 0.25, 0, 0.75, 0.5, 1, 0.75,
0, 0.5, 0.75, 0.75, 0.5, 0.25, 0, 0, 0, 0.5, 0.25, 0.75, 0.5,
0, 0.5, 0.25, 0, 0.25, 0.5, 0.75, 0, 0.5, 0.5, 0, 0.75, 0.5,
0.75, 0.5, 1, 0.5, 0, 0.5, 0, 0, 0.25, 0.5, 0.25, 1, 0.25, 0,
0.5, 0, 0.5, 0, 0.5, 0, 0.75, 0.25, 0.5, 1, 1, 0, 1, 0.5, 0,
0.75, 0, 0, 0, 0.5, 0, 1, 0.75, 0.75, 0, 0.5, 0.5, 0.5, 0, 0.25,
0.5, 0.25, 0.5, 0, 0, 0.25, 0.75, 0.75, 0.25, 0.25, 0, 0, 1,
0, 0.75, 0, 0.25, 0.5, 0, 0, 0.5, 0.5, 0.5, 0.5, 0.5, 0.75, 0.5,
0.25, 0.25, 0, 0, 0.5, 0, 0.25, 0.25, 0.25, 0, 0.25, 0, 0.25,
0.5, 0, 0.25, 0.5, 0, 0.5, 0, 0.25, 0.5, 0.5, 0.5, 0, 0.75, 0.5,
0.75, 0, 0, 0.25, 0.5, 0.25, 0.75, 1, 1, 0, 0, 1, 0, 0.25, 0.25,
0.25, 0.5, 0.25, 0.75, 1, 0.5, 0, 0.75, 0.25, 0.25, 0.25, 0,
0.5, 0.5, 0, 1, 0, 0.75, 0, 0, 0.75, 1, 0.5, 0, 0.5, 0.25, 0.5,
0, 0.75, 0.5, 0.5, 0.5, 0, 0.75, 0, 0.5, 0.5, 0, 0.25, 0.25,
0, 0.5, 0.25, 0.5, 0, 0.5, 0, 0.25, 0.5, 0.25, 0.25, 0, 0.5,
0.5, 0.5, 0, 0, 0.5, 0.5, 0.5, 0, 1, 0.25, 0.75, 0.25, 0.25,
1, 0.5, 0.75, 0.75, 0.25, 0.25, 0.25, 0.5, 0, 0.75, 0.5, 0.75,
0.75, 0, 0.5, 0.25, 0.5, 0.25, 0, 0, 0.75, 0.5, 0.75, 0.5, 0.75,
0.5, 0.25, 0, 0.25, 0, 0.25, 0, 0, 0.5, 0.5, 0.75, 0, 0, 0.5,
0.5, 0, 0.25, 0, 0.5, 0.25, 1, 0.25, 0, 0, 0.5, 0, 0.75, 0.5,
0.5, 0, 0.5, 0.5, 0.75, 0.75, 0.75, 1, 0, 0.25, 0.25, 0.75, 1,
0.5, 1, 0.5, 0.5, 0.25, 0.75, 0.5, 0.25, 0.5, 0.5, 0.25, 0.75,
0.25, 0.25, 0.75, 0.5, 0.5, 0.25, 0.5, 0.25, 0.5, 0, 0.25, 0.5,
0.25, 0.5, 0.25, 0.5, 0.25, 0.5, 1, 0.25, 0, 0, 0.5, 0.5, 0,
0.5, 0.75, 0.25, 0, 0.75, 0.5, 0.25, 0.5, 0.5, 0, 0.5, 0.5, 0,
0, 0.25, 0, 1, 0, 0.75, 1, 0.25, 0.75, 0, 0.25, 0.5, 0.25, 0,
0.25, 0, 0, 0, 0.25, 0.75, 0, 0, 0.25, 0.5, 0.75, 0.75, 0.25,
0.75, 0.75, 0.5, 0.75, 0, 1, 0.5, 0.75, 1, 0.75, 0.5, 0.25, 0.75,
0.5, 0, 0.5, 0.75, 0.5, 0, 0.75, 1, 0.75, 0.25, 0.5, 0.75, 0.5,
0.75, 0.5, 0.75, 0.5, 0.75, 0.25, 0, 0.5, 0.5, 0.75, 1, 0, 0.5,
0, 0, 0, 0, 0.5, 0.75, 0, 0, 0.25, 0.75, 0.5, 0.5, 0, 0, 0.25,
0.75, 0.75, 0, 0, 1, 0, 0, 0.75, 0.75, 0.5, 0.25, 0.5, 1, 0,
0.75, 0.25, 0.5, 0.5, 0, 0, 0.75, 0.25, 0.75, 0.25, 0, 0.75,
1, 0.75, 0.75, 0.75, 1, 0, 0.25, 0.5, 0.5, 0.25, 0.5, 0, 0.25,
0.75, 1, 1, 0, 0, 0, 0.75, 0.25, 0, 0.5, 0.25, 0.5, 0.75, 0.75,
0.5, 0.5, 0.5, 0, 0.5, 0.5, 0.75, 0.75, 0.5, 0.25, 0.5, 0.5,
0.25, 0.5, 0.5, 0.75, 0.75, 0.5, 0.75, 0.25, 0.5, 1, 0.75, 0.5,
0, 0.5, 0.25, 0, 0.5, 0.75, 1, 0.5, 0, 1, 0.5, 0.25, 0.25, 0,
0.75, 0.5, 0, 0.5, 0.25, 0.75, 0.25, 0.5, 0.5, 0, 1, 0.75, 0.25,
1, 0, 0.75, 0.25, 0, 0.25, 0.75, 0.25, 0.25, 0.5, 0.25, 0, 0.5,
0.25, 0.75, 0.25, 0.5, 0.25, 0.5, 1, 1, 0, 0.75, 0.75, 0.25,
0, 0, 0.25, 0.25, 0, 1, 0.25, 0.5, 0.25, 1, 0.25, 1, 1, 0, 0.75,
0.75, 0.5, 0.5, 0.25, 0.75, 1, 0, 0, 0.5, 0.75, 0.5, 0.5, 0.5,
0, 0.5, 0.5, 0.25, 0.5, 0.5, 0, 0.5, 0.75, 0, 0.25, 0, 0, 0,
0.75, 0.5, 0, 0.75, 0.5, 0, 0, 0.25, 0.75, 1, 0.75, 0, 0, 0.75,
0.5, 0.75, 0.75, 0, 0, 0, 0.5, 0.5, 0, 1, 0.5, 0.5, 0.5, 0.75,
0.5, 0.5, 1, 0.25, 0.25, 0.25, 0.75, 0.5, 0.75, 0.25, 0.5, 0.75,
0.5, 0.5, 1, 0.25, 0.75, 0.75, 0, 0.25, 0.25, 0.5, 0.75, 0.75,
0.5, 1, 0.25, 0.25, 0.5, 1, 0, 0.5, 0.25, 0.25, 0.5, 1, 0, 0.25,
0.75, 0.25, 0, 0.5, 0.5, 0, 0, 0.5, 0.75, 0.25, 0.25, 0.25, 0.5,
0.75, 0.75, 0.25, 1, 0, 0.25, 0, 0.5, 0, 0.25, 0.75, 0.75, 1,
0, 1, 1, 0.25, 0.25, 0.25, 0.5, 0.25, 0.75, 1, 0.75, 0, 0.75,
0.25, 0.5, 0.25, 0.25, 0, 0.5, 0.25, 0.25, 0.25, 0.75, 0, 0.75,
0.75, 0.25, 0.25, 0.5, 0.25, 0.5, 0.5, 0.25, 0, 0.25, 0.5, 0.25,
1, 0.25, 0, 0.25, 1, 0.5, 0.25, 1, 0.25, 1, 1, 0.25, 0.75, 0,
0.5, 0, 0.75, 0.25, 1, 0.25, 0.75, 1, 0.75, 0.5, 0.5, 0.75, 0.25,
0.25, 0.5, 1, 0.25, 0, 0.5, 0.5, 0.75, 0, 0.25, 0.25, 1, 0.25,
0.5, 0.75, 1, 0.25, 0.25, 0.25, 1, 0, 0, 0, 0, 0, 0.75, 0.5,
1, 0.5, 0.5, 0.75, 0.5, 0.75, 0.5, 0.25, 0.5, 0.25, 0.25, 0.25,
0.25, 0.5, 0.25, 0, 0, 0.25, 0.5, 0.5, 0.25, 0.75, 0.25, 0.25,
0.25, 0.5, 0, 0.5, 0.5, 0.25, 0.75, 0.75, 0.75, 0.5, 0.75, 0.25,
0.75, 0.25, 0.25, 0, 0.75, 0.5, 0.75, 0, 0.5, 0, 0, 0.25, 0.25,
0.75, 0.5, 0.5, 0.75, 0.25, 0.25, 0.25, 0.5, 0.5, 0, 0.25, 0.5,
0.5, 0.5, 0.25, 0.25, 0.25, 0.25, 0.5, 0, 0.5, 0, 0.75, 0.5,
0.25, 0.25, 0.5, 0.25, 0.25, 0.25, 1, 0.75, 0.5, 0.25, 0.25,
0.5, 0.5, 0.5, 0, 1, 0.25, 0.25, 0.75, 0.75, 0.5, 0.25, 0.25,
0.5, 1, 0.25, 0.25, 0.5, 1, 0, 0.25, 0.25, 0.25, 0, 0.25, 0.5,
0.75, 0.75, 0.5, 0.25, 0.5, 0.5, 0, 0.25, 0.25, 0.5, 0.25, 1,
1, 0.25, 0.75, 0.75, 0.25, 0.25, 0.25, 0.5, 0.5, 0.75, 0.5, 0.25,
0.5, 0.5, 0.5, 0.5, 0, 0.25, 0.25, 0.5, 0, 0.5, 0, 0.25, 0.5,
0, 0.75, 0.5, 0.75, 0.5, 0.5, 0.5, 0, 0.75, 0.5, 0.5, 0.5, 0.5,
0.25, 0.25, 0.25, 0.25, 1, 0.25, 0.25, 0.75, 0.5, 1, 0.25, 0.25,
0.25, 0.25, 0.25, 0, 0.25, 0, 0, 0.5, 0.25, 0.5, 0.25, 0.25,
0, 0, 0.5, 0.5, 0.25, 0.25, 0, 0.5, 0, 0, 0.25, 0.25, 0.25, 0,
0, 0.5, 0.5, 1, 0.5, 0.75, 1, 1, 0, 0.5, 0.5, 1, 0, 0.75, 0.5,
0.25, 0.5, 0.25, 0.75, 0.75, 0.25, 0.25, 0.25, 0.5, 0.25, 0.25,
0.75, 0.75, 0.5, 0.75, 0.75, 0, 0.25, 0.75, 0, 0.5, 0.25, 0.5,
0.25, 0.25, 0.25, 0.75, 0.5, 0.5, 0.75, 0.75, 0.5, 0.5, 0.5,
0.5, 0.5, 0.25, 0.5, 0.5, 0.5, 0.75, 0, 0.25, 0.25, 0, 0.25,
0.25, 0.25, 0.25, 0.5, 0.5, 0, 0.25, 0.25, 0.25, 0.5, 0.75, 0.25,
0.25, 0.75, 0.5, 0.25, 0.25, 0.25, 0.75, 0.25, 0.25, 0, 0.25,
0.25, 0.5, 0.75, 0.25, 0.5, 0.5, 0.25, 0.25, 0, 0.25, 0.5, 0,
0.25, 0, 0.25, 0, 0, 1, 0, 0.25, 0, 0, 0.25, 0.5, 1, 0.5, 0.25,
0.25, 0.5, 0.75, 0.5, 0.25, 0.5, 0.75, 0, 0.5, 0.25, 0.25, 0.5,
0.25, 0.25, 0.5, 0.75, 0.5, 0, 0.25, 0.25, 0.75, 0.25, 0.75,
0.75, 0.5, 0.75, 0.5, 0.25, 0.75, 0.5, 0.5, 0.5, 0.5, 0.25, 0.5,
0.75, 0.25, 0.25, 0.25, 0.5, 0.5, 0.5, 0.25, 0.25, 0.5, 0.25,
0.5, 0.5, 0.75, 0.75, 0.75, 0.25, 0.25, 1, 0.25, 0.25, 0.5, 0,
0.75, 0.25, 0.5, 0.5, 0.5, 1, 0.5, 0, 0, 0.5, 0.25, 0.5, 1, 0.5,
0.25, 0, 0.25, 0.5, 0, 0.5, 0.5, 0.25, 0.25, 0.5, 0.75, 0.75,
0, 0.75, 0, 0.5, 0.25, 0.25, 0.25, 0.25, 0.75, 0.25, 0.25, 0.75,
0.75, 0.25, 0, 0.5, 0.25, 0.75, 0, 0.5, 0.5, 0.25, 0.25, 0, 1,
0.5, 0.25, 0, 0, 0.5, 0.5, 0.5, 0.5, 0.5, 0.25, 0.5, 0.25, 0.5,
0.5, 0.25, 0.5, 0.25, 0.25, 0.5, 0.5, 1, 1, 0.5, 0.5, 0.75, 0.75,
0.75, 0, 0.25, 0.25, 0.5, 0.5, 1, 0.25, 0.75, 0.25, 0.75, 0.5,
0.5, 0.25, 0.75, 0.5, 0.5, 0.25, 0.75, 0.25, 1, 0.75, 0.25, 0.75,
1, 0.75, 0.5, 0.5, 0.25, 1, 0.75, 0.75, 0.25, 0.75, 0.75, 0.5,
1, 1, 0, 0.75, 0.75, 0.25, 0.5, 1, 0, 1, 0.25, 0.25, 0.75, 0.75,
0.5, 1, 0.75, 0.25, 0.75, 0.75, 0.5, 0, 0, 0.5, 1, 1, 1, 0.75,
0.5, 0.5, 0.75, 1, 0.75, 0.75, 0.5, 1, 0.5, 1, 0.25, 0, 1, 0.25,
0.5, 0.5, 0.75, 1, 0.75, 0.5, 0.5, 0.5, 1, 0.5, 0, 0.75, 0.75,
0, 0.25, 0, 0.5, 0.5, 0.75, 0.5, 0, 0.25, 0.5, 0.75, 0.75, 1,
1, 0.75, 0.25, 0.75, 0.5, 0.75, 1, 1, 0.5, 0.25, 0.25, 0.25,
0.5, 0.25, 0, 1, 1, 1, 0.5, 0.25, 1, 1, 0.5, 0.75, 0.75, 1, 0.25,
0.5, 0.75, 0.25, 0.25, 1, 0.75, 0.25, 0, 1, 0.25, 1, 0.25, 1,
1, 1, 1, 0.25, 0.25, 0.25, 0, 0.75, 0.25, 1, 0.25, 0.75, 0.25,
1, 0.5, 0.25, 0.25, 0.25, 0.25, 0.25, 1, 1, 0.75, 1, 0.25, 1,
0.25, 0.5, 0.25, 0, 1, 0.75, 0, 0.25, 1, 0.75, 0, 1, 0.25, 1,
0.25, 0, 1, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.75, 0, 0.5,
0.25, 0.25, 0.25, 0, 0.5, 0.25, 1, 1, 0.75, 0.25, 0.75, 0.25,
1, 0.25, 1, 1, 1, 0, 0.75, 0, 1, 1, 0, 0.75, 0.5, 1, 1, 0.25,
1, 1, 0.25, 0.75, 0.5, 0, 0.25, 0.25, 0, 0.25, 1, 0.25, 1, 1,
1, 0.25, 1, 0.25, 1, 1, 0.25, 0.25, 0.5, 1, 0.75, 1, 1, 0.5,
0, 0.25, 0.75, 1, 1, 0.25, 0.75, 0.5, 0.75, 0, 0.25, 0.25, 0,
0, 0.25, 0.5, 0.25, 0.25, 0.5, 0.25, 0.25, 0.5, 0.25, 0, 0.75,
0.25, 0.5, 0.25, 0.25, 0.5, 0.75, 0, 0.25, 0.25, 0, 0.25, 0.25,
0.25, 0.25, 0.25, 0, 0.25, 0.75, 0.25, 0.5, 0.25, 0.75, 0.5,
0, 0.25, 0.25, 0.5, 0.25, 0.25, 0.25, 0.75, 0.25, 0.25, 0, 0.75,
0.25, 0.25, 0, 0.25, 0.25, 0.25, 0, 0.25, 0.75, 0.25, 0.25, 0.75,
0.25, 0.25, 0.75, 0.25, 0.25, 0, 0.25, 0, 0.25, 0.25, 0.25, 0.25,
0.75, 0.5, 0.5, 0, 0.75, 0.75, 0.25, 0.75, 0.75, 0.5, 0.5, 0.25,
0.5, 1, 0.5, 0, 0.25, 0.5, 0.75, 0.75, 0.25, 0.25, 1, 0.75, 0.5,
0.75, 0.75, 0.75, 0.25, 0.25, 0.25, 0.25, 1, 0.25, 0.25, 1, 0.25,
0.25, 0.25, 0.5, 0.5, 0.5, 0.75, 0.5, 0.5, 0.25, 0.75, 0, 0.75,
0.5, 0.75, 0.75, 0.75, 0.25, 1, 0.75, 0.75, 0.75, 0.5, 0.75,
0.5, 0.5, 0.25, 0.25, 0.75, 0.5, 0.5, 0.25, 0.25, 0.75, 0.75,
0.75, 0.25, 0.5, 0, 1, 0.25, 0.75, 0.75, 0, 0.75, 0.5, 0.75,
0.75, 0.25, 0.75, 0.5, 0.5, 0.5, 0.75, 0.25, 0, 0.75, 0.25, 0.75,
0, 0.25, 0.5, 0.75, 0.5, 0.5, 0.5, 0.75, 0.5, 0.75, 1, 0.5, 0.25,
0.25, 0.75, 0.25, 0, 0.25, 0.75, 0.25, 0.75, 0.5, 0.5, 1, 0.5,
0.75, 0.25, 0.5, 0, 0.5, 0.5, 0.75, 0.25, 0.5, 0.5, 0.5, 0.5,
0.25, 0.5, 0.75, 1, 0.25, 0.75, 0.5, 0.5, 0.75, 0.5, 0.5, 0.5,
0, 0.75, 0.5, 0.5, 0, 0.75, 0.5, 0.25, 0.25, 0.75, 0, 0.75, 0.5,
0, 0.75, 0.5, 0.25, 0.25, 0.25, 0.75, 0, 0.25, 0.5, 0.75, 0,
0.75, 0.5, 0.25, 0, 0.75, 0.25, 0.5, 0, 0.5, 0.75, 0.25, 0.5,
0.5, 0.5, 0.75, 0.5, 0.5, 0.25, 0.25, 0.25, 0.75, 0, 1, 0.75,
1, 0.5, 0.5, 0.25, 0.75, 0.5, 0.75, 0.75, 0.25, 0.5, 0.25, 0,
0.5, 0.25, 0.75, 0.5, 0.25, 0.5, 0.25, 0.25, 0.25, 0.25, 0.25,
0.25, 0.5, 0.25, 0.5, 0.5, 0.5, 0.25, 0.5, 0.25, 0.75, 0.5, 0.5,
0.5, 0.5, 0.75, 0, 0.5, 0.75, 0.5, 0.75, 0.25, 0.5, 0.5, 0.5,
0.25, 0.25, 0.5, 1, 0.25, 0.5, 0.75, 0.75, 0.75, 0.5, 0.5, 0.75,
0, 0, 0, 0.25, 0.25, 0.25, 0, 0, 0, 0, 0.5, 0.5, 0.5, 0, 0.5,
0.25, 0.25, 0.5, 0.25, 0.5, 0.5, 0.25, 0, 0, 0.25, 0.25, 0, 0,
0.5, 0.5, 0.25, 0, 0.25, 0, 0, 0.25, 0.25, 0.25, 0.25, 0.25,
0, 0.5, 0.25, 0.75, 0.25, 0.25, 0.25, 0.25, 0.25, 0, 0, 0.5,
0.25, 0.25, 0.5, 0.25, 0.5, 0.75, 0.25, 0.5, 0.5, 0, 0, 0.25,
0.5, 0, 0.5, 0.25, 0.25, 0.5, 0.5, 0.75, 0.75, 0, 0, 0.5, 0,
1, 0.75, 0, 0.75, 0.25, 0.75, 0.75, 0.5, 0.75, 0.75, 0.5, 1,
0.75, 0.75, 0.5, 0.25, 0.5, 0.75, 0.75, 0.5, 0.5, 0.25, 1, 0.75,
0.5, 1, 0.75, 0.5, 1, 0.75, 0.75, 0.5, 1, 0.75, 1, 0.5, 0.75,
0.75, 0.5, 0.5, 0.75, 0.5, 0.75, 0.5, 0.75, 0.75, 0.75, 0.75,
0.25, 0, 0.75, 0.5, 0.25, 0.25, 0.75, 0.75, 0.25, 0.5, 0.5, 0,
0.25, 0.5, 0.75, 0.25, 0, 0.5, 0.25, 1, 0.75, 0.5, 1, 0.5, 0.75,
0.5, 1, 0.75, 1, 0.75, 0.75, 0.75, 0.75, 1, 1, 0.75, 1, 0.75,
0.5, 0.75, 0.5, 0.75, 0.75, 0.25, 0.75, 0.25, 1, 0.75, 0.5, 1,
0.75, 1, 0.75, 1, 0.75, 0.75, 0.75, 1, 0.5, 1, 0.5, 0.5, 0, 0.5,
0.25, 0.25, 0.5, 0.25, 0, 1, 0.75, 0.25, 0.25, 0.75, 0.25, 0.5,
0.25, 0.25, 0.25, 0.25, 0.25, 0.5, 0.75, 0.5, 0.25, 1, 0.25,
0.75, 0.5, 0, 0.25, 0.5, 0, 0.5, 0, 0.25, 0.5, 0.25, 0.25, 0.25,
0.25, 0.25, 0.25, 0.25, 0.25, 0, 0.25, 1, 0.25, 0.25, 0.75, 0.25,
0.5, 0, 0, 0.25, 0.25, 0.25, 0.25, 0.25, 0, 0.5, 0.25, 0, 0.25,
0.25, 0.75, 0, 0.75, 1, 0.5, 0.75, 0, 0.25, 0.25, 0.5, 0.5, 0.25,
0, 1, 0.25, 0.25, 0.5, 0.5, 0, 0.25, 0.25, 0.25, 0.25, 0.5, 0.5,
0.75, 0.5, 0.75, 0.25, 0, 0, 0.25, 0.25, 0.5, 0.25, 0.25, 0.25,
0.25, 0.25, 0.25, 0, 0.25, 0.75, 0.25, 0.25, 0.25, 0.25, 1, 0.25,
1, 0, 0.75, 0.25, 0.5, 0, 0.25, 0.25, 1, 0.25, 0, 0.75, 0.5,
0.25, 0.25, 0.25, 0.25, 1, 0.25, 0, 0.5, 0.5, 0.25, 0.5, 0.25,
0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.5, 0.25, 0.25, 0.75, 0.75,
0.25, 0.25, 0.25, 0.5, 0.5, 0.25, 0.75, 0.25, 0.25, 0, 0.25,
0, 0.5, 0, 0.25, 0.25, 0.25, 0.25, 0.5, 0, 0.25, 0.5, 0.25, 0,
1, 0.25, 0.25, 0.5, 0.25, 0.25, 0.25, 0.25, 0.75, 0.25, 0.25,
0, 0.5, 0.25, 0.25, 0.25, 0.25, 1, 0.25, 0.25, 0.25, 0.25, 0,
0, 0.25, 0.75, 0, 0, 0.25, 0, 1, 0.5, 0.25, 0.5, 0.25, 0.5, 0.25,
0, 0.25, 0.25, 0.75, 0, 0, 0.25, 0.25, 0.5, 0.25, 0.5, 0, 0.25,
0.25, 0.25, 0.25, 0.5, 0, 0.25, 0.25, 0.25, 0.75, 0.25, 0.25,
0.5, 0.25, 0.25, 0.5, 0.5, 0.25, 0.5, 0.25, 0.25, 0, 0.5, 0,
0.25, 0.25, 0, 0, 0.75, 0.25, 0.25, 0, 0.25, 0.25, 0, 0.25, 0.25,
0.5, 0.25, 0.75, 0.25, 0.25, 0, 0.75, 0.5, 0.75, 0.25, 0.25,
0.25, 0, 1, 0.25, 0.5, 1, 0.25, 0.25, 0, 0.25, 0.75, 0.25, 0.25,
0.25, 0.25, 0.25, 0, 0.25, 0.5, 0.5, 0.25, 0.25, 0.25, 1, 0.75,
0.25, 1, 0.5, 0.5, 0.25, 0.25, 0, 0.25, 0.25, 0.5, 0.5, 0.5,
0, 0, 0.25, 0.75, 0.25, 0.25, 0.25, 0, 0.25, 0.25, 0.25, 0, 0.5,
0, 0.75, 0.25, 0.25, 0, 0, 0.25, 0, 0.25, 0.25, 0.25, 0, 0.25,
0.5, 1, 0.25, 0, 0.5, 0.25, 0.25, 0, 0.75, 0.25, 0.25, 0.25,
0.25, 0, 0, 0.25, 0.75), fev1pps = c(0.29246140737532073, 0.2404682682863748,
0.41594511271156726, 0.30415985871188106, 0.32170754811285279,
0.31260873885538304, 0.18067615337563458, 0.28206278947443575,
0.22941972127152135, 0.21382179442019425, 0.38344940078097606,
0.39449794779582953, 0.3587526646721792, 0.23071955470719746,
0.40294682793933079, 0.3444545464642666, 0.26646483783084773,
0.36525180705829746, 0.29246140737532073, 0.326256952741588,
0.35095368885038486, 0.24501767291511004, 0.37305078288009108,
0.26451510007346474, 0.34705421333561814, 0.33860530839985598,
0.37045111600873959, 0.37954992526620934, 0.38994854316709426,
0.27946312260308426, 0.26256536231608107, 0.32495711930591192,
0.44064187361262502, 0.43024320612721889, 0.23396912590025656,
0.28596226498920246, 0.2209708411280201, 0.272963980216966, 0.29896054976143893,
0.3119588345336754, 0.2209708411280201, 0.25346655305861127,
0.26646483783084773, 0.17547684442519243, 0.37045111600873959,
0.35095368885038486, 0.27946312260308426, 0.26646483783084773,
0.29246140737532073, 0.20797255635578363, 0.27946312260308426,
0.21447169874190186, 0.2209708411280201, 0.60344863321258535,
0.29345914711449811, 0.56631711562475706, 0.41639816648340211,
0.49967779978008248, 0.90523604612233011, 0.85038773112337229,
0.70227782365998837, 0.86668080817216175, 0.53072281736870441,
0.59173711635464099, 0.75124000971063098, 0.73348885022618593,
0.35223966341233554, 0.46262303903134883, 0.25538019328443107,
0.52252312423739011, 0.7231852362682637, 0.68530077772329823,
0.60558532940782606, 0.70627988954948551, 0.70627988954948551,
0.58860659759741207, 0.64320084150882939, 0.4833735166294586,
0.49421343677061169, 0.52186498888513355, 0.54539219968043806,
0.40360181467447925, 0.68780608525046705, 0.23490875258037858,
0.66238023354706232, 0.71838223160493553, 0.72325202661855659,
0.68451337552380986, 0.6936658848179309, 0.68426431247292885,
0.72837817360770718, 0.75867377074021503, 0.54141160388869569,
0.74331308103142213, 0.88088955028029003, 0.68968608237853579,
0.78052155379643184, 0.518627367561727, 0.86133222502010875,
0.75576301058173478, 0.78809315979544226, 0.58522076813960466,
0.63717076869495126, 0.80895470672143854, 0.69747541401092095,
0.52260062484430425, 0.82645749733830554, 0.44170407322959493,
1.0584922814750641, 0.55229590217648272, 0.52592273819214064,
0.68436868789042871, 0.68893552147842696, 0.51441684834435286,
0.49576156469709026, 0.65322390624479443, 0.74766109812657977,
0.50092490007727253, 0.31188398669865475, 0.61506083227420794,
0.29352752416947908, 0.33645259640421005, 0.29238539430404759,
0.60631714735885067, 0.40909416814626892, 0.57243158129402139,
0.42658019919490586, 0.60813779181482497, 0.44640190912307592,
0.58990655499439071, 0.55282720032305332, 0.58905984970733227,
0.6423601359488571, 0.72226643508712107, 0.60109024462226102,
0.82664056339123237, 0.4312204178745459, 0.525365209833761, 0.68165373700687271,
0.39511891954931261, 0.23261065876805048, 0.74622726252187976,
0.59461901832167896, 0.73401092565177639, 0.51760027378589302,
0.49388260884397456, 0.35266321439395015, 0.81133446624047778,
0.75904862972183462, 0.40409818052573854, 0.802284051475876,
0.69105878026837642, 0.68595816930773845, 0.41154646982008347,
0.62434126963348724, 0.60057124343699264, 0.48913543635172202,
0.68151157818408115, 0.43416152376010958, 0.58120060389980255,
0.41062342916236255, 0.5034681893478169, 0.8069083039396292,
0.49001298321107767, 0.48854711600556633, 0.45981948060808908,
0.68049886391944903, 0.27142487667337845, 0.52045733390772064,
0.22701596284413636, 0.50807979775862111, 0.38639372966042912,
0.35315521680732781, 0.37527531805495368, 0.78154954009364441,
0.55533989594390643, 0.82756481886972377, 0.44052029236620521,
0.40721444373307214, 0.57702662847468478, 0.56362794869231747,
0.52785420405339545, 0.60513430860136719, 0.36658776281779698,
0.54163131290292377, 0.6457031243801935, 0.49967779978008248,
0.26654556143165209, 0.5321764867819565, 0.46086977993992745,
0.51943271935795576, 0.6036823250618415, 0.24515812107191406,
0.4100980067815756, 0.84839929264705427, 0.50384200705448923,
0.30711645976037616, 0.33481905913965693, 0.10273698996369594,
0.3976470111640541, 0.35659191998406969, 0.49446061560968352,
0.47053271229711979, 0.36767413488893835, 0.37905695595466454,
0.44639422352226255, 0.70191436911828475, 0.31683262110126831,
0.47256865274492016, 0.43915825514846013, 0.60097272930659451,
0.23630787902011485, 0.5899967988232997, 0.71726132391465669,
0.22443508850638696, 0.21072224119656574, 0.29671030501224133,
0.54547411330975504, 0.55682346482355016, 0.59086948639956072,
0.53637267607265204, 0.2749408407075431, 0.54453572624266777,
0.71329560347932741, 0.76173725122453939, 0.32862250629525108,
0.32317961338353635, 0.68014676423313669, 0.74545503318592954,
0.37068183278671352, 0.61575779230670336, 0.12347334217127863,
0.60121569346134884, 0.43324862313701029, 0.45713006575304221,
0.57214790824721506, 0.19378938746455687, 0.53271661097333212,
0.78835749487891027, 0.60674798726510804, 0.25513512178751807,
0.40648222910587611, 0.5000244947535607, 0.50606522823953515,
0.43395535132021756, 0.44617466326159849, 0.23663838464736273,
0.39529668005845425, 0.54967873196908479, 0.59004058195567699,
0.45084101298400453, 0.52624627719413508, 0.52048653919081256,
0.59647804119720027, 0.45030178131401333, 0.42920292286869888,
0.39358608844767945, 0.46582153816738803, 0.58860158956075259,
0.48600804141933945, 0.57932888738680843, 0.71132536252235556,
0.30783057603726838, 0.69550130546127786, 0.29649369503059991,
0.7088387483597447, 0.5001049704317585, 0.85261387779517994,
0.53984076625142585, 0.5753271685889596, 0.49990058303463591,
0.47663557518838168, 0.5323010430996592, 0.59195127190247476,
0.51148913027956167, 0.31958805774653015, 0.35323988237758147,
0.44927905097606147, 0.72710186802742782, 0.55891305572348193,
0.69997457305743793, 0.40283945265828586, 0.77711192376836213,
0.75193706891217404, 0.67211907980648344, 0.68804339676978721,
0.55406160698276974, 0.3581041735093306, 0.41968309144020416,
0.58524397369560976, 0.78716151622326003, 0.4635622690352994,
0.4407928584802227, 0.59206139912445632, 0.41525655725544519,
0.45004627227535027, 0.55978832169485437, 0.26687388533995976,
0.63015441016633411, 0.64022730734628375, 0.40965452282236658,
0.29450525655428067, 0.48468453137470491, 0.58809855459136817,
0.54273446933455227, 0.49883763964984573, 0.44054513421141545,
0.64370700030306083, 0.52384276668935659, 0.4102254142092579,
0.36355093401371263, 0.62547021001623215, 0.59027114998008678,
0.50324600110752027, 0.17176836848677574, 0.37930053991593649,
0.42422602528889897, 0.53804897998689405, 0.24323136574018975,
0.51898239273479663, 0.42986909091341829, 0.46630121882720321,
0.6384822792854119, 0.49878790637490339, 0.32404860691295517,
0.45986782551643263, 0.52423716197240111, 0.79456473318767651,
0.48284856530162445, 0.46949426366589103, 0.5413696553836097,
0.52068517478345477, 0.53151329380851942, 0.54812534808334024,
0.63579053395786023, 0.62429109009785244, 0.38017798760624982,
0.68803114939300813, 0.33791873632458874, 0.60095239965282876,
0.68932044611788734, 0.23004458540993336, 0.39987489329410997,
0.45445012154157888, 0.69749455363617263, 0.661520983376095,
0.51076038656886213, 0.54289338772556994, 0.38222753900516765,
0.51798693388360229, 0.60302448721671342, 0.1474768866712044,
0.40994590626224719, 0.49536146719408714, 0.57318263803934077,
0.59976256947783169, 0.41301104782803899, 0.44613985492759112,
0.46236867043667673, 0.41994975699617781, 0.11800530990722528,
0.53896733490734461, 0.38099856185054165, 0.68059952049784445,
0.36908593017388724, 0.49408431867694208, 0.51388802942385203,
0.3818283092312893, 0.56486215701394848, 0.59703398285089582,
0.65844540426855191, 0.29778435532982023, 0.40041543895391712,
0.41335630485039732, 0.70267162392877502, 0.16479947474124779,
0.43423143793525282, 0.43977126858626181, 0.5134885269351056,
0.61740945271382042, 0.68566333974362093, 0.45501578176146446,
0.65142284767476177, 0.13313549357225907, 0.32644653915907834,
0.76601312284109113, 0.3717335700696725, 0.54435484190867911,
0.68948288500992727, 0.66196193852471108, 0.38657761385796158,
0.28796909932295323, 0.45161155644622569, 0.60075812749806823,
0.44876143815739183, 0.5192893705066508, 0.18844335791535566,
0.27755471354427019, 0.41241952928025488, 0.51023687319214861,
0.50507443033335075, 0.70776643350041268, 0.538702206471534,
0.5457969085439287, 0.57114402002738651, 0.3911921477555268,
0.26259977397391782, 0.59283293427710559, 0.60319019868716062,
0.30928528672546973, 0.5015056835761782, 0.25339760578163451,
0.42942089642467807, 0.22666155747758382, 0.54379711521221408,
0.49341472930024727, 0.41104405465721611, 0.4609593295855367,
0.33195364402597771, 0.41124348360220042, 0.58236043543936644,
0.41860502477639383, 0.43336742765023328, 0.58909738519001598,
0.90214276534065918, 0.53271656138881096, 0.66789601570520107,
0.36453174063883875, 0.77250229873841092, 0.5582446067907787,
0.49561325739364703, 0.84191839736480012, 0.57809676161507517,
0.54431676099626036, 0.58003888814842686, 0.53379581808113474,
0.17494327778676944, 0.59216617121812887, 0.32075170729424013,
0.38593482491507158, 0.64807802461613684, 0.50860931086242156,
0.52550880660767296, 0.32622744995136777, 0.35489756730404576,
0.40009492460772678, 0.43530762038725135, 0.45099968345241559,
0.64125727702435775, 0.40096505858113718, 0.3718754313853363,
0.52522562940608042, 0.61239918475113309, 0.33122675973482985,
0.44131790897709927, 0.66842438836501006, 0.73192460733025522,
0.39484464276930775, 0.48490721546021592, 0.53550514528661464,
0.38038192874267923, 0.28013543912845473, 0.39748489457140734,
0.20803914836799509, 0.31303762017304576, 0.41775936076428394,
0.48838194996485468, 0.5203939648893986, 0.36482756189338311,
0.56394057909960849, 0.5954848136494687, 0.32423660662576137,
0.38854200384141202, 0.49767354384144386, 0.37802621771651007,
0.35230910653452602, 0.18573527448800994, 0.43802460423618406,
0.53569351688333133, 0.49189347618435625, 0.39914017464858453,
0.45804896610322782, 0.41207935467133822, 0.4083164845129692,
0.42289453213632339, 0.4348324023343601, 0.50210421833373819,
0.2036497653858787, 0.41699357741611498, 0.57010016668332697,
0.5342492685291409, 0.57724703167221192, 0.50785889871588008,
0.4929304372799439, 0.29102809240809396, 0.44698358514336672,
0.36641034940030492, 0.69037619974708164, 0.4766917048665823,
0.38845128895955033, 0.42381105242948286, 0.42737836123553546,
0.48442525391241698, 0.31358949589598867, 0.13840723311230529,
0.6297618495105809, 0.80131898793628509, 0.52160050504810063,
0.48416047256825578, 0.57331884671956779, 0.63508058278076351,
0.31722047122749042, 0.33830723104958937, 0.54731716996939228,
0.28126698269857209, 0.43794759947448347, 0.62567519242761083,
0.52422392290519271, 0.36767413488893835, 0.3816570690867086,
0.44315213959193145, 0.26333640162351596, 0.31850027251652979,
0.35085672631882897, 0.41737607241402808, 0.59092878948712957,
0.62558589070460813, 0.50151381543768481, 0.6527427876338574,
0.3812093456509219, 0.54648657965178205, 0.49217283537780215,
0.47224511374292566, 0.45503095462500587, 0.53546979152287177,
0.1992379702000994, 0.49795984486788292, 0.53228026718520172,
0.39329715944160709, 0.21368918061776773, 0.32591154696566554,
0.76890965224193231, 0.53640307138425736, 0.5764340438596911,
0.41777740953006576, 0.23781043877144606, 0.44124115213800524,
0.66066346866337866, 0.21418500103929147, 0.32304575996807522,
0.19818486934280252, 0.10739722219577745, 0.42918457659578857,
0.30973256390056458, 0.5527906069462758, 0.45990699728832168,
0.3078541038926626, 0.34720113227246258, 0.55038005543946189,
0.41228981617232852, 0.24967891543181348, 0.10819281823742502,
0.58579951867313385, 0.63902304807556543, 0.63810796573352602,
0.50557310186485416, 0.24937233433613057, 0.6724677581608185,
0.23605152704458796, 0.49691430565009681, 0.26219811455849151,
0.30963041978652472, 0.24867582056432772, 0.34060207707576656,
0.43559937571104174, 0.53067219157237711, 0.40872248257401561,
0.42739621166323144, 0.41675418334689968, 0.38885969186988378,
0.46506770468887121, 0.27979087628939614, 0.4082375707471953,
0.41303732762436984, 0.24339534175238806, 0.57054503900913467,
0.3820197798605921, 0.11581828542278561, 0.56258027734011173,
0.63952206669871825, 0.58124929589979635, 0.25866496948766904,
0.34368811851731984, 0.67936679971185709, 0.62456722629740891,
0.2628039878252153, 0.41878754539958779, 0.41190915580170606,
0.31490125440905581, 0.55032566121950943, 0.41115442980180483,
0.46981760432979947, 0.29961471835198517, 0.67672726688531748,
0.51961162031108954, 0.45168226397371164, 0.43498388304717089,
0.57031080173014292, 0.58720871077071035, 0.39209602399573512,
0.74346714013934767, 0.66376671593384817, 0.5822560600218647,
0.24345598362203444, 0.2023754307903215, 0.33872379061368968,
0.30493317890729982, 0.5447730377619846, 0.69398208531076289,
0.15037347805270079, 0.47340787076925056, 0.54904350466570495,
0.61048695768417294, 0.35656400389853354, 0.46484427683553992,
0.44989736995765106, 0.6364191665198965, 0.10856028912536086,
0.43532294200435689, 0.62252320357262458, 0.58232443707684567,
0.66690581281327366, 0.26551192249899619, 0.48597774527677712,
0.52438462633898042, 0.69861159373378667, 0.59141769286792101,
0.76736078054763746, 0.43536593178439215, 0.61393754452690052,
0.47725885262210893, 0.36519275189333511, 0.43472525018366082,
0.43545344846462541, 0.17663913039856458, 0.51614997612009439,
0.29179652852815707, 0.434289501409787, 0.25994677894982343,
0.49771940952371896, 0.56899502687084369, 0.45858036341884073,
0.37727221069216815, 0.39665906436784876, 0.67330538948046226,
0.49318956598866764, 0.26519239984323378, 0.17493385672770712,
0.59260370503477278, 0.59589953858627753, 0.34869315531300143,
0.35722352761738813, 0.49225266645722138, 0.18998955204550053,
0.32413208245469544, 0.37255045026712152, 0.48552821200595936,
0.564680727250225, 0.32458260741594053, 0.46261356838776535,
0.48070581979477561, 0.26003997305775439, 0.55217868436794382,
0.52110624653900017, 0.46367244584180217, 0.26885587782849962,
0.62003445727559658, 0.28467832339262839, 0.38423424937761513,
0.52729727070927246, 0.45016815102889846, 0.46350931276646712,
0.39467335304020584, 0.48377287036464089, 0.55985119486796209,
0.57046897635334037, 0.31551788751691823, 0.53474660127856666,
0.33085232222164063, 0.62523582398367639, 0.58109127003016314,
0.33242563908497891, 0.37683475125230698, 0.51545876789207878,
0.24111083409891854, 0.49957238308763213, 0.44536460093583879,
0.37427502471292562, 0.29728283268833794, 0.7019709450571765,
0.42248650110989971, 0.6251450347250318, 0.37074401177652222,
0.50814252217816458, 0.25098055870251995, 0.48262449284951525,
0.34966692093609208, 0.51174344928971194, 0.28919351470161225,
0.5098223465934244, 0.4107192264576659, 0.38203284538197546,
0.50186422925026619, 0.87359646053786244, 0.75405060913592759,
0.34047295898209751, 0.21034525008052521, 0.28616575986493936,
0.38259374548780867, 0.49432534903536268, 0.58455534386270558,
0.29427778756245632, 0.37268569204918139, 0.32666039719978374,
0.47727650471171945, 0.46387732908413848, 0.45385069426263452,
0.46944041487567367, 0.60106936953876111, 0.51516894636462141,
0.39586000980583474, 0.69487688758355903, 0.62822393599550663,
0.20201595540645817, 0.23888052232731469, 0.45240272706934032,
0.58817481558524787, 0.49152689781780479, 0.61086578342750419,
0.31099682044215143, 0.47700126103354806, 0.36997017094362888,
0.31752697794639129, 0.45482026999366931, 0.4419545742315984,
0.55647151389080585, 0.27439079961189211, 0.37314221673751286,
0.39083771759671332, 0.39216883886537912, 0.37401547453576961,
0.29330146833651444, 0.1368125329241219, 0.44832588772160342,
0.50026388882277606, 0.25639087458368859, 0.59436405471275078,
0.15615431426987023, 0.57620436835666577, 0.30498087921686612,
0.31046093572735356, 0.33494978873027165, 0.60387748973798716,
0.36201160733977883, 0.37391298333008094, 0.29277614512477046,
0.59849365199123539, 0.26142970323068926, 0.47861127044270629,
0.37711207748037617, 0.35667361048304047, 0.40286022857274345,
0.41182468856953841, 0.1924104047366311, 0.55375616633107849,
0.35225706757933894, 0.66306712792171552, 0.34720113227246258,
0.55416176771595416, 0.27099118565714153, 0.58603628476271663,
0.57821541737473403, 0.6223120230960737, 0.36370861279169564,
0.57629287672732643, 0.39612008062046483, 0.23263153385155108,
0.24258575047958172, 0.38481394201705049, 0.49858257687187529,
0.38107759957761955, 0.65785381134398768, 0.29090093290301883,
0.49817766967029864, 0.37665267688980497, 0.40093414263205729,
0.37965236688737747, 0.41241122387292389, 0.27585493135915512,
0.34192923158272204, 0.57567906993718276, 0.46003487576895674,
0.45255648867013493, 0.4604241142617776, 0.66463107331051918,
0.43379856506361891, 0.38370686840823365, 0.47250453995877711,
0.43740340935235467, 0.32040030179123075, 0.18279982123788363,
0.40842807447833096, 0.34889816251664035, 0.51547765959472391,
0.3814797052537377, 0.20172707598490699, 0.53072281736870441,
0.28853932131880572, 0.39358608844767945, 0.3013845386735467,
0.52107778502372915, 0.54856660073908725, 0.34699104265538205,
0.40641412476576261, 0.55163345297086641, 0.63537997412084679,
0.20153271705723419, 0.33434255188920992, 0.22003290032162523,
0.53711922062652617, 0.49448208570744023, 0.36982979716360687,
0.21595023479262576, 0.13682404892921216, 0.44415806077713593,
0.33757734689489838, 0.54509935349717653, 0.51732993897533808,
0.42336935351304333, 0.38590425605764184, 0.39526085524175847,
0.46321745827363364, 0.44183562096481194, 0.63650227017772687,
0.48456860276372249, 0.38749440686598841, 0.52343086807026562,
0.45940321855111649, 0.41199868065505507, 0.41753955258101338,
0.50049401058649334, 0.28750905413360406, 0.26976724133143531,
0.29387424393521822, 0.45321774784723839, 0.48439094142362316,
0.52367388180954177, 0.22681450093377542, 0.26495868320171606,
0.57302317421858762, 0.39417934245371183, 0.50026150876574993,
0.28490435443333212, 0.34358718922405374, 0.48382637206320805,
0.35250268450598754, 0.19607228362108203, 0.3295710829814813,
0.47558140826387535, 0.546324140759746, 0.50324798448837504,
0.23714303111369206, 0.45067495442190775, 0.4904530458383119,
0.41788054533453295, 0.32784812003262287, 0.51777738969625731,
0.29237103958510846, 0.59022454052999151, 0.44795653262185503,
0.22455746310514951, 0.47880757556284342, 0.44414467295636406,
0.1860832214706529, 0.70448859913016659, 0.3862864039639054,
0.26498992145018463, 0.41860502477639383, 0.32744182446444753,
0.25598026516215339, 0.47444319557563291, 0.31321171142760607,
0.063455791234091313, 0.57665191824662809, 0.41054191220921687,
0.41455659735940603, 0.24634760415526241, 0.5015056835761782,
0.49983285057843346, 0.3206286137199183, 0.12006862101082617,
0.15312688173258596, 0.55368397126795144, 0.25692824683412757,
0.3789903143579319, 0.16003797232231701, 0.4174479203855056,
0.27463101182570981, 0.53627712669995586, 0.2492002760469475,
0.24373308671975807, 0.4355739388515748, 0.19901135654126909,
0.35256570643265944, 0.34938210744529419, 0.54196471922467249,
0.39511468007273426, 0.2679874793133375, 0.1543299261825313,
0.47461044416624248, 0.60868257695121053, 0.46720221916517102,
0.3347949114777457, 0.27434116550599219, 0.47146485171451374,
0.50015391035435874, 0.41615435939178452, 0.20709212119805728,
0.35697500999623949, 0.47394427612152246, 0.25826169857529768,
0.39218963957209768, 0.56433199931137012, 0.45004627227535027,
0.22305076304628232, 0.35058901948790677, 0.51151327794147283,
0.28411551428272247, 0.4341306326032906, 0.22157792921551761,
0.53372972191413692, 0.20361996508853011, 0.71920136789810618,
0.53890064372609014, 0.4644456668681779, 0.37461733145626203,
0.45548653720743165, 0.41993170823039588, 0.67516540404641612,
0.51364263562754964, 0.43403904999230469, 0.24713917145454772,
0.38678289377646796, 0.19186066114810787, 0.18467669454110147,
0.43460555314905347, 0.2979890898185924, 0.18133769766373634,
0.36801487971985147, 0.30543289171375243, 0.21443024608202965,
0.38870464107153341, 0.59703403243541686, 0.35445904179697513,
0.40826092505676442, 0.5575624725301751, 0.38799067354820471,
0.3884348516907134, 0.35409090151800049, 0.64738939478323276,
0.32517392762563929, 0.68525917630986644, 0.4407928584802227,
0.49363701670958693, 0.54445182923249513, 0.18958991319932006,
0.3338829281682924, 0.31674807949231792, 0.51037417273184538,
0.51813067941107849, 0.32524986632013037, 0.27843124392093754,
0.44587963535939629, 0.56543783330715247, 0.63274758146538501,
0.59389458846433929, 0.4727441819505997, 0.25892999875443673,
0.43532294200435689, 0.58426413396865007, 0.60655852480892092,
0.49427313653435129, 0.60232499837362774, 0.5008587047412324,
0.44921761575407376, 0.35738375999822308, 0.36072945078597418,
0.47898890615752471, 0.36017730234816447, 0.26200183423061518,
0.40643703281463983, 0.70829857458384393, 0.21726702613461271,
0.57289559324508077, 0.49786598136891386, 0.66477680221884816,
0.60181526949385744, 0.38887387304299842, 0.53284136562912088,
0.57978124697534417, 0.14407321918183127, 0.40109908554242268,
0.54328267580291201, 0.068803116178913437, 0.49665934204116863,
0.52083482086897492, 0.54335318499231255, 0.25838089976469136,
0.2965613531100203, 0.66802508421435025, 0.48011387977855929,
0.33896159797822095, 0.46729935524255134, 0.61490563272229348,
0.52303969578111109, 0.22597853069559529, 0.33200025347607365,
0.37032150206985615, 0.39135743775754178, 0.5675556377997486,
0.42301338623406759, 0.51039172565241364, 0.43693810820373952,
0.21333145308828286, 0.5290193411367472, 0.32854768325249067,
0.51355348265811118, 0.38731481172955551, 0.60797148533012169,
0.34523384159451131, 0.27525133898041509, 0.41943482174166197,
0.34496511828090082, 0.41078348799737241, 0.40445848645033566,
0.43904649163727266, 0.52002738652284775, 0.41673742377867345,
0.47732395709867864, 0.63103577503383645, 0.39205962895704294,
0.4921417954674196, 0.51119643284986438, 0.53048029947464204,
0.19065777784785748, 0.68192903026956253, 0.59424301889606579,
0.68193255077058235, 0.47259617215428484, 0.43516526322637322,
0.32173972846722754, 0.68205090902311216, 0.44336044416624248,
0.77149047699515994, 0.61324633629888425, 0.55824966441195933,
0.32120964514143124, 0.42707936657162299, 0.52705247192722759,
0.25854737979521969, 0.25371859118077777, 0.33320391773253533,
0.49956995344608474, 0.72301481426828529, 0.54013237282165283,
0.35880430695119486, 0.62659399360875345, 0.46669680413876052,
0.47003086735624827, 0.56612735566144168, 0.62107012917362847,
0.28202644402026539, 0.37119399130803182, 0.46213963953242987,
0.4190020976235922, 0.34944760859803525, 0.54924799123186996,
0.44375726909083374, 0.30789949852198484, 0.37495053943992529,
0.52473727145502447, 0.55174893532115699, 0.47889534016568397,
0.55246920007870037, 0.36233831975114145, 0.58905984970733227,
0.47308542262672587, 0.2739731987728426, 0.38757460982931813,
0.37022773773992945, 0.33003457429506677, 0.20433273018721532,
0.46570620457066159, 0.62310076407764092, 0.61717705006211943,
0.22161923312182563, 0.51699028500389532, 0.53194145615062283,
0.38242245575870676, 0.52417136331253178, 0.31962993187483468,
0.5675556377997486, 0.39141207990010124, 0.4326653604120354,
0.55230998418055444, 0.59093503713682294, 0.48229485495139157,
0.54725980067815772, 0.42034554064582047, 0.52110624653900017,
0.31858540913973621, 0.22137552519925044, 0.64170046347643839,
0.32191900130427115, 0.75482606146576403, 0.55362893244922118,
0.17923726014975316, 0.5284213518089228, 0.38126735954093494,
0.39254647458019754, 0.25759580324544573, 0.38444332251200736,
0.34736195966755357, 0.19211181914502004, 0.37053263296188593,
0.48177476290665266, 0.33040886305469186, 0.67348627381445092,
0.51225689700858601, 0.63162712003579613, 0.49117410394819727,
0.65778915312810859, 0.51208910298824095, 0.43661387501844534,
0.15358351798609118, 0.4402550151768303, 0.41788054533453295,
0.34812950326623165, 0.36278331603825248, 0.62899200023165869,
0.40704441840926509, 0.32258380577465334, 0.46947145478605679,
0.5235779853451954, 0.52175991928433274, 0.41851021917151782,
0.35581411238946603, 0.44892432331011978, 0.52342695089307656,
0.46068071415991108, 0.47932310583161603, 0.27949289810817191,
0.25666175482397902, 0.54604810372923196, 0.37907629391800224,
0.50986994773394767, 0.41395808739410761, 0.53384173334793095,
0.31139416600421727, 0.46593602882725049, 0.46230059088882408,
0.19555536498571138, 0.34493692948049726, 0.20849678870805716,
0.32926286559659307, 0.38607591767065419, 0.44143215171435524,
0.47461044416624248, 0.60116809232082558, 0.27502481209449769,
0.51686662120757765, 0.39711529154905251, 0.20690583215123842,
0.32667966078633937, 0.45860530443309405, 0.20067931785978904,
0.42813849194826697, 0.43619612542583158, 0.47888418364837337,
0.34572262101399959, 0.46594733409812461, 0.55853006488035439,
0.34053159267862754, 0.3466003662114413, 0.57659559023034213,
0.44180220099740258, 0.43775793868021112, 0.22653149727991218,
0.36882568582726816, 0.2129974765673231, 0.23231731673970268,
0.44991031154159467, 0.26515483956060976, 0.56040450854748292,
0.15368713725154187, 0.3412541878822094, 0.43989994041022662,
0.2005486130445531, 0.43734881677641901, 0.30777752061652996,
0.45425302308103144, 0.34374571093579082, 0.50456108175483194,
0.25492830474377098, 0.27125333899977311, 0.20376042565016017,
0.31827530753948119, 0.21624798981107107, 0.31163556823125266,
0.33970162218568567, 0.37432847679993397, 0.38253937604602717,
0.37736409083135392, 0.29764502280075594, 0.22169673372067969,
0.41648454269946067, 0.30640370707222836, 0.40041211678476513,
0.36334352196269026, 0.37992597425032171, 0.3310301571199406,
0.50438128831001672, 0.34077743276386502, 0.38930213456588553,
0.41017397026502728, 0.3683741691535089, 0.32686384250851663,
0.277588059127725, 0.54706582605845111, 0.18227694006311909,
0.21481665827172955, 0.28379527264619497, 0.32826336562023495,
0.3778571097285624, 0.24390293849913605, 0.34563602165915364,
0.2506654242499885, 0.25123316703678139, 0.36118064513660736,
0.57868835455258893, 0.50744050449694322, 0.34126437749760807,
0.34146926075162198, 0.30490010604442458, 0.41690457317307622,
0.31054406417395364, 0.28325561954274348, 0.33621592948075091,
0.19802647162131071, 0.31370899456604423, 0.23378211788746139,
0.39414093922686227, 0.28619325445329297, 0.56965931070222786,
0.31599722106623379, 0.44891584435950288, 0.34559399878940777,
0.40779128529438929, 0.17574115473233087, 0.35232425457826183,
0.53821300560900109, 0.28353547456363243, 0.12383385885068633,
0.38037820992420313, 0.46278855214961995, 0.21204686689788124,
0.13931257212051973, 0.33576969355515468, 0.46367051202795134,
0.35722486640828766, 0.25525226521959199, 0.39565983709112601,
0.4755894905282933, 0.34584925988566206, 0.2838475099580634,
0.44869980461267744, 0.28512225363042792, 0.54986611186331491,
0.34310795483781498, 0.25686118374490863, 0.28180026424852872,
0.4817860682002485, 0.30658491369056401, 0.26934282263770609,
0.46268016042777554, 0.40024385171368865, 0.17738657985031028,
0.27927678400195483, 0.3183364948203295, 0.34722758558954803,
0.30541082659075874, 0.38653162419191511, 0.23866482964954452,
0.23531182512534174, 0.38166103586504757, 0.41506679729232016,
0.39565636615914329, 0.42911005109252548, 0.33854218727240704,
0.70047195566620168, 0.43142321857155325, 0.43642416461667588,
0.23041855186693258, 0.39477135681821285, 0.28824905355413916,
0.30328347706656389, 0.42159487223555581, 0.31742091663320304,
0.16742311575918264, 0.17370080123331383, 0.26959937290384411,
0.23272224873068384, 0.42109188683850679, 0.32310788940160606,
0.26664973849672424, 0.22511367745759134, 0.25106462926169043,
0.23550612212129721, 0.11564310330647043, 0.30700355581738298,
0.26193687850633968, 0.11943049302506835, 0.36749240762900304,
0.20707137006453127, 0.35286767614443454, 0.31534538295149289,
0.26340691081380496, 0.54626801109652401, 0.36329118547390898,
0.25459457612193509, 0.36936231429484467, 0.35155021542892595,
0.41316314837903834, 0.33978405646282273, 0.20418292293825974,
0.34430968525986255, 0.4185835546630236, 0.29558200919692118,
0.13069784411286547, 0.30115825971601157, 0.30053096593744894,
0.25865051560324132, 0.26048668002164266, 0.38914777791948107,
0.17377386400709574, 0.49015672871456289, 0.40430460088531772,
0.34199386502588708, 0.19239732679204807, 0.22279589857707496,
0.25223757589198981, 0.40648674129941592, 0.37821466368645446,
0.26906581866059909, 0.28234123134858791, 0.25687323282993541,
0.44226596502433208, 0.32590175405379246, 0.28172249090421519,
0.35613988269492253, 0.45980326646959774, 0.31375168686541749,
0.50357593651277233, 0.2414542069094644, 0.4453824017790135,
0.33143774187329544, 0.35550864694551448, 0.37110486313085417,
0.089363207809125766, 0.33616252695414606, 0.40519342822620669,
0.19170132128865799, 0.28644368110726592, 0.21922479658445931,
0.33459196203174368, 0.51957428316649101, 0.27364809785842498,
0.35178844426779138, 0.39951438903142816, 0.19916727506874424,
0.21829181423020211, 0.30542416483798979, 0.47965963597821176,
0.48791783884475226, 0.45138138509798659, 0.26624983934615071,
0.17792329512548427, 0.31851321407660921, 0.15361608262050649,
0.48535263321575861, 0.3543207009823291, 0.22133303126442899,
0.2558392467833529, 0.32495711930591192, 0.19222814443217384,
0.18166893466267428, 0.096216352687560111, 0.26148893194147599,
0.12998284772236476, 0.75072601656202143, 0.34288576658463438,
0.083717762127580364, 0.099349939487049899, 0.14697707469570945,
0.22984771006779969, 0.13331574570360064, 0.29297718556669972,
0.38822312578442697, 0.18595280178329732, 0.49573037603314291,
0.28643636739036232, 0.38680696706159767, 0.27418256941436314,
0.13559362142733611, 0.23462607122399967, 0.34195489157253522,
0.1984161811350332, 0.29616346211821887, 0.32138616603753828,
0.41177773202779294, 0.32375801682541661, 0.24651919139149264,
0.15573024265078034, 0.16743552425516139, 0.29891527909342058,
0.15977958738141346, 0.40075544001700941, 0.27701263076430005,
0.27337662260387779, 0.27973655644622591, 0.43901490629715462,
0.3673428111170875, 0.29405341760321885, 0.5195971912153684,
0.19873410468998196, 0.26460794708974544, 0.46451548187427877,
0.37269967488421002, 0.16247855965295596, 0.50368358450868467,
0.3845325746504889, 0.47947562781937597, 0.13539879144670988,
0.26934946694656137, 0.45568700742736451, 0.46610010400849183,
0.41526989549169596, 0.22736273219439668, 0.40291177168271614,
0.1559794172668377, 0.32405195386814784, 0.2107297780438156,
0.36345064931922433, 0.36002443326875433, 0.18763213035334336,
0.37736956989989473, 0.40108993719822844, 0.29926281700376206,
0.16906551622643518, 0.16736921735394747, 0.27375175430036613,
0.17497690848839423, 0.35652438586595198, 0.20322395830854117,
0.38090211995646112, 0.21570429556658857, 0.3348042829522862,
0.49242646020465336, 0.49843045156028598, 0.49130421373229438,
0.51604490651929358, 0.42274057219744354, 0.43964785271255069,
0.44457323197463811, 0.12060264630607184, 0.20169752361016557,
0.23312140413050972, 0.30870928813287724, 0.26561711606110094,
0.26571080601424557, 0.3761489973216427, 0.13591361513605191,
0.32094531005796262, 0.33227128246992826, 0.45349571867408617,
0.17216271418529847, 0.25368398118485569, 0.097381291432825867,
0.4058943798126739, 0.27924071123244126, 0.19329346787399013,
0.1425462390537208, 0.2266676067891919, 0.20044084110421961,
0.34382561639510195, 0.25133402196316623, 0.30233351203594827,
0.23337830153577152, 0.42543727597713232, 0.20098504362247863,
0.34807119186909025, 0.47252586130297025, 0.1840666313823211,
0.20309818717006481, 0.29996044642729625, 0.2484965973118046,
0.41780200345266949, 0.27853467723253311, 0.38903318811018739,
0.27825073147085932, 0.1947971804654437, 0.29541555399000685,
0.50081621080641092, 0.49633862935689294, 0.30140950448006087,
0.41661172701697913, 0.26773194548241358, 0.20797255635578363,
0.29896054976143893, 0.36395197362262133, 0.47443739418663139,
0.4809365365727496, 0.51993139088945906, 0.35095368885038486,
0.3119588345336754, 0.1689777020390742, 0.4809365365727496, 0.3119588345336754,
0.2209708411280201, 0.22746998351413833, 0.36395197362262133,
0.136481990108483, 0.40294682793933079, 0.30545969214755719,
0.21447169874190186, 0.3769502583948578, 0.23396912590025656,
0.3769502583948578, 0.23396912590025656, 0.30545969214755719,
0.3444545464642666, 0.22746998351413833, 0.25996569544472953,
0.35095368885038486, 0.14948027488071947, 0.17547684442519243,
0.24696741067249306, 0.45493996702827666, 0.46143910941439492,
0.12998284772236476, 0.44844082464215845, 0.3769502583948578,
0.33145626169203013, 0.25996569544472953, 0.22746998351413833,
0.3119588345336754, 0.29246140737532073, 0.20147341396966539,
0.37045111600873959, 0.18197598681131066, 0.17547684442519243,
0.16247855965295596, 0.42244425509768546, 0.39644768555321253,
0.36395197362262133, 0.38994854316709426, 0.4809365365727496,
0.32495711930591192, 0.41594511271156726, 0.56542538759228667,
0.35095368885038486, 0.27946312260308426, 0.33145626169203013,
0.20147341396966539, 0.37045111600873959, 0.33145626169203013,
0.1689777020390742, 0.28596226498920246, 0.20797255635578363,
0.42244425509768546, 0.24696741067249306, 0.27946312260308426,
0.272963980216966, 0.32495711930591192, 0.35745283123650307,
0.3444545464642666, 0.16247855965295596, 0.42244425509768546,
0.19497427158354713, 0.16247855965295596, 0.40294682793933079,
0.53942881804781373, 0.272963980216966, 0.50693310611722253,
0.3444545464642666, 0.2209708411280201, 0.272963980216966, 0.1689777020390742,
0.17547684442519243, 0.22746998351413833, 0.20147341396966539,
0.136481990108483, 0.17547684442519243, 0.18197598681131066,
0.24696741067249306, 0.33795540407814839, 0.2209708411280201,
0.20797255635578363, 0.19497427158354713, 0.1559794172668377,
0.25996569544472953, 0.12998284772236476, 0.24696741067249306,
0.20797255635578363, 0.32495711930591192, 0.27946312260308426,
0.20797255635578363, 0.27946312260308426, 0.20147341396966539,
0.16247855965295596, 0.20147341396966539, 0.20797255635578363,
0.23396912590025656, 0.1689777020390742, 0.29896054976143893,
0.16247855965295596, 0.23396912590025656, 0.25346655305861127,
0.16247855965295596, 0.24696741067249306, 0.25996569544472953,
0.23396912590025656, 0.25346655305861127, 0.33795540407814839,
0.32495711930591192, 0.272963980216966, 0.4809365365727496, 0.38344940078097606,
0.44844082464215845, 0.3444545464642666, 0.40944597032544899,
0.272963980216966, 0.40944597032544899, 0.22746998351413833,
0.38994854316709426, 0.25996569544472953, 0.35745283123650307,
0.28596226498920246, 0.26646483783084773, 0.33795540407814839,
0.28596226498920246, 0.3444545464642666, 0.28596226498920246,
0.26646483783084773, 0.3769502583948578, 0.24696741067249306,
0.49393482134498612, 0.39644768555321253, 0.51343224850334079,
0.50693310611722253, 0.40944597032544899, 0.21447169874190186,
0.28596226498920246, 0.20797255635578363, 0.2404682682863748,
0.44844082464215845, 0.136481990108483, 0.25996569544472953,
0.30545969214755719, 0.25346655305861127, 0.43544253986992193,
0.40294682793933079, 0.36395197362262133, 0.3119588345336754,
0.272963980216966, 0.36395197362262133, 0.31845797691979366,
0.26646483783084773, 0.38344940078097606, 0.42894339748380372,
0.42894339748380372, 0.1689777020390742, 0.42894339748380372,
0.2404682682863748, 0.2404682682863748, 0.40944597032544899,
0.31845797691979366, 0.39644768555321253, 0.1884751291974289,
0.22746998351413833, 0.23396912590025656, 0.21447169874190186,
0.272963980216966, 0.40294682793933079, 0.44194168225604019,
0.46143910941439492, 0.41594511271156726, 0.2404682682863748,
0.3769502583948578, 0.40294682793933079, 0.20797255635578363,
0.40294682793933079, 0.3769502583948578, 0.272963980216966, 0.23396912590025656,
0.17547684442519243, 0.35095368885038486, 0.24696741067249306,
0.46143910941439492, 0.33145626169203013, 0.21447169874190186,
0.38994854316709426, 0.3444545464642666, 0.25996569544472953,
0.44844082464215845, 0.2404682682863748, 0.32495711930591192,
0.30545969214755719, 0.35745283123650307, 0.3119588345336754,
0.38344940078097606, 0.44844082464215845, 0.3444545464642666,
0.29246140737532073, 0.38344940078097606, 0.35095368885038486,
0.29896054976143893, 0.35095368885038486, 0.46793825180051313,
0.46143910941439492, 0.33145626169203013, 0.35095368885038486,
0.4809365365727496, 0.3769502583948578, 0.272963980216966, 0.4809365365727496,
0.30545969214755719, 0.45493996702827666, 0.21447169874190186,
0.3769502583948578, 0.46143910941439492, 0.35095368885038486,
0.24696741067249306, 0.40294682793933079, 0.35095368885038486,
0.40294682793933079, 0.27946312260308426, 0.35745283123650307,
0.2404682682863748, 0.35745283123650307, 0.29896054976143893,
0.32495711930591192, 0.37045111600873959, 0.39644768555321253,
0.1884751291974289, 0.35095368885038486, 0.50693310611722253,
0.1884751291974289, 0.39644768555321253, 0.41594511271156726,
0.27946312260308426, 0.35745283123650307, 0.1689777020390742,
0.38994854316709426, 0.29896054976143893, 0.29246140737532073,
0.35095368885038486, 0.40294682793933079, 0.3769502583948578,
0.50043396373110438, 0.27946312260308426, 0.46793825180051313,
0.35745283123650307, 0.44194168225604019, 0.48743567895886786,
0.18197598681131066, 0.28596226498920246, 0.38344940078097606,
0.32495711930591192, 0.29246140737532073, 0.45493996702827666,
0.44844082464215845, 0.35095368885038486, 0.40294682793933079,
0.41594511271156726, 0.32495711930591192, 0.43544253986992193,
0.27946312260308426, 0.44194168225604019, 0.47443739418663139,
0.33795540407814839, 0.19497427158354713, 0.47443739418663139,
0.3119588345336754, 0.43544253986992193, 0.43544253986992193,
0.18197598681131066, 0.35745283123650307, 0.22746998351413833,
0.3444545464642666, 0.28596226498920246, 0.3119588345336754,
0.26646483783084773, 0.272963980216966, 0.26646483783084773,
0.40294682793933079, 0.32495711930591192, 0.38344940078097606,
0.39644768555321253, 0.38994854316709426, 0.44844082464215845,
0.3444545464642666, 0.37045111600873959, 0.33145626169203013,
0.29246140737532073, 0.50693310611722253, 0.43544253986992193,
0.41594511271156726, 0.46143910941439492, 0.51343224850334079,
0.29896054976143893, 0.36395197362262133, 0.3444545464642666,
0.42244425509768546, 0.17547684442519243, 0.3119588345336754,
0.44194168225604019, 0.26646483783084773, 0.25346655305861127,
0.29896054976143893, 0.40944597032544899, 0.42894339748380372,
0.2209708411280201, 0.45493996702827666, 0.41594511271156726,
0.40294682793933079, 0.36395197362262133, 0.35095368885038486,
0.40944597032544899, 0.38344940078097606, 0.39644768555321253,
0.29896054976143893, 0.35095368885038486, 0.35745283123650307,
0.26646483783084773, 0.38994854316709426, 0.3444545464642666,
0.3769502583948578, 0.31845797691979366, 0.4809365365727496,
0.41594511271156726, 0.44844082464215845, 0.35745283123650307,
0.24696741067249306, 0.29896054976143893, 0.46793825180051313,
0.26646483783084773, 0.44844082464215845, 0.48743567895886786,
0.46143910941439492, 0.48743567895886786, 0.35095368885038486,
0.35745283123650307, 0.2209708411280201, 0.42244425509768546,
0.3444545464642666, 0.3444545464642666, 0.31845797691979366,
0.39644768555321253, 0.33795540407814839, 0.3769502583948578,
0.29246140737532073, 0.50693310611722253, 0.42894339748380372,
0.27946312260308426, 0.36395197362262133, 0.42244425509768546,
0.48743567895886786, 0.272963980216966, 0.2209708411280201, 0.26646483783084773,
0.22746998351413833, 0.45493996702827666, 0.42244425509768546,
0.25996569544472953, 0.36395197362262133, 0.39644768555321253,
0.3769502583948578, 0.14298113249460123, 0.42244425509768546,
0.39644768555321253, 0.42894339748380372, 0.49393482134498612,
0.3769502583948578, 0.35095368885038486, 0.40294682793933079,
0.3444545464642666, 0.4809365365727496, 0.31845797691979366,
0.42244425509768546, 0.42244425509768546, 0.48743567895886786,
0.27946312260308426, 0.1884751291974289, 0.40944597032544899,
0.40944597032544899, 0.53292967566169547, 0.40294682793933079,
0.33795540407814839, 0.42894339748380372, 0.46793825180051313,
0.44844082464215845, 0.40294682793933079, 0.50693310611722253,
0.46793825180051313, 0.25346655305861127, 0.40294682793933079,
0.27946312260308426, 0.4809365365727496, 0.32495711930591192,
0.3769502583948578, 0.44194168225604019, 0.51993139088945906,
0.64341509622570559, 0.63691595383958732, 0.33145626169203013,
0.39644768555321253, 0.55242710282005025, 0.12998284772236476,
0.4809365365727496, 0.51993139088945906, 0.23396912590025656,
0.48743567895886786, 0.63691595383958732, 0.19497427158354713,
0.57842367236452319, 0.47443739418663139, 0.61741852668123265,
0.41594511271156726, 0.4809365365727496, 0.63691595383958732,
0.58492281475064145, 0.54592796043393199, 0.44194168225604019,
0.35745283123650307, 0.66291252338406026, 0.56542538759228667,
0.55242710282005025, 0.49393482134498612, 0.45493996702827666,
0.26646483783084773, 0.50043396373110438, 0.38994854316709426,
0.61091938429511439, 0.72140480485912439, 0.50043396373110438,
0.47443739418663139, 0.51993139088945906, 0.656413380997942,
0.44844082464215845, 0.57192452997840493, 0.46793825180051313,
0.3119588345336754, 0.40294682793933079, 0.63691595383958732,
0.52643053327557732, 0.59142195713675971, 0.37045111600873959,
0.59792109952287786, 0.61741852668123265, 0.46143910941439492,
0.59792109952287786, 0.53292967566169547, 0.6239176690673508,
0.46793825180051313, 0.31845797691979366, 0.48743567895886786,
0.50693310611722253, 0.14948027488071947, 0.63691595383958732,
0.40294682793933079, 0.55892624520616851, 0.656413380997942,
0.72790394724524266, 0.45493996702827666, 0.56542538759228667,
0.42894339748380372, 0.32495711930591192, 0.656413380997942,
0.42244425509768546, 0.59792109952287786, 0.3119588345336754,
0.30545969214755719, 0.54592796043393199, 0.38994854316709426,
0.26646483783084773, 0.44194168225604019, 0.37045111600873959,
0.42244425509768546, 0.40944597032544899, 0.59142195713675971,
0.51993139088945906, 0.2209708411280201, 0.25346655305861127,
0.56542538759228667, 0.55892624520616851, 0.51343224850334079,
0.18197598681131066, 0.59142195713675971, 0.3444545464642666,
0.25996569544472953, 0.42244425509768546, 0.50043396373110438,
0.1559794172668377, 0.3444545464642666, 0.30545969214755719,
0.25996569544472953, 0.17547684442519243, 0.22746998351413833,
0.12348370533624653, 0.20147341396966539, 0.25346655305861127,
0.22746998351413833, 0.2404682682863748, 0.31260874877228728,
0.20797255635578363, 0.25996569544472953, 0.12998284772236476,
0.16247855965295596, 0.36005248819095037, 0.31845797691979366,
0.3769502583948578, 0.24696741067249306, 0.21447169874190186,
0.1884751291974289, 0.2209708411280201, 0.30545969214755719,
0.17547684442519243, 0.20147341396966539, 0.41594511271156726,
0.2209708411280201, 0.20147341396966539, 0.28596226498920246,
0.59792109952287786, 0.36395197362262133, 0.25996569544472953,
0.61091938429511439, 0.21447169874190186, 0.43544253986992193,
0.31845797691979366, 0.21447169874190186, 0.24696741067249306,
0.17547684442519243, 0.33145626169203013, 0.20147341396966539,
0.28596226498920246, 0.1884751291974289, 0.32495711930591192,
0.22746998351413833, 0.30545969214755719, 0.52643053327557732,
0.21447169874190186, 0.33795540407814839, 0.48743567895886786,
0.2209708411280201, 0.25996569544472953, 0.1689777020390742,
0.21447169874190186, 0.272963980216966, 0.25346655305861127,
0.25346655305861127, 0.35745283123650307, 0.3444545464642666,
0.272963980216966, 0.24696741067249306, 0.35095368885038486,
0.3769502583948578, 0.2404682682863748, 0.1559794172668377, 0.10398627817789181,
0.46793825180051313, 0.53292967566169547, 0.21447169874190186,
0.071490566247300616, 0.18197598681131066, 0.45493996702827666,
0.33145626169203013, 0.52643053327557732, 0.2404682682863748,
0.27946312260308426, 0.26646483783084773, 0.2209708411280201,
0.28596226498920246, 0.25996569544472953, 0.23396912590025656,
0.20797255635578363, 0.21447169874190186, 0.18197598681131066,
0.3444545464642666, 0.30545969214755719, 0.20797255635578363,
0.33795540407814839, 0.37045111600873959, 0.31845797691979366,
0.31845797691979366, 0.1689777020390742, 0.1689777020390742,
0.44194168225604019, 0.40944597032544899, 0.31845797691979366,
0.27946312260308426, 0.38344940078097606, 0.272963980216966,
0.23396912590025656, 0.12998284772236476, 0.3444545464642666,
0.25346655305861127, 0.2209708411280201, 0.2209708411280201,
0.272963980216966, 0.37045111600873959, 0.20147341396966539,
0.14298113249460123, 0.20147341396966539, 0.29896054976143893,
0.27946312260308426, 0.2209708411280201, 0.25346655305861127,
0.25346655305861127, 0.27946312260308426, 0.35745283123650307,
0.07798970863341885, 0.20797255635578363, 0.3769502583948578,
0.40294682793933079, 0.40944597032544899, 0.1689777020390742,
0.272963980216966, 0.27946312260308426, 0.20797255635578363,
0.24696741067249306, 0.272963980216966, 0.39644768555321253,
0.16247855965295596, 0.38994854316709426, 0.16247855965295596,
0.23396912590025656, 0.19497427158354713, 0.40944597032544899,
0.272963980216966, 0.21447169874190186, 0.23396912590025656,
0.26646483783084773, 0.23396912590025656, 0.19497427158354713,
0.29896054976143893, 0.20147341396966539, 0.23396912590025656,
0.14298113249460123, 0.41594511271156726, 0.28596226498920246,
0.40944597032544899, 0.2209708411280201, 0.20797255635578363,
0.28596226498920246, 0.31845797691979366, 0.1559794172668377,
0.35095368885038486, 0.1689777020390742, 0.18197598681131066,
0.26646483783084773, 0.097487135791773566, 0.29896054976143893,
0.40944597032544899, 0.26646483783084773, 0.14948027488071947,
0.36395197362262133, 0.272963980216966, 0.2209708411280201, 0.27946312260308426,
0.21447169874190186, 0.2404682682863748, 0.38994854316709426,
0.33145626169203013, 0.33145626169203013, 0.35745283123650307,
0.14948027488071947, 0.38994854316709426, 0.1884751291974289,
0.37045111600873959, 0.3444545464642666, 0.12348370533624653,
0.14948027488071947, 0.29246140737532073, 0.21447169874190186,
0.20147341396966539, 0.25346655305861127, 0.25346655305861127,
0.21447169874190186, 0.20797255635578363, 0.14298113249460123,
0.272963980216966, 0.17547684442519243, 0.22746998351413833,
0.33145626169203013, 0.21447169874190186, 0.17547684442519243,
0.35095368885038486, 0.25346655305861127, 0.17547684442519243,
0.25346655305861127, 0.272963980216966, 0.1559794172668377, 0.30545969214755719,
0.3444545464642666, 0.42244425509768546, 0.39644768555321253,
0.32495711930591192, 0.29246140737532073, 0.1559794172668377,
0.37045111600873959, 0.38344940078097606, 0.22746998351413833,
0.3444545464642666, 0.40944597032544899, 0.2404682682863748,
0.30545969214755719, 0.1884751291974289, 0.41594511271156726,
0.1689777020390742, 0.14948027488071947, 0.30545969214755719,
0.21447169874190186, 0.29246140737532073, 0.21447169874190186,
0.23396912590025656, 0.32495711930591192, 0.26646483783084773,
0.11698456295012828, 0.1689777020390742, 0.18197598681131066,
0.3444545464642666, 0.29896054976143893, 0.272963980216966, 0.19497427158354713,
0.18197598681131066, 0.33145626169203013, 0.16247855965295596,
0.17547684442519243, 0.272963980216966, 0.31845797691979366,
0.1884751291974289, 0.21447169874190186, 0.26646483783084773,
0.20797255635578363, 0.20147341396966539, 0.1689777020390742,
0.59142195713675971, 0.29246140737532073, 0.17547684442519243,
0.23396912590025656, 0.32495711930591192, 0.38344940078097606,
0.29246140737532073, 0.39644768555321253, 0.20797255635578363,
0.41594511271156726, 0.38994854316709426, 0.2404682682863748,
0.38344940078097606, 0.41594511271156726, 0.14948027488071947,
0.25346655305861127, 0.33795540407814839, 0.3769502583948578,
0.4809365365727496, 0.39644768555321253, 0.1559794172668377,
0.29246140737532073, 0.21447169874190186, 0.272963980216966,
0.29246140737532073, 0.27946312260308426, 0.27946312260308426,
0.11048542056401005, 0.26646483783084773, 0.17547684442519243,
0.37045111600873959, 0.23396912590025656, 0.32495711930591192,
0.19497427158354713, 0.32495711930591192, 0.22746998351413833,
0.38994854316709426, 0.18197598681131066, 0.3119588345336754,
0.39644768555321253, 0.20147341396966539, 0.20797255635578363,
0.1689777020390742, 0.41594511271156726, 0.24696741067249306,
0.20147341396966539, 0.3444545464642666, 0.38344940078097606,
0.25996569544472953, 0.29246140737532073, 0.30545969214755719,
0.39644768555321253, 0.3119588345336754, 0.25346655305861127,
0.39644768555321253, 0.35745283123650307, 0.3444545464642666,
0.39644768555321253, 0.17547684442519243, 0.14298113249460123,
0.31845797691979366, 0.35095368885038486, 0.36395197362262133,
0.27946312260308426, 0.41594511271156726, 0.24696741067249306,
0.3769502583948578, 0.3119588345336754, 0.14298113249460123,
0.35745283123650307, 0.19497427158354713, 0.2209708411280201,
0.2404682682863748, 0.20797255635578363, 0.39644768555321253,
0.1689777020390742, 0.39644768555321253, 0.2404682682863748,
0.22746998351413833, 0.1884751291974289, 0.39644768555321253,
0.2404682682863748, 0.20147341396966539, 0.29246140737532073,
0.26646483783084773, 0.1884751291974289, 0.35095368885038486,
0.40944597032544899, 0.39644768555321253, 0.22746998351413833,
0.19497427158354713, 0.29246140737532073, 0.28596226498920246,
0.39644768555321253, 0.36395197362262133, 0.272963980216966,
0.26646483783084773, 0.40944597032544899, 0.29896054976143893,
0.22746998351413833, 0.3769502583948578, 0.42244425509768546,
0.35745283123650307, 0.097487135791773566, 0.39644768555321253,
0.20147341396966539, 0.27946312260308426, 0.272963980216966,
0.14298113249460123, 0.20797255635578363, 0.18197598681131066,
0.40294682793933079, 0.272963980216966, 0.29246140737532073,
0.41594511271156726, 0.39644768555321253, 0.35095368885038486,
0.20147341396966539, 0.26646483783084773, 0.40944597032544899,
0.24696741067249306, 0.2209708411280201, 0.19497427158354713,
0.32495711930591192, 0.42244425509768546, 0.3119588345336754,
0.38994854316709426, 0.25996569544472953, 0.3769502583948578,
0.20797255635578363, 0.35095368885038486, 0.40294682793933079,
0.18197598681131066, 0.35745283123650307, 0.36395197362262133,
0.35745283123650307, 0.36395197362262133, 0.18197598681131066,
0.3119588345336754, 0.22746998351413833, 0.25996569544472953,
0.1884751291974289, 0.2209708411280201, 0.31845797691979366,
0.1884751291974289, 0.1884751291974289, 0.22746998351413833,
0.22746998351413833, 0.33145626169203013, 0.23396912590025656,
0.19497427158354713, 0.27946312260308426, 0.35095368885038486,
0.47443739418663139, 0.25996569544472953, 0.33795540407814839,
0.16247855965295596, 0.16247855965295596, 0.14298113249460123,
0.45493996702827666, 0.25346655305861127, 0.40294682793933079,
0.25346655305861127, 0.40944597032544899, 0.25996569544472953,
0.21447169874190186, 0.25346655305861127, 0.10398627817789181,
0.1689777020390742, 0.37045111600873959, 0.3119588345336754,
0.23396912590025656, 0.20147341396966539, 0.16247855965295596,
0.2404682682863748, 0.1689777020390742, 0.49393482134498612,
0.39644768555321253, 0.18197598681131066, 0.37045111600873959,
0.11048542056401005, 0.1689777020390742, 0.21447169874190186,
0.22746998351413833, 0.44194168225604019, 0.16247855965295596,
0.30545969214755719, 0.19497427158354713, 0.35745283123650307,
0.24696741067249306, 0.28596226498920246, 0.19497427158354713,
0.26646483783084773, 0.21447169874190186, 0.41594511271156726,
0.24696741067249306, 0.30545969214755719, 0.39644768555321253,
0.20797255635578363, 0.40294682793933079, 0.33795540407814839,
0.27946312260308426, 0.31845797691979366, 0.21447169874190186,
0.21447169874190186, 0.11698456295012828, 0.2404682682863748,
0.2209708411280201, 0.20147341396966539, 0.25996569544472953,
0.22746998351413833, 0.42894339748380372, 0.33795540407814839,
0.26646483783084773, 0.17547684442519243, 0.12998284772236476,
0.29896054976143893, 0.22746998351413833, 0.20147341396966539,
0.18197598681131066, 0.14948027488071947, 0.20797255635578363,
0.14948027488071947, 0.20147341396966539, 0.30545969214755719,
0.136481990108483, 0.25996569544472953, 0.1559794172668377, 0.1689777020390742,
0.37045111600873959, 0.20147341396966539, 0.12998284772236476,
0.16247855965295596, 0.18197598681131066, 0.14948027488071947,
0.136481990108483, 0.07798970863341885, 0.07798970863341885,
0.31845797691979366, 0.16247855965295596, 0.29246140737532073,
0.49393482134498612, 0.39644768555321253, 0.25996569544472953,
0.40294682793933079, 0.3444545464642666, 0.50043396373110438,
0.19497427158354713, 0.14298113249460123, 0.29246140737532073,
0.36395197362262133, 0.49393482134498612, 0.33145626169203013,
0.20797255635578363, 0.14948027488071947, 0.3444545464642666,
0.3769502583948578, 0.28596226498920246, 0.40294682793933079,
0.20797255635578363, 0.27946312260308426, 0.32495711930591192,
0.14948027488071947, 0.44844082464215845, 0.18197598681131066,
0.2404682682863748, 0.272963980216966, 0.1884751291974289, 0.272963980216966,
0.38994854316709426, 0.32495711930591192, 0.42244425509768546,
0.41269554151850812, 0.25346655305861127, 0.31845797691979366,
0.3119588345336754, 0.27946312260308426, 0.20797255635578363,
0.27946312260308426, 0.1884751291974289, 0.42244425509768546,
0.40294682793933079, 0.2209708411280201, 0.37045111600873959,
0.1559794172668377, 0.40294682793933079, 0.21447169874190186,
0.16247855965295596, 0.35420326004344399, 0.272963980216966,
0.40944597032544899, 0.21447169874190186, 0.26646483783084773,
0.37045111600873959, 0.25996569544472953, 0.46143910941439492,
0.272963980216966, 0.25996569544472953, 0.44194168225604019,
0.30545969214755719, 0.26646483783084773, 0.23396912590025656,
0.28596226498920246, 0.20797255635578363, 0.40294682793933079,
0.21447169874190186, 0.28596226498920246, 0.17547684442519243,
0.272963980216966, 0.37045111600873959, 0.38344940078097606,
0.14298113249460123, 0.20147341396966539, 0.32495711930591192,
0.42244425509768546, 0.22746998351413833, 0.33795540407814839,
0.24696741067249306, 0.272963980216966, 0.42894339748380372,
0.30545969214755719, 0.18197598681131066, 0.35745283123650307,
0.2404682682863748, 0.19497427158354713, 0.3769502583948578,
0.16247855965295596, 0.1559794172668377, 0.25346655305861127,
0.14298113249460123, 0.36395197362262133, 0.53292967566169547,
0.14948027488071947, 0.35745283123650307, 0.44844082464215845,
0.38344940078097606, 0.44194168225604019, 0.46143910941439492,
0.42244425509768546, 0.51343224850334079, 0.48743567895886786,
0.43544253986992193, 0.38344940078097606, 0.20797255635578363,
0.48743567895886786, 0.23396912590025656, 0.29896054976143893,
0.37045111600873959, 0.38994854316709426, 0.35745283123650307,
0.46143910941439492, 0.30545969214755719, 0.50043396373110438,
0.12348370533624653, 0.37045111600873959, 0.19497427158354713,
0.11698456295012828, 0.1689777020390742, 0.29896054976143893,
0.272963980216966, 0.18197598681131066, 0.31845797691979366,
0.23396912590025656, 0.3444545464642666, 0.30545969214755719,
0.14948027488071947, 0.20797255635578363, 0.42244425509768546,
0.27946312260308426, 0.21447169874190186, 0.39644768555321253,
0.42894339748380372, 0.2404682682863748, 0.21447169874190186,
0.21447169874190186, 0.21447169874190186, 0.17547684442519243,
0.51343224850334079, 0.44844082464215845, 0.1884751291974289,
0.28596226498920246, 0.46793825180051313, 0.4809365365727496,
0.49393482134498612, 0.1884751291974289, 0.272963980216966, 0.31845797691979366,
0.1559794172668377, 0.33795540407814839, 0.32495711930591192,
0.35745283123650307, 0.29246140737532073, 0.1559794172668377,
0.272963980216966, 0.51993139088945906, 0.35745283123650307,
0.46793825180051313, 0.16247855965295596, 0.44194168225604019,
0.33795540407814839, 0.32495711930591192, 0.43544253986992193,
0.3119588345336754, 0.33795540407814839, 0.83838936780925266,
0.17547684442519243, 0.63041681145346906, 0.61091938429511439,
0.45493996702827666, 0.20797255635578363, 0.48743567895886786,
0.57842367236452319, 0.30545969214755719, 0.35745283123650307,
0.49393482134498612, 0.14298113249460123, 0.46793825180051313,
0.50043396373110438, 0.26646483783084773, 0.4809365365727496,
0.27946312260308426, 0.55242710282005025, 0.55242710282005025,
0.3444545464642666, 0.46143910941439492, 0.26646483783084773,
0.27946312260308426, 0.26646483783084773, 0.26646483783084773,
0.17547684442519243, 0.3444545464642666, 0.2209708411280201,
0.30545969214755719, 0.38994854316709426, 0.1559794172668377,
0.50693310611722253, 0.20797255635578363, 0.42244425509768546,
0.38994854316709426, 0.46143910941439492, 0.35095368885038486,
0.272963980216966, 0.35745283123650307, 0.53292967566169547,
0.33145626169203013, 0.61741852668123265, 0.38344940078097606,
0.46793825180051313, 0.43544253986992193, 0.21447169874190186,
0.2404682682863748, 0.66291252338406026, 0.48743567895886786,
0.40944597032544899, 0.17547684442519243, 0.46143910941439492,
0.38344940078097606, 0.53942881804781373, 0.44844082464215845,
0.46143910941439492, 0.51993139088945906, 0.32495711930591192,
0.3769502583948578, 0.29246140737532073, 0.39644768555321253,
0.48743567895886786, 0.37045111600873959, 0.33145626169203013,
0.2209708411280201, 0.40944597032544899, 0.32495711930591192,
0.63041681145346906, 0.44194168225604019, 0.25996569544472953,
0.52643053327557732, 0.39644768555321253, 0.33795540407814839,
0.50693310611722253, 0.41594511271156726, 0.47443739418663139,
0.54592796043393199, 0.42894339748380372, 0.61741852668123265,
0.29246140737532073, 0.26646483783084773, 0.35745283123650307,
0.26646483783084773, 0.71490566247300613, 0.51343224850334079,
0.44844082464215845, 0.16247855965295596, 0.6889090929285332,
0.51343224850334079, 0.19497427158354713, 0.42894339748380372,
0.46143910941439492, 0.54592796043393199, 0.14298113249460123,
0.55892624520616851, 0.3444545464642666, 0.63041681145346906,
0.6239176690673508, 0.20147341396966539, 0.20147341396966539,
0.48743567895886786, 0.27946312260308426, 0.53942881804781373,
0.3769502583948578, 0.36395197362262133, 0.52643053327557732,
0.48743567895886786, 0.40294682793933079, 0.50043396373110438,
0.48743567895886786, 0.55892624520616851, 0.54592796043393199,
0.44194168225604019, 0.33145626169203013, 0.57192452997840493,
0.49393482134498612, 0.29896054976143893, 0.37045111600873959,
0.6239176690673508, 0.43544253986992193, 0.48743567895886786,
0.46143910941439492, 0.33145626169203013, 0.29246140737532073,
0.58492281475064145, 0.37045111600873959, 0.55892624520616851,
0.27946312260308426, 0.38344940078097606, 0.51993139088945906,
0.46143910941439492, 0.48743567895886786, 0.30545969214755719,
0.3769502583948578, 0.33145626169203013, 0.30545969214755719,
0.38344940078097606, 0.35095368885038486, 0.38344940078097606,
0.60442024190899613, 0.59792109952287786, 0.49393482134498612,
0.38994854316709426, 0.42894339748380372, 0.25996569544472953,
0.3119588345336754, 0.40944597032544899, 0.24696741067249306,
0.26646483783084773, 0.50043396373110438, 0.46793825180051313,
0.66291252338406026, 0.27946312260308426, 0.2404682682863748,
0.40294682793933079, 0.2404682682863748, 0.36395197362262133,
0.24696741067249306, 0.66941166577017852, 0.61741852668123265,
0.20797255635578363, 0.23396912590025656, 0.47443739418663139,
0.24696741067249306, 0.32495711930591192, 0.25996569544472953,
0.53292967566169547, 0.38344940078097606, 0.1884751291974289,
0.35095368885038486, 0.3444545464642666, 0.37045111600873959,
0.50043396373110438, 0.26646483783084773, 0.29896054976143893,
0.37045111600873959, 0.41594511271156726, 0.61741852668123265,
0.43544253986992193, 0.43544253986992193, 0.26646483783084773,
0.30545969214755719, 0.42244425509768546, 0.72140480485912439,
0.3769502583948578, 0.31845797691979366, 0.35095368885038486,
0.51993139088945906, 0.70840652008688798, 0.21447169874190186,
0.25996569544472953, 0.37045111600873959, 0.25346655305861127,
0.48743567895886786, 0.40294682793933079, 0.70190737770076972,
0.39644768555321253, 0.40944597032544899, 0.44194168225604019,
0.44844082464215845, 0.29246140737532073, 0.35745283123650307,
0.31845797691979366, 0.66941166577017852, 0.3769502583948578,
0.50043396373110438, 0.44844082464215845, 0.37045111600873959,
0.42244425509768546, 0.4809365365727496, 0.3444545464642666,
0.49393482134498612, 0.21447169874190186, 0.37045111600873959,
0.40944597032544899, 0.53292967566169547, 0.18197598681131066,
0.52643053327557732, 0.3444545464642666, 0.43544253986992193,
0.57842367236452319, 0.40944597032544899, 0.1559794172668377,
0.61091938429511439, 0.50043396373110438, 0.43544253986992193,
0.47443739418663139, 0.51343224850334079, 0.36395197362262133,
0.10398627817789181, 0.6239176690673508, 0.42894339748380372,
0.29246140737532073, 0.22746998351413833, 0.40294682793933079,
0.20147341396966539, 0.272963980216966, 0.33145626169203013,
0.37045111600873959, 0.38344940078097606, 0.41594511271156726,
0.3769502583948578, 0.46143910941439492, 0.48743567895886786,
0.6889090929285332, 0.58492281475064145, 0.25996569544472953,
0.1884751291974289, 0.40294682793933079, 0.53942881804781373,
0.33145626169203013, 0.57192452997840493, 0.24696741067249306,
0.38994854316709426, 0.52643053327557732, 0.57192452997840493,
0.32495711930591192, 0.47443739418663139, 0.32495711930591192,
0.25346655305861127, 0.42894339748380372, 0.46143910941439492,
0.36395197362262133, 0.32495711930591192, 0.23396912590025656,
0.40294682793933079, 0.55242710282005025, 0.26646483783084773,
0.2209708411280201, 0.30545969214755719, 0.20147341396966539,
0.53292967566169547, 0.33145626169203013, 0.19497427158354713,
0.53292967566169547, 0.44194168225604019, 0.42244425509768546,
0.1884751291974289, 0.40294682793933079, 0.58492281475064145,
0.69540823531465146, 0.51343224850334079, 0.2209708411280201,
0.63041681145346906, 0.53292967566169547, 0.58492281475064145,
0.2404682682863748, 0.54592796043393199, 0.51993139088945906,
0.2209708411280201, 0.6239176690673508, 0.39644768555321253,
0.33145626169203013, 0.59792109952287786, 0.36395197362262133,
0.44194168225604019, 0.58492281475064145, 0.42244425509768546,
0.42244425509768546, 0.60442024190899613, 0.56542538759228667,
0.55242710282005025, 0.51343224850334079, 0.54592796043393199,
0.49393482134498612, 0.41594511271156726, 0.4809365365727496,
0.44194168225604019, 0.33795540407814839, 0.42894339748380372,
0.56542538759228667, 0.50693310611722253, 0.1559794172668377,
0.33145626169203013, 0.3119588345336754, 0.38344940078097606,
0.10398627817789181, 0.53292967566169547, 0.40294682793933079,
0.2209708411280201, 0.43544253986992193, 0.42894339748380372,
0.1884751291974289, 0.18197598681131066, 0.43544253986992193,
0.48743567895886786, 0.35095368885038486, 0.44844082464215845,
0.59142195713675971, 0.60442024190899613, 0.57842367236452319,
0.45493996702827666, 0.42894339748380372, 0.24696741067249306,
0.32495711930591192, 0.35745283123650307, 0.22746998351413833,
0.28596226498920246, 0.24696741067249306, 0.38994854316709426,
0.25996569544472953, 0.69540823531465146, 0.40944597032544899,
0.38994854316709426, 0.41594511271156726, 0.64991423861182385,
0.47443739418663139, 0.38994854316709426, 0.44844082464215845,
0.55242710282005025, 0.31845797691979366, 0.058492281475064141,
0.35745283123650307, 0.36395197362262133, 0.26646483783084773,
0.37045111600873959, 0.54592796043393199, 0.43544253986992193,
0.20797255635578363, 0.44844082464215845, 0.57192452997840493,
0.55242710282005025, 0.38994854316709426, 0.53942881804781373,
0.2404682682863748, 0.59792109952287786, 0.42894339748380372,
0.32495711930591192, 0.42244425509768546, 0.50693310611722253,
0.43544253986992193, 0.43544253986992193, 0.57192452997840493,
0.2209708411280201, 0.40944597032544899, 0.44194168225604019,
0.33145626169203013, 0.42894339748380372, 0.50043396373110438,
0.49393482134498612, 0.47443739418663139, 0.37045111600873959,
0.50693310611722253, 0.17547684442519243, 0.2404682682863748,
0.19497427158354713, 0.41594511271156726, 0.51993139088945906,
0.54592796043393199, 0.33795540407814839, 0.21447169874190186,
0.60442024190899613, 0.24696741067249306, 0.272963980216966,
0.44194168225604019, 0.40294682793933079, 0.38994854316709426,
0.27946312260308426, 0.44194168225604019, 0.4809365365727496,
0.55242710282005025, 0.36395197362262133, 0.42894339748380372,
0.27946312260308426, 0.3769502583948578, 0.42894339748380372,
0.50043396373110438, 0.42894339748380372, 0.49393482134498612,
0.4809365365727496, 0.42244425509768546, 0.40294682793933079,
0.44844082464215845, 0.60442024190899613, 0.3119588345336754,
0.40944597032544899, 0.3119588345336754, 0.48743567895886786,
0.44844082464215845, 0.23396912590025656, 0.28596226498920246,
0.44844082464215845, 0.31845797691979366, 0.46143910941439492,
0.1884751291974289, 0.32495711930591192, 0.16247855965295596,
0.56542538759228667, 0.3119588345336754, 0.53292967566169547,
0.41594511271156726, 0.51993139088945906, 0.67591080815629678,
0.36395197362262133, 0.46793825180051313, 0.46143910941439492,
0.46793825180051313, 0.3769502583948578, 0.56542538759228667,
0.64341509622570559, 0.58492281475064145, 0.24696741067249306,
0.4809365365727496, 0.40294682793933079, 0.40944597032544899,
0.45493996702827666, 0.52643053327557732, 0.50693310611722253,
0.32495711930591192, 0.46793825180051313, 0.52643053327557732,
0.16247855965295596, 0.40944597032544899, 0.36395197362262133,
0.18197598681131066, 0.3444545464642666, 0.6239176690673508,
0.43544253986992193, 0.4809365365727496, 0.50693310611722253,
0.42894339748380372, 0.1559794172668377, 0.38344940078097606,
0.38344940078097606, 0.17547684442519243, 0.19497427158354713,
0.18197598681131066, 0.24696741067249306, 0.272963980216966,
0.4809365365727496, 0.1689777020390742, 0.3769502583948578, 0.656413380997942,
0.61091938429511439, 0.53942881804781373, 0.25346655305861127,
0.30545969214755719, 0.66941166577017852, 0.12348370533624653,
0.29246140737532073, 0.2404682682863748, 0.3119588345336754,
0.67591080815629678, 0.12998284772236476, 0.38994854316709426,
0.24696741067249306, 0.26646483783084773, 0.25996569544472953,
0.49393482134498612, 0.46143910941439492, 0.38344940078097606,
0.55892624520616851, 0.24696741067249306, 0.53942881804781373,
0.20797255635578363, 0.46143910941439492, 0.46793825180051313,
0.41594511271156726, 0.18197598681131066, 0.44194168225604019,
0.43544253986992193, 0.136481990108483, 0.51343224850334079,
0.29246140737532073, 0.47443739418663139, 0.30545969214755719,
0.272963980216966, 0.28596226498920246, 0.272963980216966, 0.3119588345336754,
0.29896054976143893, 0.59792109952287786, 0.38344940078097606,
0.35745283123650307, 0.16247855965295596, 0.6239176690673508,
0.40294682793933079, 0.27946312260308426, 0.11048542056401005,
0.53292967566169547, 0.48743567895886786, 0.2404682682863748,
0.23396912590025656, 0.4809365365727496, 0.40294682793933079,
0.2404682682863748, 0.50693310611722253, 0.31845797691979366,
0.48743567895886786, 0.72790394724524266, 0.53292967566169547,
0.20147341396966539, 0.42244425509768546, 0.25996569544472953,
0.25346655305861127, 0.41594511271156726, 0.29896054976143893,
0.48743567895886786, 0.52643053327557732, 0.33145626169203013,
0.37045111600873959, 0.18197598681131066, 0.56542538759228667,
0.64991423861182385, 0.44844082464215845, 0.23396912590025656,
0.61091938429511439, 0.29896054976143893, 0.48743567895886786,
0.3444545464642666, 0.43544253986992193, 0.26646483783084773,
0.35745283123650307, 0.49393482134498612, 0.35095368885038486,
0.26646483783084773, 0.30545969214755719, 0.61741852668123265,
0.67591080815629678, 0.28596226498920246, 0.61741852668123265,
0.23396912590025656, 0.26646483783084773, 0.1884751291974289,
0.77989708633418853, 0.6889090929285332, 0.67591080815629678,
0.14298113249460123, 0.61741852668123265, 0.272963980216966,
0.73440308963136092, 0.1689777020390742, 0.17547684442519243,
0.656413380997942, 0.52643053327557732, 0.59792109952287786,
0.82539108303701625, 0.2404682682863748, 0.656413380997942, 0.88388336451208038,
0.81889194065089799, 0.1884751291974289, 0.76039965917583385,
0.74090223201747918, 0.80589365587866157, 0.2404682682863748,
0.44844082464215845, 0.63041681145346906, 0.73440308963136092,
0.28596226498920246, 0.32495711930591192, 0.1884751291974289,
0.69540823531465146, 0.1689777020390742, 0.25996569544472953,
0.32495711930591192, 0.37045111600873959, 0.272963980216966,
0.25346655305861127, 0.20797255635578363, 0.6239176690673508,
0.1884751291974289, 0.14298113249460123, 0.17547684442519243,
0.60442024190899613, 0.76039965917583385, 0.70190737770076972,
0.25346655305861127, 0.24696741067249306, 0.31845797691979366,
0.20797255635578363, 0.20797255635578363, 0.63691595383958732,
0.48743567895886786, 0.1689777020390742, 0.1559794172668377,
0.30545969214755719, 0.17547684442519243, 0.40294682793933079,
0.2404682682863748, 0.656413380997942, 0.4809365365727496, 0.40944597032544899,
0.54592796043393199, 0.71490566247300613, 0.24696741067249306,
0.20147341396966539, 0.17547684442519243, 0.43544253986992193,
0.2209708411280201, 0.22746998351413833, 0.20147341396966539,
0.35745283123650307, 0.86438593735372571, 0.272963980216966,
0.27946312260308426, 0.77989708633418853, 0.25346655305861127,
0.47443739418663139, 0.38344940078097606, 0.17547684442519243,
0.33145626169203013, 0.22746998351413833, 0.38994854316709426,
0.2404682682863748, 0.53942881804781373, 0.74740137440359733,
0.31845797691979366, 0.2404682682863748, 0.69540823531465146,
0.25346655305861127, 0.3119588345336754, 0.42894339748380372,
0.33795540407814839, 0.32495711930591192, 0.136481990108483,
0.85788679496760745, 0.16247855965295596, 0.38344940078097606,
0.3444545464642666, 0.33145626169203013, 0.46143910941439492,
0.40944597032544899, 0.42244425509768546, 0.25346655305861127,
0.54592796043393199, 0.67591080815629678, 0.19497427158354713,
0.35095368885038486, 0.12348370533624653, 0.30545969214755719,
0.57192452997840493, 0.35095368885038486, 0.35095368885038486,
0.2209708411280201, 0.31845797691979366, 0.33795540407814839,
0.16247855965295596, 0.2209708411280201, 0.52643053327557732,
0.44194168225604019, 0.27946312260308426, 0.20797255635578363,
0.86438593735372571, 0.64991423861182385, 0.30545969214755719,
0.37045111600873959, 0.2404682682863748, 0.51343224850334079,
0.2404682682863748, 0.136481990108483, 0.55892624520616851, 0.24696741067249306,
0.16247855965295596, 0.33795540407814839, 0.2209708411280201,
0.2404682682863748, 0.37045111600873959, 0.14298113249460123,
0.46793825180051313, 0.16247855965295596, 0.73440308963136092,
0.3769502583948578, 0.24696741067249306, 0.51343224850334079,
0.67591080815629678, 0.55242710282005025, 0.47443739418663139,
0.63691595383958732, 0.24696741067249306, 0.3119588345336754,
0.25346655305861127, 0.39644768555321253, 0.31845797691979366,
0.20797255635578363, 0.72140480485912439, 0.23396912590025656,
0.28596226498920246, 0.26646483783084773, 0.74740137440359733,
0.76689880156195211, 0.31845797691979366, 0.89688164928431691,
0.3119588345336754, 0.53942881804781373, 0.40294682793933079,
0.71490566247300613, 0.27946312260308426, 0.38994854316709426,
0.2209708411280201, 0.27946312260308426, 0.24696741067249306,
0.31845797691979366, 0.32495711930591192, 0.42244425509768546,
0.29246140737532073, 0.70190737770076972, 0.14298113249460123,
0.23396912590025656, 0.31845797691979366, 0.40944597032544899,
0.60442024190899613, 0.51343224850334079, 0.67591080815629678,
0.4809365365727496, 0.68240995054241504, 0.1689777020390742,
0.6239176690673508, 0.79289537110642505, 0.3444545464642666,
0.25996569544472953, 0.74740137440359733, 0.50693310611722253,
0.33795540407814839, 0.51343224850334079, 0.73440308963136092,
0.74090223201747918, 0.14948027488071947, 0.76689880156195211,
0.93587650360102626, 0.38344940078097606, 0.37045111600873959,
0.42894339748380372, 0.3444545464642666, 0.23396912590025656,
0.40294682793933079, 0.2209708411280201, 0.32495711930591192,
0.3444545464642666, 0.52643053327557732, 0.1689777020390742,
0.1884751291974289, 0.32495711930591192, 0.656413380997942, 0.72140480485912439,
0.77339794394807038, 0.3769502583948578, 0.28596226498920246,
0.19497427158354713, 0.53292967566169547, 0.51343224850334079,
0.3444545464642666, 0.272963980216966, 0.31845797691979366, 0.64341509622570559,
0.41594511271156726, 0.43544253986992193, 0.45493996702827666,
0.53292967566169547, 0.58492281475064145, 0.74740137440359733,
0.29896054976143893, 0.72140480485912439, 0.57842367236452319,
0.55892624520616851, 0.75390051678971559, 0.30545969214755719,
0.27946312260308426, 0.70840652008688798, 0.53942881804781373,
0.60442024190899613, 0.6239176690673508, 0.656413380997942, 0.53292967566169547,
0.59142195713675971, 0.40294682793933079, 0.36395197362262133,
0.44194168225604019, 0.27946312260308426, 0.46143910941439492,
0.59792109952287786, 0.78639622872030679, 0.57192452997840493,
0.29896054976143893, 0.38994854316709426, 0.48743567895886786,
0.64341509622570559, 0.16247855965295596, 0.38344940078097606,
0.44194168225604019, 0.41594511271156726, 0.18587547224298162,
0.33600566136231291, 0.38539914349681148, 0.27621355141002513,
0.46923808027773678, 0.39904734250765983, 0.53812898957059008,
0.22876981199136201, 0.45883945245994756, 0.27816329412586055,
0.096837221553161754, 0.44194168225604019, 0.10853567784817457,
0.3243072050673001, 0.5563265882517211, 0.29246140737532073,
0.35095368885038486, 0.43349279715408651, 0.29961046400005076,
0.27361389445557782, 0.20732264211717177, 0.15143001759655494,
0.15987890269850866, 0.59532144256843056, 0.48028662233413782,
0.32625694778313558, 0.32560703354452375, 0.3080593491020045,
0.13908164706293027, 0.38799880045125884, 0.20667272787855998,
0.37175094448596324, 0.58427290051202962, 0.36005248819095037,
0.40944597032544899, 0.28466243651197881, 0.15402967455100225,
0.29246140737532073, 0.076689880156195211, 0.48353619352719696,
0.28531235075059064, 0.6239176690673508, 0.55892624520616851,
0.13973156130154213, 0.35095368885038486, 0.24566758219526938,
0.17352710170935695, 0.20082349973105354, 0.084488851019537098,
0.12413361957485836, 0.43479262563131016, 0.40879605608683717,
0.50823293459444618, 0.1689777020390742, 0.17872641561825153,
0.13908164706293027, 0.15987890269850866, 0.15013018911933132,
0.30221012095449806, 0.40944597032544899, 0.54137856076364921,
0.61221921277233804, 0.45039056735799388, 0.41009588456406082,
0.53292967566169547, 0.43544253986992193, 0.45688970974411214,
0.37305077296318684, 0.10333636393927999, 0.21187204178745456,
0.24956706762694034, 0.25996569544472953, 0.77469777242529403,
0.43544253986992193, 0.19042487191326438, 0.49718439253804519,
0.38409931501958788, 0.43934202530159283, 0.13973156130154213,
0.24826723914971671, 0.45429005278966489, 0.48353619352719696,
0.34510446070287842, 0.33340600440786561, 0.45234031007382935,
0.33730548983953657, 0.38994854316709426, 0.33340600440786561,
0.23656878285470387, 0.23786861133192752, 0.15792915998267318,
0.38929862892848244, 0.11828439142735193, 0.15143001759655494,
0.43999193954020471, 0.3607024024295622, 0.42114442662046181,
0.5309799329458601, 0.10788576360956276, 0.45299022431244124,
0.37500051567902237, 0.34900394613454938, 0.40034717098488348,
0.73375317539274909, 0.72985368996107813, 0.26581492359223591,
0.4822363650499733, 0.20927238483300728, 0.24631749643388121,
0.54007873228642556, 0.20082349973105354, 0.21772126993496096,
0.33470583288508926, 0.42699365476796824, 0.47443739418663139,
0.53033001870724816, 0.56087598792200388, 0.51928147665084723,
0.16117873117573231, 0.30610960638616902, 0.60896964157927891,
0.2567161242516704, 0.2430679252408221, 0.66226260914544854,
0.27816329412586055, 0.083838936780925272, 0.36655163057706863,
0.55567667401310938, 0.51278233426472897, 0.41984459814323816,
0.40684631337100169, 0.29246140737532073, 0.46403876636884223,
0.328206690498971, 0.42179434085907369, 0.42569382629074459,
0.11828439142735193, 0.37370068720179866, 0.18197598681131066,
0.44389142497187561, 0.15078010335794312, 0.52968010446863645,
0.30480977790894537, 0.45558988126688843, 0.23006964046858561,
0.52318096208251819, 0.27621355141002513, 0.34185488950981935,
0.23201938318442111, 0.3470542034187139, 0.12868301924514111,
0.29896054976143893, 0.27166415173974234, 0.14168130401737761,
0.46403876636884223, 0.40489657065516621, 0.34510446070287842,
0.36980120177012776, 0.11243516327984553, 0.20862247059439545,
0.067591080815629673, 0.25476638153583497, 0.48418610776580873,
0.22227066960524375, 0.43999193954020471, 0.12608336229069381,
0.34835403189593755, 0.16247855965295596, 0.44324151073326384,
0.25996569544472953, 0.35485317428205582, 0.44649108192632297,
0.52968010446863645, 0.14948027488071947, 0.29441115009115615,
0.13193259043820024, 0.24436775371804575, 0.36395197362262133,
0.43934202530159283, 0.21707135569634914, 0.32495711930591192,
0.36785145905429228, 0.35095368885038486, 0.43544253986992193,
0.31780806268118184, 0.56607530183089849, 0.20537289940133632,
0.60117067071593699, 0.54982744586560295, 0.45429005278966489,
0.54592796043393199, 0.19627410006077078, 0.11308507751845734,
0.37825008687208145, 0.42829348324519195, 0.15532950302822587,
0.23266929742303291, 0.40424665641655444, 0.49198507862915064,
0.50043396373110438, 0.26191543816056495, 0.51993139088945906,
0.20407307092411267, 0.35615300275927941, 0.29311132161393255,
0.43349279715408651, 0.11828439142735193, 0.58037341508035867,
0.52318096208251819, 0.24566758219526938, 0.23461904013886839,
0.26581492359223591, 0.16637804508462689, 0.22032092688940827,
0.11243516327984553, 0.51473207698056445, 0.59337169985259508,
0.20862247059439545, 0.31390857724951088, 0.30286003519310989,
0.34120497527120752, 0.46858816603912495, 0.40489657065516621,
0.33405591864647743, 0.12868301924514111, 0.26191543816056495,
0.69735797803048694, 0.12673327652930563, 0.20407307092411267,
0.3957977713146007, 0.18132607257269884, 0.12738319076791749,
0.67331115120184948, 0.19302452886771165, 0.48288627928858507,
0.58427290051202962, 0.11243516327984553, 0.25476638153583497,
0.49718439253804519, 0.58297307203480597, 0.16312847389156779,
0.23526895437748024, 0.10008679274622087, 0.28336260803475521,
0.45623979550550031, 0.19497427158354713, 0.39449794283737705,
0.52773036175280097, 0.61481886972678523, 0.19042487191326438,
0.42829348324519195, 0.49978404949249255, 0.55697650249033304,
0.33340600440786561, 0.47963670809552594, 0.43674236834714564,
0.52773036175280097, 0.47638713690246681, 0.17027753051629782,
0.43154305443825103, 0.1007367069848327, 0.20147341396966539,
0.46923808027773678, 0.25996569544472953, 0.39384802859876522,
0.30870926334061632, 0.48873550743609151, 0.21967101265079642,
0.53357958990030729, 0.56217581639922765, 0.12348370533624653,
0.44584116768771109, 0.55242710282005025, 0.41074579880267265,
0.39709759979182435, 0.25346655305861127, 0.65511355252071835,
0.38214957230375241, 0.31715814844257001, 0.48873550743609151,
0.50693310611722253, 0.16702795932323872, 0.49523464982220977,
0.42699365476796824, 0.5959713568070425, 0.26581492359223591,
0.59857101376148969, 0.37760017263346962, 0.328206690498971,
0.33535574712370109, 0.20017358549244174, 0.17352710170935695,
0.62001818363567995, 0.29961046400005076, 0.5836229862734178,
0.10008679274622087, 0.33730548983953657, 0.26451509511501231,
0.1527298460737786, 0.28076295108030791, 0.43934202530159283,
0.28141286531891968, 0.43284288291547462, 0.51213242002611714,
0.38604905773542331, 0.26581492359223591, 0.46923808027773678,
0.21642144145773731, 0.16767787356185054, 0.18002624409547519,
0.098786964268997218, 0.65771320947516576, 0.22487032655969105,
0.27101423750113057, 0.38669897197403519, 0.43154305443825103,
0.28856192194364977, 0.37305077296318684, 0.13453224739264752,
0.36265214514539768, 0.65901303795238941, 0.48548593624303238,
0.70255729193938155, 0.4120456272798963, 0.37435060144041055,
0.2209708411280201, 0.30480977790894537, 0.60766981310205526,
0.20212332820827722, 0.28466243651197881, 0.53552933261614288,
0.52903019023002462, 0.31065900605645175, 0.43609245410853376,
0.28206277955753151, 0.43869211106298106, 0.42374408357490911,
0.11048542056401005, 0.43934202530159283, 0.3145584914881227,
0.4445413392104875, 0.3145584914881227, 0.23916843980915115,
0.32495711930591192, 0.094237564598714449, 0.28271269379614333,
0.18977495767465255, 0.60572007038621978, 0.12088404838179924,
0.11633464871151646, 0.21707135569634914, 0.2404682682863748,
0.39774751403043618, 0.24761732491110489, 0.40229691370071891,
0.26906449478529504, 0.29441115009115615, 0.22617015503691468,
0.38474922925819971, 0.34315471798704295, 0.41334545575711995,
0.17287718747074515, 0.65771320947516576, 0.48743567895886786,
0.089038250689819853, 0.56217581639922765, 0.15662933150544955,
0.60117067071593699, 0.46858816603912495, 0.13193259043820024,
0.30091029247727441, 0.58102332931897049, 0.25086689610416402,
0.25736603849028222, 0.39059845740570609, 0.66226260914544854,
0.22422041232107923, 0.47053790875496049, 0.1910747861518762,
0.55697650249033304, 0.64016552503264645, 0.16117873117573231,
0.24696741067249306, 0.57387427269424041, 0.29116157889809707,
0.20927238483300728, 0.36785145905429228, 0.18912504343604072,
0.2047229851627245, 0.24891715338832851, 0.42179434085907369,
0.28466243651197881, 0.58947221442092423, 0.49133516439053876,
0.43219296867686285, 0.23071955470719746, 0.38084974382652875,
0.53227976142308375, 0.33470583288508926, 0.35030377461177303,
0.34250480374843117, 0.49263499286776241, 0.27426380869418965,
0.51928147665084723, 0.34510446070287842, 0.51018267731028166,
0.33665557560092474, 0.46403876636884223, 0.18457564376575794,
0.26126552392195318, 0.30935917757922815, 0.21967101265079642,
0.20797255635578363, 0.38149965806514058, 0.47638713690246681,
0.35875265971372677, 0.28141286531891968, 0.42959331172241549,
0.31585831996534636, 0.28466243651197881, 0.18457564376575794,
0.30675952062478085, 0.43739228258575741, 0.54917753162699112,
0.38474922925819971, 0.51993139088945906, 0.19237461462909985,
0.32690686202174735, 0.26646483783084773, 0.41984459814323816,
0.33340600440786561, 0.18132607257269884, 0.57842367236452319,
0.18197598681131066, 0.44714099616493475, 0.41529519847295543,
0.16767787356185054, 0.42244425509768546, 0.57062470150118128,
0.35615300275927941, 0.3444545464642666, 0.40034717098488348,
0.41594511271156726, 0.26256535239917683, 0.33925523255537204,
0.63106672569208089, 0.21642144145773731, 0.19172470039048803,
0.50303362068555169, 0.1722272732321333, 0.45818953822133579,
0.63041681145346906, 0.5836229862734178, 0.136481990108483, 0.53357958990030729,
0.23786861133192752, 0.41009588456406082, 0.34315471798704295,
0.4848360220044205, 0.12218387685902288, 0.23721869709331569,
0.23656878285470387, 0.114384905995681, 0.23461904013886839,
0.12088404838179924, 0.19432435734493531, 0.26516500935362408,
0.10528610665511545, 0.20277324244688902, 0.29376123585254438,
0.27491372293280147, 0.23201938318442111, 0.41659502695017903,
0.33925523255537204, 0.32170754811285279, 0.16962761627768602,
0.44064185377881654, 0.46208902365300669, 0.48743567895886786,
0.17092744475490967, 0.37825008687208145, 0.19042487191326438,
0.16182864541434411, 0.5862226432278651, 0.36720154481568046,
0.12218387685902288, 0.58102332931897049, 0.28531235075059064,
0.3957977713146007, 0.31130892029506357, 0.46338885213023034,
0.57192452997840493, 0.29311132161393255, 0.19432435734493531,
0.64601475318015289, 0.43414271139269828, 0.51538199121917627,
0.54527804619532017, 0.65056415285043556, 0.19432435734493531,
0.55502675977449756, 0.3957977713146007, 0.67721063663352044,
0.53812898957059008, 0.36590171633845681, 0.26906449478529504,
0.46338885213023034, 0.13193259043820024, 0.3957977713146007,
0.5010838779697161, 0.50953276307166995, 0.24566758219526938,
0.41074579880267265, 0.37565042991763414, 0.29116157889809707,
0.26516500935362408, 0.5361792468547546, 0.51798164817362358,
0.20537289940133632, 0.38214957230375241, 0.50173379220832803,
0.48028662233413782, 0.46208902365300669, 0.34900394613454938,
0.45429005278966489, 0.15532950302822587, 0.38279948654236423,
0.30935917757922815, 0.57517410117146406, 0.28141286531891968,
0.30221012095449806, 0.33015643321480648, 0.17937632985686339,
0.38669897197403519, 0.29636089280699168, 0.60117067071593699,
0.25281663881999944, 0.22357049808246737, 0.27426380869418965,
0.56672521606951043, 0.39774751403043618, 0.64536483894154106,
0.24761732491110489, 0.30156020671588624, 0.48938542167470328,
0.70125746346215789, 0.30286003519310989, 0.32365729082868822,
0.36655163057706863, 0.53357958990030729, 0.46793825180051313,
0.15337976031239042, 0.33470583288508926, 0.36915128753151588,
0.50823293459444618, 0.50758302035583436, 0.40034717098488348,
0.43414271139269828, 0.21122212754884273, 0.58037341508035867,
0.44324151073326384, 0.46923808027773678, 0.20537289940133632,
0.45429005278966489, 0.49003533591331516, 0.49328490710637429,
0.3633020593840095, 0.31000909181783998, 0.46988799451634861,
0.46663842332328948, 0.40034717098488348, 0.13453224739264752,
0.081239279826477981, 0.48548593624303238, 0.38669897197403519,
0.45623979550550031, 0.14883036064210764, 0.49783430677665702,
0.45234031007382935, 0.15987890269850866, 0.55762641672894486,
0.56672521606951043, 0.20862247059439545, 0.45818953822133579,
0.25996569544472953, 0.50823293459444618, 0.24956706762694034,
0.40619639913238986, 0.40229691370071891, 0.28921183618226159,
0.32560703354452375, 0.50433344916277523, 0.1884751291974289,
0.46338885213023034, 0.62781715449902176, 0.14103138977876575,
0.57647392964868771, 0.13453224739264752, 0.38864871468987061,
0.6512140670890475, 0.38149965806514058, 0.21252195602606641,
0.23786861133192752, 0.21902109841218464, 0.25281663881999944,
0.20277324244688902, 0.35030377461177303, 0.57387427269424041,
0.19952367125382992, 0.38279948654236423, 0.19627410006077078,
0.48808559319747963, 0.25476638153583497, 0.22746998351413833,
0.34640428918010208, 0.5010838779697161, 0.54072864652503738,
0.14688061792627219, 0.40164699946210708, 0.34120497527120752,
0.464688680607454, 0.29766072128421528, 0.20927238483300728,
0.51798164817362358, 0.51668181969639992, 0.28011303684169608,
0.27621355141002513, 0.39774751403043618, 0.40099708522349531,
0.22422041232107923, 0.13843173282431848, 0.60766981310205526,
0.3080593491020045, 0.26256535239917683, 0.12738319076791749,
0.10268644970066816, 0.39514785707598887, 0.18977495767465255,
0.47703705114107869, 0.18522555800436979, 0.50628319187861082,
0.53682916109336642, 0.23721869709331569, 0.51018267731028166,
0.13323241891542387, 0.18522555800436979, 0.44649108192632297,
0.26776466630807144, 0.43479262563131016, 0.49978404949249255,
0.10268644970066816, 0.1150348202342928, 0.14363104673321306,
0.61351904124956169, 0.12153396262041105, 0.52903019023002462,
0.29961046400005076, 0.46273893789161857, 0.68760926445130954,
0.57842367236452319, 0.38084974382652875, 0.4120456272798963,
0.31585831996534636, 0.32885660473758288, 0.35485317428205582,
0.14168130401737761, 0.50563327763999888, 0.62326775482873908,
0.53422950413891923, 0.58947221442092423, 0.52708044751418903,
0.34835403189593755, 0.43024322596102738, 0.49068525015192699,
0.4984842210152689, 0.36395197362262133, 0.48938542167470328,
0.24761732491110489, 0.30610960638616902, 0.75455043102832742,
0.45753962398272402, 0.25996569544472953, 0.07798970863341885,
0.56087598792200388, 0.32040771963562914, 0.61156929853372621,
0.32495711930591192, 0.46663842332328948, 0.5511272743428266,
0.54137856076364921, 0.23591886861609201, 0.1884751291974289,
0.55177718858143843, 0.53422950413891923, 0.31780806268118184,
0.47963670809552594, 0.24176809676359848, 0.55242710282005025,
0.53552933261614288, 0.089038250689819853, 0.42374408357490911,
0.32495711930591192, 0.65186398132765921, 0.42114442662046181,
0.33795540407814839, 0.079289537110642502, 0.35875265971372677,
0.32950651897619471, 0.17287718747074515, 0.12803310500652929,
0.31845797691979366, 0.52903019023002462, 0.33860531831676022,
0.73440308963136092, 0.3145584914881227, 0.16312847389156779,
0.50173379220832803, 0.48288627928858507, 0.26321526663778866,
0.47248765147079591, 0.38669897197403519, 0.11568473447290464,
0.61806844091984436, 0.1150348202342928, 0.49263499286776241,
0.15922898845989683, 0.81759211217367433, 0.49133516439053876,
0.30740943486339262, 0.272963980216966, 0.60572007038621978,
0.37175094448596324, 0.53877890380920201, 0.33405591864647743,
0.45753962398272402, 0.38604905773542331, 0.52643053327557732,
0.54787770314976747, 0.23331921166164474, 0.37825008687208145,
0.27816329412586055, 0.52578061903696549, 0.45299022431244124,
0.14753053216488399, 0.29766072128421528, 0.1527298460737786,
0.20277324244688902, 0.5036835349241634, 0.36395197362262133,
0.50953276307166995, 0.33665557560092474, 0.68240995054241504,
0.5160319054577881, 0.54592796043393199, 0.33860531831676022,
0.30610960638616902, 0.28921183618226159, 0.33145626169203013,
0.19952367125382992, 0.48028662233413782, 0.50238370644693975,
0.47248765147079591, 0.61481886972678523, 0.58492281475064145,
0.57972350084174684, 0.59662127104565421, 0.51473207698056445,
0.4445413392104875, 0.15337976031239042, 0.59337169985259508,
0.3308063474534183, 0.34575437494149031, 0.32755677626035917,
0.42569382629074459, 0.44064185377881654, 0.26776466630807144,
0.46533859484606582, 0.42569382629074459, 0.087088507973984389,
0.28986175042087342, 0.56607530183089849, 0.23331921166164474,
0.37305077296318684, 0.25021698186555219, 0.52968010446863645,
0.11698456295012828, 0.39514785707598887, 0.30740943486339262,
0.50498336340138716, 0.6388656965554228, 0.45753962398272402,
0.28856192194364977, 0.28791200770503794, 0.32885660473758288,
0.35030377461177303, 0.4848360220044205, 0.50563327763999888,
0.37045111600873959, 0.26581492359223591, 0.51538199121917627,
0.2918114931367089, 0.17872641561825153, 0.27036432326251869,
0.3470542034187139, 0.39254820012154157, 0.1527298460737786,
0.17937632985686339, 0.25541629577444674, 0.45234031007382935,
0.50888284883305801, 0.42894339748380372, 0.4445413392104875,
0.32495711930591192, 0.36525180209984498, 0.4607891951757831,
0.43479262563131016, 0.38474922925819971, 0.15662933150544955,
0.40489657065516621, 0.1722272732321333, 0.5309799329458601,
0.5036835349241634, 0.44714099616493475, 0.29246140737532073,
0.21837118417357282, 0.55242710282005025, 0.42699365476796824,
0.23461904013886839, 0.20862247059439545, 0.12998284772236476,
0.34380463222565477, 0.47638713690246681, 0.32495711930591192,
0.24956706762694034, 0.44389142497187561, 0.57907358660313502,
0.46728833756190136, 0.36785145905429228, 0.10333636393927999,
0.31975780539701731, 0.28791200770503794, 0.24501766795665758,
0.67006158000879035, 0.26711475206945962, 0.40944597032544899,
0.33730548983953657, 0.57777375812591136, 0.42049451238185004,
0.43869211106298106, 0.34900394613454938, 0.43089314019963915,
0.14363104673321306, 0.55372693129727391, 0.55762641672894486,
0.34250480374843117, 0.18652538648159342, 0.3444545464642666,
0.42894339748380372, 0.17872641561825153, 0.47963670809552594,
0.51668181969639992, 0.3620022309067859, 0.22876981199136201,
0.21317187026467818, 0.4984842210152689, 0.49133516439053876,
0.64211526774848193, 0.35030377461177303, 0.28596226498920246,
0.45364013855105301, 0.39059845740570609, 0.28076295108030791,
0.18457564376575794, 0.36395197362262133, 0.41984459814323816,
0.12478353381347017, 0.64601475318015289, 0.54592796043393199,
0.40424665641655444, 0.52058130512807088, 0.50693310611722253,
0.3957977713146007, 0.25021698186555219, 0.50563327763999888,
0.3444545464642666, 0.24111818252498665, 0.49393482134498612,
0.43414271139269828, 0.19562418582215899, 0.26906449478529504,
0.39384802859876522, 0.28206277955753151, 0.41074579880267265,
0.14623070368766036, 0.36850137329290411, 0.27491372293280147,
0.51668181969639992, 0.46923808027773678, 0.46013928093717121,
0.28726209346642612, 0.38019982958791693, 0.10853567784817457,
0.14688061792627219, 0.14818044640349584, 0.27491372293280147,
0.37045111600873959, 0.5361792468547546, 0.60182058495454882,
0.1722272732321333, 0.49653447829943342, 0.52253104784390636,
0.18587547224298162, 0.25476638153583497, 0.40164699946210708,
0.49133516439053876, 0.19887375701521809, 0.47833687961830229,
0.51798164817362358, 0.28726209346642612, 0.32885660473758288,
0.4984842210152689, 0.35485317428205582, 0.32040771963562914,
0.54527804619532017, 0.16182864541434411, 0.22552024079830288,
0.46858816603912495, 0.25996569544472953, 0.50498336340138716,
0.52838027599141268, 0.2209708411280201, 0.54462813195670834,
0.17287718747074515, 0.45234031007382935, 0.15337976031239042,
0.25346655305861127, 0.22162075536663192, 0.31910789115840549,
0.15467958878961408, 0.34185488950981935, 0.66941166577017852,
0.24566758219526938, 0.54137856076364921, 0.36265214514539768,
0.19042487191326438, 0.50823293459444618, 0.23981835404776297,
0.47118782299357226, 0.49458473558359789, 0.23396912590025656,
0.49588456406082154, 0.5836229862734178, 0.54137856076364921,
0.30221012095449806, 0.35160360308899669, 0.18262590104992249,
0.27816329412586055, 0.26711475206945962, 0.12413361957485836,
0.38214957230375241, 0.4659885090846777, 0.32235746235146462,
0.49133516439053876, 0.35875265971372677, 0.21837118417357282,
0.41269554151850812, 0.39384802859876522, 0.63756586807819915,
0.55762641672894486, 0.60831972734066708, 0.58427290051202962,
0.27946312260308426, 0.23916843980915115, 0.16442830236879144,
0.55437684553588573, 0.19757392853799444, 0.60766981310205526,
0.62521749754457456, 0.35940257395233854, 0.31000909181783998,
0.32170754811285279, 0.6187183551584563, 0.43869211106298106,
0.51343224850334079, 0.23331921166164474, 0.20732264211717177,
0.39514785707598887, 0.35615300275927941, 0.25736603849028222,
0.48028662233413782, 0.26971440902390686, 0.16117873117573231,
0.31975780539701731, 0.24696741067249306, 0.5160319054577881,
0.47053790875496049, 0.52838027599141268, 0.21512161298051369,
0.55567667401310938, 0.21707135569634914, 0.62196792635151543,
0.55307701705866197, 0.19497427158354713, 0.13518216163125935,
0.37825008687208145, 0.45493996702827666, 0.21967101265079642,
0.22811989775275016, 0.41074579880267265, 0.31325866301089911,
0.10723584937095093, 0.44649108192632297, 0.47313756570940774,
0.40099708522349531, 0.42634374052935636, 0.41529519847295543,
0.33730548983953657, 0.4809365365727496, 0.2755636371714133,
0.16702795932323872, 0.57387427269424041, 0.41919468390462633,
0.38019982958791693, 0.32040771963562914, 0.38084974382652875,
0.15078010335794312, 0.58947221442092423, 0.40684631337100169,
0.31975780539701731, 0.47573722266385504, 0.59792109952287786,
0.29246140737532073, 0.67981029358796763, 0.42829348324519195,
0.42764356900658007, 0.32690686202174735, 0.35290343156622028,
0.32755677626035917, 0.12933293348375294, 0.16702795932323872,
0.70710669160966433, 0.072790394724524268, 0.38734888621264701,
0.14948027488071947, 0.55827633096755669, 0.57777375812591136,
0.33535574712370109, 0.22487032655969105, 0.18392572952714614,
0.29571097856837986, 0.43869211106298106, 0.26321526663778866,
0.37825008687208145, 0.30545969214755719, 0.64276518198709376,
0.23526895437748024, 0.53422950413891923, 0.61026947005650256,
0.19302452886771165, 0.21577152721912551, 0.40814614184822534,
0.47183773723218403, 0.26386518087640048, 0.55242710282005025,
0.65836312371377748, 0.10138662122344451, 0.32560703354452375,
0.40684631337100169, 0.23201938318442111, 0.25281663881999944,
0.26646483783084773, 0.16117873117573231, 0.10333636393927999,
0.51083259154889349, 0.30221012095449806, 0.45299022431244124,
0.4607891951757831, 0.1884751291974289, 0.52643053327557732,
0.30091029247727441, 0.61546878396539717, 0.45753962398272402,
0.60182058495454882, 0.38539914349681148, 0.64081543927125828,
0.18262590104992249, 0.19237461462909985, 0.48678576472025609,
0.70255729193938155, 0.26906449478529504, 0.29636089280699168,
0.16117873117573231, 0.28856192194364977, 0.32170754811285279,
0.53682916109336642, 0.37825008687208145, 0.58687255746647693,
0.18262590104992249, 0.36850137329290411, 0.29311132161393255,
0.46533859484606582, 0.43804219682436929, 0.5361792468547546,
0.27946312260308426, 0.26126552392195318, 0.43414271139269828,
0.39709759979182435, 0.34835403189593755, 0.61676861244262082,
0.45299022431244124, 0.46013928093717121, 0.29961046400005076,
0.30350994943172172, 0.34770411765732573, 0.60507015614760795,
0.12738319076791749, 0.68695935021269783, 0.37500051567902237,
0.6440650104643173, 0.51278233426472897, 0.36395197362262133,
0.27946312260308426, 0.39254820012154157, 0.39384802859876522,
0.3243072050673001, 0.65446363828210663, 0.40424665641655444,
0.33925523255537204, 0.61351904124956169, 0.40424665641655444,
0.48288627928858507, 0.25281663881999944, 0.38929862892848244,
0.53552933261614288, 0.14948027488071947, 0.57517410117146406,
0.31260874877228728, 0.328206690498971, 0.27751337988724878,
0.56542538759228667, 0.22422041232107923, 0.64276518198709376,
0.37890000111069327, 0.56932487302395762, 0.52058130512807088,
0.1559794172668377, 0.136481990108483, 0.2430679252408221, 0.38149965806514058,
0.23916843980915115, 0.17547684442519243, 0.55437684553588573,
0.24111818252498665, 0.41464528423434355, 0.22487032655969105,
0.35485317428205582, 0.43869211106298106, 0.17547684442519243,
0.51213242002611714, 0.50823293459444618, 0.52968010446863645,
0.4861358504816442, 0.55242710282005025, 0.23851852557053935,
0.45234031007382935, 0.41009588456406082, 0.464688680607454,
0.22552024079830288, 0.20017358549244174, 0.47053790875496049,
0.67981029358796763, 0.40749622760961357, 0.31390857724951088,
0.33210617593064196, 0.44194168225604019, 0.41594511271156726,
0.41659502695017903, 0.24501766795665758, 0.17417701594796878,
0.48028662233413782, 0.38799880045125884, 0.4848360220044205,
0.39189828588292974, 0.12543344805208201, 0.26971440902390686,
0.46013928093717121, 0.099436878507609044, 0.38864871468987061,
0.51408216274195262, 0.45558988126688843, 0.40489657065516621,
0.29246140737532073, 0.13128267619958842, 0.49068525015192699,
0.16637804508462689, 0.09293773612149081, 0.27426380869418965,
0.28531235075059064, 0.54267838924087286, 0.52903019023002462,
0.22552024079830288, 0.18782521495881707, 0.47768696537969052,
0.56932487302395762, 0.34900394613454938, 0.15532950302822587,
0.48743567895886786, 0.36135231666817402, 0.63366638264652819,
0.20797255635578363, 0.55827633096755669, 0.21122212754884273,
0.27101423750113057, 0.4607891951757831, 0.38994854316709426,
0.20537289940133632, 0.59727118528426615, 0.38734888621264701,
0.52188113360529453, 0.28596226498920246, 0.27816329412586055,
0.48743567895886786, 0.74935111711943281, 0.18717530072020527,
0.49263499286776241, 0.41334545575711995, 0.47898679385691417,
0.28401252227336704, 0.46858816603912495, 0.43024322596102738,
0.43024322596102738, 0.23071955470719746, 0.1527298460737786,
0.30935917757922815, 0.60117067071593699, 0.33665557560092474,
0.29246140737532073, 0.20992229907161908, 0.19822384277660626,
0.20602281363994815, 0.65771320947516576, 0.23201938318442111,
0.23916843980915115, 0.34640428918010208, 0.13323241891542387,
0.16182864541434411, 0.64861441013460019, 0.40879605608683717,
0.43284288291547462, 0.49003533591331516, 0.50628319187861082,
0.464688680607454, 0.36135231666817402, 0.47053790875496049,
0.18457564376575794, 0.51668181969639992, 0.38214957230375241,
0.26971440902390686, 0.20927238483300728, 0.24761732491110489,
0.3633020593840095, 0.22227066960524375, 0.43674236834714564,
0.3607024024295622, 0.57842367236452319, 0.061741852668123265,
0.53877890380920201, 0.41464528423434355, 0.34510446070287842,
0.44519125344909932, 0.40359674217794261, 0.53422950413891923,
0.20602281363994815, 0.17092744475490967, 0.65836312371377748,
0.34510446070287842, 0.24111818252498665, 0.42764356900658007,
0.44844082464215845, 0.56217581639922765, 0.46403876636884223,
0.55177718858143843, 0.5309799329458601, 0.61156929853372621,
0.11373499175706916, 0.38279948654236423, 0.30935917757922815,
0.48873550743609151, 0.38344940078097606, 0.10788576360956276,
0.37045111600873959, 0.27946312260308426, 0.38669897197403519,
0.50823293459444618, 0.20602281363994815, 0.28336260803475521,
0.25346655305861127, 0.29506106432976797, 0.21902109841218464,
0.47703705114107869, 0.44649108192632297, 0.33860531831676022,
0.38799880045125884, 0.27166415173974234, 0.70125746346215789,
0.51928147665084723, 0.24566758219526938, 0.42179434085907369,
0.42374408357490911, 0.37240085872457501, 0.20732264211717177,
0.6239176690673508, 0.52968010446863645, 0.4659885090846777,
0.45623979550550031, 0.26906449478529504, 0.33730548983953657,
0.4861358504816442, 0.272963980216966, 0.21382178450329004, 0.36980120177012776,
0.32885660473758288, 0.67266123696323765, 0.49978404949249255,
0.32950651897619471, 0.28206277955753151, 0.42114442662046181,
0.18262590104992249, 0.26776466630807144, 0.11048542056401005,
0.20602281363994815, 0.17677667290241608, 0.17807650137963971,
0.28726209346642612, 0.24891715338832851, 0.39904734250765983,
0.59402161409120702, 0.19692401429938261, 0.48353619352719696,
0.1748269301865806, 0.10853567784817457, 0.49003533591331516,
0.6063699846248316, 0.49198507862915064, 0.30156020671588624,
0.37890000111069327, 0.32365729082868822, 0.1559794172668377,
0.41724494118879091, 0.41139571304128447, 0.32495711930591192,
0.55242710282005025, 0.53357958990030729, 0.48353619352719696,
0.12738319076791749, 0.33340600440786561, 0.47248765147079591,
0.13908164706293027, 0.22162075536663192, 0.40879605608683717,
0.29636089280699168, 0.54137856076364921, 0.33730548983953657,
0.49978404949249255, 0.42309416933629729, 0.57777375812591136,
0.30221012095449806, 0.47768696537969052, 0.15662933150544955,
0.45039056735799388, 0.43544253986992193, 0.43739228258575741,
0.26451509511501231, 0.15922898845989683, 0.68695935021269783,
0.52448079055974184, 0.61741852668123265, 0.38929862892848244,
0.73960240354025553, 0.54462813195670834, 0.30610960638616902,
0.43934202530159283, 0.47833687961830229, 0.49978404949249255,
0.1910747861518762, 0.56022607368339217, 0.47378747994801962,
0.40034717098488348, 0.43999193954020471, 0.3620022309067859,
0.3607024024295622, 0.41139571304128447, 0.30480977790894537,
0.55827633096755669, 0.38344940078097606, 0.46533859484606582,
0.27881320836447243, 0.58297307203480597, 0.63821578231681098,
0.3470542034187139, 0.23851852557053935, 0.27751337988724878,
0.46663842332328948, 0.10268644970066816, 0.34575437494149031,
0.41399536999573178, 0.39709759979182435, 0.37435060144041055,
0.23266929742303291, 0.49523464982220977, 0.37110103024735142,
0.49523464982220977, 0.5511272743428266, 0.47313756570940774,
0.26451509511501231, 0.35355334580483216, 0.30675952062478085,
0.43024322596102738, 0.55892624520616851, 0.58297307203480597,
0.33730548983953657, 0.35680291699789124, 0.56542538759228667,
0.44584116768771109, 0.52318096208251819, 0.43284288291547462,
0.17677667290241608, 0.41334545575711995, 0.3957977713146007,
0.44259159649465196, 0.49458473558359789, 0.16572813084601506,
0.46208902365300669, 0.34120497527120752, 0.42634374052935636,
0.46403876636884223, 0.25086689610416402, 0.22487032655969105,
0.55892624520616851, 0.39189828588292974, 0.62196792635151543,
0.3620022309067859, 0.54137856076364921, 0.54527804619532017,
0.31650823420395824, 0.40164699946210708, 0.23396912590025656,
0.41269554151850812, 0.36005248819095037, 0.45948936669855944,
0.48743567895886786, 0.41854476966601456, 0.4445413392104875,
0.53812898957059008, 0.46208902365300669, 0.42374408357490911,
0.12933293348375294, 0.1910747861518762, 0.1910747861518762,
0.42049451238185004, 0.19757392853799444, 0.76624888732334029,
0.33795540407814839, 0.49068525015192699, 0.31845797691979366,
0.11763447718874012, 0.46273893789161857, 0.24111818252498665,
0.35290343156622028, 0.32235746235146462, 0.46273893789161857,
0.51083259154889349, 0.62911698297624541, 0.26841458054668321,
0.20667272787855998, 0.31845797691979366, 0.43479262563131016,
0.17677667290241608, 0.32235746235146462, 0.22487032655969105,
0.37890000111069327, 0.49328490710637429, 0.24176809676359848,
0.31715814844257001, 0.45429005278966489, 0.43609245410853376,
0.29896054976143893, 0.61351904124956169, 0.3620022309067859,
0.48028662233413782, 0.25151681034277584, 0.24176809676359848,
0.4822363650499733, 0.18067615833408701, 0.34185488950981935,
0.37565042991763414, 0.13973156130154213, 0.43219296867686285,
0.29766072128421528, 0.5036835349241634, 0.39189828588292974,
0.34315471798704295, 0.22357049808246737, 0.13713190434709482,
0.52188113360529453, 0.42374408357490911, 0.46793825180051313,
0.66291252338406026, 0.30480977790894537, 0.51733173393501175,
0.4848360220044205, 0.29311132161393255, 0.27751337988724878,
0.63951561079403463, 0.72790394724524266, 0.28076295108030791,
0.328206690498971, 0.30480977790894537, 0.19172470039048803,
0.28921183618226159, 0.48028662233413782, 0.33535574712370109,
0.18002624409547519, 0.40424665641655444, 0.47378747994801962,
0.61091938429511439, 0.45299022431244124, 0.33015643321480648,
0.54657787467254382, 0.063691595383958743, 0.48548593624303238,
0.15337976031239042, 0.23656878285470387, 0.57647392964868771,
0.31130892029506357, 0.12868301924514111, 0.33015643321480648,
0.31650823420395824, 0.47898679385691417, 0.38214957230375241,
0.61676861244262082, 0.45623979550550031, 0.59662127104565421,
0.37370068720179866, 0.30350994943172172, 0.35225351732760851,
0.40749622760961357, 0.3080593491020045, 0.53812898957059008,
0.53812898957059008, 0.25476638153583497, 0.42959331172241549,
0.26646483783084773, 0.2593157812061177, 0.29051166465948525,
0.28986175042087342, 0.50563327763999888, 0.26126552392195318,
0.464688680607454, 0.17092744475490967, 0.45493996702827666,
0.20927238483300728, 0.34120497527120752, 0.42634374052935636,
0.46013928093717121, 0.29961046400005076, 0.2755636371714133,
0.14753053216488399, 0.26646483783084773, 0.22487032655969105,
0.33340600440786561, 0.22422041232107923, 0.35355334580483216,
0.18717530072020527, 0.47248765147079591, 0.10528610665511545,
0.26776466630807144, 0.56087598792200388, 0.28921183618226159,
0.55827633096755669, 0.14233121825598941, 0.32690686202174735,
0.3119588345336754, 0.35160360308899669, 0.38669897197403519,
0.46923808027773678, 0.25281663881999944, 0.45753962398272402,
0.27036432326251869, 0.21447169874190186, 0.33470583288508926,
0.48353619352719696, 0.18132607257269884, 0.53162984718447182,
0.39254820012154157, 0.54072864652503738, 0.29766072128421528,
0.39644768555321253, 0.61546878396539717, 0.40294682793933079,
0.14948027488071947, 0.31260874877228728, 0.29701080704560351,
0.39839742826904795, 0.36590171633845681, 0.12348370533624653,
0.21902109841218464, 0.50693310611722253, 0.16962761627768602,
0.14168130401737761, 0.616118698204009, 0.15727924574406135,
0.5634756448764513, 0.61481886972678523, 0.29051166465948525,
0.45039056735799388, 0.15467958878961408, 0.39839742826904795,
0.46338885213023034, 0.44259159649465196, 0.46273893789161857,
0.63171663993069271, 0.29311132161393255, 0.47703705114107869,
0.1722272732321333, 0.40749622760961357, 0.21122212754884273,
0.3607024024295622, 0.33600566136231291, 0.22292058384385555,
0.41009588456406082, 0.23591886861609201, 0.61676861244262082,
0.54202847500226115, 0.36980120177012776, 0.31585831996534636,
0.54527804619532017, 0.10008679274622087, 0.4659885090846777,
0.35160360308899669, 0.48743567895886786, 0.34510446070287842,
0.36525180209984498, 0.53227976142308375, 0.54267838924087286,
0.47248765147079591, 0.23136946894580929, 0.46663842332328948,
0.42309416933629729, 0.24696741067249306, 0.10853567784817457,
0.66681200881573122, 0.43739228258575741, 0.49393482134498612,
0.39059845740570609, 0.43609245410853376, 0.36915128753151588,
0.60117067071593699, 0.30026037823866264, 0.29571097856837986,
0.25021698186555219, 0.33015643321480648, 0.39059845740570609,
0.12998284772236476, 0.34185488950981935, 0.30091029247727441,
0.11568473447290464, 0.090987993405655332, 0.57192452997840493,
0.3243072050673001, 0.23981835404776297, 0.60182058495454882,
0.26386518087640048, 0.46013928093717121, 0.51993139088945906,
0.06694116657701786, 0.24891715338832851, 0.27621355141002513,
0.22227066960524375, 0.16832778780046237, 0.67786055087213226,
0.38279948654236423, 0.25281663881999944, 0.28726209346642612,
0.36590171633845681, 0.51473207698056445, 0.45299022431244124,
0.25801595272889405, 0.39969725674627166, 0.38474922925819971,
0.42309416933629729, 0.24761732491110489, 0.52838027599141268,
0.36785145905429228, 0.14753053216488399, 0.13388233315403572,
0.19822384277660626, 0.51408216274195262, 0.28986175042087342,
0.46013928093717121, 0.15532950302822587, 0.4848360220044205,
0.44779091040354663, 0.14623070368766036, 0.47833687961830229,
0.46793825180051313, 0.46923808027773678, 0.30286003519310989,
0.43349279715408651, 0.62001818363567995, 0.17092744475490967,
0.48158645081136142, 0.56087598792200388, 0.31260874877228728,
0.39059845740570609, 0.25606621001305857, 0.23201938318442111,
0.40424665641655444, 0.22941972622997378, 0.28466243651197881,
0.31260874877228728, 0.23461904013886839, 0.14298113249460123,
0.20667272787855998, 0.40489657065516621, 0.43674236834714564,
0.30156020671588624, 0.25086689610416402, 0.34315471798704295,
0.57712384388729954, 0.54397821771809651, 0.22876981199136201,
0.36135231666817402, 0.16702795932323872, 0.38149965806514058,
0.35680291699789124, 0.61936826939706802, 0.18327581528853432,
0.49783430677665702, 0.87673430788735041, 0.28856192194364977,
0.26386518087640048, 0.17807650137963971, 0.31325866301089911,
0.15792915998267318, 0.22162075536663192, 0.49263499286776241,
0.27166415173974234, 0.49523464982220977, 0.35875265971372677,
0.40164699946210708, 0.50953276307166995, 0.35745283123650307,
0.10918559208678641, 0.39839742826904795, 0.49003533591331516,
0.43999193954020471, 0.40489657065516621, 0.57322435845562858,
0.11893430566596376, 0.41724494118879091, 0.46663842332328948,
0.11763447718874012, 0.44129176801742842, 0.41269554151850812,
0.55892624520616851, 0.5160319054577881, 0.11698456295012828,
0.26581492359223591, 0.46793825180051313, 0.57322435845562858,
0.42634374052935636, 0.33600566136231291, 0.48028662233413782,
0.44844082464215845, 0.54917753162699112, 0.45493996702827666,
0.41464528423434355, 0.57192452997840493, 0.21707135569634914,
0.59532144256843056, 0.44584116768771109, 0.30935917757922815,
0.56997478726256945, 0.5186315624122354, 0.40619639913238986,
0.31000909181783998, 0.27881320836447243, 0.46923808027773678,
0.087088507973984389, 0.41399536999573178, 0.41789485542740268,
0.26841458054668321, 0.18392572952714614, 0.35550308852066764,
0.31585831996534636, 0.2047229851627245, 0.52123121936668271,
0.22162075536663192, 0.56737513030812214, 0.45104048159660576,
0.46013928093717121, 0.21447169874190186, 0.57387427269424041,
0.49068525015192699, 0.39449794283737705, 0.37175094448596324,
0.46663842332328948, 0.43804219682436929, 0.42439399781352094,
0.54787770314976747, 0.46273893789161857, 0.28206277955753151,
0.39254820012154157, 0.36005248819095037, 0.4659885090846777,
0.53877890380920201, 0.47053790875496049, 0.14233121825598941,
0.31780806268118184, 0.55502675977449756, 0.38929862892848244,
0.19887375701521809, 0.25216672458138761, 0.32495711930591192,
0.41464528423434355, 0.15467958878961408, 0.38734888621264701,
0.31260874877228728, 0.41594511271156726, 0.26321526663778866,
0.49653447829943342, 0.29636089280699168, 0.60182058495454882,
0.37175094448596324, 0.2209708411280201, 0.66746192305434304,
0.21447169874190186, 0.37565042991763414, 0.28531235075059064,
0.36005248819095037, 0.26386518087640048, 0.36915128753151588,
0.52318096208251819, 0.31650823420395824, 0.3444545464642666,
0.23981835404776297, 0.19822384277660626, 0.50173379220832803,
0.58102332931897049, 0.16052881693712048, 0.38084974382652875,
0.16637804508462689, 0.58037341508035867, 0.33860531831676022,
0.34640428918010208, 0.4445413392104875, 0.59142195713675971,
0.42049451238185004, 0.26126552392195318, 0.34575437494149031,
0.5036835349241634, 0.31130892029506357, 0.17937632985686339,
0.14233121825598941, 0.42439399781352094, 0.54267838924087286,
0.35680291699789124, 0.16702795932323872, 0.17742658714102791,
0.39449794283737705, 0.080589365587866155, 0.52708044751418903,
0.16702795932323872, 0.22746998351413833, 0.16767787356185054,
0.15207993183516677, 0.1748269301865806, 0.17807650137963971,
0.50173379220832803, 0.2567161242516704, 0.44519125344909932,
0.22811989775275016, 0.29441115009115615, 0.46338885213023034,
0.43089314019963915, 0.27751337988724878, 0.3633020593840095,
0.34185488950981935, 0.62326775482873908, 0.29766072128421528,
0.43674236834714564, 0.43284288291547462, 0.48288627928858507,
0.44649108192632297, 0.48873550743609151, 0.41269554151850812,
0.59467152832981873, 0.46273893789161857, 0.19822384277660626,
0.45818953822133579, 0.36395197362262133, 0.20927238483300728,
0.41269554151850812, 0.45883945245994756, 0.47963670809552594,
0.59532144256843056, 0.36395197362262133, 0.43739228258575741,
0.4984842210152689, 0.24631749643388121, 0.16507821660740324,
0.43544253986992193, 0.58557272898925317, 0.56607530183089849,
0.77729742937974122, 0.44519125344909932, 0.3769502583948578,
0.24956706762694034, 0.23591886861609201, 0.13453224739264752,
0.24111818252498665, 0.22032092688940827, 0.4659885090846777,
0.25736603849028222, 0.18067615833408701, 0.37240085872457501,
0.50758302035583436, 0.42959331172241549, 0.19042487191326438,
0.23786861133192752, 0.14168130401737761, 0.34055506103259564,
0.42114442662046181, 0.55047736010421477, 0.54202847500226115,
0.13128267619958842, 0.37760017263346962, 0.31390857724951088,
0.28336260803475521, 0.35550308852066764, 0.34250480374843117,
0.51928147665084723, 0.46338885213023034, 0.43999193954020471,
0.50238370644693975, 0.39644768555321253, 0.2209708411280201,
0.30545969214755719, 0.4659885090846777, 0.36005248819095037,
0.47378747994801962, 0.61286912701094987, 0.27946312260308426,
0.44324151073326384, 0.27621355141002513, 0.65836312371377748,
0.36005248819095037, 0.14753053216488399, 0.62261784059012715,
0.4809365365727496, 0.60507015614760795, 0.34770411765732573,
0.40164699946210708, 0.48743567895886786, 0.18717530072020527,
0.57322435845562858, 0.50758302035583436, 0.42634374052935636,
0.23786861133192752, 0.28076295108030791, 0.23006964046858561,
0.31910789115840549, 0.21707135569634914, 0.076039965917583385,
0.34380463222565477, 0.43089314019963915, 0.13843173282431848,
0.16572813084601506, 0.13713190434709482, 0.32755677626035917,
0.27946312260308426, 0.25606621001305857, 0.46923808027773678,
0.47053790875496049, 0.51278233426472897, 0.6037703276703843,
0.55827633096755669, 0.65251389556627115, 0.37305077296318684,
0.47378747994801962, 0.43544253986992193, 0.22876981199136201,
0.47833687961830229, 0.62846706873763369, 0.31130892029506357,
0.37305077296318684, 0.40099708522349531, 0.3620022309067859,
0.27816329412586055, 0.38799880045125884, 0.28141286531891968,
0.23526895437748024, 0.27101423750113057, 0.25411646729722309,
0.29701080704560351, 0.30286003519310989, 0.62846706873763369,
0.17027753051629782, 0.47768696537969052, 0.37305077296318684,
0.52968010446863645, 0.25021698186555219, 0.34250480374843117,
0.32170754811285279, 0.25151681034277584, 0.6037703276703843,
0.28011303684169608, 0.20537289940133632, 0.38084974382652875,
0.48873550743609151, 0.24501766795665758, 0.20342315668550084,
0.41724494118879091, 0.18522555800436979, 0.18327581528853432,
0.30935917757922815, 0.328206690498971, 0.49133516439053876,
0.62131801211290349, 0.33990514679398381, 0.38084974382652875,
0.31585831996534636, 0.33925523255537204, 0.26386518087640048,
0.4607891951757831, 0.74870120288082109, 0.22292058384385555,
0.52058130512807088, 0.31585831996534636, 0.11373499175706916,
0.53227976142308375, 0.41269554151850812, 0.42309416933629729,
0.14948027488071947, 0.46533859484606582, 0.64146535350987011,
0.48353619352719696, 0.45818953822133579, 0.41789485542740268,
0.23786861133192752, 0.40554648489377804, 0.47118782299357226,
0.27166415173974234, 0.40814614184822534, 0.59987084223871334,
0.21772126993496096, 0.10658593513233909, 0.23656878285470387,
0.20862247059439545, 0.32885660473758288, 0.33275609016925378,
0.30870926334061632, 0.10918559208678641, 0.49458473558359789,
0.47573722266385504, 0.50953276307166995, 0.53487941837753095,
0.34315471798704295, 0.31780806268118184, 0.40684631337100169,
0.09293773612149081, 0.27231406597835417, 0.30350994943172172,
0.33860531831676022, 0.18067615833408701, 0.3957977713146007,
0.25086689610416402, 0.17807650137963971, 0.33470583288508926,
0.39189828588292974, 0.47183773723218403, 0.24761732491110489,
0.35420326004344399, 0.17287718747074515, 0.19692401429938261,
0.33860531831676022, 0.26386518087640048, 0.19757392853799444,
0.59662127104565421, 0.45623979550550031, 0.60052075647732528,
0.32300737659007644, 0.47898679385691417, 0.10593602089372728,
0.2404682682863748, 0.31585831996534636, 0.077339794394807038,
0.46338885213023034, 0.20407307092411267, 0.59532144256843056,
0.20992229907161908, 0.36850137329290411, 0.2404682682863748,
0.60052075647732528, 0.18977495767465255, 0.33795540407814839,
0.26776466630807144, 0.51668181969639992, 0.2209708411280201,
0.12413361957485836, 0.54397821771809651, 0.45299022431244124,
0.52578061903696549, 0.37240085872457501, 0.41594511271156726,
0.26971440902390686, 0.13193259043820024, 0.20927238483300728,
0.21642144145773731, 0.49393482134498612, 0.35095368885038486,
0.39709759979182435, 0.19692401429938261, 0.28986175042087342,
0.55307701705866197, 0.54592796043393199, 0.16052881693712048,
0.31065900605645175, 0.42764356900658007, 0.26126552392195318,
0.28596226498920246, 0.45364013855105301, 0.49133516439053876,
0.77924717209557681, 0.43674236834714564, 0.3470542034187139,
0.1007367069848327, 0.38474922925819971, 0.40359674217794261,
0.44974065311938211, 0.20602281363994815, 0.51083259154889349,
0.42309416933629729, 0.21837118417357282, 0.30350994943172172,
0.66161269490683661, 0.52188113360529453, 0.6388656965554228,
0.3119588345336754, 0.42829348324519195, 0.15207993183516677,
0.44259159649465196, 0.48873550743609151, 0.53942881804781373,
0.33340600440786561, 0.38019982958791693, 0.45948936669855944,
0.35485317428205582, 0.46208902365300669, 0.43414271139269828,
0.47183773723218403, 0.47963670809552594, 0.13258250467681204,
0.10203653546205634, 0.42764356900658007, 0.25736603849028222,
0.21252195602606641, 0.39774751403043618, 0.44779091040354663,
0.46273893789161857, 0.33145626169203013, 0.26386518087640048,
0.58232315779619415, 0.33795540407814839, 0.32690686202174735,
0.4607891951757831, 0.27686346564863695, 0.50693310611722253,
0.23136946894580929, 0.15987890269850866, 0.28011303684169608,
0.46858816603912495, 0.24176809676359848, 0.27101423750113057,
0.21447169874190186, 0.53292967566169547, 0.52903019023002462,
0.47768696537969052, 0.31910789115840549, 0.38279948654236423,
0.2593157812061177, 0.47508730842524316, 0.28791200770503794,
0.44129176801742842, 0.22422041232107923, 0.20017358549244174,
0.35160360308899669, 0.53033001870724816, 0.40229691370071891,
0.46013928093717121, 0.14038147554015395, 0.30415986367033354,
0.17092744475490967, 0.51083259154889349, 0.22746998351413833,
0.15143001759655494, 0.51993139088945906, 0.19172470039048803,
0.48158645081136142, 0.1559794172668377, 0.49523464982220977,
0.12673327652930563, 0.43479262563131016, 0.31650823420395824,
0.36850137329290411, 0.19562418582215899, 0.53162984718447182,
0.24761732491110489, 0.13128267619958842, 0.39449794283737705,
0.17352710170935695, 0.47833687961830229, 0.54982744586560295,
0.50888284883305801, 0.34575437494149031, 0.33145626169203013,
0.51733173393501175, 0.41399536999573178, 0.19562418582215899,
0.26581492359223591, 0.4861358504816442, 0.25541629577444674,
0.42829348324519195, 0.43999193954020471, 0.45299022431244124,
0.41139571304128447, 0.26516500935362408, 0.63041681145346906,
0.30091029247727441, 0.44064185377881654, 0.3795499153493051,
0.10398627817789181, 0.35745283123650307, 0.46143910941439492,
0.14298113249460123, 0.35095368885038486, 0.058492281475064141,
0.41594511271156726, 0.42894339748380372, 0.20797255635578363,
0.33145626169203013, 0.44194168225604019, 0.43544253986992193,
0.39644768555321253, 0.084488851019537098, 0.3769502583948578,
0.32495711930591192, 0.36395197362262133, 0.31845797691979366,
0.35745283123650307, 0.42894339748380372, 0.33795540407814839,
0.30545969214755719, 0.49393482134498612, 0.38994854316709426,
0.42894339748380372, 0.17547684442519243, 0.33795540407814839,
0.40944597032544899, 0.2404682682863748, 0.11698456295012828,
0.090987993405655332, 0.27946312260308426, 0.11698456295012828,
0.46143910941439492, 0.37045111600873959, 0.071490566247300616,
0.3444545464642666, 0.37045111600873959, 0.37045111600873959,
0.33795540407814839, 0.47443739418663139, 0.40294682793933079,
0.33795540407814839, 0.19497427158354713, 0.40944597032544899,
0.090987993405655332, 0.48743567895886786, 0.44844082464215845,
0.18197598681131066, 0.42894339748380372, 0.18197598681131066,
0.272963980216966, 0.35095368885038486, 0.48743567895886786,
0.37045111600873959, 0.32495711930591192, 0.40944597032544899,
0.40294682793933079, 0.25346655305861127, 0.19497427158354713,
0.4809365365727496, 0.17547684442519243, 0.52643053327557732,
0.28596226498920246, 0.36395197362262133, 0.23396912590025656,
0.16247855965295596, 0.097487135791773566, 0.51343224850334079,
0.12348370533624653, 0.33795540407814839, 0.3444545464642666,
0.42244425509768546, 0.37045111600873959, 0.19497427158354713,
0.26646483783084773, 0.11048542056401005, 0.36395197362262133,
0.2404682682863748, 0.3769502583948578, 0.16247855965295596,
0.27946312260308426, 0.14948027488071947, 0.22746998351413833,
0.39644768555321253, 0.31845797691979366, 0.50693310611722253,
0.26646483783084773, 0.36395197362262133, 0.18197598681131066,
0.33145626169203013, 0.44194168225604019, 0.28596226498920246,
0.33795540407814839, 0.26646483783084773, 0.22746998351413833,
0.16247855965295596, 0.07798970863341885, 0.44844082464215845,
0.1884751291974289, 0.30545969214755719, 0.11698456295012828,
0.40294682793933079, 0.31845797691979366, 0.1689777020390742,
0.46143910941439492, 0.42894339748380372, 0.136481990108483,
0.33145626169203013, 0.21447169874190186, 0.33145626169203013,
0.24696741067249306, 0.27946312260308426, 0.17547684442519243,
0.32495711930591192, 0.46793825180051313, 0.3769502583948578,
0.37045111600873959, 0.07798970863341885, 0.27946312260308426,
0.35745283123650307, 0.39644768555321253, 0.2209708411280201,
0.1559794172668377, 0.14948027488071947, 0.1559794172668377,
0.33795540407814839, 0.44194168225604019, 0.27946312260308426,
0.3119588345336754, 0.10398627817789181, 0.36395197362262133,
0.49393482134498612, 0.20797255635578363, 0.21447169874190186,
0.24696741067249306, 0.44844082464215845, 0.1559794172668377,
0.11698456295012828, 0.18197598681131066, 0.46143910941439492,
0.14948027488071947, 0.31845797691979366, 0.40294682793933079,
0.30545969214755719, 0.090987993405655332, 0.3119588345336754,
0.23396912590025656, 0.2209708411280201, 0.32495711930591192,
0.30545969214755719, 0.25996569544472953, 0.28596226498920246,
0.39644768555321253, 0.29246140737532073, 0.20147341396966539,
0.14298113249460123, 0.44844082464215845, 0.20147341396966539,
0.42894339748380372, 0.32495711930591192, 0.2404682682863748,
0.136481990108483, 0.272963980216966, 0.29246140737532073, 0.28596226498920246,
0.37045111600873959, 0.40944597032544899, 0.12348370533624653,
0.2209708411280201, 0.18197598681131066, 0.272963980216966, 0.40944597032544899,
0.18197598681131066, 0.1559794172668377, 0.33145626169203013,
0.43544253986992193, 0.2209708411280201, 0.37045111600873959,
0.1884751291974289, 0.1689777020390742, 0.14298113249460123,
0.33795540407814839, 0.35095368885038486, 0.2404682682863748,
0.1884751291974289, 0.42894339748380372, 0.35745283123650307,
0.272963980216966, 0.11698456295012828, 0.33795540407814839,
0.25346655305861127, 0.25996569544472953, 0.46143910941439492,
0.097487135791773566, 0.097487135791773566, 0.2404682682863748,
0.272963980216966, 0.44844082464215845, 0.23396912590025656,
0.28596226498920246, 0.31845797691979366, 0.11698456295012828,
0.20147341396966539, 0.136481990108483, 0.45493996702827666,
0.3769502583948578, 0.32495711930591192, 0.07798970863341885,
0.2209708411280201, 0.20797255635578363, 0.46143910941439492,
0.25346655305861127, 0.2404682682863748, 0.24696741067249306,
0.24696741067249306, 0.38994854316709426, 0.43544253986992193,
0.1689777020390742, 0.21447169874190186, 0.35095368885038486,
0.2209708411280201, 0.40944597032544899, 0.1689777020390742,
0.25996569544472953, 0.3119588345336754, 0.136481990108483, 0.38344940078097606,
0.1689777020390742, 0.33795540407814839, 0.12348370533624653,
0.33145626169203013, 0.21447169874190186, 0.28596226498920246,
0.1689777020390742, 0.136481990108483, 0.20147341396966539, 0.3444545464642666,
0.07798970863341885, 0.3769502583948578, 0.11048542056401005,
0.37045111600873959, 0.46143910941439492, 0.11048542056401005,
0.40294682793933079, 0.33145626169203013, 0.097487135791773566,
0.40294682793933079, 0.35745283123650307, 0.42244425509768546,
0.38344940078097606, 0.51993139088945906, 0.26646483783084773,
0.44844082464215845, 0.3119588345336754, 0.39644768555321253,
0.44844082464215845, 0.27946312260308426, 0.16247855965295596,
0.38344940078097606, 0.3444545464642666, 0.45493996702827666,
0.24696741067249306, 0.21447169874190186, 0.3769502583948578,
0.084488851019537098, 0.11048542056401005, 0.47443739418663139,
0.36395197362262133, 0.33145626169203013, 0.27946312260308426,
0.35745283123650307, 0.50693310611722253, 0.10398627817789181,
0.46793825180051313, 0.32495711930591192, 0.3769502583948578,
0.30545969214755719, 0.1689777020390742, 0.1884751291974289,
0.47443739418663139, 0.25346655305861127, 0.14298113249460123,
0.40944597032544899, 0.33795540407814839, 0.071490566247300616,
0.26646483783084773, 0.35745283123650307, 0.44844082464215845,
0.4809365365727496, 0.3444545464642666, 0.29896054976143893,
0.46793825180051313, 0.24696741067249306, 0.38344940078097606,
0.37045111600873959, 0.38344940078097606, 0.46793825180051313,
0.41594511271156726, 0.32495711930591192, 0.31845797691979366,
0.28596226498920246, 0.40944597032544899, 0.50043396373110438,
0.097487135791773566, 0.47443739418663139, 0.19497427158354713,
0.30545969214755719, 0.3444545464642666, 0.37045111600873959,
0.43544253986992193, 0.22746998351413833, 0.12348370533624653,
0.46143910941439492, 0.25346655305861127, 0.46793825180051313,
0.50693310611722253, 0.2209708411280201, 0.44194168225604019,
0.25346655305861127, 0.42894339748380372, 0.136481990108483,
0.18197598681131066, 0.44844082464215845, 0.30545969214755719,
0.47443739418663139, 0.136481990108483, 0.33145626169203013,
0.22746998351413833, 0.39644768555321253, 0.43544253986992193,
0.44194168225604019, 0.35745283123650307, 0.35095368885038486,
0.50043396373110438, 0.22746998351413833, 0.4809365365727496,
0.3769502583948578, 0.40944597032544899, 0.50693310611722253,
0.46143910941439492, 0.29246140737532073, 0.42244425509768546,
0.39644768555321253, 0.1884751291974289, 0.29246140737532073,
0.1559794172668377, 0.3769502583948578, 0.29246140737532073,
0.35745283123650307, 0.41594511271156726, 0.39644768555321253,
0.33145626169203013, 0.44844082464215845, 0.44194168225604019,
0.33795540407814839, 0.4809365365727496, 0.29246140737532073,
0.32495711930591192, 0.2404682682863748, 0.29246140737532073,
0.20797255635578363, 0.29246140737532073, 0.33145626169203013,
0.2404682682863748, 0.38994854316709426, 0.18197598681131066,
0.272963980216966, 0.18197598681131066, 0.40294682793933079,
0.43544253986992193, 0.2209708411280201, 0.29246140737532073,
0.12348370533624653, 0.26646483783084773, 0.22746998351413833,
0.42244425509768546, 0.18197598681131066, 0.4809365365727496,
0.39644768555321253, 0.28596226498920246, 0.1884751291974289,
0.42244425509768546, 0.2209708411280201, 0.41594511271156726,
0.38994854316709426, 0.33795540407814839, 0.14298113249460123,
0.44844082464215845, 0.272963980216966, 0.46793825180051313,
0.49393482134498612, 0.18197598681131066, 0.25346655305861127,
0.36395197362262133, 0.28596226498920246, 0.1689777020390742,
0.29896054976143893, 0.14298113249460123, 0.44194168225604019,
0.29246140737532073, 0.1884751291974289, 0.2209708411280201,
0.22746998351413833, 0.33145626169203013, 0.27946312260308426,
0.28596226498920246, 0.33145626169203013, 0.30545969214755719,
0.26646483783084773, 0.2404682682863748, 0.35745283123650307,
0.37045111600873959, 0.27946312260308426, 0.35745283123650307,
0.38994854316709426, 0.25346655305861127, 0.23396912590025656,
0.43544253986992193, 0.36395197362262133, 0.24696741067249306,
0.24696741067249306, 0.3119588345336754, 0.1689777020390742,
0.28596226498920246, 0.38994854316709426, 0.30545969214755719,
0.33145626169203013, 0.19497427158354713, 0.097487135791773566,
0.136481990108483, 0.32495711930591192, 0.12348370533624653,
0.25996569544472953, 0.35095368885038486, 0.44844082464215845,
0.29896054976143893, 0.33145626169203013, 0.20147341396966539,
0.46793825180051313, 0.33795540407814839, 0.36395197362262133,
0.40294682793933079, 0.19497427158354713, 0.50043396373110438,
0.40294682793933079, 0.44844082464215845, 0.2209708411280201,
0.25346655305861127, 0.3119588345336754, 0.27946312260308426,
0.41594511271156726, 0.38344940078097606, 0.12998284772236476,
0.40294682793933079, 0.19497427158354713, 0.49393482134498612,
0.32495711930591192, 0.45493996702827666, 0.17547684442519243,
0.33145626169203013, 0.40944597032544899, 0.48743567895886786,
0.45493996702827666, 0.2404682682863748, 0.3119588345336754,
0.25346655305861127, 0.1884751291974289, 0.11048542056401005,
0.3119588345336754, 0.3444545464642666, 0.23396912590025656,
0.272963980216966, 0.19497427158354713, 0.29246140737532073,
0.31845797691979366, 0.29246140737532073, 0.41659502695017903,
0.44324151073326384, 0.45299022431244124, 0.40944597032544899,
0.62651732602179822, 0.47118782299357226, 0.47313756570940774,
0.38214957230375241, 0.52773036175280097, 0.45493996702827666,
0.50173379220832803, 0.63041681145346906, 0.44519125344909932,
0.42569382629074459, 0.51668181969639992, 0.57127461573979321,
0.53033001870724816, 0.55567667401310938, 0.35875265971372677,
0.52903019023002462, 0.33730548983953657, 0.50238370644693975,
0.51343224850334079, 0.43869211106298106, 0.61286912701094987,
0.48418610776580873, 0.6187183551584563, 0.65251389556627115,
0.58167324355758232, 0.53162984718447182, 0.53292967566169547,
0.54267838924087286, 0.53747907533197825, 0.44714099616493475,
0.5361792468547546, 0.54592796043393199, 0.42179434085907369,
0.55437684553588573, 0.40944597032544899, 0.31715814844257001,
0.36525180209984498, 0.44519125344909932, 0.48028662233413782,
0.45688970974411214, 0.41269554151850812, 0.42634374052935636,
0.55892624520616851, 0.41074579880267265, 0.33730548983953657,
0.47118782299357226, 0.48548593624303238, 0.41009588456406082,
0.33340600440786561, 0.40099708522349531, 0.4809365365727496,
0.45948936669855944, 0.65251389556627115, 0.64536483894154106,
0.26646483783084773, 0.70190737770076972, 0.29051166465948525,
0.41789485542740268, 0.64601475318015289, 0.58557272898925317,
0.59402161409120702, 0.37175094448596324, 0.35875265971372677,
0.43349279715408651, 0.36460188786123315, 0.64796449589598837,
0.52253104784390636, 0.30935917757922815, 0.55177718858143843,
0.51993139088945906, 0.66226260914544854, 0.23981835404776297,
0.34380463222565477, 0.3795499153493051, 0.41074579880267265,
0.66421235186128391, 0.40099708522349531, 0.63431629688514002,
0.67266123696323765, 0.5959713568070425, 0.5010838779697161,
0.3633020593840095, 0.50043396373110438, 0.45299022431244124,
0.54592796043393199, 0.41334545575711995, 0.59987084223871334,
0.52513070479835366, 0.35160360308899669, 0.57582401541007588,
0.46273893789161857, 0.35745283123650307, 0.18002624409547519,
0.52448079055974184, 0.48158645081136142, 0.39644768555321253,
0.52838027599141268, 0.46858816603912495, 0.47898679385691417,
0.4809365365727496, 0.58557272898925317, 0.46923808027773678,
0.61091938429511439, 0.39384802859876522, 0.61416895548817352,
0.45623979550550031, 0.464688680607454, 0.53422950413891923,
0.51538199121917627, 0.34965386037316121, 0.40554648489377804,
0.66356243762267209, 0.24761732491110489, 0.37825008687208145,
0.44519125344909932, 0.48873550743609151, 0.58557272898925317,
0.50043396373110438, 0.49913413525388067, 0.56282573063783936,
0.51538199121917627, 0.43934202530159283, 0.40359674217794261,
0.44844082464215845, 0.37045111600873959, 0.52513070479835366,
0.49003533591331516, 0.66681200881573122, 0.47768696537969052,
0.53747907533197825, 0.51278233426472897, 0.3957977713146007,
0.38929862892848244, 0.55372693129727391, 0.52448079055974184,
0.28661217922781429, 0.59077204289814789, 0.56412555911506301,
0.50498336340138716, 0.58037341508035867, 0.71815523366606526,
0.58752247170508876, 0.5485276173883793, 0.54007873228642556,
0.40099708522349531, 0.43869211106298106, 0.54267838924087286,
0.35030377461177303, 0.44909073888077022, 0.33015643321480648,
0.33795540407814839, 0.51408216274195262, 0.39774751403043618,
0.51798164817362358, 0.49133516439053876, 0.46143910941439492,
0.56542538759228667, 0.41789485542740268, 0.40294682793933079,
0.53942881804781373, 0.59727118528426615, 0.43349279715408651,
0.41334545575711995, 0.41009588456406082, 0.62066809787429178,
0.65316380980488298, 0.52188113360529453, 0.38214957230375241,
0.41269554151850812, 0.54917753162699112, 0.54592796043393199,
0.41724494118879091, 0.34120497527120752, 0.48353619352719696,
0.51083259154889349, 0.32625694778313558, 0.51798164817362358,
0.45039056735799388, 0.5160319054577881, 0.44324151073326384,
0.37630034415624597, 0.44584116768771109, 0.40034717098488348,
0.43804219682436929, 0.46013928093717121, 0.45364013855105301,
0.48678576472025609, 0.5959713568070425, 0.48158645081136142,
0.4659885090846777, 0.49393482134498612, 0.39774751403043618,
0.44389142497187561, 0.43609245410853376, 0.48743567895886786,
0.46013928093717121, 0.49588456406082154, 0.43089314019963915,
0.40749622760961357, 0.44259159649465196, 0.60247049919316065,
0.38539914349681148, 0.43349279715408651, 0.58752247170508876,
0.43414271139269828, 0.35485317428205582, 0.32560703354452375,
0.59792109952287786, 0.45493996702827666, 0.52578061903696549,
0.35160360308899669, 0.64016552503264645, 0.51018267731028166,
0.47183773723218403, 0.48873550743609151, 0.42439399781352094,
0.42179434085907369, 0.39189828588292974, 0.65186398132765921,
0.46988799451634861, 0.23981835404776297, 0.4445413392104875,
0.21512161298051369, 0.51408216274195262, 0.54592796043393199,
0.41399536999573178, 0.64341509622570559, 0.49783430677665702,
0.5836229862734178, 0.42829348324519195, 0.37305077296318684,
0.49263499286776241, 0.49978404949249255, 0.46273893789161857,
0.42504391205213282, 0.29506106432976797, 0.63366638264652819,
0.47833687961830229, 0.40684631337100169, 0.51538199121917627,
0.53033001870724816, 0.48288627928858507, 0.48808559319747963,
0.62001818363567995, 0.23071955470719746, 0.45883945245994756,
0.48353619352719696, 0.6063699846248316, 0.61156929853372621,
0.76429914460750481, 0.54527804619532017, 0.4984842210152689,
0.53942881804781373, 0.37240085872457501, 0.54722778891115564,
0.45493996702827666, 0.59727118528426615, 0.58557272898925317,
0.37370068720179866, 0.55307701705866197, 0.59727118528426615,
0.5309799329458601, 0.56477547335367495, 0.51538199121917627,
0.54722778891115564, 0.46338885213023034, 0.70775660584827615,
0.52643053327557732, 0.36590171633845681, 0.48678576472025609,
0.47443739418663139, 0.37370068720179866, 0.44194168225604019,
0.42374408357490911, 0.69020892140575685, 0.35810274547511495,
0.62456758330596263, 0.44389142497187561, 0.3769502583948578,
0.5036835349241634, 0.71165609127994711, 0.48353619352719696,
0.45753962398272402, 0.78119691481141218, 0.52903019023002462,
0.42569382629074459, 0.34965386037316121, 0.33990514679398381,
0.26646483783084773, 0.50628319187861082, 0.41464528423434355,
0.40424665641655444, 0.59142195713675971, 0.5361792468547546,
0.56087598792200388, 0.41529519847295543, 0.28986175042087342,
0.48808559319747963, 0.44844082464215845, 0.48288627928858507,
0.5010838779697161, 0.37630034415624597, 0.62586741178318628,
0.52123121936668271, 0.48158645081136142, 0.28726209346642612,
0.51018267731028166, 0.53292967566169547, 0.41009588456406082,
0.63756586807819915, 0.52188113360529453, 0.54397821771809651,
0.45364013855105301, 0.46793825180051313, 0.34770411765732573,
0.51993139088945906, 0.50238370644693975, 0.31650823420395824,
0.41724494118879091, 0.59857101376148969, 0.50758302035583436,
0.55047736010421477, 0.53162984718447182, 0.54202847500226115,
0.6037703276703843, 0.26581492359223591, 0.24436775371804575,
0.50498336340138716, 0.21707135569634914, 0.42829348324519195,
0.40619639913238986, 0.48808559319747963, 0.41009588456406082,
0.30286003519310989, 0.40034717098488348, 0.54397821771809651,
0.32755677626035917, 0.52188113360529453, 0.35355334580483216,
0.44714099616493475, 0.47508730842524316, 0.48938542167470328,
0.58492281475064145, 0.50953276307166995, 0.3769502583948578,
0.41789485542740268, 0.43024322596102738, 0.51538199121917627,
0.46273893789161857, 0.62846706873763369, 0.57517410117146406,
0.63366638264652819, 0.53942881804781373, 0.68630943597408589,
0.35290343156622028, 0.64796449589598837, 0.46338885213023034,
0.51018267731028166, 0.48938542167470328, 0.69085883564436867,
0.16832778780046237, 0.63561612536236367, 0.50498336340138716,
0.50758302035583436, 0.44974065311938211, 0.41984459814323816,
0.58037341508035867, 0.5485276173883793, 0.67981029358796763,
0.43609245410853376, 0.37435060144041055, 0.86633568006956119,
0.38149965806514058, 0.42829348324519195, 0.38409931501958788,
0.25086689610416402, 0.60442024190899613, 0.24696741067249306,
0.41399536999573178, 0.46338885213023034, 0.39969725674627166,
0.50888284883305801, 0.57517410117146406, 0.47573722266385504,
0.41594511271156726, 0.50498336340138716, 0.42764356900658007,
0.67591080815629678, 0.42829348324519195, 0.3145584914881227,
0.41984459814323816, 0.39189828588292974, 0.54462813195670834,
0.58167324355758232, 0.59077204289814789, 0.28856192194364977,
0.39319811436015339, 0.71555557671161796, 0.36785145905429228,
0.31845797691979366, 0.40879605608683717, 0.33210617593064196,
0.45493996702827666, 0.47898679385691417, 0.56607530183089849,
0.63106672569208089, 0.59532144256843056, 0.44584116768771109,
0.50303362068555169, 0.54137856076364921, 0.6889090929285332,
0.51993139088945906, 0.50238370644693975, 0.50693310611722253,
0.50628319187861082, 0.41854476966601456, 0.61936826939706802,
0.45623979550550031, 0.66941166577017852, 0.50043396373110438,
0.36525180209984498, 0.35355334580483216, 0.39319811436015339,
0.30545969214755719, 0.51213242002611714, 0.48743567895886786,
0.53682916109336642, 0.6362660396009755, 0.5485276173883793,
0.42439399781352094, 0.45688970974411214, 0.49913413525388067,
0.42894339748380372, 0.53942881804781373, 0.47703705114107869,
0.47638713690246681, 0.3620022309067859, 0.62001818363567995,
0.5186315624122354, 0.52253104784390636, 0.39514785707598887,
0.43414271139269828, 0.49783430677665702, 0.4809365365727496,
0.50303362068555169, 0.61351904124956169, 0.28726209346642612,
0.41789485542740268, 0.60052075647732528, 0.19237461462909985,
0.66551218033850756, 0.53292967566169547, 0.35875265971372677,
0.30610960638616902, 0.58102332931897049, 0.44389142497187561,
0.24696741067249306, 0.51213242002611714, 0.35810274547511495,
0.46858816603912495, 0.49328490710637429, 0.62976689721485735,
0.55957615944478023, 0.47768696537969052, 0.51993139088945906,
0.53552933261614288, 0.48938542167470328, 0.56087598792200388,
0.57322435845562858, 0.69475832107603963, 0.45169039583521753,
0.31260874877228728, 0.45169039583521753, 0.61936826939706802,
0.59402161409120702, 0.54917753162699112, 0.47573722266385504,
0.33145626169203013, 0.56997478726256945, 0.50173379220832803,
0.43479262563131016, 0.55502675977449756, 0.56282573063783936,
0.49263499286776241, 0.45883945245994756, 0.50693310611722253,
0.38474922925819971, 0.48028662233413782, 0.48548593624303238,
0.6889090929285332, 0.56412555911506301, 0.43934202530159283,
0.53357958990030729, 0.30610960638616902, 0.51928147665084723,
0.57712384388729954, 0.45948936669855944, 0.31975780539701731,
0.33990514679398381, 0.32625694778313558, 0.51993139088945906,
0.50238370644693975, 0.37110103024735142, 0.40164699946210708,
0.39774751403043618, 0.32105763387424097, 0.4809365365727496,
0.40424665641655444, 0.32170754811285279, 0.27426380869418965,
0.3470542034187139, 0.29051166465948525, 0.35875265971372677,
0.24371783947943393, 0.22292058384385555, 0.28596226498920246,
0.3470542034187139, 0.54917753162699112, 0.39254820012154157,
0.47443739418663139, 0.45364013855105301, 0.25346655305861127,
0.37500051567902237, 0.31000909181783998, 0.55372693129727391,
0.5238308763211299, 0.2755636371714133, 0.4822363650499733, 0.57972350084174684,
0.35420326004344399, 0.33210617593064196, 0.47443739418663139,
0.31130892029506357, 0.37760017263346962, 0.25346655305861127,
0.41529519847295543, 0.31910789115840549, 0.25021698186555219,
0.54527804619532017, 0.4848360220044205, 0.29636089280699168,
0.41529519847295543, 0.50693310611722253, 0.57062470150118128,
0.51018267731028166, 0.41269554151850812, 0.42894339748380372,
0.52513070479835366, 0.6063699846248316, 0.49328490710637429,
0.26191543816056495, 0.43024322596102738, 0.33210617593064196,
0.37370068720179866, 0.35940257395233854, 0.42894339748380372,
0.52838027599141268, 0.33990514679398381, 0.64536483894154106,
0.35810274547511495, 0.33275609016925378, 0.40619639913238986,
0.63821578231681098, 0.38409931501958788, 0.1884751291974289,
0.53552933261614288, 0.69670806379187511, 0.32365729082868822,
0.33665557560092474, 0.3308063474534183, 0.3769502583948578,
0.4607891951757831, 0.50173379220832803, 0.5686749587853458,
0.41854476966601456, 0.47638713690246681, 0.42114442662046181,
0.58557272898925317, 0.48548593624303238, 0.44064185377881654,
0.21967101265079642, 0.60831972734066708, 0.25476638153583497,
0.44909073888077022, 0.47638713690246681, 0.44649108192632297,
0.49523464982220977, 0.35745283123650307, 0.32625694778313558,
0.49198507862915064, 0.2918114931367089, 0.7915955426292014,
0.44129176801742842, 0.62586741178318628, 0.37565042991763414,
0.34250480374843117, 0.27426380869418965, 0.41529519847295543,
0.52903019023002462, 0.52968010446863645, 0.5010838779697161,
0.4120456272798963, 0.33405591864647743, 0.19432435734493531,
0.38669897197403519, 0.31650823420395824, 0.48288627928858507,
0.39254820012154157, 0.44324151073326384, 0.49263499286776241,
0.46988799451634861, 0.34510446070287842, 0.12153396262041105,
0.37370068720179866, 0.35485317428205582, 0.21252195602606641,
0.31325866301089911, 0.29311132161393255, 0.47508730842524316,
0.32365729082868822, 0.26776466630807144, 0.13583207586987117,
0.42634374052935636, 0.21967101265079642, 0.22032092688940827,
0.3769502583948578, 0.44519125344909932, 0.30221012095449806,
0.2755636371714133, 0.30870926334061632, 0.33145626169203013,
0.39839742826904795, 0.43414271139269828, 0.39319811436015339,
0.51018267731028166, 0.39969725674627166, 0.23851852557053935,
0.85268748105871273, 0.4861358504816442, 0.34575437494149031,
0.51408216274195262, 0.41724494118879091, 0.36005248819095037,
0.12738319076791749, 0.53227976142308375, 0.43804219682436929,
0.21317187026467818, 0.49523464982220977, 0.52513070479835366,
0.40944597032544899, 0.38734888621264701, 0.44974065311938211,
0.29831063552282711, 0.4607891951757831, 0.36395197362262133,
0.29441115009115615, 0.43609245410853376, 0.39644768555321253,
0.34185488950981935, 0.31715814844257001, 0.57582401541007588,
0.46663842332328948, 0.26646483783084773, 0.50303362068555169,
0.31715814844257001, 0.33275609016925378, 0.36720154481568046,
0.54332830347948469, 0.58947221442092423, 0.52513070479835366,
0.2404682682863748, 0.26256535239917683, 0.66681200881573122,
0.39189828588292974, 0.40294682793933079, 0.42049451238185004,
0.23786861133192752, 0.32170754811285279, 0.2593157812061177,
0.54592796043393199, 0.48873550743609151, 0.48158645081136142,
0.31065900605645175, 0.44584116768771109, 0.16052881693712048,
0.52513070479835366, 0.37370068720179866, 0.34315471798704295,
0.38409931501958788, 0.36460188786123315, 0.55372693129727391,
0.23981835404776297, 0.4120456272798963, 0.47898679385691417,
0.45429005278966489, 0.35485317428205582, 0.48353619352719696,
0.41009588456406082, 0.67071149424740217, 0.29311132161393255,
0.58752247170508876, 0.41269554151850812, 0.42829348324519195,
0.41269554151850812, 0.41919468390462633, 0.44259159649465196,
0.29571097856837986, 0.27816329412586055, 0.47898679385691417,
0.49458473558359789, 0.49523464982220977, 0.49328490710637429,
0.25736603849028222, 0.56737513030812214, 0.46143910941439492,
0.56217581639922765, 0.31650823420395824, 0.76104957341444568,
0.29636089280699168, 0.42049451238185004, 0.45493996702827666,
0.46273893789161857, 0.27881320836447243, 0.46273893789161857,
0.40359674217794261, 0.31780806268118184, 0.22876981199136201,
0.4984842210152689, 0.62326775482873908, 0.67851046511074409,
0.21447169874190186, 0.21252195602606641, 0.56997478726256945,
0.44779091040354663, 0.39124837164431797, 0.31715814844257001,
0.51343224850334079, 0.47898679385691417, 0.56802504454673408,
0.51928147665084723, 0.5888223001823123, 0.44194168225604019,
0.35810274547511495, 0.59987084223871334, 0.60312041343177247,
0.464688680607454, 0.33275609016925378, 0.25281663881999944,
0.5238308763211299, 0.49393482134498612, 0.52578061903696549,
0.41464528423434355, 0.51343224850334079, 0.44129176801742842,
0.18392572952714614, 0.42309416933629729, 0.67266123696323765,
0.52838027599141268, 0.17872641561825153, 0.54007873228642556,
0.31390857724951088, 0.4120456272798963, 0.45234031007382935,
0.40359674217794261, 0.40619639913238986, 0.29116157889809707,
0.51083259154889349, 0.25996569544472953, 0.46663842332328948,
0.41334545575711995, 0.14818044640349584, 0.51018267731028166,
0.38669897197403519, 0.33990514679398381, 0.34315471798704295,
0.38409931501958788, 0.39839742826904795, 0.44064185377881654,
0.49523464982220977, 0.36265214514539768, 0.27751337988724878,
0.42569382629074459, 0.1737220759809405, 0.20894742771370134,
0.23734867994103809, 0.30214512953063688, 0.41100576449811738,
0.36193723948292467, 0.29733576416490937, 0.22967969192541857,
0.34692422057099154, 0.45682471832025101, 0.19529922870285304,
0.24768231633496604, 0.10535109807897665, 0.31364861155406615,
0.17612675866380426, 0.12062408268635449, 0.4437614421241533,
0.48470603915669819, 0.38448926356275492, 0.22155576394277077,
0.24586255646685293, 0.50998770303869811, 0.19406439164949058,
0.20277324244688902, 0.24982703332238507, 0.48873550743609151,
0.46670341474715071, 0.24287295096923853, 0.17684166432627726,
0.16163367114276059, 0.18275588389764486, 0.36635665630548508,
0.14772550643646756, 0.40795116757664185, 0.2948010986343233,
0.27686346564863695, 0.48626583332936651, 0.31748310556187592,
0.16338843958701252, 0.25665113282780921, 0.30383490655102763,
0.29207145883215363, 0.20927238483300728, 0.20654274503083761,
0.41873974393759811, 0.34159492381437462, 0.30883924618833869,
0.21713634712021032, 0.40106207664735649, 0.51635686257709401,
0.18061116691022583, 0.5862226432278651, 0.56633526752634322,
0.18711030929634406, 0.50777799462741791, 0.32222747950374225,
0.28037300253714081, 0.50582825191158243, 0.37636533558010715,
0.23585387719223086, 0.3554380970968064, 0.39833243684518682,
0.24339288236012804, 0.097227170096328849, 0.28596226498920246,
0.2809579253518914, 0.34321970941090418, 0.21297689599309469,
0.41717994976492967, 0.15526451160436472, 0.44499627917751577,
0.30493976075666773, 0.33984015537012269, 0.3134536372824826,
0.43076315735191684, 0.48626583332936651, 0.38669897197403519,
0.36687658769637455, 0.2695844261761845, 0.29057665608334643,
0.43687235119486795, 0.43921204245387052, 0.40385670787338734,
0.48737068753500662, 0.13550711875056529, 0.28115289962347495,
0.47976669094324831, 0.18204097823517185, 0.46514362057448227,
0.18737027499178879, 0.32846665619441573, 0.44948068742393732,
0.2482022477258555, 0.52656051612329957, 0.49913413525388067,
0.49568958978923799, 0.24826723914971671, 0.5634756448764513,
0.22746998351413833, 0.23058957185947507, 0.26360521518095575,
0.20758260781261653, 0.29493108148204566, 0.14057644981173748,
0.45305521573630231, 0.30480977790894537, 0.31995277966860086,
0.20290322529461138, 0.18477061803734152, 0.3258020078161073,
0.22740499209027717, 0.27822828554972179, 0.14239620967985059,
0.36317207653628714, 0.37103603882349023, 0.48958039594628688,
0.12744818219177864, 0.33847533546903785, 0.49328490710637429,
0.23851852557053935, 0.28940681045384514, 0.26802463200351617,
0.27939813117922307, 0.55580665686083164, 0.17677667290241608,
0.3326910987453926, 0.6078647873736388, 0.20205833678441601,
0.48717571326342307, 0.38039480385950047, 0.21291190456923348,
0.16293349961998424, 0.13212756470978376, 0.18574548939525923,
0.099696844203053775, 0.20114845685035945, 0.20446301946727977,
0.30123524959658032, 0.50225372359921749, 0.28947180187770633,
0.39306813151243103, 0.4041816649926932, 0.36011747961481155,
0.19061984618484792, 0.38201958945603004, 0.2888218876390945,
0.379159966806138, 0.23227934887986584, 0.45617480408163913,
0.45156041298749522, 0.46592351766081647, 0.20829751347508951,
0.11120032622648304, 0.1944543401926577, 0.31247876592456486,
0.3371755069918142, 0.46579353481309416, 0.3065645463531973,
0.37831507829594263, 0.14740054931716165, 0.20199334536055483,
0.50862288313761339, 0.13121768477572723, 0.30519972645211246,
0.28401252227336704, 0.33789041265428721, 0.16780785640957291,
0.1944543401926577, 0.16247855965295596, 0.51278233426472897,
0.32859663904213815, 0.21089717042953685, 0.38429428929117143,
0.21531658725209724, 0.15253487180219505, 0.26159048104125909,
0.35121365454582959, 0.48821557604520205, 0.37279080726774211,
0.51135252293978306, 0.38156464948900176, 0.26490504365817935,
0.41094077307425619, 0.40099708522349531, 0.15656434008158834,
0.43869211106298106, 0.42523888632371637, 0.5175267082065953,
0.27224907455449299, 0.35621799418314065, 0.52201111645301679,
0.47593219693543859, 0.36999617604171131, 0.456109812657778,
0.30799435767814332, 0.4745673770343537, 0.69846283223612704,
0.37292079011546453, 0.44889576460918668, 0.33724049841567538,
0.46442871491200927, 0.14044646696401511, 0.48769564465431264,
0.15480957163733644, 0.44064185377881654, 0.52123121936668271,
0.20927238483300728, 0.18535554085209216, 0.39449794283737705,
0.45266526719313532, 0.29161651886512535, 0.53169483860833311,
0.28771703343345439, 0.39638269412935134, 0.40086710237577294,
0.60916461585086246, 0.2077125906603389, 0.37194591875754673,
0.19113977757573739, 0.56178586785606044, 0.24033828543865243,
0.58778243740053349, 0.4017769823098295, 0.24462771941349049,
0.2190860898360458, 0.49913413525388067, 0.56399557626734076,
0.42497892062827158, 0.21837118417357282, 0.19939368840610755,
0.43843214536753627, 0.35686790842175242, 0.3065645463531973,
0.24560259077140822, 0.47138279726515581, 0.21193703321131574,
0.27634353425774749, 0.27783833700655469, 0.44740096186037953,
0.31800303695276538, 0.3939130200226264, 0.15526451160436472,
0.52864024168685753, 0.078704614295891859, 0.38227955515147477,
0.46423374064042577, 0.32931154470461116, 0.40665133909941814,
0.38864871468987061, 0.45149542156363398, 0.31735312271415356,
0.41282552436623049, 0.097422144367912383, 0.22363548950632856,
0.29337128730937728, 0.1523398975306115, 0.24872217911674499,
0.34685922914713035, 0.24033828543865243, 0.42764356900658007,
0.25951075547770125, 0.51824161386906831, 0.55353195702569036,
0.40626139055625105, 0.39657766840093489, 0.31501343145515098,
0.31501343145515098, 0.22727500924255478, 0.40151701661438477,
0.46520861199834346, 0.23403411732411775, 0.33613564421003528,
0.43498759990289371, 0.50166880078446674, 0.2652949922013465,
0.44870079033760318, 0.4215343751636289, 0.17398204167638523,
0.46761329468120727, 0.40294682793933079, 0.55060734295193714,
0.30519972645211246, 0.41737492403651322, 0.54670785752026618,
0.55314200848252326, 0.43862711963911988, 0.44720598758879598,
0.52331094493024055, 0.20238329390372195, 0.41769988115581913,
0.16065879978484285, 0.40463660495972148, 0.39696761694410199,
0.30701948632022558, 0.27471874866121793, 0.12829307070197402,
0.4615041008382561, 0.23598386003995322, 0.50465840628208125,
0.41477526708206597, 0.20348814810936203, 0.29194147598443126,
0.45208034437838468, 0.36661662200092976, 0.554116879840441,
0.4861358504816442, 0.62274782343784951, 0.23455404871500724,
0.50439844058663641, 0.19016490621781965, 0.3455594006699067,
0.35069372315494013, 0.17144737614579911, 0.41224060155147985,
0.27562862859527443, 0.34913392898227175, 0.5085578917137521,
0.18028620979091992, 0.53260471854238967, 0.38637401485472928,
0.47820689677057993, 0.26263034382303796, 0.29356626158096083,
0.59168192283220444, 0.3752604813744671, 0.37461056713585522,
0.59194188852764906, 0.26750470061262666, 0.23780361990806637,
0.44239662222306841, 0.29148653601740299, 0.47196772007990645,
0.35485317428205582, 0.40541650204605573, 0.24722737636793776,
0.14044646696401511, 0.2482022477258555, 0.49302494141092956,
0.28648219638009192, 0.31969281397315613, 0.21356181880784531,
0.63191161420227626, 0.2923314245275983, 0.087283482245567937,
0.30045535251024613, 0.19737895426641089, 0.18912504343604072,
0.27120921177271406, 0.17339711886163459, 0.32021274536404559,
0.2988955583375778, 0.33847533546903785, 0.23117449467422574,
0.27465375723735674, 0.47807691392285762, 0.21772126993496096,
0.3636920079271766, 0.20420305377183506, 0.17021253909243667,
0.53169483860833311, 0.28953679330156751, 0.61007449578491901,
0.12588838801911029, 0.44551621056840518, 0.29538602144907394,
0.44766092755582421, 0.21427672447031831, 0.27861823409288883,
0.50920780595236392, 0.48971037879400919, 0.3360706527861741,
0.24839722199743905, 0.44961067027165974, 0.30324998373627698,
0.47443739418663139, 0.42315916076015847, 0.37331073865863157,
0.21018226476706384, 0.47963670809552594, 0.4430465364616803,
0.47157777153673935, 0.46423374064042577, 0.3444545464642666,
0.43479262563131016, 0.29694581562174227, 0.40658634767555701,
0.42166435801135127, 0.3001953868148014, 0.48574590193847705,
0.74460674317756648, 0.49867919528685245, 0.30383490655102763,
0.44922072172849264, 0.44343648500484739, 0.52441579913588066,
0.44493128775365454, 0.71191605697539184, 0.3810447180981123,
0.39150833733976265, 0.5115474972113665, 0.47073288302654404,
0.60344537055107839, 0.42816350039746948, 0.2695844261761845,
0.14545080660132617, 0.33314603871242088, 0.57127461573979321,
0.46793825180051313, 0.28784701628117676, 0.5141471541658138,
0.42452398066124325, 0.50004401518793717, 0.3765603098516907,
0.48230135647383443, 0.33204118450678083, 0.27926814833150071,
0.37565042991763414, 0.47326754855713005, 0.25015199044169101,
0.41529519847295543, 0.3534233629571098, 0.53175983003219418,
0.28934181902998396, 0.3814346666412794, 0.39937229962696574,
0.52071128797579325, 0.42393905784649272, 0.37071108170418432,
0.457214666863418, 0.74174712052767444, 0.35108367169810722,
0.36739651908726401, 0.37617036130852366, 0.58030842365649749,
0.28258271094842097, 0.27127420319657525, 0.20810253920350599,
0.22090584970415891, 0.47950672524780363, 0.45799456394975224,
0.29746574701263179, 0.18815017207812298, 0.30734444343953149,
0.22714502639483244, 0.23104451182650335, 0.19627410006077078,
0.18418569522259087, 0.44954567884779856, 0.32261742804690935,
0.21219699890676047, 0.45169039583521753, 0.52682048181874441,
0.18236593535447776, 0.32489212788205074, 0.20004360264471938,
0.12634332798613856, 0.31676819989940291, 0.42978828599399904,
0.23240933172758818, 0.46013928093717121, 0.38240953799919714,
0.50940278022394747, 0.36492684498053907, 0.49854921243912997,
0.27764336273497114, 0.28778202485731558, 0.48600586763392184,
0.29974044684777312, 0.16637804508462689, 0.2188261241406011,
0.4928949585632072, 0.40834111611980889, 0.40008720528943875,
0.58583269468469801, 0.36018247103867279, 0.2208408582802977,
0.43596247126081139, 0.55814634811983421, 0.3898185603193719,
0.44551621056840518, 0.23149945179353162, 0.30929418615536697,
0.23598386003995322, 0.57666890392027126, 0.31520840572673453,
0.60006581651029689, 0.33204118450678083, 0.2759535857145804,
0.17612675866380426, 0.20088849115491475, 0.18386073810328496,
0.21447169874190186, 0.33711051556795302, 0.12790312215880692,
0.62079808072201403, 0.42458897208510449, 0.61468888687906298,
0.51343224850334079, 0.16650802793234926, 0.45545989841916612,
0.43895207675842585, 0.49705440969032288, 0.15565446014753179,
0.47534727412068795, 0.65563348391160781, 0.50556828621613781,
0.56523041332070312, 0.48581089336233829, 0.50290363783782921,
0.41146070446514565, 0.53487941837753095, 0.53650420397406051,
0.68143507918449719, 0.60955456439402955, 0.44746595328424066,
0.29304633019007137, 0.57972350084174684, 0.3386703097406214,
0.38500919495364444, 0.42692866334410706, 0.30052034393410731,
0.14538581517746499, 0.33704552414409183, 0.2394284055045959,
0.35121365454582959, 0.38474922925819971, 0.32216248807988107,
0.35368332865255453, 0.48191140793066739, 0.24514765080437992,
0.50121386081743857, 0.15324977746466803, 0.43329782288250296,
0.57003977868643063, 0.20693269357400471, 0.35186356878444142,
0.28947180187770633, 0.42341912645560326, 0.51928147665084723,
0.22357049808246737, 0.33288607301697615, 0.5619158507037828,
0.39332809720787582, 0.36941125322696067, 0.51980140804173669,
0.30337996658399935, 0.65374873261963362, 0.40021718813716106,
0.45695470116797332, 0.23390413447639541, 0.42751358615885771,
0.46403876636884223, 0.46273893789161857, 0.21856615844515637,
0.47976669094324831, 0.4978992982005182, 0.22194571248593781,
0.11555475162518228, 0.20660773645469879, 0.38351439220483724,
0.5361792468547546, 0.24930710193149561, 0.36187224805906348,
0.44746595328424066, 0.3681764161735982, 0.23500898868203546,
0.29545101287293513, 0.38929862892848244, 0.12965789060305885,
0.29909053260916135, 0.34088001815190161, 0.39176830303520738,
0.28459744508811763, 0.29746574701263179, 0.40528651919833331,
0.17424200737182996, 0.31429852579267797, 0.63613605675325313,
0.44005693096406584, 0.49257000144390128, 0.11159027476965015,
0.40801615900050298, 0.36791645047815347, 0.24313291666468326,
0.36960622749854416, 0.48067657087730487, 0.36798144190201465,
0.21791624420654454, 0.45981432381786536, 0.30675952062478085,
0.27159916031588116, 0.39625271128162898, 0.31371360297792739,
0.14746554074102283, 0.34958886894930002, 0.11646463155923883,
0.088063379331902128, 0.44746595328424066, 0.14616571226379915,
0.1659880965414598, 0.10717085794708973, 0.51538199121917627,
0.45455001848510956, 0.40554648489377804, 0.072790394724524268,
0.1180894171557684, 0.31592331138920754, 0.5903171029311195,
0.3504337574594954, 0.18470562661348033, 0.55210214570074434,
0.13693693007551128, 0.13674195580392773, 0.48873550743609151,
0.24040327686251364, 0.15565446014753179, 0.45701969259183445,
0.13791180143342902, 0.19204965750979394, 0.48451106488511464,
0.19549420297443659, 0.32905157900916643, 0.47307257428554661,
0.2289647862629455, 0.11821940000349077, 0.15552447729980942,
0.1467506350785498, 0.24553759934754704, 0.38565910919225627,
0.13739187004253955, 0.21037723903864736, 0.2268200692755265,
0.44720598758879598, 0.58076336362352576, 0.515641956914621,
0.35647795987858538, 0.19581916009374251, 0.1099004977492594,
0.18470562661348033, 0.30734444343953149, 0.3590126254091715,
0.39527783992371124, 0.19308952029157286, 0.5320847871515002,
0.22487032655969105, 0.30773439198269859, 0.12439358527030309,
0.33496579858053399, 0.3470542034187139, 0.2567161242516704,
0.47963670809552594, 0.16774286498571173, 0.49354487280181897,
0.32112262529810209, 0.30188516383519215, 0.37097104739962899,
0.26100555822650839, 0.33802039550200957, 0.33893027543606613,
0.44291655361395799, 0.35511313997750055, 0.21460168158962425,
0.18256090962606131, 0.86984521695806505, 0.3489389547106882,
0.4021669308529966, 0.57231447852157202, 0.47690706829335627,
0.390923414525012, 0.37006116746557244, 0.092742761849907249,
0.46020427236103245, 0.2239604466256345, 0.31579332854148523,
0.26100555822650839, 0.28355758230633876, 0.42998326026558259,
0.34640428918010208, 0.19861379131977336, 0.12933293348375294,
0.23890847411370641, 0.34607933206079616, 0.22110082397574249,
0.4060664162846675, 0.47599718835929972, 0.378445061143665, 0.19185468323821039,
0.50862288313761339, 0.54839763454065693, 0.52825029314369043,
0.32918156185688874, 0.47183773723218403, 0.31566334569376281,
0.57250945279315557, 0.26607488928768064, 0.2608105839549249,
0.11860934854665785, 0.44259159649465196, 0.46195904080528433,
0.1803512012147811, 0.13999152699698683, 0.31540337999831808,
0.47762197395582928, 0.44187669083217895, 0.15292482034536214,
0.44057686235495541, 0.36239217944995294, 0.33620063563389646,
0.29896054976143893, 0.30545969214755719, 0.46143910941439492,
0.4809365365727496, 0.33795540407814839, 0.3444545464642666,
0.3769502583948578, 0.3444545464642666, 0.28596226498920246,
0.38344940078097606, 0.35095368885038486, 0.33145626169203013,
0.48743567895886786, 0.1559794172668377, 0.26646483783084773,
0.2209708411280201, 0.40294682793933079, 0.32495711930591192,
0.3769502583948578, 0.39644768555321253, 0.25346655305861127,
0.36395197362262133, 0.44194168225604019, 0.44194168225604019,
0.33795540407814839, 0.4809365365727496, 0.36395197362262133,
0.1884751291974289, 0.49393482134498612, 0.51993139088945906,
0.42244425509768546, 0.30545969214755719, 0.25996569544472953,
0.24696741067249306, 0.19497427158354713, 0.31845797691979366,
0.31845797691979366, 0.50693310611722253, 0.32495711930591192,
0.19497427158354713, 0.50693310611722253, 0.33145626169203013,
0.4809365365727496, 0.45493996702827666, 0.48743567895886786,
0.40294682793933079, 0.39644768555321253, 0.40294682793933079,
0.42244425509768546, 0.31845797691979366, 0.23396912590025656,
0.44844082464215845, 0.3769502583948578, 0.40294682793933079,
0.42894339748380372, 0.30545969214755719, 0.40944597032544899,
0.35745283123650307, 0.37045111600873959, 0.46793825180051313,
0.4809365365727496, 0.49393482134498612, 0.31845797691979366,
0.29246140737532073, 0.44844082464215845, 0.49393482134498612,
0.23396912590025656, 0.44844082464215845, 0.25996569544472953,
0.20797255635578363, 0.37045111600873959, 0.40944597032544899,
0.4809365365727496, 0.23396912590025656, 0.44194168225604019,
0.40944597032544899, 0.42894339748380372, 0.25346655305861127,
0.37045111600873959, 0.41594511271156726, 0.48743567895886786,
0.40944597032544899, 0.39644768555321253, 0.44844082464215845,
0.25996569544472953, 0.40944597032544899, 0.41594511271156726,
0.1884751291974289, 0.1884751291974289, 0.41594511271156726,
0.38344940078097606, 0.32495711930591192, 0.30545969214755719,
0.33795540407814839, 0.1689777020390742, 0.25346655305861127,
0.50043396373110438, 0.3444545464642666, 0.31845797691979366,
0.31845797691979366, 0.45493996702827666, 0.28596226498920246,
0.46793825180051313, 0.2209708411280201, 0.27946312260308426,
0.26646483783084773, 0.2209708411280201, 0.47443739418663139,
0.272963980216966, 0.44194168225604019, 0.097487135791773566,
0.38344940078097606, 0.41594511271156726, 0.29246140737532073,
0.25346655305861127, 0.38344940078097606, 0.46143910941439492,
0.50693310611722253, 0.3444545464642666, 0.42244425509768546,
0.46143910941439492, 0.37045111600873959, 0.50043396373110438,
0.12998284772236476, 0.17547684442519243, 0.46143910941439492,
0.25346655305861127, 0.16247855965295596, 0.41594511271156726,
0.36395197362262133, 0.43544253986992193, 0.37045111600873959,
0.46143910941439492, 0.44194168225604019, 0.11698456295012828,
0.49393482134498612, 0.50043396373110438, 0.136481990108483,
0.26646483783084773, 0.42894339748380372, 0.1884751291974289,
0.38344940078097606, 0.48743567895886786, 0.1559794172668377,
0.51343224850334079, 0.33145626169203013, 0.49393482134498612,
0.3769502583948578, 0.35745283123650307, 0.44844082464215845,
0.64341509622570559, 0.40944597032544899, 0.45493996702827666,
0.42894339748380372, 0.47443739418663139, 0.42244425509768546,
0.35745283123650307, 0.18197598681131066, 0.37045111600873959,
0.39644768555321253, 0.22746998351413833, 0.27946312260308426,
0.22746998351413833, 0.46143910941439492, 0.31845797691979366,
0.07798970863341885, 0.24696741067249306, 0.42894339748380372,
0.42244425509768546, 0.29896054976143893, 0.29246140737532073,
0.14948027488071947, 0.21447169874190186, 0.41594511271156726,
0.2209708411280201, 0.48743567895886786, 0.21447169874190186,
0.4809365365727496, 0.25346655305861127, 0.21447169874190186,
0.50043396373110438, 0.47443739418663139, 0.3769502583948578,
0.40944597032544899, 0.44194168225604019, 0.42894339748380372,
0.47443739418663139, 0.097487135791773566, 0.28596226498920246,
0.50693310611722253, 0.3444545464642666, 0.24696741067249306,
0.33145626169203013, 0.31845797691979366, 0.45493996702827666,
0.42894339748380372, 0.46143910941439492, 0.50693310611722253,
0.50043396373110438, 0.35745283123650307, 0.14298113249460123,
0.39644768555321253, 0.26646483783084773, 0.1559794172668377,
0.17547684442519243, 0.30545969214755719, 0.4809365365727496,
0.18197598681131066, 0.40294682793933079, 0.29246140737532073,
0.1884751291974289, 0.3119588345336754, 0.3769502583948578, 0.52643053327557732,
0.40944597032544899, 0.3444545464642666, 0.22746998351413833,
0.1884751291974289, 0.60442024190899613, 0.35745283123650307,
0.22746998351413833, 0.23396912590025656, 0.40944597032544899,
0.272963980216966, 0.3769502583948578, 0.19497427158354713, 0.22746998351413833,
0.29246140737532073, 0.25996569544472953, 0.29246140737532073,
0.136481990108483, 0.40944597032544899, 0.25996569544472953,
0.38994854316709426, 0.41594511271156726, 0.136481990108483,
0.29246140737532073, 0.29896054976143893, 0.07798970863341885,
0.28596226498920246, 0.19497427158354713, 0.67591080815629678,
0.41594511271156726, 0.1689777020390742, 0.2209708411280201,
0.11698456295012828, 0.3119588345336754, 0.31845797691979366,
0.4809365365727496, 0.27946312260308426, 0.72790394724524266,
0.26646483783084773, 0.19497427158354713, 0.097487135791773566,
0.23396912590025656, 0.1689777020390742, 0.19497427158354713,
0.1689777020390742, 0.2209708411280201, 0.45493996702827666,
0.21447169874190186, 0.19497427158354713, 0.14298113249460123,
0.1559794172668377, 0.33145626169203013, 0.46143910941439492,
0.35095368885038486, 0.20797255635578363, 0.18197598681131066,
0.3769502583948578, 0.31845797691979366, 0.46793825180051313,
0.19497427158354713, 0.136481990108483, 0.17547684442519243,
0.43544253986992193, 0.35095368885038486, 0.41594511271156726,
0.20147341396966539, 0.44844082464215845, 0.19497427158354713,
0.1884751291974289, 0.21447169874190186, 0.18197598681131066,
0.50043396373110438, 0.17547684442519243, 0.23396912590025656,
0.272963980216966, 0.136481990108483, 0.31845797691979366, 0.41594511271156726,
0.55892624520616851, 0.48743567895886786, 0.36395197362262133,
0.29246140737532073, 0.24696741067249306, 0.53942881804781373,
0.38994854316709426, 0.23396912590025656, 0.45493996702827666,
0.42244425509768546, 0.51343224850334079, 0.30545969214755719,
0.22746998351413833, 0.40294682793933079, 0.136481990108483,
0.2209708411280201, 0.1884751291974289, 0.42244425509768546,
0.33145626169203013, 0.33145626169203013, 0.3769502583948578,
0.14298113249460123, 0.48743567895886786, 0.3444545464642666,
0.24696741067249306, 0.24696741067249306, 0.28596226498920246,
0.21447169874190186, 0.17547684442519243, 0.31845797691979366,
0.29246140737532073, 0.19497427158354713, 0.44844082464215845,
0.33795540407814839, 0.10398627817789181, 0.26646483783084773,
0.44194168225604019, 0.21447169874190186, 0.29896054976143893,
0.25346655305861127, 0.18197598681131066, 0.42244425509768546,
0.26646483783084773, 0.24696741067249306, 0.46143910941439492,
0.42894339748380372, 0.3119588345336754, 0.14948027488071947,
0.38994854316709426, 0.41594511271156726, 0.14298113249460123,
0.23396912590025656, 0.23396912590025656, 0.18197598681131066,
0.6239176690673508, 0.31845797691979366, 0.47443739418663139,
0.37045111600873959, 0.33145626169203013, 0.3119588345336754,
0.33145626169203013, 0.25996569544472953, 0.27946312260308426,
0.31845797691979366, 0.39644768555321253, 0.31845797691979366,
0.35095368885038486, 0.61741852668123265, 0.42894339748380372,
0.55242710282005025, 0.20797255635578363, 0.27946312260308426,
0.38994854316709426, 0.37045111600873959, 0.23396912590025656,
0.26646483783084773, 0.24696741067249306, 0.38344940078097606,
0.53942881804781373, 0.21447169874190186, 0.59792109952287786,
0.44194168225604019, 0.40944597032544899, 0.25346655305861127,
0.41594511271156726, 0.12348370533624653, 0.30545969214755719,
0.26646483783084773, 0.50043396373110438, 0.39644768555321253,
0.20147341396966539, 0.37045111600873959, 0.23396912590025656,
0.3119588345336754, 0.22746998351413833, 0.44194168225604019,
0.11698456295012828, 0.35095368885038486, 0.50043396373110438,
0.42244425509768546, 0.32495711930591192, 0.35745283123650307,
0.38994854316709426, 0.29246140737532073, 0.50693310611722253,
0.20797255635578363, 0.42244425509768546, 0.19497427158354713,
0.38994854316709426, 0.20797255635578363, 0.2404682682863748,
0.24696741067249306, 0.23396912590025656, 0.24696741067249306,
0.42894339748380372, 0.39644768555321253, 0.40944597032544899,
0.28596226498920246, 0.38344940078097606, 0.3769502583948578,
0.23396912590025656, 0.38344940078097606, 0.52643053327557732,
0.50693310611722253, 0.48743567895886786, 0.44844082464215845,
0.48743567895886786, 0.49393482134498612, 0.33145626169203013,
0.28596226498920246, 0.16247855965295596, 0.21447169874190186,
0.51343224850334079, 0.32495711930591192, 0.42894339748380372,
0.20147341396966539, 0.36395197362262133, 0.35095368885038486,
0.40944597032544899, 0.29246140737532073, 0.44194168225604019,
0.31845797691979366, 0.12998284772236476, 0.4809365365727496,
0.28596226498920246, 0.3119588345336754, 0.24696741067249306,
0.26646483783084773, 0.38344940078097606, 0.25996569544472953,
0.3769502583948578, 0.44194168225604019, 0.25996569544472953,
0.3769502583948578, 0.2209708411280201, 0.56542538759228667,
0.3444545464642666, 0.32495711930591192, 0.42244425509768546,
0.18197598681131066, 0.272963980216966, 0.36395197362262133,
0.41594511271156726, 0.45493996702827666, 0.272963980216966,
0.33795540407814839, 0.3957977713146007, 0.43024322596102738,
0.23721869709331569, 0.13908164706293027, 0.36265214514539768,
0.27751337988724878, 0.37305077296318684, 0.42244425509768546,
0.18327581528853432, 0.14298113249460123, 0.29246140737532073,
0.29571097856837986, 0.28466243651197881, 0.12803310500652929,
0.18197598681131066, 0.32560703354452375, 0.19887375701521809,
0.34900394613454938, 0.19757392853799444, 0.28011303684169608,
0.31910789115840549, 0.27946312260308426, 0.24501766795665758,
0.17937632985686339, 0.36720154481568046, 0.44259159649465196,
0.28921183618226159, 0.13128267619958842, 0.17287718747074515,
0.31390857724951088, 0.21902109841218464, 0.41464528423434355,
0.18587547224298162, 0.35550308852066764, 0.28856192194364977,
0.27816329412586055, 0.31650823420395824, 0.26256535239917683,
0.42764356900658007, 0.26516500935362408, 0.30156020671588624,
0.29506106432976797, 0.52448079055974184, 0.35225351732760851,
0.27881320836447243, 0.25021698186555219, 0.25996569544472953,
0.22357049808246737, 0.48353619352719696, 0.23591886861609201,
0.16832778780046237, 0.31975780539701731, 0.17417701594796878,
0.26516500935362408, 0.21967101265079642, 0.11178524904123369,
0.37565042991763414, 0.14493087521043671, 0.2404682682863748,
0.21317187026467818, 0.39059845740570609, 0.32495711930591192,
0.23981835404776297, 0.42634374052935636, 0.44064185377881654,
0.16832778780046237, 0.21187204178745456, 0.13713190434709482,
0.18782521495881707, 0.28271269379614333, 0.41984459814323816,
0.48158645081136142, 0.41594511271156726, 0.13843173282431848,
0.35940257395233854, 0.12348370533624653, 0.2209708411280201,
0.63041681145346906, 0.1689777020390742, 0.33145626169203013,
0.2404682682863748, 0.33145626169203013, 0.28596226498920246,
0.12998284772236476, 0.40944597032544899, 0.44844082464215845,
0.14298113249460123, 0.39644768555321253, 0.22746998351413833,
0.30545969214755719, 0.23396912590025656, 0.50693310611722253,
0.35745283123650307, 0.1559794172668377, 0.3119588345336754,
0.39644768555321253, 0.18197598681131066, 0.20147341396966539,
0.43544253986992193, 0.272963980216966, 0.11698456295012828,
0.51343224850334079, 0.2404682682863748, 0.20797255635578363,
0.20147341396966539, 0.14298113249460123, 0.11698456295012828,
0.24696741067249306, 0.2404682682863748, 0.22746998351413833,
0.46793825180051313, 0.20797255635578363, 0.36395197362262133,
0.38344940078097606, 0.24696741067249306, 0.20147341396966539,
0.46143910941439492, 0.3769502583948578, 0.25346655305861127,
0.14948027488071947, 0.35095368885038486, 0.1559794172668377,
0.1884751291974289, 0.51993139088945906, 0.49393482134498612,
0.31845797691979366, 0.3769502583948578, 0.39644768555321253,
0.35095368885038486, 0.22746998351413833, 0.2209708411280201,
0.2404682682863748, 0.2209708411280201, 0.1559794172668377, 0.3444545464642666,
0.33795540407814839, 0.25346655305861127, 0.3444545464642666,
0.40294682793933079, 0.23396912590025656, 0.32495711930591192,
0.40944597032544899, 0.20797255635578363, 0.14298113249460123,
0.29896054976143893, 0.32495711930591192, 0.43544253986992193,
0.22746998351413833, 0.27946312260308426, 0.2209708411280201,
0.20147341396966539, 0.3119588345336754, 0.2404682682863748,
0.26646483783084773, 0.33145626169203013, 0.32495711930591192,
0.33795540407814839, 0.19497427158354713, 0.40294682793933079,
0.29246140737532073, 0.25996569544472953, 0.18197598681131066,
0.17547684442519243, 0.29896054976143893, 0.24696741067249306,
0.19497427158354713, 0.29246140737532073, 0.17547684442519243,
0.27946312260308426, 0.11698456295012828, 0.3444545464642666,
0.35095368885038486, 0.32495711930591192, 0.1884751291974289,
0.19497427158354713, 0.20797255635578363, 0.21447169874190186,
0.090987993405655332, 0.18197598681131066, 0.11698456295012828,
0.2404682682863748, 0.25346655305861127, 0.25346655305861127,
0.48938542167470328, 0.30747442628725385, 0.39774751403043618,
0.31780806268118184, 0.4445413392104875, 0.29896054976143893,
0.62456758330596263, 0.44324151073326384, 0.39449794283737705,
0.41334545575711995, 0.20732264211717177, 0.28986175042087342,
0.45883945245994756, 0.30675952062478085, 0.50693310611722253,
0.16117873117573231, 0.32560703354452375, 0.47573722266385504,
0.41009588456406082, 0.28596226498920246, 0.41074579880267265,
0.39040348313412254, 0.19497427158354713, 0.48074156230116605,
0.11698456295012828, 0.11016046344470413, 0.42959331172241549,
0.20147341396966539, 0.45039056735799388, 0.30981411754625643,
0.51408216274195262, 0.50043396373110438, 0.36986619319398889,
0.53942881804781373, 0.43804219682436929, 0.20335816526163966,
0.21967101265079642, 0.40977092744475491, 0.36915128753151588,
0.25996569544472953, 0.19757392853799444, 0.40710627906644642,
0.37370068720179866, 0.44844082464215845, 0.37435060144041055,
0.30675952062478085, 0.42049451238185004, 0.3243072050673001,
0.40554648489377804, 0.23331921166164474, 0.26386518087640048,
0.36720154481568046, 0.15662933150544955, 0.26971440902390686,
0.2755636371714133, 0.37799012117663672, 0.30812434052586563,
0.2268200692755265, 0.3620022309067859, 0.15604440869069891,
0.27166415173974234, 0.33860531831676022, 0.29798567840352125,
0.41074579880267265, 0.47703705114107869, 0.40424665641655444,
0.55047736010421477, 0.42829348324519195, 0.41789485542740268,
0.37890000111069327, 0.28596226498920246, 0.38539914349681148,
0.5160319054577881, 0.33925523255537204, 0.44844082464215845,
0.25866586696750588, 0.47443739418663139, 0.35160360308899669,
0.43674236834714564, 0.30415986367033354, 0.39514785707598887,
0.35420326004344399, 0.32950651897619471, 0.26386518087640048,
0.46410375779270335, 0.28726209346642612, 0.39124837164431797,
0.23734867994103809, 0.38669897197403519, 0.34900394613454938,
0.41854476966601456, 0.3998922310178552, 0.22480533513582987,
0.29265638164690427, 0.35420326004344399, 0.44707600474107362,
0.53162984718447182, 0.39631770270549016, 0.4762571540547445,
0.23396912590025656, 0.24241801100221025, 0.29506106432976797,
0.35550308852066764, 0.48158645081136142, 0.42049451238185004,
0.49913413525388067, 0.44389142497187561, 0.1910747861518762,
0.29766072128421528, 0.26906449478529504, 0.44844082464215845,
0.46143910941439492, 0.2918114931367089, 0.14772550643646756,
0.48678576472025609, 0.19432435734493531, 0.57517410117146406,
0.37045111600873959, 0.3769502583948578, 0.18002624409547519,
0.39872238538835392, 0.36395197362262133, 0.49328490710637429,
0.31715814844257001, 0.39969725674627166, 0.41477526708206597,
0.28336260803475521, 0.20797255635578363, 0.46988799451634861,
0.38864871468987061, 0.29246140737532073, 0.59012212865953595,
0.28570229929375773, 0.41139571304128447, 0.42504391205213282,
0.51590192261006573, 0.25411646729722309, 0.14623070368766036,
0.33275609016925378, 0.35881765113758796, 0.10723584937095093,
0.3243072050673001, 0.30350994943172172, 0.40658634767555701,
0.26815461485123848, 0.52454578198360291, 0.35400828577186044,
0.19237461462909985, 0.36265214514539768, 0.30753941771111504,
0.42439399781352094, 0.5085578917137521, 0.20862247059439545,
0.44584116768771109, 0.35940257395233854, 0.27361389445557782,
0.29701080704560351, 0.19497427158354713, 0.26477506081045704,
0.53487941837753095, 0.35095368885038486, 0.4809365365727496,
0.40294682793933079, 0.32495711930591192, 0.5036835349241634,
0.35745283123650307, 0.45104048159660576, 0.35673792557403011,
0.42309416933629729, 0.22162075536663192, 0.24696741067249306,
0.30026037823866264, 0.50407348346733061, 0.40229691370071891,
0.42959331172241549, 0.38344940078097606, 0.33340600440786561,
0.2567161242516704, 0.43349279715408651, 0.49776931535279589,
0.48743567895886786, 0.18821516350198417, 0.31260874877228728,
0.19302452886771165, 0.46793825180051313, 0.39319811436015339,
0.39709759979182435, 0.2179812356304057, 0.3470542034187139,
0.27946312260308426, 0.52513070479835366, 0.32944152755233347,
0.36850137329290411, 0.51343224850334079, 0.35485317428205582,
0.46533859484606582, 0.33730548983953657, 0.49003533591331516,
0.38383934932414315, 0.61286912701094987, 0.23266929742303291,
0.3243072050673001, 0.37734020693802489, 0.45169039583521753,
0.64991423861182385, 0.20407307092411267, 0.37974488962088865,
0.37045111600873959, 0.20667272787855998, 0.46663842332328948,
0.46975801166862624, 0.46923808027773678, 0.3444545464642666,
0.47118782299357226, 0.54917753162699112, 0.22746998351413833,
0.49588456406082154, 0.61338905840183933, 0.40034717098488348,
0.54995742871332531, 0.29896054976143893, 0.45299022431244124,
0.44844082464215845, 0.47443739418663139, 0.41074579880267265,
0.2839475308495058, 0.28531235075059064, 0.56152590216061582,
0.2404682682863748, 0.55639157967558239, 0.47443739418663139,
0.20797255635578363, 0.37110103024735142, 0.18717530072020527,
0.32495711930591192, 0.28596226498920246, 0.16845777064818473,
0.38214957230375241, 0.42244425509768546, 0.43219296867686285,
0.4544200356373872, 0.3769502583948578, 0.46923808027773678,
0.53812898957059008, 0.23916843980915115, 0.38149965806514058,
0.34380463222565477, 0.28661217922781429, 0.2567161242516704,
0.35095368885038486, 0.36973621034626658, 0.49198507862915064,
0.20556787367291987, 0.60364034482266193, 0.2755636371714133,
0.31780806268118184, 0.38994854316709426, 0.20283823387075023,
0.36135231666817402, 0.43089314019963915, 0.35940257395233854,
0.32554204212066257, 0.36349703365559305, 0.24111818252498665,
0.25346655305861127, 0.25086689610416402, 0.48938542167470328,
0.15013018911933132, 0.40294682793933079, 0.19562418582215899,
0.3308063474534183, 0.35745283123650307, 0.18717530072020527,
0.48548593624303238, 0.23006964046858561, 0.22811989775275016,
0.50888284883305801, 0.41594511271156726, 0.44129176801742842,
0.30156020671588624, 0.40294682793933079, 0.65517854394457964,
0.26321526663778866, 0.33600566136231291, 0.41984459814323816,
0.29135655316968062, 0.42244425509768546, 0.45039056735799388,
0.35485317428205582, 0.49718439253804519, 0.26516500935362408,
0.43219296867686285, 0.4659885090846777, 0.55047736010421477,
0.43544253986992193, 0.56087598792200388, 0.26451509511501231,
0.35680291699789124, 0.13076274480869896, 0.45234031007382935,
0.19497427158354713, 0.34380463222565477, 0.35023878318791185,
0.4756722312399938, 0.44259159649465196, 0.2269500521232489,
0.34828904047207637, 0.18782521495881707, 0.29961046400005076,
0.3444545464642666, 0.28531235075059064, 0.60286044773632774,
0.18522555800436979, 0.18743526641564998, 0.3633020593840095,
0.37045111600873959, 0.36395197362262133, 0.42439399781352094,
0.43011324311330507, 0.45818953822133579, 0.33776042980656484,
0.16182864541434411, 0.371685953062102, 0.28076295108030791,
0.64341509622570559, 0.31715814844257001, 0.58797741167211703,
0.44382643354801454, 0.60442024190899613, 0.54527804619532017,
0.47118782299357226, 0.39742255691113026, 0.29441115009115615,
0.30545969214755719, 0.464688680607454, 0.23338420308550592,
0.2209708411280201, 0.16572813084601506, 0.53448946983436385,
0.1298528648746424, 0.23643880000698153, 0.48522597054758765,
0.32560703354452375, 0.21772126993496096, 0.43544253986992193,
0.328206690498971, 0.50173379220832803, 0.49588456406082154,
0.47443739418663139, 0.3444545464642666, 0.35290343156622028,
0.20797255635578363), ages = c(1.0649350649350648, 0.87012987012987009,
0.61038961038961037, 0.75324675324675328, 0.92207792207792205,
1.051948051948052, 0.98701298701298701, 0.90909090909090906,
0.94805194805194803, 0.83116883116883122, 1.0129870129870129,
0.87012987012987009, 0.88311688311688308, 1.0129870129870129,
0.97402597402597402, 1.051948051948052, 0.89610389610389607,
0.92207792207792205, 0.79220779220779225, 1.051948051948052,
0.80519480519480524, 0.87012987012987009, 0.96103896103896103,
1, 0.89610389610389607, 1, 0.97402597402597402, 0.98701298701298701,
0.87012987012987009, 0.98701298701298701, 0.88311688311688308,
1.025974025974026, 0.74025974025974028, 0.74025974025974028,
1.0779220779220779, 0.93506493506493504, 0.97402597402597402,
0.92207792207792205, 1.0389610389610389, 1.025974025974026, 0.98701298701298701,
1.0129870129870129, 1.0389610389610389, 0.74025974025974028,
0.7142857142857143, 0.58441558441558439, 0.72727272727272729,
0.94805194805194803, 1, 0.72727272727272729, 0.94805194805194803,
0.90909090909090906, 0.89610389610389607, 0.94805194805194803,
0.83116883116883122, 0.79220779220779225, 0.72727272727272729,
0.72727272727272729, 0.8571428571428571, 0.80519480519480524,
0.75324675324675328, 0.68831168831168832, 0.8441558441558441,
0.72727272727272729, 0.58441558441558439, 0.80519480519480524,
0.7142857142857143, 0.54545454545454541, 0.70129870129870131,
0.68831168831168832, 0.54545454545454541, 0.8571428571428571,
0.8441558441558441, 0.80519480519480524, 0.80519480519480524,
0.90909090909090906, 0.68831168831168832, 0.66233766233766234,
0.51948051948051943, 0.96103896103896103, 0.88311688311688308,
0.68831168831168832, 0.63636363636363635, 0.59740259740259738,
0.68831168831168832, 0.51948051948051943, 0.79220779220779225,
0.76623376623376627, 0.55844155844155841, 0.81818181818181823,
0.5714285714285714, 0.51948051948051943, 0.55844155844155841,
1.1038961038961039, 0.79220779220779225, 0.77922077922077926,
0.75324675324675328, 0.5714285714285714, 0.94805194805194803,
0.8571428571428571, 0.81818181818181823, 0.64935064935064934,
0.77922077922077926, 1.0129870129870129, 0.94805194805194803,
0.68831168831168832, 0.61038961038961037, 0.51948051948051943,
1, 0.88311688311688308, 0.75324675324675328, 0.79220779220779225,
0.64935064935064934, 0.63636363636363635, 1, 0.98701298701298701,
0.92207792207792205, 0.80519480519480524, 0.93506493506493504,
0.8441558441558441, 0.96103896103896103, 0.68831168831168832,
0.62337662337662336, 0.90909090909090906, 0.79220779220779225,
0.77922077922077926, 0.72727272727272729, 0.66233766233766234,
0.89610389610389607, 0.7142857142857143, 0.59740259740259738,
0.87012987012987009, 0.81818181818181823, 0.80519480519480524,
0.72727272727272729, 0.62337662337662336, 0.58441558441558439,
0.79220779220779225, 0.77922077922077926, 0.70129870129870131,
0.68831168831168832, 0.64935064935064934, 0.51948051948051943,
0.66233766233766234, 0.5714285714285714, 0.54545454545454541,
0.93506493506493504, 0.92207792207792205, 0.92207792207792205,
0.80519480519480524, 0.76623376623376627, 0.68831168831168832,
0.81818181818181823, 0.7142857142857143, 0.58441558441558439,
0.88311688311688308, 0.81818181818181823, 0.77922077922077926,
0.70129870129870131, 0.81818181818181823, 0.59740259740259738,
0.5714285714285714, 0.88311688311688308, 0.75324675324675328,
0.93506493506493504, 0.68831168831168832, 0.63636363636363635,
0.75324675324675328, 0.93506493506493504, 0.76623376623376627,
0.67532467532467533, 0.8441558441558441, 0.62337662337662336,
0.96103896103896103, 0.75324675324675328, 0.93506493506493504,
0.92207792207792205, 0.89610389610389607, 0.88311688311688308,
0.66233766233766234, 0.54545454545454541, 0.53246753246753242,
0.81818181818181823, 0.74025974025974028, 0.72727272727272729,
0.90909090909090906, 0.72727272727272729, 0.89610389610389607,
0.80519480519480524, 0.75324675324675328, 0.70129870129870131,
0.8571428571428571, 0.8441558441558441, 0.67532467532467533,
0.62337662337662336, 0.8571428571428571, 0.8571428571428571,
0.8441558441558441, 0.7142857142857143, 0.67532467532467533,
0.55844155844155841, 0.68831168831168832, 0.97402597402597402,
0.8441558441558441, 0.63636363636363635, 0.59740259740259738,
1.025974025974026, 0.8571428571428571, 0.76623376623376627, 0.72727272727272729,
0.7142857142857143, 0.88311688311688308, 0.70129870129870131,
0.90909090909090906, 0.89610389610389607, 0.8571428571428571,
0.81818181818181823, 0.94805194805194803, 0.92207792207792205,
0.66233766233766234, 0.96103896103896103, 0.87012987012987009,
0.79220779220779225, 0.68831168831168832, 1.025974025974026,
0.90909090909090906, 0.75324675324675328, 0.63636363636363635,
0.76623376623376627, 0.67532467532467533, 0.67532467532467533,
0.79220779220779225, 0.77922077922077926, 0.76623376623376627,
0.72727272727272729, 0.72727272727272729, 0.7142857142857143,
0.74025974025974028, 0.63636363636363635, 0.61038961038961037,
0.87012987012987009, 0.83116883116883122, 0.77922077922077926,
0.79220779220779225, 0.74025974025974028, 0.67532467532467533,
0.92207792207792205, 0.90909090909090906, 0.88311688311688308,
0.8441558441558441, 0.8441558441558441, 0.64935064935064934,
0.83116883116883122, 0.72727272727272729, 0.93506493506493504,
0.89610389610389607, 0.68831168831168832, 0.8441558441558441,
0.96103896103896103, 0.79220779220779225, 0.74025974025974028,
0.72727272727272729, 0.63636363636363635, 1.051948051948052,
0.8441558441558441, 0.72727272727272729, 0.68831168831168832,
0.97402597402597402, 0.92207792207792205, 0.8441558441558441,
0.76623376623376627, 0.72727272727272729, 0.66233766233766234,
0.59740259740259738, 0.89610389610389607, 0.79220779220779225,
0.79220779220779225, 0.76623376623376627, 0.67532467532467533,
0.96103896103896103, 0.80519480519480524, 0.81818181818181823,
0.80519480519480524, 0.79220779220779225, 0.61038961038961037,
0.97402597402597402, 0.87012987012987009, 0.72727272727272729,
0.54545454545454541, 0.54545454545454541, 0.92207792207792205,
0.79220779220779225, 0.75324675324675328, 0.7142857142857143,
0.90909090909090906, 0.8571428571428571, 0.58441558441558439,
0.75324675324675328, 0.79220779220779225, 0.74025974025974028,
0.64935064935064934, 0.63636363636363635, 0.68831168831168832,
0.79220779220779225, 0.81818181818181823, 0.5714285714285714,
0.68831168831168832, 0.77922077922077926, 0.68831168831168832,
0.80519480519480524, 0.67532467532467533, 0.67532467532467533,
0.59740259740259738, 1, 0.96103896103896103, 0.92207792207792205,
0.8441558441558441, 0.81818181818181823, 0.75324675324675328,
0.97402597402597402, 0.94805194805194803, 0.94805194805194803,
0.75324675324675328, 0.89610389610389607, 0.77922077922077926,
0.54545454545454541, 0.8441558441558441, 0.79220779220779225,
0.72727272727272729, 0.7142857142857143, 0.68831168831168832,
0.67532467532467533, 0.92207792207792205, 0.81818181818181823,
0.76623376623376627, 0.66233766233766234, 0.64935064935064934,
0.87012987012987009, 0.80519480519480524, 0.79220779220779225,
0.7142857142857143, 0.70129870129870131, 0.77922077922077926,
0.76623376623376627, 0.62337662337662336, 1.0129870129870129,
0.70129870129870131, 0.81818181818181823, 0.74025974025974028,
0.70129870129870131, 0.67532467532467533, 0.5714285714285714,
0.67532467532467533, 0.83116883116883122, 0.72727272727272729,
0.68831168831168832, 0.68831168831168832, 0.66233766233766234,
0.92207792207792205, 0.88311688311688308, 0.97402597402597402,
0.97402597402597402, 0.89610389610389607, 0.76623376623376627,
0.81818181818181823, 0.75324675324675328, 0.94805194805194803,
0.72727272727272729, 0.58441558441558439, 1.051948051948052,
0.96103896103896103, 0.8441558441558441, 0.76623376623376627,
0.75324675324675328, 0.70129870129870131, 0.96103896103896103,
0.75324675324675328, 0.80519480519480524, 0.72727272727272729,
0.58441558441558439, 0.54545454545454541, 0.90909090909090906,
0.8571428571428571, 0.74025974025974028, 0.62337662337662336,
0.8441558441558441, 0.77922077922077926, 0.75324675324675328,
0.68831168831168832, 0.68831168831168832, 0.94805194805194803,
0.88311688311688308, 0.83116883116883122, 0.5714285714285714,
0.54545454545454541, 0.81818181818181823, 0.76623376623376627,
0.63636363636363635, 0.96103896103896103, 0.74025974025974028,
0.92207792207792205, 0.80519480519480524, 0.72727272727272729,
0.93506493506493504, 0.77922077922077926, 0.74025974025974028,
0.62337662337662336, 0.96103896103896103, 0.88311688311688308,
0.8441558441558441, 0.64935064935064934, 1.025974025974026, 0.96103896103896103,
0.87012987012987009, 0.97402597402597402, 0.80519480519480524,
0.61038961038961037, 0.59740259740259738, 0.5714285714285714,
0.96103896103896103, 0.83116883116883122, 0.76623376623376627,
0.68831168831168832, 0.75324675324675328, 0.88311688311688308,
0.68831168831168832, 0.68831168831168832, 0.68831168831168832,
0.92207792207792205, 0.68831168831168832, 0.68831168831168832,
0.8441558441558441, 0.77922077922077926, 0.67532467532467533,
0.55844155844155841, 0.54545454545454541, 1, 0.8571428571428571,
0.83116883116883122, 0.81818181818181823, 0.76623376623376627,
0.8571428571428571, 0.5714285714285714, 0.66233766233766234,
0.83116883116883122, 0.80519480519480524, 0.61038961038961037,
0.61038961038961037, 0.7142857142857143, 0.94805194805194803,
0.79220779220779225, 0.7142857142857143, 0.75324675324675328,
0.8441558441558441, 0.74025974025974028, 0.64935064935064934,
0.62337662337662336, 0.89610389610389607, 0.89610389610389607,
0.81818181818181823, 0.54545454545454541, 0.93506493506493504,
0.87012987012987009, 0.8571428571428571, 0.77922077922077926,
0.7142857142857143, 0.72727272727272729, 0.70129870129870131,
0.67532467532467533, 0.61038961038961037, 0.61038961038961037,
1, 0.75324675324675328, 0.55844155844155841, 0.97402597402597402,
0.8441558441558441, 0.75324675324675328, 0.74025974025974028,
0.53246753246753242, 0.8441558441558441, 0.76623376623376627,
0.96103896103896103, 0.87012987012987009, 0.93506493506493504,
0.87012987012987009, 0.8571428571428571, 0.83116883116883122,
0.81818181818181823, 0.79220779220779225, 0.79220779220779225,
0.63636363636363635, 0.54545454545454541, 0.89610389610389607,
0.94805194805194803, 0.8571428571428571, 0.83116883116883122,
0.80519480519480524, 0.74025974025974028, 0.93506493506493504,
0.88311688311688308, 0.7142857142857143, 0.81818181818181823,
0.81818181818181823, 0.90909090909090906, 0.81818181818181823,
0.80519480519480524, 0.79220779220779225, 0.77922077922077926,
0.67532467532467533, 0.66233766233766234, 0.88311688311688308,
0.53246753246753242, 0.94805194805194803, 0.77922077922077926,
0.98701298701298701, 0.96103896103896103, 0.87012987012987009,
0.8571428571428571, 0.8441558441558441, 0.80519480519480524,
0.79220779220779225, 0.5714285714285714, 0.93506493506493504,
0.87012987012987009, 0.75324675324675328, 0.74025974025974028,
0.90909090909090906, 0.81818181818181823, 0.77922077922077926,
0.79220779220779225, 0.64935064935064934, 0.62337662337662336,
0.62337662337662336, 0.81818181818181823, 0.76623376623376627,
0.72727272727272729, 0.68831168831168832, 0.83116883116883122,
0.63636363636363635, 0.81818181818181823, 0.79220779220779225,
0.80519480519480524, 0.76623376623376627, 0.96103896103896103,
0.87012987012987009, 0.83116883116883122, 0.81818181818181823,
0.59740259740259738, 0.61038961038961037, 0.89610389610389607,
0.88311688311688308, 0.87012987012987009, 0.74025974025974028,
0.79220779220779225, 0.53246753246753242, 0.81818181818181823,
0.80519480519480524, 0.72727272727272729, 0.70129870129870131,
0.8571428571428571, 0.77922077922077926, 0.68831168831168832,
0.62337662337662336, 0.68831168831168832, 0.66233766233766234,
0.90909090909090906, 0.89610389610389607, 0.76623376623376627,
0.74025974025974028, 0.72727272727272729, 0.63636363636363635,
0.90909090909090906, 0.80519480519480524, 0.76623376623376627,
0.67532467532467533, 0.88311688311688308, 0.76623376623376627,
0.62337662337662336, 0.68831168831168832, 0.90909090909090906,
0.75324675324675328, 0.97402597402597402, 0.93506493506493504,
0.77922077922077926, 0.89610389610389607, 0.8441558441558441,
0.90909090909090906, 0.93506493506493504, 0.72727272727272729,
0.97402597402597402, 0.87012987012987009, 0.89610389610389607,
0.70129870129870131, 0.61038961038961037, 0.94805194805194803,
0.81818181818181823, 0.80519480519480524, 0.75324675324675328,
0.72727272727272729, 0.75324675324675328, 0.58441558441558439,
0.94805194805194803, 0.90909090909090906, 0.68831168831168832,
0.97402597402597402, 0.96103896103896103, 0.94805194805194803,
0.74025974025974028, 0.7142857142857143, 0.67532467532467533,
0.77922077922077926, 0.77922077922077926, 0.74025974025974028,
0.8571428571428571, 0.70129870129870131, 0.83116883116883122,
0.67532467532467533, 0.58441558441558439, 0.83116883116883122,
0.75324675324675328, 0.70129870129870131, 0.64935064935064934,
0.97402597402597402, 0.8571428571428571, 0.79220779220779225,
0.64935064935064934, 0.66233766233766234, 0.8441558441558441,
0.74025974025974028, 0.68831168831168832, 0.67532467532467533,
0.94805194805194803, 0.97402597402597402, 0.97402597402597402,
0.96103896103896103, 0.8441558441558441, 0.70129870129870131,
0.92207792207792205, 0.80519480519480524, 0.79220779220779225,
1.0389610389610389, 0.75324675324675328, 0.75324675324675328,
0.67532467532467533, 0.74025974025974028, 0.62337662337662336,
0.76623376623376627, 0.66233766233766234, 0.83116883116883122,
0.89610389610389607, 0.5714285714285714, 0.92207792207792205,
0.89610389610389607, 0.81818181818181823, 0.76623376623376627,
0.89610389610389607, 0.92207792207792205, 0.80519480519480524,
0.66233766233766234, 0.75324675324675328, 0.88311688311688308,
0.93506493506493504, 0.87012987012987009, 0.8571428571428571,
0.70129870129870131, 0.54545454545454541, 0.97402597402597402,
1.0649350649350648, 0.77922077922077926, 0.92207792207792205,
0.70129870129870131, 0.64935064935064934, 0.64935064935064934,
0.8571428571428571, 0.8441558441558441, 0.80519480519480524,
0.75324675324675328, 0.83116883116883122, 1.1038961038961039,
0.80519480519480524, 0.72727272727272729, 0.62337662337662336,
0.94805194805194803, 0.8441558441558441, 0.66233766233766234,
1, 0.92207792207792205, 0.79220779220779225, 0.79220779220779225,
0.63636363636363635, 0.58441558441558439, 0.87012987012987009,
0.8441558441558441, 0.63636363636363635, 0.8441558441558441,
0.81818181818181823, 0.97402597402597402, 0.88311688311688308,
0.72727272727272729, 0.5714285714285714, 0.53246753246753242,
1.1168831168831168, 0.77922077922077926, 0.76623376623376627,
0.8441558441558441, 0.74025974025974028, 0.92207792207792205,
0.90909090909090906, 0.64935064935064934, 0.62337662337662336,
0.58441558441558439, 0.8571428571428571, 0.8441558441558441,
0.74025974025974028, 0.68831168831168832, 0.5714285714285714,
0.92207792207792205, 0.8571428571428571, 0.79220779220779225,
0.77922077922077926, 0.74025974025974028, 0.74025974025974028,
0.8571428571428571, 0.81818181818181823, 0.79220779220779225,
0.70129870129870131, 0.88311688311688308, 0.63636363636363635,
0.92207792207792205, 0.63636363636363635, 0.97402597402597402,
0.96103896103896103, 0.8441558441558441, 0.77922077922077926,
0.96103896103896103, 0.59740259740259738, 0.68831168831168832,
0.92207792207792205, 0.89610389610389607, 0.8441558441558441,
0.75324675324675328, 0.72727272727272729, 0.70129870129870131,
0.97402597402597402, 0.94805194805194803, 0.92207792207792205,
0.90909090909090906, 0.87012987012987009, 0.80519480519480524,
0.80519480519480524, 0.72727272727272729, 0.70129870129870131,
0.70129870129870131, 0.64935064935064934, 1.0129870129870129,
0.97402597402597402, 0.8441558441558441, 0.81818181818181823,
0.74025974025974028, 0.8571428571428571, 0.81818181818181823,
0.67532467532467533, 0.94805194805194803, 0.88311688311688308,
0.94805194805194803, 0.92207792207792205, 0.89610389610389607,
0.88311688311688308, 0.7142857142857143, 0.5714285714285714,
0.7142857142857143, 0.58441558441558439, 0.54545454545454541,
0.89610389610389607, 0.87012987012987009, 0.72727272727272729,
0.8571428571428571, 0.8571428571428571, 0.5714285714285714, 1.0389610389610389,
0.80519480519480524, 0.66233766233766234, 0.75324675324675328,
0.8441558441558441, 0.87012987012987009, 0.62337662337662336,
0.97402597402597402, 0.7142857142857143, 0.67532467532467533,
0.75324675324675328, 0.96103896103896103, 0.51948051948051943,
0.72727272727272729, 0.7142857142857143, 0.7142857142857143,
0.68831168831168832, 0.92207792207792205, 0.87012987012987009,
0.83116883116883122, 0.80519480519480524, 0.75324675324675328,
0.80519480519480524, 0.79220779220779225, 0.62337662337662336,
0.61038961038961037, 0.70129870129870131, 0.92207792207792205,
0.81818181818181823, 0.87012987012987009, 0.87012987012987009,
0.80519480519480524, 0.8571428571428571, 0.54545454545454541,
0.90909090909090906, 0.72727272727272729, 0.88311688311688308,
0.7142857142857143, 0.62337662337662336, 0.81818181818181823,
0.77922077922077926, 0.62337662337662336, 0.8571428571428571,
0.83116883116883122, 0.70129870129870131, 0.63636363636363635,
1.1948051948051948, 0.88311688311688308, 0.81818181818181823,
0.76623376623376627, 0.63636363636363635, 0.98701298701298701,
0.93506493506493504, 0.87012987012987009, 0.80519480519480524,
0.59740259740259738, 0.5714285714285714, 0.92207792207792205,
0.89610389610389607, 0.83116883116883122, 0.83116883116883122,
0.68831168831168832, 0.7142857142857143, 0.93506493506493504,
0.90909090909090906, 0.89610389610389607, 0.77922077922077926,
0.61038961038961037, 0.5714285714285714, 0.96103896103896103,
0.74025974025974028, 0.58441558441558439, 0.94805194805194803,
0.77922077922077926, 0.8441558441558441, 0.58441558441558439,
0.93506493506493504, 0.88311688311688308, 0.75324675324675328,
0.74025974025974028, 0.66233766233766234, 0.72727272727272729,
0.92207792207792205, 0.75324675324675328, 0.94805194805194803,
0.70129870129870131, 0.58441558441558439, 0.88311688311688308,
0.8441558441558441, 0.77922077922077926, 0.53246753246753242,
0.55844155844155841, 0.87012987012987009, 0.80519480519480524,
0.66233766233766234, 0.77922077922077926, 0.93506493506493504,
0.88311688311688308, 0.68831168831168832, 0.93506493506493504,
0.80519480519480524, 0.76623376623376627, 0.68831168831168832,
0.68831168831168832, 0.67532467532467533, 0.63636363636363635,
0.8441558441558441, 0.87012987012987009, 0.76623376623376627,
0.76623376623376627, 0.67532467532467533, 0.96103896103896103,
0.94805194805194803, 0.80519480519480524, 0.67532467532467533,
1.0649350649350648, 0.79220779220779225, 0.76623376623376627,
0.64935064935064934, 0.66233766233766234, 1.025974025974026,
1, 0.8441558441558441, 0.7142857142857143, 0.93506493506493504,
0.64935064935064934, 0.93506493506493504, 0.8441558441558441,
0.72727272727272729, 0.98701298701298701, 0.8571428571428571,
0.80519480519480524, 0.79220779220779225, 0.75324675324675328,
0.70129870129870131, 0.96103896103896103, 0.89610389610389607,
0.79220779220779225, 0.70129870129870131, 0.81818181818181823,
0.80519480519480524, 0.98701298701298701, 0.94805194805194803,
0.70129870129870131, 0.61038961038961037, 0.70129870129870131,
0.88311688311688308, 0.74025974025974028, 0.80519480519480524,
0.67532467532467533, 0.72727272727272729, 0.67532467532467533,
0.72727272727272729, 0.66233766233766234, 0.8571428571428571,
0.97402597402597402, 0.97402597402597402, 0.92207792207792205,
0.81818181818181823, 0.79220779220779225, 0.92207792207792205,
0.74025974025974028, 0.72727272727272729, 0.64935064935064934,
0.93506493506493504, 0.90909090909090906, 0.8571428571428571,
0.77922077922077926, 0.93506493506493504, 0.88311688311688308,
0.83116883116883122, 0.70129870129870131, 0.98701298701298701,
0.70129870129870131, 0.62337662337662336, 0.96103896103896103,
0.89610389610389607, 0.94805194805194803, 0.72727272727272729,
1.1168831168831168, 0.89610389610389607, 0.79220779220779225,
0.76623376623376627, 0.75324675324675328, 0.72727272727272729,
0.63636363636363635, 0.54545454545454541, 0.8441558441558441,
0.92207792207792205, 0.66233766233766234, 0.98701298701298701,
0.74025974025974028, 0.96103896103896103, 0.75324675324675328,
0.72727272727272729, 0.8441558441558441, 0.83116883116883122,
0.79220779220779225, 0.96103896103896103, 0.63636363636363635,
0.74025974025974028, 1.025974025974026, 0.96103896103896103,
0.74025974025974028, 0.72727272727272729, 0.72727272727272729,
0.59740259740259738, 0.94805194805194803, 0.8441558441558441,
0.74025974025974028, 0.72727272727272729, 0.64935064935064934,
0.5714285714285714, 0.83116883116883122, 0.88311688311688308,
0.8441558441558441, 0.79220779220779225, 0.64935064935064934,
0.66233766233766234, 0.96103896103896103, 0.92207792207792205,
0.70129870129870131, 0.53246753246753242, 0.83116883116883122,
0.63636363636363635, 0.61038961038961037, 0.88311688311688308,
0.8571428571428571, 0.8441558441558441, 0.81818181818181823,
0.63636363636363635, 0.87012987012987009, 0.8441558441558441,
0.79220779220779225, 0.87012987012987009, 0.8571428571428571,
0.54545454545454541, 1.0129870129870129, 0.98701298701298701,
0.97402597402597402, 0.93506493506493504, 0.93506493506493504,
0.58441558441558439, 0.64935064935064934, 1.1428571428571428,
0.88311688311688308, 0.76623376623376627, 0.74025974025974028,
0.59740259740259738, 0.8441558441558441, 0.77922077922077926,
0.75324675324675328, 0.88311688311688308, 0.77922077922077926,
0.66233766233766234, 0.83116883116883122, 0.75324675324675328,
0.55844155844155841, 0.80519480519480524, 0.59740259740259738,
0.79220779220779225, 0.75324675324675328, 0.7142857142857143,
0.67532467532467533, 0.66233766233766234, 0.90909090909090906,
0.80519480519480524, 0.75324675324675328, 0.5714285714285714,
0.97402597402597402, 0.92207792207792205, 0.90909090909090906,
0.81818181818181823, 0.8441558441558441, 0.55844155844155841,
0.98701298701298701, 0.8571428571428571, 0.83116883116883122,
1.0129870129870129, 0.94805194805194803, 1.0649350649350648,
0.68831168831168832, 0.66233766233766234, 0.63636363636363635,
0.7142857142857143, 0.81818181818181823, 0.75324675324675328,
0.7142857142857143, 0.7142857142857143, 0.68831168831168832,
0.96103896103896103, 0.94805194805194803, 0.93506493506493504,
0.92207792207792205, 0.72727272727272729, 0.79220779220779225,
0.76623376623376627, 0.76623376623376627, 0.76623376623376627,
0.76623376623376627, 0.63636363636363635, 0.53246753246753242,
0.75324675324675328, 0.75324675324675328, 0.70129870129870131,
0.70129870129870131, 0.98701298701298701, 0.89610389610389607,
0.8441558441558441, 0.70129870129870131, 0.67532467532467533,
0.66233766233766234, 0.79220779220779225, 0.77922077922077926,
0.76623376623376627, 0.76623376623376627, 0.74025974025974028,
0.67532467532467533, 0.88311688311688308, 0.8441558441558441,
0.72727272727272729, 0.58441558441558439, 0.83116883116883122,
0.70129870129870131, 0.68831168831168832, 0.64935064935064934,
0.75324675324675328, 0.7142857142857143, 0.7142857142857143,
0.64935064935064934, 0.98701298701298701, 0.81818181818181823,
0.77922077922077926, 0.64935064935064934, 0.59740259740259738,
0.51948051948051943, 0.75324675324675328, 0.74025974025974028,
0.72727272727272729, 1, 0.8571428571428571, 0.77922077922077926,
0.72727272727272729, 0.72727272727272729, 0.70129870129870131,
0.53246753246753242, 0.81818181818181823, 0.80519480519480524,
0.79220779220779225, 0.76623376623376627, 0.92207792207792205,
0.8441558441558441, 0.79220779220779225, 0.66233766233766234,
0.54545454545454541, 0.67532467532467533, 0.72727272727272729,
0.68831168831168832, 0.59740259740259738, 0.54545454545454541,
0.79220779220779225, 0.61038961038961037, 0.55844155844155841,
0.88311688311688308, 0.81818181818181823, 0.90909090909090906,
0.68831168831168832, 0.77922077922077926, 0.77922077922077926,
0.58441558441558439, 0.93506493506493504, 0.97402597402597402,
0.80519480519480524, 1.0129870129870129, 0.96103896103896103,
0.8571428571428571, 0.77922077922077926, 0.72727272727272729,
0.93506493506493504, 0.92207792207792205, 0.89610389610389607,
0.8571428571428571, 0.8441558441558441, 0.81818181818181823,
0.67532467532467533, 0.76623376623376627, 0.77922077922077926,
0.58441558441558439, 0.98701298701298701, 0.93506493506493504,
0.87012987012987009, 0.81818181818181823, 0.7142857142857143,
0.88311688311688308, 0.79220779220779225, 0.70129870129870131,
0.77922077922077926, 0.77922077922077926, 0.67532467532467533,
0.66233766233766234, 0.81818181818181823, 0.75324675324675328,
0.83116883116883122, 0.77922077922077926, 0.77922077922077926,
0.54545454545454541, 0.97402597402597402, 0.87012987012987009,
0.59740259740259738, 0.80519480519480524, 0.8571428571428571,
0.62337662337662336, 0.75324675324675328, 0.77922077922077926,
0.93506493506493504, 0.83116883116883122, 0.77922077922077926,
0.61038961038961037, 1, 1.0129870129870129, 0.93506493506493504,
1.0389610389610389, 0.97402597402597402, 1, 0.96103896103896103,
0.97402597402597402, 0.93506493506493504, 0.75324675324675328,
0.88311688311688308, 0.90909090909090906, 0.68831168831168832,
0.77922077922077926, 0.92207792207792205, 0.87012987012987009,
1.0649350649350648, 0.93506493506493504, 0.97402597402597402,
0.96103896103896103, 1, 0.77922077922077926, 0.88311688311688308,
0.81818181818181823, 0.96103896103896103, 0.90909090909090906,
0.8571428571428571, 0.8571428571428571, 0.80519480519480524,
0.76623376623376627, 0.7142857142857143, 0.83116883116883122,
0.63636363636363635, 0.93506493506493504, 0.79220779220779225,
0.92207792207792205, 0.90909090909090906, 0.8441558441558441,
0.94805194805194803, 0.89610389610389607, 0.88311688311688308,
0.75324675324675328, 0.67532467532467533, 0.66233766233766234,
0.93506493506493504, 0.97402597402597402, 0.67532467532467533,
0.89610389610389607, 1.051948051948052, 0.89610389610389607,
0.94805194805194803, 0.96103896103896103, 0.8571428571428571,
0.76623376623376627, 0.97402597402597402, 0.89610389610389607,
0.96103896103896103, 1.0129870129870129, 1.1038961038961039,
1.0129870129870129, 0.83116883116883122, 0.8441558441558441,
0.76623376623376627, 0.87012987012987009, 0.79220779220779225,
0.88311688311688308, 1.0129870129870129, 0.92207792207792205,
0.98701298701298701, 0.92207792207792205, 0.97402597402597402,
0.96103896103896103, 0.96103896103896103, 0.8571428571428571,
0.5714285714285714, 0.92207792207792205, 0.88311688311688308,
0.94805194805194803, 0.94805194805194803, 0.87012987012987009,
0.76623376623376627, 0.76623376623376627, 0.93506493506493504,
0.8571428571428571, 0.93506493506493504, 0.61038961038961037,
0.8441558441558441, 0.88311688311688308, 0.68831168831168832,
0.98701298701298701, 0.63636363636363635, 1, 0.79220779220779225,
0.83116883116883122, 0.72727272727272729, 0.76623376623376627,
1, 0.88311688311688308, 1.0129870129870129, 0.80519480519480524,
0.8441558441558441, 0.8441558441558441, 0.93506493506493504,
0.96103896103896103, 0.79220779220779225, 1.025974025974026,
1.0649350649350648, 1, 0.98701298701298701, 0.88311688311688308,
1, 0.76623376623376627, 0.92207792207792205, 0.96103896103896103,
1.051948051948052, 0.68831168831168832, 1.051948051948052, 0.87012987012987009,
1.0129870129870129, 0.88311688311688308, 0.8441558441558441,
0.90909090909090906, 0.68831168831168832, 1.0129870129870129,
0.92207792207792205, 0.70129870129870131, 0.92207792207792205,
0.87012987012987009, 0.72727272727272729, 0.80519480519480524,
0.67532467532467533, 0.8571428571428571, 0.88311688311688308,
0.96103896103896103, 0.90909090909090906, 0.75324675324675328,
0.89610389610389607, 0.88311688311688308, 0.98701298701298701,
0.8571428571428571, 0.87012987012987009, 0.68831168831168832,
0.81818181818181823, 0.70129870129870131, 1.0649350649350648,
1.0909090909090908, 0.98701298701298701, 0.97402597402597402,
1.0649350649350648, 0.7142857142857143, 1.1038961038961039, 0.68831168831168832,
0.90909090909090906, 0.8571428571428571, 0.75324675324675328,
0.97402597402597402, 0.81818181818181823, 0.88311688311688308,
0.77922077922077926, 0.88311688311688308, 0.76623376623376627,
0.89610389610389607, 0.88311688311688308, 0.98701298701298701,
0.8571428571428571, 0.98701298701298701, 0.93506493506493504,
0.8571428571428571, 1, 0.8571428571428571, 0.97402597402597402,
0.80519480519480524, 0.81818181818181823, 0.92207792207792205,
0.94805194805194803, 0.68831168831168832, 0.80519480519480524,
0.79220779220779225, 0.5714285714285714, 0.75324675324675328,
0.7142857142857143, 0.8571428571428571, 0.8571428571428571, 0.83116883116883122,
0.98701298701298701, 1.051948051948052, 0.97402597402597402,
0.75324675324675328, 0.7142857142857143, 0.80519480519480524,
0.87012987012987009, 0.88311688311688308, 0.79220779220779225,
0.8441558441558441, 0.81818181818181823, 0.68831168831168832,
0.68831168831168832, 0.77922077922077926, 0.7142857142857143,
0.88311688311688308, 0.55844155844155841, 0.96103896103896103,
0.77922077922077926, 0.8441558441558441, 0.87012987012987009,
1, 0.87012987012987009, 0.92207792207792205, 0.80519480519480524,
0.89610389610389607, 0.96103896103896103, 1.0129870129870129,
0.8441558441558441, 0.83116883116883122, 0.8571428571428571,
0.77922077922077926, 1.025974025974026, 0.87012987012987009,
0.90909090909090906, 0.8571428571428571, 1.0389610389610389,
0.68831168831168832, 0.87012987012987009, 0.75324675324675328,
0.88311688311688308, 0.94805194805194803, 0.93506493506493504,
0.75324675324675328, 0.8571428571428571, 0.79220779220779225,
0.88311688311688308, 0.96103896103896103, 1, 0.97402597402597402,
0.89610389610389607, 0.87012987012987009, 0.66233766233766234,
0.83116883116883122, 0.94805194805194803, 0.79220779220779225,
0.81818181818181823, 0.92207792207792205, 0.90909090909090906,
0.8571428571428571, 0.93506493506493504, 0.8441558441558441,
0.58441558441558439, 0.8441558441558441, 0.88311688311688308,
0.74025974025974028, 0.97402597402597402, 0.64935064935064934,
0.77922077922077926, 0.96103896103896103, 0.59740259740259738,
0.94805194805194803, 0.83116883116883122, 1, 0.66233766233766234,
0.61038961038961037, 0.80519480519480524, 0.67532467532467533,
0.74025974025974028, 0.8571428571428571, 0.79220779220779225,
0.7142857142857143, 0.87012987012987009, 0.98701298701298701,
0.89610389610389607, 0.70129870129870131, 1.0389610389610389,
1, 1.0129870129870129, 0.8571428571428571, 0.72727272727272729,
0.88311688311688308, 0.80519480519480524, 0.89610389610389607,
0.8441558441558441, 0.92207792207792205, 0.80519480519480524,
1.0649350649350648, 0.72727272727272729, 0.81818181818181823,
0.74025974025974028, 0.87012987012987009, 0.81818181818181823,
0.81818181818181823, 0.83116883116883122, 1.0649350649350648,
0.70129870129870131, 0.79220779220779225, 0.8441558441558441,
0.8441558441558441, 0.87012987012987009, 1.051948051948052, 0.81818181818181823,
0.8571428571428571, 0.68831168831168832, 0.89610389610389607,
0.93506493506493504, 0.89610389610389607, 0.93506493506493504,
1.0909090909090908, 1.051948051948052, 0.89610389610389607, 1.0779220779220779,
0.76623376623376627, 1.1298701298701299, 0.88311688311688308,
0.74025974025974028, 0.74025974025974028, 0.70129870129870131,
0.96103896103896103, 0.58441558441558439, 0.88311688311688308,
0.97402597402597402, 0.92207792207792205, 0.76623376623376627,
1.025974025974026, 0.63636363636363635, 0.96103896103896103,
0.8441558441558441, 0.94805194805194803, 0.88311688311688308,
0.63636363636363635, 0.8441558441558441, 0.70129870129870131,
0.92207792207792205, 0.62337662337662336, 0.90909090909090906,
1.1168831168831168, 1.051948051948052, 0.67532467532467533, 0.97402597402597402,
0.89610389610389607, 1.1558441558441559, 0.96103896103896103,
1, 0.79220779220779225, 0.88311688311688308, 0.83116883116883122,
0.61038961038961037, 1.1038961038961039, 1.025974025974026, 1.0649350649350648,
0.79220779220779225, 1.025974025974026, 0.80519480519480524,
0.98701298701298701, 0.8441558441558441, 1.0389610389610389,
0.72727272727272729, 1.0129870129870129, 0.88311688311688308,
0.87012987012987009, 0.8441558441558441, 1.051948051948052, 0.88311688311688308,
0.98701298701298701, 1.0129870129870129, 1.1168831168831168,
0.88311688311688308, 0.80519480519480524, 0.97402597402597402,
0.88311688311688308, 0.88311688311688308, 1.051948051948052,
1.1298701298701299, 0.97402597402597402, 0.98701298701298701,
0.90909090909090906, 0.87012987012987009, 0.80519480519480524,
1.0649350649350648, 1, 0.98701298701298701, 0.72727272727272729,
0.75324675324675328, 1, 0.80519480519480524, 0.89610389610389607,
0.8441558441558441, 1.0389610389610389, 0.87012987012987009,
1.025974025974026, 0.93506493506493504, 1, 0.8441558441558441,
0.92207792207792205, 0.8441558441558441, 0.76623376623376627,
0.87012987012987009, 0.77922077922077926, 0.81818181818181823,
0.80519480519480524, 1.1558441558441559, 0.92207792207792205,
0.83116883116883122, 0.97402597402597402, 0.96103896103896103,
1.025974025974026, 0.92207792207792205, 0.98701298701298701,
1.0129870129870129, 0.80519480519480524, 0.96103896103896103,
0.98701298701298701, 0.90909090909090906, 1.0389610389610389,
1.025974025974026, 0.83116883116883122, 0.87012987012987009,
0.92207792207792205, 0.79220779220779225, 1.0909090909090908,
0.89610389610389607, 1.0649350649350648, 0.8571428571428571,
0.98701298701298701, 0.83116883116883122, 0.74025974025974028,
0.94805194805194803, 1.1298701298701299, 0.81818181818181823,
0.92207792207792205, 0.98701298701298701, 1.1428571428571428,
0.67532467532467533, 0.76623376623376627, 0.79220779220779225,
0.92207792207792205, 1.0389610389610389, 1.0779220779220779,
1.051948051948052, 0.96103896103896103, 0.93506493506493504,
0.98701298701298701, 0.79220779220779225, 0.97402597402597402,
0.90909090909090906, 1.0129870129870129, 0.93506493506493504,
1.025974025974026, 0.92207792207792205, 0.94805194805194803,
0.96103896103896103, 0.97402597402597402, 0.92207792207792205,
0.66233766233766234, 0.94805194805194803, 0.87012987012987009,
1.0129870129870129, 0.97402597402597402, 1.025974025974026, 0.80519480519480524,
0.92207792207792205, 0.97402597402597402, 0.89610389610389607,
0.8441558441558441, 0.77922077922077926, 1, 1, 1.0129870129870129,
0.94805194805194803, 0.88311688311688308, 0.67532467532467533,
0.70129870129870131, 0.89610389610389607, 0.90909090909090906,
0.77922077922077926, 0.80519480519480524, 0.97402597402597402,
0.93506493506493504, 0.90909090909090906, 1, 0.79220779220779225,
0.51948051948051943, 1.0909090909090908, 0.66233766233766234,
0.98701298701298701, 1.0389610389610389, 0.68831168831168832,
0.79220779220779225, 0.80519480519480524, 0.76623376623376627,
1.0779220779220779, 0.93506493506493504, 0.92207792207792205,
0.98701298701298701, 0.90909090909090906, 0.92207792207792205,
0.94805194805194803, 0.90909090909090906, 0.88311688311688308,
0.79220779220779225, 1, 0.87012987012987009, 0.87012987012987009,
0.94805194805194803, 1.0129870129870129, 0.77922077922077926,
0.92207792207792205, 0.88311688311688308, 1.025974025974026,
0.96103896103896103, 0.8571428571428571, 0.93506493506493504,
0.63636363636363635, 0.98701298701298701, 0.98701298701298701,
0.88311688311688308, 0.90909090909090906, 1.0129870129870129,
0.98701298701298701, 0.88311688311688308, 0.90909090909090906,
0.89610389610389607, 0.88311688311688308, 1.0129870129870129,
0.94805194805194803, 0.68831168831168832, 1, 0.94805194805194803,
0.83116883116883122, 0.90909090909090906, 0.96103896103896103,
0.89610389610389607, 0.90909090909090906, 0.8441558441558441,
0.81818181818181823, 0.97402597402597402, 0.96103896103896103,
1, 1.051948051948052, 0.88311688311688308, 1.025974025974026,
0.8441558441558441, 0.90909090909090906, 0.98701298701298701,
1, 0.98701298701298701, 0.87012987012987009, 0.98701298701298701,
0.90909090909090906, 0.81818181818181823, 0.88311688311688308,
0.98701298701298701, 0.98701298701298701, 0.88311688311688308,
0.8441558441558441, 0.92207792207792205, 0.96103896103896103,
0.87012987012987009, 0.75324675324675328, 0.81818181818181823,
0.89610389610389607, 0.74025974025974028, 1, 1.0129870129870129,
0.74025974025974028, 0.96103896103896103, 0.92207792207792205,
0.87012987012987009, 0.97402597402597402, 0.93506493506493504,
0.89610389610389607, 0.8571428571428571, 0.8571428571428571,
1, 0.88311688311688308, 0.72727272727272729, 0.87012987012987009,
0.79220779220779225, 0.92207792207792205, 0.8571428571428571,
0.98701298701298701, 0.77922077922077926, 0.90909090909090906,
0.90909090909090906, 0.94805194805194803, 0.96103896103896103,
1, 1.0129870129870129, 0.72727272727272729, 0.97402597402597402,
0.90909090909090906, 0.79220779220779225, 0.96103896103896103,
0.88311688311688308, 0.42857142857142855, 0.8571428571428571,
0.97402597402597402, 0.68831168831168832, 0.75324675324675328,
0.8441558441558441, 0.96103896103896103, 0.74025974025974028,
1, 0.98701298701298701, 0.98701298701298701, 0.81818181818181823,
0.90909090909090906, 0.90909090909090906, 0.64935064935064934,
0.94805194805194803, 0.88311688311688308, 1, 0.89610389610389607,
0.70129870129870131, 0.96103896103896103, 0.90909090909090906,
0.66233766233766234, 0.87012987012987009, 1.051948051948052,
0.90909090909090906, 0.92207792207792205, 0.8571428571428571,
0.8441558441558441, 0.96103896103896103, 0.97402597402597402,
0.77922077922077926, 0.98701298701298701, 0.90909090909090906,
0.8441558441558441, 0.87012987012987009, 0.75324675324675328,
0.92207792207792205, 0.8441558441558441, 0.77922077922077926,
0.93506493506493504, 0.87012987012987009, 1.0129870129870129,
0.92207792207792205, 0.90909090909090906, 0.8571428571428571,
0.80519480519480524, 0.93506493506493504, 0.7142857142857143,
0.8441558441558441, 0.88311688311688308, 0.90909090909090906,
0.94805194805194803, 0.79220779220779225, 0.92207792207792205,
1.051948051948052, 0.92207792207792205, 0.64935064935064934,
0.94805194805194803, 0.66233766233766234, 0.77922077922077926,
1.0389610389610389, 1.025974025974026, 0.94805194805194803, 0.98701298701298701,
0.94805194805194803, 0.80519480519480524, 0.89610389610389607,
1.0389610389610389, 0.94805194805194803, 0.90909090909090906,
0.94805194805194803, 0.63636363636363635, 0.88311688311688308,
1, 0.83116883116883122, 0.92207792207792205, 1.0129870129870129,
0.83116883116883122, 0.61038961038961037, 0.79220779220779225,
0.93506493506493504, 1, 0.97402597402597402, 0.87012987012987009,
0.81818181818181823, 0.88311688311688308, 0.67532467532467533,
0.74025974025974028, 0.87012987012987009, 0.8571428571428571,
0.94805194805194803, 1.025974025974026, 0.93506493506493504,
0.72727272727272729, 0.96103896103896103, 0.92207792207792205,
0.77922077922077926, 1, 0.96103896103896103, 1, 0.88311688311688308,
0.72727272727272729, 0.93506493506493504, 0.96103896103896103,
0.98701298701298701, 1.025974025974026, 0.77922077922077926,
0.77922077922077926, 0.88311688311688308, 0.76623376623376627,
0.77922077922077926, 0.89610389610389607, 1, 0.67532467532467533,
0.7142857142857143, 0.75324675324675328, 0.53246753246753242,
0.77922077922077926, 0.87012987012987009, 0.92207792207792205,
0.93506493506493504, 0.76623376623376627, 0.90909090909090906,
1.0129870129870129, 1, 0.89610389610389607, 0.77922077922077926,
1.0129870129870129, 1.0389610389610389, 1.0129870129870129, 0.79220779220779225,
1.0389610389610389, 0.98701298701298701, 0.94805194805194803,
0.94805194805194803, 0.89610389610389607, 0.97402597402597402,
0.93506493506493504, 0.97402597402597402, 0.89610389610389607,
0.92207792207792205, 0.94805194805194803, 0.90909090909090906,
0.97402597402597402, 0.93506493506493504, 0.67532467532467533,
0.92207792207792205, 1.0129870129870129, 0.83116883116883122,
0.89610389610389607, 0.79220779220779225, 0.79220779220779225,
0.74025974025974028, 0.72727272727272729, 0.7142857142857143,
0.83116883116883122, 0.81818181818181823, 0.70129870129870131,
0.64935064935064934, 0.66233766233766234, 1.0909090909090908,
0.97402597402597402, 0.83116883116883122, 0.64935064935064934,
0.70129870129870131, 0.74025974025974028, 0.8441558441558441,
0.81818181818181823, 1.0389610389610389, 0.76623376623376627,
0.81818181818181823, 0.8441558441558441, 0.74025974025974028,
0.77922077922077926, 0.8571428571428571, 0.72727272727272729,
0.68831168831168832, 0.80519480519480524, 0.89610389610389607,
1, 0.75324675324675328, 0.98701298701298701, 0.79220779220779225,
0.74025974025974028, 0.77922077922077926, 1, 0.80519480519480524,
0.94805194805194803, 0.83116883116883122, 0.76623376623376627,
0.89610389610389607, 0.90909090909090906, 0.50649350649350644,
0.89610389610389607, 0.7142857142857143, 0.77922077922077926,
0.74025974025974028, 0.96103896103896103, 0.74025974025974028,
0.7142857142857143, 0.96103896103896103, 0.66233766233766234,
0.80519480519480524, 0.88311688311688308, 0.7142857142857143,
0.72727272727272729, 0.77922077922077926, 0.75324675324675328,
0.80519480519480524, 0.94805194805194803, 0.8441558441558441,
0.7142857142857143, 0.77922077922077926, 0.88311688311688308,
0.89610389610389607, 0.77922077922077926, 0.80519480519480524,
0.98701298701298701, 0.81818181818181823, 0.7142857142857143,
0.74025974025974028, 0.72727272727272729, 0.94805194805194803,
0.94805194805194803, 0.8571428571428571, 0.80519480519480524,
0.64935064935064934, 0.76623376623376627, 0.83116883116883122,
0.74025974025974028, 0.80519480519480524, 0.81818181818181823,
0.67532467532467533, 1.0129870129870129, 0.98701298701298701,
1.025974025974026, 1.0779220779220779, 1.0389610389610389, 1.0129870129870129,
0.8571428571428571, 1.0649350649350648, 0.79220779220779225,
0.83116883116883122, 1.0129870129870129, 0.79220779220779225,
1, 0.96103896103896103, 0.80519480519480524, 0.98701298701298701,
0.90909090909090906, 0.98701298701298701, 0.89610389610389607,
0.98701298701298701, 1, 1.0389610389610389, 0.93506493506493504,
0.75324675324675328, 0.8571428571428571, 1.0779220779220779,
0.94805194805194803, 1, 1.025974025974026, 1.1428571428571428,
0.7142857142857143, 1, 0.87012987012987009, 0.87012987012987009,
0.8441558441558441, 0.58441558441558439, 1.0779220779220779,
0.92207792207792205, 1.0129870129870129, 1.0389610389610389,
0.62337662337662336, 1.0389610389610389, 0.98701298701298701,
0.64935064935064934, 0.87012987012987009, 1.0909090909090908,
0.88311688311688308, 0.87012987012987009, 0.87012987012987009,
0.87012987012987009, 0.96103896103896103, 0.94805194805194803,
0.98701298701298701, 1, 0.96103896103896103, 0.97402597402597402,
0.88311688311688308, 1.0129870129870129, 0.93506493506493504,
1.0649350649350648, 0.88311688311688308, 1.1428571428571428,
0.81818181818181823, 0.96103896103896103, 1.0389610389610389,
0.97402597402597402, 1.0129870129870129, 0.74025974025974028,
0.90909090909090906, 1.1298701298701299, 0.87012987012987009,
1, 0.76623376623376627, 1.0129870129870129, 0.90909090909090906,
1.025974025974026, 0.8441558441558441, 0.97402597402597402, 0.89610389610389607,
0.76623376623376627, 0.83116883116883122, 0.76623376623376627,
1, 0.90909090909090906, 0.98701298701298701, 0.92207792207792205,
1, 0.67532467532467533, 0.96103896103896103, 1.0129870129870129,
0.75324675324675328, 0.88311688311688308, 0.67532467532467533,
1.025974025974026, 0.81818181818181823, 0.89610389610389607,
0.93506493506493504, 0.8571428571428571, 0.98701298701298701,
0.87012987012987009, 0.89610389610389607, 0.83116883116883122,
0.94805194805194803, 0.83116883116883122, 0.70129870129870131,
0.88311688311688308, 0.80519480519480524, 0.72727272727272729,
0.92207792207792205, 0.93506493506493504, 0.76623376623376627,
1.0129870129870129, 0.93506493506493504, 0.92207792207792205,
0.94805194805194803, 0.81818181818181823, 1.0129870129870129,
0.89610389610389607, 0.88311688311688308, 0.66233766233766234,
0.66233766233766234, 0.90909090909090906, 0.92207792207792205,
0.88311688311688308, 1.0129870129870129, 0.8441558441558441,
0.8441558441558441, 0.88311688311688308, 0.98701298701298701,
0.97402597402597402, 1.0649350649350648, 1.0129870129870129,
0.81818181818181823, 0.97402597402597402, 0.92207792207792205,
0.89610389610389607, 1.0389610389610389, 0.96103896103896103,
0.96103896103896103, 0.92207792207792205, 0.92207792207792205,
0.90909090909090906, 0.87012987012987009, 1.1038961038961039,
0.93506493506493504, 0.79220779220779225, 0.83116883116883122,
0.72727272727272729, 0.76623376623376627, 0.92207792207792205,
0.80519480519480524, 1.025974025974026, 0.72727272727272729,
0.8441558441558441, 0.81818181818181823, 0.87012987012987009,
0.89610389610389607, 0.81818181818181823, 1.0129870129870129,
0.90909090909090906, 0.76623376623376627, 0.64935064935064934,
0.90909090909090906, 0.8441558441558441, 0.79220779220779225,
0.8571428571428571, 1.025974025974026, 0.92207792207792205, 0.8441558441558441,
0.8441558441558441, 0.88311688311688308, 1.0129870129870129,
0.8571428571428571, 0.8441558441558441, 0.90909090909090906,
0.81818181818181823, 1, 0.90909090909090906, 0.5714285714285714,
0.88311688311688308, 0.72727272727272729, 0.81818181818181823,
0.7142857142857143, 0.7142857142857143, 0.97402597402597402,
0.89610389610389607, 0.96103896103896103, 0.8441558441558441,
0.74025974025974028, 1, 0.89610389610389607, 0.67532467532467533,
0.94805194805194803, 0.92207792207792205, 0.50649350649350644,
0.89610389610389607, 0.87012987012987009, 0.58441558441558439,
0.97402597402597402, 0.80519480519480524, 1.0129870129870129,
0.88311688311688308, 0.8571428571428571, 0.4935064935064935,
1.0129870129870129, 0.88311688311688308, 1.025974025974026, 0.8441558441558441,
0.68831168831168832, 0.81818181818181823, 0.88311688311688308,
0.8571428571428571, 0.96103896103896103, 0.88311688311688308,
0.80519480519480524, 0.88311688311688308, 0.88311688311688308,
0.7142857142857143, 0.80519480519480524, 0.87012987012987009,
0.83116883116883122, 0.62337662337662336, 0.51948051948051943,
0.93506493506493504, 0.74025974025974028, 1.0779220779220779,
0.94805194805194803, 0.74025974025974028, 0.90909090909090906,
0.89610389610389607, 0.44155844155844154, 0.87012987012987009,
0.81818181818181823, 0.94805194805194803, 0.64935064935064934,
1.0389610389610389, 0.96103896103896103, 0.92207792207792205,
0.80519480519480524, 0.89610389610389607, 0.8441558441558441,
0.87012987012987009, 0.70129870129870131, 0.92207792207792205,
1.0779220779220779, 0.80519480519480524, 0.96103896103896103,
1, 0.97402597402597402, 0.90909090909090906, 0.75324675324675328,
1.025974025974026, 0.97402597402597402, 0.67532467532467533,
0.83116883116883122, 0.8441558441558441, 1.0779220779220779,
0.88311688311688308, 0.80519480519480524, 0.97402597402597402,
0.81818181818181823, 0.88311688311688308, 0.88311688311688308,
0.81818181818181823, 0.96103896103896103, 0.77922077922077926,
0.97402597402597402, 0.72727272727272729, 0.76623376623376627,
0.8441558441558441, 1.051948051948052, 0.70129870129870131, 0.8441558441558441,
0.70129870129870131, 0.89610389610389607, 0.97402597402597402,
1, 0.7142857142857143, 1, 0.88311688311688308, 0.92207792207792205,
0.8571428571428571, 0.98701298701298701, 0.93506493506493504,
0.98701298701298701, 0.88311688311688308, 0.81818181818181823,
0.89610389610389607, 0.70129870129870131, 0.81818181818181823,
0.81818181818181823, 0.55844155844155841, 0.94805194805194803,
0.77922077922077926, 0.98701298701298701, 0.68831168831168832,
0.88311688311688308, 0.79220779220779225, 0.80519480519480524,
0.98701298701298701, 0.70129870129870131, 0.7142857142857143,
0.80519480519480524, 0.96103896103896103, 0.45454545454545453,
0.81818181818181823, 0.74025974025974028, 0.77922077922077926,
0.94805194805194803, 0.68831168831168832, 1.1168831168831168,
0.94805194805194803, 0.76623376623376627, 0.81818181818181823,
0.89610389610389607, 1, 0.90909090909090906, 0.90909090909090906,
0.81818181818181823, 0.64935064935064934, 0.8441558441558441,
0.75324675324675328, 0.87012987012987009, 1.0129870129870129,
0.87012987012987009, 0.89610389610389607, 0.98701298701298701,
0.96103896103896103, 0.8441558441558441, 0.90909090909090906,
0.76623376623376627, 0.93506493506493504, 0.63636363636363635,
0.59740259740259738, 0.75324675324675328, 0.79220779220779225,
0.8571428571428571, 0.97402597402597402, 0.92207792207792205,
0.87012987012987009, 0.7142857142857143, 0.8441558441558441,
0.59740259740259738, 0.59740259740259738, 1.025974025974026,
0.8441558441558441, 0.8441558441558441, 0.90909090909090906,
0.8571428571428571, 0.66233766233766234, 0.7142857142857143,
0.89610389610389607, 0.5714285714285714, 0.61038961038961037,
1, 0.97402597402597402, 0.83116883116883122, 0.66233766233766234,
1.025974025974026, 1.0129870129870129, 0.77922077922077926, 1.051948051948052,
0.97402597402597402, 0.98701298701298701, 0.8571428571428571,
0.83116883116883122, 1.0649350649350648, 0.88311688311688308,
0.8441558441558441, 1.1428571428571428, 0.98701298701298701,
0.83116883116883122, 0.83116883116883122, 1.0129870129870129,
0.98701298701298701, 0.72727272727272729, 0.94805194805194803,
0.76623376623376627, 0.90909090909090906, 1, 0.75324675324675328,
1.051948051948052, 0.68831168831168832, 0.92207792207792205,
0.83116883116883122, 1.0389610389610389, 1.0129870129870129,
0.97402597402597402, 0.87012987012987009, 1.051948051948052,
1, 0.88311688311688308, 1.0129870129870129, 0.98701298701298701,
0.92207792207792205, 1.1038961038961039, 0.76623376623376627,
1.025974025974026, 0.92207792207792205, 1.0909090909090908, 0.97402597402597402,
1, 0.81818181818181823, 0.87012987012987009, 1.051948051948052,
1.1038961038961039, 0.87012987012987009, 0.98701298701298701,
0.96103896103896103, 0.74025974025974028, 0.97402597402597402,
0.62337662337662336, 0.98701298701298701, 0.72727272727272729,
0.81818181818181823, 0.88311688311688308, 1.1038961038961039,
0.97402597402597402, 0.97402597402597402, 0.83116883116883122,
1.0649350649350648, 0.87012987012987009, 0.5714285714285714,
0.79220779220779225, 0.88311688311688308, 0.8441558441558441,
0.97402597402597402, 0.97402597402597402, 1.0129870129870129,
1.0649350649350648, 0.94805194805194803, 0.62337662337662336,
1.0779220779220779, 0.7142857142857143, 0.94805194805194803,
1.1298701298701299, 0.96103896103896103, 0.8441558441558441,
0.92207792207792205, 1, 0.90909090909090906, 1.1038961038961039,
1, 0.83116883116883122, 0.88311688311688308, 1.0779220779220779,
0.92207792207792205, 0.98701298701298701, 1.0389610389610389,
0.77922077922077926, 0.97402597402597402, 0.96103896103896103,
0.79220779220779225, 0.97402597402597402, 0.96103896103896103,
0.8571428571428571, 1.0649350649350648, 0.93506493506493504,
1.1558441558441559, 1.0129870129870129, 0.98701298701298701,
1.1428571428571428, 0.83116883116883122, 1.0389610389610389,
0.96103896103896103, 0.88311688311688308, 0.79220779220779225,
0.90909090909090906, 0.77922077922077926, 0.68831168831168832,
0.81818181818181823, 0.98701298701298701, 0.8571428571428571,
0.98701298701298701, 1.025974025974026, 1.0649350649350648, 1.0649350649350648,
0.94805194805194803, 0.94805194805194803, 1.0129870129870129,
0.89610389610389607, 1.051948051948052, 0.81818181818181823,
0.63636363636363635, 0.8441558441558441, 1.0129870129870129,
1.0649350649350648, 1.025974025974026, 1, 0.92207792207792205,
0.93506493506493504, 0.94805194805194803, 0.87012987012987009,
1.025974025974026, 0.83116883116883122, 0.96103896103896103,
0.89610389610389607, 0.96103896103896103, 0.89610389610389607,
0.87012987012987009, 0.88311688311688308, 1.0389610389610389,
1.1298701298701299, 0.96103896103896103, 1.1818181818181819,
1.0909090909090908, 0.88311688311688308, 0.92207792207792205,
0.94805194805194803, 1.0779220779220779, 0.87012987012987009,
0.81818181818181823, 0.68831168831168832, 0.79220779220779225,
1.0779220779220779, 0.81818181818181823, 0.76623376623376627,
1.025974025974026, 0.88311688311688308, 0.96103896103896103,
0.8441558441558441, 0.8571428571428571, 1, 0.93506493506493504,
1.0779220779220779, 0.90909090909090906, 0.77922077922077926,
0.97402597402597402, 0.88311688311688308, 1.0389610389610389,
0.75324675324675328, 0.90909090909090906, 0.81818181818181823,
0.90909090909090906, 1.1428571428571428, 0.79220779220779225,
1.0779220779220779, 1.1168831168831168, 1.0129870129870129, 1.0389610389610389,
0.89610389610389607, 1, 0.8571428571428571, 0.96103896103896103,
1, 1.0389610389610389, 1.1558441558441559, 0.8571428571428571,
0.80519480519480524, 0.79220779220779225, 1, 0.94805194805194803,
1.025974025974026, 0.8571428571428571, 0.72727272727272729, 0.97402597402597402,
0.80519480519480524, 0.94805194805194803, 1.0129870129870129,
0.97402597402597402, 0.93506493506493504, 0.67532467532467533,
1.0779220779220779, 0.8571428571428571, 0.72727272727272729,
0.79220779220779225, 1.1428571428571428, 0.81818181818181823,
1.1558441558441559, 0.89610389610389607, 0.92207792207792205,
0.88311688311688308, 0.66233766233766234, 0.80519480519480524,
0.94805194805194803, 0.89610389610389607, 0.94805194805194803,
0.83116883116883122, 0.68831168831168832, 0.8441558441558441,
0.88311688311688308, 0.93506493506493504, 0.70129870129870131,
0.96103896103896103, 0.88311688311688308, 0.81818181818181823,
0.83116883116883122, 0.93506493506493504, 0.75324675324675328,
0.72727272727272729, 0.93506493506493504, 0.81818181818181823,
0.87012987012987009, 0.8571428571428571, 0.75324675324675328,
0.77922077922077926, 0.94805194805194803, 0.97402597402597402,
0.8441558441558441, 0.59740259740259738, 0.88311688311688308,
0.80519480519480524, 0.8441558441558441, 0.83116883116883122,
0.97402597402597402, 0.80519480519480524, 0.94805194805194803,
0.89610389610389607, 0.80519480519480524, 0.93506493506493504,
0.88311688311688308, 0.83116883116883122, 0.97402597402597402,
0.97402597402597402, 0.77922077922077926, 0.90909090909090906,
0.88311688311688308, 0.98701298701298701, 0.92207792207792205,
0.75324675324675328, 1.025974025974026, 0.92207792207792205,
0.72727272727272729, 0.74025974025974028, 0.74025974025974028,
0.97402597402597402, 0.87012987012987009, 0.89610389610389607,
0.5714285714285714, 0.8571428571428571, 0.97402597402597402,
0.93506493506493504, 0.77922077922077926, 0.88311688311688308,
1.0389610389610389, 0.75324675324675328, 0.61038961038961037,
0.8441558441558441, 0.77922077922077926, 0.66233766233766234,
1.051948051948052, 0.63636363636363635, 0.81818181818181823,
0.79220779220779225, 0.79220779220779225, 0.70129870129870131,
0.97402597402597402, 0.70129870129870131, 1.0649350649350648,
0.98701298701298701, 0.5714285714285714, 0.8571428571428571,
0.64935064935064934, 1.051948051948052, 0.80519480519480524,
0.68831168831168832, 0.66233766233766234, 0.64935064935064934,
0.90909090909090906, 0.89610389610389607, 0.83116883116883122,
0.83116883116883122, 1.1428571428571428, 0.87012987012987009,
0.8571428571428571, 0.89610389610389607, 0.83116883116883122,
0.8441558441558441, 0.88311688311688308, 0.93506493506493504,
1.0389610389610389, 0.75324675324675328, 0.76623376623376627,
0.55844155844155841, 1.0129870129870129, 0.88311688311688308,
0.83116883116883122, 1, 0.89610389610389607, 0.72727272727272729,
0.68831168831168832, 0.77922077922077926, 0.94805194805194803,
0.83116883116883122, 0.79220779220779225, 0.80519480519480524,
0.92207792207792205, 1.025974025974026, 0.61038961038961037,
0.62337662337662336, 0.97402597402597402, 0.5714285714285714,
0.74025974025974028, 0.87012987012987009, 0.88311688311688308,
0.93506493506493504, 0.59740259740259738, 0.87012987012987009,
0.77922077922077926, 0.66233766233766234, 0.68831168831168832,
1.0389610389610389, 0.80519480519480524, 0.90909090909090906,
0.76623376623376627, 0.90909090909090906, 0.87012987012987009,
0.89610389610389607, 0.64935064935064934, 0.7142857142857143,
1.051948051948052, 0.94805194805194803, 0.87012987012987009,
0.8571428571428571, 0.80519480519480524, 0.72727272727272729,
0.8571428571428571, 0.76623376623376627, 0.79220779220779225,
0.83116883116883122, 0.79220779220779225, 0.7142857142857143,
0.70129870129870131, 0.90909090909090906, 0.7142857142857143,
0.75324675324675328, 0.79220779220779225, 0.68831168831168832,
0.89610389610389607, 0.74025974025974028, 0.98701298701298701,
0.76623376623376627, 0.94805194805194803, 0.64935064935064934,
1.0129870129870129, 0.92207792207792205, 0.74025974025974028,
0.76623376623376627, 0.96103896103896103, 0.88311688311688308,
0.93506493506493504, 0.81818181818181823, 1, 0.94805194805194803,
0.63636363636363635, 0.58441558441558439, 0.93506493506493504,
0.74025974025974028, 0.70129870129870131, 0.81818181818181823,
0.8571428571428571, 0.59740259740259738, 0.74025974025974028,
0.81818181818181823, 0.67532467532467533, 0.94805194805194803,
0.83116883116883122, 0.89610389610389607, 0.93506493506493504,
0.72727272727272729, 0.70129870129870131, 0.75324675324675328,
0.92207792207792205, 0.88311688311688308, 0.72727272727272729,
0.81818181818181823, 1.0389610389610389, 0.94805194805194803,
0.83116883116883122, 0.94805194805194803, 0.81818181818181823,
0.74025974025974028, 0.92207792207792205, 0.90909090909090906,
0.81818181818181823, 0.8571428571428571, 0.75324675324675328,
0.80519480519480524, 0.93506493506493504, 0.87012987012987009,
0.8441558441558441, 0.54545454545454541, 0.75324675324675328,
0.96103896103896103, 0.83116883116883122, 0.87012987012987009,
0.97402597402597402, 0.88311688311688308, 1, 0.66233766233766234,
0.93506493506493504, 0.94805194805194803, 0.72727272727272729,
1.0129870129870129, 0.70129870129870131, 0.93506493506493504,
0.67532467532467533, 0.93506493506493504, 0.81818181818181823,
0.81818181818181823, 0.88311688311688308, 0.59740259740259738,
0.89610389610389607, 0.98701298701298701, 0.8571428571428571,
0.93506493506493504, 0.8441558441558441, 0.66233766233766234,
0.59740259740259738, 0.58441558441558439, 0.7142857142857143,
0.79220779220779225, 1, 0.96103896103896103, 1.0129870129870129,
0.93506493506493504, 0.64935064935064934, 0.90909090909090906,
0.63636363636363635, 0.8441558441558441, 0.96103896103896103,
0.94805194805194803, 0.8571428571428571, 0.74025974025974028,
0.7142857142857143, 0.98701298701298701, 0.83116883116883122,
0.74025974025974028, 0.90909090909090906, 0.92207792207792205,
1.0129870129870129, 0.90909090909090906, 0.61038961038961037,
0.90909090909090906, 0.75324675324675328, 0.76623376623376627,
0.68831168831168832, 0.96103896103896103, 0.72727272727272729,
1, 0.79220779220779225, 0.87012987012987009, 0.67532467532467533,
0.90909090909090906, 0.76623376623376627, 0.75324675324675328,
0.87012987012987009, 0.62337662337662336, 0.61038961038961037,
0.8441558441558441, 0.7142857142857143, 0.88311688311688308,
0.83116883116883122, 0.88311688311688308, 0.8441558441558441,
0.97402597402597402, 1.025974025974026, 0.94805194805194803,
0.88311688311688308, 0.83116883116883122, 0.87012987012987009,
0.90909090909090906, 0.79220779220779225, 0.88311688311688308,
0.75324675324675328, 0.8571428571428571, 0.8571428571428571,
0.76623376623376627, 0.64935064935064934, 0.68831168831168832,
0.76623376623376627, 0.89610389610389607, 0.7142857142857143,
0.67532467532467533, 0.72727272727272729, 0.94805194805194803,
0.67532467532467533, 0.68831168831168832, 0.67532467532467533,
0.7142857142857143, 0.96103896103896103, 1.025974025974026, 0.80519480519480524,
0.83116883116883122, 0.93506493506493504, 0.94805194805194803,
1.025974025974026, 0.77922077922077926, 0.59740259740259738,
0.96103896103896103, 0.58441558441558439, 0.90909090909090906,
0.87012987012987009, 0.75324675324675328, 0.97402597402597402,
0.64935064935064934, 0.76623376623376627, 0.79220779220779225,
0.97402597402597402, 0.75324675324675328, 0.64935064935064934,
0.81818181818181823, 1.025974025974026, 0.72727272727272729,
0.75324675324675328, 0.7142857142857143, 0.75324675324675328,
0.87012987012987009, 0.89610389610389607, 1.051948051948052,
1.0389610389610389, 0.7142857142857143, 0.89610389610389607,
0.75324675324675328, 0.80519480519480524, 0.81818181818181823,
0.67532467532467533, 0.7142857142857143, 0.75324675324675328,
0.93506493506493504, 0.81818181818181823, 0.94805194805194803,
0.96103896103896103, 0.90909090909090906, 0.66233766233766234,
0.79220779220779225, 0.8441558441558441, 0.88311688311688308,
0.87012987012987009, 0.80519480519480524, 1, 0.63636363636363635,
0.79220779220779225, 0.66233766233766234, 0.94805194805194803,
0.8571428571428571, 0.81818181818181823, 0.66233766233766234,
0.92207792207792205, 0.74025974025974028, 0.72727272727272729,
0.51948051948051943, 0.8441558441558441, 0.87012987012987009,
0.8571428571428571, 1, 0.87012987012987009, 0.96103896103896103,
1.025974025974026, 0.87012987012987009, 0.90909090909090906,
0.74025974025974028, 0.7142857142857143, 0.75324675324675328,
1, 0.74025974025974028, 0.80519480519480524, 0.96103896103896103,
0.8441558441558441, 0.72727272727272729, 0.66233766233766234,
0.63636363636363635, 0.93506493506493504, 0.63636363636363635,
0.54545454545454541, 0.76623376623376627, 0.74025974025974028,
0.5714285714285714, 0.79220779220779225, 0.76623376623376627,
0.59740259740259738, 0.87012987012987009, 0.67532467532467533,
0.83116883116883122, 1.0389610389610389, 0.92207792207792205,
0.98701298701298701, 0.8441558441558441, 0.90909090909090906,
0.8571428571428571, 0.79220779220779225, 0.87012987012987009,
0.68831168831168832, 0.8441558441558441, 0.90909090909090906,
0.94805194805194803, 1, 0.92207792207792205, 0.77922077922077926,
0.96103896103896103, 0.81818181818181823, 0.58441558441558439,
0.64935064935064934, 0.88311688311688308, 0.93506493506493504,
0.80519480519480524, 0.81818181818181823, 1.1428571428571428,
0.94805194805194803, 0.68831168831168832, 0.96103896103896103,
0.83116883116883122, 0.68831168831168832, 0.75324675324675328,
0.83116883116883122, 0.81818181818181823, 0.5714285714285714,
0.88311688311688308, 0.80519480519480524, 0.8571428571428571,
0.63636363636363635, 0.66233766233766234, 0.89610389610389607,
0.79220779220779225, 0.79220779220779225, 0.92207792207792205,
0.96103896103896103, 0.92207792207792205, 1, 0.75324675324675328,
0.44155844155844154, 0.98701298701298701, 0.93506493506493504,
0.97402597402597402, 0.83116883116883122, 1.0389610389610389,
0.94805194805194803, 0.88311688311688308, 0.72727272727272729,
1.0389610389610389, 1.0129870129870129, 0.87012987012987009,
0.8441558441558441, 0.7142857142857143, 0.92207792207792205,
0.72727272727272729, 0.76623376623376627, 0.80519480519480524,
0.92207792207792205, 0.81818181818181823, 0.90909090909090906,
0.77922077922077926, 0.67532467532467533, 1, 0.70129870129870131,
0.72727272727272729, 0.88311688311688308, 0.96103896103896103,
1, 0.72727272727272729, 0.83116883116883122, 0.76623376623376627,
0.87012987012987009, 1.0129870129870129, 0.8441558441558441,
0.81818181818181823, 0.97402597402597402, 0.87012987012987009,
0.89610389610389607, 0.93506493506493504, 0.98701298701298701,
0.94805194805194803, 0.66233766233766234, 1.051948051948052,
0.8571428571428571, 0.83116883116883122, 0.77922077922077926,
0.75324675324675328, 0.64935064935064934, 0.74025974025974028,
0.81818181818181823, 0.67532467532467533, 0.54545454545454541,
0.7142857142857143, 0.8441558441558441, 0.97402597402597402,
0.87012987012987009, 0.97402597402597402, 0.72727272727272729,
0.8441558441558441, 0.92207792207792205, 0.87012987012987009,
0.63636363636363635, 0.8571428571428571, 0.72727272727272729,
1.025974025974026, 0.64935064935064934, 0.90909090909090906,
0.68831168831168832, 0.83116883116883122, 0.75324675324675328,
0.76623376623376627, 0.87012987012987009, 1.025974025974026,
0.81818181818181823, 1, 0.97402597402597402, 0.62337662337662336,
0.96103896103896103, 0.80519480519480524, 0.93506493506493504,
0.81818181818181823, 0.92207792207792205, 0.88311688311688308,
1.0649350649350648, 0.96103896103896103, 0.67532467532467533,
0.90909090909090906, 0.72727272727272729, 1.0649350649350648,
0.77922077922077926, 0.70129870129870131, 0.94805194805194803,
0.66233766233766234, 0.75324675324675328, 0.8441558441558441,
1.025974025974026, 0.90909090909090906, 0.72727272727272729,
0.97402597402597402, 0.67532467532467533, 0.76623376623376627,
0.81818181818181823, 0.80519480519480524, 0.58441558441558439,
0.66233766233766234, 0.87012987012987009, 0.68831168831168832,
0.72727272727272729, 0.74025974025974028, 0.93506493506493504,
0.75324675324675328, 0.92207792207792205, 0.94805194805194803,
0.87012987012987009, 0.98701298701298701, 0.70129870129870131,
0.83116883116883122, 0.92207792207792205, 0.77922077922077926,
0.94805194805194803, 0.7142857142857143, 0.55844155844155841,
0.92207792207792205, 0.76623376623376627, 0.81818181818181823,
0.96103896103896103, 0.77922077922077926, 0.8571428571428571,
0.83116883116883122, 0.77922077922077926, 0.72727272727272729,
0.59740259740259738, 0.70129870129870131, 1, 0.87012987012987009,
0.80519480519480524, 1.025974025974026, 0.90909090909090906,
0.88311688311688308, 0.97402597402597402, 0.75324675324675328,
0.93506493506493504, 0.81818181818181823, 0.67532467532467533,
0.75324675324675328, 0.70129870129870131, 0.83116883116883122,
0.70129870129870131, 0.54545454545454541, 0.75324675324675328,
0.54545454545454541, 0.76623376623376627, 0.55844155844155841,
0.67532467532467533, 0.89610389610389607, 0.8441558441558441,
0.70129870129870131, 0.75324675324675328, 0.74025974025974028,
0.75324675324675328, 0.83116883116883122, 0.8441558441558441,
1.025974025974026, 0.89610389610389607, 0.8441558441558441, 0.89610389610389607,
0.89610389610389607, 0.70129870129870131, 0.8441558441558441,
1.051948051948052, 0.77922077922077926, 0.88311688311688308,
0.98701298701298701, 0.89610389610389607, 0.92207792207792205,
1.0909090909090908, 0.8571428571428571, 0.70129870129870131,
0.70129870129870131, 0.66233766233766234, 0.70129870129870131,
0.61038961038961037, 0.70129870129870131, 0.8441558441558441,
0.88311688311688308, 0.79220779220779225, 0.87012987012987009,
0.96103896103896103, 0.7142857142857143, 0.76623376623376627,
0.87012987012987009, 0.75324675324675328, 0.85584415584415596,
0.62987012987012991, 0.7805194805194805, 0.84675324675324681,
0.61948051948051952, 0.86623376623376624, 0.99480519480519469,
1.0805194805194807, 0.7805194805194805, 0.76753246753246751,
0.91558441558441561, 1.0727272727272728, 0.65714285714285714,
0.80000000000000004, 0.9129870129870129, 0.49610389610389616,
0.61818181818181817, 0.96623376623376633, 0.52467532467532463,
0.66233766233766234, 0.68701298701298696, 0.59480519480519478,
0.74155844155844153, 0.75584415584415587, 0.95194805194805188,
0.69999999999999996, 0.73636363636363644, 0.88181818181818195,
0.82207792207792207, 0.54025974025974033, 0.83636363636363642,
0.93896103896103889, 0.75064935064935057, 0.76103896103896107,
0.81688311688311688, 0.74675324675324672, 0.87532467532467539,
0.82987012987012987, 0.86623376623376624, 0.75714285714285712,
0.58831168831168823, 0.79350649350649349, 0.35584415584415585,
0.6506493506493507, 0.78961038961038954, 0.7779220779220779,
0.99090909090909085, 0.80779220779220784, 0.61298701298701297,
0.82987012987012987, 0.69610389610389611, 0.53636363636363638,
0.82337662337662332, 0.58051948051948055, 0.9129870129870129,
0.80519480519480524, 0.65714285714285714, 0.86883116883116895,
0.86753246753246749, 0.84805194805194806, 0.94415584415584419,
0.42077922077922075, 0.80649350649350648, 0.74025974025974028,
0.7142857142857143, 0.95454545454545459, 0.7194805194805195,
0.69220779220779216, 1.0064935064935066, 0.76103896103896107,
0.82857142857142851, 0.71818181818181814, 0.75974025974025972,
0.61168831168831173, 0.70519480519480515, 0.81558441558441552,
0.86623376623376624, 0.69090909090909092, 0.98441558441558441,
0.75324675324675328, 0.79480519480519485, 0.83506493506493507,
0.91558441558441561, 0.97142857142857142, 0.59220779220779218,
0.64805194805194799, 0.47532467532467532, 0.74285714285714288,
0.83376623376623382, 0.83116883116883122, 0.67532467532467533,
0.75584415584415587, 0.62207792207792201, 0.62597402597402596,
0.65324675324675319, 0.61038961038961037, 0.71818181818181814,
0.60649350649350653, 0.51688311688311683, 0.8727272727272728,
0.96233766233766227, 0.79740259740259734, 0.65324675324675319,
0.87402597402597404, 0.76233766233766243, 0.78701298701298705,
0.60519480519480517, 0.64935064935064934, 0.68051948051948052,
0.89350649350649347, 0.59220779220779218, 0.87402597402597404,
0.99480519480519469, 0.66753246753246753, 0.65194805194805194,
0.82857142857142851, 0.81818181818181823, 0.7805194805194805,
0.62987012987012991, 0.65454545454545454, 0.88441558441558432,
0.59740259740259738, 0.70259740259740266, 0.8545454545454545,
0.90389610389610386, 0.85584415584415596, 0.7779220779220779,
0.59220779220779218, 0.70649350649350651, 0.68571428571428572,
0.81818181818181823, 0.76753246753246751, 0.68181818181818177,
0.58961038961038958, 0.64675324675324675, 0.82597402597402603,
0.75064935064935057, 0.635064935064935, 0.8597402597402598, 0.51558441558441559,
0.61168831168831173, 0.7831168831168831, 0.78441558441558434,
0.95324675324675334, 0.78961038961038954, 0.56233766233766225,
0.63766233766233771, 0.60000000000000009, 0.75844155844155847,
0.85584415584415596, 0.75064935064935057, 0.7116883116883117,
0.75064935064935057, 0.52987012987012982, 0.58181818181818179,
0.6558441558441559, 0.35064935064935066, 0.83246753246753236,
0.81168831168831168, 0.63376623376623376, 0.75324675324675328,
0.74155844155844153, 0.53896103896103897, 0.4935064935064935,
0.4987012987012987, 0.80519480519480524, 0.83246753246753236,
0.66233766233766234, 0.77922077922077926, 0.73506493506493509,
0.75064935064935057, 0.78181818181818186, 0.63376623376623376,
0.41168831168831166, 0.66363636363636369, 0.46623376623376622,
0.85844155844155834, 0.93246753246753245, 0.86623376623376624,
0.62857142857142856, 0.7220779220779221, 0.87792207792207788,
0.59610389610389614, 0.63896103896103895, 0.70129870129870131,
0.86623376623376624, 0.7168831168831169, 0.62597402597402596,
0.80389610389610389, 0.83896103896103891, 0.75584415584415587,
0.88571428571428579, 0.70259740259740266, 0.46103896103896103,
0.60129870129870122, 0.69610389610389611, 0.5, 0.60649350649350653,
0.56753246753246755, 0.60779220779220777, 0.58441558441558439,
0.80000000000000004, 0.70519480519480515, 0.74935064935064943,
0.65844155844155849, 0.64935064935064934, 0.88571428571428579,
0.82337662337662332, 0.49610389610389616, 0.79610389610389609,
0.65194805194805194, 0.46883116883116888, 0.58441558441558439,
0.79220779220779225, 0.44415584415584419, 0.5870129870129871,
0.6402597402597402, 0.59870129870129873, 0.70519480519480515,
0.67402597402597397, 0.49220779220779221, 0.84285714285714297,
0.9103896103896103, 0.92727272727272736, 0.56233766233766225,
0.81688311688311688, 0.79480519480519485, 0.34155844155844156,
0.86103896103896105, 0.73506493506493509, 0.31558441558441558,
0.47662337662337667, 0.66103896103896098, 0.84285714285714297,
0.72987012987012989, 0.39480519480519477, 0.69350649350649352,
0.95974025974025978, 0.72467532467532458, 0.49090909090909085,
0.61948051948051952, 0.46883116883116888, 0.73376623376623373,
0.56753246753246755, 0.73766233766233757, 0.79610389610389609,
0.76883116883116887, 0.59350649350649354, 0.80779220779220784,
1.0233766233766233, 0.81948051948051948, 0.91948051948051945,
0.73896103896103893, 0.77272727272727271, 0.53506493506493513,
0.5051948051948052, 0.56493506493506496, 0.83506493506493507,
0.81818181818181823, 0.80519480519480524, 0.89610389610389607,
0.8571428571428571, 0.89610389610389607, 0.94805194805194803,
0.79220779220779225, 0.81818181818181823, 1.051948051948052,
0.61038961038961037, 0.62337662337662336, 0.72727272727272729,
0.8441558441558441, 0.93506493506493504, 0.77922077922077926,
0.98701298701298701, 0.8571428571428571, 0.90909090909090906,
0.80519480519480524, 0.61038961038961037, 0.97402597402597402,
0.93506493506493504, 0.75324675324675328, 0.88311688311688308,
0.81818181818181823, 0.8441558441558441, 0.75324675324675328,
0.77922077922077926, 0.90909090909090906, 0.7142857142857143,
0.81818181818181823, 0.8441558441558441, 0.97402597402597402,
0.88311688311688308, 0.8441558441558441, 0.64935064935064934,
0.88311688311688308, 0.92207792207792205, 0.76623376623376627,
0.80519480519480524, 0.90909090909090906, 1.0389610389610389,
1.0129870129870129, 0.89610389610389607, 0.76623376623376627,
0.97402597402597402, 0.58441558441558439, 0.76623376623376627,
0.79220779220779225, 0.93506493506493504, 0.90909090909090906,
0.76623376623376627, 0.76623376623376627, 0.67532467532467533,
0.88311688311688308, 0.90909090909090906, 0.76623376623376627,
0.62337662337662336, 0.76623376623376627, 0.64935064935064934,
0.98701298701298701, 0.90909090909090906, 0.83116883116883122,
0.75324675324675328, 0.81818181818181823, 0.61038961038961037,
0.75324675324675328, 0.83116883116883122, 0.64935064935064934,
1.0129870129870129, 0.81818181818181823, 0.66233766233766234,
0.83116883116883122, 0.98701298701298701, 0.94805194805194803,
0.96103896103896103, 0.72727272727272729, 0.8571428571428571,
0.94805194805194803, 0.88311688311688308, 0.97402597402597402,
0.88311688311688308, 0.75324675324675328, 0.8571428571428571,
0.89610389610389607, 0.81818181818181823, 0.89610389610389607,
0.83116883116883122, 0.96103896103896103, 0.93506493506493504,
0.98701298701298701, 0.8571428571428571, 0.77922077922077926,
0.83116883116883122, 0.68831168831168832, 0.63636363636363635,
0.66233766233766234, 0.97402597402597402, 0.8441558441558441,
0.59740259740259738, 0.75324675324675328, 0.68831168831168832,
0.94805194805194803, 0.76623376623376627, 0.89610389610389607,
0.80519480519480524, 0.80519480519480524, 0.72727272727272729,
0.75324675324675328, 0.83116883116883122, 0.79220779220779225,
0.90909090909090906, 0.81818181818181823, 0.87012987012987009,
0.75324675324675328, 0.79220779220779225, 0.96103896103896103,
0.79220779220779225, 0.80519480519480524, 0.77922077922077926,
0.89610389610389607, 0.8571428571428571, 0.90909090909090906,
0.75324675324675328, 0.70129870129870131, 0.76623376623376627,
0.67532467532467533, 0.87012987012987009, 0.89610389610389607,
0.79220779220779225, 0.89610389610389607, 0.90909090909090906,
0.89610389610389607, 0.8441558441558441, 0.68831168831168832,
0.87012987012987009, 0.8441558441558441, 0.89610389610389607,
0.8571428571428571, 0.8571428571428571, 0.83116883116883122,
1.0129870129870129, 0.93506493506493504, 1.025974025974026, 0.8441558441558441,
0.98701298701298701, 0.94805194805194803, 0.87012987012987009,
0.93506493506493504, 0.76623376623376627, 0.66233766233766234,
0.77922077922077926, 1.025974025974026, 0.8441558441558441, 0.8571428571428571,
0.89610389610389607, 0.88311688311688308, 0.7142857142857143,
0.8441558441558441, 0.89610389610389607, 0.90909090909090906,
0.89610389610389607, 0.90909090909090906, 0.94805194805194803,
0.83116883116883122, 0.76623376623376627, 0.8571428571428571,
0.8441558441558441, 0.79220779220779225, 0.93506493506493504,
0.66233766233766234, 0.90909090909090906, 0.83116883116883122,
0.7142857142857143, 0.76623376623376627, 0.87012987012987009,
0.7142857142857143, 0.77922077922077926, 0.70129870129870131,
0.81818181818181823, 0.87012987012987009, 0.8571428571428571,
0.87012987012987009, 0.70129870129870131, 0.72727272727272729,
1, 0.77922077922077926, 0.7142857142857143, 0.7142857142857143,
0.79220779220779225, 0.83116883116883122, 0.88311688311688308,
0.93506493506493504, 0.72727272727272729, 0.87012987012987009,
0.92207792207792205, 1.0389610389610389, 0.62337662337662336,
0.90909090909090906, 0.88311688311688308, 0.88311688311688308,
0.81818181818181823, 0.62337662337662336, 0.8441558441558441,
0.68831168831168832, 0.83116883116883122, 0.97402597402597402,
0.8441558441558441, 0.70129870129870131, 0.8441558441558441,
1.0129870129870129, 0.96103896103896103, 0.80519480519480524,
0.93506493506493504, 0.5714285714285714, 0.87012987012987009,
0.88311688311688308, 0.8441558441558441, 0.75324675324675328,
0.7142857142857143, 0.75324675324675328, 0.88311688311688308,
0.75324675324675328, 0.72727272727272729, 0.87012987012987009,
0.94805194805194803, 0.90909090909090906, 0.83116883116883122,
0.79220779220779225, 0.68831168831168832, 0.94805194805194803,
0.74025974025974028, 0.8571428571428571, 0.77922077922077926,
0.58441558441558439, 0.80519480519480524, 0.88311688311688308,
0.93506493506493504, 0.74025974025974028, 0.90909090909090906,
0.93506493506493504, 0.89610389610389607, 0.7142857142857143,
0.80519480519480524, 0.88311688311688308, 0.96103896103896103,
1, 0.92207792207792205, 0.8571428571428571, 0.59740259740259738,
0.90909090909090906, 0.8571428571428571, 0.96103896103896103,
0.92207792207792205, 0.72727272727272729, 0.8441558441558441,
0.70129870129870131, 0.77922077922077926, 0.8571428571428571,
0.80519480519480524, 0.79220779220779225, 0.93506493506493504,
0.8441558441558441, 0.7142857142857143, 0.87012987012987009,
0.77922077922077926, 1.0129870129870129, 0.76623376623376627,
0.90909090909090906, 0.92207792207792205, 0.8441558441558441,
0.89610389610389607, 0.68831168831168832, 0.83116883116883122,
0.70129870129870131, 0.62337662337662336, 0.90909090909090906,
0.93506493506493504, 1.025974025974026, 0.93506493506493504,
0.7142857142857143, 0.79220779220779225, 0.62337662337662336,
0.79220779220779225, 0.89610389610389607, 0.7142857142857143,
0.89610389610389607, 0.83116883116883122, 0.96103896103896103,
0.75324675324675328, 0.74025974025974028, 0.8441558441558441,
0.77922077922077926, 0.59740259740259738, 0.8441558441558441,
0.81818181818181823, 0.8571428571428571, 0.63636363636363635,
0.81818181818181823, 0.83116883116883122, 0.80519480519480524,
0.90909090909090906, 1, 0.81818181818181823, 0.93506493506493504,
0.94805194805194803, 0.77922077922077926, 0.96103896103896103,
0.63636363636363635, 0.8441558441558441, 0.8441558441558441,
0.72727272727272729, 0.67532467532467533, 0.80519480519480524,
0.88311688311688308, 0.87012987012987009, 0.93506493506493504,
0.90909090909090906, 0.76623376623376627, 0.92207792207792205,
0.89610389610389607, 0.92207792207792205, 0.66233766233766234,
0.67532467532467533, 0.93506493506493504, 0.83116883116883122,
0.87012987012987009, 0.72727272727272729, 0.74025974025974028,
0.59740259740259738, 0.89610389610389607, 0.67532467532467533,
0.90909090909090906, 0.64935064935064934, 0.8571428571428571,
0.80519480519480524, 0.7142857142857143, 0.8441558441558441,
0.8571428571428571, 0.8441558441558441, 0.76623376623376627,
0.68831168831168832, 0.67532467532467533, 0.97402597402597402,
0.8571428571428571, 0.93506493506493504, 0.79220779220779225,
0.87012987012987009, 0.87012987012987009, 1, 0.79220779220779225,
0.89610389610389607, 0.90909090909090906, 0.97402597402597402,
0.81818181818181823, 0.96103896103896103, 0.67532467532467533,
0.94805194805194803, 0.90909090909090906, 1.025974025974026,
0.87012987012987009, 0.94805194805194803, 0.98701298701298701,
0.80519480519480524, 0.74025974025974028, 0.83116883116883122,
0.8441558441558441, 0.92207792207792205, 0.7142857142857143,
0.92207792207792205, 0.92207792207792205, 0.7142857142857143,
0.8571428571428571, 1, 0.89610389610389607, 0.64935064935064934,
0.67532467532467533, 0.88311688311688308, 0.80519480519480524,
0.80519480519480524, 0.92207792207792205, 0.96103896103896103,
0.75324675324675328, 0.8441558441558441, 0.77922077922077926,
0.94805194805194803, 0.98701298701298701, 0.94805194805194803,
0.59740259740259738, 0.97402597402597402, 0.72727272727272729,
0.90909090909090906, 1.0129870129870129, 0.72727272727272729,
0.76623376623376627, 0.61038961038961037, 0.92207792207792205,
0.88311688311688308, 0.83116883116883122, 0.88311688311688308,
0.79220779220779225, 0.8571428571428571, 0.79220779220779225,
0.92207792207792205, 0.64935064935064934, 0.8441558441558441,
0.59740259740259738, 0.93506493506493504, 0.92207792207792205,
0.87012987012987009, 0.98701298701298701, 0.94805194805194803,
0.89610389610389607, 0.66233766233766234, 0.87012987012987009,
0.80519480519480524, 0.92207792207792205, 0.97402597402597402,
0.90909090909090906, 0.72727272727272729, 0.93506493506493504,
0.75324675324675328, 0.87012987012987009, 0.94805194805194803,
0.80519480519480524, 0.7142857142857143, 0.72727272727272729,
0.92207792207792205, 0.98701298701298701, 0.59740259740259738,
0.89610389610389607, 0.98701298701298701, 0.97402597402597402,
0.8441558441558441, 0.64935064935064934, 1.0389610389610389,
0.8571428571428571, 0.66233766233766234, 0.70129870129870131,
0.81818181818181823, 0.87012987012987009, 0.66233766233766234,
0.83116883116883122, 0.8571428571428571, 0.58441558441558439,
0.80519480519480524, 0.89610389610389607, 0.83116883116883122,
0.81818181818181823, 0.67532467532467533, 0.70129870129870131,
0.90909090909090906, 0.77922077922077926, 0.76623376623376627,
0.90909090909090906, 0.77922077922077926, 0.89610389610389607,
1.0129870129870129, 0.67532467532467533, 0.66233766233766234,
0.72727272727272729, 0.8441558441558441, 0.89610389610389607,
0.94805194805194803, 0.67532467532467533, 0.77922077922077926,
0.81818181818181823, 0.66233766233766234, 0.87012987012987009,
0.92207792207792205, 0.92207792207792205, 0.59740259740259738,
0.88311688311688308, 0.88311688311688308, 0.87012987012987009,
0.88311688311688308, 0.81818181818181823, 0.92207792207792205,
0.77922077922077926, 0.68831168831168832, 0.74025974025974028,
0.83116883116883122, 0.8571428571428571, 0.59740259740259738,
0.92207792207792205, 0.77922077922077926, 1.0389610389610389,
0.97402597402597402, 0.8571428571428571, 0.94805194805194803,
0.94805194805194803, 0.68831168831168832, 1.025974025974026,
0.8571428571428571, 0.88311688311688308, 0.75324675324675328,
0.59740259740259738, 0.8571428571428571, 0.75324675324675328,
0.68831168831168832, 0.75324675324675328, 0.92207792207792205,
0.68831168831168832, 0.70129870129870131, 0.8571428571428571,
0.98701298701298701, 0.8571428571428571, 0.87012987012987009,
0.66233766233766234, 1, 0.87012987012987009, 0.8571428571428571,
0.79220779220779225, 0.83116883116883122, 0.98701298701298701,
0.7142857142857143, 0.8441558441558441, 0.88311688311688308,
0.89610389610389607, 0.58441558441558439, 0.96103896103896103,
0.83116883116883122, 0.62337662337662336, 0.77922077922077926,
0.83116883116883122, 0.70129870129870131, 0.67532467532467533,
0.88311688311688308, 0.61038961038961037, 0.98701298701298701,
0.98701298701298701, 0.88311688311688308, 0.8571428571428571,
0.81818181818181823, 0.58441558441558439, 0.92207792207792205,
0.79220779220779225, 0.92207792207792205, 0.94805194805194803,
0.88311688311688308, 0.80519480519480524, 0.75324675324675328,
0.76623376623376627, 0.77922077922077926, 0.90909090909090906,
0.77922077922077926, 0.90909090909090906, 0.94805194805194803,
0.97402597402597402, 0.79220779220779225, 0.76623376623376627,
0.94805194805194803, 0.96103896103896103, 0.96103896103896103,
0.80519480519480524, 0.8441558441558441, 0.77922077922077926,
0.90909090909090906, 0.8571428571428571, 0.72727272727272729,
0.75324675324675328, 0.83116883116883122, 0.8571428571428571,
0.88311688311688308, 0.92207792207792205, 0.77922077922077926,
0.90909090909090906, 0.94805194805194803, 0.76623376623376627,
0.88311688311688308, 0.92207792207792205, 0.77922077922077926,
0.76623376623376627, 0.7142857142857143, 0.8571428571428571,
1.0129870129870129, 0.83116883116883122, 0.61038961038961037,
0.59740259740259738, 0.80519480519480524, 0.68831168831168832,
0.8441558441558441, 0.79220779220779225, 0.77922077922077926,
0.90909090909090906, 0.8441558441558441, 0.89610389610389607,
0.88311688311688308, 0.94805194805194803, 0.92207792207792205,
0.7142857142857143, 0.93506493506493504, 0.94805194805194803,
1.025974025974026, 0.77922077922077926, 0.8571428571428571, 0.66233766233766234,
1.025974025974026, 1.0129870129870129, 0.68831168831168832, 0.75324675324675328,
0.75324675324675328, 0.8571428571428571, 0.89610389610389607,
0.77922077922077926, 0.81818181818181823, 0.75324675324675328,
0.62337662337662336, 0.72727272727272729, 0.63636363636363635,
0.72727272727272729, 0.70129870129870131, 0.8571428571428571,
0.79220779220779225, 0.92207792207792205, 0.74025974025974028,
0.94805194805194803, 1.0389610389610389, 0.66233766233766234,
0.80519480519480524, 0.66233766233766234, 1, 0.63636363636363635,
0.92207792207792205, 0.75324675324675328, 0.75324675324675328,
0.74025974025974028, 0.7142857142857143, 0.79220779220779225,
0.67532467532467533, 0.8441558441558441, 0.89610389610389607,
0.88311688311688308, 0.79220779220779225, 0.63636363636363635,
0.89610389610389607, 0.62337662337662336, 0.77922077922077926,
0.59740259740259738, 0.94805194805194803, 0.7142857142857143,
0.7142857142857143, 0.62337662337662336, 0.64935064935064934,
0.80519480519480524, 0.8571428571428571, 0.81818181818181823,
0.97402597402597402, 0.8441558441558441, 0.83116883116883122,
0.70129870129870131, 0.8441558441558441, 0.80519480519480524,
0.81818181818181823, 1.025974025974026, 0.83116883116883122,
0.93506493506493504, 1.051948051948052, 0.90909090909090906,
0.62337662337662336, 0.93506493506493504, 0.87012987012987009,
0.89610389610389607, 0.66233766233766234, 0.76623376623376627,
0.75324675324675328, 0.80519480519480524, 0.8571428571428571,
0.70129870129870131, 0.92207792207792205, 0.81818181818181823,
0.93506493506493504, 0.61038961038961037, 0.58441558441558439,
0.77922077922077926, 0.75324675324675328, 0.67532467532467533,
0.67532467532467533, 0.88311688311688308, 0.63636363636363635,
0.96103896103896103, 0.74025974025974028, 0.80519480519480524,
0.75324675324675328, 0.72727272727272729, 0.76623376623376627,
0.88311688311688308, 0.74025974025974028, 0.88311688311688308,
0.90909090909090906, 0.81818181818181823, 0.90909090909090906,
0.89610389610389607, 0.7142857142857143, 0.61038961038961037,
0.67532467532467533, 0.8571428571428571, 0.89610389610389607,
0.59740259740259738, 0.76623376623376627, 0.8571428571428571,
0.92207792207792205, 0.97402597402597402, 0.77922077922077926,
0.83116883116883122, 0.83116883116883122, 0.72727272727272729,
0.70129870129870131, 0.93506493506493504, 0.77922077922077926,
0.92207792207792205, 1.0129870129870129, 0.66233766233766234,
0.80519480519480524, 0.98701298701298701, 0.90909090909090906,
0.64935064935064934, 0.59740259740259738, 0.80519480519480524,
1, 0.79220779220779225, 0.72727272727272729, 0.8571428571428571,
0.67532467532467533, 0.59740259740259738, 0.87012987012987009,
0.88311688311688308, 0.8441558441558441, 0.92207792207792205,
0.90909090909090906, 0.87012987012987009, 0.83116883116883122,
0.75324675324675328, 0.81818181818181823, 0.72727272727272729,
0.75324675324675328, 0.68831168831168832, 0.79220779220779225,
0.93506493506493504, 0.70129870129870131, 0.77922077922077926,
0.67532467532467533, 0.89610389610389607, 0.62337662337662336,
0.8441558441558441, 0.92207792207792205, 0.90909090909090906,
0.90909090909090906, 0.75324675324675328, 0.64935064935064934,
0.89610389610389607, 0.80519480519480524, 0.64935064935064934,
0.94805194805194803, 0.80519480519480524, 0.98701298701298701,
0.8571428571428571, 0.79220779220779225, 0.89610389610389607,
0.76623376623376627, 0.89610389610389607, 0.8441558441558441,
0.90909090909090906, 0.80519480519480524, 0.76623376623376627,
0.70129870129870131, 0.63636363636363635, 0.70129870129870131,
0.90909090909090906, 0.76623376623376627, 0.98701298701298701,
1.0129870129870129, 0.83116883116883122, 0.80519480519480524,
1.0129870129870129, 1.025974025974026, 0.83116883116883122, 0.96103896103896103,
0.90909090909090906, 0.97402597402597402, 0.80519480519480524,
0.79220779220779225, 0.67532467532467533, 0.79220779220779225,
0.76623376623376627, 0.66233766233766234, 0.87012987012987009,
0.8441558441558441, 0.94805194805194803, 0.80519480519480524,
0.61038961038961037, 0.68831168831168832, 0.93506493506493504,
0.93506493506493504, 0.93506493506493504, 0.89610389610389607,
0.87012987012987009, 0.63636363636363635, 0.7142857142857143,
0.77922077922077926, 0.64935064935064934, 0.8441558441558441,
0.76623376623376627, 0.81818181818181823, 0.97402597402597402,
0.59740259740259738, 0.92207792207792205, 0.94805194805194803,
0.7142857142857143, 0.62337662337662336, 0.80519480519480524,
0.97402597402597402, 0.92207792207792205, 0.7142857142857143,
0.76623376623376627, 0.74025974025974028, 0.92207792207792205,
0.93506493506493504, 0.64935064935064934, 0.8441558441558441,
0.70129870129870131, 0.87012987012987009, 0.90909090909090906,
0.80519480519480524, 0.80519480519480524, 0.80519480519480524,
0.8571428571428571, 0.64935064935064934, 0.72727272727272729,
0.76623376623376627, 0.93506493506493504, 0.7142857142857143,
0.8441558441558441, 0.80519480519480524, 0.8441558441558441,
0.8571428571428571, 0.94805194805194803, 0.90909090909090906,
0.94805194805194803, 1.0389610389610389, 0.97402597402597402,
0.83116883116883122, 0.83116883116883122, 0.96103896103896103,
0.83116883116883122, 0.80519480519480524, 1, 0.8571428571428571,
0.88311688311688308, 0.81818181818181823, 0.77922077922077926,
0.58441558441558439, 0.62337662337662336, 0.80519480519480524,
0.8571428571428571, 0.77922077922077926, 1, 0.80519480519480524,
0.72727272727272729, 0.8571428571428571, 0.8571428571428571,
0.94805194805194803, 0.74025974025974028, 0.66233766233766234,
1.025974025974026, 0.92207792207792205, 0.81818181818181823,
0.8571428571428571, 0.90909090909090906, 0.70129870129870131,
0.93506493506493504, 0.80519480519480524, 0.77922077922077926,
0.90909090909090906, 0.97402597402597402, 1, 0.79220779220779225,
0.90909090909090906, 0.61038961038961037, 0.76623376623376627,
0.87012987012987009, 0.89610389610389607, 0.98701298701298701,
0.70129870129870131, 0.96103896103896103, 0.62337662337662336,
0.92207792207792205, 0.80519480519480524, 0.75324675324675328,
0.80519480519480524, 0.67532467532467533, 0.61038961038961037,
0.75324675324675328, 0.72727272727272729, 0.75324675324675328,
0.70129870129870131, 0.77922077922077926, 0.81818181818181823,
0.63636363636363635, 0.80519480519480524, 0.66233766233766234,
0.8571428571428571, 0.88311688311688308, 0.88311688311688308,
0.8571428571428571, 0.88311688311688308, 0.75324675324675328,
0.72727272727272729, 0.77922077922077926, 0.97402597402597402,
0.80519480519480524, 0.83116883116883122, 0.76623376623376627,
0.80519480519480524, 0.92207792207792205, 0.77922077922077926,
0.79220779220779225, 0.93506493506493504, 0.67532467532467533,
0.89610389610389607, 0.75324675324675328, 0.96103896103896103,
0.93506493506493504, 0.96103896103896103, 1.0129870129870129,
0.63636363636363635, 0.81818181818181823, 0.67532467532467533,
0.79220779220779225, 0.75324675324675328, 0.88311688311688308,
0.77922077922077926, 0.7142857142857143, 0.58441558441558439,
0.76623376623376627, 0.83116883116883122, 0.80519480519480524,
0.64935064935064934, 0.97402597402597402, 0.83116883116883122,
0.76623376623376627, 0.90909090909090906, 0.77922077922077926,
0.79220779220779225, 0.72727272727272729, 0.72727272727272729,
0.79220779220779225, 0.67532467532467533, 0.63636363636363635,
0.94805194805194803, 0.62337662337662336, 0.72727272727272729,
0.70129870129870131, 0.67532467532467533, 0.92207792207792205,
0.97402597402597402, 0.8441558441558441, 0.68831168831168832,
0.8441558441558441, 0.8441558441558441, 0.88311688311688308,
1.0129870129870129, 0.72727272727272729, 0.66233766233766234,
0.80519480519480524, 0.74025974025974028, 0.64935064935064934,
0.66233766233766234, 0.70129870129870131, 0.89610389610389607,
0.80519480519480524, 0.87012987012987009, 0.93506493506493504,
0.8441558441558441, 0.92207792207792205, 0.67532467532467533,
0.68831168831168832, 0.61038961038961037, 0.94805194805194803,
0.74025974025974028, 1, 0.83116883116883122, 0.97402597402597402,
0.93506493506493504, 0.93506493506493504, 0.76623376623376627,
0.8441558441558441, 0.79220779220779225, 0.74025974025974028,
0.87012987012987009, 0.72727272727272729, 0.88311688311688308,
0.68831168831168832, 0.77922077922077926, 0.92207792207792205,
0.77922077922077926, 0.67532467532467533, 0.79220779220779225,
0.77922077922077926, 0.66233766233766234, 0.8571428571428571,
0.90909090909090906, 0.93506493506493504, 0.80519480519480524,
0.87012987012987009, 0.90909090909090906, 0.92207792207792205,
0.87012987012987009, 0.64935064935064934, 0.81818181818181823,
0.8571428571428571, 0.92207792207792205, 0.67532467532467533,
1, 0.74025974025974028, 0.80519480519480524, 0.8441558441558441,
0.74025974025974028, 0.8571428571428571, 0.87012987012987009,
0.59740259740259738, 0.62337662337662336, 0.83116883116883122,
0.81818181818181823, 0.90909090909090906, 0.83116883116883122,
0.77922077922077926, 0.93506493506493504, 0.59740259740259738,
0.79220779220779225, 0.8441558441558441, 0.68831168831168832,
1.0129870129870129, 0.81818181818181823, 0.7142857142857143,
0.97402597402597402, 0.67532467532467533, 0.98701298701298701,
0.83116883116883122, 0.80519480519480524, 0.68831168831168832,
0.72727272727272729, 0.87012987012987009, 0.83116883116883122,
0.64935064935064934, 0.59740259740259738, 0.70129870129870131,
0.75324675324675328, 0.80519480519480524, 0.72727272727272729,
1.0389610389610389, 0.66233766233766234, 0.8441558441558441,
1.0389610389610389, 0.66233766233766234, 0.8571428571428571,
0.81818181818181823, 0.8441558441558441, 0.98701298701298701,
0.64935064935064934, 0.67532467532467533, 0.80519480519480524,
0.97402597402597402, 0.62337662337662336, 0.74025974025974028,
0.81818181818181823, 0.59740259740259738, 0.92207792207792205,
0.83116883116883122, 0.90909090909090906, 0.77922077922077926,
0.96103896103896103, 0.83116883116883122, 0.7142857142857143,
0.74025974025974028, 0.8571428571428571, 0.76623376623376627,
0.87012987012987009, 0.7142857142857143, 0.66233766233766234,
0.72727272727272729, 0.66233766233766234, 0.64935064935064934,
0.8441558441558441, 0.66233766233766234, 0.66233766233766234,
0.96103896103896103, 0.72727272727272729, 0.68831168831168832,
0.77922077922077926, 0.77922077922077926, 0.79220779220779225,
0.92207792207792205, 0.74025974025974028, 0.59740259740259738,
0.70129870129870131, 0.80519480519480524, 0.66233766233766234,
0.67532467532467533, 0.93506493506493504, 0.63636363636363635,
0.74025974025974028, 0.79220779220779225, 1.025974025974026,
0.98701298701298701, 0.89610389610389607, 0.80519480519480524,
0.83116883116883122, 0.74025974025974028, 0.94805194805194803,
0.87012987012987009, 0.80519480519480524, 0.97402597402597402,
0.88311688311688308, 0.70129870129870131, 0.76623376623376627,
0.8441558441558441, 0.90909090909090906, 0.76623376623376627,
0.74025974025974028, 0.66233766233766234, 0.96103896103896103,
0.88311688311688308, 0.87012987012987009, 0.98701298701298701,
0.72727272727272729, 0.72727272727272729, 0.89610389610389607,
0.72727272727272729, 0.7142857142857143, 0.62337662337662336,
0.87012987012987009, 0.87012987012987009, 0.62337662337662336,
0.87012987012987009, 0.94805194805194803, 0.72727272727272729,
0.87012987012987009, 0.8571428571428571, 0.75324675324675328,
0.72727272727272729, 0.77922077922077926, 0.98701298701298701,
0.7142857142857143, 1, 0.8571428571428571, 0.8441558441558441,
0.8571428571428571, 0.94805194805194803, 0.90909090909090906,
0.88311688311688308, 0.87012987012987009, 0.93506493506493504,
0.81818181818181823, 0.98701298701298701, 0.80519480519480524,
1.0129870129870129, 0.7142857142857143, 0.97402597402597402,
0.63636363636363635, 0.97402597402597402, 0.68831168831168832,
0.68831168831168832, 0.74025974025974028, 0.8571428571428571,
0.72727272727272729, 0.75324675324675328, 0.93506493506493504,
0.98701298701298701, 0.61038961038961037, 0.89610389610389607,
0.87012987012987009, 0.88311688311688308, 0.96103896103896103,
0.98701298701298701, 0.81818181818181823, 0.79220779220779225,
0.90909090909090906, 0.67532467532467533, 0.61038961038961037,
0.80519480519480524, 0.66233766233766234, 0.77922077922077926,
1, 0.77922077922077926, 0.77922077922077926, 0.68831168831168832,
0.63636363636363635, 0.88311688311688308, 0.80519480519480524,
0.59740259740259738, 0.68831168831168832, 0.88311688311688308,
0.93506493506493504, 0.89610389610389607, 0.77922077922077926,
0.81818181818181823, 0.88311688311688308, 0.75324675324675328,
0.92207792207792205, 1, 0.8441558441558441, 0.89610389610389607,
1.025974025974026, 0.94805194805194803, 0.8571428571428571, 0.79220779220779225,
0.92207792207792205, 0.88311688311688308, 0.83116883116883122,
0.88311688311688308, 0.63636363636363635, 0.66233766233766234,
1.0389610389610389, 0.83116883116883122, 1.025974025974026, 0.66233766233766234,
0.81818181818181823, 0.8441558441558441, 0.8571428571428571,
0.76623376623376627, 0.96103896103896103, 0.64935064935064934,
0.88311688311688308, 0.70129870129870131, 0.83116883116883122,
0.79220779220779225, 0.79220779220779225, 0.75324675324675328,
0.90909090909090906, 0.93506493506493504, 0.8441558441558441,
0.70129870129870131, 0.8571428571428571, 1.025974025974026, 0.87012987012987009,
0.79220779220779225, 0.94805194805194803, 0.81818181818181823,
0.97402597402597402, 0.93506493506493504, 0.63636363636363635,
0.74025974025974028, 0.80519480519480524, 0.81818181818181823,
0.80519480519480524, 0.59740259740259738, 0.70129870129870131,
0.79220779220779225, 0.80519480519480524, 1, 0.94805194805194803,
0.70129870129870131, 0.75324675324675328, 0.83116883116883122,
0.93506493506493504, 0.97402597402597402, 0.8441558441558441,
0.68831168831168832, 0.83116883116883122, 0.61038961038961037,
1, 0.66233766233766234, 0.59740259740259738, 0.74025974025974028,
0.76623376623376627, 0.83116883116883122, 0.81818181818181823,
0.98701298701298701, 0.8571428571428571, 0.81818181818181823,
0.90909090909090906, 0.76623376623376627, 0.81818181818181823,
1.025974025974026, 0.8571428571428571, 0.76623376623376627, 0.61038961038961037,
0.70129870129870131, 0.96103896103896103, 0.89610389610389607,
0.75324675324675328, 0.88311688311688308, 0.90909090909090906,
0.88311688311688308, 0.66233766233766234, 0.64935064935064934,
0.62337662337662336, 0.94805194805194803, 0.90909090909090906,
0.88311688311688308, 0.70129870129870131, 0.77922077922077926,
1, 0.88311688311688308, 0.90909090909090906, 0.75324675324675328,
0.98701298701298701, 0.77922077922077926, 0.77922077922077926,
0.67532467532467533, 0.83116883116883122, 0.83116883116883122,
0.74025974025974028, 0.80519480519480524, 0.81818181818181823,
0.87012987012987009, 0.93506493506493504, 0.89610389610389607,
0.97402597402597402, 0.80519480519480524, 0.8571428571428571,
0.61038961038961037, 0.77922077922077926, 0.8571428571428571,
0.98701298701298701, 0.98701298701298701, 0.62337662337662336,
0.96103896103896103, 0.87012987012987009, 0.66233766233766234,
0.59740259740259738, 0.63636363636363635, 0.76623376623376627,
0.80519480519480524, 0.81818181818181823, 1.0389610389610389,
1.0389610389610389, 0.87012987012987009, 0.8571428571428571,
0.89610389610389607, 0.76623376623376627, 0.94805194805194803,
0.81818181818181823, 0.93506493506493504, 1, 0.72727272727272729,
0.8571428571428571, 0.59740259740259738, 0.67532467532467533,
0.87012987012987009, 0.70129870129870131, 0.83116883116883122,
0.8571428571428571, 0.75324675324675328, 0.93506493506493504,
0.59740259740259738, 0.7142857142857143, 0.92207792207792205,
0.92207792207792205, 0.83116883116883122, 0.61038961038961037,
0.81818181818181823, 0.80519480519480524, 0.87012987012987009,
0.92207792207792205, 0.74025974025974028, 0.74025974025974028,
0.98701298701298701, 0.92207792207792205, 0.96103896103896103,
0.67532467532467533, 0.94805194805194803, 0.68831168831168832,
0.77922077922077926, 0.76623376623376627, 0.83116883116883122,
0.80519480519480524, 0.72727272727272729, 0.75324675324675328,
0.75324675324675328, 0.59740259740259738, 0.68831168831168832,
0.79220779220779225, 0.90909090909090906, 0.75324675324675328,
0.83116883116883122, 0.66233766233766234, 1.0129870129870129,
0.74025974025974028, 0.67532467532467533, 0.75324675324675328,
0.64935064935064934, 0.72727272727272729, 0.83116883116883122,
0.80519480519480524, 0.76623376623376627, 0.75324675324675328,
0.87012987012987009, 0.74025974025974028, 0.61038961038961037,
0.70129870129870131, 0.93506493506493504, 0.80519480519480524,
1.025974025974026, 0.61038961038961037, 0.64935064935064934,
1.025974025974026, 0.68831168831168832, 0.77922077922077926,
0.81818181818181823, 1, 0.59740259740259738, 0.67532467532467533,
0.88311688311688308, 0.63636363636363635, 0.74025974025974028,
0.63636363636363635, 1.025974025974026, 0.7142857142857143, 0.83116883116883122,
0.64935064935064934, 0.92207792207792205, 0.61038961038961037,
0.90909090909090906, 0.72727272727272729, 0.93506493506493504,
0.87012987012987009, 0.77922077922077926, 0.61038961038961037,
0.81818181818181823, 0.75324675324675328, 0.87012987012987009,
0.70129870129870131, 0.77922077922077926, 0.70129870129870131,
0.79220779220779225, 0.96103896103896103, 1.025974025974026,
0.68831168831168832, 0.76623376623376627, 1, 0.63636363636363635,
0.68831168831168832, 0.90909090909090906, 0.67532467532467533,
1.0129870129870129, 0.70129870129870131, 0.74025974025974028,
0.59740259740259738, 0.8441558441558441, 0.98701298701298701,
0.72727272727272729, 0.92207792207792205, 0.92207792207792205,
0.8441558441558441, 0.77922077922077926, 0.96103896103896103,
0.87012987012987009, 0.81818181818181823, 0.66233766233766234,
0.67532467532467533, 0.8571428571428571, 0.68831168831168832,
0.97402597402597402, 0.90909090909090906, 0.70129870129870131,
0.77922077922077926, 0.68831168831168832, 0.80519480519480524,
0.63636363636363635, 0.72727272727272729, 0.97402597402597402,
0.8571428571428571, 0.7142857142857143, 0.61038961038961037,
0.87012987012987009, 0.75324675324675328, 0.98701298701298701,
0.64935064935064934, 0.89610389610389607, 0.76623376623376627,
0.67532467532467533, 0.63636363636363635, 0.7142857142857143,
0.67532467532467533, 0.89610389610389607, 0.88311688311688308,
0.7142857142857143, 0.79220779220779225, 0.72727272727272729,
0.70129870129870131, 1, 0.68831168831168832, 0.8571428571428571,
0.7142857142857143, 0.97402597402597402, 0.59740259740259738,
1.0129870129870129, 0.8441558441558441, 0.77922077922077926,
0.74025974025974028, 0.92207792207792205, 0.89610389610389607,
0.8441558441558441, 0.92207792207792205, 0.81818181818181823,
0.72727272727272729, 0.8571428571428571, 0.8571428571428571,
0.75324675324675328, 0.8571428571428571, 0.64935064935064934,
0.8571428571428571, 0.81818181818181823, 0.59740259740259738,
0.96103896103896103, 0.77922077922077926, 0.74025974025974028,
0.67532467532467533, 1, 0.75324675324675328, 0.88311688311688308,
0.75324675324675328, 0.80519480519480524, 0.8441558441558441,
1, 0.83116883116883122, 0.8441558441558441, 0.66233766233766234,
0.8441558441558441, 0.77922077922077926, 0.63636363636363635,
1.025974025974026, 0.87012987012987009, 0.8571428571428571, 0.63636363636363635,
1.025974025974026, 0.70129870129870131, 0.66233766233766234,
0.80519480519480524, 0.64935064935064934, 0.68831168831168832,
0.90909090909090906, 0.80519480519480524, 0.79220779220779225,
0.89610389610389607, 0.74025974025974028, 0.8571428571428571,
0.80519480519480524, 0.75324675324675328, 1.025974025974026,
0.81818181818181823, 0.66233766233766234, 0.63636363636363635,
0.88311688311688308, 0.93506493506493504, 0.98701298701298701,
0.90909090909090906, 0.61038961038961037, 0.83116883116883122,
0.8441558441558441, 0.76623376623376627, 0.8441558441558441,
0.98701298701298701, 0.92207792207792205, 0.80519480519480524,
0.63636363636363635, 0.87012987012987009, 1, 0.77922077922077926,
0.87012987012987009, 0.58441558441558439, 0.89610389610389607,
0.89610389610389607, 0.59740259740259738, 0.94805194805194803,
0.8441558441558441, 0.8441558441558441, 0.8441558441558441, 0.93506493506493504,
0.79220779220779225, 0.63636363636363635, 0.8571428571428571,
0.87012987012987009, 0.81818181818181823, 0.59740259740259738,
0.92207792207792205, 0.76623376623376627, 0.94805194805194803,
0.88311688311688308, 0.87012987012987009, 1.025974025974026,
0.92207792207792205, 0.68831168831168832, 0.8571428571428571,
0.77922077922077926, 0.72727272727272729, 0.89610389610389607,
0.72727272727272729, 0.94805194805194803, 0.76623376623376627,
0.83116883116883122, 0.75324675324675328, 0.67532467532467533,
0.93506493506493504, 0.88311688311688308, 0.76623376623376627,
0.67532467532467533, 0.75324675324675328, 0.77922077922077926,
0.76623376623376627, 0.96103896103896103, 0.89610389610389607,
0.8441558441558441, 0.62337662337662336, 0.79220779220779225,
0.7142857142857143, 0.61038961038961037, 0.88311688311688308,
0.72727272727272729, 0.80519480519480524, 0.68831168831168832,
0.83116883116883122, 0.8571428571428571, 0.74025974025974028,
0.8571428571428571, 0.67532467532467533, 0.87012987012987009,
0.80519480519480524, 0.88311688311688308, 0.89610389610389607,
0.70129870129870131, 0.88311688311688308, 0.8441558441558441,
0.72727272727272729, 0.81818181818181823, 0.94805194805194803,
0.96103896103896103, 0.80519480519480524, 0.94805194805194803,
1.0129870129870129, 0.97402597402597402, 0.81818181818181823,
0.81818181818181823, 0.70129870129870131, 0.89610389610389607,
0.80519480519480524, 0.74025974025974028, 0.64935064935064934,
0.62337662337662336, 0.98701298701298701, 0.87012987012987009,
1.025974025974026, 0.72727272727272729, 0.8441558441558441, 0.93506493506493504,
0.92207792207792205, 0.77922077922077926, 0.76623376623376627,
0.74025974025974028, 0.70129870129870131, 0.80519480519480524,
0.74025974025974028, 0.8571428571428571, 0.90909090909090906,
0.93506493506493504, 0.88311688311688308, 0.67532467532467533,
0.94805194805194803, 0.90909090909090906, 1.025974025974026,
0.83116883116883122, 0.79220779220779225, 0.8441558441558441,
0.67532467532467533, 0.88311688311688308, 0.8571428571428571,
0.88311688311688308, 1, 0.64935064935064934, 0.81818181818181823,
0.79220779220779225, 0.76623376623376627, 0.89610389610389607,
0.76623376623376627, 0.81818181818181823, 0.79220779220779225,
0.97402597402597402, 0.92207792207792205, 0.59740259740259738,
1.0129870129870129, 0.89610389610389607, 0.80519480519480524,
0.88311688311688308, 0.75324675324675328, 0.89610389610389607,
0.88311688311688308, 0.90909090909090906, 0.94805194805194803,
0.63636363636363635, 0.8571428571428571, 0.88311688311688308,
0.63636363636363635, 0.88311688311688308, 0.63636363636363635,
0.81818181818181823, 0.72727272727272729, 0.66233766233766234,
0.72727272727272729, 0.76623376623376627, 0.93506493506493504,
0.97402597402597402, 0.75324675324675328, 0.64935064935064934,
0.77922077922077926, 0.8571428571428571, 0.74025974025974028,
0.92207792207792205, 0.63636363636363635, 0.98701298701298701,
0.97402597402597402, 0.97402597402597402, 0.94805194805194803,
0.72727272727272729, 0.88311688311688308, 0.96103896103896103,
0.81818181818181823, 0.81818181818181823, 0.75324675324675328,
0.62337662337662336, 0.81818181818181823, 0.98701298701298701,
0.93506493506493504, 0.98701298701298701, 0.92207792207792205,
0.90909090909090906, 0.81818181818181823, 0.76623376623376627,
0.77922077922077926, 0.92207792207792205, 0.68831168831168832,
0.88311688311688308, 0.87012987012987009, 0.96103896103896103,
0.87012987012987009, 0.72727272727272729, 0.90909090909090906,
0.81818181818181823, 1.025974025974026, 0.98701298701298701,
1.025974025974026, 0.81818181818181823, 0.80519480519480524,
0.75324675324675328, 0.94805194805194803, 0.64935064935064934,
0.75324675324675328, 0.64935064935064934, 0.93506493506493504,
0.74025974025974028, 0.63636363636363635, 0.77922077922077926,
0.90909090909090906, 0.87012987012987009, 0.75324675324675328,
0.80519480519480524, 0.94805194805194803, 0.94805194805194803,
0.83116883116883122, 0.80519480519480524, 0.8571428571428571,
0.88311688311688308, 0.79220779220779225, 0.72727272727272729,
0.62337662337662336, 0.89610389610389607, 0.98701298701298701,
0.8571428571428571, 0.79220779220779225, 0.7142857142857143,
0.93506493506493504, 0.96103896103896103, 0.77922077922077926,
0.97402597402597402, 0.77922077922077926, 0.92207792207792205,
0.81818181818181823, 0.94805194805194803, 1.0389610389610389,
0.79220779220779225, 0.80519480519480524, 0.92207792207792205,
0.74025974025974028, 0.76623376623376627, 0.64935064935064934,
0.90909090909090906, 0.80519480519480524, 0.67532467532467533,
0.77922077922077926, 0.88311688311688308, 0.72727272727272729,
0.62337662337662336, 0.96103896103896103, 0.98701298701298701,
0.74025974025974028, 0.74025974025974028, 0.63636363636363635,
0.72727272727272729, 0.89610389610389607, 0.63636363636363635,
0.8441558441558441, 0.77922077922077926, 0.76623376623376627,
0.75324675324675328, 0.7142857142857143, 0.8441558441558441,
0.80519480519480524, 0.72727272727272729, 0.8441558441558441,
0.80519480519480524, 0.58441558441558439, 0.98701298701298701,
0.87012987012987009, 0.92207792207792205, 0.62337662337662336,
0.87012987012987009, 0.77922077922077926, 0.98701298701298701,
0.79220779220779225, 0.88311688311688308, 0.80519480519480524,
0.8571428571428571, 0.87012987012987009, 0.92207792207792205,
0.88311688311688308, 0.92207792207792205, 0.77922077922077926,
0.58441558441558439, 0.8441558441558441, 1.025974025974026, 0.77922077922077926,
0.76623376623376627, 0.62337662337662336, 0.61038961038961037,
0.79220779220779225, 0.59740259740259738, 0.80519480519480524,
0.67532467532467533, 0.80519480519480524, 0.75324675324675328,
0.74025974025974028, 0.80519480519480524, 0.68831168831168832,
0.88311688311688308, 0.64935064935064934, 0.94805194805194803,
0.75324675324675328, 0.64935064935064934, 0.74025974025974028,
0.81818181818181823, 0.81818181818181823, 0.8571428571428571,
0.90909090909090906, 0.80519480519480524, 0.87012987012987009,
0.87012987012987009, 0.75324675324675328, 0.72727272727272729,
0.94805194805194803, 0.68831168831168832, 0.67532467532467533,
0.92207792207792205, 0.81818181818181823, 0.7142857142857143,
0.72727272727272729, 0.76623376623376627, 0.93506493506493504,
0.92207792207792205, 0.87012987012987009, 0.68831168831168832,
0.89610389610389607, 0.80519480519480524, 0.66233766233766234,
0.96103896103896103, 0.83116883116883122, 0.75324675324675328,
0.80519480519480524, 0.61038961038961037, 1.0129870129870129,
0.97402597402597402, 0.8441558441558441, 0.87012987012987009,
0.8571428571428571, 0.79220779220779225, 0.67532467532467533,
0.8571428571428571, 0.87012987012987009, 0.97402597402597402,
0.77922077922077926, 0.92207792207792205, 0.66233766233766234,
0.58441558441558439, 0.89610389610389607, 0.74025974025974028,
0.80519480519480524, 0.80519480519480524, 0.77922077922077926,
0.80519480519480524, 0.79220779220779225, 0.90909090909090906,
0.75324675324675328, 0.8441558441558441, 0.89610389610389607,
0.68831168831168832, 0.75324675324675328, 0.7142857142857143,
0.61038961038961037, 0.83116883116883122, 0.76623376623376627,
0.89610389610389607, 0.76623376623376627, 0.83116883116883122,
0.7142857142857143, 0.66233766233766234, 0.8441558441558441,
0.74025974025974028, 0.68831168831168832, 0.87012987012987009,
0.90909090909090906, 0.81818181818181823, 0.70129870129870131,
0.66233766233766234, 0.87012987012987009, 0.8441558441558441,
0.74025974025974028, 0.68831168831168832, 0.70129870129870131,
1.0389610389610389, 0.98701298701298701, 0.75324675324675328,
0.70129870129870131, 0.79220779220779225, 0.72727272727272729,
0.76623376623376627, 0.75324675324675328, 0.74025974025974028,
0.89610389610389607, 0.94805194805194803, 0.92207792207792205,
0.97402597402597402, 0.96103896103896103, 0.80519480519480524,
0.93506493506493504, 1.0129870129870129, 0.90909090909090906,
0.81818181818181823, 0.77922077922077926, 0.92207792207792205,
0.81818181818181823, 0.89610389610389607, 0.66233766233766234,
0.77922077922077926, 0.88311688311688308, 1.0129870129870129,
0.83116883116883122, 0.75324675324675328, 0.75324675324675328,
0.89610389610389607, 0.75324675324675328, 0.77922077922077926,
0.8441558441558441, 0.88311688311688308, 0.81818181818181823,
0.96103896103896103, 0.80519480519480524, 0.81818181818181823,
0.64935064935064934, 0.83116883116883122, 0.98701298701298701,
0.83116883116883122, 0.96103896103896103, 0.74025974025974028,
0.96103896103896103, 0.8571428571428571, 0.92207792207792205,
0.89610389610389607, 0.75324675324675328, 0.88311688311688308,
1, 0.87012987012987009, 0.94805194805194803, 0.88311688311688308,
0.93506493506493504, 0.87012987012987009, 0.80519480519480524,
0.7142857142857143, 0.81818181818181823, 0.74025974025974028,
0.87012987012987009, 0.87012987012987009, 0.76623376623376627,
0.89610389610389607, 0.76623376623376627, 0.74025974025974028,
0.72727272727272729, 0.92207792207792205, 0.67532467532467533,
0.94805194805194803, 0.92207792207792205, 0.72727272727272729,
0.72727272727272729, 0.90909090909090906, 0.72727272727272729,
0.62337662337662336, 0.77922077922077926, 0.80519480519480524,
0.79220779220779225, 0.70129870129870131, 0.98701298701298701,
0.81818181818181823, 0.92207792207792205, 0.88311688311688308,
0.88311688311688308, 0.75324675324675328, 0.70129870129870131,
0.75324675324675328, 0.97402597402597402, 0.81818181818181823,
0.70129870129870131, 0.8571428571428571, 0.87012987012987009,
0.90909090909090906, 0.77922077922077926, 0.90909090909090906,
0.62337662337662336, 0.80519480519480524, 0.8441558441558441,
0.97402597402597402, 0.80519480519480524, 0.87012987012987009,
0.77922077922077926, 0.80519480519480524, 0.75324675324675328,
1, 0.7142857142857143, 0.96103896103896103, 0.88311688311688308,
0.80519480519480524, 0.89610389610389607, 0.79220779220779225,
0.88311688311688308, 0.94805194805194803, 0.80519480519480524,
0.72727272727272729, 0.7142857142857143, 0.94805194805194803,
0.97402597402597402, 0.94805194805194803, 0.83116883116883122,
0.87012987012987009, 0.62337662337662336, 0.80519480519480524,
0.88311688311688308, 0.89610389610389607, 0.87012987012987009,
0.81818181818181823, 0.74025974025974028, 0.63636363636363635,
0.87012987012987009, 1.0389610389610389, 0.88311688311688308,
0.87012987012987009, 0.83116883116883122, 0.8441558441558441,
0.83116883116883122, 0.8441558441558441, 0.8571428571428571,
0.70129870129870131, 0.67532467532467533, 0.96103896103896103,
0.87012987012987009, 1.0129870129870129, 0.93506493506493504,
0.93506493506493504, 0.81818181818181823, 0.98701298701298701,
0.96103896103896103, 0.7142857142857143, 0.88311688311688308,
0.96103896103896103, 0.67532467532467533, 0.76623376623376627,
0.7142857142857143, 0.96103896103896103, 0.77922077922077926,
0.98701298701298701, 0.87012987012987009, 0.79220779220779225,
0.72727272727272729, 0.79220779220779225, 0.67532467532467533,
0.87012987012987009, 0.68831168831168832, 0.67532467532467533,
0.89610389610389607, 0.81818181818181823, 0.89610389610389607,
0.76623376623376627, 0.94805194805194803, 0.93506493506493504,
0.8571428571428571, 0.97402597402597402, 1.051948051948052, 0.64935064935064934,
0.93506493506493504, 0.87012987012987009, 0.7142857142857143,
0.81818181818181823, 0.66233766233766234, 0.83116883116883122,
0.88311688311688308, 0.87012987012987009, 0.92207792207792205,
0.8441558441558441, 0.87012987012987009, 0.94805194805194803,
0.92207792207792205, 0.68831168831168832, 0.90909090909090906,
0.8571428571428571, 0.70129870129870131, 0.67532467532467533,
0.76623376623376627, 0.80519480519480524, 0.8441558441558441,
1.025974025974026, 0.77922077922077926, 0.70129870129870131,
0.68831168831168832, 0.68831168831168832, 0.83116883116883122,
0.92207792207792205, 0.88311688311688308, 0.8571428571428571,
0.66233766233766234, 0.8571428571428571, 0.79220779220779225,
1.0129870129870129, 0.94805194805194803, 0.8441558441558441,
0.72727272727272729, 0.90909090909090906, 0.87012987012987009,
0.90909090909090906, 0.74025974025974028, 0.96103896103896103,
1, 0.89610389610389607, 0.76623376623376627, 0.83116883116883122,
0.8571428571428571, 0.8571428571428571, 0.64935064935064934,
0.87012987012987009, 0.87012987012987009, 0.74025974025974028,
0.96103896103896103, 0.87012987012987009, 0.89610389610389607,
0.89610389610389607, 1.0129870129870129, 0.77922077922077926,
0.8571428571428571, 0.87012987012987009, 0.83116883116883122,
0.89610389610389607, 1.0129870129870129, 0.87012987012987009,
0.87012987012987009, 0.80519480519480524, 0.88311688311688308,
0.81818181818181823, 0.81818181818181823, 0.81818181818181823,
0.89610389610389607, 0.74025974025974028, 1, 0.88311688311688308,
0.76623376623376627, 0.83116883116883122, 0.8441558441558441,
0.80519480519480524, 0.81818181818181823, 0.96103896103896103,
0.62337662337662336, 0.81818181818181823, 0.58441558441558439,
0.72727272727272729, 0.8571428571428571, 0.83116883116883122,
0.81818181818181823, 0.58441558441558439, 0.79220779220779225,
0.66233766233766234, 0.7142857142857143, 0.90909090909090906,
0.76623376623376627, 0.80519480519480524, 0.70129870129870131,
0.68831168831168832, 0.88311688311688308, 0.93506493506493504,
0.89610389610389607, 0.8571428571428571, 0.81818181818181823,
0.87012987012987009, 0.64935064935064934, 0.77922077922077926,
0.68831168831168832, 0.72727272727272729, 0.75324675324675328,
0.7142857142857143, 0.75324675324675328, 0.81818181818181823,
0.7142857142857143, 0.67532467532467533, 0.72727272727272729,
0.70129870129870131, 0.8441558441558441, 0.79220779220779225,
0.96103896103896103, 0.8441558441558441, 0.89610389610389607,
0.74025974025974028, 0.8441558441558441, 0.93506493506493504,
0.70129870129870131, 0.83116883116883122, 0.75324675324675328,
0.77922077922077926, 0.76623376623376627, 0.67532467532467533,
0.89610389610389607, 0.74025974025974028, 0.63636363636363635,
0.76623376623376627, 0.83116883116883122, 0.74025974025974028,
0.87012987012987009, 0.74025974025974028, 0.83116883116883122,
0.90909090909090906, 0.5714285714285714, 0.90909090909090906,
1.0909090909090908, 0.59740259740259738, 0.61038961038961037,
0.93506493506493504, 0.80519480519480524, 0.62337662337662336,
0.63636363636363635, 0.79220779220779225, 0.61038961038961037,
0.5714285714285714, 0.70129870129870131, 0.63636363636363635,
0.70129870129870131, 0.74025974025974028, 0.62337662337662336,
0.74025974025974028, 0.54545454545454541, 0.7142857142857143,
1, 0.54545454545454541, 0.74025974025974028, 0.70129870129870131,
0.75324675324675328, 0.59740259740259738, 1.0779220779220779,
0.93506493506493504, 0.66233766233766234, 0.70129870129870131,
0.75324675324675328, 0.66233766233766234, 0.70129870129870131,
0.74025974025974028, 0.74025974025974028, 0.75324675324675328,
0.77922077922077926, 0.68831168831168832, 0.8441558441558441,
0.67532467532467533, 0.76623376623376627, 0.7142857142857143,
0.80519480519480524, 0.61038961038961037, 0.96103896103896103,
0.70129870129870131, 0.74025974025974028, 0.66233766233766234,
0.66233766233766234, 0.76623376623376627, 1.0649350649350648,
0.74025974025974028, 0.75324675324675328, 1, 0.75324675324675328,
0.74025974025974028, 0.8441558441558441, 0.67532467532467533,
0.67532467532467533, 0.75324675324675328, 0.74025974025974028,
0.90909090909090906, 0.87012987012987009, 0.74025974025974028,
0.76623376623376627, 0.76623376623376627, 0.67532467532467533,
0.94805194805194803, 0.74025974025974028, 0.74025974025974028,
0.75324675324675328, 0.83116883116883122, 0.75324675324675328,
0.76623376623376627, 0.75324675324675328, 0.66233766233766234,
0.68831168831168832, 0.59740259740259738, 0.80519480519480524,
0.87012987012987009, 0.89610389610389607, 0.68831168831168832,
0.7142857142857143, 0.68831168831168832, 0.90909090909090906,
0.74025974025974028, 0.77922077922077926, 0.68831168831168832,
0.77922077922077926, 0.75324675324675328, 0.87012987012987009,
0.8571428571428571, 0.88311688311688308, 0.68831168831168832,
0.8441558441558441, 0.8441558441558441, 0.89610389610389607,
0.66233766233766234, 0.72727272727272729, 0.90909090909090906,
0.80519480519480524, 0.89610389610389607, 1.0129870129870129,
0.72727272727272729, 0.8571428571428571, 0.7142857142857143,
0.77922077922077926, 0.77922077922077926, 0.87012987012987009,
0.70129870129870131, 0.89610389610389607, 0.87012987012987009,
0.90909090909090906, 0.89610389610389607, 0.87012987012987009,
0.88311688311688308, 0.76623376623376627, 0.79220779220779225,
0.8441558441558441, 0.70129870129870131, 0.83116883116883122,
0.89610389610389607, 0.72727272727272729, 0.83116883116883122,
0.79220779220779225, 0.66233766233766234, 0.89610389610389607,
0.70129870129870131, 0.88311688311688308, 0.90909090909090906,
0.7142857142857143, 0.61038961038961037, 0.8441558441558441,
0.89610389610389607, 0.80519480519480524, 0.8441558441558441,
0.80519480519480524, 0.88311688311688308, 0.8571428571428571,
0.79220779220779225, 0.80519480519480524, 0.80519480519480524,
0.88311688311688308, 0.88311688311688308, 0.80519480519480524,
0.83116883116883122, 0.64935064935064934, 0.79220779220779225,
0.87012987012987009, 0.89610389610389607, 0.80519480519480524,
0.90909090909090906, 0.79220779220779225, 0.59740259740259738,
0.83116883116883122, 0.8571428571428571, 0.88311688311688308,
0.8571428571428571, 0.72727272727272729, 0.89610389610389607,
0.80519480519480524, 0.8571428571428571, 0.83116883116883122,
0.81818181818181823, 0.90909090909090906, 0.8441558441558441,
0.74025974025974028, 0.90909090909090906, 0.88311688311688308,
0.83116883116883122, 0.80519480519480524, 0.76623376623376627,
0.79220779220779225, 0.89610389610389607, 0.8571428571428571,
0.93506493506493504, 0.8441558441558441, 0.80519480519480524,
0.79220779220779225, 0.83116883116883122, 0.83116883116883122,
0.80519480519480524, 0.67532467532467533, 0.88311688311688308,
0.80519480519480524, 0.80519480519480524, 0.81818181818181823,
0.88311688311688308, 0.83116883116883122, 0.81818181818181823,
0.88311688311688308, 0.88311688311688308, 0.89610389610389607,
0.79220779220779225, 0.90909090909090906, 0.88311688311688308,
0.90909090909090906, 0.93506493506493504, 0.87012987012987009,
0.8441558441558441, 0.93506493506493504, 0.97402597402597402,
0.93506493506493504, 0.93506493506493504, 0.79220779220779225,
0.66233766233766234, 0.68831168831168832, 0.81818181818181823,
0.92207792207792205, 0.98701298701298701, 0.54545454545454541,
1.025974025974026, 0.94805194805194803, 1, 0.94805194805194803,
0.68831168831168832, 0.97402597402597402, 0.92207792207792205,
0.94805194805194803, 0.93506493506493504, 0.93506493506493504,
0.67532467532467533, 0.8571428571428571, 1.0389610389610389,
0.92207792207792205, 0.89610389610389607, 0.94805194805194803,
1.025974025974026, 0.93506493506493504, 0.93506493506493504,
0.80519480519480524, 0.94805194805194803, 1.0389610389610389,
1.0389610389610389, 0.92207792207792205, 1, 1.0389610389610389,
0.97402597402597402, 1.0389610389610389, 0.97402597402597402,
0.72727272727272729, 0.94805194805194803, 1.0129870129870129,
0.94805194805194803, 0.92207792207792205, 0.96103896103896103,
0.7142857142857143, 0.93506493506493504, 1, 1.0389610389610389,
0.67532467532467533, 0.93506493506493504, 0.8441558441558441,
0.92207792207792205, 0.96103896103896103, 0.89610389610389607,
1.0129870129870129, 1.025974025974026, 1.1298701298701299, 0.98701298701298701,
0.79220779220779225, 0.96103896103896103, 0.98701298701298701,
0.68831168831168832, 1.025974025974026, 0.97402597402597402,
0.63636363636363635, 0.93506493506493504, 0.92207792207792205,
0.96103896103896103, 0.98701298701298701, 0.7142857142857143,
0.92207792207792205, 0.90909090909090906, 0.94805194805194803,
1.025974025974026, 0.96103896103896103, 1.025974025974026, 0.94805194805194803,
1.0129870129870129, 1.0129870129870129, 0.94805194805194803,
0.61038961038961037, 1.0649350649350648, 1.0129870129870129,
0.93506493506493504, 0.93506493506493504, 0.58441558441558439,
0.67532467532467533, 1, 0.98701298701298701, 0.68831168831168832,
0.92207792207792205, 1.025974025974026, 1.0389610389610389, 0.8441558441558441,
0.94805194805194803, 0.98701298701298701, 0.68831168831168832,
0.74025974025974028, 0.8441558441558441, 0.98701298701298701,
0.90909090909090906, 1, 1, 0.93506493506493504, 1.0129870129870129,
0.83116883116883122, 0.98701298701298701, 0.58441558441558439,
0.77922077922077926, 1, 0.62337662337662336, 0.76623376623376627,
0.61038961038961037, 0.7142857142857143, 0.74025974025974028,
0.81818181818181823, 1.1038961038961039, 0.88311688311688308,
1.0779220779220779, 0.97402597402597402, 0.93506493506493504,
0.97402597402597402, 0.70129870129870131, 1.0909090909090908,
0.81818181818181823, 1, 0.76623376623376627, 1.0649350649350648,
0.93506493506493504, 0.7142857142857143, 1.0779220779220779,
0.96103896103896103, 0.7142857142857143, 0.77922077922077926,
0.96103896103896103, 1.0779220779220779, 0.8571428571428571,
1.0389610389610389, 1.0649350649350648, 0.83116883116883122,
0.74025974025974028, 0.70129870129870131, 0.62337662337662336,
0.92207792207792205, 0.76623376623376627, 1.1558441558441559,
0.92207792207792205, 1.0649350649350648, 0.75324675324675328,
0.67532467532467533, 1.025974025974026, 0.67532467532467533,
0.62337662337662336, 0.7142857142857143, 1.1688311688311688,
0.97402597402597402, 0.96103896103896103, 1.1168831168831168,
0.93506493506493504, 1, 0.83116883116883122, 0.76623376623376627,
0.63636363636363635, 0.90909090909090906, 1, 0.70129870129870131,
1.0909090909090908, 0.72727272727272729, 0.75324675324675328,
1, 0.87012987012987009, 1.051948051948052, 1.0129870129870129,
0.72727272727272729, 0.90909090909090906, 0.81818181818181823,
0.67532467532467533, 0.67532467532467533, 0.70129870129870131,
1.0909090909090908, 0.76623376623376627, 0.97402597402597402,
0.66233766233766234, 0.8571428571428571, 0.96103896103896103,
1, 0.89610389610389607, 0.66233766233766234, 0.98701298701298701,
1.0909090909090908, 1, 0.7142857142857143, 0.7142857142857143,
0.76623376623376627, 0.90909090909090906, 0.87012987012987009,
0.77922077922077926, 0.66233766233766234, 0.83116883116883122,
0.83116883116883122, 0.77922077922077926, 0.98701298701298701,
0.66233766233766234, 0.8441558441558441, 0.7142857142857143,
0.98701298701298701, 0.98701298701298701, 0.98701298701298701,
0.72727272727272729, 0.88311688311688308, 1.0649350649350648,
1.0649350649350648, 0.7142857142857143, 0.70129870129870131,
1, 0.8571428571428571, 0.96103896103896103, 0.75324675324675328,
1.0779220779220779, 0.74025974025974028, 0.94805194805194803,
0.97402597402597402, 0.7142857142857143, 0.80519480519480524,
0.98701298701298701, 0.87012987012987009, 0.87012987012987009,
0.76623376623376627, 0.90909090909090906, 0.83116883116883122,
0.8441558441558441, 0.98701298701298701, 0.75324675324675328,
1.0909090909090908, 1.0129870129870129, 0.94805194805194803,
0.76623376623376627, 0.64935064935064934, 0.59740259740259738,
0.63636363636363635, 1.0779220779220779, 0.93506493506493504,
0.75324675324675328, 0.76623376623376627, 0.98701298701298701,
1.1038961038961039, 0.8571428571428571, 0.97402597402597402,
0.55844155844155841, 0.8441558441558441, 1.0909090909090908,
1.0909090909090908, 0.93506493506493504, 0.88311688311688308,
0.92207792207792205, 1, 0.51948051948051943, 0.83116883116883122,
1.0779220779220779, 1.025974025974026, 0.8571428571428571, 0.83116883116883122,
1.0389610389610389, 0.98701298701298701, 0.94805194805194803,
0.83116883116883122, 1.025974025974026, 1.051948051948052, 1.1298701298701299,
0.88311688311688308, 0.81818181818181823, 0.63636363636363635,
0.80519480519480524, 0.75324675324675328, 0.89610389610389607,
0.88311688311688308, 1.0389610389610389, 0.89610389610389607,
0.48051948051948051, 0.88311688311688308, 0.74025974025974028,
0.87012987012987009, 0.8441558441558441, 0.83116883116883122,
0.77922077922077926, 0.51948051948051943, 0.8571428571428571,
0.74025974025974028, 0.51948051948051943, 0.88311688311688308,
0.54545454545454541, 0.53246753246753242, 0.88311688311688308,
0.89610389610389607, 0.94805194805194803, 0.58441558441558439,
0.83116883116883122, 0.55844155844155841, 0.75324675324675328,
0.36363636363636365, 0.59740259740259738, 0.8571428571428571,
0.8441558441558441, 0.83116883116883122, 0.87012987012987009,
0.40259740259740262, 0.97402597402597402, 0.75324675324675328,
0.88311688311688308, 0.68831168831168832, 0.87012987012987009,
0.97402597402597402, 0.81818181818181823, 0.92207792207792205,
0.79220779220779225, 0.74025974025974028, 0.87012987012987009,
0.88311688311688308, 0.8571428571428571, 0.83116883116883122,
0.4935064935064935, 0.97402597402597402, 0.93506493506493504,
0.8441558441558441, 0.66233766233766234, 0.54545454545454541,
0.53246753246753242, 0.41558441558441561, 0.74025974025974028,
0.72727272727272729, 0.46753246753246752, 0.61038961038961037,
0.8571428571428571, 0.96103896103896103, 0.61038961038961037,
0.93506493506493504, 0.93506493506493504, 1.0779220779220779,
0.72727272727272729, 0.70129870129870131, 0.92207792207792205,
0.7142857142857143, 0.8441558441558441, 0.81818181818181823,
0.54545454545454541, 0.98701298701298701, 0.90909090909090906,
0.83116883116883122, 0.83116883116883122, 0.94805194805194803,
0.8571428571428571, 0.8441558441558441, 1.0909090909090908, 0.92207792207792205,
0.66233766233766234, 0.8441558441558441, 0.67532467532467533,
0.44155844155844154, 0.77922077922077926, 0.98701298701298701,
0.74025974025974028, 0.70129870129870131, 0.87012987012987009,
0.81818181818181823, 0.93506493506493504, 0.96103896103896103,
0.75324675324675328, 0.96103896103896103, 0.90909090909090906,
0.81818181818181823, 0.62337662337662336, 1, 0.90909090909090906,
0.81818181818181823, 0.66233766233766234, 0.94805194805194803,
0.44155844155844154, 0.74025974025974028, 0.46753246753246752,
0.83116883116883122, 0.70129870129870131, 0.7142857142857143,
0.98701298701298701, 0.58441558441558439, 0.87012987012987009,
0.67532467532467533, 0.50649350649350644, 0.87012987012987009,
0.89610389610389607, 0.93506493506493504, 0.89610389610389607,
0.83116883116883122, 0.76623376623376627, 0.58441558441558439,
0.4935064935064935, 0.67532467532467533, 0.70129870129870131,
0.58441558441558439, 0.70129870129870131, 0.80519480519480524,
0.92207792207792205, 0.74025974025974028, 0.88311688311688308,
0.97402597402597402, 0.94805194805194803, 0.93506493506493504,
0.90909090909090906, 0.79220779220779225, 0.68831168831168832,
0.89610389610389607, 0.93506493506493504, 0.80519480519480524,
0.68831168831168832, 0.89610389610389607, 0.81818181818181823,
0.44155844155844154, 0.27272727272727271, 0.94805194805194803,
0.88311688311688308, 0.51948051948051943, 0.33766233766233766,
0.77922077922077926, 0.81818181818181823, 0.66233766233766234,
0.79220779220779225, 0.93506493506493504, 0.88311688311688308,
0.8441558441558441, 0.8571428571428571, 0.93506493506493504,
0.77922077922077926, 0.98701298701298701, 0.74025974025974028,
0.64935064935064934, 0.61038961038961037, 0.81818181818181823,
0.70129870129870131, 1.0909090909090908, 0.94805194805194803,
0.76623376623376627, 0.96103896103896103, 0.81818181818181823,
0.74025974025974028, 1.025974025974026, 0.81818181818181823,
0.7142857142857143, 0.97402597402597402, 0.92207792207792205,
0.88311688311688308, 0.74025974025974028, 0.88311688311688308,
0.77922077922077926, 0.59740259740259738, 0.92207792207792205,
0.74025974025974028, 0.77922077922077926, 0.45454545454545453,
0.80519480519480524, 0.79220779220779225, 0.72727272727272729,
0.88311688311688308, 0.74025974025974028, 0.90909090909090906,
0.83116883116883122, 0.72727272727272729, 0.77922077922077926,
0.68831168831168832, 0.88311688311688308, 0.81818181818181823,
0.74025974025974028, 0.66233766233766234, 0.92207792207792205,
0.8441558441558441, 0.58441558441558439, 0.88311688311688308,
0.75324675324675328, 0.88311688311688308, 0.54545454545454541,
0.77922077922077926, 0.81818181818181823, 0.63636363636363635,
0.59740259740259738, 0.80519480519480524, 0.8571428571428571,
0.76623376623376627, 0.79220779220779225, 0.70129870129870131,
0.25974025974025972, 0.68831168831168832, 0.96103896103896103,
0.29870129870129869, 0.4935064935064935, 0.90909090909090906,
0.90909090909090906, 0.76623376623376627, 0.93506493506493504,
0.88311688311688308, 0.94805194805194803, 0.90909090909090906,
0.83116883116883122, 0.81818181818181823, 0.75324675324675328,
0.62337662337662336, 0.4935064935064935, 0.80519480519480524,
0.88311688311688308, 0.72727272727272729, 0.68831168831168832,
0.93506493506493504, 0.88311688311688308, 0.81818181818181823,
0.89610389610389607, 0.89610389610389607, 0.7142857142857143,
0.62337662337662336, 0.93506493506493504, 0.76623376623376627,
0.62337662337662336, 0.96103896103896103, 0.76623376623376627,
0.89610389610389607, 0.80519480519480524, 0.68831168831168832,
0.96103896103896103, 0.35064935064935066, 0.8571428571428571,
0.8441558441558441, 1.025974025974026, 0.79220779220779225, 0.7142857142857143,
0.77922077922077926, 0.67532467532467533, 0.55844155844155841,
0.79220779220779225, 0.77922077922077926, 0.42857142857142855,
0.7142857142857143, 0.83116883116883122, 0.79220779220779225,
0.83116883116883122, 0.94805194805194803, 0.93506493506493504,
0.72727272727272729, 0.92207792207792205, 0.64935064935064934,
0.59740259740259738, 0.62337662337662336, 0.90909090909090906,
0.68831168831168832, 1.0129870129870129, 0.70129870129870131,
0.90909090909090906, 0.97402597402597402, 0.80519480519480524,
0.75324675324675328, 0.8441558441558441, 0.79220779220779225,
0.68831168831168832, 0.8571428571428571, 0.79220779220779225,
0.74025974025974028, 0.97402597402597402, 0.8441558441558441,
0.4935064935064935, 0.88311688311688308, 0.45454545454545453,
0.8441558441558441, 0.54545454545454541, 0.89610389610389607,
0.63636363636363635, 0.81818181818181823, 0.62337662337662336,
0.55844155844155841, 0.51948051948051943, 0.66233766233766234,
0.67532467532467533, 0.63636363636363635, 0.36363636363636365,
0.93506493506493504, 0.59740259740259738, 0.92207792207792205,
0.66233766233766234, 0.79220779220779225, 0.68831168831168832,
0.54545454545454541, 0.83116883116883122, 0.68831168831168832,
0.8571428571428571, 0.67532467532467533, 0.24675324675324675,
0.70129870129870131, 0.61038961038961037, 0.50649350649350644,
0.31168831168831168, 0.77922077922077926, 0.76623376623376627,
0.8571428571428571, 0.97402597402597402, 0.92207792207792205,
0.41558441558441561, 0.79220779220779225, 0.93506493506493504,
0.92207792207792205, 0.8441558441558441, 0.76623376623376627,
0.8571428571428571, 0.68831168831168832, 0.59740259740259738,
0.97402597402597402, 0.92207792207792205, 0.88311688311688308,
0.87012987012987009, 0.68831168831168832, 0.53246753246753242,
0.75324675324675328, 0.62337662337662336, 0.7142857142857143,
0.62337662337662336, 0.7142857142857143, 0.93506493506493504,
0.83116883116883122, 0.36363636363636365, 0.88311688311688308,
0.68831168831168832, 0.81818181818181823, 0.66233766233766234,
0.8441558441558441, 1.0129870129870129, 0.8441558441558441, 0.46753246753246752,
0.8571428571428571, 0.45454545454545453, 0.94805194805194803,
0.93506493506493504, 0.88311688311688308, 0.92207792207792205,
0.8441558441558441, 0.8571428571428571, 0.90909090909090906,
0.7142857142857143, 0.70129870129870131, 0.7142857142857143,
0.75324675324675328, 0.55844155844155841, 0.96103896103896103,
0.79220779220779225, 0.58441558441558439, 0.97402597402597402,
0.62337662337662336, 0.92207792207792205, 0.8571428571428571,
0.72727272727272729, 0.8441558441558441, 0.67532467532467533,
0.8441558441558441, 0.89610389610389607, 0.93506493506493504,
0.63636363636363635, 0.83116883116883122, 0.83116883116883122,
0.79220779220779225, 0.51948051948051943, 0.50649350649350644,
0.46753246753246752, 0.61038961038961037, 1.1298701298701299,
0.64935064935064934, 0.8441558441558441, 0.74025974025974028,
0.81818181818181823, 0.62337662337662336, 0.96103896103896103,
0.89610389610389607, 1.0129870129870129, 0.90909090909090906,
0.7142857142857143, 0.92207792207792205, 0.70129870129870131,
0.62337662337662336, 0.4935064935064935, 0.37662337662337664,
0.68831168831168832, 0.50649350649350644, 1, 0.4935064935064935,
0.96103896103896103, 0.53246753246753242, 0.94805194805194803,
0.8571428571428571, 0.62337662337662336, 0.96103896103896103,
0.92207792207792205, 0.75324675324675328, 0.97402597402597402,
0.7142857142857143, 0.62337662337662336, 0.83116883116883122,
0.81818181818181823, 0.93506493506493504, 0.90909090909090906,
0.8571428571428571, 0.80519480519480524, 0.80519480519480524,
0.76623376623376627, 0.94805194805194803, 0.51948051948051943,
1.0129870129870129, 0.81818181818181823, 0.80519480519480524,
0.8571428571428571, 0.72727272727272729, 0.81818181818181823,
0.8571428571428571, 0.97402597402597402, 0.74025974025974028,
0.97402597402597402, 0.8441558441558441, 0.8571428571428571,
0.83116883116883122, 0.46753246753246752, 0.55844155844155841,
0.90909090909090906, 0.93506493506493504, 0.8571428571428571,
0.79220779220779225, 0.67532467532467533, 0.40259740259740262,
0.8441558441558441, 0.83116883116883122, 0.76623376623376627,
0.74025974025974028, 0.93506493506493504, 0.81818181818181823,
0.63636363636363635, 0.90909090909090906, 0.87012987012987009,
0.64935064935064934, 0.77922077922077926, 0.35064935064935066,
0.92207792207792205, 1.0649350649350648, 0.89610389610389607,
0.8441558441558441, 0.76623376623376627, 0.75324675324675328,
0.75324675324675328, 0.7142857142857143, 0.87012987012987009,
0.8441558441558441, 0.80519480519480524, 0.51948051948051943,
0.32467532467532467, 0.66233766233766234, 0.5714285714285714,
0.96103896103896103, 0.96103896103896103, 0.8441558441558441,
0.76623376623376627, 0.72727272727272729, 0.70129870129870131,
0.70129870129870131, 0.63636363636363635, 0.4935064935064935,
0.88311688311688308, 0.67532467532467533, 1.0649350649350648,
0.89610389610389607, 0.83116883116883122, 0.81818181818181823,
0.64935064935064934, 0.76623376623376627, 0.87012987012987009,
0.81818181818181823, 0.80519480519480524, 0.92207792207792205,
0.54545454545454541, 0.98701298701298701, 0.7142857142857143,
0.58441558441558439, 0.5714285714285714, 0.8571428571428571,
0.77922077922077926, 0.72727272727272729, 0.90909090909090906,
0.81818181818181823, 0.87012987012987009, 1, 0.70129870129870131,
0.89610389610389607, 0.8441558441558441, 0.92207792207792205,
0.94805194805194803, 1.0779220779220779, 0.98701298701298701,
0.90909090909090906, 1, 0.8441558441558441, 0.81818181818181823,
0.83116883116883122, 1.0779220779220779, 1, 0.8441558441558441,
0.8441558441558441, 0.93506493506493504, 0.92207792207792205,
0.90909090909090906, 0.92207792207792205, 0.87012987012987009,
1.0389610389610389, 0.77922077922077926, 0.96103896103896103,
1.0909090909090908, 0.80519480519480524, 0.97402597402597402,
1.0129870129870129, 0.83116883116883122, 0.72727272727272729,
0.94805194805194803, 0.83116883116883122, 0.92207792207792205,
0.96103896103896103, 0.93506493506493504, 1.0779220779220779,
0.92207792207792205, 1.1038961038961039, 1.0779220779220779,
0.94805194805194803, 1.1038961038961039, 0.88311688311688308,
0.88311688311688308, 1.051948051948052, 1.1038961038961039, 0.97402597402597402,
1.051948051948052, 0.90909090909090906, 1.0129870129870129, 1.1428571428571428,
0.98701298701298701, 1.0909090909090908, 1.0129870129870129,
1.2467532467532467, 0.93506493506493504, 0.88311688311688308,
0.92207792207792205, 0.90909090909090906, 0.96103896103896103,
0.88311688311688308, 0.92207792207792205, 0.94805194805194803,
0.88311688311688308, 0.58441558441558439, 0.98701298701298701,
0.87012987012987009, 0.96103896103896103, 0.94805194805194803,
1.0129870129870129, 1, 0.92207792207792205, 1.1168831168831168,
1.051948051948052, 1.051948051948052, 1.0389610389610389, 0.93506493506493504,
1.025974025974026, 0.88311688311688308, 1.025974025974026, 1.0389610389610389,
0.88311688311688308, 0.96103896103896103, 1.1168831168831168,
0.98701298701298701, 1.0649350649350648, 0.64935064935064934,
0.92207792207792205, 0.96103896103896103, 0.90909090909090906,
0.8441558441558441, 1.025974025974026, 0.87012987012987009, 0.87012987012987009,
0.97402597402597402, 0.90909090909090906, 0.76623376623376627,
0.7142857142857143, 0.87012987012987009, 0.96103896103896103,
1.0649350649350648, 0.8441558441558441, 0.94805194805194803,
0.94805194805194803, 1, 0.74025974025974028, 0.92207792207792205,
0.92207792207792205, 0.97402597402597402, 0.93506493506493504,
1, 1.0779220779220779, 0.8571428571428571, 0.90909090909090906,
0.79220779220779225, 0.94805194805194803, 0.97402597402597402,
0.94805194805194803, 1.1168831168831168, 1.051948051948052, 0.89610389610389607,
0.89610389610389607, 0.8441558441558441, 1.051948051948052, 0.98701298701298701,
1, 0.81818181818181823, 0.87012987012987009, 1.0129870129870129,
1.0779220779220779, 1.1038961038961039, 0.94805194805194803,
0.72727272727272729, 0.77922077922077926, 0.83116883116883122,
0.92207792207792205, 1.1428571428571428, 0.96103896103896103,
0.98701298701298701, 1.0649350649350648, 0.88311688311688308,
0.96103896103896103, 1, 0.76623376623376627, 0.96103896103896103,
0.83116883116883122, 0.8441558441558441, 0.96103896103896103,
0.8441558441558441, 1.025974025974026, 0.79220779220779225, 0.96103896103896103,
1.0909090909090908, 0.45454545454545453, 0.8441558441558441,
0.96103896103896103, 0.89610389610389607, 1.051948051948052,
0.89610389610389607, 0.96103896103896103, 0.63636363636363635,
0.90909090909090906, 0.94805194805194803, 0.79220779220779225,
0.97402597402597402, 0.8441558441558441, 0.67532467532467533,
0.98701298701298701, 0.98701298701298701, 0.92207792207792205,
0.90909090909090906, 0.87012987012987009, 0.98701298701298701,
0.93506493506493504, 0.98701298701298701, 0.80519480519480524,
0.70129870129870131, 0.93506493506493504, 0.98701298701298701,
1.0909090909090908, 0.96103896103896103, 0.93506493506493504,
1, 0.97402597402597402, 0.92207792207792205, 0.89610389610389607,
0.80519480519480524, 0.75324675324675328, 0.8441558441558441,
0.81818181818181823, 0.88311688311688308, 0.74025974025974028,
1.051948051948052, 1, 0.94805194805194803, 0.98701298701298701,
0.93506493506493504, 0.96103896103896103, 0.81818181818181823,
0.62337662337662336, 0.96103896103896103, 1.0129870129870129,
0.98701298701298701, 1, 0.63636363636363635, 1.0649350649350648,
0.93506493506493504, 0.74025974025974028, 1.0129870129870129,
0.55844155844155841, 0.89610389610389607, 0.8441558441558441,
0.88311688311688308, 0.92207792207792205, 0.92207792207792205,
1.0649350649350648, 0.98701298701298701, 0.98701298701298701,
0.68831168831168832, 1.025974025974026, 0.7142857142857143, 0.96103896103896103,
0.89610389610389607, 0.67532467532467533, 0.98701298701298701,
1.0389610389610389, 0.87012987012987009, 0.97402597402597402,
0.88311688311688308, 1.0389610389610389, 0.80519480519480524,
0.92207792207792205, 1.051948051948052, 0.98701298701298701,
0.96103896103896103, 0.79220779220779225, 0.93506493506493504,
1.025974025974026, 0.67532467532467533, 1, 0.94805194805194803,
1, 1.0129870129870129, 1.0649350649350648, 0.89610389610389607,
0.93506493506493504, 0.87012987012987009, 0.92207792207792205,
0.81818181818181823, 0.94805194805194803, 1.0779220779220779,
1.0129870129870129, 0.53246753246753242, 0.88311688311688308,
0.97402597402597402, 0.88311688311688308, 0.87012987012987009,
0.88311688311688308, 0.77922077922077926, 0.97402597402597402,
0.79220779220779225, 1.0129870129870129, 0.93506493506493504,
0.96103896103896103, 0.8571428571428571, 0.80519480519480524,
0.93506493506493504, 1.0649350649350648, 0.98701298701298701,
0.94805194805194803, 0.72727272727272729, 0.8441558441558441,
1, 0.8441558441558441, 1, 0.94805194805194803, 0.94805194805194803,
0.93506493506493504, 0.8441558441558441, 0.94805194805194803,
0.76623376623376627, 0.7142857142857143, 0.62337662337662336,
0.94805194805194803, 0.7142857142857143, 0.75324675324675328,
0.80519480519480524, 0.61038961038961037, 0.83116883116883122,
0.74025974025974028, 0.79220779220779225, 0.80519480519480524,
0.92207792207792205, 1.0909090909090908, 1, 0.77922077922077926,
0.75324675324675328, 1, 1.0649350649350648, 0.67532467532467533,
0.68831168831168832, 0.63636363636363635, 0.77922077922077926,
0.92207792207792205, 0.75324675324675328, 0.93506493506493504,
0.81818181818181823, 0.80519480519480524, 1.1298701298701299,
1, 0.79220779220779225, 0.83116883116883122, 0.97402597402597402,
1.0129870129870129, 0.7142857142857143, 0.76623376623376627,
0.64935064935064934, 0.76623376623376627, 0.98701298701298701,
0.8441558441558441, 0.97402597402597402, 0.89610389610389607,
0.97402597402597402, 1.0779220779220779, 0.90909090909090906,
1.1038961038961039, 0.96103896103896103, 0.83116883116883122,
1.0649350649350648, 0.94805194805194803, 0.72727272727272729,
0.5714285714285714, 1.025974025974026, 0.97402597402597402, 0.74025974025974028,
0.8571428571428571, 0.88311688311688308, 1, 0.81818181818181823,
1.0649350649350648, 1.0389610389610389, 0.83116883116883122,
0.68831168831168832, 0.88311688311688308, 1.0779220779220779,
0.72727272727272729, 0.80519480519480524, 0.83116883116883122,
0.98701298701298701, 0.79220779220779225, 0.90909090909090906,
1.0779220779220779, 0.96103896103896103, 0.67532467532467533,
0.7142857142857143, 0.79220779220779225, 0.5714285714285714,
1.1298701298701299, 0.88311688311688308, 0.74025974025974028,
0.5714285714285714, 0.87012987012987009, 1.1168831168831168,
0.90909090909090906, 0.93506493506493504, 0.93506493506493504,
0.54545454545454541, 0.61038961038961037, 0.66233766233766234,
0.8441558441558441, 0.83116883116883122, 0.74025974025974028,
0.89610389610389607, 0.90909090909090906, 0.96103896103896103,
0.77922077922077926, 0.55844155844155841, 0.72727272727272729,
0.72727272727272729, 0.96103896103896103, 0.87012987012987009,
0.75324675324675328, 0.77922077922077926, 0.83116883116883122,
1, 0.74025974025974028, 0.67532467532467533, 0.8441558441558441,
0.8441558441558441, 0.64935064935064934, 0.94805194805194803,
0.75324675324675328, 0.8441558441558441, 1.0779220779220779,
0.83116883116883122, 0.93506493506493504, 0.90909090909090906,
0.8441558441558441, 0.5714285714285714, 0.98701298701298701,
0.8441558441558441, 0.63636363636363635, 0.68831168831168832,
0.89610389610389607, 1.051948051948052, 0.80519480519480524,
0.83116883116883122, 0.93506493506493504, 0.88311688311688308,
0.98701298701298701, 1.0649350649350648, 0.92207792207792205,
0.88311688311688308, 0.64935064935064934, 0.92207792207792205,
0.94805194805194803, 1.0129870129870129, 0.77922077922077926,
0.92207792207792205, 0.81818181818181823, 1.025974025974026,
0.79220779220779225, 0.83116883116883122, 0.77922077922077926,
0.8441558441558441, 0.83116883116883122, 0.61038961038961037,
0.96103896103896103, 1.0129870129870129, 0.74025974025974028,
1.025974025974026, 0.81818181818181823, 0.87012987012987009,
0.81818181818181823, 0.59740259740259738, 0.96103896103896103,
0.96103896103896103, 0.62337662337662336, 0.8571428571428571,
0.76623376623376627, 0.93506493506493504, 0.62337662337662336,
0.98701298701298701, 0.98701298701298701, 0.94805194805194803,
0.87012987012987009, 0.76623376623376627, 0.88311688311688308,
0.72727272727272729, 0.79220779220779225, 0.72727272727272729,
0.77922077922077926, 1.0649350649350648, 0.8441558441558441,
0.96103896103896103, 0.81818181818181823, 0.75324675324675328,
0.92207792207792205, 0.8571428571428571, 0.90909090909090906,
0.8441558441558441, 0.92207792207792205, 0.79220779220779225,
1.0649350649350648, 0.70129870129870131, 0.72727272727272729,
0.75324675324675328, 0.80519480519480524, 0.8441558441558441,
0.8571428571428571, 0.62337662337662336, 0.64935064935064934,
0.62337662337662336, 1.025974025974026, 0.5714285714285714, 0.79220779220779225,
0.67532467532467533, 0.81818181818181823, 0.77922077922077926,
0.72727272727272729, 0.81818181818181823, 0.83116883116883122,
1.0649350649350648, 0.59740259740259738, 0.68831168831168832,
0.4935064935064935, 1.025974025974026, 0.4935064935064935, 1.0129870129870129,
0.89610389610389607, 0.72727272727272729, 1.0649350649350648,
0.89610389610389607, 0.75324675324675328, 0.93506493506493504,
0.58441558441558439, 0.64935064935064934, 0.72727272727272729,
0.93506493506493504, 0.89610389610389607, 0.96103896103896103,
0.88311688311688308, 0.97402597402597402, 1.051948051948052,
0.75324675324675328, 1.0649350649350648, 0.96103896103896103,
0.90909090909090906, 0.94805194805194803, 0.67532467532467533,
0.77922077922077926, 0.8571428571428571, 0.98701298701298701,
0.93506493506493504, 0.93506493506493504, 0.83116883116883122,
0.87012987012987009, 0.54545454545454541, 1.0909090909090908,
0.96103896103896103, 0.90909090909090906, 0.76623376623376627,
0.67532467532467533, 0.67532467532467533, 0.76623376623376627,
0.93506493506493504, 0.8441558441558441, 0.7142857142857143,
0.8571428571428571, 0.72727272727272729, 0.97402597402597402,
0.75324675324675328, 0.93506493506493504, 0.42857142857142855,
1.0129870129870129, 1.025974025974026, 1, 0.98701298701298701,
0.83116883116883122, 1.025974025974026, 1.0389610389610389, 0.96103896103896103,
0.88311688311688308, 0.75324675324675328, 0.96103896103896103,
0.93506493506493504, 0.7142857142857143, 1, 0.81818181818181823,
0.94805194805194803, 1.0389610389610389, 0.74025974025974028,
0.53246753246753242, 1.0389610389610389, 0.81818181818181823,
0.94805194805194803, 0.81818181818181823, 0.8571428571428571,
1.051948051948052, 0.62337662337662336, 0.83116883116883122,
0.81818181818181823, 0.83116883116883122, 0.8571428571428571,
0.72727272727272729, 0.66233766233766234, 0.8571428571428571,
0.90909090909090906, 0.75324675324675328, 0.70129870129870131,
0.96103896103896103, 0.64935064935064934, 0.96103896103896103,
0.80519480519480524, 0.76623376623376627, 0.74025974025974028,
0.96103896103896103, 0.92207792207792205, 0.97402597402597402,
0.68831168831168832, 0.77922077922077926, 0.75324675324675328,
0.87012987012987009, 0.64935064935064934, 1.0129870129870129,
0.89610389610389607, 0.81818181818181823, 0.89610389610389607,
0.74025974025974028, 0.77922077922077926, 0.77922077922077926,
0.79220779220779225, 0.8441558441558441, 0.75324675324675328,
0.66233766233766234, 0.72727272727272729, 0.90909090909090906,
0.93506493506493504, 0.74025974025974028, 0.72727272727272729,
0.93506493506493504, 0.70129870129870131, 0.87012987012987009,
0.80519480519480524, 0.66233766233766234, 0.74025974025974028,
0.94805194805194803, 0.75324675324675328, 0.94805194805194803,
0.90909090909090906, 0.7142857142857143, 0.8571428571428571,
0.97402597402597402, 0.81818181818181823, 0.8441558441558441,
0.88311688311688308, 0.87012987012987009, 0.96103896103896103,
0.87012987012987009, 0.68831168831168832, 0.77922077922077926,
0.88311688311688308, 1.025974025974026, 0.98701298701298701,
0.76623376623376627, 1.025974025974026, 0.7142857142857143, 0.74025974025974028,
1.0779220779220779, 0.67532467532467533, 1.0129870129870129,
0.8571428571428571, 0.80519480519480524, 1.051948051948052, 0.8441558441558441,
0.80519480519480524, 0.67532467532467533, 0.72727272727272729,
0.68831168831168832, 0.80519480519480524, 0.89610389610389607,
0.98701298701298701, 0.7142857142857143, 1, 0.80519480519480524,
0.64935064935064934, 1.025974025974026, 0.98701298701298701,
0.5714285714285714, 0.87012987012987009, 0.97402597402597402,
0.77922077922077926, 0.93506493506493504, 0.70129870129870131,
0.81818181818181823, 0.72727272727272729, 0.89610389610389607,
1.0129870129870129, 0.8441558441558441, 0.96103896103896103,
0.67532467532467533, 0.79220779220779225, 0.88311688311688308,
1.0129870129870129, 0.74025974025974028, 0.77922077922077926,
0.94805194805194803, 0.74025974025974028, 0.79220779220779225,
0.76623376623376627, 1.051948051948052, 1.051948051948052, 0.87012987012987009,
0.8441558441558441, 0.67532467532467533, 0.94805194805194803,
0.76623376623376627, 1.025974025974026, 0.8441558441558441, 0.81818181818181823,
0.87012987012987009, 0.51948051948051943, 0.90909090909090906,
0.70129870129870131, 0.89610389610389607, 0.80519480519480524,
0.66233766233766234, 0.76623376623376627, 0.87012987012987009,
0.90909090909090906, 0.81818181818181823, 0.83116883116883122,
0.83116883116883122, 0.97402597402597402, 0.94805194805194803,
0.87012987012987009, 0.90909090909090906, 0.67532467532467533,
0.83116883116883122, 0.80519480519480524, 0.66233766233766234,
0.8441558441558441, 0.74025974025974028, 1.025974025974026, 0.76623376623376627,
0.83116883116883122, 0.90909090909090906, 0.59740259740259738,
0.8441558441558441, 0.92207792207792205, 0.96103896103896103,
0.67532467532467533, 0.70129870129870131, 0.72727272727272729,
0.87012987012987009, 0.96103896103896103, 1.051948051948052,
0.90909090909090906, 0.4935064935064935, 0.77922077922077926,
0.79220779220779225, 0.8441558441558441, 0.80519480519480524,
0.88311688311688308, 0.81818181818181823, 0.72727272727272729,
0.75324675324675328, 0.67532467532467533, 0.83116883116883122,
0.96103896103896103, 0.76623376623376627, 0.64935064935064934,
0.87012987012987009, 0.79220779220779225, 0.74025974025974028,
0.80519480519480524, 0.62337662337662336, 0.76623376623376627,
0.79220779220779225, 0.93506493506493504, 0.80519480519480524,
0.77922077922077926, 0.83116883116883122, 0.72727272727272729,
1.0129870129870129, 0.8441558441558441, 0.8571428571428571, 0.76623376623376627,
0.66233766233766234, 0.59740259740259738, 0.66233766233766234,
0.51948051948051943, 1.0129870129870129, 0.8571428571428571,
0.7142857142857143, 0.70129870129870131, 0.8441558441558441,
0.96103896103896103, 0.7142857142857143, 0.50649350649350644,
0.98701298701298701, 0.59740259740259738, 0.83116883116883122,
0.79220779220779225, 0.64935064935064934, 0.87012987012987009,
1.0129870129870129, 0.66233766233766234, 0.8441558441558441,
0.90909090909090906, 0.68831168831168832, 0.48051948051948051,
0.81818181818181823, 1.1168831168831168, 0.74025974025974028,
0.75324675324675328, 0.77922077922077926, 0.94805194805194803,
0.89610389610389607, 0.61038961038961037, 0.67532467532467533,
0.7142857142857143, 0.63636363636363635, 0.98701298701298701,
0.88311688311688308, 0.77922077922077926, 1.051948051948052,
0.8441558441558441, 0.88311688311688308, 0.76623376623376627,
0.72727272727272729, 0.87012987012987009, 0.89610389610389607,
0.89610389610389607, 0.90909090909090906, 0.67532467532467533,
0.8571428571428571, 0.80519480519480524, 0.80519480519480524,
1.025974025974026, 0.98701298701298701, 0.83116883116883122,
0.90909090909090906, 0.81818181818181823, 0.75324675324675328,
0.68831168831168832, 0.90909090909090906, 0.77922077922077926,
0.72727272727272729, 0.64935064935064934, 0.77922077922077926,
1.051948051948052, 0.8441558441558441, 1, 0.64935064935064934,
0.89610389610389607, 0.77922077922077926, 0.96103896103896103,
0.53246753246753242, 0.80519480519480524, 0.58441558441558439,
0.59740259740259738, 0.75324675324675328, 0.94805194805194803,
1.025974025974026, 0.92207792207792205, 0.70129870129870131,
0.81818181818181823, 0.96103896103896103, 0.76623376623376627,
0.62337662337662336, 0.77922077922077926, 0.67532467532467533,
0.77922077922077926, 1.0389610389610389, 0.7142857142857143,
0.7142857142857143, 0.89610389610389607, 1.0129870129870129,
0.70129870129870131, 0.75324675324675328, 0.64935064935064934,
0.79220779220779225, 0.96103896103896103, 1.0909090909090908,
0.66233766233766234, 0.8571428571428571, 0.8441558441558441,
0.81818181818181823, 0.67532467532467533, 0.62337662337662336,
0.75324675324675328, 0.77922077922077926, 0.70129870129870131,
0.77922077922077926, 0.96103896103896103, 0.89610389610389607,
1.0649350649350648, 0.98701298701298701, 0.90909090909090906,
0.8441558441558441, 0.80519480519480524, 0.8441558441558441,
1, 0.88311688311688308, 0.97402597402597402, 0.81818181818181823,
0.93506493506493504, 0.81818181818181823, 0.70129870129870131,
0.83116883116883122, 0.94805194805194803, 0.66233766233766234,
0.98701298701298701, 0.72727272727272729, 0.79220779220779225,
0.79220779220779225, 0.63636363636363635, 0.75324675324675328,
0.88311688311688308, 1.0129870129870129, 0.8441558441558441,
0.62337662337662336, 0.79220779220779225, 0.98701298701298701,
0.59740259740259738, 0.8571428571428571, 0.81818181818181823,
0.7142857142857143, 0.87012987012987009, 0.70129870129870131,
0.67532467532467533, 0.88311688311688308, 0.96103896103896103,
0.72727272727272729, 0.89610389610389607, 0.98701298701298701,
0.77922077922077926, 0.63636363636363635, 0.59740259740259738,
0.74025974025974028, 0.8441558441558441, 0.88311688311688308,
0.66233766233766234, 1.025974025974026, 0.77922077922077926,
0.8571428571428571, 0.76623376623376627, 0.89610389610389607,
0.87012987012987009, 1.0129870129870129, 0.66233766233766234,
0.7142857142857143, 1.0909090909090908, 0.77922077922077926,
0.94805194805194803, 1.0389610389610389, 1.0389610389610389,
0.88311688311688308, 1.1038961038961039, 0.75324675324675328,
0.89610389610389607, 0.89610389610389607, 0.90909090909090906,
0.79220779220779225, 0.66233766233766234, 0.83116883116883122,
1.1298701298701299, 0.8571428571428571, 1.0779220779220779, 1.0779220779220779,
0.72727272727272729, 0.83116883116883122, 1.1168831168831168,
0.87012987012987009, 0.61038961038961037, 0.83116883116883122,
0.89610389610389607, 0.97402597402597402, 0.80519480519480524,
0.87012987012987009, 0.8441558441558441, 0.76623376623376627,
1, 0.74025974025974028, 0.96103896103896103, 0.87012987012987009,
0.41558441558441561, 0.81818181818181823, 0.68831168831168832,
0.72727272727272729, 0.90909090909090906, 0.89610389610389607,
0.79220779220779225, 0.8571428571428571, 0.75324675324675328,
0.76623376623376627, 0.74025974025974028, 0.8441558441558441,
0.8441558441558441, 1.025974025974026, 1.051948051948052, 0.93506493506493504,
0.97402597402597402, 1.0779220779220779, 0.94805194805194803,
0.79220779220779225, 0.79220779220779225, 0.75324675324675328,
1.0649350649350648, 0.76623376623376627, 1.025974025974026, 1.0129870129870129,
0.88311688311688308, 0.83116883116883122, 0.63636363636363635,
0.72727272727272729, 1.025974025974026, 0.8571428571428571, 0.76623376623376627,
0.72727272727272729, 0.8571428571428571, 0.8441558441558441,
0.80519480519480524, 0.70129870129870131, 1.0649350649350648,
0.80519480519480524, 0.94805194805194803, 0.74025974025974028,
0.81818181818181823, 0.66233766233766234, 1.0649350649350648,
0.98701298701298701, 0.90909090909090906, 1.0129870129870129,
0.81818181818181823, 1.0649350649350648, 0.90909090909090906,
0.8571428571428571, 0.81818181818181823, 1.0649350649350648,
0.77922077922077926, 0.67532467532467533, 0.8571428571428571,
0.76623376623376627, 0.77922077922077926, 1, 0.7142857142857143,
1.025974025974026, 0.68831168831168832, 0.97402597402597402,
0.72727272727272729, 0.89610389610389607, 0.76623376623376627,
0.74025974025974028, 0.83116883116883122, 0.72727272727272729,
0.72727272727272729, 0.92207792207792205, 0.67532467532467533,
0.81818181818181823, 0.8571428571428571, 0.77922077922077926,
0.87012987012987009, 1.0129870129870129, 0.83116883116883122,
1.0389610389610389, 0.80519480519480524, 0.8571428571428571,
1.0389610389610389, 0.70129870129870131, 0.97402597402597402,
0.96103896103896103, 0.68831168831168832, 1.1168831168831168,
1.0389610389610389, 0.92207792207792205, 0.80519480519480524,
0.68831168831168832, 0.75324675324675328, 0.67532467532467533,
0.8571428571428571, 0.96103896103896103, 0.80519480519480524,
1.0649350649350648, 0.7142857142857143, 1.1688311688311688, 0.92207792207792205,
0.67532467532467533, 0.8441558441558441, 0.90909090909090906,
0.63636363636363635, 1.0779220779220779, 1.0909090909090908,
1.0649350649350648, 1.0129870129870129, 0.88311688311688308,
1.0389610389610389, 0.74025974025974028, 1.051948051948052, 0.7142857142857143,
1.1428571428571428, 0.79220779220779225, 1.1168831168831168,
0.66233766233766234, 0.90909090909090906, 0.67532467532467533,
0.92207792207792205, 0.7142857142857143, 0.77922077922077926,
0.97402597402597402, 0.88311688311688308, 0.77922077922077926,
1.051948051948052, 1.0129870129870129, 0.89610389610389607, 1.0649350649350648,
0.93506493506493504, 0.7142857142857143, 0.76623376623376627,
0.88311688311688308, 0.88311688311688308, 0.72727272727272729,
0.81818181818181823, 0.94805194805194803, 0.77922077922077926,
1.0129870129870129, 0.93506493506493504, 0.93506493506493504,
0.70129870129870131, 0.68831168831168832, 0.77922077922077926,
0.7142857142857143, 0.96103896103896103, 0.7142857142857143,
0.76623376623376627, 0.75324675324675328, 1.1038961038961039,
0.54545454545454541, 1, 1.0129870129870129, 0.53246753246753242,
0.89610389610389607, 0.98701298701298701, 0.8441558441558441,
0.93506493506493504, 0.83116883116883122, 0.87012987012987009,
1.025974025974026, 0.75324675324675328, 1.0129870129870129, 0.83116883116883122,
0.77922077922077926, 0.8571428571428571, 0.8441558441558441,
0.53246753246753242, 0.90909090909090906, 0.76623376623376627,
0.76623376623376627, 0.80519480519480524, 1.0129870129870129,
0.7142857142857143, 0.94805194805194803, 0.93506493506493504,
0.75324675324675328, 1, 0.76623376623376627, 1.0779220779220779,
0.97402597402597402, 0.94805194805194803, 0.83116883116883122,
0.97402597402597402, 0.70129870129870131, 0.89610389610389607,
0.98701298701298701, 0.89610389610389607, 0.94805194805194803,
1.025974025974026, 0.59740259740259738, 0.8441558441558441, 0.77922077922077926,
0.72727272727272729, 0.90909090909090906, 0.94805194805194803,
0.81818181818181823, 0.66233766233766234, 0.8571428571428571,
0.76623376623376627, 0.8571428571428571, 0.90909090909090906,
0.96103896103896103, 0.79220779220779225, 0.74025974025974028,
0.77922077922077926, 1.0129870129870129, 0.59740259740259738,
0.67532467532467533, 0.96103896103896103, 0.94805194805194803,
0.67532467532467533, 0.92207792207792205, 0.94805194805194803,
0.8571428571428571, 0.89610389610389607, 0.8571428571428571,
0.80519480519480524, 0.94805194805194803, 0.92207792207792205,
0.81818181818181823, 0.8441558441558441, 0.87012987012987009,
1.0909090909090908, 1.0129870129870129, 0.96103896103896103,
0.88311688311688308, 0.74025974025974028, 0.89610389610389607,
0.96103896103896103, 0.62337662337662336, 0.79220779220779225,
0.79220779220779225, 0.8571428571428571, 0.97402597402597402,
1.1168831168831168, 0.8441558441558441, 0.8441558441558441, 1.025974025974026,
1.1818181818181819, 0.97402597402597402, 0.92207792207792205,
1.0649350649350648, 1.0129870129870129, 0.87012987012987009,
0.92207792207792205, 0.79220779220779225, 0.70129870129870131,
0.80519480519480524, 1.0389610389610389, 1.1428571428571428,
1.0389610389610389, 1.0779220779220779, 0.68831168831168832,
0.8571428571428571, 1.1818181818181819, 1.0909090909090908, 0.92207792207792205,
0.94805194805194803, 0.77922077922077926, 0.97402597402597402,
1.0909090909090908, 1.025974025974026, 1.1038961038961039, 1.051948051948052,
0.90909090909090906, 0.98701298701298701, 0.90909090909090906,
0.79220779220779225, 1.0779220779220779, 0.67532467532467533,
0.8441558441558441, 0.76623376623376627, 0.64935064935064934,
0.87012987012987009, 1.0909090909090908, 0.81818181818181823,
0.83116883116883122, 1, 0.81818181818181823, 0.83116883116883122,
0.88311688311688308, 0.93506493506493504, 1.0129870129870129,
0.97402597402597402, 1.1038961038961039, 0.81818181818181823,
0.94805194805194803, 0.88311688311688308, 0.94805194805194803,
0.80519480519480524, 0.79220779220779225, 0.98701298701298701,
1.0909090909090908, 0.93506493506493504, 1.1038961038961039,
0.77922077922077926, 0.79220779220779225, 0.94805194805194803,
0.79220779220779225, 0.59740259740259738, 1.051948051948052,
0.90909090909090906, 1.1168831168831168, 1.0909090909090908,
0.8571428571428571, 0.89610389610389607, 1.025974025974026, 1,
0.77922077922077926, 1.1688311688311688, 0.79220779220779225,
1.0779220779220779, 0.7142857142857143, 0.66233766233766234,
0.89610389610389607, 0.8441558441558441, 1.025974025974026, 1.1038961038961039,
1.051948051948052, 0.94805194805194803, 0.87012987012987009,
0.90909090909090906, 0.77922077922077926, 0.96103896103896103,
1.025974025974026, 0.89610389610389607, 1.0909090909090908, 0.98701298701298701,
1.1038961038961039, 1.0779220779220779, 1.1298701298701299, 1.0649350649350648,
1.0779220779220779, 1.0649350649350648, 0.90909090909090906,
0.8441558441558441, 0.97402597402597402, 0.90909090909090906,
1.0909090909090908, 0.90909090909090906, 0.89610389610389607,
1.1298701298701299, 0.80519480519480524, 0.75324675324675328,
1.0779220779220779, 0.90909090909090906, 0.94805194805194803,
1.0649350649350648, 0.79220779220779225, 0.96103896103896103,
1.0909090909090908, 1.0779220779220779, 0.74025974025974028,
0.76623376623376627, 0.88311688311688308, 0.87012987012987009,
0.64935064935064934, 1.0649350649350648, 1.0129870129870129,
0.98701298701298701, 0.8571428571428571, 1.0779220779220779,
1.1038961038961039, 0.96103896103896103, 0.90909090909090906,
0.92207792207792205, 0.8441558441558441, 0.81818181818181823,
0.8571428571428571, 0.88311688311688308, 1.1038961038961039,
1.1558441558441559, 0.96103896103896103, 0.92207792207792205,
1.0129870129870129, 0.8441558441558441, 0.88311688311688308,
0.81818181818181823, 0.7142857142857143, 0.88311688311688308,
1.0389610389610389, 1.0389610389610389, 1.0649350649350648, 1.0779220779220779,
0.79220779220779225, 0.96103896103896103, 0.64935064935064934,
0.76623376623376627, 0.8441558441558441, 1.2077922077922079,
0.94805194805194803, 1.1168831168831168, 1.1428571428571428,
0.89610389610389607, 1.1298701298701299, 1.0649350649350648,
1.1428571428571428, 0.8571428571428571, 0.92207792207792205,
1.0779220779220779, 1, 1.0909090909090908, 1.0779220779220779,
1.0649350649350648, 0.80519480519480524, 0.76623376623376627,
0.90909090909090906, 1.1298701298701299, 0.88311688311688308,
1.1168831168831168, 1.1038961038961039, 1.0649350649350648, 0.8441558441558441,
1.1298701298701299, 0.93506493506493504, 1.0909090909090908,
0.97402597402597402, 1.0389610389610389, 0.79220779220779225,
1.1168831168831168, 0.75324675324675328, 1.1168831168831168,
1.1948051948051948, 1.1168831168831168, 0.90909090909090906,
1.0389610389610389, 0.98701298701298701, 1.051948051948052, 1.0909090909090908,
0.94805194805194803, 0.75324675324675328, 0.90909090909090906,
0.89610389610389607, 0.94805194805194803, 0.93506493506493504,
0.92207792207792205, 1, 0.97402597402597402, 0.92207792207792205,
0.76623376623376627, 0.83116883116883122, 0.75324675324675328,
1.0649350649350648, 0.7142857142857143, 0.8441558441558441, 0.72727272727272729,
0.44155844155844154, 0.79220779220779225, 0.93506493506493504,
0.98701298701298701, 0.90909090909090906, 0.93506493506493504,
0.8571428571428571, 0.88311688311688308, 0.90909090909090906,
0.92207792207792205, 0.97402597402597402, 1.051948051948052,
0.76623376623376627, 1, 0.8441558441558441, 1.1038961038961039,
0.8441558441558441, 0.90909090909090906, 1.0649350649350648,
1.051948051948052, 0.74025974025974028, 0.98701298701298701,
0.81818181818181823, 0.93506493506493504, 0.89610389610389607,
0.81818181818181823, 0.72727272727272729, 0.90909090909090906,
0.97402597402597402, 0.89610389610389607, 1.025974025974026,
0.96103896103896103, 1.1298701298701299, 0.93506493506493504,
0.88311688311688308, 0.67532467532467533, 0.8441558441558441,
0.90909090909090906, 0.79220779220779225, 0.89610389610389607,
0.89610389610389607, 0.98701298701298701, 0.89610389610389607,
0.87012987012987009, 0.80519480519480524, 1.1558441558441559,
0.98701298701298701, 0.83116883116883122, 0.88311688311688308,
0.88311688311688308, 0.97402597402597402, 0.89610389610389607,
1.025974025974026, 0.92207792207792205, 0.90909090909090906,
0.96103896103896103, 0.90909090909090906, 1.025974025974026,
0.89610389610389607, 0.89610389610389607, 0.92207792207792205,
1, 0.8441558441558441, 0.96103896103896103, 0.8571428571428571,
0.8571428571428571, 0.83116883116883122, 0.98701298701298701,
0.8571428571428571, 0.8571428571428571, 0.88311688311688308,
0.90909090909090906, 0.94805194805194803, 0.8441558441558441,
0.94805194805194803, 0.8441558441558441, 0.98701298701298701,
0.93506493506493504, 0.87012987012987009, 0.90909090909090906,
0.79220779220779225, 0.79220779220779225, 0.97402597402597402,
1.0129870129870129, 0.87012987012987009, 0.87012987012987009,
1.0129870129870129, 0.70129870129870131, 0.97402597402597402,
0.88311688311688308, 0.77922077922077926, 0.77922077922077926,
0.94805194805194803, 0.8441558441558441, 0.89610389610389607,
0.96103896103896103, 0.89610389610389607, 0.83116883116883122,
1.025974025974026, 1.0129870129870129, 1.025974025974026, 0.81818181818181823,
1, 0.79220779220779225, 0.92207792207792205, 0.77922077922077926,
1.0389610389610389, 1, 0.98701298701298701, 0.83116883116883122,
0.72727272727272729, 0.89610389610389607, 0.8441558441558441,
0.8571428571428571, 0.81818181818181823, 0.72727272727272729,
0.98701298701298701, 0.96103896103896103, 0.93506493506493504,
0.81818181818181823, 1, 0.74025974025974028, 0.76623376623376627,
0.92207792207792205, 0.83116883116883122, 0.8571428571428571,
0.72727272727272729, 0.89610389610389607, 0.89610389610389607,
0.94805194805194803, 0.76623376623376627, 0.89610389610389607,
0.7142857142857143, 1.0389610389610389, 0.75324675324675328,
0.8571428571428571, 0.96103896103896103, 0.77922077922077926,
0.72727272727272729, 1.0389610389610389, 0.79220779220779225,
0.7142857142857143, 0.76623376623376627, 0.67532467532467533,
0.77922077922077926, 0.89610389610389607, 0.8441558441558441,
0.90909090909090906, 0.83116883116883122, 0.7142857142857143,
0.67532467532467533, 1.051948051948052, 0.92207792207792205,
0.90909090909090906, 0.8571428571428571, 0.80519480519480524,
0.97402597402597402, 0.89610389610389607, 0.88311688311688308,
1.0389610389610389, 1.0129870129870129, 0.93506493506493504,
0.83116883116883122, 0.81818181818181823, 0.88311688311688308,
0.87012987012987009, 1.1038961038961039, 0.83116883116883122,
0.8571428571428571, 1.0389610389610389, 0.94805194805194803,
0.89610389610389607, 0.97402597402597402, 0.92207792207792205,
0.88311688311688308, 0.8571428571428571, 0.90909090909090906,
0.97402597402597402, 0.94805194805194803, 1.0649350649350648,
0.97402597402597402, 1.051948051948052, 0.89610389610389607,
0.72727272727272729, 0.81818181818181823, 1.0779220779220779,
0.7142857142857143, 0.81818181818181823, 0.81818181818181823,
0.93506493506493504, 0.96103896103896103, 0.90909090909090906,
0.8571428571428571, 0.80519480519480524, 0.93506493506493504,
0.94805194805194803, 0.81818181818181823, 0.93506493506493504,
0.74025974025974028, 1.0909090909090908, 0.81818181818181823,
1.0649350649350648, 0.94805194805194803, 0.87012987012987009,
0.96103896103896103, 0.64935064935064934, 0.81818181818181823,
1.0129870129870129, 0.97402597402597402, 0.8441558441558441,
0.77922077922077926, 0.87012987012987009, 0.90909090909090906,
0.76623376623376627, 1.025974025974026, 0.92207792207792205,
1.0389610389610389, 0.87012987012987009, 0.98701298701298701,
0.8571428571428571, 0.93506493506493504, 0.80519480519480524,
0.75324675324675328, 0.8441558441558441, 0.98701298701298701,
0.80519480519480524, 0.88311688311688308, 0.79220779220779225,
0.98701298701298701, 0.63636363636363635, 0.64935064935064934,
0.87012987012987009, 1, 0.66233766233766234, 1, 0.93506493506493504,
0.83116883116883122, 1.051948051948052, 0.72727272727272729,
1, 0.90909090909090906, 0.83116883116883122, 0.98701298701298701,
0.98701298701298701, 1.051948051948052, 0.90909090909090906,
0.77922077922077926, 0.76623376623376627, 0.77922077922077926,
0.75324675324675328, 0.8441558441558441, 0.80519480519480524,
1.0909090909090908, 0.77922077922077926, 0.59740259740259738,
1.0129870129870129, 0.94805194805194803, 0.89610389610389607,
0.8571428571428571, 0.90909090909090906, 1.0909090909090908,
0.97402597402597402, 0.79220779220779225, 1.025974025974026,
0.83116883116883122, 0.67532467532467533, 1.0779220779220779,
0.62337662337662336, 0.92207792207792205, 0.90909090909090906,
0.89610389610389607, 0.97402597402597402, 0.74025974025974028,
0.72727272727272729, 1.0909090909090908, 1, 1, 1.025974025974026,
1.0779220779220779, 0.89610389610389607, 0.83116883116883122,
1.0389610389610389, 0.80519480519480524, 0.93506493506493504,
0.64935064935064934, 1.051948051948052, 0.8441558441558441, 0.83116883116883122,
1.0779220779220779, 0.80519480519480524, 0.77922077922077926,
1, 0.97402597402597402, 0.93506493506493504, 0.67532467532467533,
0.89610389610389607, 0.97402597402597402, 1, 0.54545454545454541,
0.81818181818181823, 1.0129870129870129, 0.94805194805194803,
1.0389610389610389, 1.0909090909090908, 1, 0.92207792207792205,
0.8571428571428571, 0.87012987012987009, 0.79220779220779225,
0.90909090909090906, 1.1168831168831168, 0.80519480519480524,
0.77922077922077926, 0.8571428571428571, 0.96103896103896103,
1.051948051948052, 1.0389610389610389, 1.0389610389610389, 0.92207792207792205,
1.025974025974026, 0.66233766233766234, 0.92207792207792205,
1.0129870129870129, 0.8441558441558441, 0.97402597402597402,
0.97402597402597402, 0.79220779220779225, 0.79220779220779225,
0.90909090909090906, 0.94805194805194803, 0.93506493506493504,
0.89610389610389607, 0.92207792207792205, 1.0909090909090908,
0.70129870129870131, 1.0779220779220779, 0.90909090909090906,
0.75324675324675328, 1.0129870129870129, 0.90909090909090906,
1, 0.67532467532467533, 0.98701298701298701, 0.89610389610389607,
1.0779220779220779, 0.88311688311688308, 0.93506493506493504,
0.98701298701298701, 0.93506493506493504, 0.54545454545454541,
0.8571428571428571, 0.79220779220779225, 0.62337662337662336,
1.0909090909090908, 0.96103896103896103, 0.75324675324675328,
1.0909090909090908, 0.72727272727272729, 0.67532467532467533,
0.94805194805194803, 0.98701298701298701, 0.96103896103896103,
0.79220779220779225, 0.98701298701298701, 0.87012987012987009,
0.68831168831168832, 0.77922077922077926, 0.76623376623376627,
0.97402597402597402, 1, 0.97402597402597402, 1.1038961038961039,
0.77922077922077926, 0.80519480519480524, 1.0649350649350648,
0.81818181818181823, 0.80519480519480524, 1.0129870129870129,
0.7142857142857143, 0.96103896103896103, 0.75324675324675328,
0.79220779220779225, 0.81818181818181823, 1.025974025974026,
0.94805194805194803, 1.051948051948052, 0.8441558441558441, 0.97402597402597402,
0.96103896103896103, 0.8441558441558441, 0.96103896103896103,
0.8571428571428571, 0.96103896103896103, 0.74025974025974028,
0.81818181818181823, 0.77922077922077926, 1.0389610389610389,
0.54545454545454541, 0.77922077922077926, 0.58441558441558439,
0.93506493506493504, 0.96103896103896103, 0.92207792207792205,
0.64935064935064934, 0.96103896103896103, 1, 0.8441558441558441,
0.83116883116883122, 0.63636363636363635, 0.76623376623376627,
0.81818181818181823, 0.66233766233766234, 0.75324675324675328,
0.94805194805194803, 0.88311688311688308, 0.72727272727272729,
1.1038961038961039, 0.90909090909090906, 0.87012987012987009,
0.97402597402597402, 0.94805194805194803, 0.90909090909090906,
1.0129870129870129, 1.1688311688311688, 0.97402597402597402,
0.79220779220779225, 0.80519480519480524, 1.0129870129870129,
1.051948051948052, 0.70129870129870131, 0.80519480519480524,
0.88311688311688308, 1.0649350649350648, 0.97402597402597402,
0.8441558441558441, 0.80519480519480524, 0.8441558441558441,
1, 1.0389610389610389, 0.79220779220779225, 1.051948051948052,
0.80519480519480524, 1.025974025974026, 0.96103896103896103,
1, 0.77922077922077926, 0.8441558441558441, 1.0129870129870129,
0.8441558441558441, 0.8571428571428571, 0.80519480519480524,
0.74025974025974028, 0.93506493506493504, 0.94805194805194803,
1.0649350649350648, 1.0129870129870129, 1.0129870129870129, 0.77922077922077926,
0.76623376623376627, 1.051948051948052, 0.79220779220779225,
0.98701298701298701, 1.051948051948052, 0.96103896103896103,
0.90909090909090906, 0.93506493506493504, 0.89610389610389607,
0.92207792207792205, 0.92207792207792205, 1.0389610389610389,
0.8441558441558441, 0.96103896103896103, 0.90909090909090906,
1.0649350649350648, 0.87012987012987009, 1.0389610389610389,
0.79220779220779225, 0.81818181818181823, 0.83116883116883122,
0.83116883116883122, 0.8571428571428571, 0.92207792207792205,
0.8571428571428571, 0.89610389610389607, 0.90909090909090906,
0.64935064935064934, 1, 0.7142857142857143, 0.77922077922077926,
0.94805194805194803, 1.0389610389610389, 0.97402597402597402,
0.94805194805194803, 0.87012987012987009, 0.77922077922077926,
0.97402597402597402, 0.87012987012987009, 1, 0.93506493506493504,
0.8571428571428571, 1.051948051948052, 0.89610389610389607, 1.0129870129870129,
0.88311688311688308, 1.0129870129870129, 0.98701298701298701,
0.70129870129870131, 0.81818181818181823, 0.66233766233766234,
1.0389610389610389, 0.90909090909090906, 0.83116883116883122,
1, 0.79220779220779225, 0.8571428571428571, 1.0779220779220779,
0.72727272727272729, 0.7142857142857143, 0.55844155844155841,
0.98701298701298701, 0.62337662337662336, 0.87012987012987009,
1.0649350649350648, 0.94805194805194803, 0.96103896103896103,
0.90909090909090906, 0.66233766233766234, 1.0649350649350648,
0.98701298701298701, 0.62337662337662336, 0.77922077922077926,
0.97402597402597402, 1.0389610389610389, 0.81818181818181823,
0.77922077922077926, 0.77922077922077926, 0.87012987012987009,
0.89610389610389607, 0.75324675324675328, 0.89610389610389607,
0.89610389610389607, 0.7142857142857143, 0.70129870129870131,
0.8441558441558441, 1.0909090909090908, 0.89610389610389607,
1.0779220779220779, 0.8571428571428571, 1.025974025974026, 0.81818181818181823,
1.0779220779220779, 0.8571428571428571, 0.83116883116883122,
0.81818181818181823, 0.87012987012987009, 0.75324675324675328,
0.98701298701298701, 1.1688311688311688, 0.89610389610389607,
0.8441558441558441, 0.8571428571428571, 0.90909090909090906,
0.93506493506493504, 0.70129870129870131, 0.64935064935064934,
0.90909090909090906, 0.7142857142857143, 0.77922077922077926,
0.79220779220779225, 0.93506493506493504, 1.1168831168831168,
0.83116883116883122, 1.0129870129870129, 0.92207792207792205,
1.0389610389610389, 0.76623376623376627, 0.88311688311688308,
0.98701298701298701, 0.88311688311688308), cohort = structure(c(1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 3L, 3L, 3L, 3L,
3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
3L, 3L, 3L, 3L, 3L, 3L, 3L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L,
5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L,
5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L,
5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L,
5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L,
5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L,
5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L,
5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 6L, 6L, 6L, 6L, 6L, 6L,
6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L,
6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L,
6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L,
6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L,
6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L,
6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L,
6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L,
6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L,
6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L,
6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L,
6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L,
6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L,
6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L,
6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L,
6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L,
6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L,
6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 7L, 7L, 7L, 7L, 7L, 7L,
7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L,
7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L,
7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L,
7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L,
7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L,
7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L,
7L, 7L, 7L, 7L, 7L, 7L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L,
8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L,
8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L,
8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L,
8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L,
8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L,
8L, 8L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L,
9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L,
9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L,
9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L,
9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L,
9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L,
9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L,
9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L,
9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L,
9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L,
9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L,
9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L,
9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L,
9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L,
9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L,
9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L,
9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L,
9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L,
9L, 9L, 9L, 9L, 9L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L,
10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L,
10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L,
10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L,
10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L,
10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L,
10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L,
10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L,
10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L,
10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L,
10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L,
10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L,
10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L,
10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L,
10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 11L, 11L, 11L, 11L, 11L,
11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L,
11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L,
11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L,
11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L,
11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L,
13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L,
13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L,
13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L,
13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L,
13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L,
13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L,
13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L,
13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L,
13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L,
13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L,
13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L,
13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L,
13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L,
13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L,
13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L,
13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L,
13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L,
13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L,
13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L,
13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
14L, 14L, 14L, 14L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
16L, 16L, 16L, 16L, 16L, 16L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 18L,
18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L,
18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L,
18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L,
18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L,
18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L,
18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L,
18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L,
18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L,
18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L,
18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L,
18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L,
18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L,
18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L,
18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L,
18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L,
18L, 18L, 18L, 18L, 18L, 18L, 18L, 18L, 19L, 19L, 19L, 19L, 19L,
19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L,
19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L,
19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L,
19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L,
19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L,
19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L,
19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L,
19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L,
19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L,
19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L,
19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L,
19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L,
19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L,
19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L,
19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L,
19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L,
19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L,
19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L,
19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L,
19L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L,
20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L,
20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L,
20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L,
20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L,
20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 21L, 21L,
21L, 21L, 21L, 21L, 21L, 21L, 21L, 21L, 21L, 21L, 21L, 21L, 21L,
21L, 21L, 21L, 21L, 21L, 21L, 21L, 21L, 21L, 21L, 21L, 21L, 21L,
21L, 21L, 21L, 21L, 21L, 21L, 21L, 21L, 21L, 21L, 21L, 21L, 21L,
21L, 21L, 21L, 21L, 21L, 21L, 21L, 21L, 21L, 22L, 22L, 22L, 22L,
22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L,
22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L,
22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L,
22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L,
22L, 22L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
23L, 23L, 23L), .Label = c("1", "2", "3", "4", "5", "6", "7",
"8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18",
"19", "20", "21", "22", "23"), class = "factor"), sui = structure(c(36,
36, 36, 36, 34, 36, 36, 36, 36, 36, 36, 36, 22, 4, 36, 36, 36,
5, 36, 36, 36, 26, 36, 36, 36, 36, 18, 36, 33, 36, 36, 36, 36,
36, 36, 36, 36, 26, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 14, 36, 36, 36, 36, 36, 28, 36, 36, 32, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 2, 36, 36, 36,
36, 36, 35, 36, 36, 20, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 29, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 17, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 34, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 22,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 19, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 23,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 32, 36, 36, 36, 36, 36,
22, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 33, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
27, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 9, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 30, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 33, 36, 29, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 32, 36, 36, 36, 36, 36, 36,
36, 28, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 28, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 31, 36, 36, 36, 36, 36, 36, 36, 1, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 13, 36, 36, 36, 36, 36, 36, 36, 15, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 26, 36, 36, 36, 36, 36, 36, 36, 36,
4, 36, 36, 36, 36, 36, 27, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 19, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 7, 36, 36, 36, 36, 36, 36, 36, 36, 36,
8, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 32, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 34,
36, 36, 36, 36, 36, 36, 36, 11, 36, 36, 36, 36, 36, 30, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 30, 36, 36, 36, 36, 36, 36, 9, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 18, 36, 36, 36, 2, 36, 36, 36, 5,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 23, 36, 36, 36,
36, 36, 36, 36, 36, 32, 36, 36, 36, 35, 36, 36, 13, 30, 36, 36,
36, 36, 36, 9, 36, 21, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 29, 36, 15, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 29, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 32, 36,
36, 36, 36, 36, 36, 36, 15, 4, 36, 36, 36, 36, 23, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 9, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 6, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
28, 36, 36, 36, 36, 36, 36, 36, 36, 13, 36, 28, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 6, 36, 15, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 11, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 5, 36, 36, 36, 36, 36, 36, 36, 36, 25, 9,
36, 36, 36, 36, 36, 36, 34, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 34, 36, 36, 36, 36, 18, 36, 36, 36, 36, 36, 10,
36, 21, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 2, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 16, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 18, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 13, 36, 36, 36, 36, 4, 36, 20, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 33, 36, 36, 36, 18, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 6, 36, 36, 36, 15, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 34, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 35,
36, 36, 36, 27, 29, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 35, 36, 36, 36, 58.200000000000003,
31, 81.099999999999994, 63.600000000000001, 78.099999999999994,
59.700000000000003, 75.599999999999994, 65.200000000000003, 73,
68.900000000000006, 71.200000000000003, 70, 69.400000000000006,
64.700000000000003, 68.400000000000006, 67.299999999999997, 15.699999999999999,
64, 12.1, 65.200000000000003, 14.4, 26, 55.100000000000001, 56.5,
56, 81.5, 80.400000000000006, 78.5, 76.900000000000006, 76.700000000000003,
74, 75.299999999999997, 54.600000000000001, 63.299999999999997,
71.299999999999997, 46.5, 56.200000000000003, 69.700000000000003,
63.100000000000001, 54.5, 68, 64.200000000000003, 63.299999999999997,
63.5, 63.100000000000001, 63.799999999999997, 61.299999999999997,
77.099999999999994, 73.900000000000006, 73.400000000000006, 75.299999999999997,
75.900000000000006, 74.400000000000006, 72.5, 74.299999999999997,
74.299999999999997, 63.399999999999999, 62.899999999999999, 12.6,
69.200000000000003, 69.799999999999997, 68.700000000000003, 64.900000000000006,
47.600000000000001, 56.700000000000003, 53, 56.200000000000003,
56, 55.5, 57.399999999999999, 53, 36.100000000000001, 80.400000000000006,
9, 39.200000000000003, 36.700000000000003, 72.900000000000006,
72.5, 71.900000000000006, 71.700000000000003, 70.900000000000006,
69.5, 70, 69.299999999999997, 68.900000000000006, 68.700000000000003,
66.200000000000003, 64, 63.100000000000001, 24.399999999999999,
57.299999999999997, 55, 80.5, 79.900000000000006, 26.199999999999999,
79.900000000000006, 79.200000000000003, 48.700000000000003, 70.400000000000006,
66.700000000000003, 55.899999999999999, 68.099999999999994, 60.100000000000001,
6.2000000000000002, 65, 66.299999999999997, 61, 60.600000000000001,
52.899999999999999, 22.5, 59.399999999999999, 58.799999999999997,
56, 53.200000000000003, 55.700000000000003, 54.399999999999999,
55.5, 55.5, 52.5, 53.899999999999999, 81.799999999999997, 81.5,
80.400000000000006, 79, 79.400000000000006, 71.900000000000006,
58.100000000000001, 62.799999999999997, 57.299999999999997, 66.799999999999997,
71.400000000000006, 50.799999999999997, 69.599999999999994, 70,
68.900000000000006, 40, 30.199999999999999, 64.799999999999997,
10, 59.399999999999999, 80.299999999999997, 78, 51.100000000000001,
72.200000000000003, 35.399999999999999, 69.299999999999997, 70.700000000000003,
50.5, 68.099999999999994, 68.099999999999994, 65, 80.099999999999994,
69.299999999999997, 68.200000000000003, 81, 80.099999999999994,
80.299999999999997, 75, 74.099999999999994, 77.599999999999994,
73.200000000000003, 66.799999999999997, 69.700000000000003, 55.299999999999997,
68.599999999999994, 15.9, 62.200000000000003, 27.600000000000001,
58.5, 58.700000000000003, 56.700000000000003, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 15, 36, 36, 26, 23, 36, 36, 36, 12, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 1, 36, 0, 13, 5, 8, 29, 15, 12, 30, 36, 36, 36, 35, 36,
36, 36, 36, 21, 36, 36, 36, 36, 36, 36, 36, 36, 18, 36, 8, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 14, 36, 36, 36, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
35, 36, 36, 36, 36, 36, 36, 35, 36, 36, 36, 36, 36, 36, 36, 36,
36, 36, 4, 36, 29, 36, 36, 26, 36, 36, 36, 36, 36, 36, 36, 32,
21, 36, 23, 36, 36, 36, 33, 36, 36, 36, 36, 9, 36, 7, 36, 36,
36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 49, 22, 17, 26, 48, 31,
34, 47, 3, 47, 47, 21, 45, 39, 12, 17, 43, 43, 42, 29, 42, 42,
41, 17, 3, 40, 12, 10, 41, 17, 40, 39, 15, 39, 38, 38, 38, 37,
37, 32, 37, 15, 24, 37, 37, 36, 36, 36, 36, 36, 36, 33, 35, 35,
35, 31, 17, 34, 33, 33, 33, 33, 33, 33, 33, 32, 4, 31, 31, 30,
31, 4, 30, 18, 27, 30, 3, 14, 30, 19, 8, 46, 13, 45, 16, 5, 44,
31, 34, 7, 17, 8, 40, 16, 4, 16, 16, 39, 35, 37, 36, 36, 16,
36, 17, 35, 35, 11, 35, 34, 33, 33, 31, 24, 30, 30, 60, 21, 60,
60, 54, 60, 5, 60, 6, 60, 45, 60, 36, 22, 60, 56, 60, 62, 32,
60, 60, 60, 60, 60, 60, 60, 56, 32, 10, 60, 28, 60, 60, 28, 56,
19, 60, 60, 60, 60, 62, 60, 60, 28, 60, 60, 60, 60, 27, 60, 43,
60, 60, 60, 60, 55, 21, 57, 50, 29, 60, 56, 60, 21, 68, 60, 60,
24, 49, 60, 60, 43, 60, 29, 60, 60, 60, 60, 60, 60, 11, 60, 57,
60, 48, 60, 34, 60, 32, 60, 54, 18, 60, 60, 60, 12, 60, 60, 60,
60, 60, 31, 31, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 25, 60,
60, 3, 60, 23, 60, 33, 14, 60, 60, 39, 60, 60, 60, 60, 60, 60,
60, 60, 60, 45, 60, 60, 24, 60, 60, 60, 60, 7, 60, 60, 51, 39,
60, 60, 41, 60, 62, 2, 11, 60, 60, 60, 60, 60, 34, 26, 60, 60,
60, 60, 45, 60, 60, 60, 60, 1, 57, 60, 60, 19, 60, 60, 60, 60,
3, 60, 60, 60, 37, 60, 60, 10, 60, 60, 60, 60, 14, 60, 60, 60,
60, 56, 60, 60, 20, 60, 60, 60, 60, 60, 42, 11, 45, 37, 33, 60,
60, 13, 60, 57, 55, 60, 60, 5, 60, 43, 60, 60, 60, 60, 60, 60,
60, 60, 60, 60, 60, 60, 60, 60, 60, 52, 60, 60, 60, 60, 60, 56,
39, 18, 17, 60, 54, 11, 60, 44, 60, 60, 60, 60, 21, 60, 60, 60,
44, 60, 60, 60, 60, 60, 60, 60, 60, 60, 29, 34, 60, 96, 115,
42, 62, 36, 96, 62, 17, 128, 71, 162, 72, 140, 46, 26, 20, 136,
66, 38, 77, 84, 12, 170, 63, 10, 168, 120, 80, 136, 72, 96, 156,
84, 76, 76, 76, 108, 136, 68, 36, 46, 136, 60, 76, 67, 96, 130,
130, 12, 84, 136, 120, 53, 108, 108, 96, 60, 156, 118, 60, 72,
84, 120, 12, 108, 156, 108, 156, 84, 43, 148, 108, 84, 104, 28,
21, 84, 84, 96, 61, 108, 120, 61, 60, 120, 136, 53, 36, 60, 48,
31, 48, 51, 84, 13, 16, 40, 15, 60, 14, 108, 12, 24, 96, 24,
96, 96, 60, 89, 76, 20, 3, 41, 45, 91, 44, 11, 39, 39, 66, 50,
36, 2, 20, 67, 67, 63, 60, 67, 23, 14, 18, 80, 62, 28, 14, 30,
10, 67, 61, 35, 67, 24, 65, 17, 6, 19, 27, 68, 11, 22, 20, 11,
90, 13, 60, 64, 90, 9, 15, 90, 11, 91, 23, 65, 17, 38, 36, 65,
12, 13, 14, 13, 65, 36, 10, 58, 18, 19, 35, 13, 13, 64, 14, 85,
14, 19, 25, 19, 21, 12, 10, 25, 15, 18, 23, 21, 23, 23, 12, 40.700000000000003,
4.7000000000000002, 173, 195.5, 45.5, 64.200000000000003, 70,
3.2000000000000002, 72.799999999999997, 102.09999999999999, 17,
4.2999999999999998, 200.5, 221.90000000000001, 134.69999999999999,
23.399999999999999, 49.200000000000003, 157.09999999999999, 19.899999999999999,
21.899999999999999, 60, 154.80000000000001, 1.1000000000000001,
98.299999999999997, 95.5, 220.69999999999999, 49.200000000000003,
54.600000000000001, 144.80000000000001, 120.5, 43.799999999999997,
36.899999999999999, 219.80000000000001, 49.399999999999999, 47.899999999999999,
36, 171.09999999999999, 89.599999999999994, 3.7999999999999998,
223, 56.600000000000001, 188.40000000000001, 73.400000000000006,
117, 87.200000000000003, 61.200000000000003, 9.1999999999999993,
149.80000000000001, 51.600000000000001, 89, 86.400000000000006,
89.900000000000006, 28.5, 146, 218.69999999999999, 88.299999999999997,
168.59999999999999, 1.6000000000000001, 141.5, 69.400000000000006,
38.799999999999997, 38.299999999999997, 78.799999999999997, 23.600000000000001,
109.59999999999999, 3.8999999999999999, 0.5, 194.90000000000001,
202.09999999999999, 79.400000000000006, 23.600000000000001, 55.200000000000003,
149.30000000000001, 58.700000000000003, 11.800000000000001, 110.59999999999999,
58.5, 26.300000000000001, 28.899999999999999, 155.90000000000001,
5.9000000000000004, 176.69999999999999, 74.5, 37.899999999999999,
217.40000000000001, 169.69999999999999, 92.5, 21.300000000000001,
146.59999999999999, 141.59999999999999, 18.699999999999999, 88.799999999999997,
134.30000000000001, 216.09999999999999, 75.099999999999994, 70.299999999999997,
58.899999999999999, 8.5999999999999996, 157.30000000000001, 28.199999999999999,
158.40000000000001, 87.900000000000006, 48.799999999999997, 215.5,
36.100000000000001, 17.800000000000001, 91.400000000000006, 63.100000000000001,
143.19999999999999, 212.80000000000001, 43.700000000000003, 8.6999999999999993,
212.59999999999999, 10.6, 135.5, 212.09999999999999, 187, 74.099999999999994,
132.30000000000001, 134, 53.200000000000003, 75.900000000000006,
6.9000000000000004, 32.399999999999999, 110.90000000000001, 8.0999999999999996,
75.099999999999994, 211.40000000000001, 211.40000000000001, 136.09999999999999,
136.69999999999999, 129.59999999999999, 75.799999999999997, 22.399999999999999,
134.19999999999999, 36.700000000000003, 207.09999999999999, 14.4,
96.799999999999997, 27.899999999999999, 41.5, 32.700000000000003,
0.69999999999999996, 1.6000000000000001, 116.90000000000001,
210.69999999999999, 11, 53.399999999999999, 35.799999999999997,
26.199999999999999, 16.899999999999999, 80, 173.80000000000001,
2.7999999999999998, 29.600000000000001, 60.700000000000003, 209.69999999999999,
54, 73, 210.19999999999999, 128.19999999999999, 210.19999999999999,
12.4, 141.80000000000001, 29.699999999999999, 12.800000000000001,
10.300000000000001, 84.599999999999994, 69.299999999999997, 67.200000000000003,
39.899999999999999, 209.30000000000001, 58.5, 164.59999999999999,
95.599999999999994, 209.30000000000001, 9.3000000000000007, 209.19999999999999,
6.7000000000000002, 68.400000000000006, 209.09999999999999, 122,
74.700000000000003, 209, 138.40000000000001, 46.5, 129.80000000000001,
29.100000000000001, 18, 60.399999999999999, 81, 47.799999999999997,
134.59999999999999, 73.700000000000003, 208.5, 46.399999999999999,
208.30000000000001, 208.40000000000001, 109.2, 26.300000000000001,
105.8, 128.30000000000001, 13.6, 208, 205, 37.299999999999997,
208, 191.5, 58, 107.8, 207.90000000000001, 88.599999999999994,
207.80000000000001, 34.899999999999999, 178.09999999999999, 37.299999999999997,
111.90000000000001, 17.699999999999999, 105.59999999999999, 205.40000000000001,
2.5, 168.90000000000001, 39.5, 52.5, 94.700000000000003, 184.40000000000001,
125.40000000000001, 206.30000000000001, 206.09999999999999, 91.099999999999994,
164.69999999999999, 52.399999999999999, 65.200000000000003, 37.899999999999999,
192.09999999999999, 138.30000000000001, 191.5, 85.599999999999994,
104.2, 206, 206, 75.200000000000003, 33.100000000000001, 81.299999999999997,
129.40000000000001, 204.90000000000001, 15.9, 205.59999999999999,
205.5, 205.5, 47.700000000000003, 141.30000000000001, 158.30000000000001,
41.899999999999999, 205.09999999999999, 7.5999999999999996, 204.80000000000001,
84, 204.69999999999999, 204.59999999999999, 57.100000000000001,
85.400000000000006, 29.300000000000001, 204.59999999999999, 61,
75.099999999999994, 69.099999999999994, 0.90000000000000002,
45.5, 18.199999999999999, 131.80000000000001, 126, 35.100000000000001,
91.799999999999997, 146.80000000000001, 38.700000000000003, 92.200000000000003,
107.40000000000001, 79.799999999999997, 100.09999999999999, 189.30000000000001,
204.59999999999999, 53.200000000000003, 150.40000000000001, 85.200000000000003,
191.09999999999999, 204.19999999999999, 47.100000000000001, 12.4,
29.600000000000001, 115.5, 12.300000000000001, 2.6000000000000001,
121.5, 29.300000000000001, 20.100000000000001, 9, 99.799999999999997,
96, 76.200000000000003, 258.39999999999998, 1.2, 83.099999999999994,
45.799999999999997, 121.09999999999999, 96.299999999999997, 74.700000000000003,
93.799999999999997, 13.5, 146.80000000000001, 25.399999999999999,
87.700000000000003, 14.800000000000001, 29.199999999999999, 77.299999999999997,
252.90000000000001, 62.100000000000001, 219.40000000000001, 112.3,
61.299999999999997, 60.799999999999997, 128.30000000000001, 77.799999999999997,
17.399999999999999, 3.5, 3, 12.9, 66.700000000000003, 188.69999999999999,
77.900000000000006, 109.09999999999999, 150.69999999999999, 129.80000000000001,
37.5, 26.699999999999999, 0.69999999999999996, 90.400000000000006,
258.10000000000002, 19.699999999999999, 24.100000000000001, 142.40000000000001,
13.1, 15.6, 17.5, 233.80000000000001, 4.7000000000000002, 31.5,
2.2999999999999998, 199.80000000000001, 26.699999999999999, 12.6,
20.300000000000001, 40.700000000000003, 113.2, 42.5, 115.5, 27.5,
27.5, 4.5999999999999996, 17.100000000000001, 4.4000000000000004,
25.300000000000001, 175.90000000000001, 31.800000000000001, 3.2000000000000002,
17, 104.5, 76.5, 118.59999999999999, 8.9000000000000004, 17.199999999999999,
48.600000000000001, 72.400000000000006, 25.399999999999999, 165.19999999999999,
142.80000000000001, 58.600000000000001, 3.7999999999999998, 184.5,
64.299999999999997, 4, 78.099999999999994, 15.4, 100.09999999999999,
7.4000000000000004, 5.7000000000000002, 28.399999999999999, 15.4,
154.90000000000001, 76.700000000000003, 228.40000000000001, 50.799999999999997,
39.399999999999999, 60.899999999999999, 10.1, 78.099999999999994,
46.5, 10.699999999999999, 110.8, 20.800000000000001, 15, 139.40000000000001,
44.200000000000003, 167.40000000000001, 28.699999999999999, 38.299999999999997,
160.40000000000001, 88.400000000000006, 87.900000000000006, 121,
5.4000000000000004, 42.100000000000001, 134.80000000000001, 38.399999999999999,
1.6000000000000001, 77.099999999999994, 41.799999999999997, 4,
102.5, 105, 38.799999999999997, 159.80000000000001, 30.800000000000001,
23.399999999999999, 155, 45.5, 155.80000000000001, 164.90000000000001,
43.899999999999999, 67.400000000000006, 39.200000000000003, 82.200000000000003,
170, 85.299999999999997, 12, 79.700000000000003, 54.700000000000003,
137.09999999999999, 65.799999999999997, 1.3999999999999999, 86.700000000000003,
28.699999999999999, 71.099999999999994, 11.699999999999999, 55.5,
31.600000000000001, 138.59999999999999, 81.900000000000006, 99.200000000000003,
78.599999999999994, 171, 10.199999999999999, 46.100000000000001,
127.09999999999999, 91.299999999999997, 72.400000000000006, 55.299999999999997,
38, 24.699999999999999, 80.400000000000006, 60.5, 163.59999999999999,
172.59999999999999, 30.399999999999999, 40.299999999999997, 70.099999999999994,
97.599999999999994, 98.799999999999997, 25.399999999999999, 31.5,
7.2000000000000002, 161.90000000000001, 18.100000000000001, 38.5,
21.100000000000001, 95.599999999999994, 40.799999999999997, 43,
58, 20, 76, 85, 66, 75, 57, 66, 84, 23, 90, 84, 85, 92, 85, 48,
48, 90, 83, 71, 76, 46, 81, 84, 70, 41, 91, 56, 90, 85, 10, 85,
78, 34, 87, 74, 29, 73, 81, 46, 14, 85, 84, 74, 25, 42, 43, 85,
42, 38, 78, 26, 89, 44, 92, 42, 85, 92, 88, 85, 7, 91, 22, 81,
68, 92, 92, 198.96000000000001, 181.19999999999999, 208.44, 98.640000000000001,
36.960000000000001, 147.84, 211.68000000000001, 71.519999999999996,
56.159999999999997, 58.560000000000002, 118.08, 198.12, 16.440000000000001,
59.280000000000001, 122.76000000000001, 245.40000000000001, 77.760000000000005,
178.80000000000001, 228.84, 8.4000000000000004, 171.59999999999999,
13.199999999999999, 10.800000000000001, 41.039999999999999, 142.44,
163.44, 102.59999999999999, 172.80000000000001, 123.72, 126.59999999999999,
36.479999999999997, 50.520000000000003, 88.920000000000002, 38.039999999999999,
98.879999999999995, 36.479999999999997, 149.75999999999999, 32.039999999999999,
151.08000000000001, 62.520000000000003, 236.75999999999999, 30.719999999999999,
131.75999999999999, 14.16, 107.76000000000001, 126.72, 184.91999999999999,
65.640000000000001, 44.399999999999999, 207.72, 91.680000000000007,
10.44, 213.59999999999999, 126.95999999999999, 220.08000000000001,
5.2800000000000002, 15.24, 126.72, 212.52000000000001, 14.640000000000001,
182.03999999999999, 78, 72.840000000000003, 123.84, 238.56, 158.63999999999999,
95.280000000000001, 22.32, 226.44, 168.84, 217.56, 102.72, 26.640000000000001,
202.80000000000001, 226.19999999999999, 111.72, 248.03999999999999,
238.56, 236.63999999999999, 40.079999999999998, 237, 116.88,
155.28, 203.40000000000001, 27.960000000000001, 224.40000000000001,
148.80000000000001, 16.32, 59.880000000000003, 121.2, 93.719999999999999,
67.439999999999998, 94.200000000000003, 72.959999999999994, 189.96000000000001,
109.92, 166.80000000000001, 109.8, 121.44, 18.359999999999999,
6.2400000000000002, 232.44, 94.439999999999998, 124.08, 27.239999999999998,
121.2, 136.08000000000001, 150.36000000000001, 176.75999999999999,
89.879999999999995, 130.31999999999999, 9.7200000000000006, 120.48,
146.88, 112.8, 195.24000000000001, 20.16, 233.88, 122.04000000000001,
24.48, 193.44, 15.6, 162.12, 29.399999999999999, 124.08, 178.08000000000001,
211.19999999999999, 38.640000000000001, 17.760000000000002, 151.80000000000001,
115.8, 6.96, 181.44, 33.359999999999999, 77.280000000000001,
78.599999999999994, 102.23999999999999, 120.84, 171.84, 161.63999999999999,
8.6400000000000006, 193.56, 132.47999999999999, 112.2, 91.680000000000007,
225.24000000000001, 89.040000000000006, 193.80000000000001, 178.80000000000001,
91.560000000000002, 199.19999999999999, 39.719999999999999, 119.40000000000001,
214.19999999999999, 157.80000000000001, 155.28, 54.960000000000001,
74.159999999999997, 91.319999999999993, 102.59999999999999, 18.120000000000001,
142.80000000000001, 208.91999999999999, 123.36, 28.800000000000001,
47.640000000000001, 145.08000000000001, 89.400000000000006, 172.31999999999999,
180.84, 222, 65.280000000000001, 17.280000000000001, 139.08000000000001,
60, 61.68, 93.719999999999999, 217.19999999999999, 155.03999999999999,
206.40000000000001, 66.599999999999994, 29.52, 122.64, 101.04000000000001,
13.08, 145.44, 110.76000000000001, 160.91999999999999, 148.31999999999999,
238.31999999999999, 40.920000000000002, 36.719999999999999, 150.59999999999999,
252.59999999999999, 101.64, 125.52, 33.719999999999999, 241.44,
183.59999999999999, 217.08000000000001, 14.4, 66.480000000000004,
182.16, 160.91999999999999, 140.88, 95.640000000000001, 215.40000000000001,
115.08, 223.19999999999999, 199.19999999999999, 179.03999999999999,
137.03999999999999, 207.24000000000001, 89.879999999999995, 114.84,
236.16, 109.56, 11.16, 90.959999999999994, 122.52, 156.59999999999999,
194.16, 144.47999999999999, 137.75999999999999, 71.159999999999997,
90.719999999999999, 188.28, 44.759999999999998, 200.40000000000001,
128.75999999999999, 177.12, 114.12, 182.40000000000001, 142.19999999999999,
26.039999999999999, 44.280000000000001, 64.200000000000003, 243.84,
146.75999999999999, 29.16, 15.48, 130.68000000000001, 149.75999999999999,
112.31999999999999, 22.68, 56.759999999999998, 25.920000000000002,
4.2000000000000002, 173.28, 232.68000000000001, 129.84, 208.08000000000001,
154.31999999999999, 191.28, 189.36000000000001, 104.64, 167.03999999999999,
68.040000000000006, 84, 48, 131.52000000000001, 119.16, 125.04000000000001,
84.719999999999999, 64.319999999999993, 59.039999999999999, 146.88,
241.80000000000001, 175.31999999999999, 152.52000000000001, 15.6,
145.56, 137.75999999999999, 146.88, 27.84, 111.23999999999999,
100.31999999999999, 204.59999999999999, 109.8, 216.84, 50.880000000000003,
64.799999999999997, 47.280000000000001, 64.200000000000003, 54.840000000000003,
161.40000000000001, 120.59999999999999, 170.63999999999999, 56.520000000000003,
117.95999999999999, 80.760000000000005, 66, 87.120000000000005,
36.840000000000003, 218.03999999999999, 9.3599999999999994, 169.80000000000001,
142.19999999999999, 157.80000000000001, 81.120000000000005, 130.80000000000001,
210.36000000000001, 169.31999999999999, 150.47999999999999, 236.03999999999999,
136.91999999999999, 186.36000000000001, 117.72, 149.75999999999999,
122.40000000000001, 134.63999999999999, 129, 197.52000000000001,
213.59999999999999, 104.76000000000001, 141, 167.75999999999999,
119.64, 23.399999999999999, 133.44, 198.36000000000001, 127.68000000000001,
225.84, 26.879999999999999, 248.75999999999999, 126.23999999999999,
149.63999999999999, 5.7599999999999998, 201.36000000000001, 131.16,
149.52000000000001, 153.47999999999999, 226.56, 81, 18.600000000000001,
68.040000000000006, 7.4400000000000004, 146.16, 187.80000000000001,
155.16, 201.24000000000001, 29.640000000000001, 114.48, 141.24000000000001,
244.56, 115.08, 168.84, 41.280000000000001, 63, 90.719999999999999,
83.159999999999997, 150.47999999999999, 41.759999999999998, 171.59999999999999,
48.960000000000001, 207.96000000000001, 148.31999999999999, 122.40000000000001,
114.23999999999999, 94.200000000000003, 155.88, 22.68, 63.240000000000002,
178.44, 172.08000000000001, 41.399999999999999, 99.239999999999995,
158.63999999999999, 120.48, 120.48, 233.03999999999999, 129.47999999999999,
27.719999999999999, 65.400000000000006, 161.88, 217.31999999999999,
199.68000000000001, 32.759999999999998, 132.12, 155.52000000000001,
152.40000000000001, 63, 119.28, 146.03999999999999, 46.439999999999998,
210.96000000000001, 59.159999999999997, 134.03999999999999, 111.36,
99.480000000000004, 11.4, 71.760000000000005, 137.75999999999999,
205.91999999999999, 89.640000000000001, 93.719999999999999, 172.68000000000001,
146.52000000000001, 196.19999999999999, 226.44, 12.720000000000001,
25.440000000000001, 160.56, 44.759999999999998, 135.72, 225.72,
171.72, 150.12, 24.48, 22.079999999999998, 207.84, 210.72, 126.12,
106.44, 146.16, 179.40000000000001, 39.719999999999999, 112.8,
74.159999999999997, 142.31999999999999, 46.68, 59.039999999999999,
64.079999999999998, 127.2, 57.719999999999999, 26.879999999999999,
132.59999999999999, 162.36000000000001, 175.44, 164.03999999999999,
45.479999999999997, 42, 168.59999999999999, 240.96000000000001,
178.80000000000001, 88.799999999999997, 19.079999999999998, 46.560000000000002,
24.600000000000001, 168.84, 181.56, 167.40000000000001, 158.40000000000001,
51.119999999999997, 237.72, 36, 196.80000000000001, 195, 143.52000000000001,
117.72, 168.24000000000001, 132.72, 137.88, 165.96000000000001,
23.52, 100.44, 116.76000000000001, 154.56, 181.44, 131.75999999999999,
128.03999999999999, 222.47999999999999, 36.119999999999997, 55.799999999999997,
128.88, 66.239999999999995, 57.600000000000001, 204.24000000000001,
81.480000000000004, 67.439999999999998, 91.319999999999993, 172.91999999999999,
10.56, 43.32, 129.72, 112.2, 112.68000000000001, 120, 82.920000000000002,
237, 131.75999999999999, 120.59999999999999, 170.63999999999999,
51.240000000000002, 133.68000000000001, 189.84, 58.079999999999998,
82.680000000000007, 247.31999999999999, 59.640000000000001, 184.80000000000001,
81.719999999999999, 21.719999999999999, 135.59999999999999, 17.640000000000001,
194.88, 50.159999999999997, 83.879999999999995, 111, 87.959999999999994,
131.63999999999999, 99.239999999999995, 162.72, 195.59999999999999,
115.31999999999999, 118.2, 36, 97.079999999999998, 66.599999999999994,
7.0800000000000001, 137.52000000000001, 70.560000000000002, 15.359999999999999,
94.439999999999998, 210.36000000000001, 79.439999999999998, 46.32,
129.72, 36.240000000000002, 79.680000000000007, 122.16, 106.2,
155.75999999999999, 68.280000000000001, 114.36, 33, 86.519999999999996,
130.68000000000001, 11.16, 103.68000000000001, 214.44, 156.84,
243.47999999999999, 203.16, 239.03999999999999, 260.88, 138.72,
166.31999999999999, 260.75999999999999, 120, 198.24000000000001,
207.36000000000001, 90.719999999999999, 79.560000000000002, 75.239999999999995,
65.879999999999995, 16.68, 115.44, 232.56, 132.47999999999999,
52.200000000000003, 11.880000000000001, 15.6, 94.319999999999993,
23.16, 215.63999999999999, 91.319999999999993, 71.400000000000006,
70.680000000000007, 118.2, 29.039999999999999, 157.19999999999999,
74.040000000000006, 102.36, 127.56, 53.159999999999997, 107.28,
115.44, 142.44, 221.88, 213.72, 73.079999999999998, 113.88, 134.28,
72.400000000000006, 68.599999999999994, 79.900000000000006, 69.5,
25.600000000000001, 83.799999999999997, 67.799999999999997, 33.100000000000001,
52.700000000000003, 28.899999999999999, 80.099999999999994, 88,
77.400000000000006, 66.900000000000006, 78.200000000000003, 78.799999999999997,
78.5, 78.5, 79.5, 66.200000000000003, 64.700000000000003, 75.200000000000003,
87.599999999999994, 87.700000000000003, 48.399999999999999, 86.700000000000003,
72.5, 80.099999999999994, 54.200000000000003, 78.5, 77.5, 76.200000000000003,
75.5, 75.599999999999994, 52.399999999999999, 87.599999999999994,
75.5, 50.899999999999999, 71.299999999999997, 63.700000000000003,
86, 71.5, 57.299999999999997, 44.899999999999999, 78.700000000000003,
52.600000000000001, 44.700000000000003, 52.700000000000003, 67,
37, 78.5, 77.900000000000006, 63.799999999999997, 77.400000000000006,
31.600000000000001, 56.799999999999997, 84.599999999999994, 50.5,
70.400000000000006, 81.400000000000006, 67.599999999999994, 69.799999999999997,
68.799999999999997, 6.2000000000000002, 68, 47.799999999999997,
52.399999999999999, 58, 2.1000000000000001, 83.900000000000006,
51.200000000000003, 84.200000000000003, 77, 54.700000000000003,
66.799999999999997, 76.900000000000006, 67.200000000000003, 81.5,
61.799999999999997, 57.5, 78.099999999999994, 68.5, 70.799999999999997,
57.100000000000001, 81.400000000000006, 77.900000000000006, 64.599999999999994,
32.399999999999999, 80, 52.200000000000003, 29.100000000000001,
86.700000000000003, 62, 74.900000000000006, 71.400000000000006,
58.299999999999997, 70.200000000000003, 70.5, 79.700000000000003,
48.5, 67.400000000000006, 55.600000000000001, 63.799999999999997,
55.399999999999999, 84.200000000000003, 71.299999999999997, 50.799999999999997,
63.399999999999999, 51.700000000000003, 57.100000000000001, 70.099999999999994,
75.200000000000003, 78.099999999999994, 65.599999999999994, 76,
75.900000000000006, 82.299999999999997, 54.700000000000003, 74.700000000000003,
54, 66.099999999999994, 79.5, 71.5, 84.099999999999994, 70.099999999999994,
70.799999999999997, 68.200000000000003, 52.799999999999997, 55.899999999999999,
83.900000000000006, 75.900000000000006, 61.600000000000001, 76.200000000000003,
60.299999999999997, 70.299999999999997, 83.700000000000003, 68.700000000000003,
56.799999999999997, 81.799999999999997, 69.900000000000006, 80,
77.299999999999997, 76.200000000000003, 78, 67.400000000000006,
39.799999999999997, 79.5, 87.799999999999997, 87.799999999999997,
86.400000000000006, 72.400000000000006, 86.5, 46.100000000000001,
84.700000000000003, 84.099999999999994, 61.899999999999999, 84.099999999999994,
81, 83.200000000000003, 78.099999999999994, 81.299999999999997,
78.799999999999997, 68.900000000000006, 68.900000000000006, 80.200000000000003,
79.5, 55.899999999999999, 81.599999999999994, 54.299999999999997,
79.299999999999997, 66.400000000000006, 77.099999999999994, 78.099999999999994,
77.799999999999997, 66, 59.799999999999997, 77.599999999999994,
77.400000000000006, 77.099999999999994, 76.5, 63.799999999999997,
87.599999999999994, 74.200000000000003, 68, 84.200000000000003,
70.599999999999994, 71.799999999999997, 71.099999999999994, 70.5,
82.700000000000003, 82.299999999999997, 69.700000000000003, 81.299999999999997,
68.700000000000003, 25.399999999999999, 54, 76.599999999999994,
76.400000000000006, 62.899999999999999, 62.899999999999999, 55.899999999999999,
62.600000000000001, 61.899999999999999, 71.599999999999994, 57.799999999999997,
72.700000000000003, 34.399999999999999, 68.5, 56.100000000000001,
68.200000000000003, 67.900000000000006, 55.399999999999999, 54.799999999999997,
54.899999999999999, 66.599999999999994, 64.299999999999997, 63.5,
50.299999999999997, 62.299999999999997, 62.200000000000003, 49.600000000000001,
48.700000000000003, 60.299999999999997, 58.200000000000003, 45.600000000000001,
45.399999999999999, 45.5, 56.399999999999999, 54.100000000000001,
43.799999999999997, 54, 37, 51, 51.200000000000003, 50.5, 37.899999999999999,
49.799999999999997, 37.299999999999997, 36.100000000000001, 35.700000000000003,
35, 47, 33.100000000000001, 44.700000000000003, 31.600000000000001,
43.700000000000003, 43.700000000000003, 44, 31.399999999999999,
30.899999999999999, 42.399999999999999, 41.399999999999999, 40.200000000000003,
40.100000000000001, 38.200000000000003, 37.700000000000003, 37.100000000000001,
29.5, 72, 71, 57, 70, 68, 61, 8, 49, 67, 67, 71, 65, 14, 23,
70, 70, 66, 70, 68, 66, 65, 67, 65, 63, 70, 32, 68, 70, 65, 37,
41, 67, 65, 68, 68, 62, 65, 66, 21, 69, 69, 68, 68, 62, 51, 66,
24, 60, 51, 68, 68, 69, 66, 9, 67, 32, 41, 64, 67, 64, 51, 66,
69, 64, 50, 67, 52, 69, 64, 67, 68, 65, 59, 63, 57, 62, 13, 65,
63, 62, 14, 67, 56, 64, 65, 68, 37, 65, 58, 43, 19, 30, 50, 65,
56, 67, 54, 64, 16, 31, 64, 65, 36, 64, 61, 68, 59, 56, 64, 27,
35, 1, 68, 63, 22, 64, 64, 65, 65, 51, 58, 65, 64, 67, 67, 59,
64, 64, 60, 66, 67, 67, 67, 64, 66, 65, 36, 65, 53, 61, 66, 66,
66, 66, 47, 66, 66, 36, 59, 12, 65, 63, 61, 50, 49, 62, 54, 67,
20, 68, 7, 63, 66, 56, 39, 46, 65, 60, 66, 7, 52, 59, 4, 63,
58, 17, 64, 45, 64, 14, 44, 22, 67, 62, 62, 64, 67, 65, 65, 67,
61, 30, 64, 60, 67, 63, 64, 42, 63, 64, 54, 53, 27, 63, 63, 67,
33, 66, 65, 64, 53, 63, 27, 43, 21, 63, 62, 61, 64, 54, 62, 62,
64, 58, 19, 64, 59, 22, 66, 23, 63, 51, 66, 60, 64, 54, 26, 67,
43, 64, 65, 51, 32, 54, 64, 24, 65, 65, 49, 62, 62, 57, 49, 40,
60, 65, 60, 51, 32, 60, 62, 60, 60, 25, 65, 59, 34, 12, 60, 57,
43, 63, 61, 46, 63, 62, 64, 62, 61, 59, 62, 23, 22, 57, 65, 66,
59, 63, 3, 65, 36, 60, 62, 23, 62, 57, 59, 56, 22, 64, 65, 57,
59, 64, 62, 64, 46, 30, 57, 60, 31, 16, 31, 64, 64, 41, 62, 64,
62, 62, 63, 58, 41, 59, 64, 60, 35, 63, 60, 64, 64, 65, 21, 63,
43, 62, 65, 40, 20, 38, 53, 60, 60, 42, 23, 63, 2, 61, 59, 22,
55, 51, 49, 63, 28, 41, 38, 48, 64, 31, 63, 56, 64, 62, 62, 59,
45, 58, 63, 15, 22, 60, 60, 63, 62, 27, 61, 62, 57, 61, 64, 46,
64, 59, 58, 11, 37, 60, 64, 59, 18, 63, 58, 64, 62, 60, 37, 62,
60, 62, 53, 62, 50, 60, 40, 30, 35, 63, 61, 62, 60, 62, 62, 62,
62, 61, 33, 62, 60, 61, 61, 64, 58, 56, 60, 57, 59, 61, 60, 4,
57, 60, 57, 43, 63, 61, 14, 60, 25, 62, 39, 28, 60, 45, 33, 59,
61, 38, 60, 61, 33, 20, 61, 58, 59, 61, 62, 55, 62, 62, 51, 60,
7, 53, 19, 56, 31, 58, 60, 54, 58, 56, 60, 49, 11, 57, 39, 58,
60, 62, 59, 62, 52, 56, 59, 59, 46, 61, 45, 56, 59, 21, 58, 59,
62, 19, 57, 59, 61, 60, 46, 58, 56, 13, 57, 14, 57, 32, 22, 61,
60, 45, 53, 56, 62, 59, 60, 62, 36, 51, 57, 32, 24, 58, 56, 59,
29, 32, 56, 60, 57, 58, 58, 33, 17, 62, 59, 31, 48, 59, 58, 58,
59, 26, 57, 32, 60, 53, 59, 62, 43, 59, 56, 56, 57, 62, 57, 56,
57, 54, 49, 44, 56, 60, 61, 61, 35, 55, 61, 57, 34, 58, 45, 56,
56, 55, 57, 58, 25, 37, 56, 59, 55, 54, 23, 61, 59, 60, 28, 59,
61, 60, 60, 60, 58, 55, 57, 46, 57, 15, 56, 56, 57, 49, 56, 60,
41, 24, 22, 55, 57, 34, 54, 53, 24, 57, 57, 56, 55, 58, 56, 57,
29, 55, 33, 58, 52, 60, 48, 60, 60, 54, 15, 56, 60, 38, 54, 55,
35, 50, 56, 57, 24, 57, 54, 59, 59, 58, 57, 59, 56, 53, 57, 56,
53, 40, 20, 60, 53, 38, 52, 58, 57, 27, 59, 60, 54, 54, 60, 57,
40, 10, 36, 19, 58, 58, 58, 56, 16, 53, 54, 55, 56, 53, 56, 59,
9, 25, 43, 55, 56, 56, 53, 47, 51, 57, 56, 60, 42, 32, 57, 28,
57, 56, 58, 25, 55, 54, 20, 56, 56, 38, 35, 57, 46, 58, 56, 14,
55, 55, 56, 41, 53, 30, 35, 18, 24, 56, 58, 57, 3, 29, 59, 56,
58, 13, 57, 56, 51, 56, 39, 55, 56, 43, 56, 42, 53, 52, 54, 56,
55, 57, 55, 50, 41, 56, 10, 27, 54, 55, 45, 55, 53, 55, 38, 55,
12, 56, 49, 55, 54, 34, 52, 43, 51, 26, 55, 34, 20, 55, 55, 28,
54, 51, 47, 19, 34, 58, 51, 56, 25, 53, 50, 55, 57, 52, 56, 52,
53, 54, 55, 54, 56, 55, 47, 48, 58, 48, 45, 51, 58, 47, 55, 22,
55, 34, 56, 47, 26, 55, 49, 54, 54, 54, 49, 53, 24, 7, 55, 55,
56, 55, 47, 57, 52, 52, 46, 32, 8, 57, 54, 58, 57, 47, 51, 53,
53, 46, 46, 54, 49, 38, 52, 54, 54, 6, 45, 57, 56, 53, 54, 49,
56, 29, 56, 46, 52, 51, 53, 49, 31, 53, 19, 55, 56, 55, 16, 51,
31, 42, 54, 56, 12, 38, 45, 19, 54, 48, 52, 54, 6, 51, 50, 55,
35, 21, 49, 51, 49, 13, 48, 5, 57, 7, 30, 40, 47, 54, 57, 50,
53, 53, 54, 48, 45, 49, 54, 53, 52, 23, 47, 51, 50, 50, 5, 30,
54, 47, 47, 53, 50, 54, 52, 13, 37, 28, 46, 46, 54, 55, 54, 51,
53, 53, 52, 51, 56, 45, 52, 45, 22, 46, 50, 47, 53, 55, 50, 55,
40, 54, 44, 39, 53, 54, 53, 53, 10, 8, 14, 53, 53, 55, 46, 43,
40, 38, 8, 14, 53, 50, 52, 55, 51, 28, 41, 21, 53, 54, 51, 53,
46, 49, 52, 54, 55, 53, 8, 51, 47, 43, 50, 43, 49, 53, 28, 54,
49, 42, 46, 52, 5, 55, 52, 50, 50, 52, 48, 51, 18, 53, 20, 49,
32, 50, 51, 7, 52, 50, 50, 53, 49, 50, 25, 49, 18, 53, 9, 54,
54, 49, 13, 41, 54, 9, 32, 28, 43, 54, 51, 40, 55, 44, 52, 25,
28, 50, 51, 53, 54, 22, 52, 52, 11, 11, 55, 52, 54, 50, 48, 18,
6, 51, 52, 15, 53, 42, 52, 20, 52, 53, 35, 44, 43, 51, 14, 31,
38, 35, 19, 54, 34, 49, 49, 54, 44, 24, 55, 32, 38, 15, 40, 50,
18, 24, 46, 7, 48, 6, 42, 18, 52, 40, 49, 52, 7, 36, 48, 32,
51, 6, 37, 45, 53, 52, 45, 50, 47, 49, 52, 53, 40, 29, 51, 28,
54, 53, 42, 34, 50, 24, 47, 54, 54, 7, 43, 48, 38, 42, 19, 37,
46, 47, 47, 47, 47, 42, 50, 51, 46, 17, 49, 7, 10, 10, 52, 53,
11, 49, 39, 46, 52, 43, 53, 50, 48, 50, 44, 39, 32, 11, 43, 49,
47, 10, 47, 48, 37, 44, 53, 53, 51, 45, 48, 51, 49, 45, 45, 49,
26, 50, 50, 50, 47, 50, 52, 51, 47, 22, 49, 24, 49, 50, 20, 51,
47, 52, 17, 21, 51, 48, 21, 48, 8, 46, 48, 47, 47, 48, 48, 50,
53, 45, 11, 48, 48, 48, 52, 49, 52, 37, 47, 42, 37, 50, 12, 52,
28, 44, 48, 13, 50, 50, 44, 48, 31, 52, 50, 51, 49, 49, 37, 49,
48, 4, 46, 13, 14, 48, 16, 49, 48, 43, 47, 17, 48, 46, 47, 38,
45, 48, 51, 52, 50, 48, 48, 16, 34, 23, 40, 24, 39, 16, 48, 49,
17, 47, 50, 49, 43, 50, 15, 46, 45, 46, 47, 47, 34, 44, 47, 46,
23, 49, 52, 46, 47, 48, 31, 7, 18, 46, 48, 50, 6, 48, 48, 49,
21, 46, 51, 39, 2, 47, 47, 46, 50, 51, 42, 39, 25, 36, 19, 18,
50, 47, 39, 47, 47, 15, 21, 44, 47, 49, 51, 47, 48, 47, 34, 20,
47, 47, 45, 49, 50, 28, 44, 41, 46, 48, 8, 21, 47, 41, 29, 45,
49, 44, 47, 50, 47, 37, 7, 7, 21, 48, 49, 44, 15, 48, 43, 47,
44, 42, 50, 47, 47, 5, 7, 27, 30, 37, 49, 47, 12, 45, 32, 26,
12, 25, 45, 43, 48, 50, 18, 13, 31, 23, 50, 46, 23, 8, 35, 47,
45, 14, 47, 15, 42, 11, 39, 45, 49, 11, 35, 43, 29, 42, 25, 40,
14, 8, 47, 10, 47, 34, 29, 33, 9, 43, 38, 44, 38, 4, 46, 38,
46, 27, 45, 36, 15, 45, 38, 47, 44, 48, 45, 41, 27, 5, 41, 15,
44, 42, 31, 40, 41, 13, 10, 47, 10, 46, 47, 48, 45, 28, 30, 39,
48, 31, 44, 44, 18, 44, 44, 46, 34, 32, 35, 43, 42, 42, 45, 25,
39, 45, 42, 36, 44, 5, 43, 15, 46, 42, 44, 41, 44, 47, 18, 32,
25, 42, 39, 12, 6, 40, 20, 41, 17, 46, 40, 35, 43, 43, 4, 27,
44, 40, 42, 14, 43, 44, 44, 43, 43, 38, 35, 47, 45, 44, 3, 7,
44, 46, 42, 44, 9, 29, 47, 31, 41, 41, 46, 27, 11, 44, 45, 44,
45, 36, 32, 42, 42, 42, 43, 12, 14, 4, 43, 43, 42, 43, 5, 40,
42, 45, 46, 43, 40, 38, 43, 34, 38, 25, 45, 44, 14, 42, 41, 44,
10, 41, 37, 42, 30, 43, 43, 29, 41, 6, 29, 26, 40, 43, 42, 16,
43, 46, 43, 40, 28, 40, 26, 43, 42, 30, 42, 42, 42, 43, 15, 45,
41, 3, 41, 42, 42, 38, 10, 18, 40, 9, 44, 40, 45, 42, 6, 42,
40, 42, 41, 6, 23, 41, 45, 43, 40, 43, 42, 41, 29, 40, 42, 18,
11, 36, 15, 42, 24, 38, 40, 43, 33, 10, 32, 40, 42, 36, 41, 40,
41, 6, 3, 42, 30, 16, 44, 40, 45, 20, 12, 21, 42, 42, 39, 13,
33, 20, 27, 3, 41, 36, 32, 36, 7, 27, 40, 31, 45, 42, 45, 45,
39, 44, 39, 43, 42, 43, 15, 35, 39, 19, 28, 41, 38, 40, 39, 31,
37, 41, 40, 44, 41, 38, 41, 38, 6, 40, 42, 19, 9, 41, 41, 43,
36, 16, 42, 41, 40, 10, 29, 42, 39, 32, 43, 36, 43, 41, 40, 41,
44, 38, 39, 20, 39, 43, 39, 41, 43, 1, 42, 40, 32, 38, 40, 38,
38, 38, 29, 3, 39, 40, 39, 18, 43, 44, 40, 43, 39, 42, 40, 28,
35, 41, 42, 39, 42, 36, 41, 40, 35, 40, 40, 40, 37, 39, 39, 39,
41, 40, 32, 37, 40, 15, 26, 33, 37, 31, 40, 40, 30, 36, 39, 36,
19, 5, 39, 41, 40, 4, 37, 41, 41, 42, 21, 17, 42, 35, 4, 3, 42,
35, 12, 36, 42, 40, 40, 17, 38, 39, 37, 41, 39, 39, 40, 39, 37,
37, 42, 40, 41, 42, 35, 39, 39, 30, 39, 38, 37, 15, 28, 24, 38,
37, 31, 1, 12, 14, 29, 38, 28, 37, 36, 35, 38, 10, 5, 10, 36,
42, 42, 25, 42, 38, 6, 39, 40, 41, 41, 36, 42, 41, 38, 38, 40,
21, 41, 37, 7, 36, 17, 36, 38, 21, 37, 3, 7, 41, 38, 37, 35,
37, 6, 27, 41, 37, 40, 38, 38, 12, 36, 34, 41, 18, 34, 35, 38,
40, 37, 37, 5, 36, 38, 37, 39, 38, 42, 38, 31, 37, 32, 38, 40,
35, 40, 36, 38, 34, 39, 39, 37, 38, 34, 41, 36, 39, 38, 30, 37,
36, 38, 34, 33, 36, 40, 26, 8, 6, 37, 36, 36, 23, 25, 34, 39,
34, 30, 21, 35, 36, 39, 37, 37, 36, 36, 25, 37, 34, 38, 35, 35,
36, 3, 34, 36, 35, 37, 40, 36, 37, 39, 36, 36, 37, 36, 23, 17,
37, 35, 17, 37, 6, 36, 36, 38, 37, 7, 4, 34, 37, 36, 36, 34,
36, 35, 34, 36, 35, 39, 28, 37, 37, 36, 38, 35, 36, 35, 16, 37,
34, 36, 37, 36, 35, 30, 39, 36, 36, 26, 32, 36, 36, 35, 29, 35,
23, 39, 35, 36, 35, 13, 35, 35, 39, 33, 36, 35, 27, 36, 30, 36,
39, 37, 35, 30, 4, 32, 3, 34, 24, 36, 36, 36, 33, 36, 32, 35,
37, 33, 5, 33, 33, 24, 35, 36, 35, 33, 26, 36, 35, 36, 33, 26,
33, 31, 32, 32, 25, 22, 38, 6, 31, 34, 3, 35, 35, 32, 35, 35,
31, 32, 9, 34, 3, 35, 34, 33, 9, 18, 33, 32, 35, 35, 34, 27,
35, 31, 34, 31, 17, 38, 36, 34, 34, 34, 11, 29, 35, 32, 34, 32,
35, 12, 30, 37, 33, 21, 34, 27, 31, 35, 22, 34, 36, 33, 35, 35,
37, 36, 35, 33, 5, 4, 34, 31, 14, 26, 9, 23, 31, 28, 36, 34,
14, 12, 30, 37, 6, 31, 28, 33, 32, 34, 33, 31, 27, 35, 6, 27,
30, 31, 30, 29, 16, 31, 34, 35, 32, 26, 25, 28, 31, 23, 21, 30,
27, 32, 33, 16, 30, 31, 31, 32, 34, 20, 29, 28, 16, 6, 26, 30,
29, 20, 28, 50, 133, 133, 1, 133, 40, 14, 133, 133, 39, 133,
133, 132, 132, 132, 132, 132, 132, 132, 132, 132, 114, 132, 89,
132, 67, 132, 33, 76, 60, 47, 132, 132, 132, 131, 24, 131, 131,
131, 131, 131, 131, 131, 112, 83, 111, 131, 131, 131, 116, 50,
116, 131, 131, 63, 131, 131, 131, 131, 110, 131, 98, 131, 131,
88, 23, 131, 21, 131, 51, 130, 130, 130, 130, 130, 130, 35, 130,
130, 129, 126, 129, 129, 123, 129, 129, 129, 129, 129, 129, 129,
129, 129, 129, 129, 129, 110, 39, 129, 129, 15, 129, 129, 100,
118, 53, 128, 128, 128, 29, 128, 47, 128, 13, 111, 128, 50, 128,
118, 67, 128, 128, 128, 128, 25, 127, 127, 127, 126, 50, 67,
126, 126, 53, 28, 25, 126, 126, 43, 24, 126, 36, 126, 126, 126,
33, 9, 125, 95, 125, 125, 125, 113, 125, 125, 125, 91, 74, 5,
121, 125, 125, 125, 70, 124, 55, 119, 119, 36, 34, 106, 124,
124, 64, 79, 124, 124, 99, 124, 124, 110, 124, 124, 124, 123,
105, 123, 11, 75, 123, 102, 110, 123, 123, 71, 60, 36, 123, 123,
27, 123, 93, 39, 123, 123, 123, 123, 123, 41, 123, 48, 122, 43,
122, 82, 122, 122, 82, 83, 98, 60, 86, 122, 100, 59, 122, 122,
108, 31, 122, 122, 122, 3, 45, 16, 36, 97, 89, 39, 121, 55, 100,
121, 37, 121, 17, 22, 120, 33, 60, 42, 120, 86, 120, 120, 120,
111, 89, 120, 98, 120, 120, 120, 60, 120, 18, 13, 120, 109, 120,
120, 119, 119, 24, 119, 27, 104, 119, 6, 18, 49, 119, 23, 119,
119, 3, 119, 97, 119, 119, 73, 9, 119, 99, 119, 12, 118, 118,
118, 118, 102, 118, 118, 119, 58, 118, 34, 86, 118, 47, 118,
118, 26, 117, 117, 117, 117, 117, 117, 28, 117, 45, 9, 117, 117,
117, 26, 117, 8, 117, 35, 117, 116, 82, 116, 116, 116, 69, 46,
116, 116, 32, 116, 116, 116, 116, 116, 97, 70, 116, 69, 37, 116,
116, 116, 116, 116, 31, 99, 16, 73, 56, 47, 116, 29, 115, 35,
103, 80, 22, 114, 114, 68, 37, 52, 67, 114, 49, 114, 114, 114,
113, 22, 113, 113, 113, 113, 113, 105, 113, 113, 113, 6, 91,
113, 113, 113, 103, 91, 113, 113, 85, 91, 113, 100, 113, 113,
113, 39, 72, 85, 112, 112, 106, 112, 112, 112, 10, 72, 35, 112,
55, 112, 46, 112, 112, 112, 112, 112, 32, 112, 73, 80, 99, 112,
17, 111, 14, 111, 111, 111, 111, 111, 57, 111, 75, 111, 111,
15, 111, 80, 111, 62, 8, 42, 56, 111, 111, 22, 78, 103, 57, 110,
110, 110, 9, 25, 64, 96, 59, 14, 61, 52, 110, 110, 109, 118,
144, 210, 150, 200, 204, 150, 203, 167, 196, 198, 204, 203, 209,
147, 197, 195, 207, 201, 170, 182, 182, 210, 196, 207, 217, 201,
204, 196, 210, 203, 160, 197, 182, 208, 205, 211, 141, 205, 179,
136, 196, 201, 211, 159, 132, 200, 205, 160, 146, 172, 209, 211,
212, 202, 206, 204, 204, 214, 163, 188, 208, 123, 199, 158, 176,
207, 135, 201, 173, 174, 212, 146, 177, 208, 171, 200, 174, 135,
129, 199, 200, 203, 216, 195, 215, 160, 180, 202, 198, 205, 203,
205, 210, 209, 201, 134, 208, 125, 203, 116, 199, 129, 212, 208,
205, 214, 199, 208, 210, 211, 199, 205, 211, 210, 152, 128, 210,
198, 198, 200, 211, 213, 203, 215, 199, 181, 189, 204, 211, 136,
140, 203, 149, 208, 198, 126, 171, 216, 212, 148, 142, 199, 209,
139, 211, 195, 198, 154, 137, 201, 211, 127, 205, 198, 211, 197,
158, 126, 212, 205, 200, 207, 203, 210, 212, 203, 181, 211, 216,
201, 208, 167, 151, 200, 144, 207, 183, 141, 212, 195, 203, 158,
202, 209, 204, 185, 127, 215, 210, 177, 211, 195, 145, 198, 173,
211, 202, 186, 207, 205, 208, 209, 174, 209, 207, 130, 212, 215,
213, 211, 212, 214, 203, 203, 214, 134, 214, 199, 187, 133, 203,
138, 214, 131, 115, 215, 130, 202, 209, 211, 200, 174, 212, 203,
201, 191, 214, 137, 203, 204, 204, 170, 204, 203, 140, 152, 151,
203, 128, 128, 210, 195, 202, 179, 211, 209, 208, 162, 119, 147,
202, 211, 215, 200, 204, 205, 132, 208, 208, 210, 212, 205, 211,
211, 202, 199, 134, 188, 133, 170, 181, 170, 147, 199, 205, 210,
216, 203, 163, 217, 155, 203, 155, 216, 209, 210, 145, 198, 212,
211, 215, 192, 170, 216, 216, 214, 212, 210, 211, 205, 199, 173,
209, 203, 202, 215, 197, 199, 198, 214, 203, 201, 171, 205, 148,
214, 203, 194, 208, 209, 141, 203, 209, 198, 136, 210, 196, 197,
149, 202, 136, 176, 146, 157, 205, 121, 197, 203, 128, 199, 200,
214, 125, 120, 204, 216, 159, 200, 139, 210, 217, 192, 182, 203,
146, 202, 210, 214, 200, 199, 202, 200, 211, 188, 201, 200, 160,
217, 167, 209, 143, 142, 142, 200, 204, 196, 202, 216, 200, 203,
196, 137, 195, 212, 215, 157, 212, 211, 207, 193, 136, 210, 194,
137, 211, 204, 204, 214, 200, 118, 202, 209, 215, 201, 203, 203,
136, 204, 211, 121, 213, 214, 210, 166, 126, 129, 196, 203, 214,
214, 145, 208, 136, 211, 202, 213, 211, 201, 210, 196, 208, 211,
208, 198, 216, 211, 214, 140, 193, 177, 191, 205, 201, 169, 208,
198, 214, 143, 198, 199, 181, 201, 176, 172, 212, 136, 178, 184,
214, 205, 217, 204, 203, 210, 144, 198, 201, 213, 207, 208, 183,
202, 182, 203, 212, 216, 217, 202, 199, 168, 194, 190, 185, 202,
186, 202, 134, 199, 192, 203, 213, 195, 149, 188, 205, 198, 182,
158, 153, 156, 212, 19, 84, 106, 82, 119, 100, 22, 42, 102, 128,
64, 16, 59, 55, 64, 75, 48, 35, 87, 54, 32, 111, 87, 41, 97,
102, 36, 69, 60, 30, 105, 17, 15, 52, 123, 63, 73, 11, 101, 22,
67, 112, 110, 34, 29, 90, 122, 81, 36, 24, 22, 69, 24, 56, 45,
46, 68, 102, 33, 46, 7, 103, 45, 109, 15, 149, 72, 92, 56, 118,
40, 113, 10, 13, 51, 107, 72, 88, 18, 108, 33, 72, 12, 60, 22,
31, 104, 19, 13, 90, 40, 86, 37, 36, 40, 4, 50, 36, 63, 70, 33,
70, 87, 6, 122, 4, 214, 99, 121, 39, 37, 122, 93, 67, 89, 106,
53, 86, 63, 70, 122, 85, 103, 44, 83, 77, 50, 39, 86, 74, 91,
84, 46, 71, 129, 16, 96, 100, 119, 77, 48, 214, 60, 82, 92, 118,
65, 83, 73, 96, 108, 205, 32, 109, 209, 61, 19, 120, 87, 100,
84, 74, 119, 10, 103, 112, 45, 112, 126, 36, 49, 119, 68, 52,
61, 16, 14, 91, 124, 31, 74, 121, 92, 107, 105, 47, 63, 110,
208, 58, 32, 94, 27, 87, 118, 74, 38, 91, 111, 63, 47, 28, 67,
62, 47, 68, 58, 62, 21, 84, 207, 40, 21, 108, 80, 55, 60, 93,
83, 67, 96, 100, 28, 97, 40, 22, 80, 90, 97, 36, 110, 35, 95,
94, 66, 116, 101, 88, 39, 60, 68, 109, 71, 70, 27, 103, 64, 23,
92, 45, 78, 14, 87, 109, 101, 98, 84, 111, 57, 109, 110, 24,
52, 80, 114, 96, 96, 36, 108, 48, 59, 196, 43, 113, 190, 32,
34, 36, 72, 47, 95, 8, 92, 128, 100, 94, 117, 117, 109, 49, 78,
59, 22, 112, 27, 32, 125, 49, 16, 71, 122, 148, 92, 83, 57, 166,
21, 40, 107, 55, 24, 109, 112, 51, 44, 111, 114, 55, 105, 97,
33, 52, 24, 66, 98, 2, 23, 104, 4, 107, 51, 76, 112, 97, 32,
5, 101, 15, 42, 69, 64, 90, 117, 107, 120, 99, 102, 73, 81, 82,
81, 83, 95, 77, 101, 87, 132, 33, 30, 93, 126, 121, 21, 30, 27,
112, 108, 8, 103, 80, 123, 53, 24, 33, 81, 61, 38, 125, 95, 40,
71, 57, 125, 145, 55, 1, 96, 113, 80, 3, 23, 38, 158, 108, 104,
11, 6, 79, 134, 74, 40, 111, 110, 96, 126, 33, 105, 22, 23, 70,
44, 10, 55, 81, 86, 122, 107, 18, 104, 112, 23, 109, 115, 102,
110, 103, 112, 50, 78, 105, 73, 89, 96, 95, 69, 60, 71, 28, 62,
15, 91, 28, 66, 28, 121, 71, 6, 135, 18, 15, 118, 80, 135, 61,
107, 49, 104, 103, 55, 103, 12, 102, 100, 67, 34, 168, 159, 114,
13, 36, 128, 28, 43, 57, 106, 97, 15, 99, 4, 84, 90, 123, 90,
16, 52, 75, 76, 70, 76, 95, 105, 104, 70, 76, 65, 10, 62, 64,
27, 37, 88, 44, 95, 56, 47, 122, 80, 88, 11, 64, 63, 94, 38,
90, 61, 62, 64, 91, 56, 66, 79, 86, 89, 41, 26, 86, 52, 16, 2,
124, 108, 62, 3, 73, 33, 59, 29, 29, 78, 78, 69, 82, 32, 78,
120, 6, 133, 123, 61, 101, 44, 8, 29, 87, 5, 80, 3, 30, 79, 83,
58, 69, 54, 30, 11, 117, 117, 87, 43, 81, 57, 47, 60, 16, 109,
76, 65, 81, 2, 89, 79, 55, 114, 29, 6, 110, 110, 90, 92, 21,
104, 65, 103, 79, 33, 44, 8, 45, 118, 51, 77, 65, 77, 48, 38,
90, 29, 50, 112, 102, 36, 20, 50, 31, 1, 7, 63, 95, 69, 42, 11,
3, 1, 39, 95, 23, 73, 26, 72, 43, 30, 18, 33, 45, 60, 36, 55,
51, 91, 8, 47, 57, 61, 72, 48, 44, 53, 25, 35, 72, 68, 20, 59,
7, 59, 12, 83, 53, 31, 60, 15, 84, 32, 29, 47, 73, 54, 50, 25,
46, 63, 52, 52, 45, 18, 31, 34, 45, 31, 21, 8, 29, 24, 77, 13,
79, 42, 40, 10, 29, 34, 32, 31, 28, 28, 34, 27, 30, 32, 23, 55,
43, 28, 6, 9, 69, 48, 48, 37, 49, 54, 40, 36, 25, 19, 26, 15,
30, 27, 31, 1, 18, 6, 26, 22, 9, 24, 19, 28, 20, 24, 25, 31,
61, 10, 50, 43, 42, 42, 41, 41, 40, 25, 24, 81, 1, 25, 14, 1,
14, 23, 28, 1, 8, 12, 27, 22, 17, 16, 20, 1, 26, 10, 17, 20,
25, 23, 3, 25, 45, 32, 20, 31, 31, 40, 47, 1, 28, 31, 30, 30,
30, 31, 2, 16, 23, 28, 1, 14, 22, 24, 7, 23, 1, 24, 27, 23, 12,
22, 1, 18, 14, 19, 22, 1, 3, 1, 22, 21, 12, 18, 8, 17, 6, 9,
3, 2, 2, 19, 2, 17, 28, 18, 1, 14, 14, 2, 16, 18, 18, 37, 14,
16, 18, 4, 15, 2, 32, 32, 48, 13, 7, 9, 6, 4, 4, 3, 26, 4, 10,
9, 8, 2, 8, 4, 10, 4, 40, 4, 25, 13, 40, 18, 24, 24, 2, 2, 30,
30, 10, 22, 15, 11, 10, 24, 13, 18, 22, 21, 16, 16, 17, 18, 4,
19, 19, 20, 16, 12, 19, 18, 20, 16, 21, 22, 5, 34, 8, 12, 17,
20, 16, 11, 6, 12, 9, 19, 55, 8, 13, 22, 16, 6, 20, 15, 20, 15,
12, 12, 20, 7, 16, 3, 7, 11, 12, 14, 12, 16, 12, 12, 11, 14,
12, 12, 20, 11, 12, 13, 10, 14, 12, 11, 8, 12, 13, 16, 16, 11,
15, 2, 11, 12, 10, 11, 10, 12, 13, 12, 5, 6, 19, 11, 9, 13, 6,
12, 10, 4, 10, 12, 2, 3, 6, 18, 7, 15, 17, 12, 3, 17, 10, 15,
60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 9.5999999999999996, 19.199999999999999,
60, 60, 60, 1.2, 60, 55.200000000000003, 2.3999999999999999,
60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 62.399999999999999,
60, 60, 60, 32.399999999999999, 60, 60, 20.399999999999999, 60,
60, 60, 60, 60, 60, 60, 60, 60, 60, 22.800000000000001, 60, 60,
60, 60, 60, 60, 60, 60, 60, 56.399999999999999, 60, 60, 60, 60,
60, 60, 60, 60, 44.399999999999999, 60, 60, 60, 24, 60, 60, 60,
10.800000000000001, 60, 18, 60, 60, 16.800000000000001, 60, 60,
60, 26.399999999999999, 22.800000000000001, 60, 1.2, 60, 60,
12, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 8.4000000000000004,
12, 60, 60, 39.600000000000001, 60, 60, 60, 60, 60, 60, 60, 60,
60, 7.2000000000000002, 37.200000000000003, 60, 60, 60, 60, 9.5999999999999996,
60, 20.399999999999999, 6, 60, 60, 7.2000000000000002, 60, 60,
60, 50.399999999999999, 60, 26.399999999999999, 60, 60, 60, 60,
60, 60, 60, 60, 60, 60, 60, 60, 60, 12, 60, 60, 60, 60, 60, 60,
60, 60, 60, 60, 58.799999999999997, 58.799999999999997, 60, 60,
60, 60, 60, 61.200000000000003, 60, 39.600000000000001, 19.199999999999999,
15.6, 60, 60, 60, 60, 60, 60, 60, 60, 22.800000000000001, 60,
60, 60, 89, 46, 85, 85, 43, 58, 74, 70, 52, 41, 51, 62, 58, 62,
63, 75, 65, 45, 51, 34, 58, 67, 49, 94, 44, 37, 47, 74, 77, 85,
44, 26, 37, 73, 32, 39, 51, 79, 71, 43, 45, 15, 64, 74, 64, 69,
48, 47, 71, 84, 70, 34, 34, 58, 104, 51, 41, 62, 61, 36, 67,
61, 49, 5, 45, 104, 36, 53, 39, 30, 70, 52, 30, 64, 9, 60, 32,
65, 55, 30, 78, 61, 61, 45, 28, 61, 45, 59, 76, 59, 41, 23, 65,
83, 24, 68, 47, 19, 47, 58, 13, 60, 93, 35, 50, 51, 44, 64, 59,
61, 62, 37, 48, 65, 67, 63, 56, 37, 37, 56, 69, 51, 69, 58, 59,
87, 11, 63, 59, 64, 53, 64, 43, 88, 60, 64, 47, 64, 69, 90, 48,
59, 43, 39, 17, 48, 65, 96, 30, 41, 52, 95, 63, 69, 23, 67, 99,
53, 63, 63, 45, 35, 71, 14, 49, 59, 76, 59, 102, 66, 88, 49,
24, 104, 75, 42, 52, 48, 49, 39, 104, 65, 64, 53, 82, 60, 60,
98, 93, 41, 57, 77, 85, 73, 68, 62, 57, 35, 104, 69, 19, 20,
37, 38, 104, 28, 68, 1, 34, 46, 24, 63, 22, 91, 84, 50, 3, 21,
36, 70, 23, 25, 4, 13, 73, 12, 47, 73, 12, 47, 21, 11, 101, 9,
51, 34, 36, 23, 48, 35, 65, 25, 70, 21, 56, 21, 98, 18, 35, 66,
19, 39, 16, 60, 48, 40, 60, 60, 60, 11, 60, 29, 18, 60, 60, 60,
14, 4, 60, 4, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 40,
60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 47, 48, 60, 60, 60, 25,
60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 2, 60, 60, 55, 60, 60,
60, 51, 60, 60, 53, 26, 60, 39, 60, 60, 60, 60, 44, 60, 51.399999999999999,
66.099999999999994, 47.200000000000003, 42.200000000000003, 26.600000000000001,
51.399999999999999, 53.299999999999997, 42.399999999999999, 53,
52.5, 72.299999999999997, 45.399999999999999, 53, 41.899999999999999,
47.200000000000003, 45.200000000000003, 36.5, 52.899999999999999,
33.299999999999997, 35.5, 61.200000000000003, 45.200000000000003,
53.299999999999997, 33.799999999999997, 53.200000000000003, 52.399999999999999,
55.299999999999997, 53, 37.100000000000001, 68.299999999999997,
34.299999999999997, 53.799999999999997, 53.5, 42.299999999999997,
55.600000000000001, 51.600000000000001, 41.299999999999997, 52.899999999999999,
35.899999999999999, 45.200000000000003, 49.200000000000003, 53.299999999999997,
35, 45.200000000000003, 54.399999999999999, 35.200000000000003,
72.900000000000006, 61.600000000000001, 60.100000000000001, 52.899999999999999,
12, 84, 84, 84, 84, 84, 82.799999999999997, 82.799999999999997,
82.799999999999997, 80.400000000000006, 79.200000000000003, 79.200000000000003,
79.200000000000003, 75.599999999999994, 75.599999999999994, 74.400000000000006,
81.599999999999994, 38.399999999999999, 80.400000000000006, 14.4,
76.799999999999997, 78, 26.399999999999999, 54, 52.799999999999997,
84, 79.200000000000003, 79.200000000000003, 79.200000000000003,
76.799999999999997, 6, 70.799999999999997, 7.2000000000000002,
63.600000000000001, 61.200000000000003, 14.4, 56.399999999999999,
37.200000000000003, 61.200000000000003, 60, 61.200000000000003,
60, 56.399999999999999, 56.399999999999999, 61.200000000000003,
44.399999999999999, 61.200000000000003, 55.200000000000003, 60,
22.800000000000001, 36, 1.2, 16.800000000000001, 37.200000000000003,
68.400000000000006, 50.399999999999999, 57.600000000000001, 38.399999999999999,
33, 14, 55, 22, 40, 10, 23, 37, 12, 45, 37, 28, 13, 15, 18, 12,
44, 4, 22, 46, 41, 49, 6, 35, 45, 15, 43, 52, 51, 52, 20, 45,
51, 42, 50, 9, 14, 47, 53, 0, 52, 33, 19, 45, 32, 18, 33, 50,
36, 52, 46, 27, 50, 53, 47, 26, 25, 28, 14, 35, 29, 3, 45, 41,
12, 46, 47, 17, 2, 1, 51, 19, 0, 53, 17, 18, 8, 35, 30, 8, 10,
15, 47, 29, 38, 54, 43, 12, 44, 47, 20, 13, 32, 43, 51, 29, 33,
55, 30, 47, 40, 9, 49, 52, 56, 29, 3, 6, 54, 29, 47, 46, 52,
51, 38, 34, 47, 19, 48, 31, 47, 24, 40, 46, 24, 55, 14, 53, 23,
48, 38, 12, 50, 46, 0, 28, 53, 44, 53, 44, 52, 43, 37, 38, 43,
21, 48, 19, 24, 30, 35, 19, 33, 49, 50, 38, 22, 22, 31, 23, 38,
26, 52, 37, 15, 44, 27, 44, 52, 27, 8, 52, 41, 55, 28, 3, 9,
45, 11, 42, 43, 37, 45, 18, 6, 56, 52, 46, 43, 15, 43, 42, 16,
25, 48, 38, 48, 31, 49, 32, 12, 11, 46, 24, 13, 4, 56, 5, 13,
50, 30, 48, 41, 54, 37, 46, 25, 16, 7, 46, 42, 47, 4, 2, 39,
43, 34, 49, 52, 24, 16, 48, 46, 25, 44, 10, 53, 12, 37, 17, 44,
41, 22, 35, 51, 51, 54, 39, 47, 46, 47, 51, 49, 41, 1, 45, 19,
28, 39, 44, 39, 21, 26, 48, 48, 50, 25, 48, 39, 7, 30, 49, 59,
40, 34, 51, 51, 3, 56, 28, 17, 3, 40, 44, 45, 50, 46, 47, 40,
28, 40, 14, 42, 39, 48, 23, 31, 11, 8, 29, 35, 54, 12, 47, 48,
24, 26, 41, 38, 18, 43, 26, 40, 23, 47, 51, 8, 41, 28, 0, 16,
9, 12, 22, 49, 18, 11, 26, 26, 18, 15, 38, 36, 34, 26, 12, 34,
20, 48, 47, 50, 6, 13, 14, 37, 34, 42, 6, 50, 11, 52, 43, 1,
1, 1, 1, 35, 1, 1, 1, 1, 1, 1, 1, 23, 5, 1, 1, 1, 6, 1, 1, 1,
27, 1, 1, 1, 1, 19, 1, 34, 1, 1, 1, 1, 1, 1, 1, 1, 27, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 15, 1, 1, 1, 1, 1, 29,
1, 1, 33, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 36,
1, 1, 21, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 30, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 18, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 35, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
23, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 20, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 24, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 33,
1, 1, 1, 1, 1, 23, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 34, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 28, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 10, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 31, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
34, 1, 30, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
33, 1, 1, 1, 1, 1, 1, 1, 29, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 29, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 32, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 14, 1, 1, 1, 1, 1, 1, 1, 16, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 27, 1, 1, 1, 1, 1, 1, 1, 1, 5, 1,
1, 1, 1, 1, 28, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 20,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 8, 1, 1, 1, 1, 1, 1, 1, 1,
1, 9, 1, 1, 1, 1, 37, 1, 1, 1, 1, 1, 33, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 35, 1, 1, 1, 1, 1, 1, 1,
12, 1, 1, 1, 1, 1, 31, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 31, 1, 1, 1, 1, 1, 1, 10, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 37, 1, 1, 1,
1, 1, 1, 1, 19, 1, 1, 1, 3, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 24, 1, 1, 1, 1, 1, 1, 1, 1, 33, 1, 1, 1, 36, 1,
1, 14, 31, 1, 1, 1, 1, 1, 10, 1, 22, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 30, 1, 16, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 30, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 33, 1, 1, 1, 1, 1, 1, 1, 16, 5, 1, 1,
1, 1, 24, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 10, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 29, 1, 1, 1, 1, 1, 1, 1, 1, 14, 1,
29, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 7, 1, 16, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 12, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1, 1, 26, 10,
1, 1, 1, 1, 1, 1, 35, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 35, 1, 1, 1, 1, 19, 1, 1, 1,
1, 1, 11, 1, 22, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 17, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 19, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 14, 1, 1, 1, 1, 5, 1, 21, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 34, 1, 1, 1, 19, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 7, 1, 1, 1, 16, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 35, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 36, 1, 1, 1, 28, 30, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 36, 1, 1, 1, 58.300000000000004, 31.100000000000001,
1, 63.700000000000003, 1, 59.800000000000004, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 15.799999999999999, 1, 12.199999999999999, 1,
14.5, 26.100000000000001, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 46.600000000000001, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 63.5, 1, 12.699999999999999, 1, 1, 1, 1,
47.700000000000003, 1, 1, 1, 1, 1, 1, 1, 36.200000000000003,
1, 9.0999999999999996, 39.300000000000004, 36.800000000000004,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 24.5, 1, 1, 1, 1, 26.300000000000001,
1, 1, 48.800000000000004, 1, 1, 1, 1, 1, 6.2999999999999998,
1, 1, 1, 1, 1, 22.600000000000001, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 62.899999999999999, 1, 1, 1, 50.899999999999999,
1, 1, 69, 40.100000000000001, 30.300000000000001, 1, 10.1, 1,
1, 1, 51.200000000000003, 1, 35.5, 1, 1, 50.600000000000001,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 66.899999999999991, 1,
55.399999999999999, 1, 16, 1, 27.700000000000003, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 16, 1, 1, 27, 24, 1, 1, 1, 13, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 37, 1, 1, 1, 1, 1, 2, 1,
1, 14, 6, 9, 30, 16, 13, 31, 1, 1, 1, 36, 1, 1, 1, 1, 22, 1,
1, 1, 1, 1, 1, 1, 1, 19, 1, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 15, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 36, 1, 1, 1, 1, 1, 1, 36, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 5, 1, 30, 1, 1, 27, 1, 1, 1, 1, 1, 1, 1, 33, 22, 1, 24, 1,
1, 1, 34, 1, 1, 1, 1, 10, 1, 8, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 23, 18, 27, 1, 32, 35, 1, 4, 1, 48, 22, 1, 40, 13, 18,
1, 1, 1, 30, 1, 1, 1, 18, 4, 1, 13, 11, 42, 18, 1, 1, 16, 1,
1, 1, 1, 1, 1, 33, 1, 16, 25, 1, 1, 1, 1, 1, 1, 1, 1, 34, 1,
1, 1, 32, 18, 1, 1, 1, 1, 1, 1, 1, 1, 1, 5, 1, 1, 31, 1, 5, 1,
19, 28, 1, 4, 15, 1, 20, 9, 1, 14, 1, 17, 6, 1, 32, 35, 8, 18,
9, 41, 17, 5, 17, 17, 1, 1, 1, 1, 1, 17, 1, 18, 1, 1, 12, 1,
1, 1, 1, 1, 25, 1, 1, 1, 22, 1, 1, 55, 1, 6, 1, 7, 1, 46, 1,
37, 23, 1, 57, 1, 63, 33, 1, 1, 1, 1, 1, 1, 1, 57, 33, 11, 1,
29, 1, 1, 29, 57, 20, 1, 1, 1, 1, 63, 1, 1, 29, 1, 1, 1, 1, 28,
1, 44, 1, 1, 1, 1, 56, 22, 58, 51, 30, 1, 57, 1, 22, 69, 1, 1,
25, 50, 1, 1, 44, 1, 30, 1, 1, 1, 1, 1, 1, 12, 1, 58, 1, 49,
1, 35, 1, 33, 1, 55, 19, 1, 1, 1, 13, 1, 1, 1, 1, 1, 32, 32,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 26, 1, 1, 4, 1, 24, 1, 34, 15,
1, 1, 40, 1, 1, 1, 1, 1, 1, 1, 1, 1, 46, 1, 1, 25, 1, 1, 1, 1,
8, 1, 1, 52, 40, 1, 1, 42, 1, 63, 3, 12, 1, 1, 1, 1, 1, 35, 27,
1, 1, 1, 1, 46, 1, 1, 1, 1, 2, 58, 1, 1, 20, 1, 1, 1, 1, 4, 1,
1, 1, 38, 1, 1, 11, 1, 1, 1, 1, 15, 1, 1, 1, 1, 57, 1, 1, 21,
1, 1, 1, 1, 1, 43, 12, 46, 38, 34, 1, 1, 14, 1, 58, 56, 1, 1,
6, 1, 44, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 53, 1,
1, 1, 1, 1, 57, 40, 19, 18, 1, 55, 12, 1, 45, 1, 1, 1, 1, 22,
1, 1, 1, 45, 1, 1, 1, 1, 1, 1, 1, 1, 1, 30, 35, 1, 97, 116, 43,
63, 37, 97, 63, 18, 129, 72, 163, 73, 141, 47, 27, 21, 137, 67,
39, 78, 85, 13, 171, 64, 11, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 77, 21, 4, 42, 46, 1, 45, 12, 40,
40, 1, 1, 37, 3, 21, 1, 1, 1, 61, 1, 1, 1, 19, 1, 63, 1, 15,
31, 11, 1, 1, 36, 1, 25, 1, 1, 7, 1, 1, 69, 12, 23, 21, 12, 1,
1, 1, 65, 1, 1, 16, 1, 1, 1, 1, 1, 18, 39, 37, 1, 1, 1, 1, 14,
1, 37, 11, 1, 1, 20, 36, 14, 1, 1, 1, 1, 1, 1, 1, 20, 1, 13,
1, 1, 1, 1, 1, 1, 1, 1, 1, 40.800000000000004, 4.7999999999999998,
173.09999999999999, 195.59999999999999, 45.600000000000001, 64.299999999999997,
70.099999999999994, 3.3000000000000003, 72.899999999999991, 102.19999999999999,
17.100000000000001, 4.3999999999999995, 200.59999999999999, 222,
134.79999999999998, 23.5, 49.300000000000004, 157.19999999999999,
20, 22, 60.100000000000001, 154.90000000000001, 1.2000000000000002,
98.399999999999991, 95.599999999999994, 1, 49.300000000000004,
54.700000000000003, 144.90000000000001, 120.59999999999999, 43.899999999999999,
37, 1, 49.5, 48, 36.100000000000001, 171.19999999999999, 89.699999999999989,
3.8999999999999999, 1, 56.700000000000003, 188.5, 73.5, 117.09999999999999,
87.299999999999997, 61.300000000000004, 9.2999999999999989, 149.90000000000001,
51.700000000000003, 89.099999999999994, 86.5, 90, 28.600000000000001,
146.09999999999999, 1, 88.399999999999991, 168.69999999999999,
1.7000000000000002, 141.59999999999999, 69.5, 38.899999999999999,
38.399999999999999, 78.899999999999991, 23.700000000000003, 109.69999999999999,
4, 0.59999999999999998, 195, 202.19999999999999, 79.5, 23.700000000000003,
55.300000000000004, 149.40000000000001, 58.800000000000004, 11.9,
110.69999999999999, 58.600000000000001, 26.400000000000002, 29,
156, 6, 176.79999999999998, 74.599999999999994, 38, 1, 169.79999999999998,
92.599999999999994, 21.400000000000002, 146.69999999999999, 141.69999999999999,
18.800000000000001, 88.899999999999991, 134.40000000000001, 1,
75.199999999999989, 70.399999999999991, 59, 8.6999999999999993,
157.40000000000001, 28.300000000000001, 158.5, 88, 48.899999999999999,
1, 36.200000000000003, 17.900000000000002, 91.5, 63.200000000000003,
143.29999999999998, 1, 43.800000000000004, 8.7999999999999989,
1, 10.699999999999999, 135.59999999999999, 1, 187.09999999999999,
74.199999999999989, 132.40000000000001, 134.09999999999999, 53.300000000000004,
76, 7, 32.5, 111, 8.1999999999999993, 75.199999999999989, 1,
1, 136.19999999999999, 136.79999999999998, 129.69999999999999,
75.899999999999991, 22.5, 134.29999999999998, 36.800000000000004,
207.19999999999999, 14.5, 96.899999999999991, 28, 41.600000000000001,
32.800000000000004, 0.79999999999999993, 1.7000000000000002,
117, 1, 11.1, 53.5, 35.899999999999999, 26.300000000000001, 17,
80.099999999999994, 173.90000000000001, 2.8999999999999999, 29.700000000000003,
60.800000000000004, 1, 54.100000000000001, 73.099999999999994,
1, 128.29999999999998, 1, 12.5, 141.90000000000001, 29.800000000000001,
12.9, 10.4, 84.699999999999989, 69.399999999999991, 67.299999999999997,
40, 1, 58.600000000000001, 164.69999999999999, 95.699999999999989,
1, 9.4000000000000004, 1, 6.7999999999999998, 68.5, 1, 122.09999999999999,
74.799999999999997, 1, 138.5, 46.600000000000001, 129.90000000000001,
29.200000000000003, 18.100000000000001, 60.5, 81.099999999999994,
47.899999999999999, 134.69999999999999, 73.799999999999997, 1,
46.5, 1, 1, 109.3, 26.400000000000002, 105.89999999999999, 128.40000000000001,
13.699999999999999, 1, 205.09999999999999, 37.399999999999999,
1, 191.59999999999999, 58.100000000000001, 107.89999999999999,
1, 88.699999999999989, 1, 35, 178.19999999999999, 37.399999999999999,
112, 17.800000000000001, 105.69999999999999, 205.5, 2.6000000000000001,
169, 39.600000000000001, 52.600000000000001, 94.799999999999997,
184.5, 125.5, 1, 1, 91.199999999999989, 164.79999999999998, 52.5,
65.299999999999997, 38, 192.19999999999999, 138.40000000000001,
191.59999999999999, 85.699999999999989, 104.3, 1, 1, 75.299999999999997,
33.200000000000003, 81.399999999999991, 129.5, 205, 16, 1, 1,
1, 47.800000000000004, 141.40000000000001, 158.40000000000001,
42, 1, 7.6999999999999993, 1, 84.099999999999994, 1, 1, 57.200000000000003,
85.5, 29.400000000000002, 1, 61.100000000000001, 75.199999999999989,
69.199999999999989, 1, 45.600000000000001, 18.300000000000001,
131.90000000000001, 126.09999999999999, 35.200000000000003, 91.899999999999991,
146.90000000000001, 38.800000000000004, 92.299999999999997, 107.5,
79.899999999999991, 100.19999999999999, 189.40000000000001, 1,
53.300000000000004, 150.5, 85.299999999999997, 191.19999999999999,
1, 47.200000000000003, 12.5, 29.700000000000003, 115.59999999999999,
12.4, 2.7000000000000002, 121.59999999999999, 29.400000000000002,
20.200000000000003, 9.0999999999999996, 99.899999999999991, 96.099999999999994,
76.299999999999997, 1, 1.3, 83.199999999999989, 45.899999999999999,
121.19999999999999, 96.399999999999991, 74.799999999999997, 93.899999999999991,
13.6, 146.90000000000001, 25.5, 87.799999999999997, 14.9, 29.300000000000001,
77.399999999999991, 1, 62.200000000000003, 219.5, 112.39999999999999,
61.399999999999999, 60.899999999999999, 128.40000000000001, 77.899999999999991,
17.5, 3.6000000000000001, 3.1000000000000001, 13, 66.799999999999997,
188.79999999999998, 78, 109.19999999999999, 150.79999999999998,
129.90000000000001, 37.600000000000001, 26.800000000000001, 0.79999999999999993,
90.5, 1, 19.800000000000001, 24.200000000000003, 142.5, 13.199999999999999,
15.699999999999999, 17.600000000000001, 1, 4.7999999999999998,
31.600000000000001, 2.3999999999999999, 199.90000000000001, 26.800000000000001,
12.699999999999999, 20.400000000000002, 40.800000000000004, 113.3,
42.600000000000001, 115.59999999999999, 27.600000000000001, 27.600000000000001,
4.6999999999999993, 17.200000000000003, 4.5, 25.400000000000002,
176, 31.900000000000002, 3.3000000000000003, 17.100000000000001,
104.59999999999999, 76.599999999999994, 118.69999999999999, 9,
17.300000000000001, 48.700000000000003, 72.5, 25.5, 165.29999999999998,
142.90000000000001, 58.700000000000003, 3.8999999999999999, 184.59999999999999,
64.399999999999991, 4.0999999999999996, 78.199999999999989, 15.5,
100.19999999999999, 7.5, 5.7999999999999998, 28.5, 15.5, 155,
76.799999999999997, 228.5, 50.899999999999999, 39.5, 61, 10.199999999999999,
78.199999999999989, 46.600000000000001, 10.799999999999999, 110.89999999999999,
20.900000000000002, 15.1, 139.5, 44.300000000000004, 1, 28.800000000000001,
38.399999999999999, 1, 88.5, 88, 121.09999999999999, 5.5, 42.200000000000003,
134.90000000000001, 38.5, 1.7000000000000002, 77.199999999999989,
41.899999999999999, 4.0999999999999996, 102.59999999999999, 105.09999999999999,
38.899999999999999, 1, 30.900000000000002, 23.5, 1, 45.600000000000001,
155.90000000000001, 1, 44, 67.5, 39.300000000000004, 82.299999999999997,
170.09999999999999, 85.399999999999991, 1, 79.799999999999997,
54.800000000000004, 137.19999999999999, 1, 1.5, 86.799999999999997,
28.800000000000001, 71.199999999999989, 11.799999999999999, 55.600000000000001,
31.700000000000003, 138.69999999999999, 82, 99.299999999999997,
78.699999999999989, 1, 10.299999999999999, 46.200000000000003,
127.19999999999999, 91.399999999999991, 72.5, 55.399999999999999,
38.100000000000001, 24.800000000000001, 80.5, 60.600000000000001,
1, 1, 30.5, 1, 70.199999999999989, 97.699999999999989, 98.899999999999991,
25.5, 31.600000000000001, 7.2999999999999998, 1, 18.200000000000003,
1, 21.200000000000003, 95.699999999999989, 40.899999999999999,
1, 59, 21, 77, 86, 1, 1, 58, 67, 1, 24, 1, 85, 1, 1, 1, 49, 49,
1, 1, 72, 1, 1, 82, 85, 71, 42, 1, 57, 1, 86, 11, 1, 79, 35,
88, 75, 30, 1, 1, 47, 15, 86, 1, 75, 26, 43, 1, 86, 43, 39, 79,
27, 1, 45, 93, 1, 86, 93, 89, 86, 8, 92, 23, 82, 69, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 25.700000000000003, 1, 1, 33.200000000000003,
1, 29, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 52.5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 44.800000000000004,
1, 1, 37.100000000000001, 1, 1, 1, 1, 31.700000000000003, 1,
1, 1, 1, 1, 1, 1, 1, 6.2999999999999998, 1, 47.899999999999999,
1, 1, 2.2000000000000002, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 32.5, 1, 1, 29.200000000000003, 1, 1, 1, 1,
1, 1, 1, 1, 48.600000000000001, 1, 1, 1, 1, 1, 1, 50.899999999999999,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 54.100000000000001, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 56.899999999999999,
1, 1, 1, 1, 1, 1, 1, 1, 79.599999999999994, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 54.399999999999999,
1, 1, 1, 1, 1, 1, 59.899999999999999, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 58, 1, 1, 1, 9, 50, 1,
1, 1, 1, 15, 24, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 33, 1, 1, 1,
1, 42, 1, 1, 1, 1, 1, 1, 1, 22, 1, 1, 1, 1, 1, 52, 1, 25, 1,
52, 1, 1, 1, 1, 10, 1, 33, 42, 1, 1, 1, 1, 1, 1, 1, 51, 1, 53,
1, 1, 1, 1, 1, 1, 1, 1, 1, 14, 1, 1, 1, 1, 1, 57, 1, 1, 1, 1,
1, 59, 44, 20, 1, 51, 1, 1, 1, 1, 1, 17, 1, 1, 1, 1, 1, 62, 1,
1, 1, 1, 28, 36, 2, 1, 1, 23, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 54, 1, 1, 1, 1, 1, 48, 1,
1, 37, 1, 13, 1, 1, 62, 1, 50, 1, 1, 1, 1, 1, 8, 1, 1, 57, 40,
47, 1, 1, 1, 8, 1, 1, 5, 1, 1, 18, 1, 1, 1, 15, 45, 23, 1, 1,
1, 1, 1, 1, 1, 1, 1, 31, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 34, 1, 1, 1, 54, 1, 28, 44, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 52, 1, 1, 1, 1, 27, 1, 1, 1, 1, 1, 33,
55, 65, 25, 1, 1, 1, 1, 1, 1, 50, 41, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 35, 13, 1, 1, 44, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 24,
1, 1, 1, 1, 1, 64, 4, 1, 37, 1, 1, 1, 1, 1, 1, 57, 1, 1, 1, 1,
1, 1, 1, 1, 1, 31, 1, 1, 32, 1, 32, 1, 1, 1, 1, 1, 1, 1, 1, 1,
42, 1, 1, 1, 1, 1, 1, 1, 1, 1, 22, 1, 1, 1, 1, 41, 21, 1, 1,
1, 1, 43, 24, 1, 3, 1, 1, 23, 1, 52, 1, 1, 29, 1, 39, 1, 1, 32,
1, 1, 1, 1, 1, 1, 46, 1, 1, 16, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 12, 38, 1, 1, 1, 1, 1, 1, 1, 1, 1, 38, 1, 1, 1,
1, 1, 1, 1, 41, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 34, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 5, 1, 1, 1, 44, 1, 1, 15, 1, 1, 1,
40, 1, 1, 1, 1, 1, 1, 39, 1, 62, 1, 21, 1, 1, 1, 1, 1, 56, 1,
1, 1, 1, 8, 1, 1, 1, 1, 1, 1, 55, 1, 1, 1, 1, 12, 58, 40, 1,
1, 1, 1, 1, 53, 1, 1, 60, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 33, 1, 62, 1, 46, 1, 1, 1, 1, 1, 1,
1, 52, 1, 1, 1, 1, 1, 1, 30, 1, 1, 61, 1, 1, 1, 1, 1, 1, 1, 32,
49, 1, 1, 1, 1, 27, 1, 1, 1, 1, 1, 1, 44, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 36, 1, 1, 1, 35, 1, 46, 1, 1, 1, 1, 1,
1, 38, 1, 1, 1, 1, 24, 1, 1, 1, 29, 1, 1, 1, 1, 1, 1, 1, 1, 47,
1, 16, 1, 1, 1, 1, 1, 1, 1, 1, 23, 1, 1, 35, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 30, 1, 1, 1, 53, 1, 1, 1, 1, 1, 1, 1, 1, 39, 1, 56,
1, 1, 1, 1, 25, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 54, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 10, 1, 44, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
33, 1, 29, 1, 1, 1, 1, 1, 1, 21, 1, 1, 1, 1, 1, 1, 59, 1, 1,
1, 1, 1, 1, 1, 31, 1, 1, 25, 1, 1, 1, 4, 1, 1, 1, 1, 14, 1, 1,
52, 1, 1, 1, 1, 1, 1, 43, 1, 1, 1, 1, 1, 1, 1, 1, 42, 1, 1, 28,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 50, 1, 1, 35, 1, 1, 1, 27, 1, 35,
21, 1, 1, 1, 55, 1, 1, 20, 1, 1, 1, 1, 1, 1, 51, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 49, 1, 1, 1, 1, 1, 1, 1, 1, 1, 35, 1,
48, 1, 1, 1, 1, 1, 1, 1, 1, 25, 8, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 1, 1,
57, 1, 1, 1, 1, 30, 1, 1, 1, 1, 1, 50, 1, 1, 20, 1, 1, 1, 1,
1, 1, 1, 1, 1, 13, 1, 46, 1, 1, 1, 1, 1, 7, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 6, 1, 8, 31, 41, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 24, 48, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
41, 1, 1, 1, 54, 1, 1, 1, 1, 1, 1, 1, 1, 1, 47, 44, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 42, 1, 1, 1, 1, 1, 1, 50, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 50, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 33, 1, 1, 8, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 10, 1, 1, 1, 1, 1, 1, 1, 1, 1, 26, 1, 1, 1,
1, 55, 1, 1, 1, 12, 1, 1, 1, 1, 1, 1, 19, 1, 1, 1, 1, 1, 43,
1, 21, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 16, 1, 1, 1, 25, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 37,
1, 33, 1, 1, 38, 1, 1, 1, 46, 1, 48, 1, 1, 1, 41, 30, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 20, 38, 1, 1, 1, 1, 48,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 40, 1, 1, 1, 1, 1, 1,
1, 1, 1, 33, 1, 1, 1, 1, 11, 1, 1, 38, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 23, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 12, 1, 1,
1, 1, 1, 1, 38, 1, 43, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32,
1, 1, 1, 1, 1, 1, 1, 1, 5, 1, 14, 1, 1, 17, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 18,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 35, 1, 1, 1, 1, 1, 1, 1, 1,
49, 32, 1, 19, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 40, 3, 1, 1, 1,
1, 1, 1, 1, 1, 1, 20, 1, 1, 1, 40, 1, 1, 16, 22, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 8, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 38, 1, 1, 1, 1, 33, 1, 1, 26, 1, 1, 1, 1, 1, 1, 32,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 12, 1, 1, 1, 12, 1, 1, 30,
1, 26, 1, 15, 1, 1, 1, 1, 35, 30, 1, 10, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 28, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 36, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 19, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 41, 36, 1, 1, 5, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 45, 1, 1, 1, 10,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 13, 1,
5, 1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 26, 1, 1, 1,
1, 1, 1, 11, 1, 1, 1, 31, 1, 1, 1, 1, 1, 1, 27, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 19, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 19, 1, 1, 1, 1, 25, 1, 1, 1, 1, 1, 1, 1, 1, 37,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 33, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
20, 1, 1, 1, 1, 37, 1, 1, 1, 1, 11, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 29, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 31,
1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 31, 1, 1, 1, 16, 1, 1, 1, 38, 1, 2, 13, 1, 30, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 18, 1, 1, 22, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 19, 1, 1, 1, 1, 1, 1, 6, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 37, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 7, 1, 1, 1, 24, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 18, 1, 1, 1, 1,
1, 1, 8, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 27, 1, 1, 1, 1, 30, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 31, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 1, 37,
1, 1, 1, 1, 1, 1, 1, 27, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 10, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 28,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 13, 1, 1,
1, 1, 1, 1, 1, 1, 23, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1,
1, 1, 10, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 51, 1,
1, 2, 1, 41, 15, 1, 1, 40, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 115,
1, 90, 1, 68, 1, 34, 77, 61, 48, 1, 1, 1, 1, 25, 1, 1, 1, 1,
1, 1, 1, 113, 84, 112, 1, 1, 1, 117, 51, 117, 1, 1, 64, 1, 1,
1, 1, 111, 1, 99, 1, 1, 89, 24, 1, 22, 1, 52, 1, 1, 1, 1, 1,
1, 36, 1, 1, 1, 127, 1, 1, 124, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 111, 40, 1, 1, 16, 1, 1, 101, 119, 54, 1, 1, 1, 30, 1,
48, 1, 14, 112, 1, 51, 1, 119, 68, 1, 1, 1, 1, 26, 1, 1, 1, 1,
51, 68, 1, 1, 54, 29, 26, 1, 1, 44, 25, 1, 37, 1, 1, 1, 34, 10,
1, 96, 1, 1, 1, 114, 1, 1, 1, 92, 75, 6, 122, 1, 1, 1, 71, 1,
56, 120, 120, 37, 35, 107, 1, 1, 65, 80, 1, 1, 100, 1, 1, 111,
1, 1, 1, 1, 106, 1, 12, 76, 1, 103, 111, 1, 1, 72, 61, 37, 1,
1, 28, 1, 94, 40, 1, 1, 1, 1, 1, 42, 1, 49, 1, 44, 1, 83, 1,
1, 83, 84, 99, 61, 87, 1, 101, 60, 1, 1, 109, 32, 1, 1, 1, 4,
46, 17, 37, 98, 90, 40, 1, 56, 101, 1, 38, 1, 18, 23, 1, 34,
61, 43, 1, 87, 1, 1, 1, 112, 90, 1, 99, 1, 1, 1, 61, 1, 19, 14,
1, 110, 1, 1, 1, 1, 25, 1, 28, 105, 1, 7, 19, 50, 1, 24, 1, 1,
4, 1, 98, 1, 1, 74, 10, 1, 100, 1, 13, 1, 1, 1, 1, 103, 1, 1,
1, 59, 1, 35, 87, 1, 48, 1, 1, 27, 1, 1, 1, 1, 1, 1, 29, 1, 46,
10, 1, 1, 1, 27, 1, 9, 1, 36, 1, 1, 83, 1, 1, 1, 70, 47, 1, 1,
33, 1, 1, 1, 1, 1, 98, 71, 1, 70, 38, 1, 1, 1, 1, 1, 32, 100,
17, 74, 57, 48, 1, 30, 1, 36, 104, 81, 23, 1, 1, 69, 38, 53,
68, 1, 50, 1, 1, 1, 1, 23, 1, 1, 1, 1, 1, 106, 1, 1, 1, 7, 92,
1, 1, 1, 104, 92, 1, 1, 86, 92, 1, 101, 1, 1, 1, 40, 73, 86,
1, 1, 107, 1, 1, 1, 11, 73, 36, 1, 56, 1, 47, 1, 1, 1, 1, 1,
33, 1, 74, 81, 100, 1, 18, 1, 15, 1, 1, 1, 1, 1, 58, 1, 76, 1,
1, 16, 1, 81, 1, 63, 9, 43, 57, 1, 1, 23, 79, 104, 58, 1, 1,
1, 10, 26, 65, 97, 60, 15, 62, 53, 1, 1, 1, 1, 145, 1, 151, 201,
1, 151, 1, 168, 1, 1, 1, 1, 210, 148, 1, 1, 1, 1, 171, 183, 183,
1, 1, 1, 1, 1, 1, 197, 1, 1, 161, 1, 183, 1, 1, 1, 142, 1, 180,
137, 1, 1, 1, 160, 133, 1, 1, 161, 147, 173, 1, 1, 1, 1, 207,
1, 1, 1, 164, 189, 1, 124, 1, 159, 177, 1, 136, 1, 174, 175,
1, 147, 178, 1, 172, 201, 175, 136, 130, 1, 1, 1, 1, 1, 1, 161,
181, 1, 1, 1, 1, 1, 1, 1, 202, 135, 1, 126, 1, 117, 1, 130, 1,
1, 206, 1, 1, 1, 1, 1, 1, 1, 1, 1, 153, 129, 211, 1, 1, 1, 1,
1, 1, 1, 1, 182, 190, 1, 1, 137, 141, 1, 150, 1, 1, 127, 172,
1, 1, 149, 143, 1, 1, 140, 1, 1, 1, 155, 138, 1, 1, 128, 1, 199,
1, 1, 159, 127, 1, 1, 1, 1, 1, 1, 1, 1, 182, 1, 1, 1, 1, 168,
152, 1, 145, 208, 184, 142, 1, 196, 1, 159, 1, 1, 1, 186, 128,
1, 1, 178, 1, 196, 146, 1, 174, 1, 1, 187, 208, 1, 1, 1, 175,
1, 1, 131, 1, 1, 1, 1, 1, 1, 1, 1, 1, 135, 1, 1, 188, 134, 204,
139, 1, 132, 116, 1, 131, 1, 1, 1, 1, 175, 1, 1, 202, 192, 1,
138, 1, 1, 1, 171, 1, 1, 141, 153, 152, 1, 129, 129, 1, 1, 1,
180, 1, 1, 1, 163, 120, 148, 1, 1, 1, 1, 1, 1, 133, 1, 1, 1,
1, 1, 1, 1, 1, 1, 135, 189, 134, 171, 182, 171, 148, 1, 1, 1,
1, 1, 164, 1, 156, 1, 156, 1, 1, 1, 146, 1, 1, 1, 1, 193, 171,
1, 1, 1, 1, 1, 1, 1, 1, 174, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 172,
1, 149, 1, 1, 195, 209, 1, 142, 1, 1, 1, 137, 1, 1, 1, 150, 1,
137, 177, 147, 158, 1, 122, 1, 1, 129, 1, 201, 1, 126, 121, 205,
1, 160, 1, 140, 1, 1, 193, 183, 1, 147, 1, 1, 1, 1, 1, 1, 1,
1, 189, 1, 1, 161, 1, 168, 1, 144, 143, 143, 1, 1, 197, 1, 1,
1, 1, 1, 138, 1, 1, 1, 158, 1, 1, 1, 194, 137, 1, 195, 138, 1,
1, 1, 1, 1, 119, 1, 1, 1, 1, 1, 1, 137, 1, 1, 122, 1, 1, 1, 167,
127, 130, 1, 1, 1, 1, 146, 1, 137, 1, 1, 1, 1, 1, 1, 197, 1,
1, 1, 1, 1, 1, 1, 141, 194, 178, 192, 1, 1, 170, 1, 1, 1, 144,
1, 1, 182, 1, 177, 173, 1, 137, 179, 185, 1, 1, 1, 1, 1, 211,
145, 1, 1, 1, 1, 1, 184, 203, 183, 1, 1, 1, 1, 1, 1, 169, 195,
191, 186, 1, 187, 1, 135, 200, 193, 1, 1, 1, 150, 189, 1, 1,
183, 159, 154, 157, 1, 20, 85, 107, 83, 120, 101, 23, 43, 103,
129, 65, 17, 60, 56, 65, 76, 49, 36, 88, 55, 33, 112, 88, 42,
98, 103, 37, 70, 61, 31, 106, 18, 16, 53, 124, 64, 74, 12, 102,
23, 68, 113, 111, 35, 30, 91, 123, 82, 37, 25, 23, 70, 25, 57,
46, 47, 69, 103, 34, 47, 8, 104, 46, 110, 16, 150, 73, 93, 57,
119, 41, 114, 11, 14, 52, 108, 73, 89, 19, 109, 34, 73, 13, 61,
23, 32, 105, 20, 14, 91, 41, 87, 38, 37, 41, 5, 51, 37, 64, 71,
34, 71, 88, 7, 123, 5, 1, 100, 122, 40, 38, 123, 94, 68, 90,
107, 54, 87, 64, 71, 123, 86, 104, 45, 84, 78, 51, 40, 87, 75,
92, 85, 47, 72, 130, 17, 97, 101, 120, 78, 49, 1, 61, 83, 93,
119, 66, 84, 74, 97, 109, 206, 33, 110, 1, 62, 20, 121, 88, 101,
85, 75, 120, 11, 104, 113, 46, 113, 127, 37, 50, 120, 69, 53,
62, 17, 15, 92, 125, 32, 75, 122, 93, 108, 106, 48, 64, 111,
1, 59, 33, 95, 28, 88, 119, 75, 39, 92, 112, 64, 48, 29, 68,
63, 48, 69, 59, 63, 22, 85, 1, 41, 22, 109, 81, 56, 61, 94, 84,
68, 97, 101, 29, 98, 41, 23, 81, 91, 98, 37, 111, 36, 96, 95,
67, 117, 102, 89, 40, 61, 69, 110, 72, 71, 28, 104, 65, 24, 93,
46, 79, 15, 88, 110, 102, 99, 85, 112, 58, 110, 111, 25, 53,
81, 115, 97, 97, 37, 109, 49, 60, 1, 44, 114, 191, 33, 35, 37,
73, 1, 1, 1, 1, 1, 1, 1, 118, 118, 110, 50, 79, 60, 23, 1, 28,
33, 1, 50, 17, 72, 1, 1, 1, 84, 58, 1, 22, 41, 1, 56, 25, 1,
1, 52, 45, 1, 1, 56, 1, 1, 34, 53, 25, 67, 1, 3, 24, 1, 5, 1,
52, 1, 1, 1, 33, 1, 1, 16, 43, 1, 1, 1, 118, 1, 1, 100, 103,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 34, 1, 1, 1, 1, 22, 31, 28, 1,
109, 9, 1, 1, 1, 1, 25, 34, 82, 1, 39, 1, 1, 1, 1, 58, 1, 1,
1, 1, 1, 1, 1, 1, 1, 39, 1, 1, 1, 1, 7, 1, 1, 1, 41, 1, 1, 1,
1, 1, 1, 23, 1, 1, 1, 1, 56, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 51, 79, 1, 1, 1, 1, 1, 70, 61, 72, 29, 63, 16, 1, 29,
1, 29, 1, 1, 7, 1, 19, 16, 1, 1, 1, 1, 1, 1, 1, 1, 56, 1, 1,
1, 1, 1, 35, 1, 1, 1, 1, 37, 1, 1, 1, 58, 1, 1, 1, 1, 5, 1, 1,
1, 1, 17, 53, 1, 1, 1, 1, 1, 1, 1, 1, 77, 1, 11, 1, 65, 28, 38,
1, 1, 1, 1, 48, 1, 1, 1, 1, 1, 1, 1, 39, 1, 62, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 17, 3, 1, 1, 63, 1, 1, 1, 60, 1, 1, 1, 1,
1, 1, 33, 1, 1, 7, 1, 1, 1, 1, 1, 9, 30, 1, 6, 1, 4, 31, 1, 1,
1, 1, 1, 31, 12, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1,
1, 1, 1, 1, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 34, 1, 9, 1, 1, 1,
1, 1, 1, 1, 1, 1, 30, 1, 1, 1, 37, 1, 1, 1, 1, 8, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 19, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 37, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 15, 1, 15, 1, 1, 1, 1, 1, 1, 1, 18, 1, 1, 1, 1, 1, 1,
1, 1, 1, 4, 1, 1, 1, 1, 1, 32, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 23,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 20, 1, 1, 1, 22, 1, 6, 1, 1, 1, 1, 1, 1, 12, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 16, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1.3, 1, 1, 2.5, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 24.100000000000001, 1, 1, 1, 10.9, 1, 1, 1,
1, 16.900000000000002, 1, 1, 1, 1, 1, 1, 1.3, 1, 1, 12.1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 8.5, 12.1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6.0999999999999996, 1, 1, 7.2999999999999998,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 12.1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 58.899999999999999, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 90,
47, 1, 1, 44, 1, 1, 1, 1, 1, 1, 1, 59, 1, 1, 1, 1, 46, 52, 35,
1, 1, 50, 1, 45, 38, 1, 1, 1, 1, 1, 27, 1, 1, 1, 1, 1, 1, 1,
1, 1, 16, 1, 1, 1, 1, 1, 1, 1, 1, 71, 35, 1, 59, 1, 1, 42, 63,
62, 37, 68, 1, 1, 6, 46, 1, 37, 1, 1, 1, 1, 1, 31, 1, 10, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 77, 1, 1, 24, 1, 1, 25, 1,
1, 20, 1, 1, 14, 61, 1, 36, 51, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 52, 1, 1, 1, 1, 12, 1, 1, 1, 1, 1, 44, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 40, 18, 1, 1, 1, 1, 1, 1, 1, 1, 1, 24,
68, 1, 1, 1, 1, 1, 1, 1, 15, 1, 1, 1, 1, 1, 1, 1, 1, 25, 1, 76,
1, 1, 1, 1, 40, 1, 1, 65, 1, 1, 61, 1, 1, 1, 42, 1, 1, 1, 1,
69, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 74, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 20, 1, 1, 1,
49, 41, 1, 1, 1, 12, 1, 30, 19, 1, 1, 1, 15, 5, 1, 5, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 41, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 48,
49, 1, 1, 1, 26, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 56, 1,
1, 1, 52, 1, 1, 54, 27, 61, 40, 1, 1, 1, 1, 45, 1, 1, 66.199999999999989,
1, 1, 1, 1, 1, 1, 1, 1, 1, 45.5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 55.700000000000003, 1, 1,
53, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 12.1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 38.5, 1, 14.5, 76.899999999999991,
1, 26.5, 1, 1, 1, 1, 1, 1, 1, 6.0999999999999996, 1, 7.2999999999999998,
1, 1, 14.5, 1, 37.300000000000004, 1, 1, 1, 1, 1, 1, 1, 44.5,
1, 1, 1, 22.900000000000002, 36.100000000000001, 1.3, 16.900000000000002,
37.300000000000004, 1, 50.5, 1, 38.5, 1, 15, 1, 1, 1, 11, 1,
1, 1, 1, 38, 1, 1, 16, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 16, 1,
1, 1, 1, 21, 1, 1, 1, 1, 1, 15, 1, 1, 1, 1, 1, 1, 1, 33, 1, 1,
51, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 46, 1, 1, 1, 1,
1, 3, 2, 1, 1, 1, 1, 18, 1, 9, 1, 1, 9, 11, 1, 1, 30, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 30, 1, 1, 1, 1, 1, 1, 1, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 39, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 38, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 38, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 4, 10, 1, 1, 1, 1, 38, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 17, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 8, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 26, 1, 1, 1, 1, 1, 1, 1, 1, 23, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
31, 1, 1, 41, 35, 1, 1, 4, 1, 29, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 24, 1, 1, 9, 30, 36, 1, 1, 48, 1, 1, 1, 1,
1, 1, 1, 1, 1, 24, 1, 1, 9, 1, 1, 1, 1, 10, 1, 1, 1, 1, 1, 1,
27, 1, 1, 1, 1, 1, 27, 1, 1, 1, 1, 1, 1, 1, 14, 1, 1, 1, 1, 1,
1, 1, 1, 44, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 0,
0, 3, 0, 0, 0, 3, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0,
3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0,
0, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 3,
0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 3,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0,
0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0,
0, 0, 0, 3, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0,
0, 0, 0, 0, 3, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0,
0, 3, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0,
0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 3, 3, 0,
0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
3, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0,
0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0,
0, 0, 0, 3, 3, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 3,
0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0,
0, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 3, 0, 0, 0, 3, 3, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
3, 0, 3, 0, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0,
3, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 3, 3, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 3, 0, 0, 3, 0, 0,
0, 0, 0, 3, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 3, 3, 3, 0, 3, 0, 0, 0,
3, 0, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0,
3, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0,
3, 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0,
0, 0, 0, 0, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 3, 0, 0, 0,
0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 3, 0, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 3, 0, 0, 0,
3, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
3, 3, 3, 0, 3, 3, 0, 3, 0, 3, 3, 0, 3, 3, 3, 0, 0, 0, 3, 0, 0,
0, 3, 3, 0, 3, 3, 3, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 3, 3,
0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 3, 0, 0, 0, 0, 0, 0, 0,
0, 0, 3, 0, 0, 3, 0, 3, 0, 3, 3, 0, 3, 3, 0, 3, 3, 0, 3, 0, 3,
3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 3, 0, 3, 0,
0, 3, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 3, 0, 3, 0, 3, 0, 3,
0, 3, 3, 0, 3, 0, 3, 3, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 0, 3, 0,
0, 3, 3, 3, 0, 0, 0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 3, 0, 3, 0, 0,
0, 0, 3, 3, 3, 3, 3, 0, 3, 0, 3, 3, 0, 0, 3, 3, 0, 0, 3, 0, 3,
0, 0, 0, 0, 0, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 3, 0, 0, 0,
3, 0, 0, 0, 0, 0, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0,
3, 0, 3, 0, 3, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0,
3, 0, 0, 0, 0, 3, 0, 0, 3, 3, 0, 0, 3, 0, 3, 3, 3, 0, 0, 0, 0,
0, 3, 3, 0, 0, 0, 0, 3, 0, 0, 0, 0, 3, 3, 0, 0, 3, 0, 0, 0, 0,
3, 0, 0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 3, 0, 0, 0, 0, 3, 0, 0, 3,
0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 0, 0, 3, 0, 3, 3, 0, 0, 3, 0, 3,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0,
3, 3, 3, 3, 0, 3, 3, 0, 3, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0,
0, 0, 0, 0, 0, 0, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 0, 3, 3,
3, 3, 0, 0, 3, 3, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 3, 0, 3, 3, 3,
0, 0, 3, 0, 3, 0, 0, 3, 0, 0, 3, 3, 3, 3, 3, 0, 0, 0, 3, 0, 0,
3, 0, 0, 0, 0, 0, 3, 3, 3, 0, 0, 0, 0, 3, 0, 3, 3, 0, 0, 3, 3,
3, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0,
3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3,
3, 3, 3, 0, 3, 3, 0, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 0, 3, 0, 3, 3, 3, 3, 3, 3, 3,
3, 3, 0, 3, 3, 3, 0, 3, 0, 3, 3, 0, 3, 3, 0, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 0, 3, 0, 0, 3, 3, 3, 3, 3, 0, 3, 3, 0, 3, 3, 3, 0,
3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 0, 0, 3, 3, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3,
3, 0, 3, 0, 3, 0, 0, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
0, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 0, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
0, 3, 3, 0, 3, 3, 0, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 0, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0,
3, 0, 3, 3, 3, 3, 3, 3, 0, 3, 0, 3, 3, 3, 0, 3, 3, 3, 3, 0, 0,
3, 3, 0, 3, 0, 3, 0, 0, 0, 3, 3, 0, 0, 3, 0, 0, 3, 3, 3, 3, 0,
3, 0, 3, 3, 0, 3, 3, 3, 3, 3, 0, 0, 3, 3, 3, 0, 3, 3, 3, 0, 3,
3, 3, 3, 3, 0, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0,
0, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1,
1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 1,
1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, 0,
1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 0,
0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0,
0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1,
1, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 1, 0, 1,
1, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1,
0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1,
1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0,
0, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0,
1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1,
0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1,
1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1,
0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0,
0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 0,
0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0,
1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1,
0, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 1,
1, 0, 1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1,
1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1,
1, 0, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1,
1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0,
0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1,
0, 1, 1, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0,
0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 0, 0,
1, 1, 1, 1, 0, 0, 0, 0, 0, 3, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 3, 0, 0, 0,
0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 3,
0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0,
0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 3, 0, 0,
0, 0, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 3,
0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 3, 0, 3, 0, 3, 0, 0, 0,
0, 3, 0, 3, 3, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0,
0, 0, 0, 3, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 3, 3, 3, 0, 3, 0,
0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 3, 3, 3, 0, 0, 3,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 3, 0, 0, 0, 0, 0, 3, 0, 0, 3, 0, 3, 0, 0, 3, 0, 3, 0, 0,
0, 0, 0, 3, 0, 0, 3, 3, 3, 0, 0, 0, 3, 0, 0, 3, 0, 0, 3, 0, 0,
0, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 3, 3, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 3, 0, 0, 0, 0,
0, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 3, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0,
0, 0, 0, 0, 3, 3, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0,
0, 0, 0, 3, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0,
0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 3, 3, 0, 0, 0, 0, 3, 3, 0,
3, 0, 0, 3, 0, 3, 0, 0, 3, 0, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 3,
0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0,
0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
0, 0, 0, 3, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 3, 0,
3, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 0,
0, 0, 3, 3, 3, 0, 0, 0, 0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 0, 3, 0, 0,
0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 0,
0, 0, 3, 3, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0,
0, 0, 3, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 3,
0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0,
0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 0,
0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 3,
0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0,
3, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 3, 0, 0, 3, 0, 0, 0, 3, 0, 3, 3, 0, 0, 0, 3, 0, 0, 3, 0,
0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0,
0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 3, 0,
0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 3, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 3, 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 3, 0,
0, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0,
0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 3, 0, 0,
0, 3, 0, 3, 0, 0, 0, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 3, 3, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 3, 0, 0,
3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 3, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0,
0, 0, 0, 3, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 0,
0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 3, 3, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 3, 0, 0, 0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 3, 0, 3, 0,
3, 0, 0, 0, 0, 3, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 3, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 3, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0,
0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 3, 0, 0,
0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 3, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 3, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 3, 3, 0, 3, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 0, 0, 3, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0,
3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0,
0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 3, 0, 0, 3, 0, 3, 3, 0, 0, 3, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 3, 0, 3, 0, 3, 0, 3, 3, 3, 3, 0, 0, 0, 0, 3,
0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 0, 0, 0, 3, 3, 3, 0, 0, 3, 0, 0,
0, 0, 3, 0, 3, 0, 0, 3, 3, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0,
0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0,
0, 3, 0, 0, 3, 3, 3, 0, 0, 0, 3, 0, 3, 0, 3, 3, 0, 3, 0, 3, 3,
0, 0, 0, 0, 3, 0, 0, 0, 0, 3, 3, 0, 0, 3, 3, 3, 0, 0, 3, 3, 0,
3, 0, 0, 0, 3, 3, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 3, 3, 3, 0, 0,
0, 3, 0, 3, 3, 3, 3, 3, 3, 0, 0, 3, 3, 0, 0, 3, 0, 0, 3, 0, 0,
0, 0, 3, 0, 3, 3, 0, 3, 3, 0, 0, 3, 3, 3, 0, 0, 3, 0, 3, 3, 0,
0, 0, 0, 0, 3, 0, 3, 0, 3, 0, 3, 0, 0, 3, 3, 3, 3, 3, 0, 3, 3,
0, 0, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 0, 3, 0, 3,
3, 0, 3, 3, 3, 0, 3, 0, 0, 0, 3, 3, 0, 3, 0, 0, 0, 3, 0, 3, 3,
0, 3, 0, 0, 0, 0, 3, 0, 3, 3, 0, 3, 3, 3, 0, 3, 0, 0, 3, 0, 3,
0, 0, 3, 3, 0, 3, 0, 3, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 3, 3, 0,
3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 3, 3, 0, 0, 0, 3, 0, 3, 0,
3, 0, 0, 3, 0, 0, 0, 3, 3, 0, 0, 3, 0, 0, 0, 0, 0, 3, 3, 0, 3,
3, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 0, 3, 0, 3, 3, 3, 3, 0, 0,
3, 3, 3, 3, 0, 3, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3,
3, 0, 0, 0, 3, 3, 0, 0, 3, 3, 0, 3, 0, 0, 0, 3, 3, 3, 0, 0, 3,
0, 0, 0, 3, 3, 3, 0, 3, 0, 3, 0, 0, 0, 0, 0, 3, 0, 3, 3, 3, 0,
3, 0, 3, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 3, 0, 3, 0, 3, 3, 3, 3,
0, 0, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0,
3, 0, 3, 3, 0, 3, 0, 3, 0, 0, 0, 0, 3, 3, 0, 0, 0, 0, 3, 3, 3,
0, 0, 0, 0, 0, 0, 3, 0, 0, 3, 0, 3, 0, 0, 0, 3, 0, 3, 3, 0, 0,
0, 3, 3, 0, 0, 3, 3, 3, 0, 0, 0, 0, 3, 0, 0, 0, 3, 3, 0, 3, 0,
3, 3, 0, 3, 0, 3, 3, 0, 3, 3, 0, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0,
0, 3, 3, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 3, 0, 3, 0, 3, 0, 0, 3,
0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 3,
3, 0, 0, 3, 3, 0, 3, 0, 0, 3, 3, 0, 0, 3, 3, 0, 0, 3, 0, 0, 0,
3, 3, 0, 0, 3, 0, 3, 0, 0, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0,
0, 0, 0, 3, 3, 0, 3, 3, 3, 3, 0, 3, 0, 3, 0, 0, 0, 3, 3, 0, 0,
3, 0, 3, 3, 0, 3, 0, 0, 3, 3, 0, 0, 0, 3, 0, 0, 3, 0, 0, 0, 0,
0, 0, 0, 0, 0, 3, 0, 0, 3, 3, 3, 3, 0, 3, 3, 0, 3, 0, 0, 0, 0,
3, 0, 0, 3, 3, 0, 3, 0, 0, 0, 3, 0, 0, 3, 3, 3, 0, 3, 3, 0, 0,
0, 3, 0, 0, 0, 3, 3, 3, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0,
0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 3, 0, 3, 0, 3, 0,
0, 0, 3, 0, 0, 0, 0, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 3, 3, 0, 3, 0, 0, 0, 3, 0,
0, 0, 3, 0, 3, 3, 3, 3, 0, 3, 0, 0, 3, 0, 3, 0, 3, 3, 3, 0, 3,
0, 3, 0, 0, 3, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 3, 0,
3, 0, 3, 3, 3, 0, 0, 3, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0,
3, 3, 0, 3, 3, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 0, 3,
0, 0, 0, 3, 3, 3, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0,
0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 0, 0, 3, 0, 0, 0, 3, 0, 0, 3, 0,
3, 3, 0, 3, 3, 3, 0, 0, 0, 0, 0, 3, 3, 0, 0, 0, 0, 0, 3, 3, 3,
0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 0, 3, 0, 3, 3, 3, 0, 0, 0, 3, 3,
0, 0, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 3,
3, 3, 3, 3, 3, 3, 0, 3, 3, 0, 3, 3, 3, 0, 0, 0, 3, 3, 0, 3, 3,
0, 3, 3, 0, 0, 3, 3, 0, 0, 3, 0, 0, 3, 3, 3, 3, 0, 3, 3, 0, 3,
0, 3, 0, 0, 0, 3, 0, 0, 3, 3, 0, 0, 0, 3, 0, 0, 3, 3, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 3, 3, 3, 0, 3, 3, 0, 0, 0,
0, 3, 3, 3, 0, 3, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 3,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 0, 0, 0, 0,
3, 3, 3, 3, 3, 3, 0, 3, 0, 3, 0, 0, 3, 0, 3, 3, 0, 0, 0, 0, 0,
0, 0, 0, 3, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0,
0, 0, 3, 0, 0, 0, 0, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 0,
3, 3, 3, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0,
0, 0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 0, 3, 3, 0, 3, 0, 3, 3, 0, 0,
0, 0, 0, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0,
0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0,
0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0,
3, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0,
0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 3,
0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0,
3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0,
0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0,
0, 3, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 3, 3, 3, 0, 0, 3, 0,
3, 3, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0,
0, 0, 0, 0, 0, 3, 3, 0, 3, 0, 0, 3, 3, 3, 3, 3, 0, 0, 3, 3, 0,
3, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 3, 0, 0, 3, 0, 0, 3, 0, 0, 3, 0, 0, 3, 3, 0, 3, 3, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 3, 0, 0,
0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 0, 0, 0, 0,
0, 0, 0, 0, 3, 3, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0,
0, 3, 0, 3, 0, 0, 0, 0, 3, 0, 0, 3, 0, 0, 3, 0, 0, 0, 3, 0, 0,
0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3,
3, 0, 0, 0, 3, 0, 3, 3, 0, 0, 0, 3, 3, 0, 3, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 0, 0,
3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 3, 0, 0, 0, 3, 0, 0,
3, 3, 3, 3, 0, 0, 0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0,
3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 3, 0, 3, 0,
0, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0,
3, 0, 0, 0, 3, 3, 3, 3, 3, 0, 3, 0, 3, 0, 3, 0, 0, 0, 3, 0, 0,
0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0,
0, 3, 0, 0, 0, 0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 3, 0, 0, 3, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 3, 3, 0,
0, 3, 0, 3, 0, 3, 0, 0, 3, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0,
0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0,
3, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
3, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0,
0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 3, 3, 0, 0, 3, 0, 3, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 3, 3, 3, 0,
0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 3, 0, 0, 3, 0, 3, 0,
0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 3, 0,
0, 0, 0, 0, 0, 0, 0, 3), .Dim = c(8697L, 3L), .Dimnames = list(
    NULL, c("time1", "time2", "status")), type = "interval", class = "Surv"),
    su = structure(c(36, 36, 36, 36, 34, 36, 36, 36, 36, 36,
    36, 36, 22, 4, 36, 36, 36, 5, 36, 36, 36, 26, 36, 36, 36,
    36, 18, 36, 33, 36, 36, 36, 36, 36, 36, 36, 36, 26, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 14, 36,
    36, 36, 36, 36, 28, 36, 36, 32, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 2, 36, 36, 36, 36, 36, 35,
    36, 36, 20, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 29, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 17, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 34, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    22, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    19, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 23, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 32,
    36, 36, 36, 36, 36, 22, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 33, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 27, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 9, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 30, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 33, 36, 29, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 32, 36, 36, 36, 36, 36, 36, 36,
    28, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 28, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 31, 36, 36, 36, 36, 36, 36, 36, 1, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 13, 36, 36, 36, 36, 36, 36,
    36, 15, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 26, 36, 36,
    36, 36, 36, 36, 36, 36, 4, 36, 36, 36, 36, 36, 27, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 19, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    7, 36, 36, 36, 36, 36, 36, 36, 36, 36, 8, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 32, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 34, 36, 36, 36,
    36, 36, 36, 36, 11, 36, 36, 36, 36, 36, 30, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 30, 36, 36, 36, 36, 36, 36, 9, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 18, 36, 36, 36, 2, 36, 36,
    36, 5, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 23,
    36, 36, 36, 36, 36, 36, 36, 36, 32, 36, 36, 36, 35, 36, 36,
    13, 30, 36, 36, 36, 36, 36, 9, 36, 21, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 29, 36, 15, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 29, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 32, 36, 36, 36, 36, 36, 36, 36, 15,
    4, 36, 36, 36, 36, 23, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 9, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 6, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 28, 36,
    36, 36, 36, 36, 36, 36, 36, 13, 36, 28, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 6, 36, 15, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 11, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 5, 36, 36, 36, 36, 36,
    36, 36, 36, 25, 9, 36, 36, 36, 36, 36, 36, 34, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 34, 36, 36,
    36, 36, 18, 36, 36, 36, 36, 36, 10, 36, 21, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 2, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 16,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 18, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 13, 36, 36, 36, 36, 4, 36, 20, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 33, 36, 36, 36, 18,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 6, 36, 36, 36, 15,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 34, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 35, 36, 36, 36, 27, 29, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 35, 36,
    36, 36, 58.200000000000003, 31, 81.099999999999994, 63.600000000000001,
    78.099999999999994, 59.700000000000003, 75.599999999999994,
    65.200000000000003, 73, 68.900000000000006, 71.200000000000003,
    70, 69.400000000000006, 64.700000000000003, 68.400000000000006,
    67.299999999999997, 15.699999999999999, 64, 12.1, 65.200000000000003,
    14.4, 26, 55.100000000000001, 56.5, 56, 81.5, 80.400000000000006,
    78.5, 76.900000000000006, 76.700000000000003, 74, 75.299999999999997,
    54.600000000000001, 63.299999999999997, 71.299999999999997,
    46.5, 56.200000000000003, 69.700000000000003, 63.100000000000001,
    54.5, 68, 64.200000000000003, 63.299999999999997, 63.5, 63.100000000000001,
    63.799999999999997, 61.299999999999997, 77.099999999999994,
    73.900000000000006, 73.400000000000006, 75.299999999999997,
    75.900000000000006, 74.400000000000006, 72.5, 74.299999999999997,
    74.299999999999997, 63.399999999999999, 62.899999999999999,
    12.6, 69.200000000000003, 69.799999999999997, 68.700000000000003,
    64.900000000000006, 47.600000000000001, 56.700000000000003,
    53, 56.200000000000003, 56, 55.5, 57.399999999999999, 53,
    36.100000000000001, 80.400000000000006, 9, 39.200000000000003,
    36.700000000000003, 72.900000000000006, 72.5, 71.900000000000006,
    71.700000000000003, 70.900000000000006, 69.5, 70, 69.299999999999997,
    68.900000000000006, 68.700000000000003, 66.200000000000003,
    64, 63.100000000000001, 24.399999999999999, 57.299999999999997,
    55, 80.5, 79.900000000000006, 26.199999999999999, 79.900000000000006,
    79.200000000000003, 48.700000000000003, 70.400000000000006,
    66.700000000000003, 55.899999999999999, 68.099999999999994,
    60.100000000000001, 6.2000000000000002, 65, 66.299999999999997,
    61, 60.600000000000001, 52.899999999999999, 22.5, 59.399999999999999,
    58.799999999999997, 56, 53.200000000000003, 55.700000000000003,
    54.399999999999999, 55.5, 55.5, 52.5, 53.899999999999999,
    81.799999999999997, 81.5, 80.400000000000006, 79, 79.400000000000006,
    71.900000000000006, 58.100000000000001, 62.799999999999997,
    57.299999999999997, 66.799999999999997, 71.400000000000006,
    50.799999999999997, 69.599999999999994, 70, 68.900000000000006,
    40, 30.199999999999999, 64.799999999999997, 10, 59.399999999999999,
    80.299999999999997, 78, 51.100000000000001, 72.200000000000003,
    35.399999999999999, 69.299999999999997, 70.700000000000003,
    50.5, 68.099999999999994, 68.099999999999994, 65, 80.099999999999994,
    69.299999999999997, 68.200000000000003, 81, 80.099999999999994,
    80.299999999999997, 75, 74.099999999999994, 77.599999999999994,
    73.200000000000003, 66.799999999999997, 69.700000000000003,
    55.299999999999997, 68.599999999999994, 15.9, 62.200000000000003,
    27.600000000000001, 58.5, 58.700000000000003, 56.700000000000003,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 15, 36, 36, 26, 23,
    36, 36, 36, 12, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 1, 36, 0, 13, 5, 8, 29, 15,
    12, 30, 36, 36, 36, 35, 36, 36, 36, 36, 21, 36, 36, 36, 36,
    36, 36, 36, 36, 18, 36, 8, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 14, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 35, 36, 36, 36, 36,
    36, 36, 35, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 4, 36,
    29, 36, 36, 26, 36, 36, 36, 36, 36, 36, 36, 32, 21, 36, 23,
    36, 36, 36, 33, 36, 36, 36, 36, 9, 36, 7, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 49, 22, 17, 26, 48, 31, 34,
    47, 3, 47, 47, 21, 45, 39, 12, 17, 43, 43, 42, 29, 42, 42,
    41, 17, 3, 40, 12, 10, 41, 17, 40, 39, 15, 39, 38, 38, 38,
    37, 37, 32, 37, 15, 24, 37, 37, 36, 36, 36, 36, 36, 36, 33,
    35, 35, 35, 31, 17, 34, 33, 33, 33, 33, 33, 33, 33, 32, 4,
    31, 31, 30, 31, 4, 30, 18, 27, 30, 3, 14, 30, 19, 8, 46,
    13, 45, 16, 5, 44, 31, 34, 7, 17, 8, 40, 16, 4, 16, 16, 39,
    35, 37, 36, 36, 16, 36, 17, 35, 35, 11, 35, 34, 33, 33, 31,
    24, 30, 30, 60, 21, 60, 60, 54, 60, 5, 60, 6, 60, 45, 60,
    36, 22, 60, 56, 60, 62, 32, 60, 60, 60, 60, 60, 60, 60, 56,
    32, 10, 60, 28, 60, 60, 28, 56, 19, 60, 60, 60, 60, 62, 60,
    60, 28, 60, 60, 60, 60, 27, 60, 43, 60, 60, 60, 60, 55, 21,
    57, 50, 29, 60, 56, 60, 21, 68, 60, 60, 24, 49, 60, 60, 43,
    60, 29, 60, 60, 60, 60, 60, 60, 11, 60, 57, 60, 48, 60, 34,
    60, 32, 60, 54, 18, 60, 60, 60, 12, 60, 60, 60, 60, 60, 31,
    31, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 25, 60, 60, 3,
    60, 23, 60, 33, 14, 60, 60, 39, 60, 60, 60, 60, 60, 60, 60,
    60, 60, 45, 60, 60, 24, 60, 60, 60, 60, 7, 60, 60, 51, 39,
    60, 60, 41, 60, 62, 2, 11, 60, 60, 60, 60, 60, 34, 26, 60,
    60, 60, 60, 45, 60, 60, 60, 60, 1, 57, 60, 60, 19, 60, 60,
    60, 60, 3, 60, 60, 60, 37, 60, 60, 10, 60, 60, 60, 60, 14,
    60, 60, 60, 60, 56, 60, 60, 20, 60, 60, 60, 60, 60, 42, 11,
    45, 37, 33, 60, 60, 13, 60, 57, 55, 60, 60, 5, 60, 43, 60,
    60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 52,
    60, 60, 60, 60, 60, 56, 39, 18, 17, 60, 54, 11, 60, 44, 60,
    60, 60, 60, 21, 60, 60, 60, 44, 60, 60, 60, 60, 60, 60, 60,
    60, 60, 29, 34, 60, 96, 115, 42, 62, 36, 96, 62, 17, 128,
    71, 162, 72, 140, 46, 26, 20, 136, 66, 38, 77, 84, 12, 170,
    63, 10, 168, 120, 80, 136, 72, 96, 156, 84, 76, 76, 76, 108,
    136, 68, 36, 46, 136, 60, 76, 67, 96, 130, 130, 12, 84, 136,
    120, 53, 108, 108, 96, 60, 156, 118, 60, 72, 84, 120, 12,
    108, 156, 108, 156, 84, 43, 148, 108, 84, 104, 28, 21, 84,
    84, 96, 61, 108, 120, 61, 60, 120, 136, 53, 36, 60, 48, 31,
    48, 51, 84, 13, 16, 40, 15, 60, 14, 108, 12, 24, 96, 24,
    96, 96, 60, 89, 76, 20, 3, 41, 45, 91, 44, 11, 39, 39, 66,
    50, 36, 2, 20, 67, 67, 63, 60, 67, 23, 14, 18, 80, 62, 28,
    14, 30, 10, 67, 61, 35, 67, 24, 65, 17, 6, 19, 27, 68, 11,
    22, 20, 11, 90, 13, 60, 64, 90, 9, 15, 90, 11, 91, 23, 65,
    17, 38, 36, 65, 12, 13, 14, 13, 65, 36, 10, 58, 18, 19, 35,
    13, 13, 64, 14, 85, 14, 19, 25, 19, 21, 12, 10, 25, 15, 18,
    23, 21, 23, 23, 12, 40.700000000000003, 4.7000000000000002,
    173, 195.5, 45.5, 64.200000000000003, 70, 3.2000000000000002,
    72.799999999999997, 102.09999999999999, 17, 4.2999999999999998,
    200.5, 221.90000000000001, 134.69999999999999, 23.399999999999999,
    49.200000000000003, 157.09999999999999, 19.899999999999999,
    21.899999999999999, 60, 154.80000000000001, 1.1000000000000001,
    98.299999999999997, 95.5, 220.69999999999999, 49.200000000000003,
    54.600000000000001, 144.80000000000001, 120.5, 43.799999999999997,
    36.899999999999999, 219.80000000000001, 49.399999999999999,
    47.899999999999999, 36, 171.09999999999999, 89.599999999999994,
    3.7999999999999998, 223, 56.600000000000001, 188.40000000000001,
    73.400000000000006, 117, 87.200000000000003, 61.200000000000003,
    9.1999999999999993, 149.80000000000001, 51.600000000000001,
    89, 86.400000000000006, 89.900000000000006, 28.5, 146, 218.69999999999999,
    88.299999999999997, 168.59999999999999, 1.6000000000000001,
    141.5, 69.400000000000006, 38.799999999999997, 38.299999999999997,
    78.799999999999997, 23.600000000000001, 109.59999999999999,
    3.8999999999999999, 0.5, 194.90000000000001, 202.09999999999999,
    79.400000000000006, 23.600000000000001, 55.200000000000003,
    149.30000000000001, 58.700000000000003, 11.800000000000001,
    110.59999999999999, 58.5, 26.300000000000001, 28.899999999999999,
    155.90000000000001, 5.9000000000000004, 176.69999999999999,
    74.5, 37.899999999999999, 217.40000000000001, 169.69999999999999,
    92.5, 21.300000000000001, 146.59999999999999, 141.59999999999999,
    18.699999999999999, 88.799999999999997, 134.30000000000001,
    216.09999999999999, 75.099999999999994, 70.299999999999997,
    58.899999999999999, 8.5999999999999996, 157.30000000000001,
    28.199999999999999, 158.40000000000001, 87.900000000000006,
    48.799999999999997, 215.5, 36.100000000000001, 17.800000000000001,
    91.400000000000006, 63.100000000000001, 143.19999999999999,
    212.80000000000001, 43.700000000000003, 8.6999999999999993,
    212.59999999999999, 10.6, 135.5, 212.09999999999999, 187,
    74.099999999999994, 132.30000000000001, 134, 53.200000000000003,
    75.900000000000006, 6.9000000000000004, 32.399999999999999,
    110.90000000000001, 8.0999999999999996, 75.099999999999994,
    211.40000000000001, 211.40000000000001, 136.09999999999999,
    136.69999999999999, 129.59999999999999, 75.799999999999997,
    22.399999999999999, 134.19999999999999, 36.700000000000003,
    207.09999999999999, 14.4, 96.799999999999997, 27.899999999999999,
    41.5, 32.700000000000003, 0.69999999999999996, 1.6000000000000001,
    116.90000000000001, 210.69999999999999, 11, 53.399999999999999,
    35.799999999999997, 26.199999999999999, 16.899999999999999,
    80, 173.80000000000001, 2.7999999999999998, 29.600000000000001,
    60.700000000000003, 209.69999999999999, 54, 73, 210.19999999999999,
    128.19999999999999, 210.19999999999999, 12.4, 141.80000000000001,
    29.699999999999999, 12.800000000000001, 10.300000000000001,
    84.599999999999994, 69.299999999999997, 67.200000000000003,
    39.899999999999999, 209.30000000000001, 58.5, 164.59999999999999,
    95.599999999999994, 209.30000000000001, 9.3000000000000007,
    209.19999999999999, 6.7000000000000002, 68.400000000000006,
    209.09999999999999, 122, 74.700000000000003, 209, 138.40000000000001,
    46.5, 129.80000000000001, 29.100000000000001, 18, 60.399999999999999,
    81, 47.799999999999997, 134.59999999999999, 73.700000000000003,
    208.5, 46.399999999999999, 208.30000000000001, 208.40000000000001,
    109.2, 26.300000000000001, 105.8, 128.30000000000001, 13.6,
    208, 205, 37.299999999999997, 208, 191.5, 58, 107.8, 207.90000000000001,
    88.599999999999994, 207.80000000000001, 34.899999999999999,
    178.09999999999999, 37.299999999999997, 111.90000000000001,
    17.699999999999999, 105.59999999999999, 205.40000000000001,
    2.5, 168.90000000000001, 39.5, 52.5, 94.700000000000003,
    184.40000000000001, 125.40000000000001, 206.30000000000001,
    206.09999999999999, 91.099999999999994, 164.69999999999999,
    52.399999999999999, 65.200000000000003, 37.899999999999999,
    192.09999999999999, 138.30000000000001, 191.5, 85.599999999999994,
    104.2, 206, 206, 75.200000000000003, 33.100000000000001,
    81.299999999999997, 129.40000000000001, 204.90000000000001,
    15.9, 205.59999999999999, 205.5, 205.5, 47.700000000000003,
    141.30000000000001, 158.30000000000001, 41.899999999999999,
    205.09999999999999, 7.5999999999999996, 204.80000000000001,
    84, 204.69999999999999, 204.59999999999999, 57.100000000000001,
    85.400000000000006, 29.300000000000001, 204.59999999999999,
    61, 75.099999999999994, 69.099999999999994, 0.90000000000000002,
    45.5, 18.199999999999999, 131.80000000000001, 126, 35.100000000000001,
    91.799999999999997, 146.80000000000001, 38.700000000000003,
    92.200000000000003, 107.40000000000001, 79.799999999999997,
    100.09999999999999, 189.30000000000001, 204.59999999999999,
    53.200000000000003, 150.40000000000001, 85.200000000000003,
    191.09999999999999, 204.19999999999999, 47.100000000000001,
    12.4, 29.600000000000001, 115.5, 12.300000000000001, 2.6000000000000001,
    121.5, 29.300000000000001, 20.100000000000001, 9, 99.799999999999997,
    96, 76.200000000000003, 258.39999999999998, 1.2, 83.099999999999994,
    45.799999999999997, 121.09999999999999, 96.299999999999997,
    74.700000000000003, 93.799999999999997, 13.5, 146.80000000000001,
    25.399999999999999, 87.700000000000003, 14.800000000000001,
    29.199999999999999, 77.299999999999997, 252.90000000000001,
    62.100000000000001, 219.40000000000001, 112.3, 61.299999999999997,
    60.799999999999997, 128.30000000000001, 77.799999999999997,
    17.399999999999999, 3.5, 3, 12.9, 66.700000000000003, 188.69999999999999,
    77.900000000000006, 109.09999999999999, 150.69999999999999,
    129.80000000000001, 37.5, 26.699999999999999, 0.69999999999999996,
    90.400000000000006, 258.10000000000002, 19.699999999999999,
    24.100000000000001, 142.40000000000001, 13.1, 15.6, 17.5,
    233.80000000000001, 4.7000000000000002, 31.5, 2.2999999999999998,
    199.80000000000001, 26.699999999999999, 12.6, 20.300000000000001,
    40.700000000000003, 113.2, 42.5, 115.5, 27.5, 27.5, 4.5999999999999996,
    17.100000000000001, 4.4000000000000004, 25.300000000000001,
    175.90000000000001, 31.800000000000001, 3.2000000000000002,
    17, 104.5, 76.5, 118.59999999999999, 8.9000000000000004,
    17.199999999999999, 48.600000000000001, 72.400000000000006,
    25.399999999999999, 165.19999999999999, 142.80000000000001,
    58.600000000000001, 3.7999999999999998, 184.5, 64.299999999999997,
    4, 78.099999999999994, 15.4, 100.09999999999999, 7.4000000000000004,
    5.7000000000000002, 28.399999999999999, 15.4, 154.90000000000001,
    76.700000000000003, 228.40000000000001, 50.799999999999997,
    39.399999999999999, 60.899999999999999, 10.1, 78.099999999999994,
    46.5, 10.699999999999999, 110.8, 20.800000000000001, 15,
    139.40000000000001, 44.200000000000003, 167.40000000000001,
    28.699999999999999, 38.299999999999997, 160.40000000000001,
    88.400000000000006, 87.900000000000006, 121, 5.4000000000000004,
    42.100000000000001, 134.80000000000001, 38.399999999999999,
    1.6000000000000001, 77.099999999999994, 41.799999999999997,
    4, 102.5, 105, 38.799999999999997, 159.80000000000001, 30.800000000000001,
    23.399999999999999, 155, 45.5, 155.80000000000001, 164.90000000000001,
    43.899999999999999, 67.400000000000006, 39.200000000000003,
    82.200000000000003, 170, 85.299999999999997, 12, 79.700000000000003,
    54.700000000000003, 137.09999999999999, 65.799999999999997,
    1.3999999999999999, 86.700000000000003, 28.699999999999999,
    71.099999999999994, 11.699999999999999, 55.5, 31.600000000000001,
    138.59999999999999, 81.900000000000006, 99.200000000000003,
    78.599999999999994, 171, 10.199999999999999, 46.100000000000001,
    127.09999999999999, 91.299999999999997, 72.400000000000006,
    55.299999999999997, 38, 24.699999999999999, 80.400000000000006,
    60.5, 163.59999999999999, 172.59999999999999, 30.399999999999999,
    40.299999999999997, 70.099999999999994, 97.599999999999994,
    98.799999999999997, 25.399999999999999, 31.5, 7.2000000000000002,
    161.90000000000001, 18.100000000000001, 38.5, 21.100000000000001,
    95.599999999999994, 40.799999999999997, 43, 58, 20, 76, 85,
    66, 75, 57, 66, 84, 23, 90, 84, 85, 92, 85, 48, 48, 90, 83,
    71, 76, 46, 81, 84, 70, 41, 91, 56, 90, 85, 10, 85, 78, 34,
    87, 74, 29, 73, 81, 46, 14, 85, 84, 74, 25, 42, 43, 85, 42,
    38, 78, 26, 89, 44, 92, 42, 85, 92, 88, 85, 7, 91, 22, 81,
    68, 92, 92, 198.96000000000001, 181.19999999999999, 208.44,
    98.640000000000001, 36.960000000000001, 147.84, 211.68000000000001,
    71.519999999999996, 56.159999999999997, 58.560000000000002,
    118.08, 198.12, 16.440000000000001, 59.280000000000001, 122.76000000000001,
    245.40000000000001, 77.760000000000005, 178.80000000000001,
    228.84, 8.4000000000000004, 171.59999999999999, 13.199999999999999,
    10.800000000000001, 41.039999999999999, 142.44, 163.44, 102.59999999999999,
    172.80000000000001, 123.72, 126.59999999999999, 36.479999999999997,
    50.520000000000003, 88.920000000000002, 38.039999999999999,
    98.879999999999995, 36.479999999999997, 149.75999999999999,
    32.039999999999999, 151.08000000000001, 62.520000000000003,
    236.75999999999999, 30.719999999999999, 131.75999999999999,
    14.16, 107.76000000000001, 126.72, 184.91999999999999, 65.640000000000001,
    44.399999999999999, 207.72, 91.680000000000007, 10.44, 213.59999999999999,
    126.95999999999999, 220.08000000000001, 5.2800000000000002,
    15.24, 126.72, 212.52000000000001, 14.640000000000001, 182.03999999999999,
    78, 72.840000000000003, 123.84, 238.56, 158.63999999999999,
    95.280000000000001, 22.32, 226.44, 168.84, 217.56, 102.72,
    26.640000000000001, 202.80000000000001, 226.19999999999999,
    111.72, 248.03999999999999, 238.56, 236.63999999999999, 40.079999999999998,
    237, 116.88, 155.28, 203.40000000000001, 27.960000000000001,
    224.40000000000001, 148.80000000000001, 16.32, 59.880000000000003,
    121.2, 93.719999999999999, 67.439999999999998, 94.200000000000003,
    72.959999999999994, 189.96000000000001, 109.92, 166.80000000000001,
    109.8, 121.44, 18.359999999999999, 6.2400000000000002, 232.44,
    94.439999999999998, 124.08, 27.239999999999998, 121.2, 136.08000000000001,
    150.36000000000001, 176.75999999999999, 89.879999999999995,
    130.31999999999999, 9.7200000000000006, 120.48, 146.88, 112.8,
    195.24000000000001, 20.16, 233.88, 122.04000000000001, 24.48,
    193.44, 15.6, 162.12, 29.399999999999999, 124.08, 178.08000000000001,
    211.19999999999999, 38.640000000000001, 17.760000000000002,
    151.80000000000001, 115.8, 6.96, 181.44, 33.359999999999999,
    77.280000000000001, 78.599999999999994, 102.23999999999999,
    120.84, 171.84, 161.63999999999999, 8.6400000000000006, 193.56,
    132.47999999999999, 112.2, 91.680000000000007, 225.24000000000001,
    89.040000000000006, 193.80000000000001, 178.80000000000001,
    91.560000000000002, 199.19999999999999, 39.719999999999999,
    119.40000000000001, 214.19999999999999, 157.80000000000001,
    155.28, 54.960000000000001, 74.159999999999997, 91.319999999999993,
    102.59999999999999, 18.120000000000001, 142.80000000000001,
    208.91999999999999, 123.36, 28.800000000000001, 47.640000000000001,
    145.08000000000001, 89.400000000000006, 172.31999999999999,
    180.84, 222, 65.280000000000001, 17.280000000000001, 139.08000000000001,
    60, 61.68, 93.719999999999999, 217.19999999999999, 155.03999999999999,
    206.40000000000001, 66.599999999999994, 29.52, 122.64, 101.04000000000001,
    13.08, 145.44, 110.76000000000001, 160.91999999999999, 148.31999999999999,
    238.31999999999999, 40.920000000000002, 36.719999999999999,
    150.59999999999999, 252.59999999999999, 101.64, 125.52, 33.719999999999999,
    241.44, 183.59999999999999, 217.08000000000001, 14.4, 66.480000000000004,
    182.16, 160.91999999999999, 140.88, 95.640000000000001, 215.40000000000001,
    115.08, 223.19999999999999, 199.19999999999999, 179.03999999999999,
    137.03999999999999, 207.24000000000001, 89.879999999999995,
    114.84, 236.16, 109.56, 11.16, 90.959999999999994, 122.52,
    156.59999999999999, 194.16, 144.47999999999999, 137.75999999999999,
    71.159999999999997, 90.719999999999999, 188.28, 44.759999999999998,
    200.40000000000001, 128.75999999999999, 177.12, 114.12, 182.40000000000001,
    142.19999999999999, 26.039999999999999, 44.280000000000001,
    64.200000000000003, 243.84, 146.75999999999999, 29.16, 15.48,
    130.68000000000001, 149.75999999999999, 112.31999999999999,
    22.68, 56.759999999999998, 25.920000000000002, 4.2000000000000002,
    173.28, 232.68000000000001, 129.84, 208.08000000000001, 154.31999999999999,
    191.28, 189.36000000000001, 104.64, 167.03999999999999, 68.040000000000006,
    84, 48, 131.52000000000001, 119.16, 125.04000000000001, 84.719999999999999,
    64.319999999999993, 59.039999999999999, 146.88, 241.80000000000001,
    175.31999999999999, 152.52000000000001, 15.6, 145.56, 137.75999999999999,
    146.88, 27.84, 111.23999999999999, 100.31999999999999, 204.59999999999999,
    109.8, 216.84, 50.880000000000003, 64.799999999999997, 47.280000000000001,
    64.200000000000003, 54.840000000000003, 161.40000000000001,
    120.59999999999999, 170.63999999999999, 56.520000000000003,
    117.95999999999999, 80.760000000000005, 66, 87.120000000000005,
    36.840000000000003, 218.03999999999999, 9.3599999999999994,
    169.80000000000001, 142.19999999999999, 157.80000000000001,
    81.120000000000005, 130.80000000000001, 210.36000000000001,
    169.31999999999999, 150.47999999999999, 236.03999999999999,
    136.91999999999999, 186.36000000000001, 117.72, 149.75999999999999,
    122.40000000000001, 134.63999999999999, 129, 197.52000000000001,
    213.59999999999999, 104.76000000000001, 141, 167.75999999999999,
    119.64, 23.399999999999999, 133.44, 198.36000000000001, 127.68000000000001,
    225.84, 26.879999999999999, 248.75999999999999, 126.23999999999999,
    149.63999999999999, 5.7599999999999998, 201.36000000000001,
    131.16, 149.52000000000001, 153.47999999999999, 226.56, 81,
    18.600000000000001, 68.040000000000006, 7.4400000000000004,
    146.16, 187.80000000000001, 155.16, 201.24000000000001, 29.640000000000001,
    114.48, 141.24000000000001, 244.56, 115.08, 168.84, 41.280000000000001,
    63, 90.719999999999999, 83.159999999999997, 150.47999999999999,
    41.759999999999998, 171.59999999999999, 48.960000000000001,
    207.96000000000001, 148.31999999999999, 122.40000000000001,
    114.23999999999999, 94.200000000000003, 155.88, 22.68, 63.240000000000002,
    178.44, 172.08000000000001, 41.399999999999999, 99.239999999999995,
    158.63999999999999, 120.48, 120.48, 233.03999999999999, 129.47999999999999,
    27.719999999999999, 65.400000000000006, 161.88, 217.31999999999999,
    199.68000000000001, 32.759999999999998, 132.12, 155.52000000000001,
    152.40000000000001, 63, 119.28, 146.03999999999999, 46.439999999999998,
    210.96000000000001, 59.159999999999997, 134.03999999999999,
    111.36, 99.480000000000004, 11.4, 71.760000000000005, 137.75999999999999,
    205.91999999999999, 89.640000000000001, 93.719999999999999,
    172.68000000000001, 146.52000000000001, 196.19999999999999,
    226.44, 12.720000000000001, 25.440000000000001, 160.56, 44.759999999999998,
    135.72, 225.72, 171.72, 150.12, 24.48, 22.079999999999998,
    207.84, 210.72, 126.12, 106.44, 146.16, 179.40000000000001,
    39.719999999999999, 112.8, 74.159999999999997, 142.31999999999999,
    46.68, 59.039999999999999, 64.079999999999998, 127.2, 57.719999999999999,
    26.879999999999999, 132.59999999999999, 162.36000000000001,
    175.44, 164.03999999999999, 45.479999999999997, 42, 168.59999999999999,
    240.96000000000001, 178.80000000000001, 88.799999999999997,
    19.079999999999998, 46.560000000000002, 24.600000000000001,
    168.84, 181.56, 167.40000000000001, 158.40000000000001, 51.119999999999997,
    237.72, 36, 196.80000000000001, 195, 143.52000000000001,
    117.72, 168.24000000000001, 132.72, 137.88, 165.96000000000001,
    23.52, 100.44, 116.76000000000001, 154.56, 181.44, 131.75999999999999,
    128.03999999999999, 222.47999999999999, 36.119999999999997,
    55.799999999999997, 128.88, 66.239999999999995, 57.600000000000001,
    204.24000000000001, 81.480000000000004, 67.439999999999998,
    91.319999999999993, 172.91999999999999, 10.56, 43.32, 129.72,
    112.2, 112.68000000000001, 120, 82.920000000000002, 237,
    131.75999999999999, 120.59999999999999, 170.63999999999999,
    51.240000000000002, 133.68000000000001, 189.84, 58.079999999999998,
    82.680000000000007, 247.31999999999999, 59.640000000000001,
    184.80000000000001, 81.719999999999999, 21.719999999999999,
    135.59999999999999, 17.640000000000001, 194.88, 50.159999999999997,
    83.879999999999995, 111, 87.959999999999994, 131.63999999999999,
    99.239999999999995, 162.72, 195.59999999999999, 115.31999999999999,
    118.2, 36, 97.079999999999998, 66.599999999999994, 7.0800000000000001,
    137.52000000000001, 70.560000000000002, 15.359999999999999,
    94.439999999999998, 210.36000000000001, 79.439999999999998,
    46.32, 129.72, 36.240000000000002, 79.680000000000007, 122.16,
    106.2, 155.75999999999999, 68.280000000000001, 114.36, 33,
    86.519999999999996, 130.68000000000001, 11.16, 103.68000000000001,
    214.44, 156.84, 243.47999999999999, 203.16, 239.03999999999999,
    260.88, 138.72, 166.31999999999999, 260.75999999999999, 120,
    198.24000000000001, 207.36000000000001, 90.719999999999999,
    79.560000000000002, 75.239999999999995, 65.879999999999995,
    16.68, 115.44, 232.56, 132.47999999999999, 52.200000000000003,
    11.880000000000001, 15.6, 94.319999999999993, 23.16, 215.63999999999999,
    91.319999999999993, 71.400000000000006, 70.680000000000007,
    118.2, 29.039999999999999, 157.19999999999999, 74.040000000000006,
    102.36, 127.56, 53.159999999999997, 107.28, 115.44, 142.44,
    221.88, 213.72, 73.079999999999998, 113.88, 134.28, 72.400000000000006,
    68.599999999999994, 79.900000000000006, 69.5, 25.600000000000001,
    83.799999999999997, 67.799999999999997, 33.100000000000001,
    52.700000000000003, 28.899999999999999, 80.099999999999994,
    88, 77.400000000000006, 66.900000000000006, 78.200000000000003,
    78.799999999999997, 78.5, 78.5, 79.5, 66.200000000000003,
    64.700000000000003, 75.200000000000003, 87.599999999999994,
    87.700000000000003, 48.399999999999999, 86.700000000000003,
    72.5, 80.099999999999994, 54.200000000000003, 78.5, 77.5,
    76.200000000000003, 75.5, 75.599999999999994, 52.399999999999999,
    87.599999999999994, 75.5, 50.899999999999999, 71.299999999999997,
    63.700000000000003, 86, 71.5, 57.299999999999997, 44.899999999999999,
    78.700000000000003, 52.600000000000001, 44.700000000000003,
    52.700000000000003, 67, 37, 78.5, 77.900000000000006, 63.799999999999997,
    77.400000000000006, 31.600000000000001, 56.799999999999997,
    84.599999999999994, 50.5, 70.400000000000006, 81.400000000000006,
    67.599999999999994, 69.799999999999997, 68.799999999999997,
    6.2000000000000002, 68, 47.799999999999997, 52.399999999999999,
    58, 2.1000000000000001, 83.900000000000006, 51.200000000000003,
    84.200000000000003, 77, 54.700000000000003, 66.799999999999997,
    76.900000000000006, 67.200000000000003, 81.5, 61.799999999999997,
    57.5, 78.099999999999994, 68.5, 70.799999999999997, 57.100000000000001,
    81.400000000000006, 77.900000000000006, 64.599999999999994,
    32.399999999999999, 80, 52.200000000000003, 29.100000000000001,
    86.700000000000003, 62, 74.900000000000006, 71.400000000000006,
    58.299999999999997, 70.200000000000003, 70.5, 79.700000000000003,
    48.5, 67.400000000000006, 55.600000000000001, 63.799999999999997,
    55.399999999999999, 84.200000000000003, 71.299999999999997,
    50.799999999999997, 63.399999999999999, 51.700000000000003,
    57.100000000000001, 70.099999999999994, 75.200000000000003,
    78.099999999999994, 65.599999999999994, 76, 75.900000000000006,
    82.299999999999997, 54.700000000000003, 74.700000000000003,
    54, 66.099999999999994, 79.5, 71.5, 84.099999999999994, 70.099999999999994,
    70.799999999999997, 68.200000000000003, 52.799999999999997,
    55.899999999999999, 83.900000000000006, 75.900000000000006,
    61.600000000000001, 76.200000000000003, 60.299999999999997,
    70.299999999999997, 83.700000000000003, 68.700000000000003,
    56.799999999999997, 81.799999999999997, 69.900000000000006,
    80, 77.299999999999997, 76.200000000000003, 78, 67.400000000000006,
    39.799999999999997, 79.5, 87.799999999999997, 87.799999999999997,
    86.400000000000006, 72.400000000000006, 86.5, 46.100000000000001,
    84.700000000000003, 84.099999999999994, 61.899999999999999,
    84.099999999999994, 81, 83.200000000000003, 78.099999999999994,
    81.299999999999997, 78.799999999999997, 68.900000000000006,
    68.900000000000006, 80.200000000000003, 79.5, 55.899999999999999,
    81.599999999999994, 54.299999999999997, 79.299999999999997,
    66.400000000000006, 77.099999999999994, 78.099999999999994,
    77.799999999999997, 66, 59.799999999999997, 77.599999999999994,
    77.400000000000006, 77.099999999999994, 76.5, 63.799999999999997,
    87.599999999999994, 74.200000000000003, 68, 84.200000000000003,
    70.599999999999994, 71.799999999999997, 71.099999999999994,
    70.5, 82.700000000000003, 82.299999999999997, 69.700000000000003,
    81.299999999999997, 68.700000000000003, 25.399999999999999,
    54, 76.599999999999994, 76.400000000000006, 62.899999999999999,
    62.899999999999999, 55.899999999999999, 62.600000000000001,
    61.899999999999999, 71.599999999999994, 57.799999999999997,
    72.700000000000003, 34.399999999999999, 68.5, 56.100000000000001,
    68.200000000000003, 67.900000000000006, 55.399999999999999,
    54.799999999999997, 54.899999999999999, 66.599999999999994,
    64.299999999999997, 63.5, 50.299999999999997, 62.299999999999997,
    62.200000000000003, 49.600000000000001, 48.700000000000003,
    60.299999999999997, 58.200000000000003, 45.600000000000001,
    45.399999999999999, 45.5, 56.399999999999999, 54.100000000000001,
    43.799999999999997, 54, 37, 51, 51.200000000000003, 50.5,
    37.899999999999999, 49.799999999999997, 37.299999999999997,
    36.100000000000001, 35.700000000000003, 35, 47, 33.100000000000001,
    44.700000000000003, 31.600000000000001, 43.700000000000003,
    43.700000000000003, 44, 31.399999999999999, 30.899999999999999,
    42.399999999999999, 41.399999999999999, 40.200000000000003,
    40.100000000000001, 38.200000000000003, 37.700000000000003,
    37.100000000000001, 29.5, 72, 71, 57, 70, 68, 61, 8, 49,
    67, 67, 71, 65, 14, 23, 70, 70, 66, 70, 68, 66, 65, 67, 65,
    63, 70, 32, 68, 70, 65, 37, 41, 67, 65, 68, 68, 62, 65, 66,
    21, 69, 69, 68, 68, 62, 51, 66, 24, 60, 51, 68, 68, 69, 66,
    9, 67, 32, 41, 64, 67, 64, 51, 66, 69, 64, 50, 67, 52, 69,
    64, 67, 68, 65, 59, 63, 57, 62, 13, 65, 63, 62, 14, 67, 56,
    64, 65, 68, 37, 65, 58, 43, 19, 30, 50, 65, 56, 67, 54, 64,
    16, 31, 64, 65, 36, 64, 61, 68, 59, 56, 64, 27, 35, 1, 68,
    63, 22, 64, 64, 65, 65, 51, 58, 65, 64, 67, 67, 59, 64, 64,
    60, 66, 67, 67, 67, 64, 66, 65, 36, 65, 53, 61, 66, 66, 66,
    66, 47, 66, 66, 36, 59, 12, 65, 63, 61, 50, 49, 62, 54, 67,
    20, 68, 7, 63, 66, 56, 39, 46, 65, 60, 66, 7, 52, 59, 4,
    63, 58, 17, 64, 45, 64, 14, 44, 22, 67, 62, 62, 64, 67, 65,
    65, 67, 61, 30, 64, 60, 67, 63, 64, 42, 63, 64, 54, 53, 27,
    63, 63, 67, 33, 66, 65, 64, 53, 63, 27, 43, 21, 63, 62, 61,
    64, 54, 62, 62, 64, 58, 19, 64, 59, 22, 66, 23, 63, 51, 66,
    60, 64, 54, 26, 67, 43, 64, 65, 51, 32, 54, 64, 24, 65, 65,
    49, 62, 62, 57, 49, 40, 60, 65, 60, 51, 32, 60, 62, 60, 60,
    25, 65, 59, 34, 12, 60, 57, 43, 63, 61, 46, 63, 62, 64, 62,
    61, 59, 62, 23, 22, 57, 65, 66, 59, 63, 3, 65, 36, 60, 62,
    23, 62, 57, 59, 56, 22, 64, 65, 57, 59, 64, 62, 64, 46, 30,
    57, 60, 31, 16, 31, 64, 64, 41, 62, 64, 62, 62, 63, 58, 41,
    59, 64, 60, 35, 63, 60, 64, 64, 65, 21, 63, 43, 62, 65, 40,
    20, 38, 53, 60, 60, 42, 23, 63, 2, 61, 59, 22, 55, 51, 49,
    63, 28, 41, 38, 48, 64, 31, 63, 56, 64, 62, 62, 59, 45, 58,
    63, 15, 22, 60, 60, 63, 62, 27, 61, 62, 57, 61, 64, 46, 64,
    59, 58, 11, 37, 60, 64, 59, 18, 63, 58, 64, 62, 60, 37, 62,
    60, 62, 53, 62, 50, 60, 40, 30, 35, 63, 61, 62, 60, 62, 62,
    62, 62, 61, 33, 62, 60, 61, 61, 64, 58, 56, 60, 57, 59, 61,
    60, 4, 57, 60, 57, 43, 63, 61, 14, 60, 25, 62, 39, 28, 60,
    45, 33, 59, 61, 38, 60, 61, 33, 20, 61, 58, 59, 61, 62, 55,
    62, 62, 51, 60, 7, 53, 19, 56, 31, 58, 60, 54, 58, 56, 60,
    49, 11, 57, 39, 58, 60, 62, 59, 62, 52, 56, 59, 59, 46, 61,
    45, 56, 59, 21, 58, 59, 62, 19, 57, 59, 61, 60, 46, 58, 56,
    13, 57, 14, 57, 32, 22, 61, 60, 45, 53, 56, 62, 59, 60, 62,
    36, 51, 57, 32, 24, 58, 56, 59, 29, 32, 56, 60, 57, 58, 58,
    33, 17, 62, 59, 31, 48, 59, 58, 58, 59, 26, 57, 32, 60, 53,
    59, 62, 43, 59, 56, 56, 57, 62, 57, 56, 57, 54, 49, 44, 56,
    60, 61, 61, 35, 55, 61, 57, 34, 58, 45, 56, 56, 55, 57, 58,
    25, 37, 56, 59, 55, 54, 23, 61, 59, 60, 28, 59, 61, 60, 60,
    60, 58, 55, 57, 46, 57, 15, 56, 56, 57, 49, 56, 60, 41, 24,
    22, 55, 57, 34, 54, 53, 24, 57, 57, 56, 55, 58, 56, 57, 29,
    55, 33, 58, 52, 60, 48, 60, 60, 54, 15, 56, 60, 38, 54, 55,
    35, 50, 56, 57, 24, 57, 54, 59, 59, 58, 57, 59, 56, 53, 57,
    56, 53, 40, 20, 60, 53, 38, 52, 58, 57, 27, 59, 60, 54, 54,
    60, 57, 40, 10, 36, 19, 58, 58, 58, 56, 16, 53, 54, 55, 56,
    53, 56, 59, 9, 25, 43, 55, 56, 56, 53, 47, 51, 57, 56, 60,
    42, 32, 57, 28, 57, 56, 58, 25, 55, 54, 20, 56, 56, 38, 35,
    57, 46, 58, 56, 14, 55, 55, 56, 41, 53, 30, 35, 18, 24, 56,
    58, 57, 3, 29, 59, 56, 58, 13, 57, 56, 51, 56, 39, 55, 56,
    43, 56, 42, 53, 52, 54, 56, 55, 57, 55, 50, 41, 56, 10, 27,
    54, 55, 45, 55, 53, 55, 38, 55, 12, 56, 49, 55, 54, 34, 52,
    43, 51, 26, 55, 34, 20, 55, 55, 28, 54, 51, 47, 19, 34, 58,
    51, 56, 25, 53, 50, 55, 57, 52, 56, 52, 53, 54, 55, 54, 56,
    55, 47, 48, 58, 48, 45, 51, 58, 47, 55, 22, 55, 34, 56, 47,
    26, 55, 49, 54, 54, 54, 49, 53, 24, 7, 55, 55, 56, 55, 47,
    57, 52, 52, 46, 32, 8, 57, 54, 58, 57, 47, 51, 53, 53, 46,
    46, 54, 49, 38, 52, 54, 54, 6, 45, 57, 56, 53, 54, 49, 56,
    29, 56, 46, 52, 51, 53, 49, 31, 53, 19, 55, 56, 55, 16, 51,
    31, 42, 54, 56, 12, 38, 45, 19, 54, 48, 52, 54, 6, 51, 50,
    55, 35, 21, 49, 51, 49, 13, 48, 5, 57, 7, 30, 40, 47, 54,
    57, 50, 53, 53, 54, 48, 45, 49, 54, 53, 52, 23, 47, 51, 50,
    50, 5, 30, 54, 47, 47, 53, 50, 54, 52, 13, 37, 28, 46, 46,
    54, 55, 54, 51, 53, 53, 52, 51, 56, 45, 52, 45, 22, 46, 50,
    47, 53, 55, 50, 55, 40, 54, 44, 39, 53, 54, 53, 53, 10, 8,
    14, 53, 53, 55, 46, 43, 40, 38, 8, 14, 53, 50, 52, 55, 51,
    28, 41, 21, 53, 54, 51, 53, 46, 49, 52, 54, 55, 53, 8, 51,
    47, 43, 50, 43, 49, 53, 28, 54, 49, 42, 46, 52, 5, 55, 52,
    50, 50, 52, 48, 51, 18, 53, 20, 49, 32, 50, 51, 7, 52, 50,
    50, 53, 49, 50, 25, 49, 18, 53, 9, 54, 54, 49, 13, 41, 54,
    9, 32, 28, 43, 54, 51, 40, 55, 44, 52, 25, 28, 50, 51, 53,
    54, 22, 52, 52, 11, 11, 55, 52, 54, 50, 48, 18, 6, 51, 52,
    15, 53, 42, 52, 20, 52, 53, 35, 44, 43, 51, 14, 31, 38, 35,
    19, 54, 34, 49, 49, 54, 44, 24, 55, 32, 38, 15, 40, 50, 18,
    24, 46, 7, 48, 6, 42, 18, 52, 40, 49, 52, 7, 36, 48, 32,
    51, 6, 37, 45, 53, 52, 45, 50, 47, 49, 52, 53, 40, 29, 51,
    28, 54, 53, 42, 34, 50, 24, 47, 54, 54, 7, 43, 48, 38, 42,
    19, 37, 46, 47, 47, 47, 47, 42, 50, 51, 46, 17, 49, 7, 10,
    10, 52, 53, 11, 49, 39, 46, 52, 43, 53, 50, 48, 50, 44, 39,
    32, 11, 43, 49, 47, 10, 47, 48, 37, 44, 53, 53, 51, 45, 48,
    51, 49, 45, 45, 49, 26, 50, 50, 50, 47, 50, 52, 51, 47, 22,
    49, 24, 49, 50, 20, 51, 47, 52, 17, 21, 51, 48, 21, 48, 8,
    46, 48, 47, 47, 48, 48, 50, 53, 45, 11, 48, 48, 48, 52, 49,
    52, 37, 47, 42, 37, 50, 12, 52, 28, 44, 48, 13, 50, 50, 44,
    48, 31, 52, 50, 51, 49, 49, 37, 49, 48, 4, 46, 13, 14, 48,
    16, 49, 48, 43, 47, 17, 48, 46, 47, 38, 45, 48, 51, 52, 50,
    48, 48, 16, 34, 23, 40, 24, 39, 16, 48, 49, 17, 47, 50, 49,
    43, 50, 15, 46, 45, 46, 47, 47, 34, 44, 47, 46, 23, 49, 52,
    46, 47, 48, 31, 7, 18, 46, 48, 50, 6, 48, 48, 49, 21, 46,
    51, 39, 2, 47, 47, 46, 50, 51, 42, 39, 25, 36, 19, 18, 50,
    47, 39, 47, 47, 15, 21, 44, 47, 49, 51, 47, 48, 47, 34, 20,
    47, 47, 45, 49, 50, 28, 44, 41, 46, 48, 8, 21, 47, 41, 29,
    45, 49, 44, 47, 50, 47, 37, 7, 7, 21, 48, 49, 44, 15, 48,
    43, 47, 44, 42, 50, 47, 47, 5, 7, 27, 30, 37, 49, 47, 12,
    45, 32, 26, 12, 25, 45, 43, 48, 50, 18, 13, 31, 23, 50, 46,
    23, 8, 35, 47, 45, 14, 47, 15, 42, 11, 39, 45, 49, 11, 35,
    43, 29, 42, 25, 40, 14, 8, 47, 10, 47, 34, 29, 33, 9, 43,
    38, 44, 38, 4, 46, 38, 46, 27, 45, 36, 15, 45, 38, 47, 44,
    48, 45, 41, 27, 5, 41, 15, 44, 42, 31, 40, 41, 13, 10, 47,
    10, 46, 47, 48, 45, 28, 30, 39, 48, 31, 44, 44, 18, 44, 44,
    46, 34, 32, 35, 43, 42, 42, 45, 25, 39, 45, 42, 36, 44, 5,
    43, 15, 46, 42, 44, 41, 44, 47, 18, 32, 25, 42, 39, 12, 6,
    40, 20, 41, 17, 46, 40, 35, 43, 43, 4, 27, 44, 40, 42, 14,
    43, 44, 44, 43, 43, 38, 35, 47, 45, 44, 3, 7, 44, 46, 42,
    44, 9, 29, 47, 31, 41, 41, 46, 27, 11, 44, 45, 44, 45, 36,
    32, 42, 42, 42, 43, 12, 14, 4, 43, 43, 42, 43, 5, 40, 42,
    45, 46, 43, 40, 38, 43, 34, 38, 25, 45, 44, 14, 42, 41, 44,
    10, 41, 37, 42, 30, 43, 43, 29, 41, 6, 29, 26, 40, 43, 42,
    16, 43, 46, 43, 40, 28, 40, 26, 43, 42, 30, 42, 42, 42, 43,
    15, 45, 41, 3, 41, 42, 42, 38, 10, 18, 40, 9, 44, 40, 45,
    42, 6, 42, 40, 42, 41, 6, 23, 41, 45, 43, 40, 43, 42, 41,
    29, 40, 42, 18, 11, 36, 15, 42, 24, 38, 40, 43, 33, 10, 32,
    40, 42, 36, 41, 40, 41, 6, 3, 42, 30, 16, 44, 40, 45, 20,
    12, 21, 42, 42, 39, 13, 33, 20, 27, 3, 41, 36, 32, 36, 7,
    27, 40, 31, 45, 42, 45, 45, 39, 44, 39, 43, 42, 43, 15, 35,
    39, 19, 28, 41, 38, 40, 39, 31, 37, 41, 40, 44, 41, 38, 41,
    38, 6, 40, 42, 19, 9, 41, 41, 43, 36, 16, 42, 41, 40, 10,
    29, 42, 39, 32, 43, 36, 43, 41, 40, 41, 44, 38, 39, 20, 39,
    43, 39, 41, 43, 1, 42, 40, 32, 38, 40, 38, 38, 38, 29, 3,
    39, 40, 39, 18, 43, 44, 40, 43, 39, 42, 40, 28, 35, 41, 42,
    39, 42, 36, 41, 40, 35, 40, 40, 40, 37, 39, 39, 39, 41, 40,
    32, 37, 40, 15, 26, 33, 37, 31, 40, 40, 30, 36, 39, 36, 19,
    5, 39, 41, 40, 4, 37, 41, 41, 42, 21, 17, 42, 35, 4, 3, 42,
    35, 12, 36, 42, 40, 40, 17, 38, 39, 37, 41, 39, 39, 40, 39,
    37, 37, 42, 40, 41, 42, 35, 39, 39, 30, 39, 38, 37, 15, 28,
    24, 38, 37, 31, 1, 12, 14, 29, 38, 28, 37, 36, 35, 38, 10,
    5, 10, 36, 42, 42, 25, 42, 38, 6, 39, 40, 41, 41, 36, 42,
    41, 38, 38, 40, 21, 41, 37, 7, 36, 17, 36, 38, 21, 37, 3,
    7, 41, 38, 37, 35, 37, 6, 27, 41, 37, 40, 38, 38, 12, 36,
    34, 41, 18, 34, 35, 38, 40, 37, 37, 5, 36, 38, 37, 39, 38,
    42, 38, 31, 37, 32, 38, 40, 35, 40, 36, 38, 34, 39, 39, 37,
    38, 34, 41, 36, 39, 38, 30, 37, 36, 38, 34, 33, 36, 40, 26,
    8, 6, 37, 36, 36, 23, 25, 34, 39, 34, 30, 21, 35, 36, 39,
    37, 37, 36, 36, 25, 37, 34, 38, 35, 35, 36, 3, 34, 36, 35,
    37, 40, 36, 37, 39, 36, 36, 37, 36, 23, 17, 37, 35, 17, 37,
    6, 36, 36, 38, 37, 7, 4, 34, 37, 36, 36, 34, 36, 35, 34,
    36, 35, 39, 28, 37, 37, 36, 38, 35, 36, 35, 16, 37, 34, 36,
    37, 36, 35, 30, 39, 36, 36, 26, 32, 36, 36, 35, 29, 35, 23,
    39, 35, 36, 35, 13, 35, 35, 39, 33, 36, 35, 27, 36, 30, 36,
    39, 37, 35, 30, 4, 32, 3, 34, 24, 36, 36, 36, 33, 36, 32,
    35, 37, 33, 5, 33, 33, 24, 35, 36, 35, 33, 26, 36, 35, 36,
    33, 26, 33, 31, 32, 32, 25, 22, 38, 6, 31, 34, 3, 35, 35,
    32, 35, 35, 31, 32, 9, 34, 3, 35, 34, 33, 9, 18, 33, 32,
    35, 35, 34, 27, 35, 31, 34, 31, 17, 38, 36, 34, 34, 34, 11,
    29, 35, 32, 34, 32, 35, 12, 30, 37, 33, 21, 34, 27, 31, 35,
    22, 34, 36, 33, 35, 35, 37, 36, 35, 33, 5, 4, 34, 31, 14,
    26, 9, 23, 31, 28, 36, 34, 14, 12, 30, 37, 6, 31, 28, 33,
    32, 34, 33, 31, 27, 35, 6, 27, 30, 31, 30, 29, 16, 31, 34,
    35, 32, 26, 25, 28, 31, 23, 21, 30, 27, 32, 33, 16, 30, 31,
    31, 32, 34, 20, 29, 28, 16, 6, 26, 30, 29, 20, 28, 50, 133,
    133, 1, 133, 40, 14, 133, 133, 39, 133, 133, 132, 132, 132,
    132, 132, 132, 132, 132, 132, 114, 132, 89, 132, 67, 132,
    33, 76, 60, 47, 132, 132, 132, 131, 24, 131, 131, 131, 131,
    131, 131, 131, 112, 83, 111, 131, 131, 131, 116, 50, 116,
    131, 131, 63, 131, 131, 131, 131, 110, 131, 98, 131, 131,
    88, 23, 131, 21, 131, 51, 130, 130, 130, 130, 130, 130, 35,
    130, 130, 129, 126, 129, 129, 123, 129, 129, 129, 129, 129,
    129, 129, 129, 129, 129, 129, 129, 110, 39, 129, 129, 15,
    129, 129, 100, 118, 53, 128, 128, 128, 29, 128, 47, 128,
    13, 111, 128, 50, 128, 118, 67, 128, 128, 128, 128, 25, 127,
    127, 127, 126, 50, 67, 126, 126, 53, 28, 25, 126, 126, 43,
    24, 126, 36, 126, 126, 126, 33, 9, 125, 95, 125, 125, 125,
    113, 125, 125, 125, 91, 74, 5, 121, 125, 125, 125, 70, 124,
    55, 119, 119, 36, 34, 106, 124, 124, 64, 79, 124, 124, 99,
    124, 124, 110, 124, 124, 124, 123, 105, 123, 11, 75, 123,
    102, 110, 123, 123, 71, 60, 36, 123, 123, 27, 123, 93, 39,
    123, 123, 123, 123, 123, 41, 123, 48, 122, 43, 122, 82, 122,
    122, 82, 83, 98, 60, 86, 122, 100, 59, 122, 122, 108, 31,
    122, 122, 122, 3, 45, 16, 36, 97, 89, 39, 121, 55, 100, 121,
    37, 121, 17, 22, 120, 33, 60, 42, 120, 86, 120, 120, 120,
    111, 89, 120, 98, 120, 120, 120, 60, 120, 18, 13, 120, 109,
    120, 120, 119, 119, 24, 119, 27, 104, 119, 6, 18, 49, 119,
    23, 119, 119, 3, 119, 97, 119, 119, 73, 9, 119, 99, 119,
    12, 118, 118, 118, 118, 102, 118, 118, 119, 58, 118, 34,
    86, 118, 47, 118, 118, 26, 117, 117, 117, 117, 117, 117,
    28, 117, 45, 9, 117, 117, 117, 26, 117, 8, 117, 35, 117,
    116, 82, 116, 116, 116, 69, 46, 116, 116, 32, 116, 116, 116,
    116, 116, 97, 70, 116, 69, 37, 116, 116, 116, 116, 116, 31,
    99, 16, 73, 56, 47, 116, 29, 115, 35, 103, 80, 22, 114, 114,
    68, 37, 52, 67, 114, 49, 114, 114, 114, 113, 22, 113, 113,
    113, 113, 113, 105, 113, 113, 113, 6, 91, 113, 113, 113,
    103, 91, 113, 113, 85, 91, 113, 100, 113, 113, 113, 39, 72,
    85, 112, 112, 106, 112, 112, 112, 10, 72, 35, 112, 55, 112,
    46, 112, 112, 112, 112, 112, 32, 112, 73, 80, 99, 112, 17,
    111, 14, 111, 111, 111, 111, 111, 57, 111, 75, 111, 111,
    15, 111, 80, 111, 62, 8, 42, 56, 111, 111, 22, 78, 103, 57,
    110, 110, 110, 9, 25, 64, 96, 59, 14, 61, 52, 110, 110, 109,
    118, 144, 210, 150, 200, 204, 150, 203, 167, 196, 198, 204,
    203, 209, 147, 197, 195, 207, 201, 170, 182, 182, 210, 196,
    207, 217, 201, 204, 196, 210, 203, 160, 197, 182, 208, 205,
    211, 141, 205, 179, 136, 196, 201, 211, 159, 132, 200, 205,
    160, 146, 172, 209, 211, 212, 202, 206, 204, 204, 214, 163,
    188, 208, 123, 199, 158, 176, 207, 135, 201, 173, 174, 212,
    146, 177, 208, 171, 200, 174, 135, 129, 199, 200, 203, 216,
    195, 215, 160, 180, 202, 198, 205, 203, 205, 210, 209, 201,
    134, 208, 125, 203, 116, 199, 129, 212, 208, 205, 214, 199,
    208, 210, 211, 199, 205, 211, 210, 152, 128, 210, 198, 198,
    200, 211, 213, 203, 215, 199, 181, 189, 204, 211, 136, 140,
    203, 149, 208, 198, 126, 171, 216, 212, 148, 142, 199, 209,
    139, 211, 195, 198, 154, 137, 201, 211, 127, 205, 198, 211,
    197, 158, 126, 212, 205, 200, 207, 203, 210, 212, 203, 181,
    211, 216, 201, 208, 167, 151, 200, 144, 207, 183, 141, 212,
    195, 203, 158, 202, 209, 204, 185, 127, 215, 210, 177, 211,
    195, 145, 198, 173, 211, 202, 186, 207, 205, 208, 209, 174,
    209, 207, 130, 212, 215, 213, 211, 212, 214, 203, 203, 214,
    134, 214, 199, 187, 133, 203, 138, 214, 131, 115, 215, 130,
    202, 209, 211, 200, 174, 212, 203, 201, 191, 214, 137, 203,
    204, 204, 170, 204, 203, 140, 152, 151, 203, 128, 128, 210,
    195, 202, 179, 211, 209, 208, 162, 119, 147, 202, 211, 215,
    200, 204, 205, 132, 208, 208, 210, 212, 205, 211, 211, 202,
    199, 134, 188, 133, 170, 181, 170, 147, 199, 205, 210, 216,
    203, 163, 217, 155, 203, 155, 216, 209, 210, 145, 198, 212,
    211, 215, 192, 170, 216, 216, 214, 212, 210, 211, 205, 199,
    173, 209, 203, 202, 215, 197, 199, 198, 214, 203, 201, 171,
    205, 148, 214, 203, 194, 208, 209, 141, 203, 209, 198, 136,
    210, 196, 197, 149, 202, 136, 176, 146, 157, 205, 121, 197,
    203, 128, 199, 200, 214, 125, 120, 204, 216, 159, 200, 139,
    210, 217, 192, 182, 203, 146, 202, 210, 214, 200, 199, 202,
    200, 211, 188, 201, 200, 160, 217, 167, 209, 143, 142, 142,
    200, 204, 196, 202, 216, 200, 203, 196, 137, 195, 212, 215,
    157, 212, 211, 207, 193, 136, 210, 194, 137, 211, 204, 204,
    214, 200, 118, 202, 209, 215, 201, 203, 203, 136, 204, 211,
    121, 213, 214, 210, 166, 126, 129, 196, 203, 214, 214, 145,
    208, 136, 211, 202, 213, 211, 201, 210, 196, 208, 211, 208,
    198, 216, 211, 214, 140, 193, 177, 191, 205, 201, 169, 208,
    198, 214, 143, 198, 199, 181, 201, 176, 172, 212, 136, 178,
    184, 214, 205, 217, 204, 203, 210, 144, 198, 201, 213, 207,
    208, 183, 202, 182, 203, 212, 216, 217, 202, 199, 168, 194,
    190, 185, 202, 186, 202, 134, 199, 192, 203, 213, 195, 149,
    188, 205, 198, 182, 158, 153, 156, 212, 19, 84, 106, 82,
    119, 100, 22, 42, 102, 128, 64, 16, 59, 55, 64, 75, 48, 35,
    87, 54, 32, 111, 87, 41, 97, 102, 36, 69, 60, 30, 105, 17,
    15, 52, 123, 63, 73, 11, 101, 22, 67, 112, 110, 34, 29, 90,
    122, 81, 36, 24, 22, 69, 24, 56, 45, 46, 68, 102, 33, 46,
    7, 103, 45, 109, 15, 149, 72, 92, 56, 118, 40, 113, 10, 13,
    51, 107, 72, 88, 18, 108, 33, 72, 12, 60, 22, 31, 104, 19,
    13, 90, 40, 86, 37, 36, 40, 4, 50, 36, 63, 70, 33, 70, 87,
    6, 122, 4, 214, 99, 121, 39, 37, 122, 93, 67, 89, 106, 53,
    86, 63, 70, 122, 85, 103, 44, 83, 77, 50, 39, 86, 74, 91,
    84, 46, 71, 129, 16, 96, 100, 119, 77, 48, 214, 60, 82, 92,
    118, 65, 83, 73, 96, 108, 205, 32, 109, 209, 61, 19, 120,
    87, 100, 84, 74, 119, 10, 103, 112, 45, 112, 126, 36, 49,
    119, 68, 52, 61, 16, 14, 91, 124, 31, 74, 121, 92, 107, 105,
    47, 63, 110, 208, 58, 32, 94, 27, 87, 118, 74, 38, 91, 111,
    63, 47, 28, 67, 62, 47, 68, 58, 62, 21, 84, 207, 40, 21,
    108, 80, 55, 60, 93, 83, 67, 96, 100, 28, 97, 40, 22, 80,
    90, 97, 36, 110, 35, 95, 94, 66, 116, 101, 88, 39, 60, 68,
    109, 71, 70, 27, 103, 64, 23, 92, 45, 78, 14, 87, 109, 101,
    98, 84, 111, 57, 109, 110, 24, 52, 80, 114, 96, 96, 36, 108,
    48, 59, 196, 43, 113, 190, 32, 34, 36, 72, 47, 95, 8, 92,
    128, 100, 94, 117, 117, 109, 49, 78, 59, 22, 112, 27, 32,
    125, 49, 16, 71, 122, 148, 92, 83, 57, 166, 21, 40, 107,
    55, 24, 109, 112, 51, 44, 111, 114, 55, 105, 97, 33, 52,
    24, 66, 98, 2, 23, 104, 4, 107, 51, 76, 112, 97, 32, 5, 101,
    15, 42, 69, 64, 90, 117, 107, 120, 99, 102, 73, 81, 82, 81,
    83, 95, 77, 101, 87, 132, 33, 30, 93, 126, 121, 21, 30, 27,
    112, 108, 8, 103, 80, 123, 53, 24, 33, 81, 61, 38, 125, 95,
    40, 71, 57, 125, 145, 55, 1, 96, 113, 80, 3, 23, 38, 158,
    108, 104, 11, 6, 79, 134, 74, 40, 111, 110, 96, 126, 33,
    105, 22, 23, 70, 44, 10, 55, 81, 86, 122, 107, 18, 104, 112,
    23, 109, 115, 102, 110, 103, 112, 50, 78, 105, 73, 89, 96,
    95, 69, 60, 71, 28, 62, 15, 91, 28, 66, 28, 121, 71, 6, 135,
    18, 15, 118, 80, 135, 61, 107, 49, 104, 103, 55, 103, 12,
    102, 100, 67, 34, 168, 159, 114, 13, 36, 128, 28, 43, 57,
    106, 97, 15, 99, 4, 84, 90, 123, 90, 16, 52, 75, 76, 70,
    76, 95, 105, 104, 70, 76, 65, 10, 62, 64, 27, 37, 88, 44,
    95, 56, 47, 122, 80, 88, 11, 64, 63, 94, 38, 90, 61, 62,
    64, 91, 56, 66, 79, 86, 89, 41, 26, 86, 52, 16, 2, 124, 108,
    62, 3, 73, 33, 59, 29, 29, 78, 78, 69, 82, 32, 78, 120, 6,
    133, 123, 61, 101, 44, 8, 29, 87, 5, 80, 3, 30, 79, 83, 58,
    69, 54, 30, 11, 117, 117, 87, 43, 81, 57, 47, 60, 16, 109,
    76, 65, 81, 2, 89, 79, 55, 114, 29, 6, 110, 110, 90, 92,
    21, 104, 65, 103, 79, 33, 44, 8, 45, 118, 51, 77, 65, 77,
    48, 38, 90, 29, 50, 112, 102, 36, 20, 50, 31, 1, 7, 63, 95,
    69, 42, 11, 3, 1, 39, 95, 23, 73, 26, 72, 43, 30, 18, 33,
    45, 60, 36, 55, 51, 91, 8, 47, 57, 61, 72, 48, 44, 53, 25,
    35, 72, 68, 20, 59, 7, 59, 12, 83, 53, 31, 60, 15, 84, 32,
    29, 47, 73, 54, 50, 25, 46, 63, 52, 52, 45, 18, 31, 34, 45,
    31, 21, 8, 29, 24, 77, 13, 79, 42, 40, 10, 29, 34, 32, 31,
    28, 28, 34, 27, 30, 32, 23, 55, 43, 28, 6, 9, 69, 48, 48,
    37, 49, 54, 40, 36, 25, 19, 26, 15, 30, 27, 31, 1, 18, 6,
    26, 22, 9, 24, 19, 28, 20, 24, 25, 31, 61, 10, 50, 43, 42,
    42, 41, 41, 40, 25, 24, 81, 1, 25, 14, 1, 14, 23, 28, 1,
    8, 12, 27, 22, 17, 16, 20, 1, 26, 10, 17, 20, 25, 23, 3,
    25, 45, 32, 20, 31, 31, 40, 47, 1, 28, 31, 30, 30, 30, 31,
    2, 16, 23, 28, 1, 14, 22, 24, 7, 23, 1, 24, 27, 23, 12, 22,
    1, 18, 14, 19, 22, 1, 3, 1, 22, 21, 12, 18, 8, 17, 6, 9,
    3, 2, 2, 19, 2, 17, 28, 18, 1, 14, 14, 2, 16, 18, 18, 37,
    14, 16, 18, 4, 15, 2, 32, 32, 48, 13, 7, 9, 6, 4, 4, 3, 26,
    4, 10, 9, 8, 2, 8, 4, 10, 4, 40, 4, 25, 13, 40, 18, 24, 24,
    2, 2, 30, 30, 10, 22, 15, 11, 10, 24, 13, 18, 22, 21, 16,
    16, 17, 18, 4, 19, 19, 20, 16, 12, 19, 18, 20, 16, 21, 22,
    5, 34, 8, 12, 17, 20, 16, 11, 6, 12, 9, 19, 55, 8, 13, 22,
    16, 6, 20, 15, 20, 15, 12, 12, 20, 7, 16, 3, 7, 11, 12, 14,
    12, 16, 12, 12, 11, 14, 12, 12, 20, 11, 12, 13, 10, 14, 12,
    11, 8, 12, 13, 16, 16, 11, 15, 2, 11, 12, 10, 11, 10, 12,
    13, 12, 5, 6, 19, 11, 9, 13, 6, 12, 10, 4, 10, 12, 2, 3,
    6, 18, 7, 15, 17, 12, 3, 17, 10, 15, 60, 60, 60, 60, 60,
    60, 60, 60, 60, 60, 9.5999999999999996, 19.199999999999999,
    60, 60, 60, 1.2, 60, 55.200000000000003, 2.3999999999999999,
    60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
    62.399999999999999, 60, 60, 60, 32.399999999999999, 60, 60,
    20.399999999999999, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
    22.800000000000001, 60, 60, 60, 60, 60, 60, 60, 60, 60, 56.399999999999999,
    60, 60, 60, 60, 60, 60, 60, 60, 44.399999999999999, 60, 60,
    60, 24, 60, 60, 60, 10.800000000000001, 60, 18, 60, 60, 16.800000000000001,
    60, 60, 60, 26.399999999999999, 22.800000000000001, 60, 1.2,
    60, 60, 12, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
    60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
    60, 8.4000000000000004, 12, 60, 60, 39.600000000000001, 60,
    60, 60, 60, 60, 60, 60, 60, 60, 7.2000000000000002, 37.200000000000003,
    60, 60, 60, 60, 9.5999999999999996, 60, 20.399999999999999,
    6, 60, 60, 7.2000000000000002, 60, 60, 60, 50.399999999999999,
    60, 26.399999999999999, 60, 60, 60, 60, 60, 60, 60, 60, 60,
    60, 60, 60, 60, 12, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
    58.799999999999997, 58.799999999999997, 60, 60, 60, 60, 60,
    61.200000000000003, 60, 39.600000000000001, 19.199999999999999,
    15.6, 60, 60, 60, 60, 60, 60, 60, 60, 22.800000000000001,
    60, 60, 60, 89, 46, 85, 85, 43, 58, 74, 70, 52, 41, 51, 62,
    58, 62, 63, 75, 65, 45, 51, 34, 58, 67, 49, 94, 44, 37, 47,
    74, 77, 85, 44, 26, 37, 73, 32, 39, 51, 79, 71, 43, 45, 15,
    64, 74, 64, 69, 48, 47, 71, 84, 70, 34, 34, 58, 104, 51,
    41, 62, 61, 36, 67, 61, 49, 5, 45, 104, 36, 53, 39, 30, 70,
    52, 30, 64, 9, 60, 32, 65, 55, 30, 78, 61, 61, 45, 28, 61,
    45, 59, 76, 59, 41, 23, 65, 83, 24, 68, 47, 19, 47, 58, 13,
    60, 93, 35, 50, 51, 44, 64, 59, 61, 62, 37, 48, 65, 67, 63,
    56, 37, 37, 56, 69, 51, 69, 58, 59, 87, 11, 63, 59, 64, 53,
    64, 43, 88, 60, 64, 47, 64, 69, 90, 48, 59, 43, 39, 17, 48,
    65, 96, 30, 41, 52, 95, 63, 69, 23, 67, 99, 53, 63, 63, 45,
    35, 71, 14, 49, 59, 76, 59, 102, 66, 88, 49, 24, 104, 75,
    42, 52, 48, 49, 39, 104, 65, 64, 53, 82, 60, 60, 98, 93,
    41, 57, 77, 85, 73, 68, 62, 57, 35, 104, 69, 19, 20, 37,
    38, 104, 28, 68, 1, 34, 46, 24, 63, 22, 91, 84, 50, 3, 21,
    36, 70, 23, 25, 4, 13, 73, 12, 47, 73, 12, 47, 21, 11, 101,
    9, 51, 34, 36, 23, 48, 35, 65, 25, 70, 21, 56, 21, 98, 18,
    35, 66, 19, 39, 16, 60, 48, 40, 60, 60, 60, 11, 60, 29, 18,
    60, 60, 60, 14, 4, 60, 4, 60, 60, 60, 60, 60, 60, 60, 60,
    60, 60, 60, 40, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 47,
    48, 60, 60, 60, 25, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
    2, 60, 60, 55, 60, 60, 60, 51, 60, 60, 53, 26, 60, 39, 60,
    60, 60, 60, 44, 60, 51.399999999999999, 66.099999999999994,
    47.200000000000003, 42.200000000000003, 26.600000000000001,
    51.399999999999999, 53.299999999999997, 42.399999999999999,
    53, 52.5, 72.299999999999997, 45.399999999999999, 53, 41.899999999999999,
    47.200000000000003, 45.200000000000003, 36.5, 52.899999999999999,
    33.299999999999997, 35.5, 61.200000000000003, 45.200000000000003,
    53.299999999999997, 33.799999999999997, 53.200000000000003,
    52.399999999999999, 55.299999999999997, 53, 37.100000000000001,
    68.299999999999997, 34.299999999999997, 53.799999999999997,
    53.5, 42.299999999999997, 55.600000000000001, 51.600000000000001,
    41.299999999999997, 52.899999999999999, 35.899999999999999,
    45.200000000000003, 49.200000000000003, 53.299999999999997,
    35, 45.200000000000003, 54.399999999999999, 35.200000000000003,
    72.900000000000006, 61.600000000000001, 60.100000000000001,
    52.899999999999999, 12, 84, 84, 84, 84, 84, 82.799999999999997,
    82.799999999999997, 82.799999999999997, 80.400000000000006,
    79.200000000000003, 79.200000000000003, 79.200000000000003,
    75.599999999999994, 75.599999999999994, 74.400000000000006,
    81.599999999999994, 38.399999999999999, 80.400000000000006,
    14.4, 76.799999999999997, 78, 26.399999999999999, 54, 52.799999999999997,
    84, 79.200000000000003, 79.200000000000003, 79.200000000000003,
    76.799999999999997, 6, 70.799999999999997, 7.2000000000000002,
    63.600000000000001, 61.200000000000003, 14.4, 56.399999999999999,
    37.200000000000003, 61.200000000000003, 60, 61.200000000000003,
    60, 56.399999999999999, 56.399999999999999, 61.200000000000003,
    44.399999999999999, 61.200000000000003, 55.200000000000003,
    60, 22.800000000000001, 36, 1.2, 16.800000000000001, 37.200000000000003,
    68.400000000000006, 50.399999999999999, 57.600000000000001,
    38.399999999999999, 33, 14, 55, 22, 40, 10, 23, 37, 12, 45,
    37, 28, 13, 15, 18, 12, 44, 4, 22, 46, 41, 49, 6, 35, 45,
    15, 43, 52, 51, 52, 20, 45, 51, 42, 50, 9, 14, 47, 53, 0,
    52, 33, 19, 45, 32, 18, 33, 50, 36, 52, 46, 27, 50, 53, 47,
    26, 25, 28, 14, 35, 29, 3, 45, 41, 12, 46, 47, 17, 2, 1,
    51, 19, 0, 53, 17, 18, 8, 35, 30, 8, 10, 15, 47, 29, 38,
    54, 43, 12, 44, 47, 20, 13, 32, 43, 51, 29, 33, 55, 30, 47,
    40, 9, 49, 52, 56, 29, 3, 6, 54, 29, 47, 46, 52, 51, 38,
    34, 47, 19, 48, 31, 47, 24, 40, 46, 24, 55, 14, 53, 23, 48,
    38, 12, 50, 46, 0, 28, 53, 44, 53, 44, 52, 43, 37, 38, 43,
    21, 48, 19, 24, 30, 35, 19, 33, 49, 50, 38, 22, 22, 31, 23,
    38, 26, 52, 37, 15, 44, 27, 44, 52, 27, 8, 52, 41, 55, 28,
    3, 9, 45, 11, 42, 43, 37, 45, 18, 6, 56, 52, 46, 43, 15,
    43, 42, 16, 25, 48, 38, 48, 31, 49, 32, 12, 11, 46, 24, 13,
    4, 56, 5, 13, 50, 30, 48, 41, 54, 37, 46, 25, 16, 7, 46,
    42, 47, 4, 2, 39, 43, 34, 49, 52, 24, 16, 48, 46, 25, 44,
    10, 53, 12, 37, 17, 44, 41, 22, 35, 51, 51, 54, 39, 47, 46,
    47, 51, 49, 41, 1, 45, 19, 28, 39, 44, 39, 21, 26, 48, 48,
    50, 25, 48, 39, 7, 30, 49, 59, 40, 34, 51, 51, 3, 56, 28,
    17, 3, 40, 44, 45, 50, 46, 47, 40, 28, 40, 14, 42, 39, 48,
    23, 31, 11, 8, 29, 35, 54, 12, 47, 48, 24, 26, 41, 38, 18,
    43, 26, 40, 23, 47, 51, 8, 41, 28, 0, 16, 9, 12, 22, 49,
    18, 11, 26, 26, 18, 15, 38, 36, 34, 26, 12, 34, 20, 48, 47,
    50, 6, 13, 14, 37, 34, 42, 6, 50, 11, 52, 43, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0,
    0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0,
    0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
    1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
    0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0,
    0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0,
    0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0,
    0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
    0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 1,
    0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0,
    0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0,
    0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 1,
    0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0,
    0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1,
    0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 0,
    0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
    0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0,
    1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0,
    0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1,
    0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 0,
    1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0,
    0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 0,
    1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0,
    1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 1, 0, 0, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1,
    0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1,
    0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0,
    0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1,
    1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 1,
    0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 1,
    0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 1,
    1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1,
    1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1,
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1,
    0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 0,
    1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1,
    1, 1, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1,
    1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1,
    1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1,
    0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 0, 1, 0, 0,
    0, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 1,
    1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1,
    0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1,
    1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1,
    1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1,
    0, 1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0, 0, 1, 0,
    1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1,
    0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0,
    1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0,
    1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1,
    0, 1, 0, 1, 0, 0, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1,
    1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 0,
    1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0,
    1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1,
    0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1,
    0, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0,
    1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1,
    1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0,
    0, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0,
    1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1,
    1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1,
    1, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 0,
    1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0,
    1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1,
    1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1,
    1, 1, 1, 0, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1,
    0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1,
    0, 0, 1, 0, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1,
    1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0,
    1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1,
    0, 1, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0,
    0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
    0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1,
    0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0,
    0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0,
    1, 0, 1, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1,
    0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0,
    0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
    0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0,
    1, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0,
    1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0,
    0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0,
    1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1,
    0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0,
    0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1,
    0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0,
    0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0,
    0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0,
    0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0,
    1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0,
    0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
    1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0,
    0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0,
    0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0,
    0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0,
    0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0,
    0, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0,
    0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
    0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 0,
    0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0,
    1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
    0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1,
    1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0,
    1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0, 0,
    0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0,
    1, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1,
    0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 0,
    0, 1, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 1, 0, 0, 1, 1, 1, 0,
    0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0,
    1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1,
    1, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1, 0, 1, 0, 0,
    0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 1,
    0, 1, 1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 1, 0,
    1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1,
    0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0,
    1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1,
    1, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0,
    0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 0,
    0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0,
    1, 0, 0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0,
    0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1,
    0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0,
    0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 1,
    1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 1, 0,
    1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0,
    0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 1, 0,
    1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0,
    1, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0, 1, 1,
    0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1,
    1, 0, 1, 0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0,
    0, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0,
    1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0,
    1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 1,
    0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1,
    0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0,
    1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 1,
    0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 1, 1, 0,
    0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1,
    1, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0,
    0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0,
    1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1,
    1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0,
    0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1,
    1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
    0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0,
    0, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 0, 1,
    0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0,
    0, 0, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0,
    0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0,
    1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0,
    0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 1, 1, 0,
    0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0,
    1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
    0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1,
    1, 1, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0,
    1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0,
    1, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0,
    1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 1, 0, 0,
    0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1,
    0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1,
    1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0,
    0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1,
    0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0,
    0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0,
    1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
    0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0,
    0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 0, 0, 1), .Dim = c(8697L, 2L), .Dimnames = list(
        NULL, c("time", "status")), type = "right", class = "Surv"),
    mmrc = c(1L, 3L, 1L, 2L, 2L, 2L, 3L, 2L, 2L, 2L, 3L, 2L,
    3L, 3L, 2L, 2L, 2L, 2L, 3L, 2L, 2L, 3L, 3L, 2L, 1L, 2L, 2L,
    2L, 2L, 2L, 2L, 3L, 3L, 3L, 2L, 1L, 2L, 3L, 2L, 1L, 2L, 1L,
    1L, 2L, 1L, 2L, 1L, 1L, 2L, 2L, 2L, 3L, 2L, 2L, 4L, 1L, 0L,
    0L, 0L, 1L, 0L, 1L, 4L, 1L, 0L, 0L, 2L, 1L, 4L, 0L, 0L, 1L,
    1L, 0L, 0L, 0L, 1L, 1L, 0L, 2L, 4L, 1L, 1L, 1L, 4L, 0L, 1L,
    1L, 4L, 0L, 4L, 0L, 0L, 1L, 0L, 2L, 0L, 0L, 1L, 0L, 0L, 1L,
    2L, 1L, 2L, 0L, 0L, 1L, 0L, 0L, 1L, 1L, 1L, 1L, 0L, 1L, 2L,
    4L, 2L, 0L, 2L, 1L, 4L, 0L, 1L, 0L, 1L, 1L, 1L, 0L, 1L, 1L,
    1L, 1L, 0L, 0L, 1L, 0L, 0L, 0L, 4L, 1L, 1L, 0L, 0L, 0L, 4L,
    1L, 0L, 1L, 0L, 4L, 0L, 1L, 0L, 0L, 0L, 0L, 1L, 1L, 1L, 0L,
    1L, 0L, 0L, 1L, 0L, 4L, 1L, 1L, 1L, 4L, 4L, 4L, 0L, 0L, 1L,
    1L, 4L, 0L, 0L, 1L, 0L, 0L, 1L, 0L, 0L, 2L, 1L, 1L, 2L, 1L,
    4L, 0L, 0L, 4L, 2L, 0L, 4L, 1L, 0L, 1L, 4L, 1L, 1L, 0L, 0L,
    4L, 1L, 1L, 1L, 4L, 0L, 0L, 2L, 1L, 0L, 0L, 0L, 1L, 1L, 4L,
    1L, 2L, 1L, 1L, 4L, 0L, 0L, 2L, 1L, 4L, 1L, 1L, 2L, 1L, 4L,
    1L, 1L, 1L, 1L, 2L, 2L, 1L, 0L, 0L, 2L, 1L, 1L, 0L, 1L, 1L,
    0L, 0L, 0L, 2L, 2L, 4L, 0L, 2L, 0L, 0L, 2L, 0L, 2L, 0L, 0L,
    0L, 1L, 0L, 0L, 0L, 1L, 0L, 0L, 1L, 1L, 4L, 0L, 0L, 0L, 2L,
    0L, 0L, 1L, 1L, 0L, 1L, 0L, 0L, 0L, 0L, 1L, 1L, 0L, 0L, 1L,
    0L, 1L, 0L, 1L, 1L, 4L, 2L, 0L, 1L, 0L, 0L, 0L, 1L, 1L, 1L,
    0L, 1L, 4L, 2L, 2L, 1L, 2L, 1L, 1L, 2L, 0L, 0L, 2L, 0L, 0L,
    1L, 0L, 0L, 0L, 1L, 4L, 1L, 0L, 1L, 1L, 0L, 0L, 0L, 1L, 1L,
    1L, 4L, 0L, 1L, 0L, 2L, 2L, 1L, 0L, 4L, 1L, 2L, 1L, 0L, 1L,
    1L, 0L, 1L, 4L, 1L, 4L, 0L, 1L, 1L, 1L, 4L, 1L, 2L, 1L, 0L,
    0L, 1L, 1L, 1L, 0L, 2L, 0L, 0L, 0L, 1L, 1L, 4L, 1L, 0L, 1L,
    0L, 0L, 1L, 4L, 0L, 1L, 1L, 1L, 1L, 4L, 4L, 1L, 0L, 0L, 0L,
    0L, 0L, 2L, 1L, 0L, 1L, 0L, 1L, 0L, 2L, 1L, 4L, 0L, 0L, 0L,
    1L, 2L, 0L, 1L, 0L, 4L, 1L, 1L, 0L, 0L, 1L, 1L, 0L, 4L, 0L,
    0L, 1L, 0L, 0L, 4L, 1L, 1L, 2L, 0L, 1L, 0L, 1L, 4L, 1L, 1L,
    4L, 1L, 0L, 0L, 0L, 0L, 4L, 1L, 1L, 0L, 4L, 0L, 0L, 1L, 1L,
    2L, 0L, 1L, 0L, 0L, 1L, 0L, 4L, 0L, 0L, 0L, 0L, 1L, 1L, 2L,
    4L, 0L, 0L, 1L, 0L, 2L, 1L, 1L, 0L, 0L, 4L, 4L, 0L, 1L, 0L,
    1L, 1L, 1L, 1L, 1L, 1L, 0L, 0L, 0L, 1L, 1L, 1L, 2L, 1L, 0L,
    1L, 0L, 0L, 0L, 1L, 1L, 1L, 4L, 1L, 0L, 0L, 2L, 0L, 0L, 1L,
    4L, 4L, 2L, 0L, 0L, 1L, 0L, 1L, 1L, 1L, 2L, 1L, 0L, 2L, 4L,
    0L, 0L, 1L, 4L, 2L, 0L, 0L, 0L, 1L, 0L, 1L, 4L, 0L, 2L, 1L,
    1L, 1L, 0L, 0L, 1L, 1L, 1L, 0L, 1L, 2L, 0L, 0L, 1L, 0L, 4L,
    1L, 4L, 0L, 1L, 1L, 4L, 0L, 4L, 0L, 1L, 1L, 2L, 1L, 1L, 1L,
    2L, 1L, 2L, 0L, 4L, 4L, 0L, 1L, 2L, 2L, 1L, 0L, 1L, 1L, 4L,
    1L, 4L, 0L, 0L, 0L, 2L, 0L, 2L, 0L, 2L, 1L, 1L, 1L, 0L, 0L,
    1L, 4L, 1L, 1L, 4L, 1L, 0L, 4L, 0L, 0L, 2L, 2L, 0L, 0L, 1L,
    4L, 1L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 4L, 1L, 0L, 2L, 0L,
    4L, 1L, 4L, 0L, 2L, 0L, 4L, 0L, 0L, 0L, 1L, 1L, 0L, 0L, 2L,
    4L, 0L, 0L, 4L, 1L, 1L, 4L, 0L, 0L, 1L, 2L, 0L, 0L, 1L, 0L,
    0L, 0L, 0L, 2L, 0L, 0L, 1L, 2L, 0L, 1L, 0L, 0L, 0L, 2L, 2L,
    0L, 1L, 0L, 0L, 1L, 0L, 0L, 4L, 0L, 2L, 2L, 1L, 0L, 0L, 0L,
    1L, 1L, 4L, 0L, 2L, 0L, 1L, 1L, 1L, 0L, 0L, 0L, 0L, 1L, 4L,
    0L, 1L, 0L, 1L, 1L, 1L, 4L, 0L, 1L, 4L, 0L, 1L, 0L, 0L, 0L,
    0L, 4L, 1L, 0L, 0L, 0L, 0L, 0L, 4L, 1L, 0L, 0L, 0L, 0L, 1L,
    0L, 0L, 1L, 1L, 1L, 4L, 0L, 0L, 0L, 0L, 4L, 1L, 0L, 4L, 4L,
    1L, 1L, 1L, 0L, 0L, 1L, 1L, 0L, 1L, 0L, 0L, 4L, 0L, 1L, 1L,
    0L, 0L, 2L, 0L, 1L, 0L, 0L, 0L, 1L, 2L, 1L, 1L, 4L, 1L, 0L,
    4L, 4L, 1L, 1L, 0L, 1L, 2L, 1L, 0L, 1L, 4L, 2L, 0L, 1L, 4L,
    1L, 1L, 0L, 2L, 0L, 0L, 0L, 2L, 1L, 0L, 2L, 1L, 0L, 0L, 1L,
    0L, 1L, 1L, 1L, 1L, 0L, 4L, 0L, 0L, 4L, 4L, 4L, 2L, 1L, 1L,
    4L, 0L, 1L, 0L, 2L, 0L, 0L, 0L, 0L, 1L, 0L, 0L, 4L, 1L, 1L,
    2L, 0L, 1L, 1L, 0L, 2L, 1L, 4L, 0L, 0L, 4L, 2L, 0L, 4L, 4L,
    4L, 4L, 0L, 0L, 4L, 0L, 1L, 1L, 0L, 1L, 1L, 1L, 0L, 2L, 1L,
    0L, 4L, 0L, 0L, 4L, 1L, 0L, 2L, 2L, 0L, 1L, 1L, 0L, 1L, 2L,
    0L, 0L, 0L, 4L, 4L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 1L, 2L, 0L,
    1L, 1L, 1L, 0L, 0L, 1L, 2L, 1L, 0L, 1L, 4L, 0L, 0L, 1L, 4L,
    1L, 0L, 4L, 1L, 1L, 1L, 1L, 4L, 1L, 2L, 2L, 1L, 4L, 1L, 1L,
    0L, 0L, 2L, 0L, 0L, 4L, 1L, 0L, 1L, 4L, 0L, 1L, 1L, 0L, 4L,
    2L, 2L, 0L, 1L, 0L, 0L, 4L, 1L, 1L, 0L, 1L, 1L, 1L, 2L, 2L,
    4L, 0L, 1L, 0L, 4L, 1L, 0L, 0L, 0L, 2L, 1L, 0L, 1L, 0L, 2L,
    4L, 0L, 1L, 0L, 1L, 1L, 0L, 0L, 1L, 0L, 0L, 1L, 2L, 0L, 0L,
    2L, 0L, 2L, 1L, 0L, 0L, 0L, 0L, 4L, 1L, 0L, 4L, 4L, 1L, 0L,
    2L, 2L, 0L, 0L, 1L, 0L, 1L, 0L, 2L, 1L, 0L, 4L, 4L, 4L, 2L,
    4L, 4L, 0L, 4L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 1L, 1L, 1L, 0L,
    1L, 1L, 0L, 1L, 0L, 1L, 0L, 4L, 0L, 1L, 0L, 0L, 0L, 1L, 0L,
    1L, 0L, 0L, 0L, 1L, 0L, 0L, 2L, 2L, 2L, 2L, 0L, 0L, 1L, 0L,
    0L, 1L, 1L, 0L, 0L, 1L, 0L, 1L, 1L, 1L, 0L, 4L, 0L, 0L, 1L,
    0L, 0L, 0L, 1L, 1L, 1L, 1L, 0L, 1L, 4L, 0L, 1L, 0L, 4L, 0L,
    0L, 0L, 0L, 1L, 2L, 0L, 0L, 1L, 1L, 0L, 0L, 1L, 0L, 4L, 4L,
    0L, 1L, 1L, 0L, 4L, 0L, 2L, 1L, 4L, 0L, 4L, 1L, 2L, 4L, 4L,
    2L, 1L, 1L, 1L, 1L, 1L, 1L, 4L, 2L, 0L, 4L, 1L, 0L, 2L, 4L,
    0L, 1L, 1L, 1L, 0L, 4L, 2L, 2L, 0L, 4L, 1L, 0L, 1L, 1L, 0L,
    0L, 4L, 0L, 1L, 2L, 2L, 2L, 1L, 1L, 0L, 0L, 1L, 1L, 1L, 0L,
    1L, 0L, 1L, 1L, 2L, 0L, 0L, 4L, 1L, 0L, 1L, 0L, 0L, 0L, 1L,
    1L, 2L, 1L, 2L, 2L, 1L, 1L, 3L, 3L, 1L, 4L, 2L, 4L, 1L, 1L,
    1L, 2L, 4L, 2L, 2L, 2L, 0L, 4L, 0L, 1L, 2L, 1L, 2L, 1L, 1L,
    1L, 1L, 0L, 0L, 0L, 1L, 0L, 1L, 1L, 0L, 2L, 0L, 2L, 1L, 1L,
    3L, 2L, 1L, 1L, 1L, 2L, 3L, 1L, 1L, 1L, 1L, 2L, 2L, 4L, 2L,
    4L, 4L, 1L, 1L, 2L, 1L, 2L, 0L, 1L, 1L, 1L, 3L, 1L, 0L, 4L,
    4L, 2L, 2L, 1L, 4L, 1L, 0L, 2L, 2L, 1L, 1L, 3L, 2L, 2L, 2L,
    1L, 1L, 1L, 2L, 1L, 2L, 2L, 1L, 1L, 4L, 1L, 2L, 4L, 1L, 1L,
    2L, 0L, 1L, 4L, 4L, 1L, 2L, 1L, 1L, 3L, 4L, 3L, 1L, 4L, 0L,
    2L, 2L, 2L, 4L, 4L, 1L, 1L, 4L, 1L, 2L, 1L, 4L, 2L, 4L, 4L,
    4L, 1L, 1L, 2L, 2L, 1L, 1L, 2L, 1L, 0L, 1L, 2L, 1L, 1L, 2L,
    3L, 1L, 2L, 2L, 1L, 1L, 1L, 4L, 1L, 2L, 1L, 2L, 4L, 2L, 1L,
    1L, 1L, 4L, 4L, 1L, 1L, 4L, 2L, 0L, 1L, 0L, 1L, 1L, 2L, 1L,
    1L, 4L, 1L, 2L, 4L, 2L, 2L, 2L, 0L, 1L, 4L, 4L, 2L, 2L, 0L,
    0L, 4L, 1L, 4L, 1L, 1L, 1L, 1L, 4L, 1L, 1L, 1L, 4L, 4L, 4L,
    2L, 4L, 4L, 2L, 4L, 4L, 4L, 2L, 4L, 2L, 2L, 2L, 1L, 0L, 1L,
    2L, 2L, 1L, 1L, 4L, 4L, 1L, 0L, 1L, 1L, 2L, 4L, 1L, 4L, 1L,
    1L, 2L, 1L, 1L, 0L, 0L, 1L, 1L, 0L, 2L, 1L, 2L, 4L, 1L, 4L,
    4L, 1L, 3L, 2L, 1L, 4L, 1L, 4L, 0L, 4L, 2L, 4L, 2L, 4L, 4L,
    1L, 1L, 4L, 1L, 1L, 4L, 4L, 1L, 4L, 0L, 1L, 4L, 4L, 1L, 1L,
    1L, 4L, 4L, 1L, 1L, 3L, 4L, 3L, 1L, 4L, 4L, 2L, 2L, 4L, 2L,
    4L, 0L, 1L, 4L, 4L, 1L, 4L, 4L, 1L, 2L, 3L, 1L, 2L, 3L, 0L,
    4L, 4L, 1L, 1L, 1L, 0L, 1L, 4L, 1L, 1L, 1L, 1L, 1L, 0L, 1L,
    1L, 0L, 3L, 2L, 1L, 1L, 0L, 2L, 1L, 2L, 2L, 2L, 1L, 1L, 2L,
    1L, 1L, 1L, 0L, 4L, 1L, 1L, 0L, 1L, 0L, 2L, 1L, 2L, 0L, 0L,
    0L, 0L, 2L, 0L, 2L, 1L, 2L, 4L, 3L, 2L, 1L, 1L, 3L, 1L, 1L,
    0L, 2L, 0L, 0L, 0L, 1L, 1L, 1L, 2L, 0L, 1L, 3L, 0L, 1L, 2L,
    1L, 4L, 1L, 2L, 1L, 1L, 1L, 2L, 0L, 2L, 0L, 2L, 1L, 2L, 2L,
    1L, 1L, 3L, 3L, 1L, 3L, 4L, 1L, 2L, 2L, 1L, 4L, 3L, 3L, 1L,
    1L, 0L, 3L, 3L, 2L, 1L, 2L, 2L, 2L, 2L, 3L, 0L, 2L, 1L, 2L,
    2L, 1L, 1L, 0L, 2L, 2L, 2L, 4L, 2L, 2L, 0L, 2L, 0L, 1L, 2L,
    2L, 0L, 2L, 4L, 0L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 0L, 2L, 1L,
    1L, 1L, 1L, 2L, 2L, 1L, 2L, 1L, 0L, 1L, 2L, 2L, 1L, 1L, 1L,
    3L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 0L, 2L, 1L, 2L, 1L, 4L,
    1L, 3L, 2L, 1L, 2L, 2L, 2L, 2L, 1L, 3L, 2L, 1L, 2L, 0L, 1L,
    3L, 1L, 2L, 2L, 2L, 1L, 1L, 4L, 2L, 3L, 1L, 2L, 1L, 4L, 1L,
    1L, 3L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 2L, 2L, 1L,
    1L, 2L, 1L, 1L, 1L, 0L, 1L, 2L, 1L, 2L, 2L, 2L, 2L, 0L, 2L,
    1L, 2L, 0L, 1L, 4L, 2L, 3L, 2L, 1L, 1L, 1L, 1L, 3L, 1L, 1L,
    3L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 4L, 1L, 0L, 0L, 1L, 1L, 1L,
    1L, 0L, 2L, 1L, 1L, 1L, 2L, 2L, 2L, 1L, 1L, 2L, 1L, 2L, 1L,
    1L, 1L, 1L, 2L, 2L, 1L, 0L, 1L, 1L, 2L, 0L, 3L, 2L, 2L, 2L,
    1L, 1L, 4L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 4L,
    2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 2L, 2L, 3L, 0L,
    1L, 2L, 2L, 1L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 1L, 2L, 2L, 1L,
    1L, 0L, 0L, 0L, 0L, 0L, 0L, 2L, 1L, 2L, 0L, 1L, 2L, 1L, 1L,
    1L, 2L, 1L, 1L, 0L, 2L, 2L, 1L, 1L, 1L, 1L, 0L, 1L, 1L, 1L,
    1L, 2L, 2L, 3L, 4L, 1L, 1L, 1L, 2L, 2L, 1L, 2L, 2L, 1L, 2L,
    1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 2L, 2L, 4L, 1L, 1L, 0L,
    2L, 0L, 0L, 1L, 2L, 3L, 2L, 1L, 3L, 1L, 1L, 3L, 3L, 1L, 1L,
    0L, 0L, 0L, 3L, 2L, 1L, 1L, 1L, 0L, 2L, 1L, 2L, 3L, 0L, 0L,
    1L, 2L, 4L, 1L, 1L, 1L, 1L, 1L, 1L, 0L, 1L, 1L, 1L, 4L, 1L,
    1L, 1L, 1L, 1L, 1L, 2L, 0L, 2L, 0L, 0L, 1L, 1L, 0L, 1L, 0L,
    1L, 1L, 0L, 0L, 1L, 0L, 0L, 0L, 1L, 0L, 0L, 4L, 1L, 0L, 0L,
    1L, 0L, 1L, 0L, 1L, 1L, 0L, 0L, 1L, 1L, 1L, 0L, 1L, 2L, 1L,
    2L, 3L, 1L, 0L, 0L, 1L, 1L, 1L, 0L, 0L, 3L, 0L, 2L, 4L, 1L,
    1L, 3L, 3L, 1L, 3L, 3L, 2L, 2L, 3L, 3L, 3L, 3L, 3L, 4L, 3L,
    3L, 2L, 2L, 2L, 2L, 3L, 2L, 1L, 2L, 2L, 2L, 3L, 2L, 4L, 3L,
    1L, 3L, 2L, 2L, 2L, 3L, 0L, 1L, 4L, 2L, 4L, 1L, 3L, 4L, 3L,
    3L, 2L, 3L, 1L, 4L, 3L, 1L, 3L, 2L, 1L, 2L, 1L, 3L, 2L, 2L,
    1L, 2L, 0L, 0L, 1L, 3L, 3L, 4L, 2L, 1L, 1L, 3L, 2L, 3L, 1L,
    3L, 1L, 2L, 1L, 1L, 1L, 3L, 3L, 3L, 2L, 1L, 0L, 2L, 3L, 0L,
    1L, 0L, 1L, 3L, 4L, 2L, 1L, 3L, 2L, 1L, 1L, 2L, 3L, 3L, 1L,
    2L, 1L, 2L, 1L, 1L, 4L, 3L, 1L, 2L, 2L, 2L, 2L, 3L, 2L, 4L,
    3L, 3L, 1L, 1L, 3L, 3L, 3L, 4L, 3L, 3L, 2L, 2L, 2L, 3L, 2L,
    4L, 1L, 2L, 4L, 2L, 1L, 2L, 4L, 3L, 4L, 1L, 4L, 1L, 2L, 1L,
    2L, 4L, 2L, 2L, 4L, 1L, 3L, 4L, 2L, 3L, 2L, 3L, 4L, 3L, 1L,
    1L, 4L, 1L, 3L, 2L, 1L, 2L, 1L, 2L, 4L, 1L, 4L, 4L, 2L, 4L,
    4L, 3L, 4L, 1L, 2L, 2L, 3L, 4L, 4L, 2L, 4L, 3L, 2L, 4L, 3L,
    1L, 2L, 2L, 2L, 2L, 4L, 2L, 2L, 1L, 1L, 4L, 2L, 4L, 2L, 3L,
    2L, 1L, 4L, 3L, 3L, 4L, 1L, 3L, 4L, 3L, 2L, 3L, 2L, 2L, 2L,
    4L, 4L, 2L, 3L, 3L, 2L, 4L, 2L, 2L, 3L, 4L, 3L, 2L, 4L, 3L,
    4L, 2L, 3L, 2L, 4L, 1L, 4L, 3L, 4L, 1L, 2L, 2L, 3L, 4L, 1L,
    1L, 1L, 4L, 3L, 4L, 3L, 3L, 3L, 4L, 2L, 4L, 2L, 3L, 1L, 2L,
    4L, 4L, 4L, 2L, 4L, 2L, 2L, 3L, 3L, 1L, 2L, 2L, 3L, 3L, 2L,
    4L, 2L, 3L, 3L, 2L, 4L, 3L, 4L, 3L, 1L, 3L, 2L, 2L, 2L, 1L,
    4L, 2L, 2L, 2L, 3L, 3L, 1L, 1L, 3L, 3L, 3L, 2L, 1L, 4L, 1L,
    3L, 3L, 4L, 2L, 2L, 3L, 2L, 3L, 3L, 3L, 1L, 2L, 3L, 1L, 2L,
    3L, 2L, 4L, 2L, 2L, 4L, 3L, 2L, 2L, 3L, 1L, 1L, 1L, 2L, 2L,
    1L, 2L, 3L, 4L, 1L, 3L, 4L, 1L, 4L, 4L, 4L, 2L, 1L, 2L, 1L,
    1L, 2L, 2L, 2L, 1L, 3L, 3L, 1L, 1L, 1L, 2L, 2L, 3L, 1L, 3L,
    2L, 1L, 4L, 2L, 3L, 2L, 3L, 3L, 2L, 3L, 1L, 2L, 3L, 3L, 3L,
    4L, 3L, 1L, 0L, 3L, 3L, 1L, 1L, 2L, 4L, 2L, 4L, 3L, 4L, 1L,
    4L, 4L, 2L, 1L, 3L, 2L, 1L, 4L, 4L, 1L, 1L, 2L, 4L, 4L, 4L,
    1L, 1L, 1L, 1L, 0L, 4L, 1L, 4L, 4L, 2L, 2L, 4L, 1L, 4L, 2L,
    2L, 2L, 1L, 4L, 1L, 4L, 1L, 1L, 2L, 0L, 1L, 3L, 1L, 2L, 4L,
    3L, 1L, 3L, 2L, 2L, 3L, 0L, 2L, 1L, 2L, 4L, 1L, 2L, 2L, 2L,
    2L, 4L, 2L, 1L, 1L, 2L, 0L, 1L, 2L, 1L, 3L, 3L, 2L, 4L, 3L,
    2L, 2L, 2L, 0L, 1L, 3L, 3L, 3L, 4L, 4L, 2L, 4L, 4L, 4L, 1L,
    4L, 2L, 3L, 2L, 4L, 1L, 4L, 2L, 1L, 3L, 2L, 3L, 4L, 3L, 4L,
    2L, 2L, 4L, 3L, 0L, 2L, 4L, 1L, 3L, 4L, 2L, 4L, 4L, 2L, 4L,
    3L, 3L, 4L, 4L, 2L, 2L, 4L, 4L, 3L, 4L, 3L, 4L, 2L, 3L, 1L,
    2L, 2L, 4L, 0L, 2L, 3L, 1L, 3L, 1L, 0L, 2L, 4L, 4L, 2L, 1L,
    2L, 3L, 4L, 1L, 1L, 4L, 2L, 3L, 3L, 4L, 2L, 3L, 1L, 3L, 3L,
    1L, 3L, 3L, 1L, 1L, 2L, 0L, 3L, 2L, 0L, 1L, 2L, 1L, 1L, 1L,
    0L, 1L, 1L, 2L, 1L, 3L, 1L, 1L, 1L, 2L, 0L, 4L, 1L, 3L, 1L,
    2L, 4L, 2L, 2L, 3L, 3L, 3L, 4L, 1L, 1L, 4L, 4L, 2L, 3L, 1L,
    1L, 2L, 1L, 1L, 4L, 2L, 1L, 2L, 2L, 1L, 2L, 2L, 1L, 1L, 0L,
    2L, 2L, 1L, 2L, 1L, 1L, 4L, 1L, 3L, 2L, 1L, 2L, 3L, 2L, 1L,
    2L, 1L, 1L, 3L, 0L, 2L, 0L, 2L, 0L, 4L, 1L, 2L, 4L, 0L, 2L,
    2L, 3L, 1L, 2L, 0L, 1L, 4L, 2L, 1L, 1L, 2L, 2L, 3L, 3L, 3L,
    3L, 4L, 1L, 1L, 3L, 1L, 3L, 2L, 2L, 1L, 1L, 3L, 2L, 0L, 3L,
    0L, 1L, 0L, 2L, 3L, 2L, 0L, 2L, 2L, 3L, 3L, 1L, 0L, 1L, 0L,
    0L, 1L, 1L, 0L, 2L, 1L, 1L, 2L, 1L, 2L, 2L, 0L, 1L, 4L, 0L,
    1L, 2L, 2L, 2L, 2L, 0L, 2L, 2L, 1L, 2L, 4L, 1L, 2L, 1L, 1L,
    1L, 1L, 1L, 2L, 2L, 3L, 3L, 3L, 1L, 1L, 2L, 3L, 3L, 2L, 2L,
    3L, 3L, 1L, 2L, 3L, 1L, 2L, 1L, 1L, 0L, 1L, 1L, 2L, 1L, 0L,
    2L, 2L, 0L, 2L, 2L, 2L, 3L, 0L, 0L, 2L, 1L, 2L, 1L, 0L, 2L,
    2L, 2L, 2L, 2L, 3L, 1L, 2L, 0L, 2L, 3L, 2L, 1L, 2L, 2L, 1L,
    1L, 2L, 4L, 0L, 1L, 1L, 2L, 3L, 2L, 1L, 3L, 2L, 1L, 1L, 2L,
    3L, 1L, 2L, 4L, 4L, 1L, 2L, 3L, 2L, 3L, 1L, 0L, 1L, 2L, 1L,
    1L, 1L, 2L, 2L, 3L, 3L, 1L, 2L, 0L, 4L, 1L, 1L, 0L, 4L, 1L,
    2L, 1L, 2L, 2L, 0L, 3L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 2L, 3L,
    3L, 2L, 2L, 0L, 3L, 3L, 4L, 2L, 2L, 0L, 3L, 1L, 2L, 1L, 0L,
    1L, 3L, 0L, 2L, 2L, 1L, 1L, 1L, 3L, 1L, 2L, 2L, 2L, 2L, 4L,
    4L, 2L, 2L, 1L, 2L, 1L, 1L, 2L, 0L, 0L, 2L, 2L, 1L, 0L, 2L,
    0L, 1L, 3L, 1L, 2L, 3L, 1L, 2L, 4L, 1L, 1L, 2L, 4L, 2L, 1L,
    2L, 4L, 4L, 1L, 4L, 2L, 3L, 3L, 2L, 2L, 0L, 2L, 3L, 2L, 1L,
    0L, 2L, 0L, 2L, 1L, 0L, 1L, 2L, 3L, 0L, 0L, 0L, 3L, 1L, 0L,
    1L, 2L, 4L, 0L, 0L, 2L, 1L, 1L, 0L, 3L, 0L, 3L, 1L, 1L, 2L,
    0L, 3L, 2L, 2L, 2L, 4L, 2L, 3L, 1L, 0L, 1L, 2L, 2L, 1L, 1L,
    2L, 2L, 1L, 2L, 1L, 2L, 0L, 1L, 2L, 2L, 1L, 1L, 4L, 2L, 2L,
    2L, 0L, 2L, 2L, 2L, 1L, 1L, 2L, 2L, 3L, 1L, 3L, 3L, 3L, 2L,
    1L, 1L, 1L, 2L, 1L, 0L, 2L, 2L, 2L, 1L, 1L, 3L, 2L, 1L, 1L,
    2L, 1L, 2L, 1L, 3L, 3L, 2L, 0L, 3L, 3L, 1L, 0L, 4L, 3L, 3L,
    2L, 0L, 2L, 1L, 3L, 0L, 2L, 2L, 3L, 4L, 1L, 3L, 3L, 2L, 0L,
    1L, 1L, 0L, 1L, 2L, 1L, 3L, 1L, 1L, 1L, 0L, 0L, 0L, 2L, 0L,
    1L, 0L, 2L, 2L, 2L, 0L, 2L, 1L, 3L, 4L, 4L, 0L, 2L, 1L, 2L,
    3L, 0L, 1L, 1L, 1L, 0L, 1L, 0L, 0L, 1L, 2L, 0L, 3L, 2L, 2L,
    1L, 2L, 2L, 3L, 0L, 2L, 1L, 2L, 4L, 1L, 1L, 1L, 0L, 3L, 3L,
    2L, 3L, 2L, 3L, 2L, 2L, 4L, 1L, 0L, 3L, 2L, 1L, 2L, 1L, 2L,
    2L, 1L, 3L, 2L, 3L, 2L, 1L, 4L, 2L, 3L, 2L, 2L, 2L, 3L, 1L,
    0L, 2L, 0L, 1L, 0L, 2L, 1L, 3L, 2L, 1L, 4L, 0L, 2L, 1L, 3L,
    3L, 2L, 0L, 1L, 1L, 0L, 2L, 3L, 0L, 0L, 1L, 3L, 4L, 2L, 0L,
    2L, 2L, 2L, 1L, 1L, 0L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 2L, 2L,
    0L, 1L, 1L, 3L, 2L, 2L, 0L, 0L, 2L, 4L, 1L, 1L, 0L, 0L, 1L,
    4L, 1L, 2L, 2L, 0L, 1L, 1L, 1L, 2L, 2L, 4L, 0L, 4L, 0L, 1L,
    0L, 4L, 0L, 3L, 0L, 3L, 3L, 1L, 3L, 0L, 0L, 3L, 0L, 0L, 0L,
    2L, 0L, 1L, 0L, 1L, 2L, 2L, 0L, 2L, 0L, 3L, 0L, 3L, 4L, 1L,
    4L, 1L, 3L, 2L, 2L, 3L, 4L, 3L, 2L, 0L, 0L, 3L, 4L, 2L, 3L,
    3L, 0L, 4L, 3L, 4L, 3L, 3L, 2L, 3L, 2L, 2L, 2L, 2L, 0L, 3L,
    3L, 0L, 0L, 3L, 1L, 4L, 1L, 0L, 4L, 3L, 1L, 3L, 3L, 1L, 4L,
    2L, 2L, 3L, 0L, 1L, 2L, 3L, 3L, 0L, 4L, 3L, 1L, 3L, 0L, 3L,
    0L, 3L, 1L, 2L, 1L, 1L, 1L, 2L, 3L, 0L, 3L, 3L, 0L, 3L, 3L,
    0L, 1L, 1L, 0L, 0L, 1L, 2L, 2L, 0L, 3L, 1L, 2L, 1L, 0L, 0L,
    1L, 3L, 2L, 2L, 4L, 0L, 3L, 0L, 2L, 3L, 2L, 2L, 0L, 0L, 3L,
    1L, 0L, 3L, 3L, 2L, 0L, 0L, 3L, 2L, 1L, 3L, 0L, 2L, 4L, 1L,
    3L, 4L, 0L, 0L, 1L, 2L, 0L, 2L, 1L, 1L, 0L, 3L, 0L, 3L, 3L,
    4L, 0L, 2L, 2L, 2L, 0L, 4L, 3L, 2L, 3L, 1L, 1L, 3L, 1L, 0L,
    3L, 2L, 1L, 2L, 3L, 1L, 1L, 2L, 1L, 1L, 0L, 3L, 0L, 0L, 0L,
    1L, 1L, 0L, 1L, 2L, 3L, 1L, 3L, 2L, 4L, 3L, 2L, 0L, 0L, 0L,
    4L, 1L, 3L, 3L, 3L, 1L, 1L, 2L, 1L, 2L, 2L, 2L, 1L, 0L, 0L,
    2L, 1L, 0L, 1L, 0L, 2L, 2L, 0L, 1L, 2L, 1L, 1L, 1L, 0L, 1L,
    2L, 1L, 3L, 3L, 2L, 0L, 2L, 1L, 1L, 3L, 1L, 4L, 0L, 2L, 2L,
    1L, 2L, 3L, 0L, 3L, 3L, 3L, 3L, 3L, 0L, 3L, 0L, 3L, 3L, 0L,
    3L, 0L, 3L, 2L, 4L, 4L, 1L, 3L, 0L, 0L, 3L, 4L, 2L, 1L, 3L,
    0L, 2L, 2L, 0L, 2L, 4L, 2L, 4L, 4L, 3L, 3L, 0L, 3L, 2L, 4L,
    3L, 4L, 4L, 3L, 4L, 2L, 0L, 3L, 3L, 3L, 3L, 3L, 2L, 4L, 0L,
    1L, 1L, 1L, 3L, 0L, 3L, 1L, 3L, 3L, 2L, 2L, 2L, 0L, 0L, 3L,
    0L, 2L, 0L, 3L, 2L, 2L, 0L, 3L, 3L, 0L, 3L, 1L, 3L, 4L, 3L,
    4L, 3L, 4L, 4L, 4L, 4L, 0L, 0L, 3L, 0L, 2L, 3L, 3L, 0L, 0L,
    2L, 0L, 4L, 3L, 3L, 3L, 0L, 0L, 0L, 1L, 0L, 0L, 1L, 3L, 3L,
    0L, 2L, 3L, 2L, 4L, 4L, 0L, 0L, 2L, 0L, 0L, 0L, 1L, 3L, 3L,
    0L, 4L, 0L, 4L, 1L, 3L, 1L, 2L, 1L, 4L, 2L, 3L, 3L, 4L, 4L,
    4L, 0L, 3L, 4L, 4L, 2L, 3L, 2L, 4L, 3L, 4L, 4L, 0L, 0L, 1L,
    4L, 0L, 4L, 1L, 3L, 3L, 3L, 3L, 3L, 4L, 3L, 3L, 3L, 4L, 4L,
    3L, 3L, 0L, 2L, 3L, 1L, 2L, 0L, 0L, 3L, 0L, 4L, 4L, 3L, 1L,
    4L, 1L, 4L, 0L, 0L, 3L, 0L, 3L, 2L, 3L, 2L, 3L, 0L, 3L, 4L,
    1L, 2L, 1L, 3L, 3L, 2L, 0L, 1L, 3L, 0L, 2L, 2L, 0L, 1L, 0L,
    0L, 0L, 3L, 3L, 0L, 3L, 3L, 0L, 4L, 2L, 0L, 2L, 0L, 4L, 0L,
    4L, 0L, 4L, 2L, 2L, 4L, 0L, 0L, 1L, 4L, 0L, 1L, 1L, 2L, 2L,
    3L, 0L, 3L, 1L, 0L, 3L, 3L, 0L, 3L, 4L, 2L, 1L, 2L, 1L, 0L,
    4L, 0L, 2L, 0L, 0L, 3L, 0L, 3L, 3L, 2L, 2L, 4L, 0L, 0L, 1L,
    2L, 0L, 2L, 3L, 3L, 0L, 4L, 0L, 0L, 0L, 4L, 3L, 4L, 4L, 4L,
    4L, 2L, 1L, 0L, 3L, 2L, 3L, 4L, 4L, 4L, 4L, 0L, 4L, 3L, 0L,
    0L, 2L, 2L, 3L, 2L, 0L, 3L, 3L, 3L, 4L, 3L, 0L, 0L, 3L, 3L,
    1L, 0L, 4L, 0L, 0L, 3L, 1L, 2L, 4L, 0L, 4L, 3L, 1L, 2L, 3L,
    1L, 3L, 0L, 2L, 4L, 4L, 3L, 1L, 3L, 0L, 3L, 4L, 2L, 0L, 0L,
    1L, 4L, 1L, 0L, 4L, 0L, 4L, 3L, 0L, 3L, 1L, 1L, 4L, 0L, 4L,
    1L, 4L, 0L, 4L, 0L, 1L, 3L, 2L, 0L, 3L, 3L, 1L, 3L, 3L, 4L,
    0L, 1L, 0L, 3L, 1L, 3L, 2L, 0L, 1L, 2L, 0L, 3L, 4L, 0L, 2L,
    1L, 2L, 0L, 4L, 3L, 4L, 3L, 3L, 1L, 3L, 3L, 3L, 3L, 2L, 3L,
    2L, 2L, 0L, 0L, 2L, 0L, 3L, 3L, 2L, 3L, 1L, 2L, 1L, 1L, 2L,
    3L, 4L, 3L, 0L, 1L, 4L, 3L, 2L, 4L, 0L, 0L, 3L, 4L, 0L, 2L,
    2L, 3L, 4L, 3L, 0L, 3L, 0L, 3L, 0L, 4L, 4L, 1L, 4L, 1L, 3L,
    4L, 2L, 3L, 3L, 3L, 0L, 2L, 2L, 3L, 1L, 4L, 2L, 0L, 0L, 4L,
    3L, 3L, 3L, 3L, 4L, 2L, 0L, 2L, 1L, 0L, 3L, 4L, 3L, 3L, 0L,
    3L, 3L, 0L, 0L, 2L, 0L, 2L, 0L, 1L, 4L, 3L, 0L, 4L, 3L, 0L,
    1L, 3L, 1L, 2L, 3L, 4L, 1L, 0L, 4L, 4L, 1L, 4L, 0L, 3L, 4L,
    4L, 3L, 3L, 2L, 3L, 2L, 1L, 3L, 0L, 1L, 1L, 3L, 3L, 1L, 0L,
    3L, 1L, 1L, 3L, 1L, 1L, 2L, 3L, 2L, 0L, 2L, 3L, 0L, 1L, 0L,
    0L, 1L, 2L, 2L, 0L, 4L, 0L, 3L, 3L, 0L, 2L, 4L, 3L, 0L, 0L,
    3L, 3L, 4L, 0L, 1L, 0L, 3L, 0L, 0L, 3L, 0L, 1L, 3L, 3L, 3L,
    1L, 4L, 1L, 2L, 0L, 3L, 1L, 3L, 1L, 0L, 2L, 0L, 4L, 1L, 0L,
    4L, 4L, 3L, 3L, 4L, 2L, 2L, 0L, 4L, 1L, 2L, 4L, 0L, 4L, 4L,
    0L, 0L, 3L, 4L, 3L, 3L, 2L, 3L, 0L, 2L, 4L, 3L, 4L, 3L, 3L,
    3L, 4L, 0L, 2L, 3L, 4L, 4L, 2L, 0L, 4L, 0L, 2L, 4L, 0L, 1L,
    3L, 1L, 1L, 1L, 0L, 4L, 4L, 3L, 0L, 3L, 1L, 1L, 2L, 0L, 0L,
    4L, 0L, 3L, 3L, 0L, 2L, 0L, 1L, 0L, 3L, 3L, 4L, 0L, 0L, 0L,
    4L, 0L, 3L, 1L, 0L, 0L, 3L, 4L, 0L, 3L, 1L, 3L, 2L, 2L, 0L,
    2L, 3L, 0L, 2L, 4L, 1L, 3L, 0L, 0L, 3L, 1L, 3L, 3L, 3L, 4L,
    3L, 2L, 2L, 3L, 4L, 3L, 1L, 3L, 0L, 4L, 3L, 0L, 0L, 3L, 4L,
    0L, 4L, 0L, 4L, 1L, 3L, 1L, 0L, 4L, 3L, 1L, 0L, 1L, 0L, 3L,
    3L, 0L, 0L, 3L, 1L, 2L, 3L, 3L, 4L, 0L, 3L, 1L, 1L, 4L, 0L,
    2L, 0L, 0L, 3L, 3L, 1L, 0L, 3L, 3L, 0L, 0L, 1L, 0L, 2L, 0L,
    2L, 0L, 1L, 2L, 0L, 2L, 4L, 1L, 0L, 1L, 1L, 0L, 1L, 3L, 4L,
    0L, 1L, 3L, 4L, 0L, 3L, 1L, 2L, 2L, 0L, 4L, 3L, 2L, 3L, 1L,
    0L, 0L, 2L, 4L, 0L, 2L, 2L, 4L, 1L, 1L, 3L, 4L, 1L, 1L, 0L,
    2L, 1L, 0L, 3L, 0L, 0L, 1L, 2L, 4L, 3L, 3L, 0L, 0L, 2L, 4L,
    0L, 3L, 3L, 3L, 3L, 4L, 2L, 2L, 1L, 3L, 0L, 3L, 4L, 4L, 3L,
    3L, 3L, 1L, 2L, 2L, 0L, 0L, 1L, 2L, 2L, 3L, 4L, 0L, 1L, 1L,
    4L, 2L, 1L, 2L, 1L, 1L, 1L, 3L, 4L, 1L, 0L, 0L, 0L, 3L, 4L,
    0L, 1L, 3L, 3L, 0L, 3L, 0L, 0L, 2L, 0L, 0L, 3L, 4L, 0L, 2L,
    1L, 0L, 1L, 2L, 2L, 4L, 1L, 2L, 4L, 0L, 0L, 4L, 4L, 2L, 4L,
    4L, 4L, 3L, 4L, 3L, 2L, 0L, 2L, 3L, 2L, 0L, 3L, 4L, 1L, 1L,
    3L, 0L, 3L, 4L, 4L, 4L, 2L, 0L, 1L, 4L, 4L, 1L, 4L, 0L, 0L,
    4L, 0L, 3L, 1L, 2L, 3L, 4L, 4L, 3L, 3L, 0L, 2L, 0L, 2L, 2L,
    1L, 3L, 2L, 0L, 3L, 0L, 0L, 3L, 3L, 3L, 3L, 4L, 0L, 3L, 0L,
    0L, 2L, 3L, 3L, 2L, 3L, 2L, 0L, 0L, 0L, 0L, 2L, 3L, 2L, 2L,
    3L, 0L, 0L, 0L, 3L, 1L, 0L, 1L, 2L, 3L, 2L, 1L, 4L, 3L, 1L,
    0L, 4L, 4L, 3L, 1L, 0L, 3L, 3L, 0L, 2L, 3L, 1L, 4L, 2L, 3L,
    2L, 4L, 2L, 0L, 0L, 3L, 3L, 2L, 3L, 0L, 0L, 1L, 1L, 4L, 3L,
    3L, 0L, 3L, 2L, 1L, 3L, 0L, 2L, 1L, 1L, 0L, 2L, 0L, 2L, 0L,
    0L, 1L, 2L, 3L, 4L, 0L, 4L, 3L, 2L, 0L, 0L, 3L, 1L, 4L, 3L,
    0L, 0L, 0L, 3L, 0L, 3L, 0L, 0L, 3L, 2L, 1L, 0L, 3L, 0L, 0L,
    2L, 0L, 1L, 3L, 2L, 3L, 0L, 2L, 0L, 0L, 1L, 2L, 4L, 0L, 2L,
    0L, 0L, 0L, 3L, 0L, 4L, 3L, 1L, 0L, 3L, 0L, 4L, 2L, 3L, 1L,
    2L, 0L, 4L, 1L, 3L, 4L, 0L, 1L, 3L, 3L, 1L, 3L, 1L, 1L, 0L,
    3L, 0L, 1L, 3L, 0L, 4L, 0L, 0L, 2L, 1L, 3L, 3L, 2L, 0L, 3L,
    0L, 2L, 2L, 0L, 2L, 2L, 3L, 4L, 1L, 3L, 0L, 3L, 2L, 3L, 0L,
    4L, 3L, 0L, 1L, 1L, 3L, 3L, 4L, 0L, 2L, 0L, 0L, 0L, 1L, 1L,
    1L, 2L, 3L, 0L, 0L, 1L, 1L, 0L, 2L, 2L, 2L, 3L, 2L, 4L, 1L,
    1L, 2L, 1L, 3L, 0L, 0L, 4L, 4L, 4L, 4L, 1L, 0L, 0L, 4L, 0L,
    2L, 4L, 1L, 0L, 3L, 4L, 2L, 3L, 2L, 3L, 4L, 1L, 2L, 3L, 1L,
    3L, 3L, 0L, 0L, 2L, 3L, 0L, 3L, 0L, 3L, 1L, 3L, 4L, 0L, 1L,
    3L, 0L, 1L, 0L, 0L, 2L, 2L, 4L, 3L, 1L, 1L, 0L, 4L, 0L, 0L,
    4L, 4L, 4L, 2L, 0L, 1L, 3L, 4L, 3L, 4L, 1L, 4L, 0L, 3L, 4L,
    2L, 2L, 3L, 0L, 0L, 0L, 2L, 3L, 2L, 4L, 0L, 0L, 1L, 3L, 4L,
    0L, 2L, 0L, 2L, 0L, 4L, 1L, 3L, 3L, 0L, 3L, 0L, 3L, 4L, 0L,
    1L, 4L, 0L, 0L, 0L, 0L, 0L, 0L, 4L, 3L, 2L, 2L, 0L, 3L, 4L,
    2L, 3L, 1L, 1L, 1L, 3L, 0L, 3L, 2L, 3L, 1L, 1L, 1L, 3L, 0L,
    0L, 3L, 0L, 0L, 3L, 3L, 1L, 4L, 1L, 1L, 1L, 1L, 0L, 4L, 4L,
    4L, 0L, 0L, 0L, 0L, 1L, 1L, 3L, 3L, 4L, 4L, 1L, 4L, 3L, 3L,
    0L, 0L, 3L, 2L, 3L, 4L, 4L, 3L, 0L, 3L, 1L, 2L, 4L, 0L, 0L,
    4L, 0L, 0L, 4L, 3L, 0L, 0L, 4L, 2L, 1L, 3L, 3L, 1L, 0L, 0L,
    0L, 3L, 1L, 4L, 0L, 0L, 2L, 2L, 3L, 0L, 0L, 1L, 0L, 2L, 0L,
    0L, 0L, 4L, 0L, 0L, 0L, 0L, 4L, 1L, 2L, 3L, 3L, 1L, 1L, 2L,
    4L, 3L, 1L, 1L, 2L, 2L, 3L, 3L, 4L, 3L, 3L, 0L, 1L, 3L, 0L,
    0L, 4L, 0L, 4L, 3L, 4L, 1L, 0L, 0L, 1L, 2L, 2L, 3L, 3L, 2L,
    3L, 0L, 4L, 0L, 1L, 2L, 3L, 1L, 0L, 0L, 2L, 4L, 4L, 2L, 0L,
    0L, 0L, 1L, 2L, 2L, 0L, 4L, 3L, 2L, 0L, 0L, 0L, 0L, 1L, 2L,
    3L, 3L, 1L, 4L, 0L, 2L, 0L, 0L, 1L, 3L, 4L, 0L, 2L, 1L, 4L,
    1L, 1L, 4L, 3L, 4L, 3L, 3L, 3L, 1L, 3L, 3L, 0L, 1L, 3L, 0L,
    3L, 2L, 4L, 4L, 0L, 4L, 2L, 3L, 3L, 4L, 1L, 3L, 2L, 4L, 0L,
    0L, 0L, 3L, 3L, 2L, 1L, 1L, 0L, 0L, 1L, 3L, 1L, 1L, 1L, 0L,
    2L, 2L, 3L, 3L, 1L, 0L, 2L, 2L, 1L, 3L, 1L, 1L, 0L, 4L, 3L,
    0L, 4L, 3L, 1L, 0L, 4L, 0L, 2L, 0L, 0L, 0L, 2L, 1L, 0L, 4L,
    0L, 3L, 2L, 1L, 0L, 4L, 3L, 0L, 3L, 2L, 4L, 3L, 3L, 2L, 3L,
    1L, 4L, 2L, 0L, 2L, 3L, 0L, 4L, 2L, 3L, 3L, 2L, 0L, 4L, 2L,
    4L, 3L, 1L, 3L, 1L, 2L, 1L, 3L, 3L, 3L, 0L, 3L, 0L, 1L, 4L,
    4L, 2L, 2L, 1L, 3L, 1L, 4L, 3L, 0L, 2L, 3L, 0L, 3L, 1L, 0L,
    3L, 3L, 0L, 0L, 3L, 1L, 4L, 0L, 1L, 0L, 0L, 1L, 1L, 2L, 0L,
    0L, 0L, 3L, 4L, 4L, 2L, 4L, 1L, 4L, 2L, 3L, 3L, 0L, 1L, 3L,
    4L, 0L, 3L, 3L, 1L, 0L, 1L, 1L, 3L, 1L, 0L, 3L, 1L, 0L, 3L,
    4L, 0L, 0L, 0L, 2L, 2L, 0L, 0L, 2L, 0L, 2L, 4L, 1L, 1L, 0L,
    2L, 3L, 3L, 0L, 3L, 0L, 0L, 4L, 0L, 0L, 4L, 1L, 2L, 2L, 2L,
    0L, 4L, 3L, 0L, 3L, 0L, 0L, 0L, 4L, 0L, 2L, 3L, 1L, 2L, 3L,
    4L, 3L, 2L, 3L, 3L, 2L, 2L, 1L, 3L, 1L, 0L, 0L, 2L, 3L, 1L,
    3L, 2L, 3L, 0L, 3L, 3L, 1L, 2L, 3L, 0L, 3L, 3L, 4L, 0L, 0L,
    3L, 1L, 4L, 3L, 0L, 1L, 3L, 2L, 3L, 3L, 0L, 1L, 4L, 3L, 1L,
    1L, 1L, 3L, 4L, 2L, 3L, 4L, 2L, 3L, 3L, 1L, 0L, 0L, 3L, 2L,
    4L, 0L, 0L, 0L, 3L, 3L, 4L, 4L, 3L, 2L, 1L, 0L, 3L, 1L, 0L,
    4L, 3L, 1L, 0L, 2L, 0L, 2L, 0L, 0L, 4L, 0L, 0L, 2L, 0L, 0L,
    0L, 0L, 3L, 0L, 4L, 3L, 3L, 4L, 3L, 3L, 2L, 1L, 0L, 3L, 4L,
    3L, 0L, 3L, 1L, 0L, 1L, 0L, 0L, 3L, 0L, 0L, 2L, 3L, 1L, 1L,
    2L, 1L, 0L, 2L, 4L, 1L, 4L, 1L, 4L, 2L, 0L, 3L, 1L, 4L, 3L,
    3L, 2L, 2L, 0L, 4L, 2L, 4L, 4L, 2L, 1L, 3L, 4L, 0L, 0L, 2L,
    2L, 2L, 3L, 0L, 0L, 2L, 3L, 4L, 0L, 0L, 1L, 0L, 0L, 0L, 3L,
    3L, 0L, 1L, 3L, 3L, 1L, 0L, 1L, 3L, 2L, 4L, 3L, 0L, 4L, 4L,
    4L, 4L, 3L, 3L, 0L, 0L, 0L, 3L, 0L, 2L, 1L, 3L, 2L, 2L, 1L,
    3L, 1L, 2L, 1L, 1L, 0L, 0L, 0L, 3L, 4L, 2L, 2L, 3L, 2L, 2L,
    0L, 2L, 1L, 3L, 0L, 2L, 3L, 0L, 0L, 3L, 1L, 3L, 3L, 3L, 0L,
    3L, 3L, 3L, 0L, 0L, 4L, 3L, 0L, 2L, 3L, 3L, 4L, 2L, 4L, 0L,
    2L, 3L, 0L, 2L, 3L, 0L, 3L, 0L, 0L, 3L, 0L, 1L, 3L, 2L, 2L,
    2L, 2L, 0L, 0L, 1L, 1L, 0L, 2L, 2L, 0L, 3L, 0L, 2L, 0L, 1L,
    4L, 0L, 4L, 2L, 4L, 4L, 1L, 3L, 3L, 4L, 4L, 0L, 3L, 3L, 3L,
    3L, 0L, 3L, 3L, 3L, 0L, 2L, 1L, 0L, 1L, 0L, 1L, 4L, 3L, 2L,
    2L, 0L, 0L, 2L, 1L, 0L, 1L, 3L, 4L, 4L, 3L, 3L, 0L, 3L, 2L,
    1L, 1L, 1L, 0L, 4L, 2L, 0L, 4L, 4L, 4L, 1L, 3L, 4L, 3L, 2L,
    4L, 2L, 2L, 0L, 2L, 1L, 3L, 1L, 0L, 2L, 3L, 2L, 2L, 3L, 1L,
    3L, 0L, 0L, 0L, 4L, 2L, 0L, 0L, 0L, 2L, 3L, 4L, 4L, 3L, 0L,
    0L, 2L, 4L, 3L, 3L, 2L, 3L, 2L, 4L, 0L, 0L, 3L, 0L, 3L, 3L,
    2L, 3L, 2L, 2L, 2L, 2L, 0L, 2L, 3L, 3L, 1L, 0L, 3L, 0L, 2L,
    3L, 1L, 4L, 2L, 0L, 4L, 3L, 3L, 4L, 4L, 4L, 4L, 3L, 0L, 3L,
    0L, 0L, 1L, 2L, 0L, 4L, 1L, 3L, 3L, 2L, 4L, 0L, 0L, 1L, 1L,
    0L, 3L, 4L, 4L, 3L, 0L, 4L, 2L, 3L, 1L, 1L, 2L, 3L, 0L, 2L,
    2L, 3L, 0L, 3L, 0L, 4L, 2L, 3L, 1L, 3L, 3L, 4L, 3L, 0L, 2L,
    1L, 0L, 1L, 0L, 3L, 1L, 2L, 3L, 1L, 1L, 3L, 1L, 3L, 0L, 0L,
    2L, 1L, 0L, 3L, 4L, 4L, 1L, 1L, 2L, 0L, 3L, 3L, 3L, 2L, 1L,
    0L, 0L, 0L, 0L, 3L, 3L, 2L, 0L, 3L, 3L, 2L, 1L, 1L, 1L, 3L,
    2L, 3L, 0L, 3L, 0L, 3L, 4L, 2L, 1L, 4L, 0L, 4L, 2L, 3L, 0L,
    3L, 4L, 2L, 3L, 4L, 4L, 2L, 4L, 3L, 4L, 2L, 4L, 2L, 3L, 4L,
    1L, 1L, 4L, 0L, 0L, 4L, 2L, 0L, 3L, 3L, 3L, 2L, 4L, 4L, 0L,
    3L, 0L, 3L, 2L, 4L, 1L, 2L, 3L, 1L, 0L, 4L, 0L, 4L, 0L, 0L,
    3L, 1L, 1L, 2L, 0L, 3L, 2L, 0L, 0L, 1L, 0L, 0L, 3L, 1L, 1L,
    2L, 0L, 2L, 0L, 3L, 3L, 1L, 2L, 1L, 1L, 1L, 2L, 4L, 0L, 1L,
    0L, 1L, 0L, 0L, 2L, 2L, 0L, 2L, 0L, 1L, 1L, 0L, 4L, 0L, 0L,
    0L, 0L, 0L, 1L, 1L, 0L, 3L, 1L, 1L, 2L, 0L, 0L, 2L, 0L, 2L,
    0L, 2L, 1L, 1L, 2L, 0L, 2L, 2L, 4L, 0L, 0L, 1L, 3L, 1L, 3L,
    2L, 2L, 1L, 1L, 4L, 1L, 1L, 1L, 0L, 1L, 2L, 4L, 3L, 2L, 3L,
    0L, 2L, 1L, 1L, 1L, 0L, 4L, 1L, 1L, 2L, 1L, 2L, 1L, 4L, 2L,
    3L, 1L, 0L, 1L, 0L, 3L, 2L, 0L, 1L, 2L, 4L, 4L, 3L, 0L, 2L,
    1L, 0L, 2L, 1L, 0L, 2L, 2L, 1L, 0L, 2L, 2L, 2L, 0L, 1L, 2L,
    1L, 1L, 4L, 2L, 1L, 1L, 1L, 1L, 1L, 3L, 0L, 1L, 1L, 2L, 0L,
    0L, 0L, 1L, 1L, 2L, 0L, 0L, 3L, 1L, 1L, 3L, 2L, 4L, 3L, 0L,
    4L, 3L, 1L, 0L, 0L, 2L, 1L, 0L, 0L, 2L, 0L, 2L, 4L, 0L, 2L,
    3L, 4L, 2L, 3L, 1L, 0L, 4L, 4L, 0L, 0L, 2L, 2L, 0L, 3L, 4L,
    2L, 4L, 0L, 1L, 1L, 3L, 1L, 2L, 0L, 3L, 1L, 2L, 1L, 0L, 3L,
    2L, 4L, 2L, 4L, 1L, 2L, 3L, 1L, 4L, 1L, 2L, 1L, 1L, 0L, 2L,
    2L, 3L, 0L, 4L, 1L, 3L, 1L, 2L, 0L, 0L, 4L, 1L, 2L, 4L, 1L,
    0L, 1L, 2L, 0L, 1L, 0L, 1L, 1L, 1L, 2L, 1L, 4L, 0L, 1L, 2L,
    3L, 1L, 4L, 1L, 1L, 0L, 0L, 1L, 2L, 0L, 4L, 0L, 2L, 2L, 0L,
    4L, 1L, 1L, 1L, 4L, 0L, 3L, 3L, 1L, 1L, 1L, 0L, 4L, 3L, 0L,
    3L, 0L, 3L, 0L, 2L, 1L, 0L, 2L, 2L, 1L, 0L, 3L, 0L, 4L, 2L,
    2L, 2L, 1L, 2L, 2L, 0L, 2L, 0L, 0L, 2L, 0L, 2L, 0L, 3L, 3L,
    0L, 0L, 1L, 4L, 0L, 3L, 0L, 3L, 0L, 0L, 2L, 0L, 1L, 0L, 2L,
    1L, 0L, 3L, 1L, 0L, 0L, 1L, 0L, 2L, 0L, 4L, 1L, 2L, 0L, 1L,
    3L, 0L, 0L, 1L, 2L, 3L, 4L, 0L, 0L, 1L, 3L, 2L, 1L, 4L, 3L,
    1L, 2L, 3L, 2L, 4L, 2L, 2L, 4L, 0L, 2L, 1L, 0L, 3L, 0L, 2L,
    2L, 1L, 1L, 0L, 3L, 4L, 2L, 0L, 1L, 3L, 4L, 0L, 2L, 2L, 1L,
    1L, 0L, 0L, 4L, 1L, 0L, 0L, 1L, 2L, 1L, 1L, 4L, 3L, 0L, 1L,
    1L, 1L, 0L, 2L, 2L, 0L, 2L, 1L, 4L, 1L, 3L, 1L, 1L, 0L, 1L,
    1L, 4L, 0L, 4L, 1L, 0L, 0L, 1L, 2L, 2L, 2L, 2L, 1L, 1L, 0L,
    2L, 2L, 0L, 0L, 4L, 4L, 1L, 0L, 0L, 1L, 4L, 1L, 3L, 0L, 4L,
    0L, 2L, 1L, 1L, 2L, 1L, 1L, 2L, 2L, 4L, 1L, 4L, 2L, 1L, 1L,
    4L, 1L, 1L, 4L, 2L, 0L, 3L, 0L, 1L, 0L, 0L, 1L, 3L, 2L, 0L,
    0L, 3L, 3L, 0L, 1L, 1L, 4L, 3L, 4L, 2L, 0L, 0L, 2L, 2L, 1L,
    1L, 4L, 0L, 2L, 2L, 1L, 2L, 3L, 0L, 0L, 4L, 2L, 2L, 3L, 3L,
    1L, 2L, 3L, 3L, 1L, 0L, 1L, 1L, 2L, 3L, 0L, 4L, 0L, 1L, 1L,
    0L, 1L, 1L, 2L, 3L, 2L, 1L, 1L, 0L, 2L, 1L, 2L, 2L, 0L, 0L,
    2L, 2L, 0L, 2L, 3L, 1L, 1L, 0L, 1L, 0L, 0L, 0L, 0L, 3L, 0L,
    4L, 0L, 0L, 1L, 0L, 0L, 1L, 3L, 0L, 2L, 3L, 3L, 0L, 1L, 0L,
    0L, 0L, 3L, 0L, 1L, 0L, 2L, 0L, 0L, 3L, 1L, 0L, 2L, 2L, 2L,
    3L, 1L, 3L, 4L, 4L, 0L, 3L, 0L, 1L, 2L, 2L, 0L, 3L, 3L, 2L,
    2L, 0L, 4L, 0L, 2L, 0L, 2L, 1L, 3L, 0L, 0L, 0L, 0L, 2L, 0L,
    2L, 2L, 3L, 3L, 1L, 1L, 1L, 2L, 3L, 3L, 1L, 0L, 3L, 2L, 4L,
    3L, 0L, 2L, 3L, 3L, 2L, 1L, 0L, 0L, 0L, 2L, 1L, 3L, 2L, 0L,
    2L, 1L, 0L, 1L, 2L, 3L, 0L, 2L, 2L, 0L, 3L, 2L, 3L, 2L, 4L,
    2L, 0L, 2L, 0L, 0L, 1L, 2L, 1L, 4L, 1L, 0L, 2L, 0L, 2L, 0L,
    2L, 0L, 3L, 1L, 2L, 4L, 4L, 0L, 4L, 2L, 0L, 3L, 0L, 0L, 0L,
    2L, 0L, 4L, 3L, 3L, 0L, 2L, 2L, 2L, 0L, 1L, 2L, 1L, 2L, 0L,
    0L, 1L, 3L, 3L, 1L, 1L, 0L, 0L, 4L, 0L, 3L, 0L, 1L, 2L, 0L,
    0L, 2L, 2L, 2L, 2L, 2L, 3L, 2L, 1L, 1L, 0L, 0L, 2L, 0L, 1L,
    1L, 1L, 0L, 1L, 0L, 1L, 2L, 0L, 1L, 2L, 0L, 2L, 0L, 1L, 2L,
    2L, 2L, 0L, 3L, 2L, 3L, 0L, 0L, 1L, 2L, 1L, 3L, 4L, 4L, 0L,
    0L, 4L, 0L, 1L, 1L, 1L, 2L, 1L, 3L, 4L, 2L, 0L, 3L, 1L, 1L,
    1L, 0L, 2L, 2L, 0L, 4L, 0L, 3L, 0L, 0L, 3L, 4L, 2L, 0L, 2L,
    1L, 2L, 0L, 3L, 2L, 2L, 2L, 0L, 3L, 0L, 2L, 2L, 0L, 1L, 1L,
    0L, 2L, 1L, 2L, 0L, 2L, 0L, 1L, 2L, 1L, 1L, 0L, 2L, 2L, 2L,
    0L, 0L, 2L, 2L, 2L, 0L, 4L, 1L, 3L, 1L, 1L, 4L, 2L, 3L, 3L,
    1L, 1L, 1L, 2L, 0L, 3L, 2L, 3L, 3L, 0L, 2L, 1L, 2L, 1L, 0L,
    0L, 3L, 2L, 3L, 2L, 3L, 2L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 2L,
    2L, 3L, 0L, 0L, 2L, 2L, 0L, 1L, 0L, 2L, 1L, 4L, 1L, 0L, 0L,
    2L, 0L, 3L, 2L, 2L, 0L, 2L, 2L, 3L, 3L, 3L, 4L, 0L, 1L, 1L,
    3L, 4L, 2L, 4L, 2L, 2L, 1L, 3L, 2L, 1L, 2L, 2L, 1L, 3L, 1L,
    1L, 3L, 2L, 2L, 1L, 2L, 1L, 2L, 0L, 1L, 2L, 1L, 2L, 1L, 2L,
    1L, 2L, 4L, 1L, 0L, 0L, 2L, 2L, 0L, 2L, 3L, 1L, 0L, 3L, 2L,
    1L, 2L, 2L, 0L, 2L, 2L, 0L, 0L, 1L, 0L, 4L, 0L, 3L, 4L, 1L,
    3L, 0L, 1L, 2L, 1L, 0L, 1L, 0L, 0L, 0L, 1L, 3L, 0L, 0L, 1L,
    2L, 3L, 3L, 1L, 3L, 3L, 2L, 3L, 0L, 4L, 2L, 3L, 4L, 3L, 2L,
    1L, 3L, 2L, 0L, 2L, 3L, 2L, 0L, 3L, 4L, 3L, 1L, 2L, 3L, 2L,
    3L, 2L, 3L, 2L, 3L, 1L, 0L, 2L, 2L, 3L, 4L, 0L, 2L, 0L, 0L,
    0L, 0L, 2L, 3L, 0L, 0L, 1L, 3L, 2L, 2L, 0L, 0L, 1L, 3L, 3L,
    0L, 0L, 4L, 0L, 0L, 3L, 3L, 2L, 1L, 2L, 4L, 0L, 3L, 1L, 2L,
    2L, 0L, 0L, 3L, 1L, 3L, 1L, 0L, 3L, 4L, 3L, 3L, 3L, 4L, 0L,
    1L, 2L, 2L, 1L, 2L, 0L, 1L, 3L, 4L, 4L, 0L, 0L, 0L, 3L, 1L,
    0L, 2L, 1L, 2L, 3L, 3L, 2L, 2L, 2L, 0L, 2L, 2L, 3L, 3L, 2L,
    1L, 2L, 2L, 1L, 2L, 2L, 3L, 3L, 2L, 3L, 1L, 2L, 4L, 3L, 2L,
    0L, 2L, 1L, 0L, 2L, 3L, 4L, 2L, 0L, 4L, 2L, 1L, 1L, 0L, 3L,
    2L, 0L, 2L, 1L, 3L, 1L, 2L, 2L, 0L, 4L, 3L, 1L, 4L, 0L, 3L,
    1L, 0L, 1L, 3L, 1L, 1L, 2L, 1L, 0L, 2L, 1L, 3L, 1L, 2L, 1L,
    2L, 4L, 4L, 0L, 3L, 3L, 1L, 0L, 0L, 1L, 1L, 0L, 4L, 1L, 2L,
    1L, 4L, 1L, 4L, 4L, 0L, 3L, 3L, 2L, 2L, 1L, 3L, 4L, 0L, 0L,
    2L, 3L, 2L, 2L, 2L, 0L, 2L, 2L, 1L, 2L, 2L, 0L, 2L, 3L, 0L,
    1L, 0L, 0L, 0L, 3L, 2L, 0L, 3L, 2L, 0L, 0L, 1L, 3L, 4L, 3L,
    0L, 0L, 3L, 2L, 3L, 3L, 0L, 0L, 0L, 2L, 2L, 0L, 4L, 2L, 2L,
    2L, 3L, 2L, 2L, 4L, 1L, 1L, 1L, 3L, 2L, 3L, 1L, 2L, 3L, 2L,
    2L, 4L, 1L, 3L, 3L, 0L, 1L, 1L, 2L, 3L, 3L, 2L, 4L, 1L, 1L,
    2L, 4L, 0L, 2L, 1L, 1L, 2L, 4L, 0L, 1L, 3L, 1L, 0L, 2L, 2L,
    0L, 0L, 2L, 3L, 1L, 1L, 1L, 2L, 3L, 3L, 1L, 4L, 0L, 1L, 0L,
    2L, 0L, 1L, 3L, 3L, 4L, 0L, 4L, 4L, 1L, 1L, 1L, 2L, 1L, 3L,
    4L, 3L, 0L, 3L, 1L, 2L, 1L, 1L, 0L, 2L, 1L, 1L, 1L, 3L, 0L,
    3L, 3L, 1L, 1L, 2L, 1L, 2L, 2L, 1L, 0L, 1L, 2L, 1L, 4L, 1L,
    0L, 1L, 4L, 2L, 1L, 4L, 1L, 4L, 4L, 1L, 3L, 0L, 2L, 0L, 3L,
    1L, 4L, 1L, 3L, 4L, 3L, 2L, 2L, 3L, 1L, 1L, 2L, 4L, 1L, 0L,
    2L, 2L, 3L, 0L, 1L, 1L, 4L, 1L, 2L, 3L, 4L, 1L, 1L, 1L, 4L,
    0L, 0L, 0L, 0L, 0L, 3L, 2L, 4L, 2L, 2L, 3L, 2L, 3L, 2L, 1L,
    2L, 1L, 1L, 1L, 1L, 2L, 1L, 0L, 0L, 1L, 2L, 2L, 1L, 3L, 1L,
    1L, 1L, 2L, 0L, 2L, 2L, 1L, 3L, 3L, 3L, 2L, 3L, 1L, 3L, 1L,
    1L, 0L, 3L, 2L, 3L, 0L, 2L, 0L, 0L, 1L, 1L, 3L, 2L, 2L, 3L,
    1L, 1L, 1L, 2L, 2L, 0L, 1L, 2L, 2L, 2L, 1L, 1L, 1L, 1L, 2L,
    0L, 2L, 0L, 3L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 4L, 3L, 2L, 1L,
    1L, 2L, 2L, 2L, 0L, 4L, 1L, 1L, 3L, 3L, 2L, 1L, 1L, 2L, 4L,
    1L, 1L, 2L, 4L, 0L, 1L, 1L, 1L, 0L, 1L, 2L, 3L, 3L, 2L, 1L,
    2L, 2L, 0L, 1L, 1L, 2L, 1L, 4L, 4L, 1L, 3L, 3L, 1L, 1L, 1L,
    2L, 2L, 3L, 2L, 1L, 2L, 2L, 2L, 2L, 0L, 1L, 1L, 2L, 0L, 2L,
    0L, 1L, 2L, 0L, 3L, 2L, 3L, 2L, 2L, 2L, 0L, 3L, 2L, 2L, 2L,
    2L, 1L, 1L, 1L, 1L, 4L, 1L, 1L, 3L, 2L, 4L, 1L, 1L, 1L, 1L,
    1L, 0L, 1L, 0L, 0L, 2L, 1L, 2L, 1L, 1L, 0L, 0L, 2L, 2L, 1L,
    1L, 0L, 2L, 0L, 0L, 1L, 1L, 1L, 0L, 0L, 2L, 2L, 4L, 2L, 3L,
    4L, 4L, 0L, 2L, 2L, 4L, 0L, 3L, 2L, 1L, 2L, 1L, 3L, 3L, 1L,
    1L, 1L, 2L, 1L, 1L, 3L, 3L, 2L, 3L, 3L, 0L, 1L, 3L, 0L, 2L,
    1L, 2L, 1L, 1L, 1L, 3L, 2L, 2L, 3L, 3L, 2L, 2L, 2L, 2L, 2L,
    1L, 2L, 2L, 2L, 3L, 0L, 1L, 1L, 0L, 1L, 1L, 1L, 1L, 2L, 2L,
    0L, 1L, 1L, 1L, 2L, 3L, 1L, 1L, 3L, 2L, 1L, 1L, 1L, 3L, 1L,
    1L, 0L, 1L, 1L, 2L, 3L, 1L, 2L, 2L, 1L, 1L, 0L, 1L, 2L, 0L,
    1L, 0L, 1L, 0L, 0L, 4L, 0L, 1L, 0L, 0L, 1L, 2L, 4L, 2L, 1L,
    1L, 2L, 3L, 2L, 1L, 2L, 3L, 0L, 2L, 1L, 1L, 2L, 1L, 1L, 2L,
    3L, 2L, 0L, 1L, 1L, 3L, 1L, 3L, 3L, 2L, 3L, 2L, 1L, 3L, 2L,
    2L, 2L, 2L, 1L, 2L, 3L, 1L, 1L, 1L, 2L, 2L, 2L, 1L, 1L, 2L,
    1L, 2L, 2L, 3L, 3L, 3L, 1L, 1L, 4L, 1L, 1L, 2L, 0L, 3L, 1L,
    2L, 2L, 2L, 4L, 2L, 0L, 0L, 2L, 1L, 2L, 4L, 2L, 1L, 0L, 1L,
    2L, 0L, 2L, 2L, 1L, 1L, 2L, 3L, 3L, 0L, 3L, 0L, 2L, 1L, 1L,
    1L, 1L, 3L, 1L, 1L, 3L, 3L, 1L, 0L, 2L, 1L, 3L, 0L, 2L, 2L,
    1L, 1L, 0L, 4L, 2L, 1L, 0L, 0L, 2L, 2L, 2L, 2L, 2L, 1L, 2L,
    1L, 2L, 2L, 1L, 2L, 1L, 1L, 2L, 2L, 4L, 4L, 2L, 2L, 3L, 3L,
    3L, 0L, 1L, 1L, 2L, 2L, 4L, 1L, 3L, 1L, 3L, 2L, 2L, 1L, 3L,
    2L, 2L, 1L, 3L, 1L, 4L, 3L, 1L, 3L, 4L, 3L, 2L, 2L, 1L, 4L,
    3L, 3L, 1L, 3L, 3L, 2L, 4L, 4L, 0L, 3L, 3L, 1L, 2L, 4L, 0L,
    4L, 1L, 1L, 3L, 3L, 2L, 4L, 3L, 1L, 3L, 3L, 2L, 0L, 0L, 2L,
    4L, 4L, 4L, 3L, 2L, 2L, 3L, 4L, 3L, 3L, 2L, 4L, 2L, 4L, 1L,
    0L, 4L, 1L, 2L, 2L, 3L, 4L, 3L, 2L, 2L, 2L, 4L, 2L, 0L, 3L,
    3L, 0L, 1L, 0L, 2L, 2L, 3L, 2L, 0L, 1L, 2L, 3L, 3L, 4L, 4L,
    3L, 1L, 3L, 2L, 3L, 4L, 4L, 2L, 1L, 1L, 1L, 2L, 1L, 0L, 4L,
    4L, 4L, 2L, 1L, 4L, 4L, 2L, 3L, 3L, 4L, 1L, 2L, 3L, 1L, 1L,
    4L, 3L, 1L, 0L, 4L, 1L, 4L, 1L, 4L, 4L, 4L, 4L, 1L, 1L, 1L,
    0L, 3L, 1L, 4L, 1L, 3L, 1L, 4L, 2L, 1L, 1L, 1L, 1L, 1L, 4L,
    4L, 3L, 4L, 1L, 4L, 1L, 2L, 1L, 0L, 4L, 3L, 0L, 1L, 4L, 3L,
    0L, 4L, 1L, 4L, 1L, 0L, 4L, 1L, 1L, 1L, 1L, 1L, 1L, 3L, 0L,
    2L, 1L, 1L, 1L, 0L, 2L, 1L, 4L, 4L, 3L, 1L, 3L, 1L, 4L, 1L,
    4L, 4L, 4L, 0L, 3L, 0L, 4L, 4L, 0L, 3L, 2L, 4L, 4L, 1L, 4L,
    4L, 1L, 3L, 2L, 0L, 1L, 1L, 0L, 1L, 4L, 1L, 4L, 4L, 4L, 1L,
    4L, 1L, 4L, 4L, 1L, 1L, 2L, 4L, 3L, 4L, 4L, 2L, 0L, 1L, 3L,
    4L, 4L, 1L, 3L, 2L, 3L, 0L, 1L, 1L, 0L, 0L, 1L, 2L, 1L, 1L,
    2L, 1L, 1L, 2L, 1L, 0L, 3L, 1L, 2L, 1L, 1L, 2L, 3L, 0L, 1L,
    1L, 0L, 1L, 1L, 1L, 1L, 1L, 0L, 1L, 3L, 1L, 2L, 1L, 3L, 2L,
    0L, 1L, 1L, 2L, 1L, 1L, 1L, 3L, 1L, 1L, 0L, 3L, 1L, 1L, 0L,
    1L, 1L, 1L, 0L, 1L, 3L, 1L, 1L, 3L, 1L, 1L, 3L, 1L, 1L, 0L,
    1L, 0L, 1L, 1L, 1L, 1L, 3L, 2L, 2L, 0L, 3L, 3L, 1L, 3L, 3L,
    2L, 2L, 1L, 2L, 4L, 2L, 0L, 1L, 2L, 3L, 3L, 1L, 1L, 4L, 3L,
    2L, 3L, 3L, 3L, 1L, 1L, 1L, 1L, 4L, 1L, 1L, 4L, 1L, 1L, 1L,
    2L, 2L, 2L, 3L, 2L, 2L, 1L, 3L, 0L, 3L, 2L, 3L, 3L, 3L, 1L,
    4L, 3L, 3L, 3L, 2L, 3L, 2L, 2L, 1L, 1L, 3L, 2L, 2L, 1L, 1L,
    3L, 3L, 3L, 1L, 2L, 0L, 4L, 1L, 3L, 3L, 0L, 3L, 2L, 3L, 3L,
    1L, 3L, 2L, 2L, 2L, 3L, 1L, 0L, 3L, 1L, 3L, 0L, 1L, 2L, 3L,
    2L, 2L, 2L, 3L, 2L, 3L, 4L, 2L, 1L, 1L, 3L, 1L, 0L, 1L, 3L,
    1L, 3L, 2L, 2L, 4L, 2L, 3L, 1L, 2L, 0L, 2L, 2L, 3L, 1L, 2L,
    2L, 2L, 2L, 1L, 2L, 3L, 4L, 1L, 3L, 2L, 2L, 3L, 2L, 2L, 2L,
    0L, 3L, 2L, 2L, 0L, 3L, 2L, 1L, 1L, 3L, 0L, 3L, 2L, 0L, 3L,
    2L, 1L, 1L, 1L, 3L, 0L, 1L, 2L, 3L, 0L, 3L, 2L, 1L, 0L, 3L,
    1L, 2L, 0L, 2L, 3L, 1L, 2L, 2L, 2L, 3L, 2L, 2L, 1L, 1L, 1L,
    3L, 0L, 4L, 3L, 4L, 2L, 2L, 1L, 3L, 2L, 3L, 3L, 1L, 2L, 1L,
    0L, 2L, 1L, 3L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L,
    2L, 2L, 2L, 1L, 2L, 1L, 3L, 2L, 2L, 2L, 2L, 3L, 0L, 2L, 3L,
    2L, 3L, 1L, 2L, 2L, 2L, 1L, 1L, 2L, 4L, 1L, 2L, 3L, 3L, 3L,
    2L, 2L, 3L, 0L, 0L, 0L, 1L, 1L, 1L, 0L, 0L, 0L, 0L, 2L, 2L,
    2L, 0L, 2L, 1L, 1L, 2L, 1L, 2L, 2L, 1L, 0L, 0L, 1L, 1L, 0L,
    0L, 2L, 2L, 1L, 0L, 1L, 0L, 0L, 1L, 1L, 1L, 1L, 1L, 0L, 2L,
    1L, 3L, 1L, 1L, 1L, 1L, 1L, 0L, 0L, 2L, 1L, 1L, 2L, 1L, 2L,
    3L, 1L, 2L, 2L, 0L, 0L, 1L, 2L, 0L, 2L, 1L, 1L, 2L, 2L, 3L,
    3L, 0L, 0L, 2L, 0L, 4L, 3L, 0L, 3L, 1L, 3L, 3L, 2L, 3L, 3L,
    2L, 4L, 3L, 3L, 2L, 1L, 2L, 3L, 3L, 2L, 2L, 1L, 4L, 3L, 2L,
    4L, 3L, 2L, 4L, 3L, 3L, 2L, 4L, 3L, 4L, 2L, 3L, 3L, 2L, 2L,
    3L, 2L, 3L, 2L, 3L, 3L, 3L, 3L, 1L, 0L, 3L, 2L, 1L, 1L, 3L,
    3L, 1L, 2L, 2L, 0L, 1L, 2L, 3L, 1L, 0L, 2L, 1L, 4L, 3L, 2L,
    4L, 2L, 3L, 2L, 4L, 3L, 4L, 3L, 3L, 3L, 3L, 4L, 4L, 3L, 4L,
    3L, 2L, 3L, 2L, 3L, 3L, 1L, 3L, 1L, 4L, 3L, 2L, 4L, 3L, 4L,
    3L, 4L, 3L, 3L, 3L, 4L, 2L, 4L, 2L, 2L, 0L, 2L, 1L, 1L, 2L,
    1L, 0L, 4L, 3L, 1L, 1L, 3L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L,
    3L, 2L, 1L, 4L, 1L, 3L, 2L, 0L, 1L, 2L, 0L, 2L, 0L, 1L, 2L,
    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 0L, 1L, 4L, 1L, 1L, 3L, 1L,
    2L, 0L, 0L, 1L, 1L, 1L, 1L, 1L, 0L, 2L, 1L, 0L, 1L, 1L, 3L,
    0L, 3L, 4L, 2L, 3L, 0L, 1L, 1L, 2L, 2L, 1L, 0L, 4L, 1L, 1L,
    2L, 2L, 0L, 1L, 1L, 1L, 1L, 2L, 2L, 3L, 2L, 3L, 1L, 0L, 0L,
    1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 0L, 1L, 3L, 1L, 1L, 1L,
    1L, 4L, 1L, 4L, 0L, 3L, 1L, 2L, 0L, 1L, 1L, 4L, 1L, 0L, 3L,
    2L, 1L, 1L, 1L, 1L, 4L, 1L, 0L, 2L, 2L, 1L, 2L, 1L, 1L, 1L,
    1L, 1L, 1L, 1L, 2L, 1L, 1L, 3L, 3L, 1L, 1L, 1L, 2L, 2L, 1L,
    3L, 1L, 1L, 0L, 1L, 0L, 2L, 0L, 1L, 1L, 1L, 1L, 2L, 0L, 1L,
    2L, 1L, 0L, 4L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 3L, 1L, 1L, 0L,
    2L, 1L, 1L, 1L, 1L, 4L, 1L, 1L, 1L, 1L, 0L, 0L, 1L, 3L, 0L,
    0L, 1L, 0L, 4L, 2L, 1L, 2L, 1L, 2L, 1L, 0L, 1L, 1L, 3L, 0L,
    0L, 1L, 1L, 2L, 1L, 2L, 0L, 1L, 1L, 1L, 1L, 2L, 0L, 1L, 1L,
    1L, 3L, 1L, 1L, 2L, 1L, 1L, 2L, 2L, 1L, 2L, 1L, 1L, 0L, 2L,
    0L, 1L, 1L, 0L, 0L, 3L, 1L, 1L, 0L, 1L, 1L, 0L, 1L, 1L, 2L,
    1L, 3L, 1L, 1L, 0L, 3L, 2L, 3L, 1L, 1L, 1L, 0L, 4L, 1L, 2L,
    4L, 1L, 1L, 0L, 1L, 3L, 1L, 1L, 1L, 1L, 1L, 0L, 1L, 2L, 2L,
    1L, 1L, 1L, 4L, 3L, 1L, 4L, 2L, 2L, 1L, 1L, 0L, 1L, 1L, 2L,
    2L, 2L, 0L, 0L, 1L, 3L, 1L, 1L, 1L, 0L, 1L, 1L, 1L, 0L, 2L,
    0L, 3L, 1L, 1L, 0L, 0L, 1L, 0L, 1L, 1L, 1L, 0L, 1L, 2L, 4L,
    1L, 0L, 2L, 1L, 1L, 0L, 3L, 1L, 1L, 1L, 1L, 0L, 0L, 1L, 3L
    )), row.names = c(NA, -8697L), class = "data.frame")


library("tram")
library("tramME")
library("survival")

sup <- c(1, 150) ## setting the support for basis approximation
opt <- optim_control(iter.max = 1e4, eval.max = 1e4, rel.tol = 1e-8, method = "nlminb") ## optimization controls

## ====== MODEL 1
## - random proportional frailty term for heterogeneity in baseline risk
## - time independent prognostic factor effects
## - random slopes for heterogeneity of prognostic factor effects
fit_m1 <- CoxphME(sui ~ ages + mmrcs + fev1pps + (ages + mmrcs + fev1pps | cohort),
                  data = data3CIA, log_first = TRUE, order = 4, support = sup,
                  control = opt)
summary(fit_m1)


## ====== MODEL 2
## - stratification by study for heterogeneity in baseline risk
## - time independent prognostic factor effects
## - random slopes for heterogeneity of prognostic factor effects
fit_m2 <- CoxphME(sui | 0 + cohort ~ ages + mmrcs + fev1pps + (0 + ages + mmrcs + fev1pps | cohort),
                  data = data3CIA, log_first = TRUE, order = 4, support = sup,
                  control = opt)
summary(fit_m2)


## ====== MODEL 3
## - random proportional frailty term for heterogeneity in baseline risk
## - time dependent prognostic factor effects
## - random slopes for heterogeneity of prognostic factor effects
fit_m3 <- CoxphME(sui | ages + mmrcs + fev1pps ~ 1 + (ages + mmrcs + fev1pps | cohort),
                  data = data3CIA, log_first = TRUE, order = 4, support = sup,
                  control = opt)
summary(fit_m3)


## ====== MODEL 4
## - stratification by study for heterogeneity in baseline risk
## - time dependent prognostic factor effects
## - random slopes for heterogeneity of prognostic factor effects
fit_m4 <- CoxphME(sui | 0 + cohort + ages + mmrcs + fev1pps ~ 1 + (0 + ages + mmrcs + fev1pps | cohort),
                  data = data3CIA, log_first = TRUE, order = 4, support = sup, control = opt)
summary(fit_m4)


## ====== MODEL 5
## - stratification by study for heterogeneity in baseline risk
## - time independent prognostic factor effects
## - fixed effects only
fit_m5 <- Coxph(sui | 0 + cohort ~ ages + mmrcs + fev1pps, data = data3CIA,
                log_first = TRUE, order = 4, support = sup)
summary(fit_m5)


## ====== MODEL 6
## - stratification by study for heterogeneity in baseline risk
## - time dependent prognostic factor effects
## - fixed effects only
fit_m6 <- Coxph(sui | 0 + cohort + ages + mmrcs + fev1pps ~ 1, data = data3CIA,
                log_first = TRUE, order = 4, support = sup)
coef(fit_m6, with_baseline = TRUE)
logLik(fit_m6)
