/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.experimentertab;

import moa.core.DoubleVector;

public class Measure {
    private String name;
    private String fileName;
    private Double value;
    private DoubleVector values = new DoubleVector();
    private Double std;
    private boolean type;
    private int index;

    public Measure(String name, String filename, boolean type, int index) {
        this.name = name;
        this.fileName = filename;
        this.type = type;
        this.index = index;
        this.value = 0.0;
        this.std = 0.0;
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public Double getStd() {
        return this.std;
    }

    public void setStd(Double std) {
        this.std = std;
    }

    public boolean isType() {
        return this.type;
    }

    public void setType(boolean type) {
        this.type = type;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public DoubleVector getValues() {
        return this.values;
    }

    public void setValues(DoubleVector values) {
        this.values = (DoubleVector)values.copy();
    }

    public void computeValue(DoubleVector values) {
        if (this.isType()) {
            this.setValues(values);
            double sumDif = 0.0;
            this.value = this.values.sumOfValues() / (double)values.numValues();
            for (int i = 0; i < this.values.numValues(); ++i) {
                double dif = this.values.getValue(i) - this.value;
                sumDif += Math.pow(dif, 2.0);
            }
            this.std = Math.sqrt(sumDif /= (double)this.values.numValues());
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

