/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.outliers.AnyOut.util;

import moa.clusterers.clustree.ClusKernel;
import moa.clusterers.clustree.Entry;
import moa.clusterers.clustree.Node;
import moa.clusterers.outliers.AnyOut.util.DataObject;
import moa.clusterers.outliers.AnyOut.util.DataSet;
import moa.clusterers.outliers.AnyOut.util.EMProjectedClustering;

public class EMTopDownTreeBuilder {
    private final int maxFanout = 3;
    private boolean ALLOW_KERNELS_IN_INNER_NODES = true;

    public Node buildTree(DataSet dataSet) throws Exception {
        Node rootNode = this.buildTreeRecursively(dataSet, 0);
        return rootNode;
    }

    private Node buildTreeRecursively(DataSet dataSet, int level) throws Exception {
        Node resultNode = null;
        Entry[] entries = new Entry[3];
        int count = 0;
        if (dataSet.size() <= 3) {
            for (Object dataObject : dataSet) {
                entries[count] = new Entry(dataSet.getNrOfDimensions());
                entries[count].add(new Entry(((DataObject)dataObject).getNrOfDimensions(), new ClusKernel(((DataObject)dataObject).getFeatures(), ((DataObject)dataObject).getFeatures().length), 0L));
                ++count;
            }
        } else {
            DataSet[] subSets = this.splitDataSetUsingEM(dataSet, 3);
            if (subSets.length == 1) {
                for (DataObject dataObject : dataSet) {
                    Entry[] newEntry = new Entry(dataObject.getNrOfDimensions(), new ClusKernel(dataObject.getFeatures(), dataObject.getFeatures().length), 0L);
                    if (count < 3) {
                        entries[count] = new Entry(dataSet.getNrOfDimensions());
                        entries[count].add((Entry)newEntry);
                    } else {
                        double minDist = Double.MIN_VALUE;
                        int closestEntry = 0;
                        for (int i = 0; i < entries.length; ++i) {
                            double tmpDist = entries[i].calcDistance((Entry)newEntry);
                            if (!(tmpDist < minDist)) continue;
                            minDist = tmpDist;
                            closestEntry = i;
                        }
                        entries[closestEntry].add((Entry)newEntry);
                    }
                    ++count;
                }
            } else {
                int i;
                Node[] newChildNodes = new Node[subSets.length];
                for (i = 0; i < newChildNodes.length; ++i) {
                    newChildNodes[i] = subSets[i].size() > 1 ? this.buildTreeRecursively(subSets[i], level + 1) : null;
                }
                for (i = 0; i < 3; ++i) {
                    if (i < newChildNodes.length) {
                        if (newChildNodes[i] == null) {
                            if (subSets[i].size() == 0) {
                                entries[i] = new Entry(dataSet.getNrOfDimensions());
                            } else {
                                entries[i] = new Entry(dataSet.getNrOfDimensions());
                                entries[i].add(new Entry(subSets[i].getObject(0).getNrOfDimensions(), new ClusKernel(subSets[i].getObject(0).getFeatures(), subSets[i].getObject(0).getFeatures().length), 0L));
                            }
                        } else {
                            entries[i] = new Entry(dataSet.getNrOfDimensions());
                            entries[i].setChild(newChildNodes[i]);
                            for (Entry e : newChildNodes[i].getEntries()) {
                                entries[i].add(e);
                            }
                        }
                    } else {
                        entries[i] = new Entry(dataSet.getNrOfDimensions());
                    }
                    ++count;
                }
            }
        }
        for (int i = count; i < 3; ++i) {
            entries[i] = new Entry(dataSet.getNrOfDimensions());
        }
        resultNode = new Node(dataSet.getNrOfDimensions(), level);
        for (Entry e : entries) {
            resultNode.addEntry(e, 0L);
        }
        return resultNode;
    }

    private DataSet[] splitDataSetUsingEM(DataSet dataSet, int nrOfPartitions) throws Exception {
        boolean changes;
        if (dataSet.size() <= 1) {
            throw new Exception("EMsplit needs at least 2 objects!");
        }
        EMProjectedClustering myEM = new EMProjectedClustering();
        int nrOfIterations = 1;
        double log10 = Math.log((double)dataSet.size() * 1.0) / Math.log(10.0);
        nrOfIterations = Math.max(1, 10 - Long.valueOf(Math.round(log10)).intValue());
        nrOfIterations = Math.min(10, nrOfIterations);
        int[][] emMapping = myEM.getEMClusteringVariancesBestChoice(dataSet.getFeaturesAsArray(), nrOfPartitions, nrOfIterations);
        DataSet[] subDataSets = new DataSet[emMapping.length];
        for (int i = 0; i < subDataSets.length; ++i) {
            subDataSets[i] = new DataSet(dataSet.getNrOfDimensions());
            for (int j = 0; j < emMapping[i].length; ++j) {
                subDataSets[i].addObject(dataSet.getObject(emMapping[i][j]));
            }
        }
        if (subDataSets.length < 2) {
            System.out.println("mean shift split");
            subDataSets = this.splitDataSetUsingMeanShift(dataSet);
        }
        boolean bl = changes = !this.ALLOW_KERNELS_IN_INNER_NODES;
        block2: while (changes) {
            changes = false;
            for (int i = 0; i < subDataSets.length; ++i) {
                if (subDataSets[i].size() != 1) continue;
                System.out.println("merge singular sets");
                subDataSets = this.mergeDataSets(subDataSets, i);
                changes = true;
                continue block2;
            }
        }
        return subDataSets;
    }

    private DataSet[] splitDataSetUsingMeanShift(DataSet dataSet) {
        DataObject[] dataObjects = dataSet.getDataObjectArray();
        int N = dataSet.size();
        int dim = dataObjects[0].getFeatures().length;
        double[] LS = new double[dim];
        double[] SS = new double[dim];
        for (int i = 0; i < dataObjects.length; ++i) {
            double[] tempFeatures = dataObjects[i].getFeatures();
            for (int j = 0; j < dim; ++j) {
                int n = j;
                LS[n] = LS[n] + tempFeatures[j];
                int n2 = j;
                SS[n2] = SS[n2] + tempFeatures[j] * tempFeatures[j];
            }
        }
        double[] sigmaSquared = new double[dim];
        double[] mean = new double[dim];
        for (int i = 0; i < dim; ++i) {
            mean[i] = LS[i] / (double)N;
            sigmaSquared[i] = SS[i] / (double)N - LS[i] * LS[i] / (double)(N * N);
            if (!(sigmaSquared[i] <= 0.0)) continue;
            sigmaSquared[i] = 0.1;
        }
        double[] mean1 = new double[dim];
        double[] mean2 = new double[dim];
        for (int i = 0; i < dim; ++i) {
            mean1[i] = mean[i] + Math.sqrt(sigmaSquared[i]);
            mean2[i] = mean[i] - Math.sqrt(sigmaSquared[i]);
        }
        DataSet[] subDataSets = new DataSet[2];
        try {
            subDataSets[0] = new DataSet(dataSet.getNrOfDimensions());
            subDataSets[1] = new DataSet(dataSet.getNrOfDimensions());
            for (int i = 0; i < dataObjects.length; ++i) {
                double dist2;
                double dist1 = this.euclideanDistance(dataObjects[i].getFeatures(), mean1);
                if (dist1 < (dist2 = this.euclideanDistance(dataObjects[i].getFeatures(), mean2))) {
                    subDataSets[0].addObject(dataObjects[i]);
                    continue;
                }
                subDataSets[1].addObject(dataObjects[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (subDataSets[0].size() == 0) {
            DataSet tmpDS = subDataSets[1];
            subDataSets = new DataSet[]{tmpDS};
        } else if (subDataSets[1].size() == 0) {
            DataSet tmpDS = subDataSets[0];
            subDataSets = new DataSet[]{tmpDS};
        }
        return subDataSets;
    }

    private DataSet[] mergeDataSets(DataSet[] subDataSets, int setToMerge) throws Exception {
        DataSet[] result = new DataSet[subDataSets.length - 1];
        int nrOfDim = subDataSets[0].getNrOfDimensions();
        double[] tmpMean = new double[nrOfDim];
        DataObject tmpObject = subDataSets[setToMerge].getObject(0);
        int closestSet = 0;
        double shortestDist = Double.MAX_VALUE;
        int newIndex = 0;
        for (int i = 0; i < subDataSets.length; ++i) {
            DataSet tmpDataSet;
            if (i == setToMerge) continue;
            result[newIndex] = tmpDataSet = subDataSets[i];
            for (int j = 0; j < tmpDataSet.size(); ++j) {
                double[] tmpFeatures = tmpDataSet.getObject(j).getFeatures();
                for (int d = 0; d < nrOfDim; ++d) {
                    int n = d;
                    tmpMean[n] = tmpMean[n] + tmpFeatures[d];
                }
            }
            int d = 0;
            while (d < nrOfDim) {
                int n = d++;
                tmpMean[n] = tmpMean[n] / (double)tmpDataSet.size();
            }
            double tmpDist = this.euclideanDistance(tmpMean, tmpObject.getFeatures());
            if (tmpDist < shortestDist) {
                shortestDist = tmpDist;
                closestSet = newIndex;
            }
            ++newIndex;
        }
        result[closestSet].addObject(tmpObject);
        return result;
    }

    private double euclideanDistance(double[] x, double[] y) {
        double result = 0.0;
        for (int i = 0; i < x.length; ++i) {
            result += (x[i] - y[i]) * (x[i] - y[i]);
        }
        return Math.sqrt(result);
    }
}

