# program spuRs/resources/scripts/lmap.r

# discrete dynamical system generated by the logistic map

lmap <- function(x1, r, n) {
    x <- x1
    for (i in 2:n) {
        x[i] <- r*x[i-1]*(1-x[i-1])
    }
    plot(x, main = paste("r = ", as.character(r)), xlab = "n", ylab = "x[n]")
}

par(mfrow = c(3,3), mar=c(4,4,4,3), las=1)
lmap(runif(1), 1.5, 100)
lmap(runif(1), 2.9, 100)
lmap(runif(1), 3.1, 100)
lmap(runif(1), 3.5, 100)
lmap(runif(1), 3.56, 100)
lmap(runif(1), 3.57, 500)
lmap(runif(1), 3.58, 500)
lmap(runif(1), 3.8, 500)
lmap(runif(1), 4, 500)
