# semptools 0.2.9.3

- Minor fixes to errors in CRAN checks.

# semptools 0.2.9.2

- Minor fixes to the DESCRIPTION file and examples.

# semptools 0.2.9.1

## Bug Fix

- Fix a bug in `set_sem_layout()`. Failed to work with models in which all
factors have the same number of indicators.

## Misc

- Reformatted the help sections of the functions (wrap the text for readability).
  This has no impact on uses and the generated help files.

# semptools 0.2.9

- Added `drop_nodes()` and `keep_nodes()`. They process a `semPlotModel` object,
  which is generated by `semPlot::semPlotModel()`, drop or keep selected nodes 
  (e.g., observed variables, latent factors) from the object. The result can 
  then be passed to `semPlot::semPaths()` to draw a diagram without the dropped 
  nodes.

- Add `layout_matrix`. A helper function for creating a layout matrix to be used
  by `semPlot::semPaths()`. Users specify the positions of nodes and the function
  will create the matrix accordingly.

- `mark_sig()`, `mark_se()`, and `set_cfa_layout()` will raise an error if the
  `semPlot::semPaths` object has intercepts terms. These function do not support
  plots with intercept terms yet.

- Updated `change_node_label()` to support named vectors.

- Added `vignette("layout_matrix")` to explain how layout matrix is used in
  `semPlot::semPaths()`, and how `layout_matrix()` can be used to construct the
   layout matrix.

- Updated the vignettes to use named vectors instead of "list of named lists"
  in some functions.

- Updated `vignette("semptools")` to introduce `change_node_label()`.

- `magrittr` is no longer required for installing the package.

# semptools 0.2.8.1

- Added `change_node_label()` for changing the labels of nodes. Several other functions
  were modified to adapt for this function.

- Added `to_list_of_lists()` for converting a named vector to a list of lists. Specifying
  a list of lists is necessary in some cases because the a label may not be string (e.g.,
  it may be an expression). However, in most cases, all elements are strings or numbers
  and so a named vector will do. This function is to be used internally by other functions,
  not to be used by users.

# semptools 0.2.8

- Fix a bug in `set_cfa_layout()`. It now will not raise an error for one-factor models.

- Fix some typo errors in documentation pages.

# semptools 0.2.7

- Import the pipe operator from `magrittr` so users no need to load the package themselves.

# semptools 0.2.6

- Update the documentation of `mark_sig()` and `mark_se()` to emphasize that 
 currently they require a `lavaan` output.

# semptools 0.2.5

- Used `pkgdown` to build a site. The first draft, with minimal customization.

# semptools 0.2.4 

- Alpha release. Ready for testing.
