/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import java.util.Enumeration;
import weka.classifiers.trees.j48.BinC45Split;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.ModelSelection;
import weka.classifiers.trees.j48.NoSplit;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class BinC45ModelSelection
extends ModelSelection {
    private static final long serialVersionUID = 179170923545122001L;
    private int m_minNoObj;
    private Instances m_allData;

    public BinC45ModelSelection(int minNoObj, Instances allData) {
        this.m_minNoObj = minNoObj;
        this.m_allData = allData;
    }

    public void cleanup() {
        this.m_allData = null;
    }

    @Override
    public final ClassifierSplitModel selectModel(Instances data) {
        ClassifierSplitModel bestModel = null;
        NoSplit noSplitModel = null;
        double averageInfoGain = 0.0;
        int validModels = 0;
        boolean multiVal = true;
        try {
            Distribution checkDistribution = new Distribution(data);
            noSplitModel = new NoSplit(checkDistribution);
            if (Utils.sm(checkDistribution.total(), 2 * this.m_minNoObj) || Utils.eq(checkDistribution.total(), checkDistribution.perClass(checkDistribution.maxClass()))) {
                return noSplitModel;
            }
            Enumeration enu = data.enumerateAttributes();
            while (enu.hasMoreElements()) {
                Attribute attribute = (Attribute)enu.nextElement();
                if (!attribute.isNumeric() && !Utils.sm(attribute.numValues(), 0.3 * (double)this.m_allData.numInstances())) continue;
                multiVal = false;
                break;
            }
            BinC45Split[] currentModel = new BinC45Split[data.numAttributes()];
            double sumOfWeights = data.sumOfWeights();
            int i = 0;
            while (i < data.numAttributes()) {
                if (i != data.classIndex()) {
                    currentModel[i] = new BinC45Split(i, this.m_minNoObj, sumOfWeights);
                    currentModel[i].buildClassifier(data);
                    if (currentModel[i].checkModel() && (data.attribute(i).isNumeric() || multiVal || Utils.sm(data.attribute(i).numValues(), 0.3 * (double)this.m_allData.numInstances()))) {
                        averageInfoGain += currentModel[i].infoGain();
                        ++validModels;
                    }
                } else {
                    currentModel[i] = null;
                }
                ++i;
            }
            if (validModels == 0) {
                return noSplitModel;
            }
            averageInfoGain /= (double)validModels;
            double minResult = 0.0;
            i = 0;
            while (i < data.numAttributes()) {
                if (i != data.classIndex() && currentModel[i].checkModel() && currentModel[i].infoGain() >= averageInfoGain - 0.001 && Utils.gr(currentModel[i].gainRatio(), minResult)) {
                    bestModel = currentModel[i];
                    minResult = currentModel[i].gainRatio();
                }
                ++i;
            }
            if (Utils.eq(minResult, 0.0)) {
                return noSplitModel;
            }
            bestModel.distribution().addInstWithUnknown(data, ((BinC45Split)bestModel).attIndex());
            ((BinC45Split)bestModel).setSplitPoint(this.m_allData);
            return bestModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public final ClassifierSplitModel selectModel(Instances train, Instances test) {
        return this.selectModel(train);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.11 $");
    }
}

