/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.knowm.xchart.OHLCSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.Legend_;
import org.knowm.xchart.internal.chartpart.RenderableSeries;
import org.knowm.xchart.style.OHLCStyler;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.lines.SeriesLines;

public class Legend_OHLC<ST extends OHLCStyler, S extends OHLCSeries>
extends Legend_<ST, S> {
    private final ST axesChartStyler;

    public Legend_OHLC(Chart<ST, S> chart) {
        super(chart);
        this.axesChartStyler = (OHLCStyler)chart.getStyler();
    }

    @Override
    public void doPaint(Graphics2D g2) {
        double startx = this.xOffset + (double)((OHLCStyler)this.chart.getStyler()).getLegendPadding();
        double starty = this.yOffset + (double)((OHLCStyler)this.chart.getStyler()).getLegendPadding();
        Object oldHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Map map = this.chart.getSeriesMap();
        for (OHLCSeries series : map.values()) {
            if (!series.isShowInLegend() || !series.isEnabled()) continue;
            Map<String, Rectangle2D> seriesTextBounds = this.getSeriesTextBounds(series);
            float legendEntryHeight = this.getLegendEntryHeight(seriesTextBounds, ((Styler)this.axesChartStyler).getMarkerSize());
            if (series.getOhlcSeriesRenderStyle() != OHLCSeries.OHLCSeriesRenderStyle.Line) {
                Rectangle2D.Double rectSmall = new Rectangle2D.Double(startx, starty + (double)legendEntryHeight / 2.0 - 10.0, ((OHLCStyler)this.chart.getStyler()).getLegendSeriesLineLength(), 20.0);
                if (series.getLineColor() == null) {
                    g2.setColor(series.getUpColor());
                } else {
                    g2.setColor(series.getLineColor());
                }
                g2.fill(rectSmall);
            }
            if (series.getOhlcSeriesRenderStyle() == OHLCSeries.OHLCSeriesRenderStyle.Line && series.getLegendRenderType() == RenderableSeries.LegendRenderType.Line && series.getLineStyle() != SeriesLines.NONE) {
                g2.setColor(series.getLineColor());
                g2.setStroke(series.getLineStyle());
                Line2D.Double line = new Line2D.Double(startx, starty + (double)legendEntryHeight / 2.0, startx + (double)((OHLCStyler)this.chart.getStyler()).getLegendSeriesLineLength(), starty + (double)legendEntryHeight / 2.0);
                g2.draw(line);
            }
            if (series.getOhlcSeriesRenderStyle() == OHLCSeries.OHLCSeriesRenderStyle.Line && series.getMarker() != null) {
                g2.setColor(series.getMarkerColor());
                series.getMarker().paint(g2, startx + (double)((OHLCStyler)this.chart.getStyler()).getLegendSeriesLineLength() / 2.0, starty + (double)legendEntryHeight / 2.0, ((Styler)this.axesChartStyler).getMarkerSize());
            }
            double x = startx + (double)((OHLCStyler)this.chart.getStyler()).getLegendSeriesLineLength() + (double)((OHLCStyler)this.chart.getStyler()).getLegendPadding();
            this.paintSeriesText(g2, seriesTextBounds, ((Styler)this.axesChartStyler).getMarkerSize(), x, starty);
            if (((OHLCStyler)this.chart.getStyler()).getLegendLayout() == Styler.LegendLayout.Vertical) {
                starty += (double)(legendEntryHeight + (float)((OHLCStyler)this.chart.getStyler()).getLegendPadding());
                continue;
            }
            int markerWidth = ((OHLCStyler)this.chart.getStyler()).getLegendSeriesLineLength();
            float legendEntryWidth = this.getLegendEntryWidth(seriesTextBounds, markerWidth);
            startx += (double)(legendEntryWidth + (float)((OHLCStyler)this.chart.getStyler()).getLegendPadding());
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }

    @Override
    public double getSeriesLegendRenderGraphicHeight(S series) {
        return ((OHLCSeries)series).getLegendRenderType() == RenderableSeries.LegendRenderType.Box || ((OHLCSeries)series).getLegendRenderType() == RenderableSeries.LegendRenderType.BoxNoOutline ? 20.0 : (double)((Styler)this.axesChartStyler).getMarkerSize();
    }
}

