/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class ReTypingFeatureIterator
implements SimpleFeatureIterator {
    SimpleFeatureIterator delegate;
    SimpleFeatureType target;
    AttributeDescriptor[] types;
    SimpleFeatureBuilder builder;

    public ReTypingFeatureIterator(SimpleFeatureIterator delegate, SimpleFeatureType source, SimpleFeatureType target) {
        this.delegate = delegate;
        this.target = target;
        this.types = this.typeAttributes(source, target);
        this.builder = new SimpleFeatureBuilder(target);
    }

    public SimpleFeatureIterator getDelegate() {
        return this.delegate;
    }

    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    public SimpleFeature next() {
        SimpleFeature next = (SimpleFeature)this.delegate.next();
        String id = next.getID();
        try {
            for (int i = 0; i < this.types.length; ++i) {
                String xpath = this.types[i].getLocalName();
                this.builder.add(next.getAttribute(xpath));
            }
            this.builder.featureUserData(next);
            return this.builder.buildFeature(id);
        }
        catch (IllegalAttributeException e2) {
            throw new RuntimeException(e2);
        }
    }

    protected AttributeDescriptor[] typeAttributes(SimpleFeatureType original, SimpleFeatureType target) {
        if (target.equals(original)) {
            throw new IllegalArgumentException("FeatureReader allready produces contents with the correct schema");
        }
        if (target.getAttributeCount() > original.getAttributeCount()) {
            throw new IllegalArgumentException("Unable to retype  FeatureReader<SimpleFeatureType, SimpleFeature> (origional does not cover requested type)");
        }
        AttributeDescriptor[] types = new AttributeDescriptor[target.getAttributeCount()];
        for (int i = 0; i < target.getAttributeCount(); ++i) {
            AttributeDescriptor attrib = target.getDescriptor(i);
            String xpath = attrib.getLocalName();
            types[i] = attrib;
            if (attrib.equals(original.getDescriptor(xpath))) continue;
            throw new IllegalArgumentException("Unable to retype  FeatureReader<SimpleFeatureType, SimpleFeature> (origional does not cover " + xpath + ")");
        }
        return types;
    }

    public void close() {
        this.delegate.close();
    }
}

