/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.decomposition;

import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class UtilDecompositons_DDRM {
    public static DMatrixRMaj checkIdentity(DMatrixRMaj A2, int numRows, int numCols) {
        if (A2 == null) {
            return CommonOps_DDRM.identity(numRows, numCols);
        }
        if (numRows != A2.numRows || numCols != A2.numCols) {
            throw new IllegalArgumentException("Input is not " + numRows + " x " + numCols + " matrix");
        }
        CommonOps_DDRM.setIdentity(A2);
        return A2;
    }

    public static DMatrixRMaj checkZeros(DMatrixRMaj A2, int numRows, int numCols) {
        if (A2 == null) {
            return new DMatrixRMaj(numRows, numCols);
        }
        if (numRows != A2.numRows || numCols != A2.numCols) {
            throw new IllegalArgumentException("Input is not " + numRows + " x " + numCols + " matrix");
        }
        A2.zero();
        return A2;
    }

    public static DMatrixRMaj checkZerosLT(DMatrixRMaj A2, int numRows, int numCols) {
        if (A2 == null) {
            return new DMatrixRMaj(numRows, numCols);
        }
        if (numRows != A2.numRows || numCols != A2.numCols) {
            throw new IllegalArgumentException("Input is not " + numRows + " x " + numCols + " matrix");
        }
        for (int i = 0; i < A2.numRows; ++i) {
            int index = i * A2.numCols;
            int end = index + Math.min(i, A2.numCols);
            while (index < end) {
                A2.data[index++] = 0.0;
            }
        }
        return A2;
    }

    public static DMatrixRMaj checkZerosUT(DMatrixRMaj A2, int numRows, int numCols) {
        if (A2 == null) {
            return new DMatrixRMaj(numRows, numCols);
        }
        if (numRows != A2.numRows || numCols != A2.numCols) {
            throw new IllegalArgumentException("Input is not " + numRows + " x " + numCols + " matrix");
        }
        int maxRows = Math.min(A2.numRows, A2.numCols);
        for (int i = 0; i < maxRows; ++i) {
            int index = i * A2.numCols + i + 1;
            int end = i * A2.numCols + A2.numCols;
            while (index < end) {
                A2.data[index++] = 0.0;
            }
        }
        return A2;
    }
}

