/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables;

import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.expression.discrete.arithmetic.ArExpression;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.learn.XParameters;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.impl.siglit.SignedLiteral;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSet;

public interface IntVar
extends ICause,
Variable,
Iterable<Integer>,
ArExpression {
    public static final int MIN_INT_BOUND = -21474836;
    public static final int MAX_INT_BOUND = 21474836;

    public boolean removeValue(int var1, ICause var2) throws ContradictionException;

    public boolean removeValues(IntIterableSet var1, ICause var2) throws ContradictionException;

    public boolean removeAllValuesBut(IntIterableSet var1, ICause var2) throws ContradictionException;

    public boolean removeInterval(int var1, int var2, ICause var3) throws ContradictionException;

    public boolean instantiateTo(int var1, ICause var2) throws ContradictionException;

    public boolean updateLowerBound(int var1, ICause var2) throws ContradictionException;

    public boolean updateUpperBound(int var1, ICause var2) throws ContradictionException;

    public boolean updateBounds(int var1, int var2, ICause var3) throws ContradictionException;

    public boolean contains(int var1);

    public boolean isInstantiatedTo(int var1);

    public int getValue();

    public int getLB();

    public int getUB();

    public int getRange();

    public int nextValue(int var1);

    public int nextValueOut(int var1);

    public int previousValue(int var1);

    public int previousValueOut(int var1);

    public DisposableValueIterator getValueIterator(boolean var1);

    public DisposableRangeIterator getRangeIterator(boolean var1);

    public boolean hasEnumeratedDomain();

    public IIntDeltaMonitor monitorDelta(ICause var1);

    public boolean isBool();

    @Override
    default public void forEachIntVar(Consumer<IntVar> action) {
        action.accept(this);
    }

    default public IEventType transformEvent(IEventType evt) {
        return evt;
    }

    @Override
    default public IntVar intVar() {
        return this;
    }

    @Override
    default public int getNoChild() {
        return 1;
    }

    @Override
    default public boolean isExpressionLeaf() {
        return true;
    }

    public void createLit(IntIterableRangeSet var1);

    public SignedLiteral getLit();

    default public void flushLit() {
        this.getLit().clear();
    }

    default public void unionLit(IntIterableRangeSet set, ExplanationForSignedClause explanation) {
        if (XParameters.FINE_PROOF) {
            System.out.printf("%s: %s \u222a %s\n", this.getName(), this.getLit(), set);
        }
        this.getLit().addAll(set);
        if (this.getLit().isEmpty()) {
            if (XParameters.FINE_PROOF) {
                System.out.print("skip\n");
            }
        } else {
            if (XParameters.FINE_PROOF) {
                System.out.print("\n");
            }
            explanation.addLit(this);
        }
        explanation.returnSet(set);
    }

    default public void unionLit(int l, int u, ExplanationForSignedClause explanation) {
        if (XParameters.FINE_PROOF) {
            System.out.printf("%s: %s \u222a [%d, %d]", this.getName(), this.getLit(), l, u);
        }
        this.getLit().addBetween(l, u);
        if (this.getLit().isEmpty()) {
            if (XParameters.FINE_PROOF) {
                System.out.print("-- skip\n");
            }
        } else {
            if (XParameters.FINE_PROOF) {
                System.out.print("\n");
            }
            explanation.addLit(this);
        }
    }

    default public void unionLit(int v, ExplanationForSignedClause explanation) {
        if (XParameters.FINE_PROOF) {
            System.out.printf("%s: %s \u222a {%d}", this.getName(), this.getLit(), v);
        }
        this.getLit().add(v);
        if (this.getLit().isEmpty()) {
            if (XParameters.FINE_PROOF) {
                System.out.print("skip\n");
            }
        } else {
            if (XParameters.FINE_PROOF) {
                System.out.print("\n");
            }
            explanation.addLit(this);
        }
    }

    default public void intersectLit(IntIterableRangeSet set, ExplanationForSignedClause explanation) {
        if (explanation.contains(this)) {
            if (XParameters.FINE_PROOF) {
                System.out.printf("%s: %s \u2229 %s", this.getName(), this.getLit(), set);
            }
            this.getLit().retainAll(set);
            if (this.getLit().isEmpty()) {
                if (XParameters.FINE_PROOF) {
                    System.out.print(" -- remove");
                }
                explanation.removeLit(this);
            }
            if (XParameters.FINE_PROOF) {
                System.out.print("\n");
            }
            explanation.returnSet(set);
        } else {
            this.unionLit(set, explanation);
        }
    }

    default public void intersectLit(int l, int u, ExplanationForSignedClause explanation) {
        if (explanation.contains(this)) {
            if (XParameters.FINE_PROOF) {
                System.out.printf("%s: %s \u2229 [%d,%d]", this.getName(), this.getLit(), l, u);
            }
            this.getLit().retainBetween(l, u);
            if (this.getLit().isEmpty()) {
                if (XParameters.FINE_PROOF) {
                    System.out.print(" -- remove");
                }
                explanation.removeLit(this);
            }
            if (XParameters.FINE_PROOF) {
                System.out.print("\n");
            }
        } else {
            this.unionLit(l, u, explanation);
        }
    }

    default public void intersectLit(int v, ExplanationForSignedClause explanation) {
        if (explanation.contains(this)) {
            if (XParameters.FINE_PROOF) {
                System.out.printf("%s: %s \u2229 {%d}", this.getName(), this.getLit(), v);
            }
            this.getLit().retain(v);
            if (this.getLit().isEmpty()) {
                if (XParameters.FINE_PROOF) {
                    System.out.print(" -- remove");
                }
                explanation.removeLit(this);
            }
            if (XParameters.FINE_PROOF) {
                System.out.print("\n");
            }
        } else {
            this.unionLit(v, explanation);
        }
    }

    default public IntStream stream() {
        Spliterators.AbstractIntSpliterator it = new Spliterators.AbstractIntSpliterator(this.getDomainSize(), 273){
            final int[] val;
            {
                this.val = new int[]{IntVar.this.getLB() - 1};
            }

            @Override
            public boolean tryAdvance(IntConsumer action) {
                this.val[0] = IntVar.this.nextValue(this.val[0]);
                if (this.val[0] < Integer.MAX_VALUE) {
                    action.accept(this.val[0]);
                    return true;
                }
                return false;
            }
        };
        return StreamSupport.intStream(it, false);
    }
}

