/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.selectors.values;

import org.chocosolver.solver.Cause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.selectors.values.IntValueSelector;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.tools.VariableUtils;

public final class IntDomainImpact
implements IntValueSelector {
    private final int maxdom;
    private final DecisionOperator<IntVar> dop;
    private IntVar[] allVars;
    private final int coeff;

    public IntDomainImpact(int maxdom, DecisionOperator<IntVar> dop, boolean smallest) {
        this.maxdom = maxdom;
        this.dop = dop;
        this.coeff = smallest ? 1 : -1;
    }

    public IntDomainImpact() {
        this(100, DecisionOperatorFactory.makeIntEq(), true);
    }

    @Override
    public int selectValue(IntVar var) {
        double ubB;
        if (this.allVars == null) {
            this.allVars = var.getModel().retrieveIntVars(true);
        }
        assert (var.getModel().getObjective() != null);
        double sspace = VariableUtils.searchSpaceSize(this.allVars);
        if (var.hasEnumeratedDomain() && var.getDomainSize() < this.maxdom) {
            double bestCost = 2.0;
            int ub = var.getUB();
            int bestV = this.dop == DecisionOperatorFactory.makeIntReverseSplit() ? ub : var.getLB();
            int v = var.getLB();
            while (v <= ub) {
                double bound = this.impact(var, v, sspace) * (double)this.coeff;
                if (bound < bestCost) {
                    bestCost = bound;
                    bestV = v;
                }
                v = var.nextValue(v);
            }
            return bestV;
        }
        double lbB = this.impact(var, var.getLB(), sspace) * (double)this.coeff;
        if (lbB == (ubB = this.impact(var, var.getUB(), sspace) * (double)this.coeff)) {
            return this.dop == DecisionOperatorFactory.makeIntReverseSplit() ? var.getUB() : var.getLB();
        }
        return lbB < ubB ? var.getLB() : var.getUB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double impact(IntVar var, int val, double before) {
        Model model = var.getModel();
        if (this.dop == DecisionOperatorFactory.makeIntSplit() && val == var.getUB() || this.dop == DecisionOperatorFactory.makeIntReverseSplit() && val == var.getLB()) {
            return 1.0;
        }
        model.getEnvironment().worldPush();
        try {
            var.instantiateTo(val, Cause.Null);
            model.getSolver().getEngine().propagate();
            double after = VariableUtils.searchSpaceSize(this.allVars);
            double d2 = 1.0 - after / before;
            return d2;
        }
        catch (ContradictionException e2) {
            model.getSolver().getEngine().flush();
            model.getEnvironment().worldPop();
            model.getEnvironment().worldPush();
            try {
                var.removeValue(val, Cause.Null);
                model.getSolver().getEngine().propagate();
            }
            catch (ContradictionException ex) {
                model.getSolver().getEngine().flush();
            }
            double d3 = 1.0;
            return d3;
        }
        finally {
            model.getEnvironment().worldPop();
        }
    }
}

