/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.move;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.objective.IObjectiveManager;
import org.chocosolver.solver.search.limits.BacktrackCounter;
import org.chocosolver.solver.search.loop.move.MoveBinaryDFS;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.DecisionPath;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.tools.ArrayUtils;

public class MoveBinaryHBFS
extends MoveBinaryDFS {
    private final BacktrackCounter dfslimit;
    private long Z;
    private long limit;
    private final long N;
    private long nodesRecompute;
    private final double a;
    private final double b;
    private IObjectiveManager<IntVar> objectiveManager;
    private boolean isMinimization;
    private final PriorityQueue<Open> opens;
    private Decision[] copen;
    private final List<Decision> _unkopen;
    private int current;
    private final Model mModel;

    public MoveBinaryHBFS(Model model, AbstractStrategy strategy, double a2, double b2, long N) {
        super(strategy);
        this.mModel = model;
        this.dfslimit = new BacktrackCounter(model, N);
        this.opens = new PriorityQueue();
        this.copen = new Decision[0];
        this.current = 0;
        this.limit = this.Z = 1L;
        this.N = N;
        this.a = a2;
        this.b = b2;
        this._unkopen = new ArrayList<Decision>();
    }

    @Override
    public boolean init() {
        boolean init = super.init();
        this.objectiveManager = this.mModel.getSolver().getObjectiveManager();
        if (this.objectiveManager.getPolicy() == ResolutionPolicy.SATISFACTION) {
            throw new UnsupportedOperationException("HBFS is not adapted to satisfaction problems.");
        }
        this.isMinimization = this.objectiveManager.getPolicy() == ResolutionPolicy.MINIMIZE;
        return init;
    }

    @Override
    public boolean extend(Solver solver) {
        boolean extend;
        if (this.current < this.copen.length) {
            solver.getDecisionPath().pushDecision(this.copen[this.current++]);
            solver.getEnvironment().worldPush();
            extend = true;
        } else {
            extend = super.extend(solver);
        }
        return extend;
    }

    @Override
    public boolean repair(Solver solver) {
        boolean repair;
        if (!this.dfslimit.isMet(this.limit)) {
            this.current = this.copen.length;
            repair = super.repair(solver);
        } else {
            this.extractOpenRightBranches(solver);
            repair = true;
        }
        return repair;
    }

    protected void extractOpenRightBranches(Solver solver) {
        if (this.nodesRecompute > 0L) {
            double ratio = (double)this.nodesRecompute * 1.0 / (double)solver.getNodeCount();
            if (ratio > this.b && this.Z <= this.N) {
                this.Z *= 2L;
            } else if (ratio < this.a && this.Z >= 2L) {
                this.Z /= 2L;
            }
        }
        this.limit += this.Z;
        int i = this.compareSubpath(solver);
        if (i < this._unkopen.size()) {
            this.extractOB(solver, i);
        }
        Open next = this.opens.poll();
        while (next != null && !this.isValid(next.currentBound())) {
            next = this.opens.poll();
        }
        if (next != null) {
            this.copen = next.toArray();
            ArrayUtils.reverse(this.copen);
            this.current = 0;
            this.nodesRecompute = solver.getNodeCount() + (long)this.copen.length;
        } else {
            this.current = this.copen.length;
        }
        solver.restart();
    }

    private int compareSubpath(Solver solver) {
        int i;
        this._unkopen.clear();
        DecisionPath decisionPath = solver.getDecisionPath();
        int pos = decisionPath.size() - 1;
        Decision decision = decisionPath.getDecision(pos);
        while (decision.getPosition() != this.topDecisionPosition) {
            this._unkopen.add(decision);
            decision = decisionPath.getDecision(--pos);
        }
        Collections.reverse(this._unkopen);
        int I = Math.min(this._unkopen.size(), this.copen.length);
        for (i = 0; i < I && this.copen[i].isEquivalentTo(this._unkopen.get(i)); ++i) {
        }
        return i;
    }

    private void extractOB(Solver solver, int i) {
        int stopAt = this._unkopen.get(i).getPosition() - 1;
        solver.getEnvironment().worldPop();
        DecisionPath dp = solver.getDecisionPath();
        Decision decision = dp.getLastDecision();
        while (decision.getPosition() != stopAt) {
            int bound;
            int n = bound = this.isMinimization ? this.objectiveManager.getObjective().getLB() : this.objectiveManager.getObjective().getUB();
            if (decision.hasNext() && this.isValid(bound)) {
                this.opens.add(new Open(decision, dp, bound, this.isMinimization));
            }
            dp.synchronize();
            decision = dp.getLastDecision();
            solver.getEnvironment().worldPop();
        }
    }

    private boolean isValid(int bound) {
        return this.isMinimization ? bound < this.objectiveManager.getBestUB().intValue() : bound > this.objectiveManager.getBestLB().intValue();
    }

    private class Open
    implements Comparable<Open> {
        private final List<Decision> path = new ArrayList<Decision>();
        private final int currentBound;
        private final byte minimization;

        public Open(Decision decision, DecisionPath decisionPath, int currentBound, boolean minimization) {
            while (decision.getPosition() != MoveBinaryHBFS.this.topDecisionPosition) {
                Decision d2 = decision.duplicate();
                while (decision.triesLeft() != d2.triesLeft() - 1) {
                    d2.buildNext();
                }
                this.path.add(d2);
                decision = decisionPath.getDecision(decision.getPosition() - 1);
            }
            this.currentBound = currentBound;
            this.minimization = (byte)(minimization ? 1 : -1);
        }

        public Decision[] toArray() {
            return this.path.toArray(new Decision[0]);
        }

        public int currentBound() {
            return this.currentBound;
        }

        @Override
        public int compareTo(Open o) {
            int clb = this.minimization * (this.currentBound - o.currentBound);
            if (clb == 0) {
                return o.path.size() - this.path.size();
            }
            return clb;
        }

        public String toString() {
            StringBuilder st = new StringBuilder();
            st.append('[').append(this.currentBound).append(']');
            for (int i = this.path.size() - 1; i > -1; --i) {
                st.append(this.path.get(i)).append(',');
            }
            return st.toString();
        }
    }
}

