/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.propagation.PropagationEngine;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.ESat;

class RecursiveSearchLoop {
    RecursiveSearchLoop() {
    }

    public static int dfs(Model model, AbstractStrategy strategy) {
        int c2 = 0;
        try {
            model.getSolver().getEngine().propagate();
        }
        catch (ContradictionException e2) {
            return c2;
        }
        Decision dec = strategy.getDecision();
        if (dec != null) {
            model.getEnvironment().worldPush();
            try {
                dec.buildNext();
                dec.apply();
                c2 += RecursiveSearchLoop.dfs(model, strategy);
            }
            catch (ContradictionException cex) {
                model.getSolver().getEngine().flush();
            }
            model.getEnvironment().worldPop();
            model.getEnvironment().worldPush();
            try {
                dec.buildNext();
                dec.apply();
                c2 += RecursiveSearchLoop.dfs(model, strategy);
            }
            catch (ContradictionException cex) {
                model.getSolver().getEngine().flush();
            }
            model.getEnvironment().worldPop();
        } else {
            assert (model.getSolver().isSatisfied() == ESat.TRUE);
            ++c2;
        }
        return c2;
    }

    public static int lds(Model model, AbstractStrategy strategy, int dis) {
        int c2 = 0;
        try {
            model.getSolver().getEngine().propagate();
        }
        catch (ContradictionException e2) {
            return c2;
        }
        Decision dec = strategy.getDecision();
        if (dec != null) {
            model.getEnvironment().worldPush();
            try {
                dec.buildNext();
                dec.apply();
                c2 += RecursiveSearchLoop.lds(model, strategy, dis);
            }
            catch (ContradictionException cex) {
                model.getSolver().getEngine().flush();
            }
            model.getEnvironment().worldPop();
            if (dis > 0) {
                model.getEnvironment().worldPush();
                try {
                    dec.buildNext();
                    dec.apply();
                    c2 += RecursiveSearchLoop.lds(model, strategy, dis - 1);
                }
                catch (ContradictionException cex) {
                    model.getSolver().getEngine().flush();
                }
                model.getEnvironment().worldPop();
            }
        } else {
            assert (model.getSolver().isSatisfied() == ESat.TRUE);
            ++c2;
        }
        return c2;
    }

    public static int dds(Model model, AbstractStrategy strategy, int dis, int dep) {
        int c2 = 0;
        try {
            model.getSolver().getEngine().propagate();
        }
        catch (ContradictionException e2) {
            return c2;
        }
        Decision dec = strategy.getDecision();
        if (dec != null) {
            if (dep >= dis) {
                model.getEnvironment().worldPush();
                try {
                    dec.buildNext();
                    dec.apply();
                    c2 += RecursiveSearchLoop.ilds(model, strategy, dis, dep - 1);
                }
                catch (ContradictionException cex) {
                    model.getSolver().getEngine().flush();
                }
                model.getEnvironment().worldPop();
            } else {
                dec.buildNext();
            }
            if (dis > 0) {
                model.getEnvironment().worldPush();
                try {
                    dec.buildNext();
                    dec.apply();
                    c2 += RecursiveSearchLoop.ilds(model, strategy, dis - 1, dep);
                }
                catch (ContradictionException cex) {
                    model.getSolver().getEngine().flush();
                }
                model.getEnvironment().worldPop();
            }
        } else if (dis == 0) {
            assert (model.getSolver().isSatisfied() == ESat.TRUE);
            ++c2;
        }
        return c2;
    }

    public static int ilds(Model model, AbstractStrategy strategy, int dis, int dep) {
        int c2 = 0;
        try {
            model.getSolver().getEngine().propagate();
        }
        catch (ContradictionException e2) {
            return c2;
        }
        Decision dec = strategy.getDecision();
        if (dec != null) {
            if (dep >= dis) {
                model.getEnvironment().worldPush();
                try {
                    dec.buildNext();
                    dec.apply();
                    c2 += RecursiveSearchLoop.ilds(model, strategy, dis, dep - 1);
                }
                catch (ContradictionException cex) {
                    model.getSolver().getEngine().flush();
                }
                model.getEnvironment().worldPop();
            } else {
                dec.buildNext();
            }
            if (dis > 0) {
                model.getEnvironment().worldPush();
                try {
                    dec.buildNext();
                    dec.apply();
                    c2 += RecursiveSearchLoop.ilds(model, strategy, dis - 1, dep);
                }
                catch (ContradictionException cex) {
                    model.getSolver().getEngine().flush();
                }
                model.getEnvironment().worldPop();
            }
        } else if (dis == 0) {
            assert (model.getSolver().isSatisfied() == ESat.TRUE);
            ++c2;
        }
        return c2;
    }

    public static void main(String[] args) {
        Model model = new Model();
        IntVar[] X2 = model.intVarArray("X", 3, 0, 2, false);
        Solver r = model.getSolver();
        r.setEngine(new PropagationEngine(model));
        r.getEngine().initialize();
    }
}

