/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.cumulative;

import java.util.Arrays;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.cumulative.CumulFilter;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class TimeCumulFilter
extends CumulFilter {
    private int[] time = new int[31];

    public TimeCumulFilter(int nbMaxTasks) {
        super(nbMaxTasks);
    }

    @Override
    public void filter(IntVar[] s2, IntVar[] d2, IntVar[] e2, IntVar[] h2, IntVar capa, ISet tasks, Propagator<IntVar> aCause) throws ContradictionException {
        int min2 = 0x3FFFFFFF;
        int max = -1073741824;
        ISetIterator tIter = tasks.iterator();
        while (tIter.hasNext()) {
            int i = tIter.nextInt();
            if (s2[i].getUB() >= e2[i].getLB()) continue;
            min2 = Math.min(min2, s2[i].getUB());
            max = Math.max(max, e2[i].getLB());
        }
        if (min2 < max) {
            int hlb;
            int elb;
            if (max - min2 > this.time.length) {
                this.time = new int[max - min2];
            } else {
                Arrays.fill(this.time, 0, max - min2, 0);
            }
            int capaMax = capa.getUB();
            int maxC = 0;
            tIter = tasks.iterator();
            while (tIter.hasNext()) {
                int i = tIter.nextInt();
                elb = e2[i].getLB();
                hlb = h2[i].getLB();
                for (int t = s2[i].getUB(); t < elb; ++t) {
                    int n = t - min2;
                    this.time[n] = this.time[n] + hlb;
                    maxC = Math.max(maxC, this.time[t - min2]);
                }
            }
            capa.updateLowerBound(maxC, aCause);
            tIter = tasks.iterator();
            while (tIter.hasNext()) {
                int i = tIter.nextInt();
                if (h2[i].isInstantiated()) continue;
                int minH = h2[i].getUB();
                elb = e2[i].getLB();
                hlb = h2[i].getLB();
                for (int t = s2[i].getUB(); t < elb; ++t) {
                    minH = Math.min(minH, capaMax - (this.time[t - min2] - hlb));
                }
                h2[i].updateUpperBound(minH, aCause);
            }
            ISetIterator iSetIterator = tasks.iterator();
            while (iSetIterator.hasNext()) {
                int i = (Integer)iSetIterator.next();
                if (h2[i].getLB() <= 0) continue;
                if (s2[i].getLB() + d2[i].getLB() > min2) {
                    this.filterInf(s2[i], e2[i].getLB(), d2[i].getLB(), h2[i].getLB(), min2, max, this.time, capaMax, aCause);
                }
                if (e2[i].getUB() - d2[i].getLB() >= max) continue;
                this.filterSup(s2[i].getUB(), e2[i], d2[i].getLB(), h2[i].getLB(), min2, max, this.time, capaMax, aCause);
            }
        }
    }

    protected void filterInf(IntVar start, int elb, int dlb, int hlb, int min2, int max, int[] time, int capaMax, Propagator<IntVar> aCause) throws ContradictionException {
        int nbOk = 0;
        int sub = start.getUB();
        for (int t = start.getLB(); t < sub; ++t) {
            if (t < min2 || t >= max || hlb + time[t - min2] <= capaMax) {
                if (++nbOk != dlb) continue;
                return;
            }
            if (dlb == 0 && t >= elb) {
                return;
            }
            nbOk = 0;
            start.updateLowerBound(t + 1, aCause);
        }
    }

    protected void filterSup(int sub, IntVar end, int dlb, int hlb, int min2, int max, int[] time, int capaMax, Propagator<IntVar> aCause) throws ContradictionException {
        int nbOk = 0;
        int elb = end.getLB();
        for (int t = end.getUB(); t > elb; --t) {
            if (t - 1 < min2 || t - 1 >= max || hlb + time[t - min2 - 1] <= capaMax) {
                if (++nbOk != dlb) continue;
                return;
            }
            if (dlb == 0 && t <= sub) {
                return;
            }
            nbOk = 0;
            end.updateUpperBound(t - 1, aCause);
        }
    }
}

