/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.rescale;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.RenderedOp;
import javax.media.jai.iterator.RandomIter;

public class RescaleOpImage
extends PointOpImage {
    protected static final BorderExtender ROI_EXTENDER = BorderExtender.createInstance(0);
    private final double[] scaleFactors;
    private final double[] offsetArray;
    private final boolean hasNoData;
    private final boolean hasROI;
    private Range noData;
    private PlanarImage srcROIImage;
    private Rectangle roiBounds;
    private final boolean useROIAccessor;
    private boolean[] booleanLookupTable;
    private final boolean caseA;
    private final boolean caseB;
    private final boolean caseC;
    private byte[][] byteRescaleTable = null;
    private byte destinationNoDataByte;
    private short destinationNoDataShort;
    private int destinationNoDataInt;
    private float destinationNoDataFloat;
    private double destinationNoDataDouble;
    private RenderedOp srcROIImgExt;

    public RescaleOpImage(RenderedImage source, ImageLayout layout, Map configuration, double[] valueScale, double[] valueOffsets, double destinationNoData, ROI roi, Range noData, boolean useROIAccessor) {
        super(source, layout, configuration, true);
        boolean isByte;
        int i;
        int numBands = this.getSampleModel().getNumBands();
        if (valueScale.length < numBands && valueScale.length >= 1) {
            this.scaleFactors = new double[numBands];
            for (i = 0; i < numBands; ++i) {
                this.scaleFactors[i] = valueScale[0];
            }
        } else {
            if (valueScale.length < 1) {
                throw new IllegalArgumentException("Input Scale factor array should have almost dimension 1");
            }
            this.scaleFactors = valueScale;
        }
        if (valueOffsets.length < numBands && valueOffsets.length >= 1) {
            this.offsetArray = new double[numBands];
            for (i = 0; i < numBands; ++i) {
                this.offsetArray[i] = valueOffsets[0];
            }
        } else {
            if (valueOffsets.length < 1) {
                throw new IllegalArgumentException("Input offset array should have almost dimension 1");
            }
            this.offsetArray = valueOffsets;
        }
        this.permitInPlaceOperation();
        if (noData != null) {
            this.hasNoData = true;
            this.noData = noData;
        } else {
            this.hasNoData = false;
        }
        if (roi != null) {
            this.hasROI = true;
            ROI srcROI = roi;
            this.srcROIImage = srcROI.getAsImage();
            Rectangle srcRect = new Rectangle(source.getMinX(), source.getMinY(), source.getWidth(), source.getHeight());
            this.roiBounds = this.srcROIImage.getBounds();
            int deltaX0 = this.roiBounds.x - srcRect.x;
            int leftP = deltaX0 > 0 ? deltaX0 : 0;
            int deltaY0 = this.roiBounds.y - srcRect.y;
            int topP = deltaY0 > 0 ? deltaY0 : 0;
            int deltaX1 = srcRect.x + srcRect.width - this.roiBounds.x + this.roiBounds.width;
            int rightP = deltaX1 > 0 ? deltaX1 : 0;
            int deltaY1 = srcRect.y + srcRect.height - this.roiBounds.y + this.roiBounds.height;
            int bottomP = deltaY1 > 0 ? deltaY1 : 0;
            ParameterBlock pb = new ParameterBlock();
            pb.setSource(this.srcROIImage, 0);
            pb.set(leftP, 0);
            pb.set(rightP, 1);
            pb.set(topP, 2);
            pb.set(bottomP, 3);
            pb.set(ROI_EXTENDER, 4);
            this.srcROIImgExt = JAI.create("border", pb);
            this.useROIAccessor = useROIAccessor;
        } else {
            this.hasROI = false;
            this.useROIAccessor = false;
            this.roiBounds = null;
            this.srcROIImage = null;
        }
        int dataType = this.getSampleModel().getDataType();
        boolean bl = isByte = dataType == 0;
        if (this.hasNoData && isByte) {
            this.booleanLookupTable = new boolean[256];
            for (int i2 = 0; i2 < this.booleanLookupTable.length; ++i2) {
                byte value = (byte)i2;
                this.booleanLookupTable[i2] = !noData.contains(value);
            }
        }
        if (isByte) {
            this.byteRescaleTable = new byte[numBands][256];
            for (int b2 = 0; b2 < numBands; ++b2) {
                byte[] band = this.byteRescaleTable[b2];
                double c2 = this.scaleFactors[b2];
                double o = this.offsetArray[b2];
                for (int i3 = 0; i3 < 256; ++i3) {
                    band[i3] = ImageUtil.clampRoundByte((double)i3 * c2 + o);
                }
            }
        }
        this.caseA = !this.hasNoData && !this.hasROI;
        this.caseB = !this.hasNoData && this.hasROI;
        this.caseC = this.hasNoData && !this.hasROI;
        switch (dataType) {
            case 0: {
                this.destinationNoDataByte = ImageUtil.clampRoundByte(destinationNoData);
                break;
            }
            case 1: {
                this.destinationNoDataShort = ImageUtil.clampRoundUShort(destinationNoData);
                break;
            }
            case 2: {
                this.destinationNoDataShort = ImageUtil.clampRoundShort(destinationNoData);
                break;
            }
            case 3: {
                this.destinationNoDataInt = ImageUtil.clampRoundInt(destinationNoData);
                break;
            }
            case 4: {
                this.destinationNoDataFloat = (float)destinationNoData;
                break;
            }
            case 5: {
                this.destinationNoDataDouble = destinationNoData;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
    }

    @Override
    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        Raster tile = sources[0];
        RasterFormatTag[] formatTags = this.getFormatTags();
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor srcAccessor = new RasterAccessor(tile, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor destAccessor = new RasterAccessor(dest, destRect, formatTags[1], this.getColorModel());
        RasterAccessor roiAccessor = null;
        RandomIter roiIter = null;
        if (this.useROIAccessor) {
            Raster roiRaster = null;
            roiRaster = this.roiBounds.contains(srcRect) ? this.srcROIImage.getData(srcRect) : this.srcROIImgExt.getData(srcRect);
            roiAccessor = new RasterAccessor(roiRaster, srcRect, RasterAccessor.findCompatibleTags(new RenderedImage[]{this.srcROIImage}, this.srcROIImage)[0], this.srcROIImage.getColorModel());
        } else if (this.hasROI) {
            roiIter = RandomIterFactory.create(this.srcROIImage, this.srcROIImage.getBounds(), true, true);
        }
        int dataType = destAccessor.getDataType();
        switch (dataType) {
            case 0: {
                this.byteLoop(srcAccessor, destAccessor, roiAccessor, roiIter);
                break;
            }
            case 1: {
                this.ushortLoop(srcAccessor, destAccessor, roiAccessor, roiIter);
                break;
            }
            case 2: {
                this.shortLoop(srcAccessor, destAccessor, roiAccessor, roiIter);
                break;
            }
            case 3: {
                this.intLoop(srcAccessor, destAccessor, roiAccessor, roiIter);
                break;
            }
            case 4: {
                this.floatLoop(srcAccessor, destAccessor, roiAccessor, roiIter);
                break;
            }
            case 5: {
                this.doubleLoop(srcAccessor, destAccessor, roiAccessor, roiIter);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
        if (destAccessor.needsClamping()) {
            destAccessor.clampDataArrays();
        }
        destAccessor.copyDataToRaster();
    }

    private void byteLoop(RasterAccessor src, RasterAccessor dst, RasterAccessor roi, RandomIter roiIter) {
        int roiDataLength;
        int roiLineStride;
        byte[] roiDataArray;
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        byte[][] dstData = dst.getByteDataArrays();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        byte[][] srcData = src.getByteDataArrays();
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiLineStride = roi.getScanlineStride();
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiLineStride = 0;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int b2 = 0; b2 < dstBands; ++b2) {
                int dstLineOffset = dstBandOffsets[b2];
                int srcLineOffset = srcBandOffsets[b2];
                byte[] clamp = this.byteRescaleTable[b2];
                for (int y = 0; y < dstHeight; ++y) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dstLineStride;
                    srcLineOffset += srcLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        dstData[b2][dstPixelOffset] = clamp[srcData[b2][srcPixelOffset] & 0xFF];
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                int dstOffset = 0;
                int srcOffset = 0;
                for (int y = 0; y < dstHeight; ++y) {
                    int dstPixelOffset = dstOffset;
                    int srcPixelOffset = srcOffset;
                    int posyROI = y * roiLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        int b3;
                        int w;
                        int windex = x + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        if (w != 0) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                byte[] clamp = this.byteRescaleTable[b3];
                                dstData[b3][dstPixelOffset + dstBandOffsets[b3]] = clamp[srcData[b3][srcPixelOffset + srcBandOffsets[b3]] & 0xFF];
                            }
                        } else {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                dstData[b3][dstPixelOffset + dstBandOffsets[b3]] = this.destinationNoDataByte;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                    dstOffset += dstLineStride;
                    srcOffset += srcLineStride;
                }
            } else {
                int dstOffset = 0;
                int srcOffset = 0;
                for (int y = 0; y < dstHeight; ++y) {
                    int dstPixelOffset = dstOffset;
                    int srcPixelOffset = srcOffset;
                    for (int x = 0; x < dstWidth; ++x) {
                        int x0 = srcX + x;
                        int y0 = srcY + y;
                        if (this.roiBounds.contains(x0, y0)) {
                            int b4;
                            int w = roiIter.getSample(x0, y0, 0);
                            if (w != 0) {
                                for (b4 = 0; b4 < dstBands; ++b4) {
                                    byte[] clamp = this.byteRescaleTable[b4];
                                    dstData[b4][dstPixelOffset + dstBandOffsets[b4]] = clamp[srcData[b4][srcPixelOffset + srcBandOffsets[b4]] & 0xFF];
                                }
                            } else {
                                for (b4 = 0; b4 < dstBands; ++b4) {
                                    dstData[b4][dstPixelOffset + dstBandOffsets[b4]] = this.destinationNoDataByte;
                                }
                            }
                        } else {
                            for (int b5 = 0; b5 < dstBands; ++b5) {
                                dstData[b5][dstPixelOffset + dstBandOffsets[b5]] = this.destinationNoDataByte;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                    dstOffset += dstLineStride;
                    srcOffset += srcLineStride;
                }
            }
        } else if (this.caseC) {
            for (int b6 = 0; b6 < dstBands; ++b6) {
                int dstLineOffset = dstBandOffsets[b6];
                int srcLineOffset = srcBandOffsets[b6];
                byte[] clamp = this.byteRescaleTable[b6];
                byte[] bandDataIn = srcData[b6];
                byte[] bandDataOut = dstData[b6];
                for (int y = 0; y < dstHeight; ++y) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dstLineStride;
                    srcLineOffset += srcLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        int value = bandDataIn[srcPixelOffset] & 0xFF;
                        bandDataOut[dstPixelOffset] = this.booleanLookupTable[value] ? clamp[value] : this.destinationNoDataByte;
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            int dstOffset = 0;
            int srcOffset = 0;
            for (int y = 0; y < dstHeight; ++y) {
                int dstPixelOffset = dstOffset;
                int srcPixelOffset = srcOffset;
                int posyROI = y * roiLineStride;
                for (int x = 0; x < dstWidth; ++x) {
                    int b7;
                    int w;
                    int windex = x + posyROI;
                    int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                    if (w != 0) {
                        for (b7 = 0; b7 < dstBands; ++b7) {
                            int value = srcData[b7][srcPixelOffset + srcBandOffsets[b7]] & 0xFF;
                            if (this.booleanLookupTable[value]) {
                                byte[] clamp = this.byteRescaleTable[b7];
                                dstData[b7][dstPixelOffset + dstBandOffsets[b7]] = clamp[value];
                                continue;
                            }
                            dstData[b7][dstPixelOffset + dstBandOffsets[b7]] = this.destinationNoDataByte;
                        }
                    } else {
                        for (b7 = 0; b7 < dstBands; ++b7) {
                            dstData[b7][dstPixelOffset + dstBandOffsets[b7]] = this.destinationNoDataByte;
                        }
                    }
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
                dstOffset += dstLineStride;
                srcOffset += srcLineStride;
            }
        } else {
            int dstOffset = 0;
            int srcOffset = 0;
            for (int y = 0; y < dstHeight; ++y) {
                int dstPixelOffset = dstOffset;
                int srcPixelOffset = srcOffset;
                for (int x = 0; x < dstWidth; ++x) {
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (this.roiBounds.contains(x0, y0)) {
                        int b8;
                        int w = roiIter.getSample(x0, y0, 0);
                        if (w != 0) {
                            for (b8 = 0; b8 < dstBands; ++b8) {
                                int value = srcData[b8][srcPixelOffset + srcBandOffsets[b8]] & 0xFF;
                                if (this.booleanLookupTable[value]) {
                                    byte[] clamp = this.byteRescaleTable[b8];
                                    dstData[b8][dstPixelOffset + dstBandOffsets[b8]] = clamp[value];
                                    continue;
                                }
                                dstData[b8][dstPixelOffset + dstBandOffsets[b8]] = this.destinationNoDataByte;
                            }
                        } else {
                            for (b8 = 0; b8 < dstBands; ++b8) {
                                dstData[b8][dstPixelOffset + dstBandOffsets[b8]] = this.destinationNoDataByte;
                            }
                        }
                    } else {
                        for (int b9 = 0; b9 < dstBands; ++b9) {
                            dstData[b9][dstPixelOffset + dstBandOffsets[b9]] = this.destinationNoDataByte;
                        }
                    }
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
                dstOffset += dstLineStride;
                srcOffset += srcLineStride;
            }
        }
    }

    private void ushortLoop(RasterAccessor src, RasterAccessor dst, RasterAccessor roi, RandomIter roiIter) {
        int roiDataLength;
        int roiLineStride;
        byte[] roiDataArray;
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        short[][] dstData = dst.getShortDataArrays();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        short[][] srcData = src.getShortDataArrays();
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiLineStride = roi.getScanlineStride();
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiLineStride = 0;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int b2 = 0; b2 < dstBands; ++b2) {
                double scale = this.scaleFactors[b2];
                double offset = this.offsetArray[b2];
                int dstLineOffset = dstBandOffsets[b2];
                int srcLineOffset = srcBandOffsets[b2];
                for (int y = 0; y < dstHeight; ++y) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dstLineStride;
                    srcLineOffset += srcLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        dstData[b2][dstPixelOffset] = ImageUtil.clampRoundUShort((double)(srcData[b2][srcPixelOffset] & 0xFFFF) * scale + offset);
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                int dstOffset = 0;
                int srcOffset = 0;
                for (int y = 0; y < dstHeight; ++y) {
                    int dstPixelOffset = dstOffset;
                    int srcPixelOffset = srcOffset;
                    int posyROI = y * roiLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        int b3;
                        int w;
                        int windex = x + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        if (w != 0) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                double scale = this.scaleFactors[b3];
                                double offset = this.offsetArray[b3];
                                dstData[b3][dstPixelOffset + dstBandOffsets[b3]] = ImageUtil.clampRoundUShort((double)(srcData[b3][srcPixelOffset + srcBandOffsets[b3]] & 0xFFFF) * scale + offset);
                            }
                        } else {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                dstData[b3][dstPixelOffset + dstBandOffsets[b3]] = this.destinationNoDataShort;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                    dstOffset += dstLineStride;
                    srcOffset += srcLineStride;
                }
            } else {
                int dstOffset = 0;
                int srcOffset = 0;
                for (int y = 0; y < dstHeight; ++y) {
                    int dstPixelOffset = dstOffset;
                    int srcPixelOffset = srcOffset;
                    for (int x = 0; x < dstWidth; ++x) {
                        int x0 = srcX + x;
                        int y0 = srcY + y;
                        if (this.roiBounds.contains(x0, y0)) {
                            int b4;
                            int w = roiIter.getSample(x0, y0, 0);
                            if (w != 0) {
                                for (b4 = 0; b4 < dstBands; ++b4) {
                                    double scale = this.scaleFactors[b4];
                                    double offset = this.offsetArray[b4];
                                    dstData[b4][dstPixelOffset + dstBandOffsets[b4]] = ImageUtil.clampRoundUShort((double)(srcData[b4][srcPixelOffset + srcBandOffsets[b4]] & 0xFFFF) * scale + offset);
                                }
                            } else {
                                for (b4 = 0; b4 < dstBands; ++b4) {
                                    dstData[b4][dstPixelOffset + dstBandOffsets[b4]] = this.destinationNoDataShort;
                                }
                            }
                        } else {
                            for (int b5 = 0; b5 < dstBands; ++b5) {
                                dstData[b5][dstPixelOffset + dstBandOffsets[b5]] = this.destinationNoDataShort;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                    dstOffset += dstLineStride;
                    srcOffset += srcLineStride;
                }
            }
        } else if (this.caseC) {
            for (int b6 = 0; b6 < dstBands; ++b6) {
                double scale = this.scaleFactors[b6];
                double offset = this.offsetArray[b6];
                int dstLineOffset = dstBandOffsets[b6];
                int srcLineOffset = srcBandOffsets[b6];
                short[] bandDataIn = srcData[b6];
                short[] bandDataOut = dstData[b6];
                for (int y = 0; y < dstHeight; ++y) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dstLineStride;
                    srcLineOffset += srcLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        short value = bandDataIn[srcPixelOffset];
                        bandDataOut[dstPixelOffset] = !this.noData.contains(value) ? ImageUtil.clampRoundUShort((double)(value & 0xFFFF) * scale + offset) : this.destinationNoDataShort;
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            int dstOffset = 0;
            int srcOffset = 0;
            for (int y = 0; y < dstHeight; ++y) {
                int dstPixelOffset = dstOffset;
                int srcPixelOffset = srcOffset;
                int posyROI = y * roiLineStride;
                for (int x = 0; x < dstWidth; ++x) {
                    int b7;
                    int w;
                    int windex = x + posyROI;
                    int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                    if (w != 0) {
                        for (b7 = 0; b7 < dstBands; ++b7) {
                            short value = srcData[b7][srcPixelOffset + srcBandOffsets[b7]];
                            if (!this.noData.contains(value)) {
                                double scale = this.scaleFactors[b7];
                                double offset = this.offsetArray[b7];
                                dstData[b7][dstPixelOffset + dstBandOffsets[b7]] = ImageUtil.clampRoundUShort((double)(value & 0xFFFF) * scale + offset);
                                continue;
                            }
                            dstData[b7][dstPixelOffset + dstBandOffsets[b7]] = this.destinationNoDataShort;
                        }
                    } else {
                        for (b7 = 0; b7 < dstBands; ++b7) {
                            dstData[b7][dstPixelOffset + dstBandOffsets[b7]] = this.destinationNoDataShort;
                        }
                    }
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
                dstOffset += dstLineStride;
                srcOffset += srcLineStride;
            }
        } else {
            int dstOffset = 0;
            int srcOffset = 0;
            for (int y = 0; y < dstHeight; ++y) {
                int dstPixelOffset = dstOffset;
                int srcPixelOffset = srcOffset;
                for (int x = 0; x < dstWidth; ++x) {
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (this.roiBounds.contains(x0, y0)) {
                        int b8;
                        int w = roiIter.getSample(x0, y0, 0);
                        if (w != 0) {
                            for (b8 = 0; b8 < dstBands; ++b8) {
                                short value = srcData[b8][srcPixelOffset + srcBandOffsets[b8]];
                                if (!this.noData.contains(value)) {
                                    double scale = this.scaleFactors[b8];
                                    double offset = this.offsetArray[b8];
                                    dstData[b8][dstPixelOffset + dstBandOffsets[b8]] = ImageUtil.clampRoundUShort((double)(value & 0xFFFF) * scale + offset);
                                    continue;
                                }
                                dstData[b8][dstPixelOffset + dstBandOffsets[b8]] = this.destinationNoDataShort;
                            }
                        } else {
                            for (b8 = 0; b8 < dstBands; ++b8) {
                                dstData[b8][dstPixelOffset + dstBandOffsets[b8]] = this.destinationNoDataShort;
                            }
                        }
                    } else {
                        for (int b9 = 0; b9 < dstBands; ++b9) {
                            dstData[b9][dstPixelOffset + dstBandOffsets[b9]] = this.destinationNoDataShort;
                        }
                    }
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
                dstOffset += dstLineStride;
                srcOffset += srcLineStride;
            }
        }
    }

    private void shortLoop(RasterAccessor src, RasterAccessor dst, RasterAccessor roi, RandomIter roiIter) {
        int roiDataLength;
        int roiLineStride;
        byte[] roiDataArray;
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        short[][] dstData = dst.getShortDataArrays();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        short[][] srcData = src.getShortDataArrays();
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiLineStride = roi.getScanlineStride();
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiLineStride = 0;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int b2 = 0; b2 < dstBands; ++b2) {
                double scale = this.scaleFactors[b2];
                double offset = this.offsetArray[b2];
                int dstLineOffset = dstBandOffsets[b2];
                int srcLineOffset = srcBandOffsets[b2];
                for (int y = 0; y < dstHeight; ++y) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dstLineStride;
                    srcLineOffset += srcLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        dstData[b2][dstPixelOffset] = ImageUtil.clampRoundShort((double)srcData[b2][srcPixelOffset] * scale + offset);
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                int dstOffset = 0;
                int srcOffset = 0;
                for (int y = 0; y < dstHeight; ++y) {
                    int dstPixelOffset = dstOffset;
                    int srcPixelOffset = srcOffset;
                    int posyROI = y * roiLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        int b3;
                        int w;
                        int windex = x + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        if (w != 0) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                double scale = this.scaleFactors[b3];
                                double offset = this.offsetArray[b3];
                                dstData[b3][dstPixelOffset + dstBandOffsets[b3]] = ImageUtil.clampRoundShort((double)srcData[b3][srcPixelOffset + srcBandOffsets[b3]] * scale + offset);
                            }
                        } else {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                dstData[b3][dstPixelOffset + dstBandOffsets[b3]] = this.destinationNoDataShort;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                    dstOffset += dstLineStride;
                    srcOffset += srcLineStride;
                }
            } else {
                int dstOffset = 0;
                int srcOffset = 0;
                for (int y = 0; y < dstHeight; ++y) {
                    int dstPixelOffset = dstOffset;
                    int srcPixelOffset = srcOffset;
                    for (int x = 0; x < dstWidth; ++x) {
                        int x0 = srcX + x;
                        int y0 = srcY + y;
                        if (this.roiBounds.contains(x0, y0)) {
                            int b4;
                            int w = roiIter.getSample(x0, y0, 0);
                            if (w != 0) {
                                for (b4 = 0; b4 < dstBands; ++b4) {
                                    double scale = this.scaleFactors[b4];
                                    double offset = this.offsetArray[b4];
                                    dstData[b4][dstPixelOffset + dstBandOffsets[b4]] = ImageUtil.clampRoundShort((double)srcData[b4][srcPixelOffset + srcBandOffsets[b4]] * scale + offset);
                                }
                            } else {
                                for (b4 = 0; b4 < dstBands; ++b4) {
                                    dstData[b4][dstPixelOffset + dstBandOffsets[b4]] = this.destinationNoDataShort;
                                }
                            }
                        } else {
                            for (int b5 = 0; b5 < dstBands; ++b5) {
                                dstData[b5][dstPixelOffset + dstBandOffsets[b5]] = this.destinationNoDataShort;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                    dstOffset += dstLineStride;
                    srcOffset += srcLineStride;
                }
            }
        } else if (this.caseC) {
            for (int b6 = 0; b6 < dstBands; ++b6) {
                double scale = this.scaleFactors[b6];
                double offset = this.offsetArray[b6];
                int dstLineOffset = dstBandOffsets[b6];
                int srcLineOffset = srcBandOffsets[b6];
                short[] bandDataIn = srcData[b6];
                short[] bandDataOut = dstData[b6];
                for (int y = 0; y < dstHeight; ++y) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dstLineStride;
                    srcLineOffset += srcLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        short value = bandDataIn[srcPixelOffset];
                        bandDataOut[dstPixelOffset] = !this.noData.contains(value) ? ImageUtil.clampRoundShort((double)value * scale + offset) : this.destinationNoDataShort;
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            int dstOffset = 0;
            int srcOffset = 0;
            for (int y = 0; y < dstHeight; ++y) {
                int dstPixelOffset = dstOffset;
                int srcPixelOffset = srcOffset;
                int posyROI = y * roiLineStride;
                for (int x = 0; x < dstWidth; ++x) {
                    int b7;
                    int w;
                    int windex = x + posyROI;
                    int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                    if (w != 0) {
                        for (b7 = 0; b7 < dstBands; ++b7) {
                            short value = srcData[b7][srcPixelOffset + srcBandOffsets[b7]];
                            if (!this.noData.contains(value)) {
                                double scale = this.scaleFactors[b7];
                                double offset = this.offsetArray[b7];
                                dstData[b7][dstPixelOffset + dstBandOffsets[b7]] = ImageUtil.clampRoundShort((double)value * scale + offset);
                                continue;
                            }
                            dstData[b7][dstPixelOffset + dstBandOffsets[b7]] = this.destinationNoDataShort;
                        }
                    } else {
                        for (b7 = 0; b7 < dstBands; ++b7) {
                            dstData[b7][dstPixelOffset + dstBandOffsets[b7]] = this.destinationNoDataShort;
                        }
                    }
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
                dstOffset += dstLineStride;
                srcOffset += srcLineStride;
            }
        } else {
            int dstOffset = 0;
            int srcOffset = 0;
            for (int y = 0; y < dstHeight; ++y) {
                int dstPixelOffset = dstOffset;
                int srcPixelOffset = srcOffset;
                for (int x = 0; x < dstWidth; ++x) {
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (this.roiBounds.contains(x0, y0)) {
                        int b8;
                        int w = roiIter.getSample(x0, y0, 0);
                        if (w != 0) {
                            for (b8 = 0; b8 < dstBands; ++b8) {
                                short value = srcData[b8][srcPixelOffset + srcBandOffsets[b8]];
                                if (!this.noData.contains(value)) {
                                    double scale = this.scaleFactors[b8];
                                    double offset = this.offsetArray[b8];
                                    dstData[b8][dstPixelOffset + dstBandOffsets[b8]] = ImageUtil.clampRoundShort((double)value * scale + offset);
                                    continue;
                                }
                                dstData[b8][dstPixelOffset + dstBandOffsets[b8]] = this.destinationNoDataShort;
                            }
                        } else {
                            for (b8 = 0; b8 < dstBands; ++b8) {
                                dstData[b8][dstPixelOffset + dstBandOffsets[b8]] = this.destinationNoDataShort;
                            }
                        }
                    } else {
                        for (int b9 = 0; b9 < dstBands; ++b9) {
                            dstData[b9][dstPixelOffset + dstBandOffsets[b9]] = this.destinationNoDataShort;
                        }
                    }
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
                dstOffset += dstLineStride;
                srcOffset += srcLineStride;
            }
        }
    }

    private void intLoop(RasterAccessor src, RasterAccessor dst, RasterAccessor roi, RandomIter roiIter) {
        int roiDataLength;
        int roiLineStride;
        byte[] roiDataArray;
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        int[][] dstData = dst.getIntDataArrays();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        int[][] srcData = src.getIntDataArrays();
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiLineStride = roi.getScanlineStride();
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiLineStride = 0;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int b2 = 0; b2 < dstBands; ++b2) {
                double scale = this.scaleFactors[b2];
                double offset = this.offsetArray[b2];
                int dstLineOffset = dstBandOffsets[b2];
                int srcLineOffset = srcBandOffsets[b2];
                for (int y = 0; y < dstHeight; ++y) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dstLineStride;
                    srcLineOffset += srcLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        dstData[b2][dstPixelOffset] = ImageUtil.clampRoundInt((double)srcData[b2][srcPixelOffset] * scale + offset);
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                int dstOffset = 0;
                int srcOffset = 0;
                for (int y = 0; y < dstHeight; ++y) {
                    int dstPixelOffset = dstOffset;
                    int srcPixelOffset = srcOffset;
                    int posyROI = y * roiLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        int b3;
                        int w;
                        int windex = x + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        if (w != 0) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                double scale = this.scaleFactors[b3];
                                double offset = this.offsetArray[b3];
                                dstData[b3][dstPixelOffset + dstBandOffsets[b3]] = ImageUtil.clampRoundInt((double)srcData[b3][srcPixelOffset + srcBandOffsets[b3]] * scale + offset);
                            }
                        } else {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                dstData[b3][dstPixelOffset + dstBandOffsets[b3]] = this.destinationNoDataInt;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                    dstOffset += dstLineStride;
                    srcOffset += srcLineStride;
                }
            } else {
                int dstOffset = 0;
                int srcOffset = 0;
                for (int y = 0; y < dstHeight; ++y) {
                    int dstPixelOffset = dstOffset;
                    int srcPixelOffset = srcOffset;
                    for (int x = 0; x < dstWidth; ++x) {
                        int x0 = srcX + x;
                        int y0 = srcY + y;
                        if (this.roiBounds.contains(x0, y0)) {
                            int b4;
                            int w = roiIter.getSample(x0, y0, 0);
                            if (w != 0) {
                                for (b4 = 0; b4 < dstBands; ++b4) {
                                    double scale = this.scaleFactors[b4];
                                    double offset = this.offsetArray[b4];
                                    dstData[b4][dstPixelOffset + dstBandOffsets[b4]] = ImageUtil.clampRoundInt((double)srcData[b4][srcPixelOffset + srcBandOffsets[b4]] * scale + offset);
                                }
                            } else {
                                for (b4 = 0; b4 < dstBands; ++b4) {
                                    dstData[b4][dstPixelOffset + dstBandOffsets[b4]] = this.destinationNoDataInt;
                                }
                            }
                        } else {
                            for (int b5 = 0; b5 < dstBands; ++b5) {
                                dstData[b5][dstPixelOffset + dstBandOffsets[b5]] = this.destinationNoDataInt;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                    dstOffset += dstLineStride;
                    srcOffset += srcLineStride;
                }
            }
        } else if (this.caseC) {
            for (int b6 = 0; b6 < dstBands; ++b6) {
                double scale = this.scaleFactors[b6];
                double offset = this.offsetArray[b6];
                int dstLineOffset = dstBandOffsets[b6];
                int srcLineOffset = srcBandOffsets[b6];
                int[] bandDataIn = srcData[b6];
                int[] bandDataOut = dstData[b6];
                for (int y = 0; y < dstHeight; ++y) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dstLineStride;
                    srcLineOffset += srcLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        int value = bandDataIn[srcPixelOffset];
                        bandDataOut[dstPixelOffset] = !this.noData.contains(value) ? ImageUtil.clampRoundInt((double)value * scale + offset) : this.destinationNoDataInt;
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            int dstOffset = 0;
            int srcOffset = 0;
            for (int y = 0; y < dstHeight; ++y) {
                int dstPixelOffset = dstOffset;
                int srcPixelOffset = srcOffset;
                int posyROI = y * roiLineStride;
                for (int x = 0; x < dstWidth; ++x) {
                    int b7;
                    int w;
                    int windex = x + posyROI;
                    int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                    if (w != 0) {
                        for (b7 = 0; b7 < dstBands; ++b7) {
                            int value = srcData[b7][srcPixelOffset + srcBandOffsets[b7]];
                            if (!this.noData.contains(value)) {
                                double scale = this.scaleFactors[b7];
                                double offset = this.offsetArray[b7];
                                dstData[b7][dstPixelOffset + dstBandOffsets[b7]] = ImageUtil.clampRoundInt((double)value * scale + offset);
                                continue;
                            }
                            dstData[b7][dstPixelOffset + dstBandOffsets[b7]] = this.destinationNoDataInt;
                        }
                    } else {
                        for (b7 = 0; b7 < dstBands; ++b7) {
                            dstData[b7][dstPixelOffset + dstBandOffsets[b7]] = this.destinationNoDataInt;
                        }
                    }
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
                dstOffset += dstLineStride;
                srcOffset += srcLineStride;
            }
        } else {
            int dstOffset = 0;
            int srcOffset = 0;
            for (int y = 0; y < dstHeight; ++y) {
                int dstPixelOffset = dstOffset;
                int srcPixelOffset = srcOffset;
                for (int x = 0; x < dstWidth; ++x) {
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (this.roiBounds.contains(x0, y0)) {
                        int b8;
                        int w = roiIter.getSample(x0, y0, 0);
                        if (w != 0) {
                            for (b8 = 0; b8 < dstBands; ++b8) {
                                int value = srcData[b8][srcPixelOffset + srcBandOffsets[b8]];
                                if (!this.noData.contains(value)) {
                                    double scale = this.scaleFactors[b8];
                                    double offset = this.offsetArray[b8];
                                    dstData[b8][dstPixelOffset + dstBandOffsets[b8]] = ImageUtil.clampRoundInt((double)value * scale + offset);
                                    continue;
                                }
                                dstData[b8][dstPixelOffset + dstBandOffsets[b8]] = this.destinationNoDataInt;
                            }
                        } else {
                            for (b8 = 0; b8 < dstBands; ++b8) {
                                dstData[b8][dstPixelOffset + dstBandOffsets[b8]] = this.destinationNoDataInt;
                            }
                        }
                    } else {
                        for (int b9 = 0; b9 < dstBands; ++b9) {
                            dstData[b9][dstPixelOffset + dstBandOffsets[b9]] = this.destinationNoDataInt;
                        }
                    }
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
                dstOffset += dstLineStride;
                srcOffset += srcLineStride;
            }
        }
    }

    private void floatLoop(RasterAccessor src, RasterAccessor dst, RasterAccessor roi, RandomIter roiIter) {
        int roiDataLength;
        int roiLineStride;
        byte[] roiDataArray;
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        float[][] dstData = dst.getFloatDataArrays();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        float[][] srcData = src.getFloatDataArrays();
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiLineStride = roi.getScanlineStride();
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiLineStride = 0;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int b2 = 0; b2 < dstBands; ++b2) {
                double scale = this.scaleFactors[b2];
                double offset = this.offsetArray[b2];
                int dstLineOffset = dstBandOffsets[b2];
                int srcLineOffset = srcBandOffsets[b2];
                for (int y = 0; y < dstHeight; ++y) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dstLineStride;
                    srcLineOffset += srcLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        dstData[b2][dstPixelOffset] = (float)((double)srcData[b2][srcPixelOffset] * scale + offset);
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                int dstOffset = 0;
                int srcOffset = 0;
                for (int y = 0; y < dstHeight; ++y) {
                    int dstPixelOffset = dstOffset;
                    int srcPixelOffset = srcOffset;
                    int posyROI = y * roiLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        int b3;
                        int w;
                        int windex = x + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        if (w != 0) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                double scale = this.scaleFactors[b3];
                                double offset = this.offsetArray[b3];
                                dstData[b3][dstPixelOffset + dstBandOffsets[b3]] = (float)((double)srcData[b3][srcPixelOffset + srcBandOffsets[b3]] * scale + offset);
                            }
                        } else {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                dstData[b3][dstPixelOffset + dstBandOffsets[b3]] = this.destinationNoDataFloat;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                    dstOffset += dstLineStride;
                    srcOffset += srcLineStride;
                }
            } else {
                int dstOffset = 0;
                int srcOffset = 0;
                for (int y = 0; y < dstHeight; ++y) {
                    int dstPixelOffset = dstOffset;
                    int srcPixelOffset = srcOffset;
                    for (int x = 0; x < dstWidth; ++x) {
                        int x0 = srcX + x;
                        int y0 = srcY + y;
                        if (this.roiBounds.contains(x0, y0)) {
                            int b4;
                            int w = roiIter.getSample(x0, y0, 0);
                            if (w != 0) {
                                for (b4 = 0; b4 < dstBands; ++b4) {
                                    double scale = this.scaleFactors[b4];
                                    double offset = this.offsetArray[b4];
                                    dstData[b4][dstPixelOffset + dstBandOffsets[b4]] = (float)((double)srcData[b4][srcPixelOffset + srcBandOffsets[b4]] * scale + offset);
                                }
                            } else {
                                for (b4 = 0; b4 < dstBands; ++b4) {
                                    dstData[b4][dstPixelOffset + dstBandOffsets[b4]] = this.destinationNoDataFloat;
                                }
                            }
                        } else {
                            for (int b5 = 0; b5 < dstBands; ++b5) {
                                dstData[b5][dstPixelOffset + dstBandOffsets[b5]] = this.destinationNoDataFloat;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                    dstOffset += dstLineStride;
                    srcOffset += srcLineStride;
                }
            }
        } else if (this.caseC) {
            for (int b6 = 0; b6 < dstBands; ++b6) {
                double scale = this.scaleFactors[b6];
                double offset = this.offsetArray[b6];
                int dstLineOffset = dstBandOffsets[b6];
                int srcLineOffset = srcBandOffsets[b6];
                float[] bandDataIn = srcData[b6];
                float[] bandDataOut = dstData[b6];
                for (int y = 0; y < dstHeight; ++y) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dstLineStride;
                    srcLineOffset += srcLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        float value = bandDataIn[srcPixelOffset];
                        bandDataOut[dstPixelOffset] = !this.noData.contains(value) ? (float)((double)value * scale + offset) : this.destinationNoDataFloat;
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            int dstOffset = 0;
            int srcOffset = 0;
            for (int y = 0; y < dstHeight; ++y) {
                int dstPixelOffset = dstOffset;
                int srcPixelOffset = srcOffset;
                int posyROI = y * roiLineStride;
                for (int x = 0; x < dstWidth; ++x) {
                    int b7;
                    int w;
                    int windex = x + posyROI;
                    int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                    if (w != 0) {
                        for (b7 = 0; b7 < dstBands; ++b7) {
                            float value = srcData[b7][srcPixelOffset + srcBandOffsets[b7]];
                            if (!this.noData.contains(value)) {
                                double scale = this.scaleFactors[b7];
                                double offset = this.offsetArray[b7];
                                dstData[b7][dstPixelOffset + dstBandOffsets[b7]] = (float)((double)value * scale + offset);
                                continue;
                            }
                            dstData[b7][dstPixelOffset + dstBandOffsets[b7]] = this.destinationNoDataFloat;
                        }
                    } else {
                        for (b7 = 0; b7 < dstBands; ++b7) {
                            dstData[b7][dstPixelOffset + dstBandOffsets[b7]] = this.destinationNoDataFloat;
                        }
                    }
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
                dstOffset += dstLineStride;
                srcOffset += srcLineStride;
            }
        } else {
            int dstOffset = 0;
            int srcOffset = 0;
            for (int y = 0; y < dstHeight; ++y) {
                int dstPixelOffset = dstOffset;
                int srcPixelOffset = srcOffset;
                for (int x = 0; x < dstWidth; ++x) {
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (this.roiBounds.contains(x0, y0)) {
                        int b8;
                        int w = roiIter.getSample(x0, y0, 0);
                        if (w != 0) {
                            for (b8 = 0; b8 < dstBands; ++b8) {
                                float value = srcData[b8][srcPixelOffset + srcBandOffsets[b8]];
                                if (!this.noData.contains(value)) {
                                    double scale = this.scaleFactors[b8];
                                    double offset = this.offsetArray[b8];
                                    dstData[b8][dstPixelOffset + dstBandOffsets[b8]] = (float)((double)value * scale + offset);
                                    continue;
                                }
                                dstData[b8][dstPixelOffset + dstBandOffsets[b8]] = this.destinationNoDataFloat;
                            }
                        } else {
                            for (b8 = 0; b8 < dstBands; ++b8) {
                                dstData[b8][dstPixelOffset + dstBandOffsets[b8]] = this.destinationNoDataFloat;
                            }
                        }
                    } else {
                        for (int b9 = 0; b9 < dstBands; ++b9) {
                            dstData[b9][dstPixelOffset + dstBandOffsets[b9]] = this.destinationNoDataFloat;
                        }
                    }
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
                dstOffset += dstLineStride;
                srcOffset += srcLineStride;
            }
        }
    }

    private void doubleLoop(RasterAccessor src, RasterAccessor dst, RasterAccessor roi, RandomIter roiIter) {
        int roiDataLength;
        int roiLineStride;
        byte[] roiDataArray;
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        double[][] dstData = dst.getDoubleDataArrays();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        double[][] srcData = src.getDoubleDataArrays();
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiLineStride = roi.getScanlineStride();
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiLineStride = 0;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int b2 = 0; b2 < dstBands; ++b2) {
                double scale = this.scaleFactors[b2];
                double offset = this.offsetArray[b2];
                int dstLineOffset = dstBandOffsets[b2];
                int srcLineOffset = srcBandOffsets[b2];
                for (int y = 0; y < dstHeight; ++y) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dstLineStride;
                    srcLineOffset += srcLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        dstData[b2][dstPixelOffset] = srcData[b2][srcPixelOffset] * scale + offset;
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                int dstOffset = 0;
                int srcOffset = 0;
                for (int y = 0; y < dstHeight; ++y) {
                    int dstPixelOffset = dstOffset;
                    int srcPixelOffset = srcOffset;
                    int posyROI = y * roiLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        int b3;
                        int w;
                        int windex = x + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        if (w != 0) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                double scale = this.scaleFactors[b3];
                                double offset = this.offsetArray[b3];
                                dstData[b3][dstPixelOffset + dstBandOffsets[b3]] = srcData[b3][srcPixelOffset + srcBandOffsets[b3]] * scale + offset;
                            }
                        } else {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                dstData[b3][dstPixelOffset + dstBandOffsets[b3]] = this.destinationNoDataDouble;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                    dstOffset += dstLineStride;
                    srcOffset += srcLineStride;
                }
            } else {
                int dstOffset = 0;
                int srcOffset = 0;
                for (int y = 0; y < dstHeight; ++y) {
                    int dstPixelOffset = dstOffset;
                    int srcPixelOffset = srcOffset;
                    for (int x = 0; x < dstWidth; ++x) {
                        int x0 = srcX + x;
                        int y0 = srcY + y;
                        if (this.roiBounds.contains(x0, y0)) {
                            int b4;
                            int w = roiIter.getSample(x0, y0, 0);
                            if (w != 0) {
                                for (b4 = 0; b4 < dstBands; ++b4) {
                                    double scale = this.scaleFactors[b4];
                                    double offset = this.offsetArray[b4];
                                    dstData[b4][dstPixelOffset + dstBandOffsets[b4]] = srcData[b4][srcPixelOffset + srcBandOffsets[b4]] * scale + offset;
                                }
                            } else {
                                for (b4 = 0; b4 < dstBands; ++b4) {
                                    dstData[b4][dstPixelOffset + dstBandOffsets[b4]] = this.destinationNoDataDouble;
                                }
                            }
                        } else {
                            for (int b5 = 0; b5 < dstBands; ++b5) {
                                dstData[b5][dstPixelOffset + dstBandOffsets[b5]] = this.destinationNoDataDouble;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                    dstOffset += dstLineStride;
                    srcOffset += srcLineStride;
                }
            }
        } else if (this.caseC) {
            for (int b6 = 0; b6 < dstBands; ++b6) {
                double scale = this.scaleFactors[b6];
                double offset = this.offsetArray[b6];
                int dstLineOffset = dstBandOffsets[b6];
                int srcLineOffset = srcBandOffsets[b6];
                for (int y = 0; y < dstHeight; ++y) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dstLineStride;
                    srcLineOffset += srcLineStride;
                    double[] bandDataIn = srcData[b6];
                    double[] bandDataOut = dstData[b6];
                    for (int x = 0; x < dstWidth; ++x) {
                        double value = bandDataIn[srcPixelOffset];
                        bandDataOut[dstPixelOffset] = !this.noData.contains(value) ? value * scale + offset : this.destinationNoDataDouble;
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            int dstOffset = 0;
            int srcOffset = 0;
            for (int y = 0; y < dstHeight; ++y) {
                int dstPixelOffset = dstOffset;
                int srcPixelOffset = srcOffset;
                int posyROI = y * roiLineStride;
                for (int x = 0; x < dstWidth; ++x) {
                    int b7;
                    int w;
                    int windex = x + posyROI;
                    int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                    if (w != 0) {
                        for (b7 = 0; b7 < dstBands; ++b7) {
                            double value = srcData[b7][srcPixelOffset + srcBandOffsets[b7]];
                            if (!this.noData.contains(value)) {
                                double scale = this.scaleFactors[b7];
                                double offset = this.offsetArray[b7];
                                dstData[b7][dstPixelOffset + dstBandOffsets[b7]] = value * scale + offset;
                                continue;
                            }
                            dstData[b7][dstPixelOffset + dstBandOffsets[b7]] = this.destinationNoDataDouble;
                        }
                    } else {
                        for (b7 = 0; b7 < dstBands; ++b7) {
                            dstData[b7][dstPixelOffset + dstBandOffsets[b7]] = this.destinationNoDataDouble;
                        }
                    }
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
                dstOffset += dstLineStride;
                srcOffset += srcLineStride;
            }
        } else {
            int dstOffset = 0;
            int srcOffset = 0;
            for (int y = 0; y < dstHeight; ++y) {
                int dstPixelOffset = dstOffset;
                int srcPixelOffset = srcOffset;
                for (int x = 0; x < dstWidth; ++x) {
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (this.roiBounds.contains(x0, y0)) {
                        int b8;
                        int w = roiIter.getSample(x0, y0, 0);
                        if (w != 0) {
                            for (b8 = 0; b8 < dstBands; ++b8) {
                                double value = srcData[b8][srcPixelOffset + srcBandOffsets[b8]];
                                if (!this.noData.contains(value)) {
                                    double scale = this.scaleFactors[b8];
                                    double offset = this.offsetArray[b8];
                                    dstData[b8][dstPixelOffset + dstBandOffsets[b8]] = value * scale + offset;
                                    continue;
                                }
                                dstData[b8][dstPixelOffset + dstBandOffsets[b8]] = this.destinationNoDataDouble;
                            }
                        } else {
                            for (b8 = 0; b8 < dstBands; ++b8) {
                                dstData[b8][dstPixelOffset + dstBandOffsets[b8]] = this.destinationNoDataDouble;
                            }
                        }
                    } else {
                        for (int b9 = 0; b9 < dstBands; ++b9) {
                            dstData[b9][dstPixelOffset + dstBandOffsets[b9]] = this.destinationNoDataDouble;
                        }
                    }
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
                dstOffset += dstLineStride;
                srcOffset += srcLineStride;
            }
        }
    }

    @Override
    public synchronized void dispose() {
        if (this.srcROIImgExt != null) {
            this.srcROIImgExt.dispose();
        }
        super.dispose();
    }
}

