/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.piecewise;

import it.geosolutions.jaiext.piecewise.DefaultConstantPiecewiseTransformElement;
import it.geosolutions.jaiext.piecewise.DefaultDomainElement1D;
import it.geosolutions.jaiext.piecewise.DefaultLinearPiecewiseTransform1DElement;
import it.geosolutions.jaiext.piecewise.DefaultPassthroughPiecewiseTransform1DElement;
import it.geosolutions.jaiext.piecewise.MathTransformation;
import it.geosolutions.jaiext.piecewise.NoninvertibleTransformException;
import it.geosolutions.jaiext.piecewise.PiecewiseTransform1DElement;
import it.geosolutions.jaiext.piecewise.PiecewiseUtilities;
import it.geosolutions.jaiext.piecewise.Position;
import it.geosolutions.jaiext.piecewise.TransformationException;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;

public class DefaultPiecewiseTransform1DElement
extends DefaultDomainElement1D
implements PiecewiseTransform1DElement {
    private static final long serialVersionUID = 7422178060824402864L;
    private MathTransformation transform;
    private MathTransformation inverse;
    private int hashCode = -1;

    public static DefaultPiecewiseTransform1DElement create(CharSequence name, Range inRange, double value) {
        return new DefaultConstantPiecewiseTransformElement(name, inRange, value);
    }

    public static DefaultPiecewiseTransform1DElement create(CharSequence name, Range inRange, byte value) {
        return new DefaultConstantPiecewiseTransformElement(name, inRange, value);
    }

    public static DefaultPiecewiseTransform1DElement create(CharSequence name, Range inRange, int value) {
        return new DefaultConstantPiecewiseTransformElement(name, inRange, value);
    }

    public static DefaultPiecewiseTransform1DElement create(CharSequence name, Range inRange, Range outRange) {
        return new DefaultLinearPiecewiseTransform1DElement(name, inRange, outRange);
    }

    public static DefaultPiecewiseTransform1DElement create(CharSequence name) throws IllegalArgumentException {
        return new DefaultPassthroughPiecewiseTransform1DElement(name, RangeFactory.create(Double.NEGATIVE_INFINITY, true, Double.POSITIVE_INFINITY, true, true));
    }

    public static DefaultPiecewiseTransform1DElement create(CharSequence name, Range valueRange) throws IllegalArgumentException {
        return new DefaultPassthroughPiecewiseTransform1DElement(name, valueRange);
    }

    public DefaultPiecewiseTransform1DElement(CharSequence name, Range valueRange) throws IllegalArgumentException {
        super(name, valueRange);
    }

    public DefaultPiecewiseTransform1DElement(CharSequence name, Range valueRange, MathTransformation transform) throws IllegalArgumentException {
        super(name, valueRange);
        PiecewiseUtilities.ensureNonNull("transform", transform);
        this.transform = transform;
    }

    protected synchronized MathTransformation getTransform() {
        return this.transform;
    }

    @Override
    public synchronized double transform(double value) throws TransformationException {
        if (this.transform == null) {
            throw new IllegalStateException();
        }
        if (this.contains(value)) {
            return this.transform.transform(value);
        }
        throw new IllegalArgumentException("Provided value is not contained in this domain");
    }

    public Position transform(Position ptSrc, Position ptDst) throws TransformationException {
        if (ptDst == null) {
            ptDst = new Position();
        }
        ptDst.setOrdinatePosition(this.transform(ptSrc.getOrdinatePosition()));
        return ptDst;
    }

    public int getSourceDimensions() {
        return this.transform.getSourceDimensions();
    }

    public int getTargetDimensions() {
        return this.transform.getTargetDimensions();
    }

    public synchronized MathTransformation inverse() throws NoninvertibleTransformException {
        if (this.inverse != null) {
            return this.inverse;
        }
        if (this.transform == null) {
            throw new IllegalStateException();
        }
        this.inverse = this.transform.inverseTransform();
        return this.inverse;
    }

    public boolean isIdentity() {
        return this.transform.isIdentity();
    }

    protected synchronized void setInverse(MathTransformation mathTransform) {
        if (this.inverse != null) {
            throw new IllegalStateException();
        }
        this.inverse = mathTransform;
    }

    protected synchronized void setTransform(MathTransformation transform) {
        PiecewiseUtilities.ensureNonNull("transform", transform);
        if (this.transform != null) {
            throw new IllegalStateException();
        }
        this.transform = transform;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DefaultPiecewiseTransform1DElement)) {
            return false;
        }
        DefaultPiecewiseTransform1DElement that = (DefaultPiecewiseTransform1DElement)obj;
        if (this.getEquivalenceClass() != that.getEquivalenceClass()) {
            return false;
        }
        if (!PiecewiseUtilities.equals(this.transform, that.transform)) {
            return false;
        }
        if (!PiecewiseUtilities.equals(this.inverse, that.inverse)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    protected Class<?> getEquivalenceClass() {
        return DefaultPiecewiseTransform1DElement.class;
    }

    @Override
    public int hashCode() {
        if (this.hashCode >= 0) {
            return this.hashCode;
        }
        this.hashCode = 37;
        this.hashCode = PiecewiseUtilities.hash(this.transform, this.hashCode);
        this.hashCode = PiecewiseUtilities.hash(this.inverse, this.hashCode);
        this.hashCode = PiecewiseUtilities.hash(super.hashCode(), this.hashCode);
        return this.hashCode;
    }

    public static DefaultPiecewiseTransform1DElement create(String string, Range range, MathTransformation mathTransform1D) {
        return new DefaultPiecewiseTransform1DElement(string, range, mathTransform1D);
    }
}

