/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.orderdither;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.orderdither.JaiI18N;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.media.jai.ColorCube;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.iterator.RandomIter;

public class OrderedDitherOpImage
extends PointOpImage {
    public static final boolean ARRAY_CALC = true;
    public static final boolean TILE_CACHED = true;
    private static final int TYPE_OD_GENERAL = 0;
    private static final int TYPE_OD_BYTE_LUT_3BAND = 1;
    private static final int TYPE_OD_BYTE_LUT_NBAND = 2;
    private static final int DITHER_LUT_LENGTH_MAX = 262144;
    private static final int DITHER_LUT_CACHE_LENGTH_MAX = 4;
    private static ArrayList ditherLUTCache = new ArrayList(4);
    private int odType = 0;
    protected int numBands;
    protected int[] dims;
    protected int[] mults;
    protected int adjustedOffset;
    protected int maskWidth;
    protected int maskHeight;
    protected byte[][] maskDataByte;
    protected int[][] maskDataInt;
    protected long[][] maskDataLong;
    protected float[][] maskDataFloat;
    protected DitherLUT odLUT = null;
    private final boolean hasNoData;
    private final boolean hasROI;
    private Range nodata;
    private ROI roi;
    private Rectangle roiBounds;
    private boolean caseA;
    private boolean caseB;
    private boolean caseC;
    private PlanarImage roiImage;
    private double destNoData;
    private boolean[] lut;

    private static ImageLayout layoutHelper(ImageLayout layout, RenderedImage source, ColorCube colorMap) {
        ColorModel cm;
        ImageLayout il = layout == null ? new ImageLayout(source) : (ImageLayout)layout.clone();
        SampleModel sm = il.getSampleModel(source);
        if (colorMap.getNumBands() == 1 && colorMap.getNumEntries() == 2 && !ImageUtil.isBinary(il.getSampleModel(source))) {
            sm = new MultiPixelPackedSampleModel(0, il.getTileWidth(source), il.getTileHeight(source), 1);
            il.setSampleModel(sm);
        }
        if (sm.getNumBands() != 1) {
            sm = RasterFactory.createComponentSampleModel(sm, sm.getTransferType(), sm.getWidth(), sm.getHeight(), 1);
            il.setSampleModel(sm);
            cm = il.getColorModel(null);
            if (cm != null && !JDKWorkarounds.areCompatibleDataModels(sm, cm)) {
                il.unsetValid(512);
            }
        }
        if ((layout == null || !il.isValid(512)) && source.getSampleModel().getDataType() == 0 && il.getSampleModel(null).getDataType() == 0 && colorMap.getDataType() == 0 && colorMap.getNumBands() == 3 && ((cm = source.getColorModel()) == null || cm != null && cm.getColorSpace().isCS_sRGB())) {
            int size = colorMap.getNumEntries();
            byte[][] cmap = new byte[3][256];
            for (int i = 0; i < 3; ++i) {
                int j;
                byte[] band = cmap[i];
                byte[] data = colorMap.getByteData(i);
                int offset = colorMap.getOffset(i);
                int end = offset + size;
                for (j = 0; j < offset; ++j) {
                    band[j] = 0;
                }
                for (j = offset; j < end; ++j) {
                    band[j] = data[j - offset];
                }
                for (j = end; j < 256; ++j) {
                    band[j] = -1;
                }
            }
            il.setColorModel(new IndexColorModel(8, 256, cmap[0], cmap[1], cmap[2]));
        }
        return il;
    }

    public OrderedDitherOpImage(RenderedImage source, Map config, ImageLayout layout, ColorCube colorMap, KernelJAI[] ditherMask, ROI roi, Range nodata, double destNoData) {
        super(source, OrderedDitherOpImage.layoutHelper(layout, source, colorMap), config, true);
        this.numBands = colorMap.getNumBands();
        this.mults = (int[])colorMap.getMultipliers().clone();
        this.dims = (int[])colorMap.getDimsLessOne().clone();
        this.adjustedOffset = colorMap.getAdjustedOffset();
        this.maskWidth = ditherMask[0].getWidth();
        this.maskHeight = ditherMask[0].getHeight();
        boolean bl = this.hasNoData = nodata != null;
        if (this.hasNoData) {
            this.nodata = nodata;
        }
        boolean bl2 = this.hasROI = roi != null;
        if (this.hasROI) {
            this.roi = roi;
            this.roiBounds = roi.getBounds();
        }
        if ((this.hasROI || this.hasNoData) && destNoData < (double)this.adjustedOffset) {
            throw new IllegalArgumentException("Destination NoData must be greater than the adjustedOffset value");
        }
        this.destNoData = destNoData;
        this.caseA = !this.hasROI && !this.hasNoData;
        this.caseB = this.hasROI && !this.hasNoData;
        this.caseC = !this.hasROI && this.hasNoData;
        this.initializeDitherData(this.sampleModel.getTransferType(), ditherMask);
        this.permitInPlaceOperation();
        if (this.hasNoData && this.sampleModel.getTransferType() == 0) {
            this.initNoDataLUT();
        }
    }

    private void initNoDataLUT() {
        this.lut = new boolean[256];
        for (int i = 0; i < 256; ++i) {
            byte b2 = (byte)i;
            this.lut[i] = !this.nodata.contains(b2);
        }
    }

    private void initializeDitherData(int dataType, KernelJAI[] ditherMask) {
        switch (dataType) {
            case 0: {
                this.maskDataByte = new byte[ditherMask.length][];
                for (int i = 0; i < this.maskDataByte.length; ++i) {
                    float[] maskData = ditherMask[i].getKernelData();
                    this.maskDataByte[i] = new byte[maskData.length];
                    for (int j = 0; j < maskData.length; ++j) {
                        this.maskDataByte[i][j] = (byte)((int)(maskData[j] * 255.0f) & 0xFF);
                    }
                }
                this.initializeDitherLUT();
                break;
            }
            case 1: 
            case 2: {
                int scaleFactor = 65535;
                this.maskDataInt = new int[ditherMask.length][];
                for (int i = 0; i < this.maskDataInt.length; ++i) {
                    float[] maskData = ditherMask[i].getKernelData();
                    this.maskDataInt[i] = new int[maskData.length];
                    for (int j = 0; j < maskData.length; ++j) {
                        this.maskDataInt[i][j] = (int)(maskData[j] * (float)scaleFactor);
                    }
                }
                break;
            }
            case 3: {
                long scaleFactor = 0xFFFFFFFFL;
                this.maskDataLong = new long[ditherMask.length][];
                for (int i = 0; i < this.maskDataLong.length; ++i) {
                    float[] maskData = ditherMask[i].getKernelData();
                    this.maskDataLong[i] = new long[maskData.length];
                    for (int j = 0; j < maskData.length; ++j) {
                        this.maskDataLong[i][j] = (long)(maskData[j] * (float)scaleFactor);
                    }
                }
                break;
            }
            case 4: 
            case 5: {
                this.maskDataFloat = new float[ditherMask.length][];
                for (int i = 0; i < this.maskDataFloat.length; ++i) {
                    this.maskDataFloat[i] = ditherMask[i].getKernelData();
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
    }

    private synchronized void initializeDitherLUT() {
        if (this.numBands * this.maskHeight * this.maskWidth * 256 > 262144) {
            this.odType = 0;
            return;
        }
        this.odType = this.numBands == 3 ? 1 : 2;
        int index = 0;
        while (index < ditherLUTCache.size()) {
            SoftReference lutRef = (SoftReference)ditherLUTCache.get(index);
            DitherLUT lut = (DitherLUT)lutRef.get();
            if (lut == null) {
                ditherLUTCache.remove(index);
                continue;
            }
            if (lut.equals(this.dims, this.mults, this.maskDataByte)) {
                this.odLUT = lut;
                break;
            }
            ++index;
        }
        if (this.odLUT == null) {
            this.odLUT = new DitherLUT(this.dims, this.mults, this.maskDataByte);
            if (ditherLUTCache.size() < 4) {
                ditherLUTCache.add(new SoftReference<DitherLUT>(this.odLUT));
            }
        }
    }

    @Override
    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        ROI roiTile = null;
        RandomIter roiIter = null;
        boolean roiContainsTile = false;
        boolean roiDisjointTile = false;
        if (this.hasROI) {
            Rectangle srcRectExpanded = this.mapDestRect(destRect, 0);
            srcRectExpanded.setRect(srcRectExpanded.getMinX() - 1.0, srcRectExpanded.getMinY() - 1.0, srcRectExpanded.getWidth() + 2.0, srcRectExpanded.getHeight() + 2.0);
            if (!this.roiBounds.intersects(srcRectExpanded)) {
                roiDisjointTile = true;
            } else {
                roiTile = this.roi.intersect(new ROIShape(srcRectExpanded));
                roiContainsTile = roiTile.contains(srcRectExpanded);
                if (!roiContainsTile) {
                    if (!roiTile.intersects(srcRectExpanded)) {
                        roiDisjointTile = true;
                    } else {
                        PlanarImage roiIMG = this.getImage();
                        roiIter = RandomIterFactory.create(roiIMG, null, true, true);
                    }
                }
            }
        }
        if (roiDisjointTile) {
            ImageUtil.fillBackground(dest, destRect, new double[]{this.destNoData});
            return;
        }
        RasterFormatTag[] formatTags = null;
        if (ImageUtil.isBinary(this.getSampleModel()) && !ImageUtil.isBinary(this.getSourceImage(0).getSampleModel())) {
            RenderedImage[] sourceArray = new RenderedImage[]{this.getSourceImage(0)};
            RasterFormatTag[] sourceTags = RasterAccessor.findCompatibleTags(sourceArray, sourceArray[0]);
            RasterFormatTag[] destTags = RasterAccessor.findCompatibleTags(sourceArray, this);
            formatTags = new RasterFormatTag[]{sourceTags[0], destTags[1]};
        } else {
            formatTags = this.getFormatTags();
        }
        RasterAccessor src = new RasterAccessor(sources[0], destRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dst = new RasterAccessor(dest, destRect, formatTags[1], this.getColorModel());
        switch (src.getDataType()) {
            case 0: {
                this.computeRectByte(src, dst, roiIter, roiContainsTile);
                break;
            }
            case 1: {
                this.computeRectUShort(src, dst, roiIter, roiContainsTile);
                break;
            }
            case 2: {
                this.computeRectShort(src, dst, roiIter, roiContainsTile);
                break;
            }
            case 3: {
                this.computeRectInt(src, dst, roiIter, roiContainsTile);
                break;
            }
            case 4: {
                this.computeRectFloat(src, dst, roiIter, roiContainsTile);
                break;
            }
            case 5: {
                this.computeRectDouble(src, dst, roiIter, roiContainsTile);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage1"));
            }
        }
        dst.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int sbands = src.getNumBands();
        int sLineStride = src.getScanlineStride();
        int sPixelStride = src.getPixelStride();
        int[] sBandOffsets = src.getBandOffsets();
        byte[][] sData = src.getByteDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int dBandOffset = dst.getBandOffset(0);
        byte[] dData = dst.getByteDataArray(0);
        int x0 = dst.getX();
        int xMod = x0 % this.maskWidth;
        int y0 = dst.getY();
        switch (this.odType) {
            case 1: 
            case 2: {
                int[] srcLineOffsets = (int[])sBandOffsets.clone();
                int[] srcPixelOffsets = (int[])srcLineOffsets.clone();
                int dLineOffset = dBandOffset;
                for (int h2 = 0; h2 < dheight; ++h2) {
                    int yMod = (y0 + h2) % this.maskHeight;
                    if (this.odType == 1) {
                        this.computeLineByteLUT3(sData, srcPixelOffsets, sPixelStride, dData, dLineOffset, dPixelStride, dwidth, xMod, yMod, x0, y0 + h2, roiIter, roiContainsTile);
                    } else {
                        this.computeLineByteLUTN(sData, srcPixelOffsets, sPixelStride, dData, dLineOffset, dPixelStride, dwidth, xMod, yMod, x0, y0 + h2, roiIter, roiContainsTile);
                    }
                    for (int i = 0; i < sbands; ++i) {
                        int n = i;
                        srcLineOffsets[n] = srcLineOffsets[n] + sLineStride;
                        srcPixelOffsets[i] = srcLineOffsets[i];
                    }
                    dLineOffset += dLineStride;
                }
                break;
            }
            default: {
                this.computeRectByteGeneral(sData, sBandOffsets, sLineStride, sPixelStride, dData, dBandOffset, dLineStride, dPixelStride, dwidth, dheight, xMod, x0, y0, roiIter, roiContainsTile);
            }
        }
    }

    private void computeLineByteLUT3(byte[][] sData, int[] sPixelOffsets, int sPixelStride, byte[] dData, int dPixelOffset, int dPixelStride, int dwidth, int xMod, int yMod, int x0, int y, RandomIter roiIter, boolean roiContainsTile) {
        int ditherLUTBandStride = this.odLUT.ditherLUTBandStride;
        int ditherLUTRowStride = this.odLUT.ditherLUTRowStride;
        int ditherLUTColStride = this.odLUT.ditherLUTColStride;
        byte[] ditherLUT = this.odLUT.ditherLUT;
        int base = this.adjustedOffset;
        int dlut0 = yMod * ditherLUTRowStride;
        int dlut1 = dlut0 + ditherLUTBandStride;
        int dlut2 = dlut1 + ditherLUTBandStride;
        int dlutLimit = dlut0 + ditherLUTRowStride;
        int xDelta = xMod * ditherLUTColStride;
        int pDtab0 = dlut0 + xDelta;
        int pDtab1 = dlut1 + xDelta;
        int pDtab2 = dlut2 + xDelta;
        byte[] sData0 = sData[0];
        byte[] sData1 = sData[1];
        byte[] sData2 = sData[2];
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int count = dwidth; count > 0; --count) {
                int idx = (ditherLUT[pDtab0 + (sData0[sPixelOffsets[0]] & 0xFF)] & 0xFF) + (ditherLUT[pDtab1 + (sData1[sPixelOffsets[1]] & 0xFF)] & 0xFF) + (ditherLUT[pDtab2 + (sData2[sPixelOffsets[2]] & 0xFF)] & 0xFF);
                dData[dPixelOffset] = (byte)(idx + base & 0xFF);
                sPixelOffsets[0] = sPixelOffsets[0] + sPixelStride;
                sPixelOffsets[1] = sPixelOffsets[1] + sPixelStride;
                sPixelOffsets[2] = sPixelOffsets[2] + sPixelStride;
                dPixelOffset += dPixelStride;
                if ((pDtab0 += ditherLUTColStride) >= dlutLimit) {
                    pDtab0 = dlut0;
                    pDtab1 = dlut1;
                    pDtab2 = dlut2;
                    continue;
                }
                pDtab1 += ditherLUTColStride;
                pDtab2 += ditherLUTColStride;
            }
        } else if (this.caseB) {
            for (int count = dwidth; count > 0; --count) {
                int x = x0 + dwidth - count;
                if (this.roiBounds.contains(x, y) && roiIter.getSample(x, y, 0) > 0) {
                    int idx = (ditherLUT[pDtab0 + (sData0[sPixelOffsets[0]] & 0xFF)] & 0xFF) + (ditherLUT[pDtab1 + (sData1[sPixelOffsets[1]] & 0xFF)] & 0xFF) + (ditherLUT[pDtab2 + (sData2[sPixelOffsets[2]] & 0xFF)] & 0xFF);
                    dData[dPixelOffset] = (byte)(idx + base & 0xFF);
                } else {
                    dData[dPixelOffset] = (byte)((int)this.destNoData & 0xFF);
                }
                sPixelOffsets[0] = sPixelOffsets[0] + sPixelStride;
                sPixelOffsets[1] = sPixelOffsets[1] + sPixelStride;
                sPixelOffsets[2] = sPixelOffsets[2] + sPixelStride;
                dPixelOffset += dPixelStride;
                if ((pDtab0 += ditherLUTColStride) >= dlutLimit) {
                    pDtab0 = dlut0;
                    pDtab1 = dlut1;
                    pDtab2 = dlut2;
                    continue;
                }
                pDtab1 += ditherLUTColStride;
                pDtab2 += ditherLUTColStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int count = dwidth; count > 0; --count) {
                boolean valid;
                int src0 = sData0[sPixelOffsets[0]] & 0xFF;
                int src1 = sData1[sPixelOffsets[1]] & 0xFF;
                int src2 = sData2[sPixelOffsets[2]] & 0xFF;
                boolean bl = valid = this.lut[src0] && this.lut[src1] && this.lut[src2];
                if (valid) {
                    int idx = (ditherLUT[pDtab0 + src0] & 0xFF) + (ditherLUT[pDtab1 + src1] & 0xFF) + (ditherLUT[pDtab2 + src2] & 0xFF);
                    dData[dPixelOffset] = (byte)(idx + base & 0xFF);
                } else {
                    dData[dPixelOffset] = (byte)((int)this.destNoData & 0xFF);
                }
                sPixelOffsets[0] = sPixelOffsets[0] + sPixelStride;
                sPixelOffsets[1] = sPixelOffsets[1] + sPixelStride;
                sPixelOffsets[2] = sPixelOffsets[2] + sPixelStride;
                dPixelOffset += dPixelStride;
                if ((pDtab0 += ditherLUTColStride) >= dlutLimit) {
                    pDtab0 = dlut0;
                    pDtab1 = dlut1;
                    pDtab2 = dlut2;
                    continue;
                }
                pDtab1 += ditherLUTColStride;
                pDtab2 += ditherLUTColStride;
            }
        } else {
            for (int count = dwidth; count > 0; --count) {
                boolean valid;
                int x = x0 + dwidth - count;
                int src0 = sData0[sPixelOffsets[0]] & 0xFF;
                int src1 = sData1[sPixelOffsets[1]] & 0xFF;
                int src2 = sData2[sPixelOffsets[2]] & 0xFF;
                boolean bl = valid = this.lut[src0] && this.lut[src1] && this.lut[src2];
                if (valid && this.roiBounds.contains(x, y) && roiIter.getSample(x, y, 0) > 0) {
                    int idx = (ditherLUT[pDtab0 + src0] & 0xFF) + (ditherLUT[pDtab1 + src1] & 0xFF) + (ditherLUT[pDtab2 + src2] & 0xFF);
                    dData[dPixelOffset] = (byte)(idx + base & 0xFF);
                } else {
                    dData[dPixelOffset] = (byte)((int)this.destNoData & 0xFF);
                }
                sPixelOffsets[0] = sPixelOffsets[0] + sPixelStride;
                sPixelOffsets[1] = sPixelOffsets[1] + sPixelStride;
                sPixelOffsets[2] = sPixelOffsets[2] + sPixelStride;
                dPixelOffset += dPixelStride;
                if ((pDtab0 += ditherLUTColStride) >= dlutLimit) {
                    pDtab0 = dlut0;
                    pDtab1 = dlut1;
                    pDtab2 = dlut2;
                    continue;
                }
                pDtab1 += ditherLUTColStride;
                pDtab2 += ditherLUTColStride;
            }
        }
    }

    private void computeLineByteLUTN(byte[][] sData, int[] sPixelOffsets, int sPixelStride, byte[] dData, int dPixelOffset, int dPixelStride, int dwidth, int xMod, int yMod, int x0, int y, RandomIter roiIter, boolean roiContainsTile) {
        int ditherLUTBandStride = this.odLUT.ditherLUTBandStride;
        int ditherLUTRowStride = this.odLUT.ditherLUTRowStride;
        int ditherLUTColStride = this.odLUT.ditherLUTColStride;
        byte[] ditherLUT = this.odLUT.ditherLUT;
        int base = this.adjustedOffset;
        int dlutRow = yMod * ditherLUTRowStride;
        int dlutCol = dlutRow + xMod * ditherLUTColStride;
        int dlutLimit = dlutRow + ditherLUTRowStride;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int count = dwidth; count > 0; --count) {
                int dlutBand = dlutCol;
                int idx = base;
                int i = 0;
                while (i < this.numBands) {
                    idx += ditherLUT[dlutBand + (sData[i][sPixelOffsets[i]] & 0xFF)] & 0xFF;
                    dlutBand += ditherLUTBandStride;
                    int n = i++;
                    sPixelOffsets[n] = sPixelOffsets[n] + sPixelStride;
                }
                dData[dPixelOffset] = (byte)(idx & 0xFF);
                dPixelOffset += dPixelStride;
                if ((dlutCol += ditherLUTColStride) < dlutLimit) continue;
                dlutCol = dlutRow;
            }
        } else if (this.caseB) {
            for (int count = dwidth; count > 0; --count) {
                int x = x0 + dwidth - count;
                if (this.roiBounds.contains(x, y) && roiIter.getSample(x, y, 0) > 0) {
                    int dlutBand = dlutCol;
                    int idx = base;
                    int i = 0;
                    while (i < this.numBands) {
                        idx += ditherLUT[dlutBand + (sData[i][sPixelOffsets[i]] & 0xFF)] & 0xFF;
                        dlutBand += ditherLUTBandStride;
                        int n = i++;
                        sPixelOffsets[n] = sPixelOffsets[n] + sPixelStride;
                    }
                    dData[dPixelOffset] = (byte)(idx & 0xFF);
                } else {
                    int i = 0;
                    while (i < this.numBands) {
                        int n = i++;
                        sPixelOffsets[n] = sPixelOffsets[n] + sPixelStride;
                    }
                    dData[dPixelOffset] = (byte)((int)this.destNoData & 0xFF);
                }
                dPixelOffset += dPixelStride;
                if ((dlutCol += ditherLUTColStride) < dlutLimit) continue;
                dlutCol = dlutRow;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int count = dwidth; count > 0; --count) {
                int dlutBand = dlutCol;
                int idx = base;
                boolean valid = true;
                int i = 0;
                while (i < this.numBands) {
                    int b2 = sData[i][sPixelOffsets[i]] & 0xFF;
                    valid &= this.lut[b2];
                    idx += ditherLUT[dlutBand + b2] & 0xFF;
                    dlutBand += ditherLUTBandStride;
                    int n = i++;
                    sPixelOffsets[n] = sPixelOffsets[n] + sPixelStride;
                }
                dData[dPixelOffset] = valid ? (byte)(idx & 0xFF) : (byte)((int)this.destNoData & 0xFF);
                dPixelOffset += dPixelStride;
                if ((dlutCol += ditherLUTColStride) < dlutLimit) continue;
                dlutCol = dlutRow;
            }
        } else {
            for (int count = dwidth; count > 0; --count) {
                int x = x0 + dwidth - count;
                if (this.roiBounds.contains(x, y) && roiIter.getSample(x, y, 0) > 0) {
                    int dlutBand = dlutCol;
                    int idx = base;
                    boolean valid = true;
                    int i = 0;
                    while (i < this.numBands) {
                        int b3 = sData[i][sPixelOffsets[i]] & 0xFF;
                        valid &= this.lut[b3];
                        idx += ditherLUT[dlutBand + b3] & 0xFF;
                        dlutBand += ditherLUTBandStride;
                        int n = i++;
                        sPixelOffsets[n] = sPixelOffsets[n] + sPixelStride;
                    }
                    dData[dPixelOffset] = valid ? (byte)(idx & 0xFF) : (byte)((int)this.destNoData & 0xFF);
                } else {
                    int i = 0;
                    while (i < this.numBands) {
                        int n = i++;
                        sPixelOffsets[n] = sPixelOffsets[n] + sPixelStride;
                    }
                    dData[dPixelOffset] = (byte)((int)this.destNoData & 0xFF);
                }
                dPixelOffset += dPixelStride;
                if ((dlutCol += ditherLUTColStride) < dlutLimit) continue;
                dlutCol = dlutRow;
            }
        }
    }

    private void computeRectByteGeneral(byte[][] sData, int[] sBandOffsets, int sLineStride, int sPixelStride, byte[] dData, int dBandOffset, int dLineStride, int dPixelStride, int dwidth, int dheight, int xMod, int x0, int y0, RandomIter roiIter, boolean roiContainsTile) {
        int result;
        int frac;
        int tmp;
        int bDIndex;
        int x;
        int w;
        int dPixelOffset;
        int sPixelOffset;
        int maskIndex;
        int maskLimit;
        int maskYBase;
        int yMod;
        int y;
        int w2;
        int dPixelOffset2;
        int sPixelOffset2;
        int maskIndex2;
        int maskLimit2;
        int maskYBase2;
        int yMod2;
        int h2;
        if (this.adjustedOffset > 0) {
            Arrays.fill(dData, (byte)(this.adjustedOffset & 0xFF));
        }
        int sbands = sBandOffsets.length;
        int sLineOffset = 0;
        int dLineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (h2 = 0; h2 < dheight; ++h2) {
                yMod2 = (y0 + h2) % this.maskHeight;
                maskYBase2 = yMod2 * this.maskWidth;
                maskLimit2 = maskYBase2 + this.maskWidth;
                maskIndex2 = maskYBase2 + xMod;
                sPixelOffset2 = sLineOffset;
                dPixelOffset2 = dLineOffset;
                for (w2 = 0; w2 < dwidth; ++w2) {
                    int bDIndex2 = dPixelOffset2 + dBandOffset;
                    for (int b2 = 0; b2 < sbands; ++b2) {
                        int tmp2 = (sData[b2][sPixelOffset2 + sBandOffsets[b2]] & 0xFF) * this.dims[b2];
                        int frac2 = tmp2 & 0xFF;
                        tmp2 >>= 8;
                        if (frac2 > (this.maskDataByte[b2][maskIndex2] & 0xFF)) {
                            ++tmp2;
                        }
                        int result2 = (dData[bDIndex2] & 0xFF) + tmp2 * this.mults[b2];
                        dData[bDIndex2] = (byte)(result2 & 0xFF);
                    }
                    sPixelOffset2 += sPixelStride;
                    dPixelOffset2 += dPixelStride;
                    if (++maskIndex2 < maskLimit2) continue;
                    maskIndex2 = maskYBase2;
                }
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
            }
        } else if (this.caseB) {
            for (h2 = 0; h2 < dheight; ++h2) {
                y = y0 + h2;
                yMod = y % this.maskHeight;
                maskYBase = yMod * this.maskWidth;
                maskLimit = maskYBase + this.maskWidth;
                maskIndex = maskYBase + xMod;
                sPixelOffset = sLineOffset;
                dPixelOffset = dLineOffset;
                for (w = 0; w < dwidth; ++w) {
                    x = x0 + w;
                    bDIndex = dPixelOffset + dBandOffset;
                    if (this.roiBounds.contains(x, y) && roiIter.getSample(x, y, 0) > 0) {
                        for (int b3 = 0; b3 < sbands; ++b3) {
                            tmp = (sData[b3][sPixelOffset + sBandOffsets[b3]] & 0xFF) * this.dims[b3];
                            frac = tmp & 0xFF;
                            tmp >>= 8;
                            if (frac > (this.maskDataByte[b3][maskIndex] & 0xFF)) {
                                ++tmp;
                            }
                            result = (dData[bDIndex] & 0xFF) + tmp * this.mults[b3];
                            dData[bDIndex] = (byte)(result & 0xFF);
                        }
                    } else {
                        dData[bDIndex] = (byte)((int)this.destNoData & 0xFF);
                    }
                    sPixelOffset += sPixelStride;
                    dPixelOffset += dPixelStride;
                    if (++maskIndex < maskLimit) continue;
                    maskIndex = maskYBase;
                }
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (h2 = 0; h2 < dheight; ++h2) {
                yMod2 = (y0 + h2) % this.maskHeight;
                maskYBase2 = yMod2 * this.maskWidth;
                maskLimit2 = maskYBase2 + this.maskWidth;
                maskIndex2 = maskYBase2 + xMod;
                sPixelOffset2 = sLineOffset;
                dPixelOffset2 = dLineOffset;
                for (w2 = 0; w2 < dwidth; ++w2) {
                    boolean valid = true;
                    int bDIndex3 = dPixelOffset2 + dBandOffset;
                    for (int b4 = 0; b4 < sbands && valid; ++b4) {
                        int value = sData[b4][sPixelOffset2 + sBandOffsets[b4]] & 0xFF;
                        valid &= this.lut[value];
                        tmp = value * this.dims[b4];
                        frac = tmp & 0xFF;
                        tmp >>= 8;
                        if (frac > (this.maskDataByte[b4][maskIndex2] & 0xFF)) {
                            ++tmp;
                        }
                        result = (dData[bDIndex3] & 0xFF) + tmp * this.mults[b4];
                        dData[bDIndex3] = (byte)(result & 0xFF);
                    }
                    if (!valid) {
                        dData[bDIndex3] = (byte)((int)this.destNoData & 0xFF);
                    }
                    sPixelOffset2 += sPixelStride;
                    dPixelOffset2 += dPixelStride;
                    if (++maskIndex2 < maskLimit2) continue;
                    maskIndex2 = maskYBase2;
                }
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
            }
        } else {
            for (h2 = 0; h2 < dheight; ++h2) {
                y = y0 + h2;
                yMod = y % this.maskHeight;
                maskYBase = yMod * this.maskWidth;
                maskLimit = maskYBase + this.maskWidth;
                maskIndex = maskYBase + xMod;
                sPixelOffset = sLineOffset;
                dPixelOffset = dLineOffset;
                for (w = 0; w < dwidth; ++w) {
                    x = x0 + w;
                    bDIndex = dPixelOffset + dBandOffset;
                    if (this.roiBounds.contains(x, y) && roiIter.getSample(x, y, 0) > 0) {
                        boolean valid = true;
                        for (int b5 = 0; b5 < sbands && valid; ++b5) {
                            int value = sData[b5][sPixelOffset + sBandOffsets[b5]] & 0xFF;
                            valid &= this.lut[value];
                            int tmp3 = value * this.dims[b5];
                            int frac3 = tmp3 & 0xFF;
                            tmp3 >>= 8;
                            if (frac3 > (this.maskDataByte[b5][maskIndex] & 0xFF)) {
                                ++tmp3;
                            }
                            int result3 = (dData[bDIndex] & 0xFF) + tmp3 * this.mults[b5];
                            dData[bDIndex] = (byte)(result3 & 0xFF);
                        }
                        if (!valid) {
                            dData[bDIndex] = (byte)((int)this.destNoData & 0xFF);
                        }
                    } else {
                        dData[bDIndex] = (byte)((int)this.destNoData & 0xFF);
                    }
                    sPixelOffset += sPixelStride;
                    dPixelOffset += dPixelStride;
                    if (++maskIndex < maskLimit) continue;
                    maskIndex = maskYBase;
                }
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
            }
        }
        if (this.adjustedOffset < 0) {
            int length = dData.length;
            for (int i = 0; i < length; ++i) {
                dData[i] = (byte)((dData[i] & 0xFF) + this.adjustedOffset);
            }
        }
    }

    private void computeRectShort(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int sbands = src.getNumBands();
        int sLineStride = src.getScanlineStride();
        int sPixelStride = src.getPixelStride();
        int[] sBandOffsets = src.getBandOffsets();
        short[][] sData = src.getShortDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int dBandOffset = dst.getBandOffset(0);
        short[] dData = dst.getShortDataArray(0);
        if (this.adjustedOffset != 0) {
            Arrays.fill(dData, (short)(this.adjustedOffset & 0xFFFF));
        }
        int x0 = dst.getX();
        int xMod = x0 % this.maskWidth;
        int y0 = dst.getY();
        int sLineOffset = 0;
        int dLineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dheight; ++h2) {
                int yMod = (y0 + h2) % this.maskHeight;
                int maskYBase = yMod * this.maskWidth;
                int maskLimit = maskYBase + this.maskWidth;
                int maskIndex = maskYBase + xMod;
                int sPixelOffset = sLineOffset;
                int dPixelOffset = dLineOffset;
                for (int w = 0; w < dwidth; ++w) {
                    int bDIndex = dPixelOffset + dBandOffset;
                    for (int b2 = 0; b2 < sbands; ++b2) {
                        int tmp = (sData[b2][sPixelOffset + sBandOffsets[b2]] - Short.MIN_VALUE) * this.dims[b2];
                        int frac = tmp & 0xFFFF;
                        int result = (dData[bDIndex] & 0xFFFF) + (tmp >> 16) * this.mults[b2];
                        if (frac > this.maskDataInt[b2][maskIndex]) {
                            result += this.mults[b2];
                        }
                        dData[bDIndex] = (short)(result & 0xFFFF);
                    }
                    sPixelOffset += sPixelStride;
                    dPixelOffset += dPixelStride;
                    if (++maskIndex < maskLimit) continue;
                    maskIndex = maskYBase;
                }
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dheight; ++h3) {
                int y = y0 + h3;
                int yMod = y % this.maskHeight;
                int maskYBase = yMod * this.maskWidth;
                int maskLimit = maskYBase + this.maskWidth;
                int maskIndex = maskYBase + xMod;
                int sPixelOffset = sLineOffset;
                int dPixelOffset = dLineOffset;
                for (int w = 0; w < dwidth; ++w) {
                    int x = x0 + w;
                    int bDIndex = dPixelOffset + dBandOffset;
                    if (this.roiBounds.contains(x, y) && roiIter.getSample(x, y, 0) > 0) {
                        for (int b3 = 0; b3 < sbands; ++b3) {
                            int tmp = (sData[b3][sPixelOffset + sBandOffsets[b3]] - Short.MIN_VALUE) * this.dims[b3];
                            int frac = tmp & 0xFFFF;
                            int result = (dData[bDIndex] & 0xFFFF) + (tmp >> 16) * this.mults[b3];
                            if (frac > this.maskDataInt[b3][maskIndex]) {
                                result += this.mults[b3];
                            }
                            dData[bDIndex] = (short)(result & 0xFFFF);
                        }
                    } else {
                        dData[bDIndex] = (short)((int)this.destNoData & 0xFFFF);
                    }
                    sPixelOffset += sPixelStride;
                    dPixelOffset += dPixelStride;
                    if (++maskIndex < maskLimit) continue;
                    maskIndex = maskYBase;
                }
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h4 = 0; h4 < dheight; ++h4) {
                int yMod = (y0 + h4) % this.maskHeight;
                int maskYBase = yMod * this.maskWidth;
                int maskLimit = maskYBase + this.maskWidth;
                int maskIndex = maskYBase + xMod;
                int sPixelOffset = sLineOffset;
                int dPixelOffset = dLineOffset;
                for (int w = 0; w < dwidth; ++w) {
                    boolean valid = true;
                    int bDIndex = dPixelOffset + dBandOffset;
                    for (int b4 = 0; b4 < sbands && valid; ++b4) {
                        short value = sData[b4][sPixelOffset + sBandOffsets[b4]];
                        valid &= !this.nodata.contains(value);
                        int tmp = (value - Short.MIN_VALUE) * this.dims[b4];
                        int frac = tmp & 0xFFFF;
                        int result = (dData[bDIndex] & 0xFFFF) + (tmp >> 16) * this.mults[b4];
                        if (frac > this.maskDataInt[b4][maskIndex]) {
                            result += this.mults[b4];
                        }
                        dData[bDIndex] = (short)(result & 0xFFFF);
                    }
                    if (!valid) {
                        dData[bDIndex] = (short)((int)this.destNoData & 0xFFFF);
                    }
                    sPixelOffset += sPixelStride;
                    dPixelOffset += dPixelStride;
                    if (++maskIndex < maskLimit) continue;
                    maskIndex = maskYBase;
                }
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
            }
        } else {
            for (int h5 = 0; h5 < dheight; ++h5) {
                int y = y0 + h5;
                int yMod = y % this.maskHeight;
                int maskYBase = yMod * this.maskWidth;
                int maskLimit = maskYBase + this.maskWidth;
                int maskIndex = maskYBase + xMod;
                int sPixelOffset = sLineOffset;
                int dPixelOffset = dLineOffset;
                for (int w = 0; w < dwidth; ++w) {
                    int x = x0 + w;
                    int bDIndex = dPixelOffset + dBandOffset;
                    if (this.roiBounds.contains(x, y) && roiIter.getSample(x, y, 0) > 0) {
                        boolean valid = true;
                        for (int b5 = 0; b5 < sbands && valid; ++b5) {
                            short value = sData[b5][sPixelOffset + sBandOffsets[b5]];
                            valid &= !this.nodata.contains(value);
                            int tmp = (value - Short.MIN_VALUE) * this.dims[b5];
                            int frac = tmp & 0xFFFF;
                            int result = (dData[bDIndex] & 0xFFFF) + (tmp >> 16) * this.mults[b5];
                            if (frac > this.maskDataInt[b5][maskIndex]) {
                                result += this.mults[b5];
                            }
                            dData[bDIndex] = (short)(result & 0xFFFF);
                        }
                        if (!valid) {
                            dData[bDIndex] = (short)((int)this.destNoData & 0xFFFF);
                        }
                    } else {
                        dData[bDIndex] = (short)((int)this.destNoData & 0xFFFF);
                    }
                    sPixelOffset += sPixelStride;
                    dPixelOffset += dPixelStride;
                    if (++maskIndex < maskLimit) continue;
                    maskIndex = maskYBase;
                }
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
            }
        }
    }

    private void computeRectUShort(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int sbands = src.getNumBands();
        int sLineStride = src.getScanlineStride();
        int sPixelStride = src.getPixelStride();
        int[] sBandOffsets = src.getBandOffsets();
        short[][] sData = src.getShortDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int dBandOffset = dst.getBandOffset(0);
        short[] dData = dst.getShortDataArray(0);
        if (this.adjustedOffset != 0) {
            Arrays.fill(dData, (short)(this.adjustedOffset & 0xFFFF));
        }
        int x0 = dst.getX();
        int xMod = x0 % this.maskWidth;
        int y0 = dst.getY();
        int sLineOffset = 0;
        int dLineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dheight; ++h2) {
                int yMod = (y0 + h2) % this.maskHeight;
                int maskYBase = yMod * this.maskWidth;
                int maskLimit = maskYBase + this.maskWidth;
                int maskIndex = maskYBase + xMod;
                int sPixelOffset = sLineOffset;
                int dPixelOffset = dLineOffset;
                for (int w = 0; w < dwidth; ++w) {
                    int bDIndex = dPixelOffset + dBandOffset;
                    for (int b2 = 0; b2 < sbands; ++b2) {
                        int tmp = (sData[b2][sPixelOffset + sBandOffsets[b2]] & 0xFFFF) * this.dims[b2];
                        int frac = tmp & 0xFFFF;
                        int result = (dData[bDIndex] & 0xFFFF) + (tmp >> 16) * this.mults[b2];
                        if (frac > this.maskDataInt[b2][maskIndex]) {
                            result += this.mults[b2];
                        }
                        dData[bDIndex] = (short)(result & 0xFFFF);
                    }
                    sPixelOffset += sPixelStride;
                    dPixelOffset += dPixelStride;
                    if (++maskIndex < maskLimit) continue;
                    maskIndex = maskYBase;
                }
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dheight; ++h3) {
                int y = y0 + h3;
                int yMod = y % this.maskHeight;
                int maskYBase = yMod * this.maskWidth;
                int maskLimit = maskYBase + this.maskWidth;
                int maskIndex = maskYBase + xMod;
                int sPixelOffset = sLineOffset;
                int dPixelOffset = dLineOffset;
                for (int w = 0; w < dwidth; ++w) {
                    int x = x0 + w;
                    int bDIndex = dPixelOffset + dBandOffset;
                    if (this.roiBounds.contains(x, y) && roiIter.getSample(x, y, 0) > 0) {
                        for (int b3 = 0; b3 < sbands; ++b3) {
                            int tmp = (sData[b3][sPixelOffset + sBandOffsets[b3]] & 0xFFFF) * this.dims[b3];
                            int frac = tmp & 0xFFFF;
                            int result = (dData[bDIndex] & 0xFFFF) + (tmp >> 16) * this.mults[b3];
                            if (frac > this.maskDataInt[b3][maskIndex]) {
                                result += this.mults[b3];
                            }
                            dData[bDIndex] = (short)(result & 0xFFFF);
                        }
                    } else {
                        dData[bDIndex] = (short)((int)this.destNoData & 0xFFFF);
                    }
                    sPixelOffset += sPixelStride;
                    dPixelOffset += dPixelStride;
                    if (++maskIndex < maskLimit) continue;
                    maskIndex = maskYBase;
                }
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h4 = 0; h4 < dheight; ++h4) {
                int yMod = (y0 + h4) % this.maskHeight;
                int maskYBase = yMod * this.maskWidth;
                int maskLimit = maskYBase + this.maskWidth;
                int maskIndex = maskYBase + xMod;
                int sPixelOffset = sLineOffset;
                int dPixelOffset = dLineOffset;
                for (int w = 0; w < dwidth; ++w) {
                    boolean valid = true;
                    int bDIndex = dPixelOffset + dBandOffset;
                    for (int b4 = 0; b4 < sbands && valid; ++b4) {
                        short value = sData[b4][sPixelOffset + sBandOffsets[b4]];
                        valid &= !this.nodata.contains(value);
                        int tmp = (value & 0xFFFF) * this.dims[b4];
                        int frac = tmp & 0xFFFF;
                        int result = (dData[bDIndex] & 0xFFFF) + (tmp >> 16) * this.mults[b4];
                        if (frac > this.maskDataInt[b4][maskIndex]) {
                            result += this.mults[b4];
                        }
                        dData[bDIndex] = (short)(result & 0xFFFF);
                    }
                    if (!valid) {
                        dData[bDIndex] = (short)((int)this.destNoData & 0xFFFF);
                    }
                    sPixelOffset += sPixelStride;
                    dPixelOffset += dPixelStride;
                    if (++maskIndex < maskLimit) continue;
                    maskIndex = maskYBase;
                }
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
            }
        } else {
            for (int h5 = 0; h5 < dheight; ++h5) {
                int y = y0 + h5;
                int yMod = y % this.maskHeight;
                int maskYBase = yMod * this.maskWidth;
                int maskLimit = maskYBase + this.maskWidth;
                int maskIndex = maskYBase + xMod;
                int sPixelOffset = sLineOffset;
                int dPixelOffset = dLineOffset;
                for (int w = 0; w < dwidth; ++w) {
                    int x = x0 + w;
                    int bDIndex = dPixelOffset + dBandOffset;
                    if (this.roiBounds.contains(x, y) && roiIter.getSample(x, y, 0) > 0) {
                        boolean valid = true;
                        for (int b5 = 0; b5 < sbands && valid; ++b5) {
                            short value = sData[b5][sPixelOffset + sBandOffsets[b5]];
                            valid &= !this.nodata.contains(value);
                            int tmp = (value & 0xFFFF) * this.dims[b5];
                            int frac = tmp & 0xFFFF;
                            int result = (dData[bDIndex] & 0xFFFF) + (tmp >> 16) * this.mults[b5];
                            if (frac > this.maskDataInt[b5][maskIndex]) {
                                result += this.mults[b5];
                            }
                            dData[bDIndex] = (short)(result & 0xFFFF);
                        }
                        if (!valid) {
                            dData[bDIndex] = (short)((int)this.destNoData & 0xFFFF);
                        }
                    } else {
                        dData[bDIndex] = (short)((int)this.destNoData & 0xFFFF);
                    }
                    sPixelOffset += sPixelStride;
                    dPixelOffset += dPixelStride;
                    if (++maskIndex < maskLimit) continue;
                    maskIndex = maskYBase;
                }
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
            }
        }
    }

    private void computeRectInt(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int sbands = src.getNumBands();
        int sLineStride = src.getScanlineStride();
        int sPixelStride = src.getPixelStride();
        int[] sBandOffsets = src.getBandOffsets();
        int[][] sData = src.getIntDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int dBandOffset = dst.getBandOffset(0);
        int[] dData = dst.getIntDataArray(0);
        if (this.adjustedOffset != 0) {
            Arrays.fill(dData, this.adjustedOffset);
        }
        int x0 = dst.getX();
        int xMod = x0 % this.maskWidth;
        int y0 = dst.getY();
        int sLineOffset = 0;
        int dLineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dheight; ++h2) {
                int yMod = (y0 + h2) % this.maskHeight;
                int maskYBase = yMod * this.maskWidth;
                int maskLimit = maskYBase + this.maskWidth;
                int maskIndex = maskYBase + xMod;
                int sPixelOffset = sLineOffset;
                int dPixelOffset = dLineOffset;
                for (int w = 0; w < dwidth; ++w) {
                    int bDIndex = dPixelOffset + dBandOffset;
                    for (int b2 = 0; b2 < sbands; ++b2) {
                        long tmp = ((long)sData[b2][sPixelOffset + sBandOffsets[b2]] - Integer.MIN_VALUE) * (long)this.dims[b2];
                        long frac = tmp & 0xFFFFFFFFFFFFFFFFL;
                        int result = dData[bDIndex] + (int)(tmp >> 32) * this.mults[b2];
                        if (frac > this.maskDataLong[b2][maskIndex]) {
                            result += this.mults[b2];
                        }
                        dData[bDIndex] = result;
                    }
                    sPixelOffset += sPixelStride;
                    dPixelOffset += dPixelStride;
                    if (++maskIndex < maskLimit) continue;
                    maskIndex = maskYBase;
                }
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dheight; ++h3) {
                int y = y0 + h3;
                int yMod = y % this.maskHeight;
                int maskYBase = yMod * this.maskWidth;
                int maskLimit = maskYBase + this.maskWidth;
                int maskIndex = maskYBase + xMod;
                int sPixelOffset = sLineOffset;
                int dPixelOffset = dLineOffset;
                for (int w = 0; w < dwidth; ++w) {
                    int x = x0 + w;
                    int bDIndex = dPixelOffset + dBandOffset;
                    if (this.roiBounds.contains(x, y) && roiIter.getSample(x, y, 0) > 0) {
                        for (int b3 = 0; b3 < sbands; ++b3) {
                            long tmp = ((long)sData[b3][sPixelOffset + sBandOffsets[b3]] - Integer.MIN_VALUE) * (long)this.dims[b3];
                            long frac = tmp & 0xFFFFFFFFFFFFFFFFL;
                            int result = dData[bDIndex] + (int)(tmp >> 32) * this.mults[b3];
                            if (frac > this.maskDataLong[b3][maskIndex]) {
                                result += this.mults[b3];
                            }
                            dData[bDIndex] = result;
                        }
                    } else {
                        dData[bDIndex] = (int)this.destNoData;
                    }
                    sPixelOffset += sPixelStride;
                    dPixelOffset += dPixelStride;
                    if (++maskIndex < maskLimit) continue;
                    maskIndex = maskYBase;
                }
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h4 = 0; h4 < dheight; ++h4) {
                int yMod = (y0 + h4) % this.maskHeight;
                int maskYBase = yMod * this.maskWidth;
                int maskLimit = maskYBase + this.maskWidth;
                int maskIndex = maskYBase + xMod;
                int sPixelOffset = sLineOffset;
                int dPixelOffset = dLineOffset;
                for (int w = 0; w < dwidth; ++w) {
                    boolean valid = true;
                    int bDIndex = dPixelOffset + dBandOffset;
                    for (int b4 = 0; b4 < sbands && valid; ++b4) {
                        int value = sData[b4][sPixelOffset + sBandOffsets[b4]];
                        valid &= !this.nodata.contains(value);
                        long tmp = ((long)value - Integer.MIN_VALUE) * (long)this.dims[b4];
                        long frac = tmp & 0xFFFFFFFFFFFFFFFFL;
                        int result = dData[bDIndex] + (int)(tmp >> 32) * this.mults[b4];
                        if (frac > this.maskDataLong[b4][maskIndex]) {
                            result += this.mults[b4];
                        }
                        dData[bDIndex] = result;
                    }
                    if (!valid) {
                        dData[bDIndex] = (int)this.destNoData;
                    }
                    sPixelOffset += sPixelStride;
                    dPixelOffset += dPixelStride;
                    if (++maskIndex < maskLimit) continue;
                    maskIndex = maskYBase;
                }
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
            }
        } else {
            for (int h5 = 0; h5 < dheight; ++h5) {
                int y = y0 + h5;
                int yMod = y % this.maskHeight;
                int maskYBase = yMod * this.maskWidth;
                int maskLimit = maskYBase + this.maskWidth;
                int maskIndex = maskYBase + xMod;
                int sPixelOffset = sLineOffset;
                int dPixelOffset = dLineOffset;
                for (int w = 0; w < dwidth; ++w) {
                    int x = x0 + w;
                    int bDIndex = dPixelOffset + dBandOffset;
                    if (this.roiBounds.contains(x, y) && roiIter.getSample(x, y, 0) > 0) {
                        boolean valid = true;
                        for (int b5 = 0; b5 < sbands && valid; ++b5) {
                            int value = sData[b5][sPixelOffset + sBandOffsets[b5]];
                            valid &= !this.nodata.contains(value);
                            long tmp = ((long)value - Integer.MIN_VALUE) * (long)this.dims[b5];
                            long frac = tmp & 0xFFFFFFFFFFFFFFFFL;
                            int result = dData[bDIndex] + (int)(tmp >> 32) * this.mults[b5];
                            if (frac > this.maskDataLong[b5][maskIndex]) {
                                result += this.mults[b5];
                            }
                            dData[bDIndex] = result;
                        }
                        if (!valid) {
                            dData[bDIndex] = (int)this.destNoData;
                        }
                    } else {
                        dData[bDIndex] = (int)this.destNoData;
                    }
                    sPixelOffset += sPixelStride;
                    dPixelOffset += dPixelStride;
                    if (++maskIndex < maskLimit) continue;
                    maskIndex = maskYBase;
                }
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
            }
        }
    }

    private void computeRectFloat(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int sbands = src.getNumBands();
        int sLineStride = src.getScanlineStride();
        int sPixelStride = src.getPixelStride();
        int[] sBandOffsets = src.getBandOffsets();
        float[][] sData = src.getFloatDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int dBandOffset = dst.getBandOffset(0);
        float[] dData = dst.getFloatDataArray(0);
        if (this.adjustedOffset != 0) {
            Arrays.fill(dData, (float)this.adjustedOffset);
        }
        int x0 = dst.getX();
        int xMod = x0 % this.maskWidth;
        int y0 = dst.getY();
        int sLineOffset = 0;
        int dLineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dheight; ++h2) {
                int yMod = (y0 + h2) % this.maskHeight;
                int maskYBase = yMod * this.maskWidth;
                int maskLimit = maskYBase + this.maskWidth;
                int maskIndex = maskYBase + xMod;
                int sPixelOffset = sLineOffset;
                int dPixelOffset = dLineOffset;
                for (int w = 0; w < dwidth; ++w) {
                    int bDIndex = dPixelOffset + dBandOffset;
                    for (int b2 = 0; b2 < sbands; ++b2) {
                        int bIndex = sPixelOffset + sBandOffsets[b2];
                        int tmp = (int)(sData[b2][bIndex] * (float)this.dims[b2]);
                        float frac = sData[b2][bIndex] * (float)this.dims[b2] - (float)tmp;
                        float result = dData[bDIndex] + (float)(tmp * this.mults[b2]);
                        if (frac > this.maskDataFloat[b2][maskIndex]) {
                            result += (float)this.mults[b2];
                        }
                        dData[bDIndex] = result;
                    }
                    sPixelOffset += sPixelStride;
                    dPixelOffset += dPixelStride;
                    if (++maskIndex < maskLimit) continue;
                    maskIndex = maskYBase;
                }
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dheight; ++h3) {
                int y = y0 + h3;
                int yMod = y % this.maskHeight;
                int maskYBase = yMod * this.maskWidth;
                int maskLimit = maskYBase + this.maskWidth;
                int maskIndex = maskYBase + xMod;
                int sPixelOffset = sLineOffset;
                int dPixelOffset = dLineOffset;
                for (int w = 0; w < dwidth; ++w) {
                    int x = x0 + w;
                    int bDIndex = dPixelOffset + dBandOffset;
                    if (this.roiBounds.contains(x, y) && roiIter.getSample(x, y, 0) > 0) {
                        for (int b3 = 0; b3 < sbands; ++b3) {
                            int bIndex = sPixelOffset + sBandOffsets[b3];
                            int tmp = (int)(sData[b3][bIndex] * (float)this.dims[b3]);
                            float frac = sData[b3][bIndex] * (float)this.dims[b3] - (float)tmp;
                            float result = dData[bDIndex] + (float)(tmp * this.mults[b3]);
                            if (frac > this.maskDataFloat[b3][maskIndex]) {
                                result += (float)this.mults[b3];
                            }
                            dData[bDIndex] = result;
                        }
                    } else {
                        dData[bDIndex] = (float)this.destNoData;
                    }
                    sPixelOffset += sPixelStride;
                    dPixelOffset += dPixelStride;
                    if (++maskIndex < maskLimit) continue;
                    maskIndex = maskYBase;
                }
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h4 = 0; h4 < dheight; ++h4) {
                int yMod = (y0 + h4) % this.maskHeight;
                int maskYBase = yMod * this.maskWidth;
                int maskLimit = maskYBase + this.maskWidth;
                int maskIndex = maskYBase + xMod;
                int sPixelOffset = sLineOffset;
                int dPixelOffset = dLineOffset;
                for (int w = 0; w < dwidth; ++w) {
                    boolean valid = true;
                    int bDIndex = dPixelOffset + dBandOffset;
                    for (int b4 = 0; b4 < sbands && valid; ++b4) {
                        int bIndex = sPixelOffset + sBandOffsets[b4];
                        float value = sData[b4][bIndex];
                        valid &= !this.nodata.contains(value);
                        int tmp = (int)(value * (float)this.dims[b4]);
                        float frac = value * (float)this.dims[b4] - (float)tmp;
                        float result = dData[bDIndex] + (float)(tmp * this.mults[b4]);
                        if (frac > this.maskDataFloat[b4][maskIndex]) {
                            result += (float)this.mults[b4];
                        }
                        dData[bDIndex] = result;
                    }
                    if (!valid) {
                        dData[bDIndex] = (float)this.destNoData;
                    }
                    sPixelOffset += sPixelStride;
                    dPixelOffset += dPixelStride;
                    if (++maskIndex < maskLimit) continue;
                    maskIndex = maskYBase;
                }
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
            }
        } else {
            for (int h5 = 0; h5 < dheight; ++h5) {
                int y = y0 + h5;
                int yMod = y % this.maskHeight;
                int maskYBase = yMod * this.maskWidth;
                int maskLimit = maskYBase + this.maskWidth;
                int maskIndex = maskYBase + xMod;
                int sPixelOffset = sLineOffset;
                int dPixelOffset = dLineOffset;
                for (int w = 0; w < dwidth; ++w) {
                    int x = x0 + w;
                    int bDIndex = dPixelOffset + dBandOffset;
                    if (this.roiBounds.contains(x, y) && roiIter.getSample(x, y, 0) > 0) {
                        boolean valid = true;
                        for (int b5 = 0; b5 < sbands && valid; ++b5) {
                            int bIndex = sPixelOffset + sBandOffsets[b5];
                            float value = sData[b5][bIndex];
                            valid &= !this.nodata.contains(value);
                            int tmp = (int)(value * (float)this.dims[b5]);
                            float frac = value * (float)this.dims[b5] - (float)tmp;
                            float result = dData[bDIndex] + (float)(tmp * this.mults[b5]);
                            if (frac > this.maskDataFloat[b5][maskIndex]) {
                                result += (float)this.mults[b5];
                            }
                            dData[bDIndex] = result;
                        }
                        if (!valid) {
                            dData[bDIndex] = (float)this.destNoData;
                        }
                    } else {
                        dData[bDIndex] = (float)this.destNoData;
                    }
                    sPixelOffset += sPixelStride;
                    dPixelOffset += dPixelStride;
                    if (++maskIndex < maskLimit) continue;
                    maskIndex = maskYBase;
                }
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
            }
        }
    }

    private void computeRectDouble(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int sbands = src.getNumBands();
        int sLineStride = src.getScanlineStride();
        int sPixelStride = src.getPixelStride();
        int[] sBandOffsets = src.getBandOffsets();
        double[][] sData = src.getDoubleDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int dBandOffset = dst.getBandOffset(0);
        double[] dData = dst.getDoubleDataArray(0);
        if (this.adjustedOffset != 0) {
            Arrays.fill(dData, (double)this.adjustedOffset);
        }
        int x0 = dst.getX();
        int xMod = x0 % this.maskWidth;
        int y0 = dst.getY();
        int sLineOffset = 0;
        int dLineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dheight; ++h2) {
                int yMod = (y0 + h2) % this.maskHeight;
                int maskYBase = yMod * this.maskWidth;
                int maskLimit = maskYBase + this.maskWidth;
                int maskIndex = maskYBase + xMod;
                int sPixelOffset = sLineOffset;
                int dPixelOffset = dLineOffset;
                for (int w = 0; w < dwidth; ++w) {
                    int bDIndex = dPixelOffset + dBandOffset;
                    for (int b2 = 0; b2 < sbands; ++b2) {
                        int bIndex = sPixelOffset + sBandOffsets[b2];
                        int tmp = (int)(sData[b2][bIndex] * (double)this.dims[b2]);
                        float frac = (float)(sData[b2][bIndex] * (double)this.dims[b2] - (double)tmp);
                        double result = dData[bDIndex] + (double)(tmp * this.mults[b2]);
                        if (frac > this.maskDataFloat[b2][maskIndex]) {
                            result += (double)this.mults[b2];
                        }
                        dData[bDIndex] = result;
                    }
                    sPixelOffset += sPixelStride;
                    dPixelOffset += dPixelStride;
                    if (++maskIndex < maskLimit) continue;
                    maskIndex = maskYBase;
                }
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dheight; ++h3) {
                int y = y0 + h3;
                int yMod = y % this.maskHeight;
                int maskYBase = yMod * this.maskWidth;
                int maskLimit = maskYBase + this.maskWidth;
                int maskIndex = maskYBase + xMod;
                int sPixelOffset = sLineOffset;
                int dPixelOffset = dLineOffset;
                for (int w = 0; w < dwidth; ++w) {
                    int x = x0 + w;
                    int bDIndex = dPixelOffset + dBandOffset;
                    if (this.roiBounds.contains(x, y) && roiIter.getSample(x, y, 0) > 0) {
                        for (int b3 = 0; b3 < sbands; ++b3) {
                            int bIndex = sPixelOffset + sBandOffsets[b3];
                            int tmp = (int)(sData[b3][bIndex] * (double)this.dims[b3]);
                            float frac = (float)(sData[b3][bIndex] * (double)this.dims[b3] - (double)tmp);
                            double result = dData[bDIndex] + (double)(tmp * this.mults[b3]);
                            if (frac > this.maskDataFloat[b3][maskIndex]) {
                                result += (double)this.mults[b3];
                            }
                            dData[bDIndex] = result;
                        }
                    } else {
                        dData[bDIndex] = this.destNoData;
                    }
                    sPixelOffset += sPixelStride;
                    dPixelOffset += dPixelStride;
                    if (++maskIndex < maskLimit) continue;
                    maskIndex = maskYBase;
                }
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h4 = 0; h4 < dheight; ++h4) {
                int yMod = (y0 + h4) % this.maskHeight;
                int maskYBase = yMod * this.maskWidth;
                int maskLimit = maskYBase + this.maskWidth;
                int maskIndex = maskYBase + xMod;
                int sPixelOffset = sLineOffset;
                int dPixelOffset = dLineOffset;
                for (int w = 0; w < dwidth; ++w) {
                    boolean valid = true;
                    int bDIndex = dPixelOffset + dBandOffset;
                    for (int b4 = 0; b4 < sbands && valid; ++b4) {
                        int bIndex = sPixelOffset + sBandOffsets[b4];
                        double value = sData[b4][bIndex];
                        valid &= !this.nodata.contains(value);
                        int tmp = (int)(value * (double)this.dims[b4]);
                        float frac = (float)(value * (double)this.dims[b4] - (double)tmp);
                        double result = dData[bDIndex] + (double)(tmp * this.mults[b4]);
                        if (frac > this.maskDataFloat[b4][maskIndex]) {
                            result += (double)this.mults[b4];
                        }
                        dData[bDIndex] = result;
                    }
                    if (!valid) {
                        dData[bDIndex] = this.destNoData;
                    }
                    sPixelOffset += sPixelStride;
                    dPixelOffset += dPixelStride;
                    if (++maskIndex < maskLimit) continue;
                    maskIndex = maskYBase;
                }
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
            }
        } else {
            for (int h5 = 0; h5 < dheight; ++h5) {
                int y = y0 + h5;
                int yMod = y % this.maskHeight;
                int maskYBase = yMod * this.maskWidth;
                int maskLimit = maskYBase + this.maskWidth;
                int maskIndex = maskYBase + xMod;
                int sPixelOffset = sLineOffset;
                int dPixelOffset = dLineOffset;
                for (int w = 0; w < dwidth; ++w) {
                    int x = x0 + w;
                    int bDIndex = dPixelOffset + dBandOffset;
                    if (this.roiBounds.contains(x, y) && roiIter.getSample(x, y, 0) > 0) {
                        boolean valid = true;
                        for (int b5 = 0; b5 < sbands && valid; ++b5) {
                            int bIndex = sPixelOffset + sBandOffsets[b5];
                            double value = sData[b5][bIndex];
                            valid &= !this.nodata.contains(value);
                            int tmp = (int)(value * (double)this.dims[b5]);
                            float frac = (float)(value * (double)this.dims[b5] - (double)tmp);
                            double result = dData[bDIndex] + (double)(tmp * this.mults[b5]);
                            if (frac > this.maskDataFloat[b5][maskIndex]) {
                                result += (double)this.mults[b5];
                            }
                            dData[bDIndex] = result;
                        }
                        if (!valid) {
                            dData[bDIndex] = this.destNoData;
                        }
                    } else {
                        dData[bDIndex] = this.destNoData;
                    }
                    sPixelOffset += sPixelStride;
                    dPixelOffset += dPixelStride;
                    if (++maskIndex < maskLimit) continue;
                    maskIndex = maskYBase;
                }
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlanarImage getImage() {
        PlanarImage img = this.roiImage;
        if (img == null) {
            OrderedDitherOpImage orderedDitherOpImage = this;
            synchronized (orderedDitherOpImage) {
                img = this.roiImage;
                if (img == null) {
                    this.roiImage = img = this.roi.getAsImage();
                }
            }
        }
        return img;
    }

    class DitherLUT {
        private int[] dimsCache;
        private int[] multsCache;
        private byte[][] maskDataCache;
        public int ditherLUTBandStride;
        public int ditherLUTRowStride;
        public int ditherLUTColStride;
        public byte[] ditherLUT;

        DitherLUT(int[] dims, int[] mults, byte[][] maskData) {
            this.dimsCache = (int[])dims.clone();
            this.multsCache = (int[])mults.clone();
            this.maskDataCache = new byte[maskData.length][];
            for (int i = 0; i < maskData.length; ++i) {
                this.maskDataCache[i] = (byte[])maskData[i].clone();
            }
            this.ditherLUTColStride = 256;
            this.ditherLUTRowStride = OrderedDitherOpImage.this.maskWidth * this.ditherLUTColStride;
            this.ditherLUTBandStride = OrderedDitherOpImage.this.maskHeight * this.ditherLUTRowStride;
            this.ditherLUT = new byte[OrderedDitherOpImage.this.numBands * this.ditherLUTBandStride];
            int pDithBand = 0;
            int maskSize2D = OrderedDitherOpImage.this.maskWidth * OrderedDitherOpImage.this.maskHeight;
            for (int band = 0; band < OrderedDitherOpImage.this.numBands; ++band) {
                int step = dims[band];
                int delta = mults[band];
                byte[] maskDataBand = maskData[band];
                int sum = 0;
                for (int gray = 0; gray < 256; ++gray) {
                    int tmp = sum;
                    int frac = tmp & 0xFF;
                    int bin = tmp >> 8;
                    int lowVal = bin * delta;
                    int highVal = lowVal + delta;
                    int pDith = pDithBand + gray;
                    for (int dcount = 0; dcount < maskSize2D; ++dcount) {
                        int threshold = maskDataBand[dcount] & 0xFF;
                        this.ditherLUT[pDith] = frac > threshold ? (byte)(highVal & 0xFF) : (byte)(lowVal & 0xFF);
                        pDith += 256;
                    }
                    sum += step;
                }
                pDithBand += this.ditherLUTBandStride;
            }
        }

        public boolean equals(int[] dims, int[] mults, byte[][] maskData) {
            int i;
            if (dims.length != this.dimsCache.length) {
                return false;
            }
            for (i = 0; i < dims.length; ++i) {
                if (dims[i] == this.dimsCache[i]) continue;
                return false;
            }
            if (mults.length != this.multsCache.length) {
                return false;
            }
            for (i = 0; i < mults.length; ++i) {
                if (mults[i] == this.multsCache[i]) continue;
                return false;
            }
            if (maskData.length != OrderedDitherOpImage.this.maskDataByte.length) {
                return false;
            }
            for (i = 0; i < maskData.length; ++i) {
                if (maskData[i].length != this.maskDataCache[i].length) {
                    return false;
                }
                byte[] refData = this.maskDataCache[i];
                byte[] data = maskData[i];
                for (int j = 0; j < maskData[i].length; ++j) {
                    if (data[j] == refData[j]) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

