/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.pam;

import it.geosolutions.imageio.pam.PAMDataset;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class PAMParser {
    private static PAMParser instance = null;
    private static JAXBContext CONTEXT;
    private static final Logger LOGGER;

    public static synchronized PAMParser getInstance() {
        if (instance == null) {
            instance = new PAMParser();
        }
        return instance;
    }

    public PAMDataset parsePAM(String filePath) throws IOException {
        File file = new File(filePath);
        return this.parsePAM(file);
    }

    public PAMDataset parsePAM(File file) throws IOException {
        PAMDataset pamDataset;
        try {
            pamDataset = this.unmarshal(file);
        }
        catch (JAXBException e2) {
            throw new IOException("Exception occurred while parsing the file", e2);
        }
        return pamDataset;
    }

    private PAMDataset unmarshal(File pamFile) throws JAXBException {
        Unmarshaller unmarshaller = null;
        PAMDataset pamDataset = null;
        if (pamFile != null) {
            unmarshaller = CONTEXT.createUnmarshaller();
            pamDataset = (PAMDataset)unmarshaller.unmarshal(pamFile);
        }
        return pamDataset;
    }

    public String getMetadataValue(PAMDataset.PAMRasterBand rasterBand, String key) {
        if (rasterBand == null) {
            throw new IllegalArgumentException("Specified raster band is null");
        }
        PAMDataset.PAMRasterBand.Metadata metadata = rasterBand.getMetadata();
        if (metadata == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("No metadata have been found from the provided Raster band");
            }
            return null;
        }
        List<PAMDataset.PAMRasterBand.Metadata.MDI> mdis = metadata.getMDI();
        if ((mdis == null || mdis.size() == 0) && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("No metadata have been found from the provided Raster band");
        }
        for (PAMDataset.PAMRasterBand.Metadata.MDI mdi : mdis) {
            if (!mdi.getKey().equalsIgnoreCase(key)) continue;
            return mdi.getValue();
        }
        return null;
    }

    static {
        LOGGER = Logger.getLogger(PAMParser.class.toString());
        try {
            CONTEXT = JAXBContext.newInstance("it.geosolutions.imageio.pam");
        }
        catch (JAXBException e2) {
            LOGGER.log(Level.FINER, e2.getMessage(), e2);
        }
    }
}

