% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/history.R
\name{revert}
\alias{revert}
\title{Revert Lockfile}
\usage{
revert(commit = "HEAD", ..., project = NULL)
}
\arguments{
\item{commit}{The commit associated with a prior version of the lockfile.}

\item{...}{Optional arguments; currently unused.}

\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}
}
\value{
The commit used when reverting \code{renv.lock}. Note that this function
is normally called for its side effects.
}
\description{
Revert the lockfile to its contents at a prior commit.
}
\details{
The \code{revert()} function is currently only implemented for projects using
\code{git} for version control.
}
\examples{

\dontrun{

# get history of previous versions of renv.lock in VCS
db <- renv::history()

# choose an older commit
commit <- db$commit[5]

# revert to that version of the lockfile
renv::revert(commit = commit)

}
}
