/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.util.ArrayList;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.element.AbstractBasisSet;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLAtomicBasisFunction;
import org.xmlcml.cml.element.CMLEigen;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.molutil.ChemicalElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMLBasisSet
extends AbstractBasisSet {
    CMLMolecule molecule = null;
    Basis basis = null;
    CMLEigen coefficients = null;

    public CMLBasisSet() {
    }

    public CMLBasisSet(CMLBasisSet old) {
        super(old);
    }

    @Override
    public Node copy() {
        return new CMLBasisSet(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLBasisSet();
    }

    public CMLBasisSet(Basis basis, CMLMolecule molecule) {
        this.basis = basis;
        this.molecule = molecule;
    }

    public List<CMLAtomicBasisFunction> getABFsByL(int l) {
        ArrayList<CMLAtomicBasisFunction> abfList = new ArrayList<CMLAtomicBasisFunction>();
        CMLElements<CMLAtomicBasisFunction> abChildList = this.getAtomicBasisFunctionElements();
        for (CMLAtomicBasisFunction abf : abChildList) {
            if (abf.getLAttribute() == null || abf.getL() != l) continue;
            abfList.add(abf);
        }
        return abfList;
    }

    public List<CMLAtomicBasisFunction> getABFsByM(int m) {
        ArrayList<CMLAtomicBasisFunction> abfList = new ArrayList<CMLAtomicBasisFunction>();
        CMLElements<CMLAtomicBasisFunction> abChildList = this.getAtomicBasisFunctionElements();
        for (CMLAtomicBasisFunction abf : abChildList) {
            if (abf.getMAttribute() == null || abf.getM() != m) continue;
            abfList.add(abf);
        }
        return abfList;
    }

    public List<CMLAtomicBasisFunction> getABFsByN(int n) {
        ArrayList<CMLAtomicBasisFunction> abfList = new ArrayList<CMLAtomicBasisFunction>();
        CMLElements<CMLAtomicBasisFunction> abChildList = this.getAtomicBasisFunctionElements();
        for (CMLAtomicBasisFunction abf : abChildList) {
            if (abf.getNAttribute() == null || abf.getN() != n) continue;
            abfList.add(abf);
        }
        return abfList;
    }

    public List<CMLAtomicBasisFunction> getABFsByLM(String lm) {
        ArrayList<CMLAtomicBasisFunction> abfList = new ArrayList<CMLAtomicBasisFunction>();
        CMLElements<CMLAtomicBasisFunction> abChildList = this.getAtomicBasisFunctionElements();
        for (CMLAtomicBasisFunction abf : abChildList) {
            if (!lm.equals(abf.getLm())) continue;
            abfList.add(abf);
        }
        return abfList;
    }

    public List<CMLAtomicBasisFunction> getABFsBySymbol(String symbol) {
        ArrayList<CMLAtomicBasisFunction> abfList = new ArrayList<CMLAtomicBasisFunction>();
        if (symbol != null) {
            CMLElements<CMLAtomicBasisFunction> abChildList = this.getAtomicBasisFunctionElements();
            for (CMLAtomicBasisFunction abf : abChildList) {
                if (!symbol.equals(abf.getSymbol())) continue;
                abfList.add(abf);
            }
        }
        return abfList;
    }

    public void setMolecule(CMLMolecule mol) {
        this.molecule = mol;
    }

    public void setBasis(Basis basis) {
        this.basis = basis;
    }

    public void setMolecularOrbitalCoefficients(CMLEigen coefficients) {
        if (this.getAtomicBasisFunctionElements().size() != coefficients.getSize()) {
            throw new RuntimeException("Number of orbitals (" + this.getAtomicBasisFunctionElements().size() + ") inconsistent with size of matrix (" + coefficients.getSize() + ")");
        }
        this.coefficients = coefficients;
    }

    CMLBasisSet createBasisSet() {
        CMLBasisSet basisSet = null;
        if (this.molecule != null && this.basis != null) {
            basisSet = new CMLBasisSet();
            List<CMLAtom> atoms = this.molecule.getAtoms();
            if (this.basis.equals((Object)Basis.MINIMAL)) {
                for (CMLAtom atom : atoms) {
                    List<CMLAtomicBasisFunction> abfList = CMLAtomicBasisFunction.getABFList(atom, this.basis);
                    for (CMLAtomicBasisFunction abf : abfList) {
                        basisSet.addAtomicBasisFunction(abf);
                    }
                }
            } else {
                throw new RuntimeException("Unsupported basis set " + this.basis.value);
            }
        }
        return basisSet;
    }

    public int getElectronCount() {
        int count = 0;
        if (this.molecule != null && this.basis != null) {
            List<CMLAtom> atoms = this.molecule.getAtoms();
            for (CMLAtom atom : atoms) {
                if (this.basis.equals((Object)Basis.MINIMAL)) {
                    ChemicalElement element = atom.getChemicalElement();
                    int nValence = element.getValenceElectrons();
                    count += nValence;
                    continue;
                }
                throw new RuntimeException("Basis set not supported: " + (Object)((Object)this.basis));
            }
            if (this.molecule.getFormalChargeAttribute() != null) {
                count -= this.molecule.getFormalCharge();
            }
        }
        return count;
    }

    public String getString() {
        StringBuffer sb = new StringBuffer("basis: " + (Object)((Object)this.basis) + "\n");
        CMLElements<CMLAtomicBasisFunction> abfList = this.getAtomicBasisFunctionElements();
        for (int i = 0; i < abfList.size(); ++i) {
            sb.append(abfList.get(i).getString());
            if (i >= abfList.size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Basis {
        MINIMAL("minimal", "H s else s+3p");

        public String value;
        public String desc;

        private Basis(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }
    }
}

