/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.HashMap;
import java.util.Map;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class JPlogPDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static final String[] NAMES = new String[]{"JPLogP"};
    private boolean addImplicitH = true;
    JPlogPCalculator jplogp = new JPlogPCalculator();

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("JPlogP developed at Lhasa Limited www.lhasalimited.org", this.getClass().getName(), "Jeffrey Plante - Lhasa Limited");
    }

    @Override
    public String[] getParameterNames() {
        String[] params = new String[]{"addImplicitH"};
        return params;
    }

    @Override
    public Object getParameterType(String name) {
        if ("addImplicitH".equals(name)) {
            return true;
        }
        return null;
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length != 1) {
            throw new CDKException("JPLogPDescriptor expects one parameter");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("The parameter must be of type Boolean");
        }
        this.addImplicitH = (Boolean)params[0];
    }

    @Override
    public Object[] getParameters() {
        Object[] params = new Object[]{this.addImplicitH};
        return params;
    }

    @Override
    public String[] getDescriptorNames() {
        return NAMES;
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleResult(0.0);
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), this.getDescriptorNames(), e);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer container) {
        IAtomContainer struct;
        try {
            struct = container.clone();
            AtomContainerManipulator.percieveAtomTypesAndConfigureUnsetProperties(struct);
            CDKHydrogenAdder hAdder = CDKHydrogenAdder.getInstance(struct.getBuilder());
            hAdder.addImplicitHydrogens(struct);
            AtomContainerManipulator.convertImplicitToExplicitHydrogens(struct);
            Aromaticity.cdkLegacy().apply(struct);
        }
        catch (CloneNotSupportedException e) {
            return this.getDummyDescriptorValue(e);
        }
        catch (CDKException e) {
            return this.getDummyDescriptorValue(e);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(this.jplogp.calcLogP(struct)), this.getDescriptorNames());
    }

    protected class JPlogPCalculator {
        Map<Integer, Double> coeffs = new HashMap<Integer, Double>();

        public JPlogPCalculator() {
            this.initcoeffs();
        }

        protected Double calcLogP(IAtomContainer struct) {
            boolean inDomain = true;
            Double logP = 0.0;
            for (IAtom atom : struct.atoms()) {
                Integer atomtype = this.getAtomTypeCode(atom);
                Double increment = 0.0;
                try {
                    increment = this.coeffs.get(atomtype);
                }
                catch (NullPointerException e) {
                    inDomain = false;
                }
                if (inDomain && increment != null) {
                    logP = logP + increment;
                    continue;
                }
                System.out.println(atomtype + " not found");
                return Double.NaN;
            }
            return logP;
        }

        public Map<Integer, Integer> getMappedHologram(IAtomContainer struct) {
            HashMap<Integer, Integer> holo = new HashMap<Integer, Integer>();
            for (int i = 0; i < struct.getAtomCount(); ++i) {
                IAtom atom = struct.getAtom(i);
                Integer type = this.getAtomTypeCode(atom);
                if (holo.containsKey(type)) {
                    int count = (Integer)holo.get(type);
                    holo.put(type, ++count);
                    continue;
                }
                holo.put(type, 1);
            }
            return holo;
        }

        private Integer getAtomTypeCode(IAtom atom) {
            Integer returnMe = 0;
            String element = atom.getSymbol();
            int nonHNeighbours = this.nonHNeighbours(atom);
            int charge = atom.getFormalCharge();
            int aNum = atom.getAtomicNumber();
            int toadd = 0;
            returnMe = returnMe + 100000 * (charge + 1);
            returnMe = returnMe + aNum * 1000;
            returnMe = returnMe + nonHNeighbours * 100;
            switch (element) {
                case "C": {
                    toadd = this.getCarbonSpecial(atom);
                    break;
                }
                case "N": {
                    toadd = this.getNitrogenSpecial(atom);
                    break;
                }
                case "O": {
                    toadd = this.getOxygenSpecial(atom);
                    break;
                }
                case "H": {
                    toadd = this.getHydrogenSpecial(atom);
                    break;
                }
                case "F": {
                    toadd = this.getFluorineSpecial(atom);
                    break;
                }
                default: {
                    toadd = this.getDefaultSpecial(atom);
                }
            }
            returnMe = returnMe + toadd;
            if (toadd != 99) {
                return returnMe;
            }
            return null;
        }

        protected int getHydrogenSpecial(IAtom atom) {
            int toadd = 0;
            int bondCount = atom.getBondCount();
            if (bondCount > 0) {
                IAtom neighbour = atom.bonds().iterator().next().getOther(atom);
                int numNeighbours = neighbour.getBondCount();
                if (neighbour.getSymbol().equals("C")) {
                    if (this.carbonylConjugated(neighbour)) {
                        toadd = 51;
                    } else {
                        double formalOxState = this.getNumMoreElectronegativethanCarbon(neighbour);
                        switch (numNeighbours) {
                            case 4: {
                                if (formalOxState == 0.0) {
                                    toadd = 46;
                                    break;
                                }
                                if (formalOxState == 1.0) {
                                    toadd = 47;
                                    break;
                                }
                                if (formalOxState == 2.0) {
                                    toadd = 48;
                                    break;
                                }
                                if (formalOxState != 3.0) break;
                                toadd = 49;
                                break;
                            }
                            case 3: {
                                if (formalOxState == 0.0) {
                                    toadd = 47;
                                    break;
                                }
                                if (formalOxState == 1.0) {
                                    toadd = 48;
                                    break;
                                }
                                if (!(formalOxState >= 2.0)) break;
                                toadd = 49;
                                break;
                            }
                            case 2: {
                                if (formalOxState == 0.0) {
                                    toadd = 48;
                                    break;
                                }
                                if (!(formalOxState >= 1.0)) break;
                                toadd = 49;
                                break;
                            }
                            case 1: {
                                toadd = 121;
                            }
                        }
                    }
                } else {
                    toadd = 50;
                }
            }
            return toadd;
        }

        protected int getDefaultSpecial(IAtom atom) {
            int[] polarbondCounts = this.getPolarBondArray(atom);
            int singleBondPolar = polarbondCounts[0];
            int doubleBondPolar = polarbondCounts[2];
            int tripleBondPolar = polarbondCounts[3];
            int aromaticBondPolar = polarbondCounts[1];
            int toadd = atom.isAromatic() ? 10 : singleBondPolar + doubleBondPolar + tripleBondPolar + aromaticBondPolar;
            return toadd;
        }

        protected int getFluorineSpecial(IAtom atom) {
            int toadd;
            int numconn = atom.getBondCount();
            int neighbourconn = 0;
            if (numconn == 1) {
                IBond bond = atom.bonds().iterator().next();
                IAtom next = bond.getOther(atom);
                neighbourconn = next.getBondCount();
                double ox = this.getNumMoreElectronegativethanCarbon(next);
                toadd = next.getSymbol().matches("S") ? 8 : (next.getSymbol().matches("B") ? 9 : (!next.getSymbol().matches("C") ? 1 : (neighbourconn == 2 ? 2 : (neighbourconn == 3 ? 3 : (neighbourconn == 4 && ox <= 2.0 ? 5 : (neighbourconn == 4 && ox > 2.0 ? 7 : 99))))));
            } else {
                toadd = 99;
            }
            return toadd;
        }

        protected int getOxygenSpecial(IAtom atom) {
            int toadd;
            int numConnections = atom.getBondCount();
            switch (numConnections) {
                case 2: {
                    if (this.boundTo(atom, "N")) {
                        toadd = 1;
                        break;
                    }
                    if (this.boundTo(atom, "S")) {
                        toadd = 2;
                        break;
                    }
                    if (atom.isAromatic()) {
                        toadd = 8;
                        break;
                    }
                    toadd = 3;
                    break;
                }
                case 1: {
                    if (this.boundTo(atom, "N")) {
                        toadd = 4;
                        break;
                    }
                    if (this.boundTo(atom, "S")) {
                        toadd = 5;
                        break;
                    }
                    if (this.checkAlphaCarbonyl(atom, "O")) {
                        toadd = 6;
                        break;
                    }
                    if (this.checkAlphaCarbonyl(atom, "N")) {
                        toadd = 9;
                        break;
                    }
                    if (this.checkAlphaCarbonyl(atom, "S")) {
                        toadd = 10;
                        break;
                    }
                    toadd = 7;
                    break;
                }
                default: {
                    toadd = 0;
                }
            }
            return toadd;
        }

        protected int getNitrogenSpecial(IAtom atom) {
            int toadd;
            int numConnections = atom.getBondCount();
            int[] polarbondCounts = this.getPolarBondArray(atom);
            int singleBondPolar = polarbondCounts[0];
            switch (numConnections) {
                case 4: {
                    toadd = 9;
                    break;
                }
                case 3: {
                    if (this.nextToAromatic(atom)) {
                        toadd = 1;
                        break;
                    }
                    if (this.carbonylConjugated(atom)) {
                        toadd = 2;
                        break;
                    }
                    if (this.doubleBondHetero(atom)) {
                        toadd = 10;
                        break;
                    }
                    if (singleBondPolar > 0) {
                        toadd = 3;
                        break;
                    }
                    toadd = 4;
                    break;
                }
                case 2: {
                    if (atom.isAromatic()) {
                        toadd = 5;
                        break;
                    }
                    if (this.doubleBondHetero(atom)) {
                        toadd = 6;
                        break;
                    }
                    toadd = 7;
                    break;
                }
                case 1: {
                    toadd = 8;
                    break;
                }
                default: {
                    toadd = 0;
                }
            }
            return toadd;
        }

        protected int getCarbonSpecial(IAtom atom) {
            int toadd;
            int numConnections = atom.getBondCount();
            int[] polarbondCounts = this.getPolarBondArray(atom);
            int singleBondPolar = polarbondCounts[0];
            int doubleBondPolar = polarbondCounts[2];
            int tripleBondPolar = polarbondCounts[3];
            int aromaticBondPolar = polarbondCounts[1];
            switch (numConnections) {
                case 4: {
                    toadd = 2;
                    if (singleBondPolar <= 0) break;
                    toadd = 3;
                    break;
                }
                case 3: {
                    if (atom.isAromatic()) {
                        if (aromaticBondPolar >= 1 && singleBondPolar == 0) {
                            toadd = 11;
                            break;
                        }
                        if (aromaticBondPolar == 0 && singleBondPolar == 1) {
                            toadd = 5;
                            break;
                        }
                        if (aromaticBondPolar >= 1 && singleBondPolar == 1) {
                            toadd = 13;
                            break;
                        }
                        toadd = 4;
                        break;
                    }
                    if (doubleBondPolar == 1 && singleBondPolar == 0) {
                        toadd = 7;
                        break;
                    }
                    if (singleBondPolar >= 1 && doubleBondPolar == 0) {
                        toadd = 8;
                        break;
                    }
                    if (doubleBondPolar == 1 && singleBondPolar >= 1) {
                        toadd = 14;
                        break;
                    }
                    toadd = 6;
                    break;
                }
                case 2: {
                    if (tripleBondPolar == 1 && singleBondPolar == 0) {
                        toadd = 12;
                        break;
                    }
                    if (tripleBondPolar == 0 && singleBondPolar == 1) {
                        toadd = 10;
                        break;
                    }
                    if (tripleBondPolar == 1 && singleBondPolar == 1) {
                        toadd = 15;
                        break;
                    }
                    toadd = 9;
                    break;
                }
                default: {
                    toadd = 0;
                    if (singleBondPolar <= 0 && doubleBondPolar <= 0 && aromaticBondPolar <= 0 && tripleBondPolar <= 0) break;
                    toadd = 1;
                }
            }
            return toadd;
        }

        protected boolean checkAlphaCarbonyl(IAtom atom, String symbol) {
            for (IBond bond : atom.bonds()) {
                IAtom next = bond.getOther(atom);
                for (IBond bond2 : next.bonds()) {
                    IAtom next2 = bond2.getOther(next);
                    if (!next2.getSymbol().equals(symbol) || bond2.getOrder().numeric() != 1) continue;
                    return true;
                }
            }
            return false;
        }

        protected boolean boundTo(IAtom atom, String symbol) {
            for (IBond bond : atom.bonds()) {
                IAtom next = bond.getOther(atom);
                if (!next.getSymbol().equals(symbol)) continue;
                return true;
            }
            return false;
        }

        protected double getNumMoreElectronegativethanCarbon(IAtom atom) {
            double returnme = 0.0;
            for (IBond bond : atom.bonds()) {
                IAtom compare = bond.getOther(atom);
                double bondOrder = bond.getOrder().numeric().intValue();
                if (!this.electronWithdrawing(compare)) continue;
                returnme += bondOrder;
            }
            return returnme;
        }

        protected boolean electronWithdrawing(IAtom atom) {
            String symbol = atom.getSymbol();
            return symbol.equals("N") || symbol.equals("O") || symbol.equals("S") || symbol.equals("F") || symbol.equals("Cl") || symbol.equals("Br") || symbol.equals("I");
        }

        protected int nonHNeighbours(IAtom atom) {
            int returnMe = 0;
            for (IBond bond : atom.bonds()) {
                IAtom neighbor = bond.getOther(atom);
                if (neighbor.getAtomicNumber() == 1) continue;
                ++returnMe;
            }
            return returnMe;
        }

        protected int[] getPolarBondArray(IAtom atom) {
            int[] array = new int[4];
            for (IBond bond : atom.bonds()) {
                IAtom neighbor = bond.getOther(atom);
                if (!this.isPolar(neighbor)) continue;
                if (bond.isAromatic()) {
                    array[1] = array[1] + 1;
                    continue;
                }
                if (bond.getOrder().numeric() == 1) {
                    array[0] = array[0] + 1;
                    continue;
                }
                if (bond.getOrder().numeric() == 2) {
                    array[2] = array[2] + 1;
                    continue;
                }
                if (bond.getOrder().numeric() != 3) continue;
                array[3] = array[3] + 1;
            }
            return array;
        }

        protected boolean isPolar(IAtom atom) {
            return atom.getSymbol().matches("O") || atom.getSymbol().matches("S") || atom.getSymbol().matches("N") || atom.getSymbol().matches("P");
        }

        protected boolean doubleBondHetero(IAtom atom) {
            for (IBond bond : atom.bonds()) {
                IAtom neighbour = bond.getOther(atom);
                if (bond.isAromatic() || !this.isPolar(neighbour) || bond.getOrder().numeric() != 2) continue;
                return true;
            }
            return false;
        }

        protected boolean carbonylConjugated(IAtom atom) {
            for (IBond bond : atom.bonds()) {
                IAtom next = bond.getOther(atom);
                if (bond.isAromatic() || bond.getOrder().numeric() != 1 || !this.doubleBondHetero(next)) continue;
                return true;
            }
            return false;
        }

        protected boolean nextToAromatic(IAtom atom) {
            if (!atom.isAromatic()) {
                for (IBond bond : atom.bonds()) {
                    IAtom next = bond.getOther(atom);
                    if (!next.isAromatic() || bond.getOrder().numeric() != 1) continue;
                    return true;
                }
            }
            return false;
        }

        private void initcoeffs() {
            this.coeffs.put(115200, 0.3428999504964441);
            this.coeffs.put(134400, -0.6009339899021935);
            this.coeffs.put(207110, -0.2537868203838485);
            this.coeffs.put(134404, -1.175240011610751);
            this.coeffs.put(153100, 0.9269788584798107);
            this.coeffs.put(153101, 1.0143514773529836);
            this.coeffs.put(133402, -0.25834811742258956);
            this.coeffs.put(114200, 0.02852160272741147);
            this.coeffs.put(133403, -0.8194572348477968);
            this.coeffs.put(5401, 0.10394247591686294);
            this.coeffs.put(101147, 1.1304660454056645);
            this.coeffs.put(5402, 0.05199289233087018);
            this.coeffs.put(101146, 1.2682622213479229);
            this.coeffs.put(133401, -0.3667171872036366);
            this.coeffs.put(5403, 0.6787470799044643);
            this.coeffs.put(101149, 1.1949147655182892);
            this.coeffs.put(101148, 1.140089012601143);
            this.coeffs.put(101151, 1.124474664082366);
            this.coeffs.put(133404, -0.6914424692323852);
            this.coeffs.put(101150, -0.243037761960754);
            this.coeffs.put(107301, 0.17827258865107412);
            this.coeffs.put(107303, -0.018054804206490728);
            this.coeffs.put(107302, 0.174747113462705);
            this.coeffs.put(7207, -0.1900259417225229);
            this.coeffs.put(107304, 0.15377727288498777);
            this.coeffs.put(109101, 0.4139612626967727);
            this.coeffs.put(115501, -0.14127468400014018);
            this.coeffs.put(115500, 0.17611532140449737);
            this.coeffs.put(115503, 0.01466761555846904);
            this.coeffs.put(109103, 0.26645165703555906);
            this.coeffs.put(115502, -0.12059099254331078);
            this.coeffs.put(115505, -0.3426049607280402);
            this.coeffs.put(109105, 0.43024980310815464);
            this.coeffs.put(115504, -0.10220447776639764);
            this.coeffs.put(207409, -0.2390615198632319);
            this.coeffs.put(109107, 0.46498369443558685);
            this.coeffs.put(109109, 0.4802991193785544);
            this.coeffs.put(109108, 0.2432096581199898);
            this.coeffs.put(134202, -0.6346778955294479);
            this.coeffs.put(134200, -0.049120673015459124);
            this.coeffs.put(134201, 0.011636535054497877);
            this.coeffs.put(106303, -1.3926887806607753);
            this.coeffs.put(106302, -1.1712347846892444);
            this.coeffs.put(106305, 0.11166429492968204);
            this.coeffs.put(134210, 0.8723651043132042);
            this.coeffs.put(106304, 0.2093224791516782);
            this.coeffs.put(106307, -0.2713000174540411);
            this.coeffs.put(106306, 0.01721171808054029);
            this.coeffs.put(108101, -0.09302944637095042);
            this.coeffs.put(106308, 0.02622454278720872);
            this.coeffs.put(108103, 0.016350079235673567);
            this.coeffs.put(106311, 0.14287513828273285);
            this.coeffs.put(108102, 0.09827832065783548);
            this.coeffs.put(108105, -0.47007800462613053);
            this.coeffs.put(106313, 0.29015591756689035);
            this.coeffs.put(108104, 0.015437937018121088);
            this.coeffs.put(108107, 0.03827614806405689);
            this.coeffs.put(108106, 0.19321034882780294);
            this.coeffs.put(106314, -0.3943404186929503);
            this.coeffs.put(108109, -0.10401802166752877);
            this.coeffs.put(116301, -0.05382098343764403);
            this.coeffs.put(116300, 0.7387521460456399);
            this.coeffs.put(116303, -0.16756182500979416);
            this.coeffs.put(116302, -0.13139795079560512);
            this.coeffs.put(108110, 0.09217290650820302);
            this.coeffs.put(5201, 0.23346448860951585);
            this.coeffs.put(5202, 0.2039139119266068);
            this.coeffs.put(133200, -0.30769228187947917);
            this.coeffs.put(208208, 0.7096167841949101);
            this.coeffs.put(133201, -0.4991951722354514);
            this.coeffs.put(105301, -0.16207989873206854);
            this.coeffs.put(105300, -0.17440788934127419);
            this.coeffs.put(105303, -0.14262227829859978);
            this.coeffs.put(105302, -0.1772536453086892);
            this.coeffs.put(107101, 0.06472635260371458);
            this.coeffs.put(107103, -0.25579034271921075);
            this.coeffs.put(107102, 0.07815605927333318);
            this.coeffs.put(107104, -0.3248358665028741);
            this.coeffs.put(107107, 0.40442424583948916);
            this.coeffs.put(107106, 0.396893949325775);
            this.coeffs.put(207207, -0.07223876787467944);
            this.coeffs.put(115301, -0.02360338462248146);
            this.coeffs.put(107108, 0.11602222985765208);
            this.coeffs.put(207206, -0.24327541812800021);
            this.coeffs.put(115300, 0.08742831050292114);
            this.coeffs.put(115303, -0.23502791004771306);
            this.coeffs.put(115302, -0.10635975733575764);
            this.coeffs.put(117101, 0.7375898512161616);
            this.coeffs.put(117100, 0.711562233142568);
            this.coeffs.put(153200, 0.7953592172870871);
            this.coeffs.put(106103, -3.373528417699127);
            this.coeffs.put(106102, -3.222960398502975);
            this.coeffs.put(116600, 1.2414649166226785);
            this.coeffs.put(106107, -2.1610769299516286);
            this.coeffs.put(106106, -1.794277022889798);
            this.coeffs.put(114301, -0.13076494426939203);
            this.coeffs.put(106109, -0.7983974980016113);
            this.coeffs.put(114300, -0.2992443066268472);
            this.coeffs.put(114302, -0.3024419065452111);
            this.coeffs.put(106112, -1.1706517781448094);
            this.coeffs.put(116101, 1.25794766342382);
            this.coeffs.put(116100, 0.7033847677524618);
            this.coeffs.put(216210, 0.7111335744036255);
            this.coeffs.put(134302, -0.3781625467763615);
            this.coeffs.put(134303, -0.363065393849358);
            this.coeffs.put(134300, -0.46600673735969483);
            this.coeffs.put(134301, -0.38176583952591553);
            this.coeffs.put(106403, -0.6031848047124038);
            this.coeffs.put(106402, -0.19127514916328328);
            this.coeffs.put(8104, -0.24231144996862355);
            this.coeffs.put(108201, 0.03078259547644759);
            this.coeffs.put(8105, -0.42080392882157724);
            this.coeffs.put(108203, 0.16517108509661693);
            this.coeffs.put(8106, -0.29674843353741903);
            this.coeffs.put(108202, 0.12117897946674977);
            this.coeffs.put(116401, 0.7441487272627919);
            this.coeffs.put(108208, 0.06651412646122902);
            this.coeffs.put(116403, 0.3031855131038271);
            this.coeffs.put(116402, 0.543649606560247);
            this.coeffs.put(133302, -0.7027480278305203);
            this.coeffs.put(114100, 0.3786112153751248);
            this.coeffs.put(133303, -0.431414306011833);
            this.coeffs.put(116404, 0.02729394485921511);
            this.coeffs.put(133300, -0.20426419244061747);
            this.coeffs.put(133301, 0.2550357745554604);
            this.coeffs.put(135100, 0.8603178696688789);
            this.coeffs.put(135101, 0.7236559576494113);
            this.coeffs.put(107201, 0.260897789525647);
            this.coeffs.put(107203, 0.2070230861251806);
            this.coeffs.put(107202, 0.16622067949480449);
            this.coeffs.put(107205, -0.2544031618211347);
            this.coeffs.put(7108, 0.2615348564811823);
            this.coeffs.put(207303, -0.4723141310610628);
            this.coeffs.put(107204, 0.13376742355228766);
            this.coeffs.put(207302, 0.24697598201746412);
            this.coeffs.put(107207, 0.316655927726688);
            this.coeffs.put(207301, 0.36095025588716984);
            this.coeffs.put(107206, 0.3112912468366892);
            this.coeffs.put(115401, -0.33411394854894955);
            this.coeffs.put(115400, -0.10319130468863787);
            this.coeffs.put(115403, -0.7380151037685063);
            this.coeffs.put(207304, -0.07460535077700184);
            this.coeffs.put(115402, -0.38147795848833443);
            this.coeffs.put(115404, -0.8125502294660335);
            this.coeffs.put(207310, 0.3572618921544123);
            this.coeffs.put(153302, 0.6010094256860743);
            this.coeffs.put(134100, -0.13465231260837543);
            this.coeffs.put(134101, 0.11087519417725553);
            this.coeffs.put(153301, 0.5747227306225426);
            this.coeffs.put(106203, -2.393849677660491);
            this.coeffs.put(106202, -2.0873117350423795);
            this.coeffs.put(106204, -0.8226943130543642);
            this.coeffs.put(106207, -1.4051640234159233);
            this.coeffs.put(106206, -0.8797695620379107);
            this.coeffs.put(106209, 0.1943653458623092);
            this.coeffs.put(114401, -0.16364741554376241);
            this.coeffs.put(106208, -1.0638733077308757);
            this.coeffs.put(114400, -0.11449728057513861);
            this.coeffs.put(106211, -1.0460240915898267);
            this.coeffs.put(114403, -0.15482665868271833);
            this.coeffs.put(114402, -0.10981861418848725);
            this.coeffs.put(106210, 0.16195495590632014);
            this.coeffs.put(106212, -0.25091180447462924);
            this.coeffs.put(114404, -0.13028646729956206);
            this.coeffs.put(106215, -0.14549848501097237);
            this.coeffs.put(106214, -1.4797542026181651);
            this.coeffs.put(116201, 0.6388354010094074);
            this.coeffs.put(116200, 0.7924621516585404);
            this.coeffs.put(116202, 0.533270577934211);
            this.coeffs.put(216301, 0.16747913472407247);
            this.coeffs.put(216300, 0.8099240433489436);
            this.coeffs.put(105201, 0.07571701124699833);
            this.coeffs.put(105202, -0.06906898812339575);
            this.coeffs.put(116210, 0.5793769304831321);
            this.coeffs.put(216310, 0.16964757212192544);
        }

        public Map<Integer, Double> getCoeffs() {
            return this.coeffs;
        }

        public void setCoeffs(Map<Integer, Double> coeffs) {
            this.coeffs = coeffs;
        }
    }
}

