/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import com.google.common.base.Objects;
import java.io.Serializable;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.interfaces.IElement;

public class Element
extends ChemObject
implements Serializable,
IElement,
Cloneable {
    private static final long serialVersionUID = 3062529834691231436L;
    protected Integer atomicNumber = null;

    public Element() {
    }

    public Element(IElement element) {
        super(element);
        this.atomicNumber = element.getAtomicNumber();
    }

    public Element(String symbol) {
        this.setSymbolInternal(symbol);
    }

    public Element(String symbol, Integer atomicNumber) {
        this.atomicNumber = atomicNumber;
    }

    @Override
    public Integer getAtomicNumber() {
        return this.atomicNumber;
    }

    @Override
    public void setAtomicNumber(Integer atomicNumber) {
        this.atomicNumber = atomicNumber;
        this.notifyChanged();
    }

    @Override
    public String getSymbol() {
        if (this.atomicNumber == null) {
            return null;
        }
        if (this.atomicNumber == 0) {
            return "R";
        }
        return Elements.ofNumber(this.atomicNumber).symbol();
    }

    @Override
    public void setSymbol(String symbol) {
        this.setSymbolInternal(symbol);
        this.notifyChanged();
    }

    private void setSymbolInternal(String symbol) {
        this.atomicNumber = symbol == null ? null : Integer.valueOf(Elements.ofString(symbol).number());
    }

    @Override
    public String toString() {
        StringBuffer resultString = new StringBuffer(32);
        resultString.append("Element(").append(this.hashCode());
        if (this.getSymbol() != null) {
            resultString.append(", S:").append(this.getSymbol());
        }
        if (this.getID() != null) {
            resultString.append(", ID:").append(this.getID());
        }
        if (this.getAtomicNumber() != null) {
            resultString.append(", AN:").append(this.getAtomicNumber());
        }
        resultString.append(')');
        return resultString.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public boolean compare(Object object) {
        if (!(object instanceof Element)) {
            return false;
        }
        if (!super.compare(object)) {
            return false;
        }
        Element elem = (Element)object;
        return Objects.equal(this.atomicNumber, elem.atomicNumber);
    }
}

