/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.scorecard.Attribute;
import org.dmg.pmml.scorecard.Characteristic;
import org.dmg.pmml.scorecard.Characteristics;
import org.dmg.pmml.scorecard.Scorecard;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.rexp.DecorationUtil;
import org.jpmml.rexp.GLMConverter;
import org.jpmml.rexp.RDoubleVector;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.RNumberVector;

public class ScorecardConverter
extends GLMConverter {
    public ScorecardConverter(RGenericVector glm) {
        super(glm);
    }

    public Scorecard encodeModel(Schema schema) {
        Characteristic characteristic;
        RGenericVector glm = (RGenericVector)this.getObject();
        RDoubleVector coefficients = glm.getDoubleElement("coefficients");
        RGenericVector family = glm.getGenericElement("family");
        RGenericVector scConf = DecorationUtil.getGenericElement(glm, "sc.conf");
        Double intercept = (Double)coefficients.getElement("(Intercept)", false);
        List features = schema.getFeatures();
        SchemaUtil.checkSize((int)(coefficients.size() - (intercept != null ? 1 : 0)), (List)features);
        RNumberVector<?> odds = scConf.getNumericElement("odds");
        RNumberVector<?> basePoints = scConf.getNumericElement("base_points");
        RNumberVector<?> pdo = scConf.getNumericElement("pdo");
        double factor = ((Number)pdo.asScalar()).doubleValue() / Math.log(2.0);
        LinkedHashMap<Object, Characteristic> fieldCharacteristics = new LinkedHashMap<Object, Characteristic>();
        for (Feature feature : features) {
            FieldName name = feature.getName();
            if (!(feature instanceof BinaryFeature)) {
                throw new IllegalArgumentException();
            }
            Double d = this.getFeatureCoefficient(feature, coefficients);
            characteristic = (Characteristic)fieldCharacteristics.get(name);
            if (characteristic == null) {
                characteristic = new Characteristic().setName("score(" + FeatureUtil.getName((Feature)feature) + ")");
                fieldCharacteristics.put(name, characteristic);
            }
            BinaryFeature binaryFeature = (BinaryFeature)feature;
            SimplePredicate simplePredicate = new SimplePredicate(binaryFeature.getName(), SimplePredicate.Operator.EQUAL, binaryFeature.getValue());
            Attribute attribute = new Attribute((Predicate)simplePredicate).setPartialScore(ScorecardConverter.formatScore(-1.0 * d * factor));
            characteristic.addAttributes(new Attribute[]{attribute});
        }
        Characteristics characteristics = new Characteristics();
        Set entries = fieldCharacteristics.entrySet();
        for (Map.Entry entry : entries) {
            characteristic = (Characteristic)entry.getValue();
            Attribute attribute = new Attribute((Predicate)True.INSTANCE).setPartialScore((Number)0.0);
            characteristic.addAttributes(new Attribute[]{attribute});
            characteristics.addCharacteristics(new Characteristic[]{characteristic});
        }
        Scorecard scorecard = new Scorecard(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Label)schema.getLabel()), characteristics).setInitialScore(ScorecardConverter.formatScore(((Number)basePoints.asScalar()).doubleValue() - Math.log(((Number)odds.asScalar()).doubleValue()) * factor - (intercept != null ? intercept * factor : 0.0))).setUseReasonCodes(Boolean.valueOf(false));
        return scorecard;
    }

    private static Number formatScore(Double score) {
        return Math.round(score);
    }
}

