/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.time_series;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.dmg.pmml.time_series.DynamicRegressor;
import org.dmg.pmml.time_series.MaximumLikelihoodStat;
import org.dmg.pmml.time_series.NonseasonalComponent;
import org.dmg.pmml.time_series.OutlierEffect;
import org.dmg.pmml.time_series.SeasonalComponent;
import org.dmg.pmml.time_series.TimeSeriesAlgorithm;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name="ARIMA", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "nonseasonalComponent", "seasonalComponent", "dynamicRegressors", "maximumLikelihoodStat", "outlierEffects"})
@Added(value=Version.PMML_4_0)
@JsonRootName(value="ARIMA")
@JsonPropertyOrder(value={"rmse", "transformation", "constantTerm", "predictionMethod", "extensions", "nonseasonalComponent", "seasonalComponent", "dynamicRegressors", "maximumLikelihoodStat", "outlierEffects"})
public class ARIMA
extends TimeSeriesAlgorithm
implements HasExtensions<ARIMA> {
    @XmlAttribute(name="RMSE")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @Added(value=Version.PMML_4_4)
    @JsonProperty(value="RMSE")
    private Number rmse;
    @XmlAttribute(name="transformation")
    @Added(value=Version.PMML_4_4)
    @JsonProperty(value="transformation")
    private String transformation;
    @XmlAttribute(name="constantTerm")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @Added(value=Version.PMML_4_4)
    @JsonProperty(value="constantTerm")
    private Number constantTerm;
    @XmlAttribute(name="predictionMethod")
    @Added(value=Version.PMML_4_4)
    @JsonProperty(value="predictionMethod")
    private String predictionMethod;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @Added(value=Version.PMML_4_4)
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="NonseasonalComponent", namespace="http://www.dmg.org/PMML-4_4")
    @Added(value=Version.PMML_4_4)
    @JsonProperty(value="NonseasonalComponent")
    private NonseasonalComponent nonseasonalComponent;
    @XmlElement(name="SeasonalComponent", namespace="http://www.dmg.org/PMML-4_4")
    @Added(value=Version.PMML_4_4)
    @JsonProperty(value="SeasonalComponent")
    private SeasonalComponent seasonalComponent;
    @XmlElement(name="DynamicRegressor", namespace="http://www.dmg.org/PMML-4_4")
    @Added(value=Version.PMML_4_4)
    @JsonProperty(value="DynamicRegressor")
    private List<DynamicRegressor> dynamicRegressors;
    @XmlElement(name="MaximumLikelihoodStat", namespace="http://www.dmg.org/PMML-4_4")
    @Added(value=Version.PMML_4_4)
    @JsonProperty(value="MaximumLikelihoodStat")
    private MaximumLikelihoodStat maximumLikelihoodStat;
    @XmlElement(name="OutlierEffect", namespace="http://www.dmg.org/PMML-4_4")
    @Added(value=Version.PMML_4_4)
    @JsonProperty(value="OutlierEffect")
    private List<OutlierEffect> outlierEffects;
    private static final Number DEFAULT_CONSTANT_TERM = new RealNumberAdapter().unmarshal("0");
    private static final long serialVersionUID = 67371266L;

    public Number getRMSE() {
        return this.rmse;
    }

    public ARIMA setRMSE(@Property(value="rmse") Number rmse) {
        this.rmse = rmse;
        return this;
    }

    public String getTransformation() {
        if (this.transformation == null) {
            return "none";
        }
        return this.transformation;
    }

    public ARIMA setTransformation(@Property(value="transformation") String transformation) {
        this.transformation = transformation;
        return this;
    }

    public Number getConstantTerm() {
        if (this.constantTerm == null) {
            return DEFAULT_CONSTANT_TERM;
        }
        return this.constantTerm;
    }

    public ARIMA setConstantTerm(@Property(value="constantTerm") Number constantTerm) {
        this.constantTerm = constantTerm;
        return this;
    }

    public String getPredictionMethod() {
        if (this.predictionMethod == null) {
            return "conditionalLeastSquares";
        }
        return this.predictionMethod;
    }

    public ARIMA setPredictionMethod(@Property(value="predictionMethod") String predictionMethod) {
        this.predictionMethod = predictionMethod;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ARIMA addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public NonseasonalComponent getNonseasonalComponent() {
        return this.nonseasonalComponent;
    }

    public ARIMA setNonseasonalComponent(@Property(value="nonseasonalComponent") NonseasonalComponent nonseasonalComponent) {
        this.nonseasonalComponent = nonseasonalComponent;
        return this;
    }

    public SeasonalComponent getSeasonalComponent() {
        return this.seasonalComponent;
    }

    public ARIMA setSeasonalComponent(@Property(value="seasonalComponent") SeasonalComponent seasonalComponent) {
        this.seasonalComponent = seasonalComponent;
        return this;
    }

    public boolean hasDynamicRegressors() {
        return this.dynamicRegressors != null && this.dynamicRegressors.size() > 0;
    }

    public List<DynamicRegressor> getDynamicRegressors() {
        if (this.dynamicRegressors == null) {
            this.dynamicRegressors = new ArrayList<DynamicRegressor>();
        }
        return this.dynamicRegressors;
    }

    public ARIMA addDynamicRegressors(DynamicRegressor ... dynamicRegressors) {
        this.getDynamicRegressors().addAll(Arrays.asList(dynamicRegressors));
        return this;
    }

    public MaximumLikelihoodStat getMaximumLikelihoodStat() {
        return this.maximumLikelihoodStat;
    }

    public ARIMA setMaximumLikelihoodStat(@Property(value="maximumLikelihoodStat") MaximumLikelihoodStat maximumLikelihoodStat) {
        this.maximumLikelihoodStat = maximumLikelihoodStat;
        return this;
    }

    public boolean hasOutlierEffects() {
        return this.outlierEffects != null && this.outlierEffects.size() > 0;
    }

    public List<OutlierEffect> getOutlierEffects() {
        if (this.outlierEffects == null) {
            this.outlierEffects = new ArrayList<OutlierEffect>();
        }
        return this.outlierEffects;
    }

    public ARIMA addOutlierEffects(OutlierEffect ... outlierEffects) {
        this.getOutlierEffects().addAll(Arrays.asList(outlierEffects));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getNonseasonalComponent(), (Visitable)this.getSeasonalComponent());
            }
            if (status == VisitorAction.CONTINUE && this.hasDynamicRegressors()) {
                status = PMMLObject.traverse(visitor, this.getDynamicRegressors());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getMaximumLikelihoodStat());
            }
            if (status == VisitorAction.CONTINUE && this.hasOutlierEffects()) {
                status = PMMLObject.traverse(visitor, this.getOutlierEffects());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

