/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Window;
import javax.swing.SwingUtilities;

public class AppletUtilities {
    public static final int WAIT_CURSOR = 1;
    public static final int DEFAULT_CURSOR = 2;

    private AppletUtilities() {
    }

    public static Applet getTopApplet(Component component) {
        Applet applet = null;
        for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
            if (component2 == null || !(component2 instanceof Applet)) continue;
            applet = (Applet)component2;
        }
        return applet;
    }

    public static Window getFirstWindowParent(Component component) {
        Object var1_1 = null;
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Window)) continue;
            return (Window)container;
        }
        return SwingUtilities.getWindowAncestor(component);
    }

    public static void setCursor(int n, Component component) {
        if (component != null) {
            if (component instanceof Container) {
                Container container = (Container)component;
                for (int i = 0; i < container.getComponentCount(); ++i) {
                    AppletUtilities.setCursor(n, container.getComponent(i));
                }
                switch (n) {
                    case 1: {
                        component.setCursor(Cursor.getPredefinedCursor(3));
                        break;
                    }
                    case 2: {
                        component.setCursor(Cursor.getPredefinedCursor(0));
                        break;
                    }
                    default: {
                        System.out.println("setCursor, unknown cursor requested : " + n);
                        break;
                    }
                }
            }
        } else {
            System.out.println("setCursor on a null component");
        }
    }

    public static String getUserNameProperty() {
        String string = System.getProperty("user.name");
        return string;
    }

    public static final boolean isSunOS() {
        return "SunOS".equals(System.getProperty("os.name"));
    }

    public static final boolean isMacOS() {
        return System.getProperty("os.name").toLowerCase().indexOf("mac") != -1;
    }

    public static final boolean isMacOS13() {
        return AppletUtilities.isMacOS() && System.getProperty("java.version").indexOf("1.3.1") != -1;
    }
}

