params <-
list(EVAL = TRUE)

## ----setup, include=FALSE-----------------------------------------------------
library(dplyr)
library(modelr)
library(tidyr)
library(ggplot2)
library(tidybayes)
library(multiverse)

## ---- include=FALSE-----------------------------------------------------------
M = multiverse()

## ---- chunk-setup, include=FALSE----------------------------------------------
knitr::opts_chunk$set(
  echo = TRUE,
  eval = if (isTRUE(exists("params"))) params$EVAL else FALSE,
  fig.width = 6, 
  fig.height = 4
)

## -----------------------------------------------------------------------------
data("hurricane")

# read and process data
hurricane_data <- hurricane %>%
    # rename some variables
    rename(
        year = Year,
        name = Name,
        dam = NDAM,
        death = alldeaths,
        female = Gender_MF,
        masfem = MasFem,
        category = Category,
        pressure = Minpressure_Updated_2014,
        wind = HighestWindSpeed
    ) %>%
    # create new variables
    mutate(
        post = ifelse(year>1979, 1, 0),
        zcat = as.numeric(scale(category)),
        zpressure = -scale(pressure),
        zwind = as.numeric(scale(wind)),
        z3 = as.numeric((zpressure + zcat + zwind) / 3)
    )

## -----------------------------------------------------------------------------
df <- hurricane_data %>%
    filter( name != "Katrina" & name != "Audrey" )

fit <- glm(death ~ masfem * dam + masfem * zpressure, data = df, family = "poisson")

## ---- eval = FALSE------------------------------------------------------------
#  M <- multiverse()

## ----default-m-1, inside = M, echo = FALSE, engine="multiverse"---------------
df <- hurricane_data %>%
    filter(TRUE) %>%
    filter(TRUE)

## ----default-m-1, inside = M, echo = FALSE, engine="multiverse"---------------
df <- hurricane_data %>%
    filter(TRUE) %>%
    filter(!(name %in% c("Sandy")))

## ----default-m-1, inside = M, echo = FALSE, engine="multiverse"---------------
df <- hurricane_data %>%
    filter(TRUE) %>%
    filter(!(name %in% c("Sandy", "Andrew")))

## ----default-m-1, inside = M, echo = FALSE, engine="multiverse"---------------
df <- hurricane_data %>%
    filter(TRUE) %>%
    filter(!(name %in% c("Sandy", "Andrew", "Donna")))

## ----default-m-1, inside = M, echo = FALSE, engine="multiverse"---------------
df <- hurricane_data %>%
    filter(name != "Katrina") %>%
    filter(TRUE)

## ----default-m-1, inside = M, echo = FALSE, engine="multiverse"---------------
df <- hurricane_data %>%
    filter(name != "Katrina") %>%
    filter(!(name %in% c("Sandy")))

## ----default-m-1, inside = M, echo = FALSE, engine="multiverse"---------------
df <- hurricane_data %>%
    filter(name != "Katrina") %>%
    filter(!(name %in% c("Sandy", "Andrew")))

## ----default-m-1, inside = M, echo = FALSE, engine="multiverse"---------------
df <- hurricane_data %>%
    filter(name != "Katrina") %>%
    filter(!(name %in% c("Sandy", "Andrew", "Donna")))

## ----default-m-1, inside = M, echo = FALSE, engine="multiverse"---------------
df <- hurricane_data %>%
    filter(!(name %in% c("Katrina", "Audrey"))) %>%
    filter(TRUE)

## ----default-m-1, inside = M, echo = FALSE, engine="multiverse"---------------
df <- hurricane_data %>%
    filter(!(name %in% c("Katrina", "Audrey"))) %>%
    filter(!(name %in% c("Sandy")))

## ----default-m-1, inside = M, echo = FALSE, engine="multiverse"---------------
df <- hurricane_data %>%
    filter(!(name %in% c("Katrina", "Audrey"))) %>%
    filter(!(name %in% c("Sandy", "Andrew")))

## ----default-m-1, inside = M, echo = FALSE, engine="multiverse"---------------
df <- hurricane_data %>%
    filter(!(name %in% c("Katrina", "Audrey"))) %>%
    filter(!(name %in% c("Sandy", "Andrew", "Donna")))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = masfem, damage = identity(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = masfem, damage = log(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = female, damage = identity(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = female, damage = log(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = masfem, damage = identity(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = masfem, damage = log(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = female, damage = identity(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = female, damage = log(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = masfem, damage = identity(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = masfem, damage = log(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = female, damage = identity(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = female, damage = log(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = masfem, damage = identity(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = masfem, damage = log(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = female, damage = identity(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = female, damage = log(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = masfem, damage = identity(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = masfem, damage = log(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = female, damage = identity(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = female, damage = log(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = masfem, damage = identity(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = masfem, damage = log(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = female, damage = identity(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = female, damage = log(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = masfem, damage = identity(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = masfem, damage = log(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = female, damage = identity(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = female, damage = log(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = masfem, damage = identity(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = masfem, damage = log(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = female, damage = identity(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = female, damage = log(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = masfem, damage = identity(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = masfem, damage = log(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = female, damage = identity(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = female, damage = log(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = masfem, damage = identity(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = masfem, damage = log(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = female, damage = identity(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = female, damage = log(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = masfem, damage = identity(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = masfem, damage = log(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = female, damage = identity(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = female, damage = log(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = masfem, damage = identity(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = masfem, damage = log(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = female, damage = identity(dam))

## ----label = default-m-2, inside = M, echo = FALSE, engine="multiverse"-------
df <- df %>%
    mutate(femininity = female, damage = log(dam))

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity + damage + z3 + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + year:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + NULL + post:damage, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + NULL, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zpressure + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zwind + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * zcat + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + NULL, family = "gaussian", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + year:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(log(death + 1) ~ femininity * damage + femininity * z3 + post:damage, 
    family = "gaussian", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + year:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity + damage + z3 + post:damage, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + NULL, family = "poisson", data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + NULL + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zpressure + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zwind + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * zcat + post:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + NULL, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + year:damage, family = "poisson", 
    data = df)

## ----label = default-m-3, inside = M, echo = FALSE, engine="multiverse"-------
fit <- glm(death ~ femininity * damage + femininity * z3 + post:damage, family = "poisson", 
    data = df)

## -----------------------------------------------------------------------------
broom::tidy(fit)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    mu
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(mean_deaths = mean(expected_deaths), .groups = "drop_last") %>%
    compare_levels(mean_deaths, by = female)

## ----label = default-m-4, inside = M, echo = FALSE, engine="multiverse"-------
pred <- predict(fit, se.fit = TRUE, type = "response")
pred2expectation <- function(mu, sigma) {
    exp(mu + sigma^2/2) - 1
}
disagg_fit <- df %>%
    mutate(fitted = pred$fit, se.fit = pred$se.fit, deg_f = df.residual(fit), sigma = sigma(fit), 
        se.residual = sqrt(sum(residuals(fit)^2)/deg_f))
expectation <- disagg_fit %>%
    mutate(expected_deaths = pred2expectation(fitted, sigma)) %>%
    group_by(female) %>%
    summarise(me