/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.generate;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.GraphGenerator;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.graph.SimpleGraph;

public class RandomGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    private static long seedUniquifier = 8682522807148012L;
    protected int numOfVertexes;
    protected int numOfEdges;
    protected Random randomizer;
    private long randomizerSeed;

    public RandomGraphGenerator(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("must be non-negative");
        }
        this.numOfVertexes = n;
        this.numOfEdges = n2;
        this.randomizerSeed = RandomGraphGenerator.chooseRandomSeedOnce();
        this.randomizer = new Random(this.randomizerSeed);
    }

    private static synchronized long chooseRandomSeedOnce() {
        return ++seedUniquifier + System.nanoTime();
    }

    private void resetRandomSeed() {
        this.randomizer.setSeed(this.randomizerSeed);
    }

    @Override
    public void generateGraph(Graph<V, E> graph, VertexFactory<V> vertexFactory, Map<String, V> map) {
        this.resetRandomSeed();
        HashMap<Integer, V> hashMap = new HashMap<Integer, V>(this.numOfVertexes);
        for (int i = 0; i < this.numOfVertexes; ++i) {
            V v = vertexFactory.createVertex();
            graph.addVertex(v);
            hashMap.put(i, v);
        }
        EdgeTopologyFactory<V, E> edgeTopologyFactory = this.edgeTopologyFactoryChooser(graph, this.numOfEdges);
        if (!edgeTopologyFactory.isNumberOfEdgesValid(graph, this.numOfEdges)) {
            throw new IllegalArgumentException("numOfEdges is not valid for the graph type \n-> Invalid number Of Edges=" + this.numOfEdges + " for:" + " graph type=" + graph.getClass() + " ,number Of Vertexes=" + this.numOfVertexes + "\n-> Advice: For the Max value , check the javadoc for" + " org.jgrapht.generate.RandomGraphGenerator.DefaultEdgeTopologyFactory");
        }
        edgeTopologyFactory.createEdges(graph, hashMap, this.numOfEdges, this.randomizer);
    }

    private EdgeTopologyFactory<V, E> edgeTopologyFactoryChooser(Graph<V, E> graph, int n) {
        return new DefaultEdgeTopologyFactory();
    }

    public class DefaultEdgeTopologyFactory<VV, EE>
    implements EdgeTopologyFactory<VV, EE> {
        @Override
        public void createEdges(Graph<VV, EE> graph, Map<Integer, VV> map, int n, Random random) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                VV VV = map.get(random.nextInt(RandomGraphGenerator.this.numOfVertexes));
                VV VV2 = map.get(random.nextInt(RandomGraphGenerator.this.numOfVertexes));
                try {
                    EE EE = graph.addEdge(VV, VV2);
                    if (EE != null) {
                        ++n3;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }

        @Override
        public boolean isNumberOfEdgesValid(Graph<VV, EE> graph, int n) {
            boolean bl = false;
            int n2 = this.getMaxEdgesForVertexNum(graph);
            if (n2 == -1) {
                bl = true;
            }
            boolean bl2 = true == bl ? true : n <= n2;
            return bl2;
        }

        public int getMaxEdgesForVertexNum(Graph<VV, EE> graph) {
            int n = 0;
            n = graph instanceof SimpleGraph ? RandomGraphGenerator.this.numOfVertexes * (RandomGraphGenerator.this.numOfVertexes - 1) / 2 : (graph instanceof SimpleDirectedGraph ? RandomGraphGenerator.this.numOfVertexes * (RandomGraphGenerator.this.numOfVertexes - 1) : (graph instanceof DefaultDirectedGraph ? RandomGraphGenerator.this.numOfVertexes * RandomGraphGenerator.this.numOfVertexes : -1));
            return n;
        }
    }

    public static interface EdgeTopologyFactory<VV, EE> {
        public void createEdges(Graph<VV, EE> var1, Map<Integer, VV> var2, int var3, Random var4);

        public boolean isNumberOfEdgesValid(Graph<VV, EE> var1, int var2);
    }
}

