/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.propagation;

import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateBool;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.propagation.PropagationEngine;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.propagation.event.PropagationEvent;
import java.util.EventListener;

public abstract class Propagator
implements EventListener {
    protected PropagationEngine propagationEngine;
    protected IStateBool active;
    protected final ConstraintEvent constAwakeEvent;
    protected final int priority;

    protected Propagator() {
        this(ConstraintEvent.UNARY);
    }

    protected Propagator(int priority) {
        this.priority = priority;
        this.constAwakeEvent = new ConstraintEvent(this, false, priority);
    }

    public abstract void addListener(boolean var1);

    public abstract boolean isCompletelyInstantiated();

    public final void constAwake(boolean isInitialPropagation) {
        this.propagationEngine.postConstAwake(this, isInitialPropagation);
    }

    public void awake() throws ContradictionException {
        this.propagate();
    }

    public abstract void propagate() throws ContradictionException;

    public final void activate(IEnvironment environment) {
        this.active = environment.makeBool(false);
    }

    public final void setActive() {
        if (!this.isActive()) {
            this.setActiveSilently();
            this.constAwake(true);
        }
    }

    public final void setActiveSilently() {
        this.active.set(true);
    }

    public final void setPassive() {
        if (this.active != null) {
            this.active.set(false);
            this.propagationEngine.desactivatePropagator(this);
        }
    }

    public final boolean isActive() {
        return this.active.get();
    }

    public final void setEntailed() {
        this.setPassive();
    }

    public final int getPriority() {
        return this.priority;
    }

    public final PropagationEvent getEvent() {
        return this.constAwakeEvent;
    }

    public abstract Boolean isEntailed();

    public abstract boolean isConsistent();

    public int getFilteredEventMask(int idx) {
        return 65535;
    }

    public void setPropagationEngine(PropagationEngine propEng) {
        this.propagationEngine = propEng;
    }

    public void fail() throws ContradictionException {
        this.propagationEngine.raiseContradiction(this);
    }
}

