/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.trailing;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IStateIntVector;
import choco.kernel.memory.trailing.EnvironmentTrailing;
import choco.kernel.memory.trailing.StoredInt;
import choco.kernel.memory.trailing.trail.StoredIntVectorTrail;

public final class StoredIntVector
implements IStateIntVector {
    public static final int MIN_CAPACITY = 8;
    private int[] elementData;
    public int[] worldStamps;
    private StoredInt size;
    private final EnvironmentTrailing environment;
    protected final StoredIntVectorTrail myTrail;

    public StoredIntVector(EnvironmentTrailing env, int initialSize, int initialValue) {
        int initialCapacity = 8;
        int w = env.getWorldIndex();
        if (initialCapacity < initialSize) {
            initialCapacity = initialSize;
        }
        this.environment = env;
        this.elementData = new int[initialCapacity];
        this.worldStamps = new int[initialCapacity];
        for (int i = 0; i < initialSize; ++i) {
            this.elementData[i] = initialValue;
            this.worldStamps[i] = w;
        }
        this.size = new StoredInt(env, initialSize);
        this.myTrail = this.environment.getIntVectorTrail();
    }

    public StoredIntVector(EnvironmentTrailing env, int[] entries) {
        int initialCapacity = 8;
        int w = env.getWorldIndex();
        int initialSize = entries.length;
        if (initialCapacity < initialSize) {
            initialCapacity = initialSize;
        }
        this.environment = env;
        this.elementData = new int[initialCapacity];
        this.worldStamps = new int[initialCapacity];
        for (int i = 0; i < initialSize; ++i) {
            this.elementData[i] = entries[i];
            this.worldStamps[i] = w;
        }
        this.size = new StoredInt(env, initialSize);
        this.myTrail = this.environment.getIntVectorTrail();
    }

    public StoredIntVector(EnvironmentTrailing env) {
        this(env, 0, 0);
    }

    private boolean rangeCheck(int index) {
        return index < this.size.get() && index >= 0;
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int[] oldData = this.elementData;
            int[] oldStamps = this.worldStamps;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new int[newCapacity];
            this.worldStamps = new int[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size.get());
            System.arraycopy(oldStamps, 0, this.worldStamps, 0, this.size.get());
        }
    }

    @Override
    public void add(int i) {
        int newsize = this.size.get() + 1;
        this.ensureCapacity(newsize);
        this.size.set(newsize);
        this.elementData[newsize - 1] = i;
        this.worldStamps[newsize - 1] = this.environment.getWorldIndex();
    }

    @Override
    public void remove(int i) {
        System.arraycopy(this.elementData, i, this.elementData, i + 1, this.size.get());
        System.arraycopy(this.worldStamps, i, this.worldStamps, i + 1, this.size.get());
        int newsize = this.size.get() - 1;
        if (newsize >= 0) {
            this.size.set(newsize);
        }
    }

    @Override
    public void removeLast() {
        int newsize = this.size.get() - 1;
        if (newsize >= 0) {
            this.size.set(newsize);
        }
    }

    @Override
    public int get(int index) {
        if (this.rangeCheck(index)) {
            return this.elementData[index];
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size.get());
    }

    @Override
    public final int quickGet(int index) {
        assert (this.rangeCheck(index));
        return this.elementData[index];
    }

    @Override
    public boolean contain(int val) {
        int ssize = this.size.get();
        for (int i = 0; i < ssize; ++i) {
            if (val != this.elementData[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public int set(int index, int val) {
        if (this.rangeCheck(index)) {
            return this.quickSet(index, val);
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size.get());
    }

    @Override
    public final int quickSet(int index, int val) {
        assert (this.rangeCheck(index));
        int oldValue = this.elementData[index];
        if (val != oldValue) {
            int oldStamp = this.worldStamps[index];
            if (oldStamp < this.environment.getWorldIndex()) {
                this.myTrail.savePreviousState(this, index, oldValue, oldStamp);
                this.worldStamps[index] = this.environment.getWorldIndex();
            }
            this.elementData[index] = val;
        }
        return oldValue;
    }

    public int _set(int index, int val, int stamp) {
        assert (this.rangeCheck(index));
        int oldval = this.elementData[index];
        this.elementData[index] = val;
        this.worldStamps[index] = stamp;
        return oldval;
    }

    @Override
    public DisposableIntIterator getIterator() {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

